#
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#
#

$(eval $(call gb_Jar_Jar,OOoRunner))

$(eval $(call gb_Jar_add_manifest_classpath,OOoRunner,\
	libreoffice.jar \
))

$(eval $(call gb_Jar_set_manifest,OOoRunner,$(SRCDIR)/qadevOOo/runner/manifest))

$(eval $(call gb_Jar_use_jars,OOoRunner,\
	libreoffice \
	java_uno \
))

$(eval $(call gb_Jar_set_packageroot,OOoRunner,\
	base \
	complexlib \
	convwatch \
	graphical \
	helper \
	ifc \
	lib \
	mod \
	org \
	share \
	stats \
	util \
))

$(eval $(call gb_Jar_add_sourcefiles,OOoRunner,\
    qadevOOo/runner/base/java_complex \
    qadevOOo/runner/base/java_fat \
    qadevOOo/runner/base/java_fat_service \
    qadevOOo/runner/base/TestBase \
    qadevOOo/runner/complexlib/Assurance \
    qadevOOo/runner/complexlib/ComplexTestCase \
    qadevOOo/runner/complexlib/MethodThread \
    qadevOOo/runner/complexlib/ShowTargets \
    qadevOOo/runner/convwatch/DB \
    qadevOOo/runner/convwatch/DBHelper \
    qadevOOo/runner/convwatch/GlobalLogWriter \
    qadevOOo/runner/graphical/FileHelper \
    qadevOOo/runner/helper/APIDescGetter \
    qadevOOo/runner/helper/AppProvider \
    qadevOOo/runner/helper/CfgParser \
    qadevOOo/runner/helper/ClParser \
    qadevOOo/runner/helper/ComplexDescGetter \
    qadevOOo/runner/helper/ConfigHelper \
    qadevOOo/runner/helper/ConfigurationRead \
    qadevOOo/runner/helper/ContextMenuInterceptor \
    qadevOOo/runner/helper/FileTools \
    qadevOOo/runner/helper/LoggingThread \
    qadevOOo/runner/helper/OfficeProvider \
    qadevOOo/runner/helper/OfficeWatcher \
    qadevOOo/runner/helper/OSHelper \
    qadevOOo/runner/helper/ProcessHandler \
    qadevOOo/runner/helper/PropertyHandlerFactroy \
    qadevOOo/runner/helper/PropertyHandlerImpl \
    qadevOOo/runner/helper/StreamSimulator \
    qadevOOo/runner/helper/StringHelper \
    qadevOOo/runner/helper/UnoProvider \
    qadevOOo/runner/helper/URLHelper \
    qadevOOo/runner/lib/DynamicClassLoader \
    qadevOOo/runner/lib/ExceptionStatus \
    qadevOOo/runner/lib/MultiMethodTest \
    qadevOOo/runner/lib/MultiPropertyTest \
    qadevOOo/runner/lib/RunState \
    qadevOOo/runner/lib/SimpleStatus \
    qadevOOo/runner/lib/Status \
    qadevOOo/runner/lib/StatusException \
    qadevOOo/runner/lib/TestCase \
    qadevOOo/runner/lib/TestEnvironment \
    qadevOOo/runner/lib/TestParameters \
    qadevOOo/runner/lib/TestResult \
    qadevOOo/runner/org/openoffice/Runner \
    qadevOOo/runner/org/openoffice/RunnerService \
    qadevOOo/runner/share/ComplexTest \
    qadevOOo/runner/share/DescEntry \
    qadevOOo/runner/share/DescGetter \
    qadevOOo/runner/share/LogWriter \
    qadevOOo/runner/share/Watcher \
    qadevOOo/runner/stats/InternalLogWriter \
    qadevOOo/runner/stats/OutProducerFactory \
    qadevOOo/runner/stats/SimpleLogWriter \
    qadevOOo/runner/stats/SimpleOutProducer \
    qadevOOo/runner/stats/Summarizer \
    qadevOOo/runner/util/AccessibilityTools \
    qadevOOo/runner/util/BookmarkDsc \
    qadevOOo/runner/util/CalcTools \
    qadevOOo/runner/util/db/DatabaseDocument \
    qadevOOo/runner/util/db/DataSource \
    qadevOOo/runner/util/db/DataSourceDescriptor \
    qadevOOo/runner/util/dbg \
    qadevOOo/runner/util/DBTools \
    qadevOOo/runner/util/DefaultDsc \
    qadevOOo/runner/util/DesktopTools \
    qadevOOo/runner/util/DrawTools \
    qadevOOo/runner/util/DynamicClassLoader \
    qadevOOo/runner/util/FootnoteDsc \
    qadevOOo/runner/util/FormTools \
    qadevOOo/runner/util/FrameDsc \
    qadevOOo/runner/util/InstCreator \
    qadevOOo/runner/util/InstDescr \
    qadevOOo/runner/util/ParagraphDsc \
    qadevOOo/runner/util/PropertyName \
    qadevOOo/runner/util/RegistryTools \
    qadevOOo/runner/util/ShapeDsc \
    qadevOOo/runner/util/SOfficeFactory \
    qadevOOo/runner/util/SysUtils \
    qadevOOo/runner/util/TableDsc \
    qadevOOo/runner/util/TextSectionDsc \
    qadevOOo/runner/util/UITools \
    qadevOOo/runner/util/utils \
    qadevOOo/runner/util/ValueChanger \
    qadevOOo/runner/util/ValueComparer \
    qadevOOo/runner/util/WaitUnreachable \
    qadevOOo/runner/util/WriterTools \
    qadevOOo/runner/util/XInstCreator \
    qadevOOo/runner/util/XLayerHandlerImpl \
    qadevOOo/runner/util/XLayerImpl \
    qadevOOo/runner/util/XMLTools \
    qadevOOo/runner/util/XSchemaHandlerImpl \
    qadevOOo/tests/java/ifc/accessibility/_XAccessible \
    qadevOOo/tests/java/ifc/accessibility/_XAccessibleAction \
    qadevOOo/tests/java/ifc/accessibility/_XAccessibleComponent \
    qadevOOo/tests/java/ifc/accessibility/_XAccessibleContext \
    qadevOOo/tests/java/ifc/accessibility/_XAccessibleEditableText \
    qadevOOo/tests/java/ifc/accessibility/_XAccessibleEventBroadcaster \
    qadevOOo/tests/java/ifc/accessibility/_XAccessibleExtendedComponent \
    qadevOOo/tests/java/ifc/accessibility/_XAccessibleImage \
    qadevOOo/tests/java/ifc/accessibility/_XAccessibleSelection \
    qadevOOo/tests/java/ifc/accessibility/_XAccessibleTable \
    qadevOOo/tests/java/ifc/accessibility/_XAccessibleText \
    qadevOOo/tests/java/ifc/accessibility/_XAccessibleValue \
    qadevOOo/tests/java/ifc/awt/tree/_TreeControlModel \
    qadevOOo/tests/java/ifc/awt/tree/_XMutableTreeDataModel \
    qadevOOo/tests/java/ifc/awt/tree/_XMutableTreeNode \
    qadevOOo/tests/java/ifc/awt/tree/_XTreeControl \
    qadevOOo/tests/java/ifc/awt/tree/_XTreeDataModel \
    qadevOOo/tests/java/ifc/awt/tree/_XTreeNode \
    qadevOOo/tests/java/ifc/awt/_UnoControlButtonModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlCheckBoxModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlComboBoxModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlContainerModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlCurrencyFieldModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlDateFieldModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlDialogElement \
    qadevOOo/tests/java/ifc/awt/_UnoControlDialogModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlEditModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlFileControlModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlFixedLineModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlFixedTextModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlFormattedFieldModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlGroupBoxModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlImageControlModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlListBoxModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlNumericFieldModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlPatternFieldModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlProgressBarModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlRadioButtonModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlScrollBarModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlSpinButtonModel \
    qadevOOo/tests/java/ifc/awt/_UnoControlTimeFieldModel \
    qadevOOo/tests/java/ifc/awt/_XButton \
    qadevOOo/tests/java/ifc/awt/_XCheckBox \
    qadevOOo/tests/java/ifc/awt/_XComboBox \
    qadevOOo/tests/java/ifc/awt/_XControl \
    qadevOOo/tests/java/ifc/awt/_XControlContainer \
    qadevOOo/tests/java/ifc/awt/_XCurrencyField \
    qadevOOo/tests/java/ifc/awt/_XDataTransferProviderAccess \
    qadevOOo/tests/java/ifc/awt/_XDateField \
    qadevOOo/tests/java/ifc/awt/_XDialog \
    qadevOOo/tests/java/ifc/awt/_XFixedText \
    qadevOOo/tests/java/ifc/awt/_XImageConsumer \
    qadevOOo/tests/java/ifc/awt/_XImageProducer \
    qadevOOo/tests/java/ifc/awt/_XItemListener \
    qadevOOo/tests/java/ifc/awt/_XLayoutConstrains \
    qadevOOo/tests/java/ifc/awt/_XListBox \
    qadevOOo/tests/java/ifc/awt/_XMessageBoxFactory \
    qadevOOo/tests/java/ifc/awt/_XNumericField \
    qadevOOo/tests/java/ifc/awt/_XPatternField \
    qadevOOo/tests/java/ifc/awt/_XRadioButton \
    qadevOOo/tests/java/ifc/awt/_XScrollBar \
    qadevOOo/tests/java/ifc/awt/_XSpinField \
    qadevOOo/tests/java/ifc/awt/_XSpinValue \
    qadevOOo/tests/java/ifc/awt/_XSystemChildFactory \
    qadevOOo/tests/java/ifc/awt/_XTabController \
    qadevOOo/tests/java/ifc/awt/_XTabControllerModel \
    qadevOOo/tests/java/ifc/awt/_XTextComponent \
    qadevOOo/tests/java/ifc/awt/_XTextLayoutConstrains \
    qadevOOo/tests/java/ifc/awt/_XTextListener \
    qadevOOo/tests/java/ifc/awt/_XTimeField \
    qadevOOo/tests/java/ifc/awt/_XToolkit \
    qadevOOo/tests/java/ifc/awt/_XTopWindow \
    qadevOOo/tests/java/ifc/awt/_XUnoControlContainer \
    qadevOOo/tests/java/ifc/awt/_XView \
    qadevOOo/tests/java/ifc/awt/_XWindow \
    qadevOOo/tests/java/ifc/beans/_XExactName \
    qadevOOo/tests/java/ifc/beans/_XFastPropertySet \
    qadevOOo/tests/java/ifc/beans/_XHierarchicalPropertySet \
    qadevOOo/tests/java/ifc/beans/_XIntrospection \
    qadevOOo/tests/java/ifc/beans/_XMultiHierarchicalPropertySet \
    qadevOOo/tests/java/ifc/beans/_XMultiPropertySet \
    qadevOOo/tests/java/ifc/beans/_XMultiPropertyStates \
    qadevOOo/tests/java/ifc/beans/_XProperty \
    qadevOOo/tests/java/ifc/beans/_XPropertyAccess \
    qadevOOo/tests/java/ifc/beans/_XPropertyContainer \
    qadevOOo/tests/java/ifc/beans/_XPropertySet \
    qadevOOo/tests/java/ifc/beans/_XPropertySetInfo \
    qadevOOo/tests/java/ifc/beans/_XPropertyState \
    qadevOOo/tests/java/ifc/beans/_XPropertyWithState \
    qadevOOo/tests/java/ifc/beans/_XTolerantMultiPropertySet \
    qadevOOo/tests/java/ifc/bridge/_XBridge \
    qadevOOo/tests/java/ifc/bridge/_XBridgeFactory \
    qadevOOo/tests/java/ifc/bridge/_XUnoUrlResolver \
    qadevOOo/tests/java/ifc/chart/_BarDiagram \
    qadevOOo/tests/java/ifc/chart/_Chart3DBarProperties \
    qadevOOo/tests/java/ifc/chart/_ChartAxis \
    qadevOOo/tests/java/ifc/chart/_ChartAxisXSupplier \
    qadevOOo/tests/java/ifc/chart/_ChartAxisYSupplier \
    qadevOOo/tests/java/ifc/chart/_ChartAxisZSupplier \
    qadevOOo/tests/java/ifc/chart/_ChartDataPointProperties \
    qadevOOo/tests/java/ifc/chart/_ChartDataRowProperties \
    qadevOOo/tests/java/ifc/chart/_ChartDocument \
    qadevOOo/tests/java/ifc/chart/_ChartLegend \
    qadevOOo/tests/java/ifc/chart/_ChartStatistics \
    qadevOOo/tests/java/ifc/chart/_ChartTableAddressSupplier \
    qadevOOo/tests/java/ifc/chart/_ChartTitle \
    qadevOOo/tests/java/ifc/chart/_ChartTwoAxisXSupplier \
    qadevOOo/tests/java/ifc/chart/_ChartTwoAxisYSupplier \
    qadevOOo/tests/java/ifc/chart/_Diagram \
    qadevOOo/tests/java/ifc/chart/_Dim3DDiagram \
    qadevOOo/tests/java/ifc/chart/_LineDiagram \
    qadevOOo/tests/java/ifc/chart/_StackableDiagram \
    qadevOOo/tests/java/ifc/chart/_StockDiagram \
    qadevOOo/tests/java/ifc/chart/_X3DDisplay \
    qadevOOo/tests/java/ifc/chart/_XAxisXSupplier \
    qadevOOo/tests/java/ifc/chart/_XAxisYSupplier \
    qadevOOo/tests/java/ifc/chart/_XAxisZSupplier \
    qadevOOo/tests/java/ifc/chart/_XChartData \
    qadevOOo/tests/java/ifc/chart/_XChartDataArray \
    qadevOOo/tests/java/ifc/chart/_XChartDocument \
    qadevOOo/tests/java/ifc/chart/_XDiagram \
    qadevOOo/tests/java/ifc/chart/_XStatisticDisplay \
    qadevOOo/tests/java/ifc/chart/_XTwoAxisXSupplier \
    qadevOOo/tests/java/ifc/chart/_XTwoAxisYSupplier \
    qadevOOo/tests/java/ifc/configuration/backend/_XBackend \
    qadevOOo/tests/java/ifc/configuration/backend/_XBackendEntities \
    qadevOOo/tests/java/ifc/configuration/backend/_XLayer \
    qadevOOo/tests/java/ifc/configuration/backend/_XLayerHandler \
    qadevOOo/tests/java/ifc/configuration/backend/_XLayerImporter \
    qadevOOo/tests/java/ifc/configuration/backend/_XMultiLayerStratum \
    qadevOOo/tests/java/ifc/configuration/backend/_XSchema \
    qadevOOo/tests/java/ifc/configuration/backend/_XSchemaSupplier \
    qadevOOo/tests/java/ifc/configuration/backend/_XSingleLayerStratum \
    qadevOOo/tests/java/ifc/configuration/backend/_XUpdateHandler \
    qadevOOo/tests/java/ifc/configuration/_XTemplateContainer \
    qadevOOo/tests/java/ifc/configuration/_XTemplateInstance \
    qadevOOo/tests/java/ifc/connection/_XAcceptor \
    qadevOOo/tests/java/ifc/connection/_XConnector \
    qadevOOo/tests/java/ifc/container/_XChild \
    qadevOOo/tests/java/ifc/container/_XContainer \
    qadevOOo/tests/java/ifc/container/_XContainerQuery \
    qadevOOo/tests/java/ifc/container/_XContentEnumerationAccess \
    qadevOOo/tests/java/ifc/container/_XElementAccess \
    qadevOOo/tests/java/ifc/container/_XEnumeration \
    qadevOOo/tests/java/ifc/container/_XEnumerationAccess \
    qadevOOo/tests/java/ifc/container/_XHierarchicalName \
    qadevOOo/tests/java/ifc/container/_XHierarchicalNameAccess \
    qadevOOo/tests/java/ifc/container/_XIndexAccess \
    qadevOOo/tests/java/ifc/container/_XIndexContainer \
    qadevOOo/tests/java/ifc/container/_XIndexReplace \
    qadevOOo/tests/java/ifc/container/_XNameAccess \
    qadevOOo/tests/java/ifc/container/_XNameContainer \
    qadevOOo/tests/java/ifc/container/_XNamed \
    qadevOOo/tests/java/ifc/container/_XNameReplace \
    qadevOOo/tests/java/ifc/container/_XSet \
    qadevOOo/tests/java/ifc/datatransfer/clipboard/_XClipboard \
    qadevOOo/tests/java/ifc/datatransfer/clipboard/_XClipboardEx \
    qadevOOo/tests/java/ifc/datatransfer/clipboard/_XClipboardNotifier \
    qadevOOo/tests/java/ifc/datatransfer/clipboard/_XFlushableClipboard \
    qadevOOo/tests/java/ifc/datatransfer/_XDataFormatTranslator \
    qadevOOo/tests/java/ifc/datatransfer/_XMimeContentTypeFactory \
    qadevOOo/tests/java/ifc/document/_ExportFilter \
    qadevOOo/tests/java/ifc/document/_ImportFilter \
    qadevOOo/tests/java/ifc/document/_LinkTarget \
    qadevOOo/tests/java/ifc/document/_OfficeDocument \
    qadevOOo/tests/java/ifc/document/_Settings \
    qadevOOo/tests/java/ifc/document/_XActionLockable \
    qadevOOo/tests/java/ifc/document/_XDocumentInsertable \
    qadevOOo/tests/java/ifc/document/_XEmbeddedObjectSupplier \
    qadevOOo/tests/java/ifc/document/_XEventBroadcaster \
    qadevOOo/tests/java/ifc/document/_XEventsSupplier \
    qadevOOo/tests/java/ifc/document/_XExporter \
    qadevOOo/tests/java/ifc/document/_XFilter \
    qadevOOo/tests/java/ifc/document/_XImporter \
    qadevOOo/tests/java/ifc/document/_XLinkTargetSupplier \
    qadevOOo/tests/java/ifc/document/_XMimeTypeInfo \
    qadevOOo/tests/java/ifc/document/_XTypeDetection \
    qadevOOo/tests/java/ifc/document/_XViewDataSupplier \
    qadevOOo/tests/java/ifc/drawing/_AreaShapeDescriptor \
    qadevOOo/tests/java/ifc/drawing/_ConnectorProperties \
    qadevOOo/tests/java/ifc/drawing/_ConnectorShape \
    qadevOOo/tests/java/ifc/drawing/_ConnectorShapeDescriptor \
    qadevOOo/tests/java/ifc/drawing/_DimensioningShapeDescriptor \
    qadevOOo/tests/java/ifc/drawing/_DrawingDocument \
    qadevOOo/tests/java/ifc/drawing/_DrawingDocumentDrawView \
    qadevOOo/tests/java/ifc/drawing/_EllipseShape \
    qadevOOo/tests/java/ifc/drawing/_EllipseShapeDescriptor \
    qadevOOo/tests/java/ifc/drawing/_FillProperties \
    qadevOOo/tests/java/ifc/drawing/_GenericDrawingDocument \
    qadevOOo/tests/java/ifc/drawing/_GenericDrawPage \
    qadevOOo/tests/java/ifc/drawing/_GraphicObjectShape \
    qadevOOo/tests/java/ifc/drawing/_GraphicObjectShapeDescriptor \
    qadevOOo/tests/java/ifc/drawing/_Layer \
    qadevOOo/tests/java/ifc/drawing/_LineProperties \
    qadevOOo/tests/java/ifc/drawing/_LineShapeDescriptor \
    qadevOOo/tests/java/ifc/drawing/_MeasureProperties \
    qadevOOo/tests/java/ifc/drawing/_MeasureShape \
    qadevOOo/tests/java/ifc/drawing/_PolyPolygonBezierDescriptor \
    qadevOOo/tests/java/ifc/drawing/_PolyPolygonDescriptor \
    qadevOOo/tests/java/ifc/drawing/_RotationDescriptor \
    qadevOOo/tests/java/ifc/drawing/_ShadowDescriptor \
    qadevOOo/tests/java/ifc/drawing/_ShadowProperties \
    qadevOOo/tests/java/ifc/drawing/_Shape \
    qadevOOo/tests/java/ifc/drawing/_ShapeDescriptor \
    qadevOOo/tests/java/ifc/drawing/_Text \
    qadevOOo/tests/java/ifc/drawing/_TextProperties \
    qadevOOo/tests/java/ifc/drawing/_TextShape \
    qadevOOo/tests/java/ifc/drawing/_TextShapeDescriptor \
    qadevOOo/tests/java/ifc/drawing/_XConnectorShape \
    qadevOOo/tests/java/ifc/drawing/_XControlShape \
    qadevOOo/tests/java/ifc/drawing/_XDrawPageDuplicator \
    qadevOOo/tests/java/ifc/drawing/_XDrawPages \
    qadevOOo/tests/java/ifc/drawing/_XDrawPagesSupplier \
    qadevOOo/tests/java/ifc/drawing/_XDrawPageSupplier \
    qadevOOo/tests/java/ifc/drawing/_XDrawView \
    qadevOOo/tests/java/ifc/drawing/_XGluePointsSupplier \
    qadevOOo/tests/java/ifc/drawing/_XLayerManager \
    qadevOOo/tests/java/ifc/drawing/_XLayerSupplier \
    qadevOOo/tests/java/ifc/drawing/_XMasterPagesSupplier \
    qadevOOo/tests/java/ifc/drawing/_XMasterPageTarget \
    qadevOOo/tests/java/ifc/drawing/_XShape \
    qadevOOo/tests/java/ifc/drawing/_XShapeBinder \
    qadevOOo/tests/java/ifc/drawing/_XShapeCombiner \
    qadevOOo/tests/java/ifc/drawing/_XShapeDescriptor \
    qadevOOo/tests/java/ifc/drawing/_XShapeGroup \
    qadevOOo/tests/java/ifc/drawing/_XShapeGrouper \
    qadevOOo/tests/java/ifc/drawing/_XShapes \
    qadevOOo/tests/java/ifc/form/binding/_BindableDatabaseCheckBox \
    qadevOOo/tests/java/ifc/form/binding/_BindableDatabaseRadioButton \
    qadevOOo/tests/java/ifc/form/binding/_XBindableValue \
    qadevOOo/tests/java/ifc/form/component/_CheckBox \
    qadevOOo/tests/java/ifc/form/component/_ComboBox \
    qadevOOo/tests/java/ifc/form/component/_CommandButton \
    qadevOOo/tests/java/ifc/form/component/_CurrencyField \
    qadevOOo/tests/java/ifc/form/component/_DatabaseComboBox \
    qadevOOo/tests/java/ifc/form/component/_DatabaseForm \
    qadevOOo/tests/java/ifc/form/component/_DatabaseFormattedField \
    qadevOOo/tests/java/ifc/form/component/_DatabaseImageControl \
    qadevOOo/tests/java/ifc/form/component/_DatabaseListBox \
    qadevOOo/tests/java/ifc/form/component/_DatabasePatternField \
    qadevOOo/tests/java/ifc/form/component/_DatabaseTextField \
    qadevOOo/tests/java/ifc/form/component/_DataForm \
    qadevOOo/tests/java/ifc/form/component/_DateField \
    qadevOOo/tests/java/ifc/form/component/_FileControl \
    qadevOOo/tests/java/ifc/form/component/_FormattedField \
    qadevOOo/tests/java/ifc/form/component/_GridControl \
    qadevOOo/tests/java/ifc/form/component/_HiddenControl \
    qadevOOo/tests/java/ifc/form/component/_HTMLForm \
    qadevOOo/tests/java/ifc/form/component/_ImageButton \
    qadevOOo/tests/java/ifc/form/component/_ListBox \
    qadevOOo/tests/java/ifc/form/component/_NavigationToolBar \
    qadevOOo/tests/java/ifc/form/component/_NumericField \
    qadevOOo/tests/java/ifc/form/component/_PatternField \
    qadevOOo/tests/java/ifc/form/component/_RadioButton \
    qadevOOo/tests/java/ifc/form/component/_RichTextControl \
    qadevOOo/tests/java/ifc/form/component/_ScrollBar \
    qadevOOo/tests/java/ifc/form/component/_SpinButton \
    qadevOOo/tests/java/ifc/form/component/_TextField \
    qadevOOo/tests/java/ifc/form/component/_TimeField \
    qadevOOo/tests/java/ifc/form/_DataAwareControlModel \
    qadevOOo/tests/java/ifc/form/_FormComponent \
    qadevOOo/tests/java/ifc/form/_FormControlModel \
    qadevOOo/tests/java/ifc/form/submission/_XSubmission \
    qadevOOo/tests/java/ifc/form/submission/_XSubmissionSupplier \
    qadevOOo/tests/java/ifc/formula/_FormulaProperties \
    qadevOOo/tests/java/ifc/form/validation/_XValidatable \
    qadevOOo/tests/java/ifc/form/validation/_XValidatableFormComponent \
    qadevOOo/tests/java/ifc/form/validation/_XValidityConstraintListener \
    qadevOOo/tests/java/ifc/form/_XApproveActionBroadcaster \
    qadevOOo/tests/java/ifc/form/_XBoundComponent \
    qadevOOo/tests/java/ifc/form/_XBoundControl \
    qadevOOo/tests/java/ifc/form/_XChangeBroadcaster \
    qadevOOo/tests/java/ifc/form/_XConfirmDeleteBroadcaster \
    qadevOOo/tests/java/ifc/form/_XDatabaseParameterBroadcaster \
    qadevOOo/tests/java/ifc/form/_XFormController \
    qadevOOo/tests/java/ifc/form/_XFormsSupplier \
    qadevOOo/tests/java/ifc/form/_XGrid \
    qadevOOo/tests/java/ifc/form/_XGridColumnFactory \
    qadevOOo/tests/java/ifc/form/_XGridFieldDataSupplier \
    qadevOOo/tests/java/ifc/form/_XImageProducerSupplier \
    qadevOOo/tests/java/ifc/form/_XLoadable \
    qadevOOo/tests/java/ifc/form/_XLoadListener \
    qadevOOo/tests/java/ifc/form/_XReset \
    qadevOOo/tests/java/ifc/form/_XSubmit \
    qadevOOo/tests/java/ifc/form/_XUpdateBroadcaster \
    qadevOOo/tests/java/ifc/frame/_Desktop \
    qadevOOo/tests/java/ifc/frame/_Frame \
    qadevOOo/tests/java/ifc/frame/_FrameLoader \
    qadevOOo/tests/java/ifc/frame/_SynchronousFrameLoader \
    qadevOOo/tests/java/ifc/frame/_XComponentLoader \
    qadevOOo/tests/java/ifc/frame/_XController \
    qadevOOo/tests/java/ifc/frame/_XDesktop \
    qadevOOo/tests/java/ifc/frame/_XDispatch \
    qadevOOo/tests/java/ifc/frame/_XDispatchProvider \
    qadevOOo/tests/java/ifc/frame/_XDispatchProviderInterception \
    qadevOOo/tests/java/ifc/frame/_XDispatchRecorder \
    qadevOOo/tests/java/ifc/frame/_XDispatchRecorderSupplier \
    qadevOOo/tests/java/ifc/frame/_XDocumentTemplates \
    qadevOOo/tests/java/ifc/frame/_XFrame \
    qadevOOo/tests/java/ifc/frame/_XFrameActionListener \
    qadevOOo/tests/java/ifc/frame/_XFrameLoader \
    qadevOOo/tests/java/ifc/frame/_XFramesSupplier \
    qadevOOo/tests/java/ifc/frame/_XLayoutManager \
    qadevOOo/tests/java/ifc/frame/_XModel \
    qadevOOo/tests/java/ifc/frame/_XModuleManager \
    qadevOOo/tests/java/ifc/frame/_XNotifyingDispatch \
    qadevOOo/tests/java/ifc/frame/_XPopupMenuController \
    qadevOOo/tests/java/ifc/frame/_XStatusListener \
    qadevOOo/tests/java/ifc/frame/_XStorable \
    qadevOOo/tests/java/ifc/frame/_XSynchronousFrameLoader \
    qadevOOo/tests/java/ifc/frame/_XTasksSupplier \
    qadevOOo/tests/java/ifc/frame/_XUIControllerRegistration \
    qadevOOo/tests/java/ifc/i18n/_XBreakIterator \
    qadevOOo/tests/java/ifc/i18n/_XCalendar \
    qadevOOo/tests/java/ifc/i18n/_XCharacterClassification \
    qadevOOo/tests/java/ifc/i18n/_XCollator \
    qadevOOo/tests/java/ifc/i18n/_XExtendedCalendar \
    qadevOOo/tests/java/ifc/i18n/_XExtendedIndexEntrySupplier \
    qadevOOo/tests/java/ifc/i18n/_XExtendedTransliteration \
    qadevOOo/tests/java/ifc/i18n/_XIndexEntrySupplier \
    qadevOOo/tests/java/ifc/i18n/_XLocaleData \
    qadevOOo/tests/java/ifc/i18n/_XNumberFormatCode \
    qadevOOo/tests/java/ifc/i18n/_XTransliteration \
    qadevOOo/tests/java/ifc/inspection/_XObjectInspector \
    qadevOOo/tests/java/ifc/inspection/_XObjectInspectorModel \
    qadevOOo/tests/java/ifc/io/_XActiveDataControl \
    qadevOOo/tests/java/ifc/io/_XActiveDataSink \
    qadevOOo/tests/java/ifc/io/_XActiveDataSource \
    qadevOOo/tests/java/ifc/io/_XConnectable \
    qadevOOo/tests/java/ifc/io/_XDataInputStream \
    qadevOOo/tests/java/ifc/io/_XDataOutputStream \
    qadevOOo/tests/java/ifc/io/_XInputStream \
    qadevOOo/tests/java/ifc/io/_XMarkableStream \
    qadevOOo/tests/java/ifc/io/_XObjectInputStream \
    qadevOOo/tests/java/ifc/io/_XObjectOutputStream \
    qadevOOo/tests/java/ifc/io/_XOutputStream \
    qadevOOo/tests/java/ifc/io/_XPersistObject \
    qadevOOo/tests/java/ifc/java/_XJavaThreadRegister_11 \
    qadevOOo/tests/java/ifc/java/_XJavaVM \
    qadevOOo/tests/java/ifc/lang/_ServiceManager \
    qadevOOo/tests/java/ifc/lang/_XComponent \
    qadevOOo/tests/java/ifc/lang/_XEventListener \
    qadevOOo/tests/java/ifc/lang/_XInitialization \
    qadevOOo/tests/java/ifc/lang/_XLocalizable \
    qadevOOo/tests/java/ifc/lang/_XMain \
    qadevOOo/tests/java/ifc/lang/_XMultiComponentFactory \
    qadevOOo/tests/java/ifc/lang/_XMultiServiceFactory \
    qadevOOo/tests/java/ifc/lang/_XServiceDisplayName \
    qadevOOo/tests/java/ifc/lang/_XServiceInfo \
    qadevOOo/tests/java/ifc/lang/_XSingleServiceFactory \
    qadevOOo/tests/java/ifc/lang/_XTypeProvider \
    qadevOOo/tests/java/ifc/linguistic2/_LinguProperties \
    qadevOOo/tests/java/ifc/linguistic2/_XAvailableLocales \
    qadevOOo/tests/java/ifc/linguistic2/_XDictionaryList \
    qadevOOo/tests/java/ifc/linguistic2/_XHyphenator \
    qadevOOo/tests/java/ifc/linguistic2/_XLinguServiceEventBroadcaster \
    qadevOOo/tests/java/ifc/linguistic2/_XLinguServiceManager \
    qadevOOo/tests/java/ifc/linguistic2/_XSearchableDictionaryList \
    qadevOOo/tests/java/ifc/linguistic2/_XSpellChecker \
    qadevOOo/tests/java/ifc/linguistic2/_XSupportedLocales \
    qadevOOo/tests/java/ifc/linguistic2/_XThesaurus \
    qadevOOo/tests/java/ifc/loader/_XImplementationLoader \
    qadevOOo/tests/java/ifc/presentation/_OutlineView \
    qadevOOo/tests/java/ifc/presentation/_Presentation \
    qadevOOo/tests/java/ifc/presentation/_PresentationView \
    qadevOOo/tests/java/ifc/presentation/_PreviewView \
    qadevOOo/tests/java/ifc/presentation/_SlidesView \
    qadevOOo/tests/java/ifc/presentation/_XCustomPresentationSupplier \
    qadevOOo/tests/java/ifc/presentation/_XPresentation \
    qadevOOo/tests/java/ifc/presentation/_XPresentationSupplier \
    qadevOOo/tests/java/ifc/reflection/_XIdlReflection \
    qadevOOo/tests/java/ifc/reflection/_XProxyFactory \
    qadevOOo/tests/java/ifc/reflection/_XTypeDescriptionEnumerationAccess \
    qadevOOo/tests/java/ifc/registry/_XImplementationRegistration \
    qadevOOo/tests/java/ifc/registry/_XSimpleRegistry \
    qadevOOo/tests/java/ifc/script/_XEventAttacherManager \
    qadevOOo/tests/java/ifc/script/_XInvocationAdapterFactory \
    qadevOOo/tests/java/ifc/script/_XInvocationAdapterFactory2 \
    qadevOOo/tests/java/ifc/script/_XTypeConverter \
    qadevOOo/tests/java/ifc/sdbc/_ResultSet \
    qadevOOo/tests/java/ifc/sdbc/_RowSet \
    qadevOOo/tests/java/ifc/sdbc/_XCloseable \
    qadevOOo/tests/java/ifc/sdbc/_XColumnLocate \
    qadevOOo/tests/java/ifc/sdbc/_XDataSource \
    qadevOOo/tests/java/ifc/sdbc/_XDriver \
    qadevOOo/tests/java/ifc/sdbc/_XDriverManager \
    qadevOOo/tests/java/ifc/sdbc/_XIsolatedConnection \
    qadevOOo/tests/java/ifc/sdbc/_XParameters \
    qadevOOo/tests/java/ifc/sdbcx/_ResultSet \
    qadevOOo/tests/java/ifc/sdbc/_XResultSet \
    qadevOOo/tests/java/ifc/sdbc/_XResultSetMetaDataSupplier \
    qadevOOo/tests/java/ifc/sdbc/_XResultSetUpdate \
    qadevOOo/tests/java/ifc/sdbc/_XRow \
    qadevOOo/tests/java/ifc/sdbc/_XRowSet \
    qadevOOo/tests/java/ifc/sdbc/_XRowUpdate \
    qadevOOo/tests/java/ifc/sdbc/_XWarningsSupplier \
    qadevOOo/tests/java/ifc/sdbcx/_XColumnsSupplier \
    qadevOOo/tests/java/ifc/sdbcx/_XCreateCatalog \
    qadevOOo/tests/java/ifc/sdbcx/_XDataDefinitionSupplier \
    qadevOOo/tests/java/ifc/sdbcx/_XDeleteRows \
    qadevOOo/tests/java/ifc/sdbcx/_XDropCatalog \
    qadevOOo/tests/java/ifc/sdbcx/_XRowLocate \
    qadevOOo/tests/java/ifc/sdbcx/_XTablesSupplier \
    qadevOOo/tests/java/ifc/sdb/_DataAccessDescriptor \
    qadevOOo/tests/java/ifc/sdb/_DataSource \
    qadevOOo/tests/java/ifc/sdb/_DatasourceAdministrationDialog \
    qadevOOo/tests/java/ifc/sdb/_ErrorMessageDialog \
    qadevOOo/tests/java/ifc/sdb/_QueryDefinition \
    qadevOOo/tests/java/ifc/sdb/_RowSet \
    qadevOOo/tests/java/ifc/sdb/_SingleSelectQueryComposer \
    qadevOOo/tests/java/ifc/sdb/_XBookmarksSupplier \
    qadevOOo/tests/java/ifc/sdb/_XCompletedConnection \
    qadevOOo/tests/java/ifc/sdb/_XCompletedExecution \
    qadevOOo/tests/java/ifc/sdb/_XFormDocumentsSupplier \
    qadevOOo/tests/java/ifc/sdb/_XParametersSupplier \
    qadevOOo/tests/java/ifc/sdb/_XQueryDefinitionsSupplier \
    qadevOOo/tests/java/ifc/sdb/_XReportDocumentsSupplier \
    qadevOOo/tests/java/ifc/sdb/_XResultSetAccess \
    qadevOOo/tests/java/ifc/sdb/_XRowSetApproveBroadcaster \
    qadevOOo/tests/java/ifc/sdb/_XSingleSelectQueryAnalyzer \
    qadevOOo/tests/java/ifc/sdb/_XSingleSelectQueryComposer \
    qadevOOo/tests/java/ifc/sdb/_XSQLErrorBroadcaster \
    qadevOOo/tests/java/ifc/sheet/_SpreadsheetDocument \
    qadevOOo/tests/java/ifc/sheet/_TableAutoFormatField \
    qadevOOo/tests/java/ifc/sheet/_XCellRangeData \
    qadevOOo/tests/java/ifc/sheet/_XCellRangesQuery \
    qadevOOo/tests/java/ifc/sheet/_XEnhancedMouseClickBroadcaster \
    qadevOOo/tests/java/ifc/sheet/_XRangeSelection \
    qadevOOo/tests/java/ifc/style/_CharacterProperties \
    qadevOOo/tests/java/ifc/style/_CharacterPropertiesAsian \
    qadevOOo/tests/java/ifc/style/_CharacterPropertiesComplex \
    qadevOOo/tests/java/ifc/style/_CharacterStyle \
    qadevOOo/tests/java/ifc/style/_PageProperties \
    qadevOOo/tests/java/ifc/style/_PageStyle \
    qadevOOo/tests/java/ifc/style/_ParagraphProperties \
    qadevOOo/tests/java/ifc/style/_ParagraphPropertiesAsian \
    qadevOOo/tests/java/ifc/style/_ParagraphPropertiesComplex \
    qadevOOo/tests/java/ifc/style/_ParagraphStyle \
    qadevOOo/tests/java/ifc/style/_Style \
    qadevOOo/tests/java/ifc/style/_XStyle \
    qadevOOo/tests/java/ifc/style/_XStyleFamiliesSupplier \
    qadevOOo/tests/java/ifc/system/_XSimpleMailClientSupplier \
    qadevOOo/tests/java/ifc/system/_XSystemShellExecute \
    qadevOOo/tests/java/ifc/table/_CellProperties \
    qadevOOo/tests/java/ifc/table/_XAutoFormattable \
    qadevOOo/tests/java/ifc/table/_XCellRange \
    qadevOOo/tests/java/ifc/table/_XTableChart \
    qadevOOo/tests/java/ifc/table/_XTableColumns \
    qadevOOo/tests/java/ifc/table/_XTableRows \
    qadevOOo/tests/java/ifc/task/_XInteractionHandler \
    qadevOOo/tests/java/ifc/task/_XJob \
    qadevOOo/tests/java/ifc/task/_XJobExecutor \
    qadevOOo/tests/java/ifc/task/_XStatusIndicatorFactory \
    qadevOOo/tests/java/ifc/text/_BaseFrame \
    qadevOOo/tests/java/ifc/text/_BaseFrameProperties \
    qadevOOo/tests/java/ifc/text/_BaseIndex \
    qadevOOo/tests/java/ifc/text/_CellProperties \
    qadevOOo/tests/java/ifc/text/_CellRange \
    qadevOOo/tests/java/ifc/text/_Defaults \
    qadevOOo/tests/java/ifc/text/_DocumentIndex \
    qadevOOo/tests/java/ifc/text/_DocumentSettings \
    qadevOOo/tests/java/ifc/text/_FootnoteSettings \
    qadevOOo/tests/java/ifc/text/_GenericTextDocument \
    qadevOOo/tests/java/ifc/text/_LineNumberingProperties \
    qadevOOo/tests/java/ifc/text/_MailMerge \
    qadevOOo/tests/java/ifc/text/_NumberingLevel \
    qadevOOo/tests/java/ifc/text/_NumberingRules \
    qadevOOo/tests/java/ifc/text/_PrintSettings \
    qadevOOo/tests/java/ifc/text/_Text \
    qadevOOo/tests/java/ifc/text/_TextColumns \
    qadevOOo/tests/java/ifc/text/_TextContent \
    qadevOOo/tests/java/ifc/text/_TextDocument \
    qadevOOo/tests/java/ifc/text/_TextEmbeddedObject \
    qadevOOo/tests/java/ifc/text/_TextFieldMaster \
    qadevOOo/tests/java/ifc/text/_TextFrame \
    qadevOOo/tests/java/ifc/text/_TextGraphicObject \
    qadevOOo/tests/java/ifc/text/_TextPortion \
    qadevOOo/tests/java/ifc/text/_TextSection \
    qadevOOo/tests/java/ifc/text/_TextTable \
    qadevOOo/tests/java/ifc/text/_TextTableRow \
    qadevOOo/tests/java/ifc/text/_ViewSettings \
    qadevOOo/tests/java/ifc/text/_XAutoTextEntry \
    qadevOOo/tests/java/ifc/text/_XAutoTextGroup \
    qadevOOo/tests/java/ifc/text/_XBookmarksSupplier \
    qadevOOo/tests/java/ifc/text/_XChapterNumberingSupplier \
    qadevOOo/tests/java/ifc/text/_XDefaultNumberingProvider \
    qadevOOo/tests/java/ifc/text/_XDocumentIndex \
    qadevOOo/tests/java/ifc/text/_XDocumentIndexesSupplier \
    qadevOOo/tests/java/ifc/text/_XEndnotesSupplier \
    qadevOOo/tests/java/ifc/text/_XFootnotesSettingsSupplier \
    qadevOOo/tests/java/ifc/text/_XFootnotesSupplier \
    qadevOOo/tests/java/ifc/text/_XLineNumberingProperties \
    qadevOOo/tests/java/ifc/text/_XMailMergeBroadcaster \
    qadevOOo/tests/java/ifc/text/_XPageCursor \
    qadevOOo/tests/java/ifc/text/_XPagePrintable \
    qadevOOo/tests/java/ifc/text/_XParagraphCursor \
    qadevOOo/tests/java/ifc/text/_XReferenceMarksSupplier \
    qadevOOo/tests/java/ifc/text/_XRelativeTextContentInsert \
    qadevOOo/tests/java/ifc/text/_XSentenceCursor \
    qadevOOo/tests/java/ifc/text/_XSimpleText \
    qadevOOo/tests/java/ifc/text/_XText \
    qadevOOo/tests/java/ifc/text/_XTextColumns \
    qadevOOo/tests/java/ifc/text/_XTextContent \
    qadevOOo/tests/java/ifc/text/_XTextCursor \
    qadevOOo/tests/java/ifc/text/_XTextDocument \
    qadevOOo/tests/java/ifc/text/_XTextEmbeddedObjectsSupplier \
    qadevOOo/tests/java/ifc/text/_XTextField \
    qadevOOo/tests/java/ifc/text/_XTextFieldsSupplier \
    qadevOOo/tests/java/ifc/text/_XTextFrame \
    qadevOOo/tests/java/ifc/text/_XTextFramesSupplier \
    qadevOOo/tests/java/ifc/text/_XTextGraphicObjectsSupplier \
    qadevOOo/tests/java/ifc/text/_XTextRange \
    qadevOOo/tests/java/ifc/text/_XTextRangeCompare \
    qadevOOo/tests/java/ifc/text/_XTextRangeMover \
    qadevOOo/tests/java/ifc/text/_XTextSection \
    qadevOOo/tests/java/ifc/text/_XTextSectionsSupplier \
    qadevOOo/tests/java/ifc/text/_XTextTable \
    qadevOOo/tests/java/ifc/text/_XTextTableCursor \
    qadevOOo/tests/java/ifc/text/_XTextTablesSupplier \
    qadevOOo/tests/java/ifc/text/_XTextViewCursorSupplier \
    qadevOOo/tests/java/ifc/text/_XWordCursor \
    qadevOOo/tests/java/ifc/ucb/_XCachedContentResultSetFactory \
    qadevOOo/tests/java/ifc/ucb/_XCachedContentResultSetStubFactory \
    qadevOOo/tests/java/ifc/ucb/_XCachedDynamicResultSetFactory \
    qadevOOo/tests/java/ifc/ucb/_XCachedDynamicResultSetStubFactory \
    qadevOOo/tests/java/ifc/ucb/_XCommandProcessor \
    qadevOOo/tests/java/ifc/ucb/_XCommandProcessor2 \
    qadevOOo/tests/java/ifc/ucb/_XContentIdentifierFactory \
    qadevOOo/tests/java/ifc/ucb/_XContentProvider \
    qadevOOo/tests/java/ifc/ucb/_XContentProviderFactory \
    qadevOOo/tests/java/ifc/ucb/_XContentProviderManager \
    qadevOOo/tests/java/ifc/ucb/_XDataContainer \
    qadevOOo/tests/java/ifc/ucb/_XFileIdentifierConverter \
    qadevOOo/tests/java/ifc/ucb/_XParameterizedContentProvider \
    qadevOOo/tests/java/ifc/ucb/_XPropertyMatcherFactory \
    qadevOOo/tests/java/ifc/ucb/_XPropertySetRegistryFactory \
    qadevOOo/tests/java/ifc/ucb/_XRemoteContentProviderAcceptor \
    qadevOOo/tests/java/ifc/ucb/_XRemoteContentProviderActivator \
    qadevOOo/tests/java/ifc/ucb/_XSimpleFileAccess \
    qadevOOo/tests/java/ifc/ucb/_XSimpleFileAccess2 \
    qadevOOo/tests/java/ifc/ucb/_XSortedDynamicResultSetFactory \
    qadevOOo/tests/java/ifc/ui/dialogs/_FilePicker \
    qadevOOo/tests/java/ifc/ui/dialogs/_XControlAccess \
    qadevOOo/tests/java/ifc/ui/dialogs/_XControlInformation \
    qadevOOo/tests/java/ifc/ui/dialogs/_XExecutableDialog \
    qadevOOo/tests/java/ifc/ui/dialogs/_XFilePicker \
    qadevOOo/tests/java/ifc/ui/dialogs/_XFilePickerControlAccess \
    qadevOOo/tests/java/ifc/ui/dialogs/_XFilePickerNotifier \
    qadevOOo/tests/java/ifc/ui/dialogs/_XFilePreview \
    qadevOOo/tests/java/ifc/ui/dialogs/_XFilterGroupManager \
    qadevOOo/tests/java/ifc/ui/dialogs/_XFilterManager \
    qadevOOo/tests/java/ifc/ui/dialogs/_XFolderPicker \
    qadevOOo/tests/java/ifc/ui/_XContextMenuInterception \
    qadevOOo/tests/java/ifc/ui/_XModuleUIConfigurationManager \
    qadevOOo/tests/java/ifc/ui/_XModuleUIConfigurationManagerSupplier \
    qadevOOo/tests/java/ifc/ui/_XUIConfiguration \
    qadevOOo/tests/java/ifc/ui/_XUIConfigurationListener \
    qadevOOo/tests/java/ifc/ui/_XUIConfigurationManager \
    qadevOOo/tests/java/ifc/ui/_XUIConfigurationPersistence \
    qadevOOo/tests/java/ifc/ui/_XUIConfigurationStorage \
    qadevOOo/tests/java/ifc/ui/_XUIElementFactory \
    qadevOOo/tests/java/ifc/ui/_XUIElementFactoryRegistration \
    qadevOOo/tests/java/ifc/uno/_XComponentContext \
    qadevOOo/tests/java/ifc/uno/_XNamingService \
    qadevOOo/tests/java/ifc/util/_PathSettings \
    qadevOOo/tests/java/ifc/util/_SearchDescriptor \
    qadevOOo/tests/java/ifc/util/_XCancellable \
    qadevOOo/tests/java/ifc/util/_XChangesBatch \
    qadevOOo/tests/java/ifc/util/_XChangesNotifier \
    qadevOOo/tests/java/ifc/util/_XCloneable \
    qadevOOo/tests/java/ifc/util/_XFlushable \
    qadevOOo/tests/java/ifc/util/_XImportable \
    qadevOOo/tests/java/ifc/util/_XModeSelector \
    qadevOOo/tests/java/ifc/util/_XModifiable \
    qadevOOo/tests/java/ifc/util/_XModifyBroadcaster \
    qadevOOo/tests/java/ifc/util/_XNumberFormatsSupplier \
    qadevOOo/tests/java/ifc/util/_XNumberFormatter \
    qadevOOo/tests/java/ifc/util/_XProtectable \
    qadevOOo/tests/java/ifc/util/_XRefreshable \
    qadevOOo/tests/java/ifc/util/_XReplaceable \
    qadevOOo/tests/java/ifc/util/_XReplaceDescriptor \
    qadevOOo/tests/java/ifc/util/_XSearchable \
    qadevOOo/tests/java/ifc/util/_XSearchDescriptor \
    qadevOOo/tests/java/ifc/util/_XSortable \
    qadevOOo/tests/java/ifc/util/_XStringEscape \
    qadevOOo/tests/java/ifc/util/_XStringSubstitution \
    qadevOOo/tests/java/ifc/util/_XURLTransformer \
    qadevOOo/tests/java/ifc/view/_XControlAccess \
    qadevOOo/tests/java/ifc/view/_XFormLayerAccess \
    qadevOOo/tests/java/ifc/view/_XMultiSelectionSupplier \
    qadevOOo/tests/java/ifc/view/_XPrintable \
    qadevOOo/tests/java/ifc/view/_XPrintJobBroadcaster \
    qadevOOo/tests/java/ifc/view/_XPrintSettingsSupplier \
    qadevOOo/tests/java/ifc/view/_XScreenCursor \
    qadevOOo/tests/java/ifc/view/_XSelectionSupplier \
    qadevOOo/tests/java/ifc/view/_XViewSettingsSupplier \
    qadevOOo/tests/java/ifc/xml/sax/_XDocumentHandler \
    qadevOOo/tests/java/ifc/xml/_UserDefinedAttributesSupplier \
    qadevOOo/tests/java/mod/_acceptor/Acceptor \
    qadevOOo/tests/java/mod/_acceptor/uno/Acceptor \
    qadevOOo/tests/java/mod/_ado/ODriver \
    qadevOOo/tests/java/mod/_basctl/AccessibleShape \
    qadevOOo/tests/java/mod/_brdgfctr/BridgeFactory \
    qadevOOo/tests/java/mod/_bridgefac/uno/BridgeFactory \
    qadevOOo/tests/java/mod/_cached/CachedContentResultSetFactory \
    qadevOOo/tests/java/mod/_cached/CachedContentResultSetStubFactory \
    qadevOOo/tests/java/mod/_cached/CachedDynamicResultSetFactory \
    qadevOOo/tests/java/mod/_cached/CachedDynamicResultSetStubFactory \
    qadevOOo/tests/java/mod/_cmdmail/SimpleCommandMail \
    qadevOOo/tests/java/mod/_cnt/ChaosContentProvider \
    qadevOOo/tests/java/mod/_cnt/CntUnoDataContainer \
    qadevOOo/tests/java/mod/_cnt/PropertyMatcherFactory \
    qadevOOo/tests/java/mod/_configmgr/ConfigurationProvider \
    qadevOOo/tests/java/mod/_configmgr/DefaultProvider \
    qadevOOo/tests/java/mod/_configmgr/ProviderTestEnvironment \
    qadevOOo/tests/java/mod/_connector/uno/Connector \
    qadevOOo/tests/java/mod/_connectr/Connector \
    qadevOOo/tests/java/mod/_corefl/CoreReflection \
    qadevOOo/tests/java/mod/_corereflection/uno/CoreReflection \
    qadevOOo/tests/java/mod/_cpld/DLLComponentLoader \
    qadevOOo/tests/java/mod/_dbaccess/ConnectionLineAccessibility \
    qadevOOo/tests/java/mod/_dbaccess/DBContentLoader \
    qadevOOo/tests/java/mod/_dbaccess/JoinViewAccessibility \
    qadevOOo/tests/java/mod/_dbaccess/OCommandDefinition \
    qadevOOo/tests/java/mod/_dbaccess/ODatabaseContext \
    qadevOOo/tests/java/mod/_dbaccess/ODatabaseSource \
    qadevOOo/tests/java/mod/_dbaccess/ODatasourceAdministrationDialog \
    qadevOOo/tests/java/mod/_dbaccess/ODatasourceBrowser \
    qadevOOo/tests/java/mod/_dbaccess/OInteractionHandler \
    qadevOOo/tests/java/mod/_dbaccess/OQueryDesign \
    qadevOOo/tests/java/mod/_dbaccess/ORowSet \
    qadevOOo/tests/java/mod/_dbaccess/OSingleSelectQueryComposer \
    qadevOOo/tests/java/mod/_dbaccess/OSQLMessageDialog \
    qadevOOo/tests/java/mod/_dbaccess/SbaXGridControl \
    qadevOOo/tests/java/mod/_dbaccess/TableWindowAccessibility \
    qadevOOo/tests/java/mod/_dbpool/OConnectionPool \
    qadevOOo/tests/java/mod/_defreg/NestedRegistry \
    qadevOOo/tests/java/mod/_dtrans/generic \
    qadevOOo/tests/java/mod/_dynamicloader/Dynamic \
    qadevOOo/tests/java/mod/_fileacc/SimpleFileAccess \
    qadevOOo/tests/java/mod/_file/calc/ODriver \
    qadevOOo/tests/java/mod/_file/dbase/ODriver \
    qadevOOo/tests/java/mod/_file/flat/ODriver \
    qadevOOo/tests/java/mod/_fop/FolderPicker \
    qadevOOo/tests/java/mod/_forms/GenericModelTest \
    qadevOOo/tests/java/mod/_forms/OButtonControl \
    qadevOOo/tests/java/mod/_forms/OButtonModel \
    qadevOOo/tests/java/mod/_forms/OCheckBoxControl \
    qadevOOo/tests/java/mod/_forms/OCheckBoxModel \
    qadevOOo/tests/java/mod/_forms/OComboBoxControl \
    qadevOOo/tests/java/mod/_forms/OComboBoxModel \
    qadevOOo/tests/java/mod/_forms/OCurrencyControl \
    qadevOOo/tests/java/mod/_forms/OCurrencyModel \
    qadevOOo/tests/java/mod/_forms/ODatabaseForm \
    qadevOOo/tests/java/mod/_forms/ODateControl \
    qadevOOo/tests/java/mod/_forms/ODateModel \
    qadevOOo/tests/java/mod/_forms/OEditControl \
    qadevOOo/tests/java/mod/_forms/OEditModel \
    qadevOOo/tests/java/mod/_forms/OFileControlModel \
    qadevOOo/tests/java/mod/_forms/OFixedTextModel \
    qadevOOo/tests/java/mod/_forms/OFormattedControl \
    qadevOOo/tests/java/mod/_forms/OFormattedFieldWrapper \
    qadevOOo/tests/java/mod/_forms/OFormsCollection \
    qadevOOo/tests/java/mod/_forms/OGridControlModel \
    qadevOOo/tests/java/mod/_forms/OGroupBoxControl \
    qadevOOo/tests/java/mod/_forms/OGroupBoxModel \
    qadevOOo/tests/java/mod/_forms/OHiddenModel \
    qadevOOo/tests/java/mod/_forms/OImageButtonControl \
    qadevOOo/tests/java/mod/_forms/OImageButtonModel \
    qadevOOo/tests/java/mod/_forms/OImageControlControl \
    qadevOOo/tests/java/mod/_forms/OImageControlModel \
    qadevOOo/tests/java/mod/_forms/OListBoxControl \
    qadevOOo/tests/java/mod/_forms/OListBoxModel \
    qadevOOo/tests/java/mod/_forms/ONavigationBarControl \
    qadevOOo/tests/java/mod/_forms/ONavigationBarModel \
    qadevOOo/tests/java/mod/_forms/ONumericControl \
    qadevOOo/tests/java/mod/_forms/ONumericModel \
    qadevOOo/tests/java/mod/_forms/OPatternControl \
    qadevOOo/tests/java/mod/_forms/OPatternModel \
    qadevOOo/tests/java/mod/_forms/ORadioButtonControl \
    qadevOOo/tests/java/mod/_forms/ORadioButtonModel \
    qadevOOo/tests/java/mod/_forms/OScrollBarModel \
    qadevOOo/tests/java/mod/_forms/OSpinButtonModel \
    qadevOOo/tests/java/mod/_forms/OTimeControl \
    qadevOOo/tests/java/mod/_forms/OTimeModel \
    qadevOOo/tests/java/mod/_fps/FilePicker \
    qadevOOo/tests/java/mod/_ftransl/DataFormatTranslator \
    qadevOOo/tests/java/mod/_fwk/ControlMenuController \
    qadevOOo/tests/java/mod/_fwk/Desktop \
    qadevOOo/tests/java/mod/_fwk/DispatchRecorder \
    qadevOOo/tests/java/mod/_fwk/DispatchRecorderSupplier \
    qadevOOo/tests/java/mod/_fwk/FontMenuController \
    qadevOOo/tests/java/mod/_fwk/FontSizeMenuController \
    qadevOOo/tests/java/mod/_fwk/FooterMenuController \
    qadevOOo/tests/java/mod/_fwk/FormatMenuController \
    qadevOOo/tests/java/mod/_fwk/Frame \
    qadevOOo/tests/java/mod/_fwk/HeaderMenuController \
    qadevOOo/tests/java/mod/_fwk/JobExecutor \
    qadevOOo/tests/java/mod/_fwk/JobHandler \
    qadevOOo/tests/java/mod/_fwk/LayoutManager \
    qadevOOo/tests/java/mod/_fwk/MacrosMenuController \
    qadevOOo/tests/java/mod/_fwk/MailToDispatcher \
    qadevOOo/tests/java/mod/_fwk/MenuBarFactory \
    qadevOOo/tests/java/mod/_fwk/ModuleManager \
    qadevOOo/tests/java/mod/_fwk/ModuleUIConfigurationManager \
    qadevOOo/tests/java/mod/_fwk/ModuleUIConfigurationManagerSupplier \
    qadevOOo/tests/java/mod/_fwk/PopupMenuControllerFactory \
    qadevOOo/tests/java/mod/_fwk/ServiceHandler \
    qadevOOo/tests/java/mod/_fwk/SoundHandler \
    qadevOOo/tests/java/mod/_fwk/StatusBarControllerFactory \
    qadevOOo/tests/java/mod/_fwk/ToolBarsMenuController \
    qadevOOo/tests/java/mod/_fwk/UICategoryDescription \
    qadevOOo/tests/java/mod/_fwk/UICommandDescription \
    qadevOOo/tests/java/mod/_fwk/UIConfigurationManager \
    qadevOOo/tests/java/mod/_fwk/UIElementFactoryManager \
    qadevOOo/tests/java/mod/_fwk/URLTransformer \
    qadevOOo/tests/java/mod/_fwl/ContentHandlerFactory \
    qadevOOo/tests/java/mod/_fwl/FilterFactory \
    qadevOOo/tests/java/mod/_fwl/FrameLoaderFactory \
    qadevOOo/tests/java/mod/_fwl/PathSettings \
    qadevOOo/tests/java/mod/_fwl/SubstituteVariables \
    qadevOOo/tests/java/mod/_fwl/TypeDetection \
    qadevOOo/tests/java/mod/_i18n/BreakIterator \
    qadevOOo/tests/java/mod/_i18n/CalendarImpl \
    qadevOOo/tests/java/mod/_i18n/ChapterCollator \
    qadevOOo/tests/java/mod/_i18n/CharacterClassification \
    qadevOOo/tests/java/mod/_i18n/Collator \
    qadevOOo/tests/java/mod/_i18n/IndexEntrySupplier \
    qadevOOo/tests/java/mod/_i18n/LocaleData \
    qadevOOo/tests/java/mod/_i18n/NumberFormatCodeMapper \
    qadevOOo/tests/java/mod/_i18n/Transliteration \
    qadevOOo/tests/java/mod/_implreg/uno/ImplementationRegistration \
    qadevOOo/tests/java/mod/_impreg/ImplementationRegistration \
    qadevOOo/tests/java/mod/_insp/Introspection \
    qadevOOo/tests/java/mod/_introspection/uno/Introspection \
    qadevOOo/tests/java/mod/_invadp/InvocationAdapterFactory \
    qadevOOo/tests/java/mod/_inv/Invocation \
    qadevOOo/tests/java/mod/_invocadapt/uno/InvocationAdapterFactory \
    qadevOOo/tests/java/mod/_invocation/uno/Invocation \
    qadevOOo/tests/java/mod/_javaloader/JavaComponentLoader \
    qadevOOo/tests/java/mod/_javaloader/uno/JavaComponentLoader \
    qadevOOo/tests/java/mod/_javavm/uno/JavaVirtualMachine \
    qadevOOo/tests/java/mod/_jdbc/JDBCDriver \
    qadevOOo/tests/java/mod/_jen/JavaVirtualMachine \
    qadevOOo/tests/java/mod/_lng/DicList \
    qadevOOo/tests/java/mod/_lng/LinguProps \
    qadevOOo/tests/java/mod/_lng/LngSvcMgr \
    qadevOOo/tests/java/mod/_lnn/Hyphenator \
    qadevOOo/tests/java/mod/_lnn/SpellChecker \
    qadevOOo/tests/java/mod/_lnn/Thesaurus \
    qadevOOo/tests/java/mod/_mcnttype/MimeContentTypeFactory \
    qadevOOo/tests/java/mod/_namingservice/NamingService \
    qadevOOo/tests/java/mod/_namingservice/uno/NamingService \
    qadevOOo/tests/java/mod/_nestedreg/uno/NestedRegistry \
    qadevOOo/tests/java/mod/_odbc/ODBCDriver \
    qadevOOo/tests/java/mod/_pcr/ObjectInspector \
    qadevOOo/tests/java/mod/_pcr/ObjectInspectorModel \
    qadevOOo/tests/java/mod/_proxyfac/ProxyFactory \
    qadevOOo/tests/java/mod/_proxyfac/uno/ProxyFactory \
    qadevOOo/tests/java/mod/_rdbtdp/RegistryTypeDescriptionProvider \
    qadevOOo/tests/java/mod/_regtypeprov/uno/RegistryTypeDescriptionProvider \
    qadevOOo/tests/java/mod/_remotebridge/uno/various \
    qadevOOo/tests/java/mod/_remotebridge/various \
    qadevOOo/tests/java/mod/_sc/AccessibleEditableTextPara_HeaderFooter \
    qadevOOo/tests/java/mod/_sc/AccessibleEditableTextPara_PreviewCell \
    qadevOOo/tests/java/mod/_sch/AccArea \
    qadevOOo/tests/java/mod/_sch/AccAxis \
    qadevOOo/tests/java/mod/_sch/AccDataPoint \
    qadevOOo/tests/java/mod/_sch/AccDataSeries \
    qadevOOo/tests/java/mod/_sch/AccDiagram \
    qadevOOo/tests/java/mod/_sch/AccessibleDocumentView \
    qadevOOo/tests/java/mod/_sch/AccFloor \
    qadevOOo/tests/java/mod/_sch/AccGrid \
    qadevOOo/tests/java/mod/_sch/AccLegend \
    qadevOOo/tests/java/mod/_sch/AccLegendEntry \
    qadevOOo/tests/java/mod/_sch/AccTitle \
    qadevOOo/tests/java/mod/_sch/AccWall \
    qadevOOo/tests/java/mod/_sch/ChartArea \
    qadevOOo/tests/java/mod/_sch/ChartGrid \
    qadevOOo/tests/java/mod/_sch/ChartLegend \
    qadevOOo/tests/java/mod/_sch/ChartLine \
    qadevOOo/tests/java/mod/_sch/ChartTitle \
    qadevOOo/tests/java/mod/_sch/ChXChartAxis \
    qadevOOo/tests/java/mod/_sch/ChXChartData \
    qadevOOo/tests/java/mod/_sch/ChXChartDataArray \
    qadevOOo/tests/java/mod/_sch/ChXChartDocument \
    qadevOOo/tests/java/mod/_sch/ChXChartView \
    qadevOOo/tests/java/mod/_sch/ChXDataPoint \
    qadevOOo/tests/java/mod/_sch/ChXDataRow \
    qadevOOo/tests/java/mod/_sch/ChXDiagram \
    qadevOOo/tests/java/mod/_sc/ScAccessibleCell \
    qadevOOo/tests/java/mod/_sc/ScAccessibleCsvCell \
    qadevOOo/tests/java/mod/_sc/ScAccessibleCsvGrid \
    qadevOOo/tests/java/mod/_sc/ScAccessibleCsvRuler \
    qadevOOo/tests/java/mod/_sc/ScAccessibleDocument \
    qadevOOo/tests/java/mod/_sc/ScAccessibleDocumentPagePreview \
    qadevOOo/tests/java/mod/_sc/ScAccessiblePageHeader \
    qadevOOo/tests/java/mod/_sc/ScAccessiblePageHeaderArea \
    qadevOOo/tests/java/mod/_sc/ScAccessiblePreviewCell \
    qadevOOo/tests/java/mod/_sc/ScAccessiblePreviewHeaderCell \
    qadevOOo/tests/java/mod/_sc/ScAccessiblePreviewTable \
    qadevOOo/tests/java/mod/_sc/ScAccessibleSpreadsheet \
    qadevOOo/tests/java/mod/_sc/ScAnnotationShapeObj \
    qadevOOo/tests/java/mod/_sc/ScAnnotationTextCursor \
    qadevOOo/tests/java/mod/_sc/ScAutoFormatFieldObj \
    qadevOOo/tests/java/mod/_sc/ScCellCursorObj \
    qadevOOo/tests/java/mod/_sc/ScCellObj \
    qadevOOo/tests/java/mod/_sc/ScCellRangeObj \
    qadevOOo/tests/java/mod/_sc/ScCellRangesObj \
    qadevOOo/tests/java/mod/_sc/ScCellTextCursor \
    qadevOOo/tests/java/mod/_sc/ScDatabaseRangeObj \
    qadevOOo/tests/java/mod/_sc/ScDataPilotItemObj \
    qadevOOo/tests/java/mod/_sc/ScDocumentConfiguration \
    qadevOOo/tests/java/mod/_sc/ScHeaderFooterTextCursor \
    qadevOOo/tests/java/mod/_sc/ScHeaderFooterTextObj \
    qadevOOo/tests/java/mod/_sc/ScModelObj \
    qadevOOo/tests/java/mod/_sc/ScShapeObj \
    qadevOOo/tests/java/mod/_sc/ScSheetLinkObj \
    qadevOOo/tests/java/mod/_sc/ScStyleObj \
    qadevOOo/tests/java/mod/_sc/ScTableSheetObj \
    qadevOOo/tests/java/mod/_sc/ScTabViewObj \
    qadevOOo/tests/java/mod/_sc/XMLContentExporter \
    qadevOOo/tests/java/mod/_sc/XMLContentImporter \
    qadevOOo/tests/java/mod/_sc/XMLExporter \
    qadevOOo/tests/java/mod/_sc/XMLImporter \
    qadevOOo/tests/java/mod/_sc/XMLMetaExporter \
    qadevOOo/tests/java/mod/_sc/XMLMetaImporter \
    qadevOOo/tests/java/mod/_sc/XMLSettingsExporter \
    qadevOOo/tests/java/mod/_sc/XMLSettingsImporter \
    qadevOOo/tests/java/mod/_sc/XMLStylesExporter \
    qadevOOo/tests/java/mod/_sc/XMLStylesImporter \
    qadevOOo/tests/java/mod/_sd/AccessibleDrawDocumentView \
    qadevOOo/tests/java/mod/_sd/AccessibleOutlineView \
    qadevOOo/tests/java/mod/_sd/AccessibleSlideView \
    qadevOOo/tests/java/mod/_sd/DrawController_DrawView \
    qadevOOo/tests/java/mod/_sd/DrawController_HandoutView \
    qadevOOo/tests/java/mod/_sd/DrawController_NotesView \
    qadevOOo/tests/java/mod/_sd/DrawController_OutlineView \
    qadevOOo/tests/java/mod/_sd/DrawController_PresentationView \
    qadevOOo/tests/java/mod/_sd/SdDocLinkTargets \
    qadevOOo/tests/java/mod/_sd/SdDrawPage \
    qadevOOo/tests/java/mod/_sd/SdDrawPagesAccess \
    qadevOOo/tests/java/mod/_sd/SdGenericDrawPage \
    qadevOOo/tests/java/mod/_sd/SdLayer \
    qadevOOo/tests/java/mod/_sd/SdLayerManager \
    qadevOOo/tests/java/mod/_sd/SdMasterPage \
    qadevOOo/tests/java/mod/_sd/SdMasterPagesAccess \
    qadevOOo/tests/java/mod/_sd/SdPageLinkTargets \
    qadevOOo/tests/java/mod/_sd/SdUnoDrawView \
    qadevOOo/tests/java/mod/_sd/SdUnoOutlineView \
    qadevOOo/tests/java/mod/_sd/SdUnoPresView \
    qadevOOo/tests/java/mod/_sd/SdUnoSlideView \
    qadevOOo/tests/java/mod/_sd/SdXCustomPresentation \
    qadevOOo/tests/java/mod/_sd/SdXCustomPresentationAccess \
    qadevOOo/tests/java/mod/_sd/SdXImpressDocument \
    qadevOOo/tests/java/mod/_sd/SdXPresentation \
    qadevOOo/tests/java/mod/_sd/SdXShape \
    qadevOOo/tests/java/mod/_servicemgr/uno/OServiceManager \
    qadevOOo/tests/java/mod/_sfx/AppDispatchProvider \
    qadevOOo/tests/java/mod/_sfx/DocumentTemplates \
    qadevOOo/tests/java/mod/_sfx/FrameLoader \
    qadevOOo/tests/java/mod/_sfx/SfxMacroLoader \
    qadevOOo/tests/java/mod/_shlibloader/uno/DLLComponentLoader \
    qadevOOo/tests/java/mod/_simplereg/uno/SimpleRegistry \
    qadevOOo/tests/java/mod/_simreg/SimpleRegistry \
    qadevOOo/tests/java/mod/_smgr/OServiceManager \
    qadevOOo/tests/java/mod/_smplmail/SimpleSystemMail \
    qadevOOo/tests/java/mod/_sm/SmGraphicAccessible \
    qadevOOo/tests/java/mod/_sm/SmModel \
    qadevOOo/tests/java/mod/_sm/XMLExporter \
    qadevOOo/tests/java/mod/_sm/XMLImporter \
    qadevOOo/tests/java/mod/_sm/XMLMetaExporter \
    qadevOOo/tests/java/mod/_sm/XMLMetaImporter \
    qadevOOo/tests/java/mod/_sm/XMLSettingsExporter \
    qadevOOo/tests/java/mod/_sm/XMLSettingsImporter \
    qadevOOo/tests/java/mod/_srtrs/SortedDynamicResultSetFactory \
    qadevOOo/tests/java/mod/_stm/DataInputStream \
    qadevOOo/tests/java/mod/_stm/DataOutputStream \
    qadevOOo/tests/java/mod/_stm/MarkableInputStream \
    qadevOOo/tests/java/mod/_stm/MarkableOutputStream \
    qadevOOo/tests/java/mod/_stm/ObjectInputStream \
    qadevOOo/tests/java/mod/_stm/ObjectOutputStream \
    qadevOOo/tests/java/mod/_stm/Pipe \
    qadevOOo/tests/java/mod/_stm/Pump \
    qadevOOo/tests/java/mod/_streams/uno/DataInputStream \
    qadevOOo/tests/java/mod/_streams/uno/DataOutputStream \
    qadevOOo/tests/java/mod/_streams/uno/MarkableInputStream \
    qadevOOo/tests/java/mod/_streams/uno/MarkableOutputStream \
    qadevOOo/tests/java/mod/_streams/uno/ObjectInputStream \
    qadevOOo/tests/java/mod/_streams/uno/ObjectOutputStream \
    qadevOOo/tests/java/mod/_streams/uno/Pipe \
    qadevOOo/tests/java/mod/_streams/uno/Pump \
    qadevOOo/tests/java/mod/_svtools/AccessibleBrowseBox \
    qadevOOo/tests/java/mod/_svtools/AccessibleBrowseBoxHeaderBar \
    qadevOOo/tests/java/mod/_svtools/AccessibleBrowseBoxHeaderCell \
    qadevOOo/tests/java/mod/_svtools/AccessibleBrowseBoxTable \
    qadevOOo/tests/java/mod/_svtools/AccessibleBrowseBoxTableCell \
    qadevOOo/tests/java/mod/_svtools/AccessibleIconChoiceCtrl \
    qadevOOo/tests/java/mod/_svtools/AccessibleIconChoiceCtrlEntry \
    qadevOOo/tests/java/mod/_svtools/AccessibleTabBar \
    qadevOOo/tests/java/mod/_svtools/AccessibleTabBarPage \
    qadevOOo/tests/java/mod/_svtools/AccessibleTabBarPageList \
    qadevOOo/tests/java/mod/_svtools/AccessibleTreeListBox \
    qadevOOo/tests/java/mod/_svtools/AccessibleTreeListBoxEntry \
    qadevOOo/tests/java/mod/_svx/AccessibleControlShape \
    qadevOOo/tests/java/mod/_svx/AccessibleEditableTextPara \
    qadevOOo/tests/java/mod/_svx/AccessibleGraphicShape \
    qadevOOo/tests/java/mod/_svx/AccessibleOLEShape \
    qadevOOo/tests/java/mod/_svx/AccessiblePageShape \
    qadevOOo/tests/java/mod/_svx/AccessiblePresentationGraphicShape \
    qadevOOo/tests/java/mod/_svx/AccessiblePresentationOLEShape \
    qadevOOo/tests/java/mod/_svx/AccessiblePresentationShape \
    qadevOOo/tests/java/mod/_svx/AccessibleShape \
    qadevOOo/tests/java/mod/_svx/GraphicExporter \
    qadevOOo/tests/java/mod/_svx/SvxDrawPage \
    qadevOOo/tests/java/mod/_svx/SvxGraphCtrlAccessibleContext \
    qadevOOo/tests/java/mod/_svx/SvxGraphicObject \
    qadevOOo/tests/java/mod/_svx/SvxShape \
    qadevOOo/tests/java/mod/_svx/SvxShapeCircle \
    qadevOOo/tests/java/mod/_svx/SvxShapeCollection \
    qadevOOo/tests/java/mod/_svx/SvxShapeConnector \
    qadevOOo/tests/java/mod/_svx/SvxShapeControl \
    qadevOOo/tests/java/mod/_svx/SvxShapeDimensioning \
    qadevOOo/tests/java/mod/_svx/SvxShapeGroup \
    qadevOOo/tests/java/mod/_svx/SvxShapePolyPolygon \
    qadevOOo/tests/java/mod/_svx/SvxUnoNumberingRules \
    qadevOOo/tests/java/mod/_svx/SvxUnoText \
    qadevOOo/tests/java/mod/_svx/SvxUnoTextContent \
    qadevOOo/tests/java/mod/_svx/SvxUnoTextContentEnum \
    qadevOOo/tests/java/mod/_svx/SvxUnoTextCursor \
    qadevOOo/tests/java/mod/_svx/SvxUnoTextField \
    qadevOOo/tests/java/mod/_svx/SvxUnoTextRange \
    qadevOOo/tests/java/mod/_svx/SvxUnoTextRangeEnumeration \
    qadevOOo/tests/java/mod/_sw/CharacterStyle \
    qadevOOo/tests/java/mod/_sw/ConditionalParagraphStyle \
    qadevOOo/tests/java/mod/_sw/DocumentSettings \
    qadevOOo/tests/java/mod/_sw/PageStyle \
    qadevOOo/tests/java/mod/_sw/ParagraphStyle \
    qadevOOo/tests/java/mod/_sw/SwAccessibleDocumentPageView \
    qadevOOo/tests/java/mod/_sw/SwAccessibleDocumentView \
    qadevOOo/tests/java/mod/_sw/SwAccessibleEndnoteView \
    qadevOOo/tests/java/mod/_sw/SwAccessibleFooterView \
    qadevOOo/tests/java/mod/_sw/SwAccessibleFootnoteView \
    qadevOOo/tests/java/mod/_sw/SwAccessibleHeaderView \
    qadevOOo/tests/java/mod/_sw/SwAccessiblePageView \
    qadevOOo/tests/java/mod/_sw/SwAccessibleParagraphView \
    qadevOOo/tests/java/mod/_sw/SwAccessibleTableCellView \
    qadevOOo/tests/java/mod/_sw/SwAccessibleTableView \
    qadevOOo/tests/java/mod/_sw/SwAccessibleTextEmbeddedObject \
    qadevOOo/tests/java/mod/_sw/SwAccessibleTextFrameView \
    qadevOOo/tests/java/mod/_sw/SwAccessibleTextGraphicObject \
    qadevOOo/tests/java/mod/_sw/SwXAutoTextEntry \
    qadevOOo/tests/java/mod/_sw/SwXAutoTextGroup \
    qadevOOo/tests/java/mod/_sw/SwXCell \
    qadevOOo/tests/java/mod/_sw/SwXCellRange \
    qadevOOo/tests/java/mod/_sw/SwXChapterNumbering \
    qadevOOo/tests/java/mod/_sw/SwXDocumentIndexMark \
    qadevOOo/tests/java/mod/_sw/SwXDrawPage \
    qadevOOo/tests/java/mod/_sw/SwXEndnoteProperties \
    qadevOOo/tests/java/mod/_sw/SwXFieldMaster \
    qadevOOo/tests/java/mod/_sw/SwXFrames \
    qadevOOo/tests/java/mod/_sw/SwXHeadFootText \
    qadevOOo/tests/java/mod/_sw/SwXLineNumberingProperties \
    qadevOOo/tests/java/mod/_sw/SwXMailMerge \
    qadevOOo/tests/java/mod/_sw/SwXModule \
    qadevOOo/tests/java/mod/_sw/SwXNumberingRules \
    qadevOOo/tests/java/mod/_sw/SwXParagraph \
    qadevOOo/tests/java/mod/_sw/SwXPrintSettings \
    qadevOOo/tests/java/mod/_sw/SwXPropertySet \
    qadevOOo/tests/java/mod/_sw/SwXPropertySetInfo \
    qadevOOo/tests/java/mod/_sw/SwXShape \
    qadevOOo/tests/java/mod/_sw/SwXStyle \
    qadevOOo/tests/java/mod/_sw/SwXStyleFamily \
    qadevOOo/tests/java/mod/_sw/SwXTableCellText \
    qadevOOo/tests/java/mod/_sw/SwXTableColumns \
    qadevOOo/tests/java/mod/_sw/SwXTableRows \
    qadevOOo/tests/java/mod/_sw/SwXTextColumns \
    qadevOOo/tests/java/mod/_sw/SwXTextCursor \
    qadevOOo/tests/java/mod/_sw/SwXTextDefaults \
    qadevOOo/tests/java/mod/_sw/SwXTextDocument \
    qadevOOo/tests/java/mod/_sw/SwXTextEmbeddedObject \
    qadevOOo/tests/java/mod/_sw/SwXTextField \
    qadevOOo/tests/java/mod/_sw/SwXTextFrame \
    qadevOOo/tests/java/mod/_sw/SwXTextFrameText \
    qadevOOo/tests/java/mod/_sw/SwXTextGraphicObject \
    qadevOOo/tests/java/mod/_sw/SwXTextGraphicObjects \
    qadevOOo/tests/java/mod/_sw/SwXTextPortion \
    qadevOOo/tests/java/mod/_sw/SwXTextPortionEnumeration \
    qadevOOo/tests/java/mod/_sw/SwXTextRange \
    qadevOOo/tests/java/mod/_sw/SwXTextRanges \
    qadevOOo/tests/java/mod/_sw/SwXTextSearch \
    qadevOOo/tests/java/mod/_sw/SwXTextSection \
    qadevOOo/tests/java/mod/_sw/SwXTextTableCursor \
    qadevOOo/tests/java/mod/_sw/SwXTextTableRow \
    qadevOOo/tests/java/mod/_sw/SwXTextView \
    qadevOOo/tests/java/mod/_sw/SwXTextViewCursor \
    qadevOOo/tests/java/mod/_sw/SwXViewSettings \
    qadevOOo/tests/java/mod/_sw/XMLContentExporter \
    qadevOOo/tests/java/mod/_sw/XMLContentImporter \
    qadevOOo/tests/java/mod/_sw/XMLExporter \
    qadevOOo/tests/java/mod/_sw/XMLImporter \
    qadevOOo/tests/java/mod/_sw/XMLMetaExporter \
    qadevOOo/tests/java/mod/_sw/XMLMetaImporter \
    qadevOOo/tests/java/mod/_sw/XMLSettingsExporter \
    qadevOOo/tests/java/mod/_sw/XMLSettingsImporter \
    qadevOOo/tests/java/mod/_sw/XMLStylesExporter \
    qadevOOo/tests/java/mod/_sw/XMLStylesImporter \
    qadevOOo/tests/java/mod/_sysdtrans/SystemClipboard \
    qadevOOo/tests/java/mod/_syssh/SystemShellExecute \
    qadevOOo/tests/java/mod/_tcv/TypeConverter \
    qadevOOo/tests/java/mod/_tdmgr/TypeDescriptionManager \
    qadevOOo/tests/java/mod/_text/DefaultNumberingProvider \
    qadevOOo/tests/java/mod/_toolkit/AccessibleButton \
    qadevOOo/tests/java/mod/_toolkit/AccessibleCheckBox \
    qadevOOo/tests/java/mod/_toolkit/AccessibleComboBox \
    qadevOOo/tests/java/mod/_toolkit/AccessibleDropDownComboBox \
    qadevOOo/tests/java/mod/_toolkit/AccessibleDropDownListBox \
    qadevOOo/tests/java/mod/_toolkit/AccessibleEdit \
    qadevOOo/tests/java/mod/_toolkit/AccessibleFixedText \
    qadevOOo/tests/java/mod/_toolkit/AccessibleList \
    qadevOOo/tests/java/mod/_toolkit/AccessibleListBox \
    qadevOOo/tests/java/mod/_toolkit/AccessibleListItem \
    qadevOOo/tests/java/mod/_toolkit/AccessibleMenu \
    qadevOOo/tests/java/mod/_toolkit/AccessibleMenuBar \
    qadevOOo/tests/java/mod/_toolkit/AccessibleMenuItem \
    qadevOOo/tests/java/mod/_toolkit/AccessibleMenuSeparator \
    qadevOOo/tests/java/mod/_toolkit/AccessiblePopupMenu \
    qadevOOo/tests/java/mod/_toolkit/AccessibleRadioButton \
    qadevOOo/tests/java/mod/_toolkit/AccessibleScrollBar \
    qadevOOo/tests/java/mod/_toolkit/AccessibleStatusBar \
    qadevOOo/tests/java/mod/_toolkit/AccessibleStatusBarItem \
    qadevOOo/tests/java/mod/_toolkit/AccessibleTabControl \
    qadevOOo/tests/java/mod/_toolkit/AccessibleTabPage \
    qadevOOo/tests/java/mod/_toolkit/AccessibleToolBox \
    qadevOOo/tests/java/mod/_toolkit/AccessibleToolBoxItem \
    qadevOOo/tests/java/mod/_toolkit/AccessibleWindow \
    qadevOOo/tests/java/mod/_toolkit/MutableTreeDataModel \
    qadevOOo/tests/java/mod/_toolkit/MutableTreeNode \
    qadevOOo/tests/java/mod/_toolkit/TabController \
    qadevOOo/tests/java/mod/_toolkit/TabControllerModel \
    qadevOOo/tests/java/mod/_toolkit/Toolkit \
    qadevOOo/tests/java/mod/_toolkit/UnoControlButton \
    qadevOOo/tests/java/mod/_toolkit/UnoControlButtonModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlCheckBox \
    qadevOOo/tests/java/mod/_toolkit/UnoControlCheckBoxModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlComboBox \
    qadevOOo/tests/java/mod/_toolkit/UnoControlComboBoxModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlContainer \
    qadevOOo/tests/java/mod/_toolkit/UnoControlContainerModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlCurrencyField \
    qadevOOo/tests/java/mod/_toolkit/UnoControlCurrencyFieldModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlDateField \
    qadevOOo/tests/java/mod/_toolkit/UnoControlDateFieldModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlDialog \
    qadevOOo/tests/java/mod/_toolkit/UnoControlDialogModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlEdit \
    qadevOOo/tests/java/mod/_toolkit/UnoControlEditModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlFileControl \
    qadevOOo/tests/java/mod/_toolkit/UnoControlFileControlModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlFixedLineModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlFixedText \
    qadevOOo/tests/java/mod/_toolkit/UnoControlFixedTextModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlFormattedField \
    qadevOOo/tests/java/mod/_toolkit/UnoControlFormattedFieldModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlGroupBox \
    qadevOOo/tests/java/mod/_toolkit/UnoControlGroupBoxModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlImageControl \
    qadevOOo/tests/java/mod/_toolkit/UnoControlImageControlModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlListBox \
    qadevOOo/tests/java/mod/_toolkit/UnoControlListBoxModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlNumericField \
    qadevOOo/tests/java/mod/_toolkit/UnoControlNumericFieldModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlPatternField \
    qadevOOo/tests/java/mod/_toolkit/UnoControlPatternFieldModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlProgressBarModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlRadioButton \
    qadevOOo/tests/java/mod/_toolkit/UnoControlRadioButtonModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlScrollBarModel \
    qadevOOo/tests/java/mod/_toolkit/UnoControlTimeField \
    qadevOOo/tests/java/mod/_toolkit/UnoControlTimeFieldModel \
    qadevOOo/tests/java/mod/_toolkit/UnoScrollBarControl \
    qadevOOo/tests/java/mod/_toolkit/UnoSpinButtonControl \
    qadevOOo/tests/java/mod/_toolkit/UnoSpinButtonControlModel \
    qadevOOo/tests/java/mod/_toolkit/UnoTreeControl \
    qadevOOo/tests/java/mod/_toolkit/UnoTreeModel \
    qadevOOo/tests/java/mod/_typeconverter/uno/TypeConverter \
    qadevOOo/tests/java/mod/_typemgr/uno/TypeDescriptionManager \
    qadevOOo/tests/java/mod/_ucb/UcbContentProviderProxyFactory \
    qadevOOo/tests/java/mod/_ucb/UcbPropertiesManager \
    qadevOOo/tests/java/mod/_ucb/UcbStore \
    qadevOOo/tests/java/mod/_ucb/UniversalContentBroker \
    qadevOOo/tests/java/mod/_ucpchelp/CHelpContentProvider \
    qadevOOo/tests/java/mod/_ucpdav/WebDAVContentProvider \
    qadevOOo/tests/java/mod/_ucpfile/FileProvider \
    qadevOOo/tests/java/mod/_ucphier/HierarchyContentProvider \
    qadevOOo/tests/java/mod/_ucphier/HierarchyDataSource \
    qadevOOo/tests/java/mod/_ucppkg/PackageContentProvider \
    qadevOOo/tests/java/mod/_ucprmt/ContentProvider \
    qadevOOo/tests/java/mod/_ucprmt/ProviderAcceptor \
    qadevOOo/tests/java/mod/_ucprmt/ProxyProvider \
    qadevOOo/tests/java/mod/_uui/UUIInteractionHandler \
    qadevOOo/tests/java/mod/_uuresolver/uno/UnoUrlResolver \
    qadevOOo/tests/java/mod/_uuresolver/UnoUrlResolver \
    qadevOOo/tests/java/mod/_xmloff/Chart/XMLContentExporter \
    qadevOOo/tests/java/mod/_xmloff/Chart/XMLContentImporter \
    qadevOOo/tests/java/mod/_xmloff/Chart/XMLExporter \
    qadevOOo/tests/java/mod/_xmloff/Chart/XMLImporter \
    qadevOOo/tests/java/mod/_xmloff/Chart/XMLStylesExporter \
    qadevOOo/tests/java/mod/_xmloff/Chart/XMLStylesImporter \
    qadevOOo/tests/java/mod/_xmloff/Draw/XMLContentExporter \
    qadevOOo/tests/java/mod/_xmloff/Draw/XMLContentImporter \
    qadevOOo/tests/java/mod/_xmloff/Draw/XMLExporter \
    qadevOOo/tests/java/mod/_xmloff/Draw/XMLImporter \
    qadevOOo/tests/java/mod/_xmloff/Draw/XMLMetaExporter \
    qadevOOo/tests/java/mod/_xmloff/Draw/XMLMetaImporter \
    qadevOOo/tests/java/mod/_xmloff/Draw/XMLSettingsExporter \
    qadevOOo/tests/java/mod/_xmloff/Draw/XMLSettingsImporter \
    qadevOOo/tests/java/mod/_xmloff/Draw/XMLStylesExporter \
    qadevOOo/tests/java/mod/_xmloff/Draw/XMLStylesImporter \
    qadevOOo/tests/java/mod/_xmloff/Impress/XMLContentExporter \
    qadevOOo/tests/java/mod/_xmloff/Impress/XMLContentImporter \
    qadevOOo/tests/java/mod/_xmloff/Impress/XMLExporter \
    qadevOOo/tests/java/mod/_xmloff/Impress/XMLImporter \
    qadevOOo/tests/java/mod/_xmloff/Impress/XMLMetaExporter \
    qadevOOo/tests/java/mod/_xmloff/Impress/XMLMetaImporter \
    qadevOOo/tests/java/mod/_xmloff/Impress/XMLSettingsExporter \
    qadevOOo/tests/java/mod/_xmloff/Impress/XMLSettingsImporter \
    qadevOOo/tests/java/mod/_xmloff/Impress/XMLStylesExporter \
    qadevOOo/tests/java/mod/_xmloff/Impress/XMLStylesImporter \
))

$(eval $(call gb_Jar_add_packagefile,OOoRunner,objdsc,$(SRCDIR)/qadevOOo/objdsc))
