/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Property {
    private String _name;
    private PropertyType _type;
    private PropertyArity _arity;
    private Object _value;

    public Property(String string, PropertyType propertyType, Object object) {
        this.init(string, propertyType, PropertyArity.SCALAR, object);
    }

    public Property(String string, PropertyType propertyType, PropertyArity propertyArity, Object object) {
        this.init(string, propertyType, propertyArity, object);
    }

    private void init(String string, PropertyType propertyType, PropertyArity propertyArity, Object object) {
        if (object == null) {
            throw new NullPointerException("Null value for Property not permitted");
        }
        if (propertyArity == PropertyArity.SCALAR) {
            if (object instanceof List || object instanceof Map || object instanceof Set) {
                throw new IncompatibleClassChangeError("Wrong class for Scalar Property");
            }
        } else if (propertyArity == PropertyArity.MAP) {
            if (!(object instanceof Map)) {
                throw new IncompatibleClassChangeError("Wrong class for Map Property");
            }
        } else if (propertyArity == PropertyArity.SET) {
            if (!(object instanceof Set)) {
                throw new IncompatibleClassChangeError("Wrong class for Set Property");
            }
        } else if (propertyArity == PropertyArity.LIST && !(object instanceof List)) {
            throw new IncompatibleClassChangeError("Wrong class for List Property");
        }
        this._name = string;
        this._type = propertyType;
        this._arity = propertyArity;
        this._value = object;
    }

    public PropertyArity getArity() {
        return this._arity;
    }

    public Property getByName(String string) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        if (this._name.equals(string)) {
                            return this;
                        }
                        if (this._arity.equals(PropertyArity.SCALAR) || !this._type.equals(PropertyType.PROPERTY)) break block5;
                        if (!this._arity.equals(PropertyArity.ARRAY)) break block6;
                        Property[] propertyArray = (Property[])this._value;
                        for (int i = 0; i < propertyArray.length; ++i) {
                            Property property = propertyArray[i].getByName(string);
                            if (property == null) continue;
                            return property;
                        }
                        break block5;
                    }
                    if (!this._arity.equals(PropertyArity.LIST)) break block7;
                    List list = (List)this._value;
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        Property property = ((Property)list.get(i)).getByName(string);
                        if (property == null) continue;
                        return property;
                    }
                    break block5;
                }
                if (!this._arity.equals(PropertyArity.MAP)) break block8;
                Collection collection = ((Map)this._value).values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Property property = ((Property)iterator.next()).getByName(string);
                    if (property == null) continue;
                    return property;
                }
                break block5;
            }
            if (!this._arity.equals(PropertyArity.SET)) break block5;
            Iterator iterator = ((Set)this._value).iterator();
            while (iterator.hasNext()) {
                Property property = ((Property)iterator.next()).getByName(string);
                if (property == null) continue;
                return property;
            }
        }
        return null;
    }

    public String getName() {
        return this._name;
    }

    public PropertyType getType() {
        return this._type;
    }

    public Object getValue() {
        return this._value;
    }
}

