/*  libtrain
 *  Copyright (c) 2000 ARINO Kazuma & FURUKAWA Yo.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/* $Id: libtrain.h,v 1.1.1.1 2000/05/07 06:44:33 furukawa Exp $ */

#ifndef _LIBTRAIN_
#define _LIBTRAIN_

int
Train_Initialize(void);
void
Train_Finalize(void);
char *
Train_GetTrainDir(void);
void
Train_SetDataFile(char *data_path);
void
Train_SetDepartureTime(int time);
int
Train_GetDepartureTime(void);
int
Train_SetStartPoint(char *start_point);
int
Train_SetEndPoint(char *end_point);
int
Train_Search(int start_id, int end_id);
char *
Train_GetWalkText(void);
char *
Train_GetWaitText(void);
char *
Train_GetJoushaText(void);
char *
Train_GetTotalText(void);
int
Train_GetTotalTime(void);
char *
Train_GetResultText(void);
char *
Train_GetResultItem(int no);
void
Train_SetWalkLimit(int limit);
int
Train_GetWalkLimit(void);
void
Train_SetWaitLimit(int limit);
int
Train_GetWaitLimit(void);
void
Train_SetChangeLimit(int limit);
int
Train_GetChangeLimit(void);
void
Train_SetUseChargedExpress(int use);
int
Train_GetUseChargedExpress(void);
void
Train_SetUseShinkansen(int use);
int
Train_GetUseShinkansen(void);
void
Train_SetUseMisc(int use);
int
Train_GetUseMisc(void);
void
Train_SetStartingWait(int on);
int
Train_GetStartingWait(void);
void
Train_SetDetailed(int on);
int
Train_GetDetailed(void);
int
Train_GetStationCount(void);
char *
Train_GetStationName(int id);
char *
Train_GetStationNameInRoman(int id);
int
Train_GetStationComplementCandidate(char *ss, int ss_len, int *cookie);

#endif
