#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Friday 31 July 2009 11:34:10 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/mol2plv/mol2plv_net.py,v 1.20 2009/09/30 21:06:47 vareille Exp $
#
# $Id: mol2plv_net.py,v 1.20 2009/09/30 21:06:47 vareille Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from MolKit.VisionInterface.MolKitNodes import molkitlib
from Vision.PILNodes import imagelib
from Vision.StandardNodes import stdlib
from symserv.VisionInterface.SymservNodes import symlib
from DejaVu.VisionInterface.DejaVuNodes import vizlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

masterNet.getEditor().addLibraryInstance(symlib,"symserv.VisionInterface.SymservNodes", "symlib")

masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Lines Macro ##
    from MolKit.VisionInterface.MolKitNodes import LinesMacro
    Lines_Macro_0 = LinesMacro(constrkw={}, name='Lines Macro', library=molkitlib)
    masterNet.addNode(Lines_Macro_0,16,116)
    input_Ports_1 = Lines_Macro_0.macroNetwork.ipNode
    apply(input_Ports_1.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    input_Ports_1.move(455, 6)
    output_Ports_2 = Lines_Macro_0.macroNetwork.opNode
    apply(output_Ports_2.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_2.move(252, 370)
    BondsByDist_3 = Lines_Macro_0.macroNetwork.nodes[2]
    BondsByDist_3.inputPortByName['cut_off'].widget.set(1.85, run=False)
    Select_Nodes_4 = Lines_Macro_0.macroNetwork.nodes[3]
    Select_Nodes_4.inputPortByName['nodeType'].widget.set(r"Atom", run=False)
    Select_Nodes_4.inputPortByName['selectionString'].widget.set(r"CA,C,N", run=False)
    code = """def doit(self, molecules, nodeType, selectionString):
    elemType, setType = self.levels[nodeType]
    result = setType([])
    for mol in molecules:
        selnodes = setType(mol.findType(elemType))
        if selectionString:
            selnodes = selnodes.get(selectionString)
        result = result + selnodes
    if len(result):
        result.sort()
        #print '''result''' ,dir(result)
        self.outputData(nodes=result)
"""
    Select_Nodes_4.configure(function=code)
    apply(Select_Nodes_4.configure, (), {'paramPanelImmediate': 1})
    IndexedPolylines_6 = Lines_Macro_0.macroNetwork.nodes[5]
    IndexedPolylines_6.inputPortByName['name'].widget.set(r"", run=False)
    IndexedPolylines_6.inputPortByName['geoms'].widget.set(r"IndexedPolylines", run=False)
    from MolKit.VisionInterface.MolKitNodes import AtomsProperty
    Extract_Atom_Property_7 = AtomsProperty(constrkw={}, name='Extract Atom Property', library=molkitlib)
    Lines_Macro_0.macroNetwork.addNode(Extract_Atom_Property_7,70,239)
    Extract_Atom_Property_7.inputPortByName['propertyName'].widget.set(r"coords[0]", run=False)
    from DejaVu.VisionInterface.DejaVuNodes import ColorMapNE
    Color_Map_8 = ColorMapNE(constrkw={}, name='Color Map', library=vizlib)
    Lines_Macro_0.macroNetwork.addNode(Color_Map_8,289,207)
    Color_Map_8.inputPortByName['colorMap'].widget.set({'mini': -12.817, 'initialValue': None, 'name': 'cmap', 'ramp': [[1.1920928955078125e-07, 0.0, 1.0, 1.0], [0.0, 0.26666653156280518, 1.0, 1.0], [0.0, 0.5333331823348999, 1.0, 1.0], [0.0, 0.79999983310699463, 1.0, 1.0], [0.0, 1.0, 0.93333333730697632, 1.0], [0.0, 1.0, 0.66666668653488159, 1.0], [0.0, 1.0, 0.40000003576278687, 1.0], [0.0, 1.0, 0.13333338499069214, 1.0], [0.13333326578140259, 1.0, 0.0, 1.0], [0.39999991655349731, 1.0, 0.0, 1.0], [0.66666662693023682, 1.0, 0.0, 1.0], [0.93333327770233154, 1.0, 0.0, 1.0], [1.0, 0.80000007152557373, 0.0, 1.0], [1.0, 0.53333336114883423, 0.0, 1.0], [1.0, 0.26666668057441711, 0.0, 1.0], [1.0, 7.7715611723760958e-16, 0.0, 1.0]], 'labelGridCfg': {'column': 0, 'row': 1}, 'maxi': 65.561000000000007, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 0, 'labelSide': 'top', 'row': 2}, 'labelCfg': {'text': 'colormap'}, 'class': 'NEColorMap'}, run=False)
    Color_Map_8.inputPortByName['filename'].widget.set(r"", run=False)

    ## saving connections for network Lines Macro ##
    Lines_Macro_0.macroNetwork.freeze()
    if Select_Nodes_4 is not None and Extract_Atom_Property_7 is not None:
        try:
            Lines_Macro_0.macroNetwork.connectNodes(
                Select_Nodes_4, Extract_Atom_Property_7, "nodes", "atoms", blocking=True
                , splitratio=[0.43628031954108254, 0.24510986687065545])
        except:
            print "WARNING: failed to restore connection between Select_Nodes_4 and Extract_Atom_Property_7 in network Lines_Macro_0.macroNetwork"
    if Extract_Atom_Property_7 is not None and Color_Map_8 is not None:
        try:
            Lines_Macro_0.macroNetwork.connectNodes(
                Extract_Atom_Property_7, Color_Map_8, "propertyValues", "values", blocking=True
                , splitratio=[0.2293159143391188, 0.67313327348815188])
        except:
            print "WARNING: failed to restore connection between Extract_Atom_Property_7 and Color_Map_8 in network Lines_Macro_0.macroNetwork"
    if Color_Map_8 is not None and IndexedPolylines_6 is not None:
        try:
            Lines_Macro_0.macroNetwork.connectNodes(
                Color_Map_8, IndexedPolylines_6, "mappedColors", "colors", blocking=True
                , splitratio=[0.37895297676869732, 0.26723874409767029])
        except:
            print "WARNING: failed to restore connection between Color_Map_8 and IndexedPolylines_6 in network Lines_Macro_0.macroNetwork"
    input_Ports_1 = Lines_Macro_0.macroNetwork.ipNode
    if input_Ports_1 is not None and IndexedPolylines_6 is not None:
        try:
            Lines_Macro_0.macroNetwork.connectNodes(
                input_Ports_1, IndexedPolylines_6, "new", "instanceMatrices", blocking=True
                , splitratio=[0.38312953950246237, 0.52211515214626614])
        except:
            print "WARNING: failed to restore connection between input_Ports_1 and IndexedPolylines_6 in network Lines_Macro_0.macroNetwork"
    output_Ports_2 = Lines_Macro_0.macroNetwork.opNode
    if Color_Map_8 is not None and output_Ports_2 is not None:
        try:
            Lines_Macro_0.macroNetwork.connectNodes(
                Color_Map_8, output_Ports_2, "legend", "new", blocking=True
                , splitratio=[0.59671894880662957, 0.30144798115866822])
        except:
            print "WARNING: failed to restore connection between Color_Map_8 and output_Ports_2 in network Lines_Macro_0.macroNetwork"
    Lines_Macro_0.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_1.outputPorts[1].configure(name='BondsByDist_molecules')
    input_Ports_1.outputPorts[2].configure(name='IndexedPolylines_instanceMatrices')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_2.inputPorts[1].configure(singleConnection=True)
    output_Ports_2.inputPorts[2].configure(singleConnection='auto')
    output_Ports_2.inputPorts[1].configure(name='IndexedPolylines_indexedPolylines')
    output_Ports_2.inputPorts[2].configure(name='Color_Map_legend')
    Lines_Macro_0.inputPorts[0].configure(name='BondsByDist_molecules')
    Lines_Macro_0.inputPorts[0].configure(datatype='MoleculeSet')
    Lines_Macro_0.inputPorts[1].configure(name='IndexedPolylines_instanceMatrices')
    Lines_Macro_0.inputPorts[1].configure(datatype='instancemat(0)')
    ## configure MacroNode input ports
    Lines_Macro_0.outputPorts[0].configure(name='IndexedPolylines_indexedPolylines')
    Lines_Macro_0.outputPorts[0].configure(datatype='geomOrInsert2d')
    Lines_Macro_0.outputPorts[1].configure(name='Color_Map_legend')
    Lines_Macro_0.outputPorts[1].configure(datatype='geom')
    ## configure MacroNode output ports
    Lines_Macro_0.shrink()
except:
    print "WARNING: failed to restore LinesMacro named Lines Macro in network masterNet"
    print_exc()
    Lines_Macro_0=None

try:
    ## saving node Read Molecule ##
    from MolKit.VisionInterface.MolKitNodes import ReadMolecule
    Read_Molecule_9 = ReadMolecule(constrkw={}, name='Read Molecule', library=molkitlib)
    masterNet.addNode(Read_Molecule_9,16,10)
    Read_Molecule_9.inputPortByName['filename'].widget.set(r"2plv.pdb", run=False)
except:
    print "WARNING: failed to restore ReadMolecule named Read Molecule in network masterNet"
    print_exc()
    Read_Molecule_9=None

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_10 = Viewer(constrkw={}, name='Viewer', library=vizlib)
    masterNet.addNode(Viewer_10,25,185)
    apply(Viewer_10.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    ##
        ## Saving State for Viewer
    Viewer_10.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 874, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 49, 'd1scale': 0.012999999999999999}
    apply(Viewer_10.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(Viewer_10.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [-0.83141613, 0.32278553, -0.45227939, 0.0, -0.49707243, -0.79583555, 0.34578148, 0.0, -0.24832679, 0.51230395, 0.82211834, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.029604685, 0.029604685, 0.029604685], 'lighting': False, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-0.043005124, -0.0085970098, 0.074012324], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(Viewer_10.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Viewer_10.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_10.vi.rootObject:
        Viewer_10.vi.rootObject.clipP = []
        Viewer_10.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_10=None

try:
    ## saving node Icosahedral1 ##
    from symserv.VisionInterface.SymservNodes import Icos1
    Icosahedral1_11 = Icos1(constrkw={}, name='Icosahedral1', library=symlib)
    masterNet.addNode(Icosahedral1_11,116,131)
    Icosahedral1_11.macroNetwork.deleteConnection(Icosahedral1_11.macroNetwork.nodes[2], 'outMatrices', Icosahedral1_11.macroNetwork.nodes[3], 'matrices')
    input_Ports_12 = Icosahedral1_11.macroNetwork.ipNode
    apply(input_Ports_12.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    input_Ports_12.move(103, 16)
    output_Ports_13 = Icosahedral1_11.macroNetwork.opNode
    apply(output_Ports_13.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_13.move(120, 370)
    _5_fold_14 = Icosahedral1_11.macroNetwork.nodes[2]
    _5_fold_14.inputPortByName['vector'].widget.set([0.0, 0.52549288072191591, 0.85079799735929229], run=False)
    _5_fold_14.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _5_fold_14.inputPortByName['identity'].widget.set(1, run=False)
    _3_fold_15 = Icosahedral1_11.macroNetwork.nodes[3]
    _3_fold_15.inputPortByName['vector'].widget.set([0.57735026918962584, 0.57735026918962584, 0.57735026918962584], run=False)
    _3_fold_15.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _3_fold_15.inputPortByName['identity'].widget.set(1, run=False)
    _2_fold_16 = Icosahedral1_11.macroNetwork.nodes[4]
    _2_fold_16.inputPortByName['vector'].widget.set([1.0, 0.0, 0.0], run=False)
    _2_fold_16.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _2_fold_16.inputPortByName['identity'].widget.set(1, run=False)
    _2_fold_17 = Icosahedral1_11.macroNetwork.nodes[5]
    _2_fold_17.inputPortByName['vector'].widget.set([0.0, 0.0, 1.0], run=False)
    _2_fold_17.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _2_fold_17.inputPortByName['identity'].widget.set(0, run=False)
    _2_fold_18 = Icosahedral1_11.macroNetwork.nodes[6]
    _2_fold_18.inputPortByName['vector'].widget.set([0.0, 1.0, 0.0], run=False)
    _2_fold_18.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _2_fold_18.inputPortByName['identity'].widget.set(0, run=False)
    from symserv.VisionInterface.SymservNodes import SymTransNE
    Translate_20 = SymTransNE(constrkw={}, name='Translate', library=symlib)
    Icosahedral1_11.macroNetwork.addNode(Translate_20,103,107)
    apply(Translate_20.inputPortByName['length'].configure, (), {'datatype': 'int', 'originalDatatype': 'None', 'height': 8})
    Translate_20.inputPortByName['vector'].widget.set([0.0, 0.52504568096145199, 0.85107404666322961], run=False)
    Translate_20.inputPortByName['length'].rebindWidget()
    Translate_20.inputPortByName['length'].widget.set(422.694666667, run=False)
    Translate_20.inputPortByName['length'].unbindWidget()
    Translate_20.inputPortByName['identity'].widget.set(0, run=False)

    ## saving connections for network Icosahedral1 ##
    Icosahedral1_11.macroNetwork.freeze()
    if Translate_20 is not None and _3_fold_15 is not None:
        try:
            Icosahedral1_11.macroNetwork.connectNodes(
                Translate_20, _3_fold_15, "outMatrices", "matrices", blocking=True
                , splitratio=[0.28218455307302576, 0.3616265608512963])
        except:
            print "WARNING: failed to restore connection between Translate_20 and _3_fold_15 in network Icosahedral1_11.macroNetwork"
    if _5_fold_14 is not None and Translate_20 is not None:
        try:
            Icosahedral1_11.macroNetwork.connectNodes(
                _5_fold_14, Translate_20, "outMatrices", "matrices", blocking=True
                , splitratio=[0.49930243705750793, 0.65443669135336968])
        except:
            print "WARNING: failed to restore connection between _5_fold_14 and Translate_20 in network Icosahedral1_11.macroNetwork"
    input_Ports_12 = Icosahedral1_11.macroNetwork.ipNode
    if input_Ports_12 is not None and Translate_20 is not None:
        try:
            Icosahedral1_11.macroNetwork.connectNodes(
                input_Ports_12, Translate_20, "new", "length", blocking=True
                , splitratio=[0.47716543511697052, 0.21991339990237935])
        except:
            print "WARNING: failed to restore connection between input_Ports_12 and Translate_20 in network Icosahedral1_11.macroNetwork"
    Icosahedral1_11.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_12.outputPorts[1].configure(name='Translate_length')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_13 = Icosahedral1_11.macroNetwork.opNode
    output_Ports_13.inputPorts[1].configure(singleConnection=True)
    output_Ports_13.inputPorts[1].configure(name='Merge_outMatrices')
    Icosahedral1_11.inputPorts[0].configure(name='Translate_length')
    Icosahedral1_11.inputPorts[0].configure(datatype='int')
    ## configure MacroNode input ports
    Icosahedral1_11.outputPorts[0].configure(name='Merge_outMatrices')
    Icosahedral1_11.outputPorts[0].configure(datatype='instancemat(0)')
    ## configure MacroNode output ports
    Icosahedral1_11.shrink()
except:
    print "WARNING: failed to restore Icos1 named Icosahedral1 in network masterNet"
    print_exc()
    Icosahedral1_11=None

try:
    ## saving node Save Image ##
    from Vision.PILNodes import SaveImage
    Save_Image_21 = SaveImage(constrkw={}, name='Save Image', library=imagelib)
    masterNet.addNode(Save_Image_21,117,323)
    apply(Save_Image_21.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Save_Image_21.inputPortByName['filename'].rebindWidget()
    Save_Image_21.inputPortByName['filename'].widget.set(r"", run=False)
    Save_Image_21.inputPortByName['filename'].unbindWidget()
    apply(Save_Image_21.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore SaveImage named Save Image in network masterNet"
    print_exc()
    Save_Image_21=None

try:
    ## saving node Grab Image ##
    from Vision.PILNodes import GetFrontBuffer
    Grab_Image_22 = GetFrontBuffer(constrkw={}, name='Grab Image', library=imagelib)
    masterNet.addNode(Grab_Image_22,99,256)
    apply(Grab_Image_22.configure, (), {'specialPortsVisible': True})
    apply(Grab_Image_22.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore GetFrontBuffer named Grab Image in network masterNet"
    print_exc()
    Grab_Image_22=None

try:
    ## saving node Filename ##
    from Vision.StandardNodes import Filename
    Filename_23 = Filename(constrkw={}, name='Filename', library=stdlib)
    masterNet.addNode(Filename_23,201,224)
    Filename_23.inputPortByName['format'].widget.set(r"../outputfiles/file%03d.png", run=False)
    apply(Filename_23.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Filename named Filename in network masterNet"
    print_exc()
    Filename_23=None

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_24 = Iterate(constrkw={}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_24,184,73)
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_24=None

try:
    ## saving node range ##
    from Vision.StandardNodes import Range
    range_25 = Range(constrkw={}, name='range', library=stdlib)
    masterNet.addNode(range_25,301,34)
    range_25.inputPortByName['fromInd'].widget.set(0, run=False)
    range_25.inputPortByName['toInd'].widget.set(99, run=False)
    range_25.inputPortByName['step'].widget.set(1, run=False)
    apply(range_25.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Range named range in network masterNet"
    print_exc()
    range_25=None

try:
    ## saving node One Redraw ##
    from DejaVu.VisionInterface.DejaVuNodes import OneRedraw
    One_Redraw_27 = OneRedraw(constrkw={}, name='One Redraw', library=vizlib)
    masterNet.addNode(One_Redraw_27,6,261)
    apply(One_Redraw_27.configure, (), {'specialPortsVisible': True})
    apply(One_Redraw_27.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore OneRedraw named One Redraw in network masterNet"
    print_exc()
    One_Redraw_27=None

#masterNet.run()
masterNet.freeze()

## saving connections for network mol2plv ##
if Lines_Macro_0 is not None and Viewer_10 is not None:
    try:
        masterNet.connectNodes(
            Lines_Macro_0, Viewer_10, "IndexedPolylines_indexedPolylines", "geometries", blocking=True
            , splitratio=[1.0, 0.53914037080420418])
    except:
        print "WARNING: failed to restore connection between Lines_Macro_0 and Viewer_10 in network masterNet"
if Read_Molecule_9 is not None and Lines_Macro_0 is not None:
    try:
        masterNet.connectNodes(
            Read_Molecule_9, Lines_Macro_0, "MolSets", "BondsByDist_molecules", blocking=True
            , splitratio=[0.57840236238919163, 0.34434237262080525])
    except:
        print "WARNING: failed to restore connection between Read_Molecule_9 and Lines_Macro_0 in network masterNet"
if Icosahedral1_11 is not None and Lines_Macro_0 is not None:
    try:
        masterNet.connectNodes(
            Icosahedral1_11, Lines_Macro_0, "Merge_outMatrices", "IndexedPolylines_instanceMatrices", blocking=True
            , splitratio=[0.40553039863895235, 0.49896343611925659])
    except:
        print "WARNING: failed to restore connection between Icosahedral1_11 and Lines_Macro_0 in network masterNet"
if Grab_Image_22 is not None and Save_Image_21 is not None:
    try:
        masterNet.connectNodes(
            Grab_Image_22, Save_Image_21, "image", "image", blocking=True
            , splitratio=[0.46054156676999247, 0.70239193684586421])
    except:
        print "WARNING: failed to restore connection between Grab_Image_22 and Save_Image_21 in network masterNet"
if Filename_23 is not None and Save_Image_21 is not None:
    try:
        masterNet.connectNodes(
            Filename_23, Save_Image_21, "filename", "filename", blocking=True
            , splitratio=[0.68965708243689394, 0.49291527797231793])
    except:
        print "WARNING: failed to restore connection between Filename_23 and Save_Image_21 in network masterNet"
if Viewer_10 is not None and Grab_Image_22 is not None:
    try:
        masterNet.connectNodes(
            Viewer_10, Grab_Image_22, "dejaVuViewer", "viewer", blocking=True
            , splitratio=[0.49305988702225056, 0.30817723512506751])
    except:
        print "WARNING: failed to restore connection between Viewer_10 and Grab_Image_22 in network masterNet"
if iterate_24 is not None and Icosahedral1_11 is not None:
    try:
        masterNet.connectNodes(
            iterate_24, Icosahedral1_11, "oneItem", "Translate_length", blocking=True
            , splitratio=[0.37619226355437047, 0.62519747747114929])
    except:
        print "WARNING: failed to restore connection between iterate_24 and Icosahedral1_11 in network masterNet"
if range_25 is not None and iterate_24 is not None:
    try:
        masterNet.connectNodes(
            range_25, iterate_24, "data", "listToLoopOver", blocking=True
            , splitratio=[0.22201371658857083, -0.17857142857142858])
    except:
        print "WARNING: failed to restore connection between range_25 and iterate_24 in network masterNet"
if iterate_24 is not None and Filename_23 is not None:
    try:
        masterNet.connectNodes(
            iterate_24, Filename_23, "iter", "number", blocking=True
            , splitratio=[0.51392547610733053, 0.23384797945675395])
    except:
        print "WARNING: failed to restore connection between iterate_24 and Filename_23 in network masterNet"
if Viewer_10 is not None and One_Redraw_27 is not None:
    try:
        masterNet.connectNodes(
            Viewer_10, One_Redraw_27, "dejaVuViewer", "viewer", blocking=True
            , splitratio=[0.49277608263156208, 0.61039706968871088])
    except:
        print "WARNING: failed to restore connection between Viewer_10 and One_Redraw_27 in network masterNet"
if Viewer_10 is not None and One_Redraw_27 is not None:
    try:
        masterNet.connectNodes(
            Viewer_10, One_Redraw_27, "dejaVuViewer", "trigger", blocking=True
            , splitratio=[0.2457237983461045, 0.48064588371408845])
    except:
        print "WARNING: failed to restore connection between Viewer_10 and One_Redraw_27 in network masterNet"
if One_Redraw_27 is not None and Grab_Image_22 is not None:
    try:
        masterNet.specialConnectNodes(
            One_Redraw_27, Grab_Image_22, "trigger", "runNode", blocking=True
            , splitratio=[0.56590178128856405, 0.38665105661960786])
    except:
        print "WARNING: failed to restore connection between One_Redraw_27 and Grab_Image_22 in network masterNet"
masterNet.runOnNewData.value = False


def loadSavedStates_Viewer_10(self=Viewer_10, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|cmap
    state = {'needsRedoDpyListOnResize': True, 'name': 'cmap', 'replace': False, 'visible': 1, 'immediateRendering': False, 'listed': True, 'anchor': [1, 0], 'position': [1, 0], 'protected': False, 'transparent': True, 'pickable': True, 'size': [12, 120]}
    obj = self.vi.FindObjectByName('root|cmap')
    if obj:
        apply(obj.Set, (), state)

    ## Object root|IndexedPolylines
    ## End Object root|IndexedPolylines

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [-0.83141613, 0.32278553, -0.45227939, 0.0, -0.49707243, -0.79583555, 0.34578148, 0.0, -0.24832679, 0.51230395, 0.82211834, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.029604685, 0.029604685, 0.029604685], 'lighting': False, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-0.043005124, -0.0085970098, 0.074012324], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_10.restoreStates_cb = Viewer_10.restoreStatesFirstRun = loadSavedStates_Viewer_10
Viewer_10.menu.add_separator()
Viewer_10.menu.add_command(label='Restore states', command=Viewer_10.restoreStates_cb)

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 0) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

