#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Interactive Adventures of Dog Mendonça and Pizzaboy
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220708.1

GAME_ID='the-interactive-adventures-of-dog-mendonca-and-pizzaboy'
GAME_NAME='The Interactive Adventures of Dog Mendonça and Pizzaboy'

ARCHIVE_BASE_0='gog_the_interactive_adventures_of_dog_mendon_a_and_pizzaboy_2.0.0.1.sh'
ARCHIVE_BASE_0_MD5='88c5bb7a410fbf2eb0cc124c3ce06fa0'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='500000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.1'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_interactive_adventures_of_dog_mendonca_and_pizzaboy'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_BIN32_FILES='
godot.x11.opt.32'
ARCHIVE_GAME_BIN64_FILES='
godot.x11.opt.64'
ARCHIVE_GAME_DATA_FILES='
data.pck'

APP_MAIN_TYPE='native'
APP_MAIN_EXE_BIN32='godot.x11.opt.32'
APP_MAIN_EXE_BIN64='godot.x11.opt.64'
APP_MAIN_ICON="${CONTENT_PATH_DEFAULT}/../support/icon.png"

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libGLU.so.1 xcursor"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Include game icon

PKG='PKG_DATA'
icons_get_from_workdir 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
