#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Roadwarden
###

script_version=20231001.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='roadwarden'
GAME_NAME='Roadwarden'

ARCHIVE_BASE_4_NAME='roadwarden_1_1_31_67621.sh'
ARCHIVE_BASE_4_MD5='c5ce0e6b2b92a0ca49ab0bd06e018957'
ARCHIVE_BASE_4_SIZE='867056'
ARCHIVE_BASE_4_VERSION='1.1.31-gog67621'
ARCHIVE_BASE_4_URL='https://www.gog.com/game/roadwarden'

ARCHIVE_BASE_3_NAME='roadwarden_1_1_2_67478.sh'
ARCHIVE_BASE_3_MD5='f62eb9f3027ea9b6fb4f76b87cc71471'
ARCHIVE_BASE_3_SIZE='867052'
ARCHIVE_BASE_3_VERSION='1.1.2-gog67478'

ARCHIVE_BASE_2_NAME='roadwarden_1_0_92_63495.sh'
ARCHIVE_BASE_2_MD5='1808e2f215bdca65324b909f2706574b'
ARCHIVE_BASE_2_SIZE='870000'
ARCHIVE_BASE_2_VERSION='1.0.92-gog63495'

ARCHIVE_BASE_1_NAME='roadwarden_1_0_9_62941.sh'
ARCHIVE_BASE_1_MD5='4fa5f13a40a2ae3e287493298e326e96'
ARCHIVE_BASE_1_SIZE='870000'
ARCHIVE_BASE_1_VERSION='1.0.9-gog62941'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/roadwarden'

ARCHIVE_BASE_0_NAME='roadwarden_1_0_8_61761.sh'
ARCHIVE_BASE_0_MD5='659218d7803632a38f8e72e4f4f83a26'
ARCHIVE_BASE_0_SIZE='870000'
ARCHIVE_BASE_0_VERSION='1.0.8-gog61761'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/lib/py2-linux-x86_64"
CONTENT_LIBS_BIN_FILES='
librenpython.so'
CONTENT_GAME_BIN_FILES='
lib/py2-linux-x86_64/Roadwarden
lib/py2-linux-x86_64/python
lib/py2-linux-x86_64/pythonw
lib/py2-linux-x86_64/zsync
lib/py2-linux-x86_64/zsyncmake'
CONTENT_GAME_DATA_FILES='
game
renpy
lib/python2.7
Roadwarden.py'
CONTENT_FONTS_DATA_PATH="${CONTENT_PATH_DEFAULT}/game"
CONTENT_FONTS_DATA_FILES='
munro.ttf
philosopher.ttf'

APP_MAIN_EXE='lib/py2-linux-x86_64/Roadwarden'
APP_MAIN_ICON='../support/icon.png'
## The game crashes on launch when SDL_VIDEODRIVER is set to "wayland".
APP_MAIN_PRERUN='# The game crashes on launch when SDL_VIDEODRIVER is set to "wayland".
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libGL.so.1
libm.so.6
libpthread.so.0
libutil.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Link the fonts into the game directory, or the engine would fail to find them.

## TODO: The library should provide a function path_fonts (or path_fonts_ttf?) returning this path.
PATH_FONTS="$(option_value 'prefix')/share/fonts/truetype/$(game_id)"
game_data_path="$(package_path 'PKG_DATA')$(path_game_data)/game"
mkdir --parents "$game_data_path"
ln --symbolic \
	"${PATH_FONTS}/munro.ttf" \
	"${PATH_FONTS}/philosopher.ttf" \
	"$game_data_path"

# Extract game data

archive_extraction_default

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion 'FONTS_DATA' 'PKG_DATA' "$PATH_FONTS"
content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
