# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to LG phones"""

from prototypes import *
import re

# We use LSB for all integer like fields
UINT=UINTlsb
BOOL=BOOLlsb

class pbheader(BaseProtogenClass):
    __fields=['pbmode', 'command', 'sequence', 'flag']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbheader,self).__init__(**dict)
        if self.__class__ is pbheader:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbheader,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbheader,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_pbmode
        except:
            self.__field_pbmode=UINT(**{'sizeinbytes': 1, 'constant': 0xff})
        self.__field_pbmode.writetobuffer(buf)
        self.__field_command.writetobuffer(buf)
        self.__field_sequence.writetobuffer(buf)
        self.__field_flag.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbmode=UINT(**{'sizeinbytes': 1, 'constant': 0xff})
        self.__field_pbmode.readfrombuffer(buf)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self.__field_sequence=UINT(**{'sizeinbytes': 1})
        self.__field_sequence.readfrombuffer(buf)
        self.__field_flag=UINT(**{'sizeinbytes': 1})
        self.__field_flag.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbmode(self):
        try: self.__field_pbmode
        except:
            self.__field_pbmode=UINT(**{'sizeinbytes': 1, 'constant': 0xff})
        return self.__field_pbmode.getvalue()

    def __setfield_pbmode(self, value):
        if isinstance(value,UINT):
            self.__field_pbmode=value
        else:
            self.__field_pbmode=UINT(value,**{'sizeinbytes': 1, 'constant': 0xff})

    def __delfield_pbmode(self): del self.__field_pbmode

    pbmode=property(__getfield_pbmode, __setfield_pbmode, __delfield_pbmode, None)

    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_sequence(self):
        return self.__field_sequence.getvalue()

    def __setfield_sequence(self, value):
        if isinstance(value,UINT):
            self.__field_sequence=value
        else:
            self.__field_sequence=UINT(value,**{'sizeinbytes': 1})

    def __delfield_sequence(self): del self.__field_sequence

    sequence=property(__getfield_sequence, __setfield_sequence, __delfield_sequence, None)

    def __getfield_flag(self):
        return self.__field_flag.getvalue()

    def __setfield_flag(self, value):
        if isinstance(value,UINT):
            self.__field_flag=value
        else:
            self.__field_flag=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag(self): del self.__field_flag

    flag=property(__getfield_flag, __setfield_flag, __delfield_flag, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbmode', self.__field_pbmode, None)
        yield ('command', self.__field_command, None)
        yield ('sequence', self.__field_sequence, None)
        yield ('flag', self.__field_flag, None)




class pbstartsyncrequest(BaseProtogenClass):
    __fields=['header', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbstartsyncrequest,self).__init__(**dict)
        if self.__class__ is pbstartsyncrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbstartsyncrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbstartsyncrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x00, 'flag': 0x01})
        self.__field_header.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 250})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader(**{'command': 0x00, 'flag': 0x01})
        self.__field_header.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 250})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x00, 'flag': 0x01})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,**{'command': 0x00, 'flag': 0x01})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 250})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 250})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('pad', self.__field_pad, None)




class pbstartsyncresponse(BaseProtogenClass):
    __fields=['header', 'unknown']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbstartsyncresponse,self).__init__(**dict)
        if self.__class__ is pbstartsyncresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbstartsyncresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbstartsyncresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_unknown.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_unknown=UNKNOWN()
        self.__field_unknown.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_unknown(self):
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown=value
        else:
            self.__field_unknown=UNKNOWN(value,)

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('unknown', self.__field_unknown, None)




class pbendsyncrequest(BaseProtogenClass):
    __fields=['header', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbendsyncrequest,self).__init__(**dict)
        if self.__class__ is pbendsyncrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbendsyncrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbendsyncrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x07, 'flag': 0x01})
        self.__field_header.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader(**{'command': 0x07, 'flag': 0x01})
        self.__field_header.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x07, 'flag': 0x01})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,**{'command': 0x07, 'flag': 0x01})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 6})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('pad', self.__field_pad, None)




class pbendsyncresponse(BaseProtogenClass):
    __fields=['header', 'unknown']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbendsyncresponse,self).__init__(**dict)
        if self.__class__ is pbendsyncresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbendsyncresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbendsyncresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_unknown.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_unknown=UNKNOWN()
        self.__field_unknown.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_unknown(self):
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown=value
        else:
            self.__field_unknown=UNKNOWN(value,)

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('unknown', self.__field_unknown, None)




class pbinforequest(BaseProtogenClass):
    "Random information about the phone"
    __fields=['header', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbinforequest,self).__init__(**dict)
        if self.__class__ is pbinforequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbinforequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbinforequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x15, 'flag': 0x01})
        self.__field_header.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader(**{'command': 0x15, 'flag': 0x01})
        self.__field_header.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x15, 'flag': 0x01})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,**{'command': 0x15, 'flag': 0x01})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 6})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('pad', self.__field_pad, None)




class pbinforesponse(BaseProtogenClass):
    __fields=['header', 'dunno1', 'something1', 'firstentry', 'dunno2', 'numentries', 'dunno3', 'lastentry', 'dunno4', 'esn', 'phonesoftware']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbinforesponse,self).__init__(**dict)
        if self.__class__ is pbinforesponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbinforesponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbinforesponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_something1.writetobuffer(buf)
        self.__field_firstentry.writetobuffer(buf)
        self.__field_dunno2.writetobuffer(buf)
        self.__field_numentries.writetobuffer(buf)
        self.__field_dunno3.writetobuffer(buf)
        self.__field_lastentry.writetobuffer(buf)
        self.__field_dunno4.writetobuffer(buf)
        self.__field_esn.writetobuffer(buf)
        self.__field_phonesoftware.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 4})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_something1=UINT(**{'sizeinbytes': 2})
        self.__field_something1.readfrombuffer(buf)
        self.__field_firstentry=UINT(**{'sizeinbytes': 4})
        self.__field_firstentry.readfrombuffer(buf)
        self.__field_dunno2=UNKNOWN(**{'sizeinbytes': 4})
        self.__field_dunno2.readfrombuffer(buf)
        self.__field_numentries=UINT(**{'sizeinbytes': 4})
        self.__field_numentries.readfrombuffer(buf)
        self.__field_dunno3=UNKNOWN(**{'sizeinbytes': 20})
        self.__field_dunno3.readfrombuffer(buf)
        self.__field_lastentry=UINT(**{'sizeinbytes': 4})
        self.__field_lastentry.readfrombuffer(buf)
        self.__field_dunno4=UNKNOWN(**{'sizeinbytes': 20})
        self.__field_dunno4.readfrombuffer(buf)
        self.__field_esn=UINT(**{'sizeinbytes': 4})
        self.__field_esn.readfrombuffer(buf)
        self.__field_phonesoftware=USTRING()
        self.__field_phonesoftware.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 4})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_something1(self):
        return self.__field_something1.getvalue()

    def __setfield_something1(self, value):
        if isinstance(value,UINT):
            self.__field_something1=value
        else:
            self.__field_something1=UINT(value,**{'sizeinbytes': 2})

    def __delfield_something1(self): del self.__field_something1

    something1=property(__getfield_something1, __setfield_something1, __delfield_something1, None)

    def __getfield_firstentry(self):
        return self.__field_firstentry.getvalue()

    def __setfield_firstentry(self, value):
        if isinstance(value,UINT):
            self.__field_firstentry=value
        else:
            self.__field_firstentry=UINT(value,**{'sizeinbytes': 4})

    def __delfield_firstentry(self): del self.__field_firstentry

    firstentry=property(__getfield_firstentry, __setfield_firstentry, __delfield_firstentry, None)

    def __getfield_dunno2(self):
        return self.__field_dunno2.getvalue()

    def __setfield_dunno2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno2=value
        else:
            self.__field_dunno2=UNKNOWN(value,**{'sizeinbytes': 4})

    def __delfield_dunno2(self): del self.__field_dunno2

    dunno2=property(__getfield_dunno2, __setfield_dunno2, __delfield_dunno2, None)

    def __getfield_numentries(self):
        return self.__field_numentries.getvalue()

    def __setfield_numentries(self, value):
        if isinstance(value,UINT):
            self.__field_numentries=value
        else:
            self.__field_numentries=UINT(value,**{'sizeinbytes': 4})

    def __delfield_numentries(self): del self.__field_numentries

    numentries=property(__getfield_numentries, __setfield_numentries, __delfield_numentries, None)

    def __getfield_dunno3(self):
        return self.__field_dunno3.getvalue()

    def __setfield_dunno3(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno3=value
        else:
            self.__field_dunno3=UNKNOWN(value,**{'sizeinbytes': 20})

    def __delfield_dunno3(self): del self.__field_dunno3

    dunno3=property(__getfield_dunno3, __setfield_dunno3, __delfield_dunno3, None)

    def __getfield_lastentry(self):
        return self.__field_lastentry.getvalue()

    def __setfield_lastentry(self, value):
        if isinstance(value,UINT):
            self.__field_lastentry=value
        else:
            self.__field_lastentry=UINT(value,**{'sizeinbytes': 4})

    def __delfield_lastentry(self): del self.__field_lastentry

    lastentry=property(__getfield_lastentry, __setfield_lastentry, __delfield_lastentry, None)

    def __getfield_dunno4(self):
        return self.__field_dunno4.getvalue()

    def __setfield_dunno4(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno4=value
        else:
            self.__field_dunno4=UNKNOWN(value,**{'sizeinbytes': 20})

    def __delfield_dunno4(self): del self.__field_dunno4

    dunno4=property(__getfield_dunno4, __setfield_dunno4, __delfield_dunno4, None)

    def __getfield_esn(self):
        return self.__field_esn.getvalue()

    def __setfield_esn(self, value):
        if isinstance(value,UINT):
            self.__field_esn=value
        else:
            self.__field_esn=UINT(value,**{'sizeinbytes': 4})

    def __delfield_esn(self): del self.__field_esn

    esn=property(__getfield_esn, __setfield_esn, __delfield_esn, None)

    def __getfield_phonesoftware(self):
        return self.__field_phonesoftware.getvalue()

    def __setfield_phonesoftware(self, value):
        if isinstance(value,USTRING):
            self.__field_phonesoftware=value
        else:
            self.__field_phonesoftware=USTRING(value,)

    def __delfield_phonesoftware(self): del self.__field_phonesoftware

    phonesoftware=property(__getfield_phonesoftware, __setfield_phonesoftware, __delfield_phonesoftware, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('something1', self.__field_something1, None)
        yield ('firstentry', self.__field_firstentry, None)
        yield ('dunno2', self.__field_dunno2, None)
        yield ('numentries', self.__field_numentries, None)
        yield ('dunno3', self.__field_dunno3, None)
        yield ('lastentry', self.__field_lastentry, None)
        yield ('dunno4', self.__field_dunno4, None)
        yield ('esn', self.__field_esn, None)
        yield ('phonesoftware', self.__field_phonesoftware, None)




class pbinitrequest(BaseProtogenClass):
    "Moves cursor to begining of phonebook"
    __fields=['header', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbinitrequest,self).__init__(**dict)
        if self.__class__ is pbinitrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbinitrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbinitrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x11, 'flag': 0x01})
        self.__field_header.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader(**{'command': 0x11, 'flag': 0x01})
        self.__field_header.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x11, 'flag': 0x01})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,**{'command': 0x11, 'flag': 0x01})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 6})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('pad', self.__field_pad, None)




class pbinitresponse(BaseProtogenClass):
    __fields=['header', 'dunno']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbinitresponse,self).__init__(**dict)
        if self.__class__ is pbinitresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbinitresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbinitresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_dunno.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_dunno=UNKNOWN()
        self.__field_dunno.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_dunno(self):
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno=value
        else:
            self.__field_dunno=UNKNOWN(value,)

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('dunno', self.__field_dunno, None)




class pbreadentryrequest(BaseProtogenClass):
    __fields=['header', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbreadentryrequest,self).__init__(**dict)
        if self.__class__ is pbreadentryrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbreadentryrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbreadentryrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x13, 'flag': 0x01})
        self.__field_header.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader(**{'command': 0x13, 'flag': 0x01})
        self.__field_header.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x13, 'flag': 0x01})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,**{'command': 0x13, 'flag': 0x01})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 6})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('pad', self.__field_pad, None)




class pbnextentryrequest(BaseProtogenClass):
    __fields=['header', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbnextentryrequest,self).__init__(**dict)
        if self.__class__ is pbnextentryrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbnextentryrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbnextentryrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x12, 'flag': 0x01})
        self.__field_header.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader(**{'command': 0x12, 'flag': 0x01})
        self.__field_header.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x12, 'flag': 0x01})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,**{'command': 0x12, 'flag': 0x01})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 6})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 6})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('pad', self.__field_pad, None)




class pbnextentryresponse(BaseProtogenClass):
    __fields=['header', 'serial', 'datalen', 'data', 'randomgunk']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbnextentryresponse,self).__init__(**dict)
        if self.__class__ is pbnextentryresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbnextentryresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbnextentryresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_serial.writetobuffer(buf)
        self.__field_datalen.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self.__field_randomgunk.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_serial=UINT(**{'sizeinbytes': 4})
        self.__field_serial.readfrombuffer(buf)
        self.__field_datalen=UINT(**{'sizeinbytes': 2})
        self.__field_datalen.readfrombuffer(buf)
        self.__field_data=DATA(**{'sizeinbytes': self.datalen})
        self.__field_data.readfrombuffer(buf)
        self.__field_randomgunk=UNKNOWN()
        self.__field_randomgunk.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_serial(self):
        return self.__field_serial.getvalue()

    def __setfield_serial(self, value):
        if isinstance(value,UINT):
            self.__field_serial=value
        else:
            self.__field_serial=UINT(value,**{'sizeinbytes': 4})

    def __delfield_serial(self): del self.__field_serial

    serial=property(__getfield_serial, __setfield_serial, __delfield_serial, None)

    def __getfield_datalen(self):
        return self.__field_datalen.getvalue()

    def __setfield_datalen(self, value):
        if isinstance(value,UINT):
            self.__field_datalen=value
        else:
            self.__field_datalen=UINT(value,**{'sizeinbytes': 2})

    def __delfield_datalen(self): del self.__field_datalen

    datalen=property(__getfield_datalen, __setfield_datalen, __delfield_datalen, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,**{'sizeinbytes': self.datalen})

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def __getfield_randomgunk(self):
        return self.__field_randomgunk.getvalue()

    def __setfield_randomgunk(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_randomgunk=value
        else:
            self.__field_randomgunk=UNKNOWN(value,)

    def __delfield_randomgunk(self): del self.__field_randomgunk

    randomgunk=property(__getfield_randomgunk, __setfield_randomgunk, __delfield_randomgunk, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('serial', self.__field_serial, None)
        yield ('datalen', self.__field_datalen, None)
        yield ('data', self.__field_data, None)
        yield ('randomgunk', self.__field_randomgunk, None)




class pbdeleteentryrequest(BaseProtogenClass):
    __fields=['header', 'serial1', 'unknown', 'serial2', 'entrynumber']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbdeleteentryrequest,self).__init__(**dict)
        if self.__class__ is pbdeleteentryrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbdeleteentryrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbdeleteentryrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x05, 'flag': 0x01})
        self.__field_header.writetobuffer(buf)
        self.__field_serial1.writetobuffer(buf)
        try: self.__field_unknown
        except:
            self.__field_unknown=UINT(**{'sizeinbytes': 2, 'constant': 0x0000})
        self.__field_unknown.writetobuffer(buf)
        self.__field_serial2.writetobuffer(buf)
        self.__field_entrynumber.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader(**{'command': 0x05, 'flag': 0x01})
        self.__field_header.readfrombuffer(buf)
        self.__field_serial1=UINT(**{'sizeinbytes': 4})
        self.__field_serial1.readfrombuffer(buf)
        self.__field_unknown=UINT(**{'sizeinbytes': 2, 'constant': 0x0000})
        self.__field_unknown.readfrombuffer(buf)
        self.__field_serial2=UINT(**{'sizeinbytes': 4})
        self.__field_serial2.readfrombuffer(buf)
        self.__field_entrynumber=UINT(**{'sizeinbytes': 2})
        self.__field_entrynumber.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=pbheader(**{'command': 0x05, 'flag': 0x01})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,**{'command': 0x05, 'flag': 0x01})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_serial1(self):
        return self.__field_serial1.getvalue()

    def __setfield_serial1(self, value):
        if isinstance(value,UINT):
            self.__field_serial1=value
        else:
            self.__field_serial1=UINT(value,**{'sizeinbytes': 4})

    def __delfield_serial1(self): del self.__field_serial1

    serial1=property(__getfield_serial1, __setfield_serial1, __delfield_serial1, None)

    def __getfield_unknown(self):
        try: self.__field_unknown
        except:
            self.__field_unknown=UINT(**{'sizeinbytes': 2, 'constant': 0x0000})
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UINT):
            self.__field_unknown=value
        else:
            self.__field_unknown=UINT(value,**{'sizeinbytes': 2, 'constant': 0x0000})

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def __getfield_serial2(self):
        return self.__field_serial2.getvalue()

    def __setfield_serial2(self, value):
        if isinstance(value,UINT):
            self.__field_serial2=value
        else:
            self.__field_serial2=UINT(value,**{'sizeinbytes': 4})

    def __delfield_serial2(self): del self.__field_serial2

    serial2=property(__getfield_serial2, __setfield_serial2, __delfield_serial2, None)

    def __getfield_entrynumber(self):
        return self.__field_entrynumber.getvalue()

    def __setfield_entrynumber(self, value):
        if isinstance(value,UINT):
            self.__field_entrynumber=value
        else:
            self.__field_entrynumber=UINT(value,**{'sizeinbytes': 2})

    def __delfield_entrynumber(self): del self.__field_entrynumber

    entrynumber=property(__getfield_entrynumber, __setfield_entrynumber, __delfield_entrynumber, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('serial1', self.__field_serial1, None)
        yield ('unknown', self.__field_unknown, None)
        yield ('serial2', self.__field_serial2, None)
        yield ('entrynumber', self.__field_entrynumber, None)




class pbdeleteentryresponse(BaseProtogenClass):
    __fields=['header', 'dunno']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbdeleteentryresponse,self).__init__(**dict)
        if self.__class__ is pbdeleteentryresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbdeleteentryresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbdeleteentryresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_dunno.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_dunno=UNKNOWN()
        self.__field_dunno.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_dunno(self):
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno=value
        else:
            self.__field_dunno=UNKNOWN(value,)

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('dunno', self.__field_dunno, None)




class pbupdateentryresponse(BaseProtogenClass):
    __fields=['header', 'serial1', 'dunno']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbupdateentryresponse,self).__init__(**dict)
        if self.__class__ is pbupdateentryresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbupdateentryresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbupdateentryresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_serial1.writetobuffer(buf)
        self.__field_dunno.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_serial1=UINT(**{'sizeinbytes': 4})
        self.__field_serial1.readfrombuffer(buf)
        self.__field_dunno=UNKNOWN()
        self.__field_dunno.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_serial1(self):
        return self.__field_serial1.getvalue()

    def __setfield_serial1(self, value):
        if isinstance(value,UINT):
            self.__field_serial1=value
        else:
            self.__field_serial1=UINT(value,**{'sizeinbytes': 4})

    def __delfield_serial1(self): del self.__field_serial1

    serial1=property(__getfield_serial1, __setfield_serial1, __delfield_serial1, None)

    def __getfield_dunno(self):
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno=value
        else:
            self.__field_dunno=UNKNOWN(value,)

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('serial1', self.__field_serial1, None)
        yield ('dunno', self.__field_dunno, None)




class pbappendentryresponse(BaseProtogenClass):
    __fields=['header', 'newserial', 'dunno', 'dunno2']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbappendentryresponse,self).__init__(**dict)
        if self.__class__ is pbappendentryresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbappendentryresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbappendentryresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_newserial.writetobuffer(buf)
        self.__field_dunno.writetobuffer(buf)
        self.__field_dunno2.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=pbheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_newserial=UINT(**{'sizeinbytes': 4})
        self.__field_newserial.readfrombuffer(buf)
        self.__field_dunno=UINT(**{'sizeinbytes': 2})
        self.__field_dunno.readfrombuffer(buf)
        self.__field_dunno2=UNKNOWN()
        self.__field_dunno2.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,pbheader):
            self.__field_header=value
        else:
            self.__field_header=pbheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_newserial(self):
        return self.__field_newserial.getvalue()

    def __setfield_newserial(self, value):
        if isinstance(value,UINT):
            self.__field_newserial=value
        else:
            self.__field_newserial=UINT(value,**{'sizeinbytes': 4})

    def __delfield_newserial(self): del self.__field_newserial

    newserial=property(__getfield_newserial, __setfield_newserial, __delfield_newserial, None)

    def __getfield_dunno(self):
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,UINT):
            self.__field_dunno=value
        else:
            self.__field_dunno=UINT(value,**{'sizeinbytes': 2})

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, None)

    def __getfield_dunno2(self):
        return self.__field_dunno2.getvalue()

    def __setfield_dunno2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno2=value
        else:
            self.__field_dunno2=UNKNOWN(value,)

    def __delfield_dunno2(self): del self.__field_dunno2

    dunno2=property(__getfield_dunno2, __setfield_dunno2, __delfield_dunno2, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('newserial', self.__field_newserial, None)
        yield ('dunno', self.__field_dunno, None)
        yield ('dunno2', self.__field_dunno2, None)




class LockKeyReq(BaseProtogenClass):
    __fields=['cmd', 'lock']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(LockKeyReq,self).__init__(**dict)
        if self.__class__ is LockKeyReq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(LockKeyReq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(LockKeyReq,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0x21 })
        self.__field_cmd.writetobuffer(buf)
        try: self.__field_lock
        except:
            self.__field_lock=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_lock.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0x21 })
        self.__field_cmd.readfrombuffer(buf)
        self.__field_lock=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_lock.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0x21 })
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'default': 0x21 })

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_lock(self):
        try: self.__field_lock
        except:
            self.__field_lock=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_lock.getvalue()

    def __setfield_lock(self, value):
        if isinstance(value,UINT):
            self.__field_lock=value
        else:
            self.__field_lock=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_lock(self): del self.__field_lock

    lock=property(__getfield_lock, __setfield_lock, __delfield_lock, "0=Lock, 1=Unlock")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('lock', self.__field_lock, "0=Lock, 1=Unlock")




class KeyPressReq(BaseProtogenClass):
    __fields=['cmd', 'hold', 'key']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(KeyPressReq,self).__init__(**dict)
        if self.__class__ is KeyPressReq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(KeyPressReq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(KeyPressReq,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0x20 })
        self.__field_cmd.writetobuffer(buf)
        try: self.__field_hold
        except:
            self.__field_hold=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_hold.writetobuffer(buf)
        self.__field_key.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0x20 })
        self.__field_cmd.readfrombuffer(buf)
        self.__field_hold=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_hold.readfrombuffer(buf)
        self.__field_key=STRING(**{'sizeinbytes': 1,  'terminator': None,                'sizeinbytes': 1 })
        self.__field_key.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0x20 })
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'default': 0x20 })

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_hold(self):
        try: self.__field_hold
        except:
            self.__field_hold=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_hold.getvalue()

    def __setfield_hold(self, value):
        if isinstance(value,UINT):
            self.__field_hold=value
        else:
            self.__field_hold=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_hold(self): del self.__field_hold

    hold=property(__getfield_hold, __setfield_hold, __delfield_hold, None)

    def __getfield_key(self):
        return self.__field_key.getvalue()

    def __setfield_key(self, value):
        if isinstance(value,STRING):
            self.__field_key=value
        else:
            self.__field_key=STRING(value,**{'sizeinbytes': 1,  'terminator': None,                'sizeinbytes': 1 })

    def __delfield_key(self): del self.__field_key

    key=property(__getfield_key, __setfield_key, __delfield_key, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('hold', self.__field_hold, None)
        yield ('key', self.__field_key, None)




class ULReq(BaseProtogenClass):
    ""
    __fields=['cmd', 'unlock_code', 'unlock_key', 'zero']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ULReq,self).__init__(**dict)
        if self.__class__ is ULReq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ULReq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ULReq,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        self.__field_cmd.writetobuffer(buf)
        try: self.__field_unlock_code
        except:
            self.__field_unlock_code=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_unlock_code.writetobuffer(buf)
        self.__field_unlock_key.writetobuffer(buf)
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_zero.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        self.__field_cmd.readfrombuffer(buf)
        self.__field_unlock_code=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_unlock_code.readfrombuffer(buf)
        self.__field_unlock_key=UINT(**{'sizeinbytes': 4})
        self.__field_unlock_key.readfrombuffer(buf)
        self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_zero.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'default': 0xFE })

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_unlock_code(self):
        try: self.__field_unlock_code
        except:
            self.__field_unlock_code=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        return self.__field_unlock_code.getvalue()

    def __setfield_unlock_code(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_code=value
        else:
            self.__field_unlock_code=UINT(value,**{'sizeinbytes': 1,  'default': 0x00 })

    def __delfield_unlock_code(self): del self.__field_unlock_code

    unlock_code=property(__getfield_unlock_code, __setfield_unlock_code, __delfield_unlock_code, None)

    def __getfield_unlock_key(self):
        return self.__field_unlock_key.getvalue()

    def __setfield_unlock_key(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_key=value
        else:
            self.__field_unlock_key=UINT(value,**{'sizeinbytes': 4})

    def __delfield_unlock_key(self): del self.__field_unlock_key

    unlock_key=property(__getfield_unlock_key, __setfield_unlock_key, __delfield_unlock_key, None)

    def __getfield_zero(self):
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        return self.__field_zero.getvalue()

    def __setfield_zero(self, value):
        if isinstance(value,UINT):
            self.__field_zero=value
        else:
            self.__field_zero=UINT(value,**{'sizeinbytes': 1,  'default': 0x00 })

    def __delfield_zero(self): del self.__field_zero

    zero=property(__getfield_zero, __setfield_zero, __delfield_zero, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('unlock_code', self.__field_unlock_code, None)
        yield ('unlock_key', self.__field_unlock_key, None)
        yield ('zero', self.__field_zero, None)




class ULRes(BaseProtogenClass):
    ""
    __fields=['cmd', 'unlock_code', 'unlock_key', 'unlock_ok']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ULRes,self).__init__(**dict)
        if self.__class__ is ULRes:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ULRes,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ULRes,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_cmd.writetobuffer(buf)
        self.__field_unlock_code.writetobuffer(buf)
        self.__field_unlock_key.writetobuffer(buf)
        self.__field_unlock_ok.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1})
        self.__field_cmd.readfrombuffer(buf)
        self.__field_unlock_code=UINT(**{'sizeinbytes': 1})
        self.__field_unlock_code.readfrombuffer(buf)
        self.__field_unlock_key=UINT(**{'sizeinbytes': 4})
        self.__field_unlock_key.readfrombuffer(buf)
        self.__field_unlock_ok=UINT(**{'sizeinbytes': 1})
        self.__field_unlock_ok.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1})

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_unlock_code(self):
        return self.__field_unlock_code.getvalue()

    def __setfield_unlock_code(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_code=value
        else:
            self.__field_unlock_code=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unlock_code(self): del self.__field_unlock_code

    unlock_code=property(__getfield_unlock_code, __setfield_unlock_code, __delfield_unlock_code, None)

    def __getfield_unlock_key(self):
        return self.__field_unlock_key.getvalue()

    def __setfield_unlock_key(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_key=value
        else:
            self.__field_unlock_key=UINT(value,**{'sizeinbytes': 4})

    def __delfield_unlock_key(self): del self.__field_unlock_key

    unlock_key=property(__getfield_unlock_key, __setfield_unlock_key, __delfield_unlock_key, None)

    def __getfield_unlock_ok(self):
        return self.__field_unlock_ok.getvalue()

    def __setfield_unlock_ok(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_ok=value
        else:
            self.__field_unlock_ok=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unlock_ok(self): del self.__field_unlock_ok

    unlock_ok=property(__getfield_unlock_ok, __setfield_unlock_ok, __delfield_unlock_ok, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('unlock_code', self.__field_unlock_code, None)
        yield ('unlock_key', self.__field_unlock_key, None)
        yield ('unlock_ok', self.__field_unlock_ok, None)




class DMKeyReq(BaseProtogenClass):
    "Slightly different command for DMv6"
    __fields=['cmd', 'unlock_code', 'unlock_key', 'zero', 'option']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(DMKeyReq,self).__init__(**dict)
        if self.__class__ is DMKeyReq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(DMKeyReq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(DMKeyReq,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        self.__field_cmd.writetobuffer(buf)
        try: self.__field_unlock_code
        except:
            self.__field_unlock_code=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_unlock_code.writetobuffer(buf)
        try: self.__field_unlock_key
        except:
            self.__field_unlock_key=UINT(**{'sizeinbytes': 4,  'default': 0x00 })
        self.__field_unlock_key.writetobuffer(buf)
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_zero.writetobuffer(buf)
        try: self.__field_option
        except:
            self.__field_option=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_option.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        self.__field_cmd.readfrombuffer(buf)
        self.__field_unlock_code=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_unlock_code.readfrombuffer(buf)
        self.__field_unlock_key=UINT(**{'sizeinbytes': 4,  'default': 0x00 })
        self.__field_unlock_key.readfrombuffer(buf)
        self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_zero.readfrombuffer(buf)
        self.__field_option=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_option.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'default': 0xFE })

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_unlock_code(self):
        try: self.__field_unlock_code
        except:
            self.__field_unlock_code=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        return self.__field_unlock_code.getvalue()

    def __setfield_unlock_code(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_code=value
        else:
            self.__field_unlock_code=UINT(value,**{'sizeinbytes': 1,  'default': 0x00 })

    def __delfield_unlock_code(self): del self.__field_unlock_code

    unlock_code=property(__getfield_unlock_code, __setfield_unlock_code, __delfield_unlock_code, None)

    def __getfield_unlock_key(self):
        try: self.__field_unlock_key
        except:
            self.__field_unlock_key=UINT(**{'sizeinbytes': 4,  'default': 0x00 })
        return self.__field_unlock_key.getvalue()

    def __setfield_unlock_key(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_key=value
        else:
            self.__field_unlock_key=UINT(value,**{'sizeinbytes': 4,  'default': 0x00 })

    def __delfield_unlock_key(self): del self.__field_unlock_key

    unlock_key=property(__getfield_unlock_key, __setfield_unlock_key, __delfield_unlock_key, None)

    def __getfield_zero(self):
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        return self.__field_zero.getvalue()

    def __setfield_zero(self, value):
        if isinstance(value,UINT):
            self.__field_zero=value
        else:
            self.__field_zero=UINT(value,**{'sizeinbytes': 1,  'default': 0x00 })

    def __delfield_zero(self): del self.__field_zero

    zero=property(__getfield_zero, __setfield_zero, __delfield_zero, None)

    def __getfield_option(self):
        try: self.__field_option
        except:
            self.__field_option=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        return self.__field_option.getvalue()

    def __setfield_option(self, value):
        if isinstance(value,UINT):
            self.__field_option=value
        else:
            self.__field_option=UINT(value,**{'sizeinbytes': 1,  'default': 0x00 })

    def __delfield_option(self): del self.__field_option

    option=property(__getfield_option, __setfield_option, __delfield_option, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('unlock_code', self.__field_unlock_code, None)
        yield ('unlock_key', self.__field_unlock_key, None)
        yield ('zero', self.__field_zero, None)
        yield ('option', self.__field_option, None)




class DMKeyResp(BaseProtogenClass):
    "Return the key/seed needed to transition to DMv6"
    __fields=['cmd', 'unlock_code', 'unlock_key']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(DMKeyResp,self).__init__(**dict)
        if self.__class__ is DMKeyResp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(DMKeyResp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(DMKeyResp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_cmd.writetobuffer(buf)
        self.__field_unlock_code.writetobuffer(buf)
        self.__field_unlock_key.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1})
        self.__field_cmd.readfrombuffer(buf)
        self.__field_unlock_code=UINT(**{'sizeinbytes': 1})
        self.__field_unlock_code.readfrombuffer(buf)
        self.__field_unlock_key=UINT(**{'sizeinbytes': 4})
        self.__field_unlock_key.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1})

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_unlock_code(self):
        return self.__field_unlock_code.getvalue()

    def __setfield_unlock_code(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_code=value
        else:
            self.__field_unlock_code=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unlock_code(self): del self.__field_unlock_code

    unlock_code=property(__getfield_unlock_code, __setfield_unlock_code, __delfield_unlock_code, None)

    def __getfield_unlock_key(self):
        return self.__field_unlock_key.getvalue()

    def __setfield_unlock_key(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_key=value
        else:
            self.__field_unlock_key=UINT(value,**{'sizeinbytes': 4})

    def __delfield_unlock_key(self): del self.__field_unlock_key

    unlock_key=property(__getfield_unlock_key, __setfield_unlock_key, __delfield_unlock_key, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('unlock_code', self.__field_unlock_code, None)
        yield ('unlock_key', self.__field_unlock_key, None)




class DMEnterReq(BaseProtogenClass):
    "Request to transition to DMv6"
    __fields=['cmd', 'unlock_code', 'unlock_key', 'zero', 'option', 'unlock_key2']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(DMEnterReq,self).__init__(**dict)
        if self.__class__ is DMEnterReq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(DMEnterReq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(DMEnterReq,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        self.__field_cmd.writetobuffer(buf)
        try: self.__field_unlock_code
        except:
            self.__field_unlock_code=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_unlock_code.writetobuffer(buf)
        try: self.__field_unlock_key
        except:
            self.__field_unlock_key=UINT(**{'sizeinbytes': 4,  'default': 0x00 })
        self.__field_unlock_key.writetobuffer(buf)
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_zero.writetobuffer(buf)
        try: self.__field_option
        except:
            self.__field_option=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_option.writetobuffer(buf)
        if self.unlock_code==3:
            try: self.__field_unlock_key2
            except:
                self.__field_unlock_key2=LIST(**{'elementclass': _gen_p_lg_180,  'createdefault': True,                 'length': 16 })
            self.__field_unlock_key2.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        self.__field_cmd.readfrombuffer(buf)
        self.__field_unlock_code=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_unlock_code.readfrombuffer(buf)
        self.__field_unlock_key=UINT(**{'sizeinbytes': 4,  'default': 0x00 })
        self.__field_unlock_key.readfrombuffer(buf)
        self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_zero.readfrombuffer(buf)
        self.__field_option=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        self.__field_option.readfrombuffer(buf)
        if self.unlock_code==3:
            self.__field_unlock_key2=LIST(**{'elementclass': _gen_p_lg_180,  'createdefault': True,                 'length': 16 })
            self.__field_unlock_key2.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'default': 0xFE })

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_unlock_code(self):
        try: self.__field_unlock_code
        except:
            self.__field_unlock_code=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        return self.__field_unlock_code.getvalue()

    def __setfield_unlock_code(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_code=value
        else:
            self.__field_unlock_code=UINT(value,**{'sizeinbytes': 1,  'default': 0x00 })

    def __delfield_unlock_code(self): del self.__field_unlock_code

    unlock_code=property(__getfield_unlock_code, __setfield_unlock_code, __delfield_unlock_code, None)

    def __getfield_unlock_key(self):
        try: self.__field_unlock_key
        except:
            self.__field_unlock_key=UINT(**{'sizeinbytes': 4,  'default': 0x00 })
        return self.__field_unlock_key.getvalue()

    def __setfield_unlock_key(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_key=value
        else:
            self.__field_unlock_key=UINT(value,**{'sizeinbytes': 4,  'default': 0x00 })

    def __delfield_unlock_key(self): del self.__field_unlock_key

    unlock_key=property(__getfield_unlock_key, __setfield_unlock_key, __delfield_unlock_key, None)

    def __getfield_zero(self):
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        return self.__field_zero.getvalue()

    def __setfield_zero(self, value):
        if isinstance(value,UINT):
            self.__field_zero=value
        else:
            self.__field_zero=UINT(value,**{'sizeinbytes': 1,  'default': 0x00 })

    def __delfield_zero(self): del self.__field_zero

    zero=property(__getfield_zero, __setfield_zero, __delfield_zero, None)

    def __getfield_option(self):
        try: self.__field_option
        except:
            self.__field_option=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        return self.__field_option.getvalue()

    def __setfield_option(self, value):
        if isinstance(value,UINT):
            self.__field_option=value
        else:
            self.__field_option=UINT(value,**{'sizeinbytes': 1,  'default': 0x00 })

    def __delfield_option(self): del self.__field_option

    option=property(__getfield_option, __setfield_option, __delfield_option, None)

    def __getfield_unlock_key2(self):
        try: self.__field_unlock_key2
        except:
            self.__field_unlock_key2=LIST(**{'elementclass': _gen_p_lg_180,  'createdefault': True,                 'length': 16 })
        return self.__field_unlock_key2.getvalue()

    def __setfield_unlock_key2(self, value):
        if isinstance(value,LIST):
            self.__field_unlock_key2=value
        else:
            self.__field_unlock_key2=LIST(value,**{'elementclass': _gen_p_lg_180,  'createdefault': True,                 'length': 16 })

    def __delfield_unlock_key2(self): del self.__field_unlock_key2

    unlock_key2=property(__getfield_unlock_key2, __setfield_unlock_key2, __delfield_unlock_key2, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('unlock_code', self.__field_unlock_code, None)
        yield ('unlock_key', self.__field_unlock_key, None)
        yield ('zero', self.__field_zero, None)
        yield ('option', self.__field_option, None)
        if self.unlock_code==3:
            yield ('unlock_key2', self.__field_unlock_key2, None)


    def init_key2(self):
        if self.unlock_code==3 and \
           not len(self.unlock_key2):
            for _idx in range(16):
                self.unlock_key2.append(0)

    def convert_to_key2(self,shift):  
        """Convert the key value to key2"""
        if self.unlock_code!=3:
            return
        self.init_key2()
        _buf=buffer()
        UINT(sizeinbytes=4, value=~self.unlock_key).writetobuffer(_buf)
        _key=_buf.getvalue()
        for _idx in range(4):
            _nth_key=ord(_key[(_idx + 4 - shift) % 4])
            for _idy in range(4):
                self.unlock_key2[_idx*4+_idy]=_nth_key





class _gen_p_lg_180(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lg_180,self).__init__(**dict)
        if self.__class__ is _gen_p_lg_180:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lg_180,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lg_180,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1,  'default': 0 }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_data=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_data
        except:
            self.__field_data=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_data=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_data(self):
        try: self.__field_data
        except:
            self.__field_data=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,UINT):
            self.__field_data=value
        else:
            self.__field_data=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('data', self.__field_data, None)




class DMEnterResp(BaseProtogenClass):
    "Response to our request to enter DMv6"
    __fields=['cmd', 'unlock_code', 'unlock_key', 'result']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(DMEnterResp,self).__init__(**dict)
        if self.__class__ is DMEnterResp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(DMEnterResp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(DMEnterResp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_cmd.writetobuffer(buf)
        self.__field_unlock_code.writetobuffer(buf)
        self.__field_unlock_key.writetobuffer(buf)
        self.__field_result.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1})
        self.__field_cmd.readfrombuffer(buf)
        self.__field_unlock_code=UINT(**{'sizeinbytes': 1})
        self.__field_unlock_code.readfrombuffer(buf)
        self.__field_unlock_key=UINT(**{'sizeinbytes': 4})
        self.__field_unlock_key.readfrombuffer(buf)
        self.__field_result=UINT(**{'sizeinbytes': 1})
        self.__field_result.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1})

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_unlock_code(self):
        return self.__field_unlock_code.getvalue()

    def __setfield_unlock_code(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_code=value
        else:
            self.__field_unlock_code=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unlock_code(self): del self.__field_unlock_code

    unlock_code=property(__getfield_unlock_code, __setfield_unlock_code, __delfield_unlock_code, None)

    def __getfield_unlock_key(self):
        return self.__field_unlock_key.getvalue()

    def __setfield_unlock_key(self, value):
        if isinstance(value,UINT):
            self.__field_unlock_key=value
        else:
            self.__field_unlock_key=UINT(value,**{'sizeinbytes': 4})

    def __delfield_unlock_key(self): del self.__field_unlock_key

    unlock_key=property(__getfield_unlock_key, __setfield_unlock_key, __delfield_unlock_key, None)

    def __getfield_result(self):
        return self.__field_result.getvalue()

    def __setfield_result(self, value):
        if isinstance(value,UINT):
            self.__field_result=value
        else:
            self.__field_result=UINT(value,**{'sizeinbytes': 1})

    def __delfield_result(self): del self.__field_result

    result=property(__getfield_result, __setfield_result, __delfield_result, "0=Failure, 1=Success")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('unlock_code', self.__field_unlock_code, None)
        yield ('unlock_key', self.__field_unlock_key, None)
        yield ('result', self.__field_result, "0=Failure, 1=Success")




class NVReq(BaseProtogenClass):
    __fields=['cmd', 'field', 'data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(NVReq,self).__init__(**dict)
        if self.__class__ is NVReq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(NVReq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(NVReq,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'constant': 0x26 })
        self.__field_cmd.writetobuffer(buf)
        self.__field_field.writetobuffer(buf)
        try: self.__field_data
        except:
            self.__field_data=DATA(**{'sizeinbytes': 130,  'default': '\x00'*130 })
        self.__field_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'constant': 0x26 })
        self.__field_cmd.readfrombuffer(buf)
        self.__field_field=UINT(**{'sizeinbytes': 2})
        self.__field_field.readfrombuffer(buf)
        self.__field_data=DATA(**{'sizeinbytes': 130,  'default': '\x00'*130 })
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'constant': 0x26 })
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'constant': 0x26 })

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_field(self):
        return self.__field_field.getvalue()

    def __setfield_field(self, value):
        if isinstance(value,UINT):
            self.__field_field=value
        else:
            self.__field_field=UINT(value,**{'sizeinbytes': 2})

    def __delfield_field(self): del self.__field_field

    field=property(__getfield_field, __setfield_field, __delfield_field, None)

    def __getfield_data(self):
        try: self.__field_data
        except:
            self.__field_data=DATA(**{'sizeinbytes': 130,  'default': '\x00'*130 })
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,**{'sizeinbytes': 130,  'default': '\x00'*130 })

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('field', self.__field_field, None)
        yield ('data', self.__field_data, None)




class NVRes(BaseProtogenClass):
    __fields=['cmd', 'field', 'data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(NVRes,self).__init__(**dict)
        if self.__class__ is NVRes:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(NVRes,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(NVRes,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_cmd.writetobuffer(buf)
        self.__field_field.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'constant': 0x26 })
        self.__field_cmd.readfrombuffer(buf)
        self.__field_field=UINT(**{'sizeinbytes': 2})
        self.__field_field.readfrombuffer(buf)
        self.__field_data=DATA(**{'sizeinbytes': 130})
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'constant': 0x26 })

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_field(self):
        return self.__field_field.getvalue()

    def __setfield_field(self, value):
        if isinstance(value,UINT):
            self.__field_field=value
        else:
            self.__field_field=UINT(value,**{'sizeinbytes': 2})

    def __delfield_field(self): del self.__field_field

    field=property(__getfield_field, __setfield_field, __delfield_field, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,**{'sizeinbytes': 130})

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('field', self.__field_field, None)
        yield ('data', self.__field_data, None)




class FWInfoReq(BaseProtogenClass):
    __fields=['cmd']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(FWInfoReq,self).__init__(**dict)
        if self.__class__ is FWInfoReq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(FWInfoReq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(FWInfoReq,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1,  'constant': 0x00}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_cmd=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'constant': 0x00})
        self.__field_cmd.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'constant': 0x00})
        self.__field_cmd.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'constant': 0x00})
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'constant': 0x00})

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)




class FWInfoRes(BaseProtogenClass):
    __fields=['cmd', 'fw_data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(FWInfoRes,self).__init__(**dict)
        if self.__class__ is FWInfoRes:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(FWInfoRes,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(FWInfoRes,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_cmd.writetobuffer(buf)
        self.__field_fw_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'constant': 0x00})
        self.__field_cmd.readfrombuffer(buf)
        self.__field_fw_data=DATA(**{'sizeinbytes': 53})
        self.__field_fw_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'constant': 0x00})

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_fw_data(self):
        return self.__field_fw_data.getvalue()

    def __setfield_fw_data(self, value):
        if isinstance(value,DATA):
            self.__field_fw_data=value
        else:
            self.__field_fw_data=DATA(value,**{'sizeinbytes': 53})

    def __delfield_fw_data(self): del self.__field_fw_data

    fw_data=property(__getfield_fw_data, __setfield_fw_data, __delfield_fw_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('fw_data', self.__field_fw_data, None)


    def get_compile_time(self):
        _comptime = re.findall(r'(\d\d):(\d\d):(\d\d)', self.fw_data)[0]
        return int(_comptime[0]) * 100 + int (_comptime[1])





class data(BaseProtogenClass):
    __fields=['bytes']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(data,self).__init__(**dict)
        if self.__class__ is data:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(data,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(data,kwargs)
        if len(args):
            dict2={}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_bytes=DATA(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_bytes.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_bytes=DATA()
        self.__field_bytes.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_bytes(self):
        return self.__field_bytes.getvalue()

    def __setfield_bytes(self, value):
        if isinstance(value,DATA):
            self.__field_bytes=value
        else:
            self.__field_bytes=DATA(value,)

    def __delfield_bytes(self): del self.__field_bytes

    bytes=property(__getfield_bytes, __setfield_bytes, __delfield_bytes, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('bytes', self.__field_bytes, None)




