#!
#! @ingroup group_sdk_cmake_camitk_cdash_projects
#!
#! MACRO camitk_sub_project_init initializes the xml_subprojects variable to gather CamiTK subprojects
#!
#! usage:
#! \code
#! camitk_sub_project_init()
#! \endcode
macro(camitk_sub_project_init)
    if(CAMITK_EXTENSION_PROJECT_SET)
        if(NOT CAMITK_XML_PROJECT_DESCRIPTION)
            # This is a call to camitk_sub_project_init from the first CEP of a CEP Set
            set(CAMITK_XML_PROJECT_DESCRIPTION "<?xml version=\"1.0\"?><Project name=\"${CAMITK_EXTENSION_PROJECT_SET_NAME}\">" CACHE INTERNAL "")            
            set(CAMITK_SUBPROJECTS "" CACHE INTERNAL "")
            # for .cep packaging
            set(CAMITK_ACTION_TARGETS "" CACHE STRING "List of CamiTK action targets" FORCE)
            set(CAMITK_COMPONENT_TARGETS "" CACHE STRING "List of CamiTK component targets" FORCE)
            set(CAMITK_CEP_LIBRARY_TARGETS "" CACHE STRING "List of CamiTK library targets" FORCE)
            set(CAMITK_APPLICATION_TARGETS "" CACHE STRING "List of CamiTK application targets" FORCE)
        
            # The different CMake variable to parse for CDash dependencies
            # This variables are CMake persistent
            set(xml_subproject_corelibraries "" CACHE INTERNAL "")
            set(xml_subproject_libraries "" CACHE INTERNAL "")
            set(xml_subproject_action_application "" CACHE INTERNAL "")
            set(xml_subproject_components "" CACHE INTERNAL "")
            set(xml_subproject_actions "" CACHE INTERNAL "")
            set(xml_subproject_applications "" CACHE INTERNAL "")
            
        endif()
    else()
        # This is a call to camitk_sub_project_init from a standalone CEP
        set(CAMITK_XML_PROJECT_DESCRIPTION "<?xml version=\"1.0\"?><Project name=\"${CMAKE_PROJECT_NAME}\">" CACHE INTERNAL "")
        set(CAMITK_SUBPROJECTS "" CACHE INTERNAL "")
        # for .cep packaging
        set(CAMITK_ACTION_TARGETS "" CACHE STRING "List of CamiTK action targets" FORCE)
        set(CAMITK_COMPONENT_TARGETS "" CACHE STRING "List of CamiTK component targets" FORCE)
        set(CAMITK_CEP_LIBRARY_TARGETS "" CACHE STRING "List of CamiTK library targets" FORCE)
        set(CAMITK_APPLICATION_TARGETS "" CACHE STRING "List of CamiTK application targets" FORCE)
        
        # The different CMake variable to parse for CDash dependencies
        # This variables are CMake persistent
        set(xml_subproject_corelibraries "" CACHE INTERNAL "")
        set(xml_subproject_libraries "" CACHE INTERNAL "")
        set(xml_subproject_action_application "" CACHE INTERNAL "")
        set(xml_subproject_components "" CACHE INTERNAL "")
        set(xml_subproject_actions "" CACHE INTERNAL "")
        set(xml_subproject_applications "" CACHE INTERNAL "")
    endif()
endmacro()
