//# tConvolver.cc:  this tests the Convolver class
//# Copyright (C) 1996,1997,1998,1999,2002
//# Associated Universities, Inc. Washington DC, USA.
//#
//# This library is free software; you can redistribute it and/or modify it
//# under the terms of the GNU Library General Public License as published by
//# the Free Software Foundation; either version 2 of the License, or (at your
//# option) any later version.
//#
//# This library is distributed in the hope that it will be useful, but WITHOUT
//# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
//# License for more details.
//#
//# You should have received a copy of the GNU Library General Public License
//# along with this library; if not, write to the Free Software Foundation,
//# Inc., 675 Massachusetts Ave, Cambridge, MA 02139, USA.
//#
//# Correspondence concerning AIPS++ should be addressed as follows:
//#        Internet email: aips2-request@nrao.edu.
//#        Postal address: AIPS++ Project Office
//#                        National Radio Astronomy Observatory
//#                        520 Edgemont Road
//#                        Charlottesville, VA 22903-2475 USA
//#
//# $Id$

#include <casacore/casa/aips.h>
#include <casacore/casa/Arrays/IPosition.h>
#include <casacore/casa/Arrays/Array.h>
#include <casacore/casa/Arrays/Vector.h>
#include <casacore/casa/Arrays/Matrix.h>
#include <casacore/casa/Arrays/Cube.h>
#include <casacore/casa/Arrays/ArrayLogical.h>
#include <casacore/scimath/Mathematics/Convolver.h>
#include <casacore/casa/iostream.h>

#include <casacore/casa/namespace.h>

Bool doLinearConv() {
	Double beamData[] = {
			 2.7000172105e-25, 9.8635317948e-24, 3.0190166275e-22, 7.7421342681e-21, 1.6634945915e-19, 2.9946487959e-18, 4.5168693657e-17, 5.7081185033e-16, 6.0438070835e-15, 5.3616318199e-14, 3.9851734651e-13, 2.481758939e-12, 1.2949036808e-11, 5.6608499138e-11, 2.0734351736e-10, 6.3630173353e-10, 1.6360705013e-09, 3.5245522056e-09, 6.3616734103e-09, 9.6206465017e-09, 1.2189945942e-08, 1.2940859051e-08, 1.151038731e-08, 8.5778921743e-09, 5.3559525703e-09, 2.8019366827e-09, 1.2281282658e-09, 4.5101875012e-10, 1.3877438088e-10, 3.5776017565e-11, 7.7274167967e-12, 1.3984425597e-12, 2.1204007517e-13
			 , 7.362798549e-24, 2.5496188929e-22, 7.3972968879e-21, 1.7982067704e-19, 3.6623942745e-18, 6.2496777531e-17, 8.9354691452e-16, 1.0703829994e-14, 1.0743044909e-13, 9.0339850401e-13, 6.3649528356e-12, 3.757297945e-11, 1.8583280748e-10, 7.7007639154e-10, 2.6736826086e-09, 7.7776736163e-09, 1.895640267e-08, 3.8710243899e-08, 6.623101001e-08, 9.4942500084e-08, 1.1403165701e-07, 1.1475035677e-07, 9.6749545264e-08, 6.8345009652e-08, 4.045116242e-08, 2.0059411909e-08, 8.334380297e-09, 2.9012920955e-09, 8.4619750096e-10, 2.0678624091e-10, 4.2338410555e-11, 7.2629064221e-12, 1.043881019e-12
			 , 1.7142488945e-22, 5.6270084002e-21, 1.5475455831e-19, 3.5659326073e-18, 6.8844614491e-17, 1.1135950628e-15, 1.5092172168e-14, 1.7137238351e-13, 1.6304078313e-12, 1.2996222154e-11, 8.6796098087e-11, 4.8567921906e-10, 2.2770070274e-09, 8.9442311335e-09, 2.9436453275e-08, 8.1169602595e-08, 1.8752831465e-07, 3.6299820749e-07, 5.8871842157e-07, 7.9997084868e-07, 9.1076549324e-07, 8.6876599426e-07, 6.9432843475e-07, 4.6493357786e-07, 2.6084489946e-07, 1.2261305926e-07, 4.8290122123e-08, 1.5934691788e-08, 4.4054928594e-09, 1.0204967982e-09, 1.980565989e-10, 3.2205800526e-11, 4.3877583858e-12
			 , 3.4077236103e-21, 1.0603099006e-19, 2.7641931753e-18, 6.03762504e-17, 1.1049162573e-15, 1.6941678773e-14, 2.1764347594e-13, 2.3426341162e-12, 2.1126518937e-11, 1.5962965672e-10, 1.0105679626e-09, 5.3602038363e-09, 2.3821185025e-08, 8.8697063916e-08, 2.7670731129e-07, 7.2326224654e-07, 1.5839317484e-06, 2.9063089642e-06, 4.4679895836e-06, 5.7550132624e-06, 6.2107837948e-06, 5.6157773543e-06, 4.2544133976e-06, 2.7004296044e-06, 1.4361226022e-06, 6.3990404442e-07, 2.3889310796e-07, 7.4723331522e-08, 1.9582705235e-08, 4.299887113e-09, 7.9105094697e-10, 1.2193142329e-10, 1.5746770207e-11
			 , 5.7837483018e-20, 1.7058633512e-18, 4.2154884256e-17, 8.727979425e-16, 1.5140580101e-14, 2.2005867181e-13, 2.6797847795e-12, 2.7341625491e-11, 2.3373031288e-10, 1.6740544506e-09, 1.0045878795e-08, 5.0509349592e-08, 2.1277482176e-07, 7.5099006835e-07, 2.220812803e-06, 5.50244431e-06, 1.1422562238e-05, 1.9867155061e-05, 2.8951673812e-05, 3.534886855e-05, 3.6161200114e-05, 3.0993738619e-05, 2.2257245291e-05, 1.3391580978e-05, 6.7508458415e-06, 2.8513409234e-06, 1.0090335536e-06, 2.9917509892e-07, 7.4320794852e-08, 1.5468991421e-08, 2.697583712e-09, 3.9414410624e-10, 4.8250181628e-11
			 , 8.3813806733e-19, 2.3432582496e-17, 5.488961963e-16, 1.0772607375e-14, 1.7714145038e-13, 2.4405256462e-12, 2.81714721e-11, 2.7246005452e-10, 2.2077970563e-09, 1.4989314678e-08, 8.5264652228e-08, 4.0636817289e-07, 1.6226908883e-06, 5.428964414e-06, 1.521817012e-05, 3.5741581087e-05, 7.0331341703e-05, 0.00011595467367, 0.00016017470625, 0.00018538023869, 0.00017976220988, 0.00014604839089, 9.9417185993e-05, 5.6700846471e-05, 2.7094622055e-05, 1.08477916e-05, 3.6388605622e-06, 1.0227099665e-06, 2.4082694949e-07, 4.7514166823e-08, 7.854269235e-09, 1.0878081769e-09, 1.2623001255e-10
			 , 1.0370020887e-17, 2.7482042207e-16, 6.1021867118e-15, 1.1352415319e-13, 1.7695107532e-12, 2.3109132663e-11, 2.528582066e-10, 2.318133463e-09, 1.7805820818e-08, 1.1459134441e-07, 6.1788307448e-07, 2.7914163638e-06, 1.0565966477e-05, 3.350870611e-05, 8.9037050202e-05, 0.00019822047034, 0.0003697356151, 0.00057782873046, 0.00075660849689, 0.00083005789202, 0.00076297478518, 0.00058759358944, 0.00037914779386, 0.00020497698279, 9.2846494226e-05, 3.5236353142e-05, 1.1204226212e-05, 2.9849554721e-06, 6.6628138029e-07, 1.2460689902e-07, 1.9525044692e-08, 2.5633424272e-09, 2.8195892843e-10
			 , 1.095460233e-16, 2.7519297893e-15, 5.7921556277e-14, 1.0214378171e-12, 1.5091877401e-11, 1.8682792813e-10, 1.9377746074e-09, 1.6839507566e-08, 1.2260896654e-07, 7.4796309946e-07, 3.8229750317e-06, 1.6371477614e-05, 5.8740668464e-05, 0.0001765856432, 0.00044477044139, 0.0009386020829, 0.0016595561756, 0.0024584820494, 0.0030514537357, 0.0031733019277, 0.0027649090625, 0.0020184358582, 0.0012345653959, 0.00063267099904, 0.00027164779021, 9.7723459476e-05, 2.9454919058e-05, 7.4384192885e-06, 1.5738672801e-06, 2.7901003818e-07, 4.1441644782e-08, 5.1572670579e-09, 5.3773124842e-10
			 , 9.8804434534e-16, 2.3527920673e-14, 4.6941324525e-13, 7.8467553635e-12, 1.0989836124e-10, 1.2896057555e-09, 1.2679044481e-08, 1.0444352938e-07, 7.2084458225e-07, 4.1683711061e-06, 2.019553358e-05, 8.1980273535e-05, 0.00027882237919, 0.00079453276703, 0.001896965201, 0.003794657765, 0.0063599031419, 0.008930850774, 0.010507524945, 0.010357918218, 0.0085547864437, 0.0059198532254, 0.0034322375432, 0.0016672802158, 0.00067858537659, 0.00023140088888, 6.6113607318e-05, 1.5826370145e-05, 3.1742156352e-06, 5.3340340855e-07, 7.5100118124e-08, 8.8591178837e-09, 8.7559853812e-10
			 , 7.608763981e-15, 1.7174738194e-13, 3.2480797565e-12, 5.1467274886e-11, 6.832812649e-10, 7.6003159322e-09, 7.083196607e-08, 5.5308458968e-07, 3.6184158034e-06, 1.9834025807e-05, 9.1089328635e-05, 0.00035049993312, 0.0011299885809, 0.0030522847082, 0.0069078211673, 0.01309849415, 0.020809743553, 0.027699816972, 0.030892400071, 0.02886630781, 0.022599330172, 0.014823971316, 0.008147017099, 0.0037514341529, 0.0014473070623, 0.0004678304249, 0.00012670148863, 2.8750160709e-05, 5.4659117268e-06, 8.7066121068e-07, 1.1619869866e-07, 1.2993292664e-08, 1.217307144e-09
			 , 5.0027500588e-14, 1.0704127472e-12, 1.9189228331e-11, 2.8822233489e-10, 3.6271305959e-09, 3.8244081679e-08, 3.3785306641e-07, 2.5006779651e-06, 1.5507876014e-05, 8.0577163317e-05, 0.00035078066867, 0.0012794549111, 0.0039100181311, 0.010011450388, 0.0214773193, 0.038603615016, 0.058135427535, 0.073353089392, 0.077546231449, 0.068685941398, 0.050972923636, 0.031693950295, 0.01651116088, 0.0072068208829, 0.0026355711743, 0.00080755102681, 0.00020731508266, 4.4591928599e-05, 8.0361169239e-06, 1.2133914424e-06, 1.5350433102e-07, 1.6270654157e-08, 1.4449539343e-09
			 , 2.8084102426e-13, 5.6960144067e-12, 9.6793142945e-11, 1.3781037422e-09, 1.643935299e-08, 1.6430584537e-07, 1.3758943851e-06, 9.6534622571e-06, 5.6747263443e-05, 0.00027949328069, 0.0011533558136, 0.0039876704104, 0.011551556177, 0.028036680073, 0.057013448328, 0.097138792276, 0.13866689801, 0.16585089266, 0.16619867086, 0.13954110444, 0.098161540926, 0.057855609804, 0.028570273891, 0.011820831336, 0.004097759258, 0.001190170995, 0.00028962624492, 5.9051388234e-05, 1.008759773e-05, 1.4438101061e-06, 1.7313968215e-07, 1.739596911e-08, 1.4644174762e-09
			 , 1.3460855694e-12, 2.5879026352e-11, 4.1685932484e-10, 5.6259481518e-09, 6.3615914314e-08, 6.0270014046e-07, 4.7840999287e-06, 3.1817395211e-05, 0.00017729403044, 0.00082773028407, 0.0032377834432, 0.010611373931, 0.029138045385, 0.067036889493, 0.1292206496, 0.20869635046, 0.28239867091, 0.32016593218, 0.30412513018, 0.24204400182, 0.16139911115, 0.090172208846, 0.042209394276, 0.016554273665, 0.0054397163913, 0.0014976364328, 0.00034546368988, 6.6766995587e-05, 1.0811519132e-05, 1.4668210042e-06, 1.6673658365e-07, 1.5879987103e-08, 1.2671688143e-09
			 , 5.5085862087e-12, 1.0038819775e-10, 1.5328210923e-09, 1.9609428747e-08, 2.1018544771e-07, 1.8875837213e-06, 1.4202775674e-05, 8.9537563326e-05, 0.00047293581883, 0.0020929765888, 0.0077605196275, 0.024109153077, 0.062753520906, 0.13685443997, 0.2500602603, 0.38282033801, 0.49103248119, 0.52770376205, 0.47515454888, 0.35846304893, 0.22657848895, 0.11999350041, 0.053242884576, 0.01979384385, 0.0061654318124, 0.001609020168, 0.00035182325519, 6.4454354288e-05, 9.893373317e-06, 1.2723365899e-06, 1.3709583868e-07, 1.2376879965e-08, 9.3618546249e-10
			 , 1.9247109115e-11, 3.3248934161e-10, 4.8123030005e-09, 5.8357095156e-08, 5.9292398191e-07, 5.0474250202e-06, 3.6000030377e-05, 0.00021513119282, 0.0010771300877, 0.0045185321942, 0.015881497413, 0.046768136322, 0.11539142579, 0.238540411, 0.41315698624, 0.59956043959, 0.72898006439, 0.74261391163, 0.63383364677, 0.45326510072, 0.27157768607, 0.13633288443, 0.057341847569, 0.020207272843, 0.0059663485736, 0.0014759581536, 0.00030591737595, 5.3125091654e-05, 7.7296444942e-06, 9.422894891e-07, 9.6244136216e-08, 8.2362294762e-09, 5.9053600898e-10
			 , 5.7418087646e-11, 9.402172374e-10, 1.289943441e-08, 1.4827892869e-07, 1.4280783489e-06, 1.1523639841e-05, 7.7909782704e-05, 0.00044132626499, 0.002094553085, 0.008328910917, 0.027749154717, 0.077459685504, 0.1811619699, 0.35499551892, 0.5828319788, 0.80173116922, 0.92401474714, 0.89226490259, 0.72189414501, 0.48934811354, 0.27792471647, 0.13225163519, 0.05272782594, 0.017613414675, 0.0049295988865, 0.0011559650302, 0.00022711334168, 3.7385692849e-05, 5.1562419685e-06, 5.9583419443e-07, 5.7687557842e-08, 4.6795438635e-09, 3.1804633926e-10
			 , 1.4624795819e-10, 2.270055699e-09, 2.9522142952e-08, 3.2167989161e-07, 2.9367281513e-06, 2.246306758e-05, 0.00014395892504, 0.00077298877295, 0.0034775424283, 0.013108015992, 0.041396718472, 0.10953669995, 0.24283881485, 0.45106744766, 0.70198774338, 0.91533988714, 1, 0.91533988714, 0.70198774338, 0.45106744766, 0.24283881485, 0.10953669995, 0.041396718472, 0.013108015992, 0.0034775424283, 0.00077298877295, 0.00014395892504, 2.246306758e-05, 2.9367281513e-06, 3.2167989161e-07, 2.9522142952e-08, 2.270055699e-09, 1.4624795819e-10
			 , 3.1804633926e-10, 4.6795438635e-09, 5.7687557842e-08, 5.9583419443e-07, 5.1562419685e-06, 3.7385692849e-05, 0.00022711334168, 0.0011559650302, 0.0049295988865, 0.017613414675, 0.05272782594, 0.13225163519, 0.27792471647, 0.48934811354, 0.72189414501, 0.89226490259, 0.92401474714, 0.80173116922, 0.5828319788, 0.35499551892, 0.1811619699, 0.077459685504, 0.027749154717, 0.008328910917, 0.002094553085, 0.00044132626499, 7.7909782704e-05, 1.1523639841e-05, 1.4280783489e-06, 1.4827892869e-07, 1.289943441e-08, 9.402172374e-10, 5.7418087646e-11
			 , 5.9053600898e-10, 8.2362294762e-09, 9.6244136216e-08, 9.422894891e-07, 7.7296444942e-06, 5.3125091654e-05, 0.00030591737595, 0.0014759581536, 0.0059663485736, 0.020207272843, 0.057341847569, 0.13633288443, 0.27157768607, 0.45326510072, 0.63383364677, 0.74261391163, 0.72898006439, 0.59956043959, 0.41315698624, 0.238540411, 0.11539142579, 0.046768136322, 0.015881497413, 0.0045185321942, 0.0010771300877, 0.00021513119282, 3.6000030377e-05, 5.0474250202e-06, 5.9292398191e-07, 5.8357095156e-08, 4.8123030005e-09, 3.3248934161e-10, 1.9247109115e-11
			 , 9.3618546249e-10, 1.2376879965e-08, 1.3709583868e-07, 1.2723365899e-06, 9.893373317e-06, 6.4454354288e-05, 0.00035182325519, 0.001609020168, 0.0061654318124, 0.01979384385, 0.053242884576, 0.11999350041, 0.22657848895, 0.35846304893, 0.47515454888, 0.52770376205, 0.49103248119, 0.38282033801, 0.2500602603, 0.13685443997, 0.062753520906, 0.024109153077, 0.0077605196275, 0.0020929765888, 0.00047293581883, 8.9537563326e-05, 1.4202775674e-05, 1.8875837213e-06, 2.1018544771e-07, 1.9609428747e-08, 1.5328210923e-09, 1.0038819775e-10, 5.5085862087e-12
			 , 1.2671688143e-09, 1.5879987103e-08, 1.6673658365e-07, 1.4668210042e-06, 1.0811519132e-05, 6.6766995587e-05, 0.00034546368988, 0.0014976364328, 0.0054397163913, 0.016554273665, 0.042209394276, 0.090172208846, 0.16139911115, 0.24204400182, 0.30412513018, 0.32016593218, 0.28239867091, 0.20869635046, 0.1292206496, 0.067036889493, 0.029138045385, 0.010611373931, 0.0032377834432, 0.00082773028407, 0.00017729403044, 3.1817395211e-05, 4.7840999287e-06, 6.0270014046e-07, 6.3615914314e-08, 5.6259481518e-09, 4.1685932484e-10, 2.5879026352e-11, 1.3460855694e-12
			 , 1.4644174762e-09, 1.739596911e-08, 1.7313968215e-07, 1.4438101061e-06, 1.008759773e-05, 5.9051388234e-05, 0.00028962624492, 0.001190170995, 0.004097759258, 0.011820831336, 0.028570273891, 0.057855609804, 0.098161540926, 0.13954110444, 0.16619867086, 0.16585089266, 0.13866689801, 0.097138792276, 0.057013448328, 0.028036680073, 0.011551556177, 0.0039876704104, 0.0011533558136, 0.00027949328069, 5.6747263443e-05, 9.6534622571e-06, 1.3758943851e-06, 1.6430584537e-07, 1.643935299e-08, 1.3781037422e-09, 9.6793142945e-11, 5.6960144067e-12, 2.8084102426e-13
			 , 1.4449539343e-09, 1.6270654157e-08, 1.5350433102e-07, 1.2133914424e-06, 8.0361169239e-06, 4.4591928599e-05, 0.00020731508266, 0.00080755102681, 0.0026355711743, 0.0072068208829, 0.01651116088, 0.031693950295, 0.050972923636, 0.068685941398, 0.077546231449, 0.073353089392, 0.058135427535, 0.038603615016, 0.0214773193, 0.010011450388, 0.0039100181311, 0.0012794549111, 0.00035078066867, 8.0577163317e-05, 1.5507876014e-05, 2.5006779651e-06, 3.3785306641e-07, 3.8244081679e-08, 3.6271305959e-09, 2.8822233489e-10, 1.9189228331e-11, 1.0704127472e-12, 5.0027500588e-14
			 , 1.217307144e-09, 1.2993292664e-08, 1.1619869866e-07, 8.7066121068e-07, 5.4659117268e-06, 2.8750160709e-05, 0.00012670148863, 0.0004678304249, 0.0014473070623, 0.0037514341529, 0.008147017099, 0.014823971316, 0.022599330172, 0.02886630781, 0.030892400071, 0.027699816972, 0.020809743553, 0.01309849415, 0.0069078211673, 0.0030522847082, 0.0011299885809, 0.00035049993312, 9.1089328635e-05, 1.9834025807e-05, 3.6184158034e-06, 5.5308458968e-07, 7.083196607e-08, 7.6003159322e-09, 6.832812649e-10, 5.1467274886e-11, 3.2480797565e-12, 1.7174738194e-13, 7.608763981e-15
			 , 8.7559853812e-10, 8.8591178837e-09, 7.5100118124e-08, 5.3340340855e-07, 3.1742156352e-06, 1.5826370145e-05, 6.6113607318e-05, 0.00023140088888, 0.00067858537659, 0.0016672802158, 0.0034322375432, 0.0059198532254, 0.0085547864437, 0.010357918218, 0.010507524945, 0.008930850774, 0.0063599031419, 0.003794657765, 0.001896965201, 0.00079453276703, 0.00027882237919, 8.1980273535e-05, 2.019553358e-05, 4.1683711061e-06, 7.2084458225e-07, 1.0444352938e-07, 1.2679044481e-08, 1.2896057555e-09, 1.0989836124e-10, 7.8467553635e-12, 4.6941324525e-13, 2.3527920673e-14, 9.8804434534e-16
			 , 5.3773124842e-10, 5.1572670579e-09, 4.1441644782e-08, 2.7901003818e-07, 1.5738672801e-06, 7.4384192885e-06, 2.9454919058e-05, 9.7723459476e-05, 0.00027164779021, 0.00063267099904, 0.0012345653959, 0.0020184358582, 0.0027649090625, 0.0031733019277, 0.0030514537357, 0.0024584820494, 0.0016595561756, 0.0009386020829, 0.00044477044139, 0.0001765856432, 5.8740668464e-05, 1.6371477614e-05, 3.8229750317e-06, 7.4796309946e-07, 1.2260896654e-07, 1.6839507566e-08, 1.9377746074e-09, 1.8682792813e-10, 1.5091877401e-11, 1.0214378171e-12, 5.7921556277e-14, 2.7519297893e-15, 1.095460233e-16
			 , 2.8195892843e-10, 2.5633424272e-09, 1.9525044692e-08, 1.2460689902e-07, 6.6628138029e-07, 2.9849554721e-06, 1.1204226212e-05, 3.5236353142e-05, 9.2846494226e-05, 0.00020497698279, 0.00037914779386, 0.00058759358944, 0.00076297478518, 0.00083005789202, 0.00075660849689, 0.00057782873046, 0.0003697356151, 0.00019822047034, 8.9037050202e-05, 3.350870611e-05, 1.0565966477e-05, 2.7914163638e-06, 6.1788307448e-07, 1.1459134441e-07, 1.7805820818e-08, 2.318133463e-09, 2.528582066e-10, 2.3109132663e-11, 1.7695107532e-12, 1.1352415319e-13, 6.1021867118e-15, 2.7482042207e-16, 1.0370020887e-17
			 , 1.2623001255e-10, 1.0878081769e-09, 7.854269235e-09, 4.7514166823e-08, 2.4082694949e-07, 1.0227099665e-06, 3.6388605622e-06, 1.08477916e-05, 2.7094622055e-05, 5.6700846471e-05, 9.9417185993e-05, 0.00014604839089, 0.00017976220988, 0.00018538023869, 0.00016017470625, 0.00011595467367, 7.0331341703e-05, 3.5741581087e-05, 1.521817012e-05, 5.428964414e-06, 1.6226908883e-06, 4.0636817289e-07, 8.5264652228e-08, 1.4989314678e-08, 2.2077970563e-09, 2.7246005452e-10, 2.81714721e-11, 2.4405256462e-12, 1.7714145038e-13, 1.0772607375e-14, 5.488961963e-16, 2.3432582496e-17, 8.3813806733e-19
			 , 4.8250181628e-11, 3.9414410624e-10, 2.697583712e-09, 1.5468991421e-08, 7.4320794852e-08, 2.9917509892e-07, 1.0090335536e-06, 2.8513409234e-06, 6.7508458415e-06, 1.3391580978e-05, 2.2257245291e-05, 3.0993738619e-05, 3.6161200114e-05, 3.534886855e-05, 2.8951673812e-05, 1.9867155061e-05, 1.1422562238e-05, 5.50244431e-06, 2.220812803e-06, 7.5099006835e-07, 2.1277482176e-07, 5.0509349592e-08, 1.0045878795e-08, 1.6740544506e-09, 2.3373031288e-10, 2.7341625491e-11, 2.6797847795e-12, 2.2005867181e-13, 1.5140580101e-14, 8.727979425e-16, 4.2154884256e-17, 1.7058633512e-18, 5.7837483018e-20
			 , 1.5746770207e-11, 1.2193142329e-10, 7.9105094697e-10, 4.299887113e-09, 1.9582705235e-08, 7.4723331522e-08, 2.3889310796e-07, 6.3990404442e-07, 1.4361226022e-06, 2.7004296044e-06, 4.2544133976e-06, 5.6157773543e-06, 6.2107837948e-06, 5.7550132624e-06, 4.4679895836e-06, 2.9063089642e-06, 1.5839317484e-06, 7.2326224654e-07, 2.7670731129e-07, 8.8697063916e-08, 2.3821185025e-08, 5.3602038363e-09, 1.0105679626e-09, 1.5962965672e-10, 2.1126518937e-11, 2.3426341162e-12, 2.1764347594e-13, 1.6941678773e-14, 1.1049162573e-15, 6.03762504e-17, 2.7641931753e-18, 1.0603099006e-19, 3.4077236103e-21
			 , 4.3877583858e-12, 3.2205800526e-11, 1.980565989e-10, 1.0204967982e-09, 4.4054928594e-09, 1.5934691788e-08, 4.8290122123e-08, 1.2261305926e-07, 2.6084489946e-07, 4.6493357786e-07, 6.9432843475e-07, 8.6876599426e-07, 9.1076549324e-07, 7.9997084868e-07, 5.8871842157e-07, 3.6299820749e-07, 1.8752831465e-07, 8.1169602595e-08, 2.9436453275e-08, 8.9442311335e-09, 2.2770070274e-09, 4.8567921906e-10, 8.6796098087e-11, 1.2996222154e-11, 1.6304078313e-12, 1.7137238351e-13, 1.5092172168e-14, 1.1135950628e-15, 6.8844614491e-17, 3.5659326073e-18, 1.5475455831e-19, 5.6270084002e-21, 1.7142488945e-22
			 , 1.043881019e-12, 7.2629064221e-12, 4.2338410555e-11, 2.0678624091e-10, 8.4619750096e-10, 2.9012920955e-09, 8.334380297e-09, 2.0059411909e-08, 4.045116242e-08, 6.8345009652e-08, 9.6749545264e-08, 1.1475035677e-07, 1.1403165701e-07, 9.4942500084e-08, 6.623101001e-08, 3.8710243899e-08, 1.895640267e-08, 7.7776736163e-09, 2.6736826086e-09, 7.7007639154e-10, 1.8583280748e-10, 3.757297945e-11, 6.3649528356e-12, 9.0339850401e-13, 1.0743044909e-13, 1.0703829994e-14, 8.9354691452e-16, 6.2496777531e-17, 3.6623942745e-18, 1.7982067704e-19, 7.3972968879e-21, 2.5496188929e-22, 7.362798549e-24
			 , 2.1204007517e-13, 1.3984425597e-12, 7.7274167967e-12, 3.5776017565e-11, 1.3877438088e-10, 4.5101875012e-10, 1.2281282658e-09, 2.8019366827e-09, 5.3559525703e-09, 8.5778921743e-09, 1.151038731e-08, 1.2940859051e-08, 1.2189945942e-08, 9.6206465017e-09, 6.3616734103e-09, 3.5245522056e-09, 1.6360705013e-09, 6.3630173353e-10, 2.0734351736e-10, 5.6608499138e-11, 1.2949036808e-11, 2.481758939e-12, 3.9851734651e-13, 5.3616318199e-14, 6.0438070835e-15, 5.7081185033e-16, 4.5168693657e-17, 2.9946487959e-18, 1.6634945915e-19, 7.7421342681e-21, 3.0190166275e-22, 9.8635317948e-24, 2.7000172105e-25
	};
	Double kernelData[] = {
			 8.8039155317e-17, 6.24999142e-16, 4.0724755416e-15, 2.435668312e-14, 1.3370776925e-13, 6.7371672477e-13, 3.115852628e-12, 1.3226817211e-11, 5.1536528517e-11, 1.8431105253e-10, 6.0502119981e-10, 1.8229211474e-09, 5.0413362374e-09, 1.2796853355e-08, 2.981532532e-08, 6.3761078195e-08, 1.2515641856e-07, 2.2549069456e-07, 3.7289299826e-07, 5.6600407561e-07, 7.8855822494e-07, 1.0083938378e-06, 1.1835978739e-06, 1.275140221e-06, 1.2609335727e-06, 1.144472435e-06, 9.5345058071e-07, 7.2907391768e-07, 5.1171087989e-07, 3.2965331798e-07, 1.9492570402e-07, 1.0579386611e-07, 5.270264225e-08, 2.4098120832e-08, 1.0113783588e-08, 3.896059031e-09, 1.3775781627e-09, 4.4708234337e-10, 1.3317907888e-10, 3.6413785182e-11, 9.1384920464e-12, 2.1050526773e-12, 4.4507285227e-13, 8.6373352318e-14, 1.5385377705e-14
			 , 3.328093829e-16, 2.350064113e-15, 1.523155991e-14, 9.0612467616e-14, 4.947798898e-13, 2.4797906784e-12, 1.1407623977e-11, 4.8168070227e-11, 1.8668117052e-10, 6.6408289978e-10, 2.1683261853e-09, 6.4983658454e-09, 1.7875782632e-08, 4.5134363802e-08, 1.0459863375e-07, 2.2249817277e-07, 4.3441593789e-07, 7.7851177593e-07, 1.2805753613e-06, 1.9334083845e-06, 2.6793047709e-06, 3.4080062505e-06, 3.9788533286e-06, 4.2637839215e-06, 4.1938587856e-06, 3.7862564568e-06, 3.1375191156e-06, 2.3864001832e-06, 1.6660155779e-06, 1.0675686326e-06, 6.2790070388e-07, 3.3897390495e-07, 1.6796612101e-07, 7.6393284587e-08, 3.1891108421e-08, 1.2219812717e-08, 4.2977306158e-09, 1.3873687754e-09, 4.1107886539e-10, 1.1179883408e-10, 2.7908076891e-11, 6.3944366295e-12, 1.3447870205e-12, 2.5958938775e-13, 4.5993617985e-14
			 , 1.1891068854e-15, 8.352003205e-15, 5.3844241213e-14, 3.1861416717e-13, 1.7304994243e-12, 8.626971533e-12, 3.9475256397e-11, 1.6579430884e-10, 6.3913946358e-10, 2.2615160855e-09, 7.3449011317e-09, 2.1895267821e-08, 5.9909304184e-08, 1.5045921486e-07, 3.4683378658e-07, 7.338467185e-07, 1.4251776292e-06, 2.5404576718e-06, 4.1565654101e-06, 6.2421840994e-06, 8.6043446572e-06, 1.0886302334e-05, 1.264216462e-05, 1.347541729e-05, 1.3183888768e-05, 1.1839236322e-05, 9.7585025287e-06, 7.3828559835e-06, 5.1267684285e-06, 3.2677069157e-06, 1.9117092052e-06, 1.0265503079e-06, 5.0596344181e-07, 2.2889534534e-07, 9.5046139847e-08, 3.6225348055e-08, 1.2672709993e-08, 4.0691880976e-09, 1.1992874471e-09, 3.2442937226e-10, 8.055563161e-11, 1.8359098963e-11, 3.8404891246e-12, 7.3739988725e-13, 1.2995638907e-13
			 , 4.0156900293e-15, 2.8055017009e-14, 1.7990425501e-13, 1.0588928822e-12, 5.7206205918e-12, 2.8366982374e-11, 1.2911015312e-10, 5.3937682098e-10, 2.0682342505e-09, 7.2792682992e-09, 2.3515655201e-08, 6.9727697394e-08, 1.8977213756e-07, 4.7406828685e-07, 1.0869947573e-06, 2.2876715775e-06, 4.4191710913e-06, 7.8355033111e-06, 1.2751857867e-05, 1.9048418835e-05, 2.611702439e-05, 3.2867672417e-05, 3.7965884985e-05, 4.0252998588e-05, 3.9172660763e-05, 3.4990225686e-05, 2.8687303711e-05, 2.1588042728e-05, 1.491131934e-05, 9.4536562756e-06, 5.5012528719e-06, 2.9383529636e-06, 1.4405422917e-06, 6.4822671675e-07, 2.6773673767e-07, 1.0150081664e-07, 3.5319160929e-08, 1.1280546275e-08, 3.3069711414e-09, 8.8983687085e-10, 2.1977125675e-10, 4.9820658016e-11, 1.0366414324e-11, 1.9798236401e-12, 3.4706037957e-13
			 , 1.2817577844e-14, 8.907214159e-14, 5.6814069508e-13, 3.3262093167e-12, 1.7874084157e-11, 8.8160916067e-11, 3.9912345651e-10, 1.6585227636e-09, 6.3257736826e-09, 2.2145462353e-08, 7.1160208392e-08, 2.0987857852e-07, 5.6817276572e-07, 1.4117933915e-06, 3.2198943245e-06, 6.7404948823e-06, 1.2951546523e-05, 2.2841846658e-05, 3.6976151023e-05, 5.494020661e-05, 7.4927105743e-05, 9.3792332336e-05, 0.00010776443378, 0.00011364837701, 0.00011000985251, 9.7741452919e-05, 7.9708617704e-05, 5.9663994762e-05, 4.0991955757e-05, 2.5850269594e-05, 1.496274399e-05, 7.9494429883e-06, 3.876521987e-06, 1.7351086399e-06, 7.1283864145e-07, 2.6880385917e-07, 9.3037982651e-08, 2.9557300607e-08, 8.6188105541e-09, 2.3068069677e-09, 5.6670107496e-10, 1.277840056e-10, 2.644708931e-11, 5.0241269478e-12, 8.7603486748e-13
			 , 3.8668802318e-14, 2.6728665396e-13, 1.6958053885e-12, 9.8753947728e-12, 5.2785154719e-11, 2.5896915168e-10, 1.1661754895e-09, 4.8201478364e-09, 1.8286749892e-08, 6.3678193385e-08, 2.035289981e-07, 5.970924235e-07, 1.6078166709e-06, 3.9738401938e-06, 9.0149624157e-06, 1.8771475879e-05, 3.5876644688e-05, 6.2936836912e-05, 0.00010133925389, 0.00014977184765, 0.00020317111921, 0.00025297355023, 0.00028911212576, 0.00030327570857, 0.00029200417339, 0.00025805921177, 0.00020932899497, 0.00015585501387, 0.00010650995682, 6.6809734562e-05, 3.8465288526e-05, 2.0327199309e-05, 9.8597847682e-06, 4.3897057367e-06, 1.7938390329e-06, 6.7283912131e-07, 2.3164275831e-07, 7.319898998e-08, 2.123113596e-08, 5.6522462266e-09, 1.3811694011e-09, 3.0977939658e-10, 6.3773146486e-11, 1.2050461323e-11, 2.0900180458e-12
			 , 1.1026142971e-13, 7.5810158932e-13, 4.784180864e-12, 2.7712030587e-11, 1.4733596287e-10, 7.189986384e-10, 3.2205280664e-09, 1.3240619268e-08, 4.9965095172e-08, 1.7306358302e-07, 5.5020529999e-07, 1.6055474816e-06, 4.3003283281e-06, 1.0572054634e-05, 2.385591506e-05, 4.9409864005e-05, 9.393144137e-05, 0.00016390309611, 0.00026250857627, 0.00038590381155, 0.00052070937818, 0.0006448974018, 0.00073310424341, 0.0007649276522, 0.00073258008342, 0.0006439757999, 0.00051959301345, 0.00038480130024, 0.00026157143293, 0.00016320105351, 9.3462054792e-05, 4.9127993407e-05, 2.3702839826e-05, 1.0496687537e-05, 4.2666188165e-06, 1.5918212739e-06, 5.4511355074e-07, 1.7133940844e-07, 4.9431893245e-08, 1.3089956674e-08, 3.1816118629e-09, 7.0980116229e-10, 1.4534723425e-10, 2.7318374993e-11, 4.7128490346e-12
			 , 2.9716577506e-13, 2.0322745223e-12, 1.2756989042e-11, 7.3500788789e-11, 3.8870237584e-10, 1.8867691853e-09, 8.4062392602e-09, 3.4376846259e-08, 1.2903525715e-07, 4.4456007231e-07, 1.4058281295e-06, 4.0805107346e-06, 1.0871155609e-05, 2.6583769795e-05, 5.9667519963e-05, 0.00012292456813, 0.00023244418844, 0.00040343948058, 0.00064271502197, 0.00093980587553, 0.001261355821, 0.0015538751613, 0.0017570104683, 0.0018235300668, 0.0017371228896, 0.0015188977122, 0.0012190069538, 0.00089797232067, 0.00060715473955, 0.00037680458627, 0.00021464079327, 0.00011222464673, 5.3857223975e-05, 2.3723554477e-05, 9.5916657301e-06, 3.5594987366e-06, 1.212449888e-06, 3.7906841044e-07, 1.0878051171e-07, 2.865272819e-08, 6.9272054759e-09, 1.5372069173e-09, 3.1309996262e-10, 5.853514895e-11, 1.0044503423e-11
			 , 7.5697168802e-13, 5.1493076296e-12, 3.2151115104e-11, 1.842572761e-10, 9.6923991055e-10, 4.6797046238e-09, 2.0738880835e-08, 8.4359257357e-08, 3.1496202268e-07, 1.0793536376e-06, 3.3950693705e-06, 9.8019854704e-06, 2.5975239623e-05, 6.3180632424e-05, 0.00014105487207, 0.00028904981446, 0.00054367107805, 0.00093859760091, 0.0014873143518, 0.0021632455755, 0.0028879400343, 0.003538754303, 0.0039800852537, 0.0041087968275, 0.0038932813331, 0.0033860772382, 0.0027030708734, 0.001980607165, 0.0013320432045, 0.00082227750681, 0.00046590543934, 0.00024230216513, 0.00011566354806, 5.0677477702e-05, 2.0380462956e-05, 7.5230082075e-06, 2.5488859592e-06, 7.9266067132e-07, 2.2625798124e-07, 5.9279138043e-08, 1.4255378211e-08, 3.1465547945e-09, 6.3748611945e-10, 1.1854593696e-10, 2.0234067893e-11
			 , 1.8225184816e-12, 1.2331712908e-11, 7.6586910425e-11, 4.365816042e-10, 2.28432806e-09, 1.0970538256e-08, 4.8358881344e-08, 1.9566212472e-07, 7.2663470974e-07, 2.4768862659e-06, 7.749521501e-06, 2.2254784199e-05, 5.8661400544e-05, 0.00014192533854, 0.00031517163734, 0.00064241443761, 0.0012018833077, 0.0020639018621, 0.0032530871686, 0.0047063310631, 0.0062495437451, 0.0076171704568, 0.0085215643048, 0.0087503362447, 0.0082472506911, 0.0071346648037, 0.0056652366184, 0.0041289748624, 0.0027621404734, 0.0016960129142, 0.00095585512463, 0.0004944644752, 0.00023477789364, 0.00010231978376, 4.0930000978e-05, 1.5028054804e-05, 5.0645999181e-06, 1.5666269064e-06, 4.4480179895e-07, 1.1591701821e-07, 2.7727246277e-08, 6.0876041985e-09, 1.2267750149e-09, 2.2691627743e-10, 3.8525085899e-11
			 , 4.147366478e-12, 2.7913081568e-11, 1.724333315e-10, 9.7772345775e-10, 5.0884989555e-09, 2.4307746926e-08, 1.0658071403e-07, 4.2893574914e-07, 1.5844726704e-06, 5.3722642406e-06, 1.671897553e-05, 4.775751222e-05, 0.00012521426834, 0.00030133200926, 0.00066560471896, 0.0013494824525, 0.0025112964213, 0.0042895134538, 0.0067250914872, 0.0096776094288, 0.012782554142, 0.01549696736, 0.017244694754, 0.017613448203, 0.016512474045, 0.014208900742, 0.011222465895, 0.0081357164308, 0.0054135583341, 0.0033063553274, 0.0018535151612, 0.00095372350188, 0.00045043081627, 0.00019526015967, 7.7692537161e-05, 2.8374211979e-05, 9.5114974101e-06, 2.9265318062e-06, 8.2648944044e-07, 2.1424045826e-07, 5.0973508081e-08, 1.1131890965e-08, 2.2313733083e-09, 4.1053899169e-10, 6.9329347818e-11
			 , 8.9203488346e-12, 5.9717210343e-11, 3.6694292049e-10, 2.0695563041e-09, 1.0713585574e-08, 5.0906372451e-08, 2.2201849958e-07, 8.8876282689e-07, 3.2655916584e-06, 1.1013303265e-05, 3.4092074202e-05, 9.6865464002e-05, 0.00025261819246, 0.00060469890013, 0.0013285999885, 0.0026793458965, 0.0049595544115, 0.0084262900054, 0.013140439987, 0.018808895722, 0.024711325765, 0.029799463227, 0.032983828336, 0.033509895205, 0.031248167157, 0.026745835319, 0.021011995152, 0.015151586384, 0.010028325021, 0.0060922689736, 0.0033971052617, 0.00173867587, 0.00081678503193, 0.00035219002166, 0.00013938812481, 5.0635400839e-05, 1.6883514036e-05, 5.1671408983e-06, 1.451502726e-06, 3.7425289179e-07, 8.8571120216e-08, 1.9239760007e-08, 3.8360585819e-09, 7.0202432756e-10, 1.1792239407e-10
			 , 1.8134277066e-11, 1.207547673e-10, 7.3804967693e-10, 4.1404333295e-09, 2.1320005317e-08, 1.0076472989e-07, 4.3712677211e-07, 1.7405578774e-06, 6.3613310886e-06, 2.1339646992e-05, 6.5706233727e-05, 0.0001856971503, 0.00048170905211, 0.0011469457531, 0.0025065781083, 0.005028042011, 0.0092575587332, 0.01564492844, 0.024267796427, 0.034551527351, 0.045152693987, 0.054160099477, 0.0596287027, 0.060257468373, 0.055891502649, 0.04758399725, 0.037183944136, 0.026670416817, 0.017558347434, 0.010610048659, 0.0058847879991, 0.002995877061, 0.0013998987852, 0.00060041208053, 0.00023636419792, 8.5406958533e-05, 2.8326006941e-05, 8.6229674707e-06, 2.4093940283e-06, 6.1792906081e-07, 1.4546171201e-07, 3.1429575387e-08, 6.2331562134e-09, 1.1346398265e-09, 1.8957757586e-10
			 , 3.4843967989e-11, 2.307875141e-10, 1.4030641093e-09, 7.8293211914e-09, 4.0100402998e-08, 1.8851793016e-07, 8.1346018987e-07, 3.2218140404e-06, 1.1712335436e-05, 3.9081052819e-05, 0.00011969310435, 0.00033647398232, 0.00086818839191, 0.0020561555866, 0.0044696838595, 0.0089182248339, 0.016332749277, 0.027454914525, 0.042360432446, 0.059990212321, 0.077979497612, 0.093037866056, 0.10188701749, 0.10241366178, 0.094487927854, 0.080015599728, 0.062194619328, 0.044372159988, 0.029056802392, 0.017464857548, 0.0096352240071, 0.0048790862784, 0.0022677462548, 0.0009674540488, 0.00037883155164, 0.0001361573959, 4.4917629566e-05, 1.3601002138e-05, 3.7801230519e-06, 9.6431790553e-07, 2.2579497738e-07, 4.8527599716e-08, 9.5728536209e-09, 1.7333032787e-09, 2.8806185215e-10
			 , 6.3279874396e-11, 4.1690303987e-10, 2.5210613597e-09, 1.3993019188e-08, 7.1288582149e-08, 3.3335504668e-07, 1.4307829588e-06, 5.6366438912e-06, 2.0382056391e-05, 6.76478885e-05, 0.00020608208433, 0.0005762433284, 0.0014789445559, 0.0034839923028, 0.0075332396664, 0.014950877056, 0.027235239744, 0.045538153499, 0.069887422025, 0.098447062075, 0.12728753686, 0.15105977654, 0.1645475626, 0.16451813281, 0.15097874403, 0.12717378139, 0.098323836923, 0.069775037467, 0.045448645949, 0.027172008529, 0.014910830185, 0.0075103780255, 0.003472175682, 0.0014734007418, 0.00057387852576, 0.00020516278164, 6.7322107498e-05, 2.0276607756e-05, 5.6054877859e-06, 1.4223643348e-06, 3.3127508914e-07, 7.0818316544e-08, 1.3895754769e-08, 2.5026400952e-09, 4.1370917803e-10
			 , 1.0862049454e-10, 7.1181038841e-10, 4.281498267e-09, 2.3637927171e-08, 1.1978416126e-07, 5.5714878044e-07, 2.3785978556e-06, 9.3207609098e-06, 3.3524433093e-05, 0.00011067543528, 0.00033536730916, 0.0009327600128, 0.0023812172003, 0.0055796611123, 0.012000416405, 0.023689972237, 0.04292518273, 0.071390412748, 0.10898005217, 0.15269824862, 0.19638155401, 0.23181794584, 0.25117307901, 0.24979224801, 0.22801549733, 0.19104231894, 0.14691780508, 0.1037048623, 0.067189827561, 0.039956513792, 0.021809764206, 0.01092684269, 0.0050247875042, 0.0021209029946, 0.00082168012159, 0.00029218997224, 9.5369163319e-05, 2.8571212169e-05, 7.8565217336e-06, 1.9829476514e-06, 4.5937977688e-07, 9.7681478906e-08, 1.9064781753e-08, 3.4153313511e-09, 5.6157928308e-10
			 , 1.7622441006e-10, 1.1486892548e-09, 6.8725500846e-09, 3.7740893077e-08, 1.9023401876e-07, 8.8012069455e-07, 3.7374588828e-06, 1.4567676772e-05, 5.211748794e-05, 0.00017114206275, 0.00051583402092, 0.0014270629035, 0.0036237256136, 0.0084459288046, 0.01806839928, 0.035478983074, 0.063944384456, 0.10578241199, 0.16062165797, 0.22385896742, 0.28636804223, 0.33624389768, 0.36237969995, 0.35847020149, 0.32547831535, 0.27125060558, 0.20749089122, 0.1456823796, 0.093884699047, 0.055534418672, 0.030151527375, 0.015025748871, 0.0068729482591, 0.0028855544515, 0.0011119749397, 0.00039331510197, 0.00012769291061, 3.8051468437e-05, 1.0407733498e-05, 2.6128918762e-06, 6.0209578123e-07, 1.2734722077e-07, 2.4722488945e-08, 4.4053081183e-09, 7.2050876376e-10
			 , 2.7022842297e-10, 1.7520631612e-09, 1.0426732366e-08, 5.6954611694e-08, 2.8555302833e-07, 1.3140876263e-06, 5.5506111494e-06, 2.151983972e-05, 7.6580137829e-05, 0.00025013388949, 0.00074990984285, 0.0020635977853, 0.0052122040652, 0.012083613314, 0.02571294643, 0.050221189857, 0.090032987297, 0.14814813435, 0.22375375032, 0.31018736959, 0.39469131827, 0.46096813679, 0.49415573478, 0.48622405529, 0.43912571669, 0.36401635408, 0.27696996927, 0.19343014061, 0.12399250269, 0.072953537107, 0.039398252964, 0.019529322162, 0.0088854003698, 0.0037106222007, 0.0014223156031, 0.00050040875794, 0.00016159747611, 4.7898589401e-05, 1.303139743e-05, 3.2541604469e-06, 7.4587671861e-07, 1.5691844624e-07, 3.0301258391e-08, 5.3706421532e-09, 8.737217061e-10
			 , 3.916553748e-10, 2.5258406477e-09, 1.4951623939e-08, 8.1236201765e-08, 4.0512836108e-07, 1.8544441218e-06, 7.791405551e-06, 3.0046667234e-05, 0.00010635465878, 0.00034553866135, 0.0010304251919, 0.0028204370756, 0.0070859133266, 0.016340110451, 0.034585449845, 0.067191138864, 0.11981468648, 0.19610469043, 0.29460862279, 0.40624010563, 0.51416176558, 0.59730541706, 0.63690233231, 0.62334567308, 0.55996990204, 0.46172165871, 0.34944227338, 0.24274507165, 0.15477648377, 0.090581484139, 0.04865789786, 0.023990936577, 0.010857267305, 0.0045099714771, 0.0017195164692, 0.00060175370891, 0.00019329106726, 5.6987948483e-05, 1.5421790522e-05, 3.830602509e-06, 8.7332983867e-07, 1.8275478908e-07, 3.5102640794e-08, 6.1885669922e-09, 1.0014288288e-09
			 , 5.3652027265e-10, 3.4416913763e-09, 2.0264648626e-08, 1.0951769269e-07, 5.4326181953e-07, 2.4735131774e-06, 1.0337095773e-05, 3.965176802e-05, 0.00013960670913, 0.00045115951798, 0.0013382370817, 0.0036434810609, 0.0091049904004, 0.020884402096, 0.043968748301, 0.084966138005, 0.15070493519, 0.24535156786, 0.36663162708, 0.50286406279, 0.63306897879, 0.73152828217, 0.77587360144, 0.7553191781, 0.67491602898, 0.55353963375, 0.41670367122, 0.28792923689, 0.18260966241, 0.10630206764, 0.056798785925, 0.027855848894, 0.012539292686, 0.0051809549332, 0.0019648340531, 0.00068394606933, 0.00021852318605, 6.408457557e-05, 1.7249973098e-05, 4.2619017222e-06, 9.6649262105e-07, 2.0117393262e-07, 3.8434940564e-08, 6.7399827941e-09, 1.0848555387e-09
			 , 6.9467176456e-10, 4.4324979243e-09, 2.5959549177e-08, 1.3954885958e-07, 6.8855007385e-07, 3.1183383271e-06, 1.2962556866e-05, 4.9458139983e-05, 0.00017320699408, 0.00055676558986, 0.0016427029623, 0.0044486271217, 0.011057885364, 0.025228891522, 0.052832838148, 0.10155215114, 0.17916539311, 0.29013422132, 0.43124428391, 0.58833885193, 0.73673510551, 0.84678846598, 0.8933429718, 0.86504995823, 0.76885396242, 0.62722915411, 0.46966513991, 0.32279747725, 0.20363460481, 0.11791062355, 0.062666252255, 0.030569938943, 0.013687840663, 0.0056254207157, 0.0021220440976, 0.00073474034434, 0.00023350333504, 6.8113338784e-05, 1.8236898541e-05, 4.4817606977e-06, 1.0109434925e-06, 2.0930751532e-07, 3.9776047345e-08, 6.9380612366e-09, 1.1108003406e-09
			 , 8.5011564455e-10, 5.3954893886e-09, 3.1431493852e-08, 1.6806482961e-07, 8.2483819597e-07, 3.7156980852e-06, 1.5363571947e-05, 5.8307341533e-05, 0.00020311125263, 0.00064941786695, 0.001905875979, 0.0051338705234, 0.012693292461, 0.028806060553, 0.060002960265, 0.11472059041, 0.20132131875, 0.32427841425, 0.47943085432, 0.65059918165, 0.81036531925, 0.92646247149, 0.97219759226, 0.93639904261, 0.82784128189, 0.67175805569, 0.50033217669, 0.34204539657, 0.21462909877, 0.12361560017, 0.065348818898, 0.031708940864, 0.014122298919, 0.0057730991393, 0.0021661657374, 0.00074602721725, 0.00023582899303, 6.8425790232e-05, 1.8223077859e-05, 4.4545577111e-06, 9.9946112186e-07, 2.058289823e-07, 3.8906843969e-08, 6.7503651557e-09, 1.0749994228e-09
			 , 9.8330776854e-10, 6.2076237484e-09, 3.597005005e-08, 1.9130960993e-07, 9.3392725375e-07, 4.1847333705e-06, 1.7210864826e-05, 6.4970590756e-05, 0.00022511846328, 0.00071595358895, 0.0020899628289, 0.005599798169, 0.013771627098, 0.031086960807, 0.064409606159, 0.1224906072, 0.2138132602, 0.34256762266, 0.50377625227, 0.67999958992, 0.84247964621, 0.95805370808, 1, 0.95805370808, 0.84247964621, 0.67999958992, 0.50377625227, 0.34256762266, 0.2138132602, 0.1224906072, 0.064409606159, 0.031086960807, 0.013771627098, 0.005599798169, 0.0020899628289, 0.00071595358895, 0.00022511846328, 6.4970590756e-05, 1.7210864826e-05, 4.1847333705e-06, 9.3392725375e-07, 1.9130960993e-07, 3.597005005e-08, 6.2076237484e-09, 9.8330776854e-10
			,  1.0749994228e-09, 6.7503651557e-09, 3.8906843969e-08, 2.058289823e-07, 9.9946112186e-07, 4.4545577111e-06, 1.8223077859e-05, 6.8425790232e-05, 0.00023582899303, 0.00074602721725, 0.0021661657374, 0.0057730991393, 0.014122298919, 0.031708940864, 0.065348818898, 0.12361560017, 0.21462909877, 0.34204539657, 0.50033217669, 0.67175805569, 0.82784128189, 0.93639904261, 0.97219759226, 0.92646247149, 0.81036531925, 0.65059918165, 0.47943085432, 0.32427841425, 0.20132131875, 0.11472059041, 0.060002960265, 0.028806060553, 0.012693292461, 0.0051338705234, 0.001905875979, 0.00064941786695, 0.00020311125263, 5.8307341533e-05, 1.5363571947e-05, 3.7156980852e-06, 8.2483819597e-07, 1.6806482961e-07, 3.1431493852e-08, 5.3954893886e-09, 8.5011564455e-10
			 , 1.1108003406e-09, 6.9380612366e-09, 3.9776047345e-08, 2.0930751532e-07, 1.0109434925e-06, 4.4817606977e-06, 1.8236898541e-05, 6.8113338784e-05, 0.00023350333504, 0.00073474034434, 0.0021220440976, 0.0056254207157, 0.013687840663, 0.030569938943, 0.062666252255, 0.11791062355, 0.20363460481, 0.32279747725, 0.46966513991, 0.62722915411, 0.76885396242, 0.86504995823, 0.8933429718, 0.84678846598, 0.73673510551, 0.58833885193, 0.43124428391, 0.29013422132, 0.17916539311, 0.10155215114, 0.052832838148, 0.025228891522, 0.011057885364, 0.0044486271217, 0.0016427029623, 0.00055676558986, 0.00017320699408, 4.9458139983e-05, 1.2962556866e-05, 3.1183383271e-06, 6.8855007385e-07, 1.3954885958e-07, 2.5959549177e-08, 4.4324979243e-09, 6.9467176456e-10
			 , 1.0848555387e-09, 6.7399827941e-09, 3.8434940564e-08, 2.0117393262e-07, 9.6649262105e-07, 4.2619017222e-06, 1.7249973098e-05, 6.408457557e-05, 0.00021852318605, 0.00068394606933, 0.0019648340531, 0.0051809549332, 0.012539292686, 0.027855848894, 0.056798785925, 0.10630206764, 0.18260966241, 0.28792923689, 0.41670367122, 0.55353963375, 0.67491602898, 0.7553191781, 0.77587360144, 0.73152828217, 0.63306897879, 0.50286406279, 0.36663162708, 0.24535156786, 0.15070493519, 0.084966138005, 0.043968748301, 0.020884402096, 0.0091049904004, 0.0036434810609, 0.0013382370817, 0.00045115951798, 0.00013960670913, 3.965176802e-05, 1.0337095773e-05, 2.4735131774e-06, 5.4326181953e-07, 1.0951769269e-07, 2.0264648626e-08, 3.4416913763e-09, 5.3652027265e-10
			 , 1.0014288288e-09, 6.1885669922e-09, 3.5102640794e-08, 1.8275478908e-07, 8.7332983867e-07, 3.830602509e-06, 1.5421790522e-05, 5.6987948483e-05, 0.00019329106726, 0.00060175370891, 0.0017195164692, 0.0045099714771, 0.010857267305, 0.023990936577, 0.04865789786, 0.090581484139, 0.15477648377, 0.24274507165, 0.34944227338, 0.46172165871, 0.55996990204, 0.62334567308, 0.63690233231, 0.59730541706, 0.51416176558, 0.40624010563, 0.29460862279, 0.19610469043, 0.11981468648, 0.067191138864, 0.034585449845, 0.016340110451, 0.0070859133266, 0.0028204370756, 0.0010304251919, 0.00034553866135, 0.00010635465878, 3.0046667234e-05, 7.791405551e-06, 1.8544441218e-06, 4.0512836108e-07, 8.1236201765e-08, 1.4951623939e-08, 2.5258406477e-09, 3.916553748e-10
			 , 8.737217061e-10, 5.3706421532e-09, 3.0301258391e-08, 1.5691844624e-07, 7.4587671861e-07, 3.2541604469e-06, 1.303139743e-05, 4.7898589401e-05, 0.00016159747611, 0.00050040875794, 0.0014223156031, 0.0037106222007, 0.0088854003698, 0.019529322162, 0.039398252964, 0.072953537107, 0.12399250269, 0.19343014061, 0.27696996927, 0.36401635408, 0.43912571669, 0.48622405529, 0.49415573478, 0.46096813679, 0.39469131827, 0.31018736959, 0.22375375032, 0.14814813435, 0.090032987297, 0.050221189857, 0.02571294643, 0.012083613314, 0.0052122040652, 0.0020635977853, 0.00074990984285, 0.00025013388949, 7.6580137829e-05, 2.151983972e-05, 5.5506111494e-06, 1.3140876263e-06, 2.8555302833e-07, 5.6954611694e-08, 1.0426732366e-08, 1.7520631612e-09, 2.7022842297e-10
			 , 7.2050876376e-10, 4.4053081183e-09, 2.4722488945e-08, 1.2734722077e-07, 6.0209578123e-07, 2.6128918762e-06, 1.0407733498e-05, 3.8051468437e-05, 0.00012769291061, 0.00039331510197, 0.0011119749397, 0.0028855544515, 0.0068729482591, 0.015025748871, 0.030151527375, 0.055534418672, 0.093884699047, 0.1456823796, 0.20749089122, 0.27125060558, 0.32547831535, 0.35847020149, 0.36237969995, 0.33624389768, 0.28636804223, 0.22385896742, 0.16062165797, 0.10578241199, 0.063944384456, 0.035478983074, 0.01806839928, 0.0084459288046, 0.0036237256136, 0.0014270629035, 0.00051583402092, 0.00017114206275, 5.211748794e-05, 1.4567676772e-05, 3.7374588828e-06, 8.8012069455e-07, 1.9023401876e-07, 3.7740893077e-08, 6.8725500846e-09, 1.1486892548e-09, 1.7622441006e-10
			 , 5.6157928308e-10, 3.4153313511e-09, 1.9064781753e-08, 9.7681478906e-08, 4.5937977688e-07, 1.9829476514e-06, 7.8565217336e-06, 2.8571212169e-05, 9.5369163319e-05, 0.00029218997224, 0.00082168012159, 0.0021209029946, 0.0050247875042, 0.01092684269, 0.021809764206, 0.039956513792, 0.067189827561, 0.1037048623, 0.14691780508, 0.19104231894, 0.22801549733, 0.24979224801, 0.25117307901, 0.23181794584, 0.19638155401, 0.15269824862, 0.10898005217, 0.071390412748, 0.04292518273, 0.023689972237, 0.012000416405, 0.0055796611123, 0.0023812172003, 0.0009327600128, 0.00033536730916, 0.00011067543528, 3.3524433093e-05, 9.3207609098e-06, 2.3785978556e-06, 5.5714878044e-07, 1.1978416126e-07, 2.3637927171e-08, 4.281498267e-09, 7.1181038841e-10, 1.0862049454e-10
			 , 4.1370917803e-10, 2.5026400952e-09, 1.3895754769e-08, 7.0818316544e-08, 3.3127508914e-07, 1.4223643348e-06, 5.6054877859e-06, 2.0276607756e-05, 6.7322107498e-05, 0.00020516278164, 0.00057387852576, 0.0014734007418, 0.003472175682, 0.0075103780255, 0.014910830185, 0.027172008529, 0.045448645949, 0.069775037467, 0.098323836923, 0.12717378139, 0.15097874403, 0.16451813281, 0.1645475626, 0.15105977654, 0.12728753686, 0.098447062075, 0.069887422025, 0.045538153499, 0.027235239744, 0.014950877056, 0.0075332396664, 0.0034839923028, 0.0014789445559, 0.0005762433284, 0.00020608208433, 6.76478885e-05, 2.0382056391e-05, 5.6366438912e-06, 1.4307829588e-06, 3.3335504668e-07, 7.1288582149e-08, 1.3993019188e-08, 2.5210613597e-09, 4.1690303987e-10, 6.3279874396e-11
			 , 2.8806185215e-10, 1.7333032787e-09, 9.5728536209e-09, 4.8527599716e-08, 2.2579497738e-07, 9.6431790553e-07, 3.7801230519e-06, 1.3601002138e-05, 4.4917629566e-05, 0.0001361573959, 0.00037883155164, 0.0009674540488, 0.0022677462548, 0.0048790862784, 0.0096352240071, 0.017464857548, 0.029056802392, 0.044372159988, 0.062194619328, 0.080015599728, 0.094487927854, 0.10241366178, 0.10188701749, 0.093037866056, 0.077979497612, 0.059990212321, 0.042360432446, 0.027454914525, 0.016332749277, 0.0089182248339, 0.0044696838595, 0.0020561555866, 0.00086818839191, 0.00033647398232, 0.00011969310435, 3.9081052819e-05, 1.1712335436e-05, 3.2218140404e-06, 8.1346018987e-07, 1.8851793016e-07, 4.0100402998e-08, 7.8293211914e-09, 1.4030641093e-09, 2.307875141e-10, 3.4843967989e-11
			 , 1.8957757586e-10, 1.1346398265e-09, 6.2331562134e-09, 3.1429575387e-08, 1.4546171201e-07, 6.1792906081e-07, 2.4093940283e-06, 8.6229674707e-06, 2.8326006941e-05, 8.5406958533e-05, 0.00023636419792, 0.00060041208053, 0.0013998987852, 0.002995877061, 0.0058847879991, 0.010610048659, 0.017558347434, 0.026670416817, 0.037183944136, 0.04758399725, 0.055891502649, 0.060257468373, 0.0596287027, 0.054160099477, 0.045152693987, 0.034551527351, 0.024267796427, 0.01564492844, 0.0092575587332, 0.005028042011, 0.0025065781083, 0.0011469457531, 0.00048170905211, 0.0001856971503, 6.5706233727e-05, 2.1339646992e-05, 6.3613310886e-06, 1.7405578774e-06, 4.3712677211e-07, 1.0076472989e-07, 2.1320005317e-08, 4.1404333295e-09, 7.3804967693e-10, 1.207547673e-10, 1.8134277066e-11
			 , 1.1792239407e-10, 7.0202432756e-10, 3.8360585819e-09, 1.9239760007e-08, 8.8571120216e-08, 3.7425289179e-07, 1.451502726e-06, 5.1671408983e-06, 1.6883514036e-05, 5.0635400839e-05, 0.00013938812481, 0.00035219002166, 0.00081678503193, 0.00173867587, 0.0033971052617, 0.0060922689736, 0.010028325021, 0.015151586384, 0.021011995152, 0.026745835319, 0.031248167157, 0.033509895205, 0.032983828336, 0.029799463227, 0.024711325765, 0.018808895722, 0.013140439987, 0.0084262900054, 0.0049595544115, 0.0026793458965, 0.0013285999885, 0.00060469890013, 0.00025261819246, 9.6865464002e-05, 3.4092074202e-05, 1.1013303265e-05, 3.2655916584e-06, 8.8876282689e-07, 2.2201849958e-07, 5.0906372451e-08, 1.0713585574e-08, 2.0695563041e-09, 3.6694292049e-10, 5.9717210343e-11, 8.9203488346e-12
			 , 6.9329347818e-11, 4.1053899169e-10, 2.2313733083e-09, 1.1131890965e-08, 5.0973508081e-08, 2.1424045826e-07, 8.2648944044e-07, 2.9265318062e-06, 9.5114974101e-06, 2.8374211979e-05, 7.7692537161e-05, 0.00019526015967, 0.00045043081627, 0.00095372350188, 0.0018535151612, 0.0033063553274, 0.0054135583341, 0.0081357164308, 0.011222465895, 0.014208900742, 0.016512474045, 0.017613448203, 0.017244694754, 0.01549696736, 0.012782554142, 0.0096776094288, 0.0067250914872, 0.0042895134538, 0.0025112964213, 0.0013494824525, 0.00066560471896, 0.00030133200926, 0.00012521426834, 4.775751222e-05, 1.671897553e-05, 5.3722642406e-06, 1.5844726704e-06, 4.2893574914e-07, 1.0658071403e-07, 2.4307746926e-08, 5.0884989555e-09, 9.7772345775e-10, 1.724333315e-10, 2.7913081568e-11, 4.147366478e-12
			 , 3.8525085899e-11, 2.2691627743e-10, 1.2267750149e-09, 6.0876041985e-09, 2.7727246277e-08, 1.1591701821e-07, 4.4480179895e-07, 1.5666269064e-06, 5.0645999181e-06, 1.5028054804e-05, 4.0930000978e-05, 0.00010231978376, 0.00023477789364, 0.0004944644752, 0.00095585512463, 0.0016960129142, 0.0027621404734, 0.0041289748624, 0.0056652366184, 0.0071346648037, 0.0082472506911, 0.0087503362447, 0.0085215643048, 0.0076171704568, 0.0062495437451, 0.0047063310631, 0.0032530871686, 0.0020639018621, 0.0012018833077, 0.00064241443761, 0.00031517163734, 0.00014192533854, 5.8661400544e-05, 2.2254784199e-05, 7.749521501e-06, 2.4768862659e-06, 7.2663470974e-07, 1.9566212472e-07, 4.8358881344e-08, 1.0970538256e-08, 2.28432806e-09, 4.365816042e-10, 7.6586910425e-11, 1.2331712908e-11, 1.8225184816e-12
			 , 2.0234067893e-11, 1.1854593696e-10, 6.3748611945e-10, 3.1465547945e-09, 1.4255378211e-08, 5.9279138043e-08, 2.2625798124e-07, 7.9266067132e-07, 2.5488859592e-06, 7.5230082075e-06, 2.0380462956e-05, 5.0677477702e-05, 0.00011566354806, 0.00024230216513, 0.00046590543934, 0.00082227750681, 0.0013320432045, 0.001980607165, 0.0027030708734, 0.0033860772382, 0.0038932813331, 0.0041087968275, 0.0039800852537, 0.003538754303, 0.0028879400343, 0.0021632455755, 0.0014873143518, 0.00093859760091, 0.00054367107805, 0.00028904981446, 0.00014105487207, 6.3180632424e-05, 2.5975239623e-05, 9.8019854704e-06, 3.3950693705e-06, 1.0793536376e-06, 3.1496202268e-07, 8.4359257357e-08, 2.0738880835e-08, 4.6797046238e-09, 9.6923991055e-10, 1.842572761e-10, 3.2151115104e-11, 5.1493076296e-12, 7.5697168802e-13
			 , 1.0044503423e-11, 5.853514895e-11, 3.1309996262e-10, 1.5372069173e-09, 6.9272054759e-09, 2.865272819e-08, 1.0878051171e-07, 3.7906841044e-07, 1.212449888e-06, 3.5594987366e-06, 9.5916657301e-06, 2.3723554477e-05, 5.3857223975e-05, 0.00011222464673, 0.00021464079327, 0.00037680458627, 0.00060715473955, 0.00089797232067, 0.0012190069538, 0.0015188977122, 0.0017371228896, 0.0018235300668, 0.0017570104683, 0.0015538751613, 0.001261355821, 0.00093980587553, 0.00064271502197, 0.00040343948058, 0.00023244418844, 0.00012292456813, 5.9667519963e-05, 2.6583769795e-05, 1.0871155609e-05, 4.0805107346e-06, 1.4058281295e-06, 4.4456007231e-07, 1.2903525715e-07, 3.4376846259e-08, 8.4062392602e-09, 1.8867691853e-09, 3.8870237584e-10, 7.3500788789e-11, 1.2756989042e-11, 2.0322745223e-12, 2.9716577506e-13
			 , 4.7128490346e-12, 2.7318374993e-11, 1.4534723425e-10, 7.0980116229e-10, 3.1816118629e-09, 1.3089956674e-08, 4.9431893245e-08, 1.7133940844e-07, 5.4511355074e-07, 1.5918212739e-06, 4.2666188165e-06, 1.0496687537e-05, 2.3702839826e-05, 4.9127993407e-05, 9.3462054792e-05, 0.00016320105351, 0.00026157143293, 0.00038480130024, 0.00051959301345, 0.0006439757999, 0.00073258008342, 0.0007649276522, 0.00073310424341, 0.0006448974018, 0.00052070937818, 0.00038590381155, 0.00026250857627, 0.00016390309611, 9.393144137e-05, 4.9409864005e-05, 2.385591506e-05, 1.0572054634e-05, 4.3003283281e-06, 1.6055474816e-06, 5.5020529999e-07, 1.7306358302e-07, 4.9965095172e-08, 1.3240619268e-08, 3.2205280664e-09, 7.189986384e-10, 1.4733596287e-10, 2.7712030587e-11, 4.784180864e-12, 7.5810158932e-13, 1.1026142971e-13
			 , 2.0900180458e-12, 1.2050461323e-11, 6.3773146486e-11, 3.0977939658e-10, 1.3811694011e-09, 5.6522462266e-09, 2.123113596e-08, 7.319898998e-08, 2.3164275831e-07, 6.7283912131e-07, 1.7938390329e-06, 4.3897057367e-06, 9.8597847682e-06, 2.0327199309e-05, 3.8465288526e-05, 6.6809734562e-05, 0.00010650995682, 0.00015585501387, 0.00020932899497, 0.00025805921177, 0.00029200417339, 0.00030327570857, 0.00028911212576, 0.00025297355023, 0.00020317111921, 0.00014977184765, 0.00010133925389, 6.2936836912e-05, 3.5876644688e-05, 1.8771475879e-05, 9.0149624157e-06, 3.9738401938e-06, 1.6078166709e-06, 5.970924235e-07, 2.035289981e-07, 6.3678193385e-08, 1.8286749892e-08, 4.8201478364e-09, 1.1661754895e-09, 2.5896915168e-10, 5.2785154719e-11, 9.8753947728e-12, 1.6958053885e-12, 2.6728665396e-13, 3.8668802318e-14
			 , 8.7603486748e-13, 5.0241269478e-12, 2.644708931e-11, 1.277840056e-10, 5.6670107496e-10, 2.3068069677e-09, 8.6188105541e-09, 2.9557300607e-08, 9.3037982651e-08, 2.6880385917e-07, 7.1283864145e-07, 1.7351086399e-06, 3.876521987e-06, 7.9494429883e-06, 1.496274399e-05, 2.5850269594e-05, 4.0991955757e-05, 5.9663994762e-05, 7.9708617704e-05, 9.7741452919e-05, 0.00011000985251, 0.00011364837701, 0.00010776443378, 9.3792332336e-05, 7.4927105743e-05, 5.494020661e-05, 3.6976151023e-05, 2.2841846658e-05, 1.2951546523e-05, 6.7404948823e-06, 3.2198943245e-06, 1.4117933915e-06, 5.6817276572e-07, 2.0987857852e-07, 7.1160208392e-08, 2.2145462353e-08, 6.3257736826e-09, 1.6585227636e-09, 3.9912345651e-10, 8.8160916067e-11, 1.7874084157e-11, 3.3262093167e-12, 5.6814069508e-13, 8.907214159e-14, 1.2817577844e-14
			 , 3.4706037957e-13, 1.9798236401e-12, 1.0366414324e-11, 4.9820658016e-11, 2.1977125675e-10, 8.8983687085e-10, 3.3069711414e-09, 1.1280546275e-08, 3.5319160929e-08, 1.0150081664e-07, 2.6773673767e-07, 6.4822671675e-07, 1.4405422917e-06, 2.9383529636e-06, 5.5012528719e-06, 9.4536562756e-06, 1.491131934e-05, 2.1588042728e-05, 2.8687303711e-05, 3.4990225686e-05, 3.9172660763e-05, 4.0252998588e-05, 3.7965884985e-05, 3.2867672417e-05, 2.611702439e-05, 1.9048418835e-05, 1.2751857867e-05, 7.8355033111e-06, 4.4191710913e-06, 2.2876715775e-06, 1.0869947573e-06, 4.7406828685e-07, 1.8977213756e-07, 6.9727697394e-08, 2.3515655201e-08, 7.2792682992e-09, 2.0682342505e-09, 5.3937682098e-10, 1.2911015312e-10, 2.8366982374e-11, 5.7206205918e-12, 1.0588928822e-12, 1.7990425501e-13, 2.8055017009e-14, 4.0156900293e-15
			 , 1.2995638907e-13, 7.3739988725e-13, 3.8404891246e-12, 1.8359098963e-11, 8.055563161e-11, 3.2442937226e-10, 1.1992874471e-09, 4.0691880976e-09, 1.2672709993e-08, 3.6225348055e-08, 9.5046139847e-08, 2.2889534534e-07, 5.0596344181e-07, 1.0265503079e-06, 1.9117092052e-06, 3.2677069157e-06, 5.1267684285e-06, 7.3828559835e-06, 9.7585025287e-06, 1.1839236322e-05, 1.3183888768e-05, 1.347541729e-05, 1.264216462e-05, 1.0886302334e-05, 8.6043446572e-06, 6.2421840994e-06, 4.1565654101e-06, 2.5404576718e-06, 1.4251776292e-06, 7.338467185e-07, 3.4683378658e-07, 1.5045921486e-07, 5.9909304184e-08, 2.1895267821e-08, 7.3449011317e-09, 2.2615160855e-09, 6.3913946358e-10, 1.6579430884e-10, 3.9475256397e-11, 8.626971533e-12, 1.7304994243e-12, 3.1861416717e-13, 5.3844241213e-14, 8.352003205e-15, 1.1891068854e-15
			 , 4.5993617985e-14, 2.5958938775e-13, 1.3447870205e-12, 6.3944366295e-12, 2.7908076891e-11, 1.1179883408e-10, 4.1107886539e-10, 1.3873687754e-09, 4.2977306158e-09, 1.2219812717e-08, 3.1891108421e-08, 7.6393284587e-08, 1.6796612101e-07, 3.3897390495e-07, 6.2790070388e-07, 1.0675686326e-06, 1.6660155779e-06, 2.3864001832e-06, 3.1375191156e-06, 3.7862564568e-06, 4.1938587856e-06, 4.2637839215e-06, 3.9788533286e-06, 3.4080062505e-06, 2.6793047709e-06, 1.9334083845e-06, 1.2805753613e-06, 7.7851177593e-07, 4.3441593789e-07, 2.2249817277e-07, 1.0459863375e-07, 4.5134363802e-08, 1.7875782632e-08, 6.4983658454e-09, 2.1683261853e-09, 6.6408289978e-10, 1.8668117052e-10, 4.8168070227e-11, 1.1407623977e-11, 2.4797906784e-12, 4.947798898e-13, 9.0612467616e-14, 1.523155991e-14, 2.350064113e-15, 3.328093829e-16
			 , 1.5385377705e-14, 8.6373352318e-14, 4.4507285227e-13, 2.1050526773e-12, 9.1384920464e-12, 3.6413785182e-11, 1.3317907888e-10, 4.4708234337e-10, 1.3775781627e-09, 3.896059031e-09, 1.0113783588e-08, 2.4098120832e-08, 5.270264225e-08, 1.0579386611e-07, 1.9492570402e-07, 3.2965331798e-07, 5.1171087989e-07, 7.2907391768e-07, 9.5345058071e-07, 1.144472435e-06, 1.2609335727e-06, 1.275140221e-06, 1.1835978739e-06, 1.0083938378e-06, 7.8855822494e-07, 5.6600407561e-07, 3.7289299826e-07, 2.2549069456e-07, 1.2515641856e-07, 6.3761078195e-08, 2.981532532e-08, 1.2796853355e-08, 5.0413362374e-09, 1.8229211474e-09, 6.0502119981e-10, 1.8431105253e-10, 5.1536528517e-11, 1.3226817211e-11, 3.115852628e-12, 6.7371672477e-13, 1.3370776925e-13, 2.435668312e-14, 4.0724755416e-15, 6.24999142e-16, 8.8039155317e-17
	};
	Double expectedData[] = {
			3.8457113701e-11, 1.5355541691e-10, 5.7920120093e-10, 2.0639292626e-09, 6.9482251076e-09, 2.2098842466e-08, 6.6402420022e-08, 1.8850309303e-07, 5.0556217426e-07, 1.2810126683e-06, 3.06659351e-06, 6.9356002718e-06, 1.4819652283e-05, 2.9917072255e-05, 5.705953493e-05, 0.00010281732805, 0.00017503874276, 0.00028153515523, 0.00042782129724, 0.00061422032944, 0.00083314126713, 0.0010676929909, 0.0012927304956, 0.0014787814262, 0.0015982137736, 0.0016319284126, 0.0015743566474, 0.0014349650576, 0.0012357086523, 0.0010053742396, 0.00077281695595, 0.00056125865138, 0.00038511216981, 0.00024966029251, 0.00015291495955, 8.8488931151e-05, 4.8380080692e-05, 2.4990966756e-05, 1.2196591949e-05, 5.6238406258e-06, 2.4500030907e-06, 1.0084150159e-06, 3.921486349e-07, 1.4407876737e-07, 5.0013227699e-08,
			1.1037329674e-10, 4.3723648337e-10, 1.636283973e-09, 5.7851833903e-09, 1.9324204644e-08, 6.0983850658e-08, 1.8182691085e-07, 5.12191586e-07, 1.3631335852e-06, 3.4274945331e-06, 8.1423193202e-06, 1.8274819301e-05, 3.8751829459e-05, 7.7636509936e-05, 0.00014695181449, 0.00026279645591, 0.00044401748663, 0.00070878913587, 0.0010689830016, 0.0015232165496, 0.002050642297, 0.0026082899464, 0.0031344387057, 0.0035587861881, 0.0038175297975, 0.0038690256129, 0.0037047558489, 0.0033516338781, 0.0028647894039, 0.0023134926721, 0.0017651555547, 0.0012724402206, 0.00086662547493, 0.0005576545782, 0.00033903063312, 0.00019473882134, 0.00010568324266, 5.4187582553e-05, 2.6250254403e-05, 1.2014546058e-05, 5.1954275555e-06, 2.1226342248e-06, 8.19348414e-07, 2.9881388688e-07, 1.0296019772e-07,
			3.02794963e-10, 1.1903630654e-09, 4.420890157e-09, 1.5511886635e-08, 5.1422412525e-08, 1.6105547757e-07, 4.7657874712e-07, 1.332387126e-06, 3.5193554415e-06, 8.7828022265e-06, 2.0708118508e-05, 4.613027277e-05, 9.7088882143e-05, 0.00019305955886, 0.00036270343014, 0.00064379968217, 0.0010796643898, 0.0017106686218, 0.002560838833, 0.0036219127892, 0.0048398649227, 0.0061103785729, 0.0072885766648, 0.0082140466076, 0.0087460411453, 0.0087984438376, 0.0083625799933, 0.0075095660001, 0.00637132247, 0.0051072201955, 0.0038679413048, 0.002767677649, 0.0018710763746, 0.0011951101522, 0.00072121507978, 0.00041120854454, 0.00022151337315, 0.00011274006279, 5.4212208366e-05, 2.4629546404e-05, 1.0571975754e-05, 4.2874215176e-06, 1.6427676057e-06, 5.9469615434e-07, 2.0339998248e-07,
			7.957350819e-10, 3.1048351739e-09, 1.1444954743e-08, 3.9858286322e-08, 1.3114733969e-07, 4.0769806066e-07, 1.1974481467e-06, 3.3228745336e-06, 8.7118519705e-06, 2.1579753679e-05, 5.0503567024e-05, 0.00011167020402, 0.00023328797585, 0.00046045509345, 0.00085866186026, 0.0015128543103, 0.0025183271885, 0.0039606583281, 0.0058852218345, 0.0082622547105, 0.010959093909, 0.013733811596, 0.016261025394, 0.018190524071, 0.019225735632, 0.019198231303, 0.018112566654, 0.0161450472, 0.013596878193, 0.01081881459, 0.0081331867975, 0.0057767347501, 0.0038765440924, 0.0024578063506, 0.0014722827963, 0.00083325026498, 0.00044555398723, 0.00022509500531, 0.00010744149031, 4.8452791782e-05, 2.0644584265e-05, 8.3106288071e-06, 3.1608340267e-06, 1.1358179187e-06, 3.8561390472e-07,
			2.0053639124e-09, 7.7665973259e-09, 2.8416967423e-08, 9.8232665366e-08, 3.2082778283e-07, 9.899826851e-07, 2.8861791059e-06, 7.9498539216e-06, 2.0688798831e-05, 5.0868825751e-05, 0.00011817034405, 0.00025936160137, 0.0005378278477, 0.0010537106065, 0.0019504728402, 0.0034111355688, 0.0056363583195, 0.0087991105269, 0.0129783515, 0.018085931707, 0.023812382431, 0.029621389802, 0.034813576865, 0.038657387952, 0.040556177845, 0.040199642788, 0.037646797572, 0.033309994463, 0.027845932452, 0.021993262511, 0.016411876559, 0.011570910099, 0.0077075702749, 0.004850741887, 0.0028842940878, 0.0016203603777, 0.000860051366, 0.00043129841327, 0.00020434876424, 9.1475929472e-05, 3.8688531618e-05, 1.5459595462e-05, 5.8365221785e-06, 2.0818501565e-06, 7.0158747243e-07,
			4.8487440521e-09, 1.8640005611e-08, 6.7697858558e-08, 2.3229310615e-07, 7.5307151968e-07, 2.3066208161e-06, 6.6750827858e-06, 1.8250621752e-05, 4.7145393018e-05, 0.0001150645281, 0.00026532872982, 0.0005780530864, 0.0011898488928, 0.0023139637316, 0.0042516934589, 0.0073808777549, 0.012105835228, 0.018759540186, 0.027465676992, 0.03799260899, 0.049653357568, 0.061311059384, 0.07152695224, 0.078839039406, 0.082101980769, 0.080780521987, 0.07509316125, 0.065953042447, 0.054728053018, 0.042906775587, 0.0317820917, 0.022242304933, 0.014706787637, 0.009187483445, 0.0054227056991, 0.0030239612165, 0.0015932250002, 0.00079308314034, 0.00037299329273, 0.00016573872884, 6.9580509897e-05, 2.7598895636e-05, 1.0342749016e-05, 3.6620110163e-06, 1.2250121022e-06,
			1.1250109566e-08, 4.2929617418e-08, 1.5476460321e-07, 5.2713222923e-07, 1.6963143646e-06, 5.1574304132e-06, 1.4814978245e-05, 4.0207709676e-05, 0.0001030999237, 0.00024977447074, 0.00057171350086, 0.0012363731025, 0.0025261628908, 0.0048765632302, 0.0088942038345, 0.015326430165, 0.02495259168, 0.038382302788, 0.055781104826, 0.076592088702, 0.099362253058, 0.12178664464, 0.14103230971, 0.15430439331, 0.15950660998, 0.15578290588, 0.14374794333, 0.12532110153, 0.10322561817, 0.080332541202, 0.059065820566, 0.041031906878, 0.026930714842, 0.016699935143, 0.0097841343891, 0.0054159014654, 0.0028324341218, 0.0013995537915, 0.00065337133715, 0.00028818491684, 0.00012009448115, 4.7284126413e-05, 1.7589273874e-05, 6.1818701869e-06, 2.0527163062e-06,
			2.5049733328e-08, 9.4882989064e-08, 3.3953920992e-07, 1.1479565683e-06, 3.6669080544e-06, 1.10666183e-05, 3.1555167574e-05, 8.5009362931e-05, 0.00021637334168, 0.00052033311118, 0.0011822243268, 0.0025378096131, 0.0051470561139, 0.0098627832308, 0.017855860971, 0.03054237663, 0.049358912993, 0.075364890264, 0.10872096027, 0.14818294127, 0.19081998789, 0.23216152038, 0.2668685139, 0.28983121577, 0.29739502847, 0.28831217011, 0.26407845609, 0.22853025096, 0.18685088002, 0.14434020721, 0.1053465278, 0.072643013417, 0.047326915555, 0.029131528634, 0.01694178126, 0.0093088404695, 0.0048325107059, 0.0023702315716, 0.0010983719706, 0.00048089337592, 0.0001989247372, 7.7744437427e-05, 2.8707152093e-05, 1.001498633e-05, 3.3010163291e-06,
			5.3527463912e-08, 2.012553614e-07, 7.1488531535e-07, 2.3991632159e-06, 7.6071574875e-06, 2.2789007633e-05, 6.4501392013e-05, 0.00017248585329, 0.00043579134738, 0.0010402661093, 0.0023461243083, 0.0049991746581, 0.010064363706, 0.019143223032, 0.034402065713, 0.058411009236, 0.093701302268, 0.14201599806, 0.20336192261, 0.27513303051, 0.35168718839, 0.42472818989, 0.4846255975, 0.52244711636, 0.53213159856, 0.51207843501, 0.46558036061, 0.39993880551, 0.32458852687, 0.24889347461, 0.18031613155, 0.12342307929, 0.079817642807, 0.048768808203, 0.028153092699, 0.015355034623, 0.0079125453174, 0.0038523198515, 0.001772022281, 0.00077011700335, 0.00031621677042, 0.00012267431314, 4.4963762972e-05, 1.5570808233e-05, 5.0944426271e-06,
			1.0976899724e-07, 4.0967201853e-07, 1.4444838816e-06, 4.8119831737e-06, 1.5145193628e-05, 4.5036640588e-05, 0.00012653125671, 0.00033586935398, 0.0008423327083, 0.0019958949377, 0.0044681980146, 0.0094507846631, 0.018886176636, 0.035658325987, 0.063609001899, 0.10720546835, 0.17070884476, 0.25682413535, 0.36505337762, 0.49025003282, 0.62204186546, 0.74569687355, 0.84458964649, 0.90379494705, 0.91376557014, 0.87285157116, 0.7877469547, 0.67169759775, 0.54112996552, 0.41187942626, 0.29619610276, 0.20124694957, 0.12918735231, 0.078352239272, 0.044897643953, 0.024307282729, 0.012433402544, 0.0060087522208, 0.0027435906208, 0.0011835729221, 0.00048240454562, 0.00018576689629, 6.7587371814e-05, 2.3232839901e-05, 7.545290725e-06,
			2.1602934632e-07, 8.0030469065e-07, 2.8010400297e-06, 9.2622975726e-06, 2.8937272564e-05, 8.5415545103e-05, 0.0002382083169, 0.00062765016697, 0.0015624966861, 0.0036750333641, 0.0081666546416, 0.01714619728, 0.034011999635, 0.063743695846, 0.11287117367, 0.18882938073, 0.29846734575, 0.44572275253, 0.62888829092, 0.83834530707, 1.0558764163, 1.2564463975, 1.4125881717, 1.5004719817, 1.5058473223, 1.4278241341, 1.2791139132, 1.0826409611, 0.86576577301, 0.65411950153, 0.46693293502, 0.31491449026, 0.20066494298, 0.12080671964, 0.068714976243, 0.036927714724, 0.018749694037, 0.0089944923703, 0.0040766163705, 0.0017456763592, 0.00070626597175, 0.00026996869598, 9.7498706263e-05, 3.3267779128e-05, 1.0724711047e-05,
			4.0801484345e-07, 1.5003920214e-06, 5.212622924e-06, 1.7109753653e-05, 5.306042988e-05, 0.00015546701245, 0.00043037439772, 0.0011256291392, 0.0027815377193, 0.0064940451628, 0.014324727802, 0.029853700709, 0.058782857635, 0.10935633337, 0.19221085562, 0.31919244989, 0.50080428272, 0.74237644455, 1.0397311531, 1.3758106085, 1.7200337733, 2.0316833383, 2.2673355007, 2.3906515631, 2.3815379306, 2.2415036479, 1.9932516121, 1.6746556728, 1.3293203483, 0.99695259257, 0.70641528539, 0.47291859931, 0.29912549224, 0.17875622804, 0.10092753373, 0.053839232795, 0.027134935031, 0.012921098265, 0.0058131400632, 0.0024709436819, 0.0009923287582, 0.00037652073116, 0.0001349778607, 4.5716786479e-05, 1.4629367583e-05,
			7.3955311131e-07, 2.699507118e-06, 9.3094430618e-06, 3.0331870561e-05, 9.3371502533e-05, 0.00027156262863, 0.00074621908056, 0.0019373291774, 0.0047520523414, 0.011012850309, 0.02411342939, 0.049883733052, 0.097498882369, 0.18004499519, 0.3141255019, 0.51780478954, 0.80643553465, 1.1866263114, 1.649677365, 2.1668297064, 2.6890028977, 3.1528149688, 3.4925804793, 3.6554015066, 3.6146352283, 3.3770274746, 2.9808864837, 2.4859764405, 1.9587964406, 1.4582175832, 1.0256426724, 0.68157014456, 0.42792312852, 0.25384095067, 0.14226508725, 0.075331342345, 0.037687193705, 0.017813637613, 0.0079552190282, 0.0033565442258, 0.0013380528939, 0.00050395851037, 0.00017933151902, 6.0291760259e-05, 1.9151193356e-05,
			1.2864502234e-06, 4.6611659236e-06, 1.5955906763e-05, 5.1604199208e-05, 0.00015768426034, 0.00045523135712, 0.0012417000133, 0.0031999406678, 0.007791263496, 0.017923160046, 0.038954891287, 0.079992659101, 0.15519545371, 0.28447793114, 0.49267314739, 0.80613899333, 1.2462400105, 1.8202631453, 2.5119291518, 3.2750755298, 4.0343723478, 4.6953866572, 5.1630635413, 5.3639448529, 5.2650423011, 4.8827012428, 4.278181111, 3.5415950884, 2.7699974829, 2.0469185842, 1.429099575, 0.94268183125, 0.58750086225, 0.34593348649, 0.19244978176, 0.10115397757, 0.050233013005, 0.023568731621, 0.010447777362, 0.0043757481063, 0.0017314956198, 0.00064733797137, 0.00022865521775, 7.6308096063e-05, 2.4060046889e-05,
			2.1475675441e-06, 7.7238709363e-06, 2.6245187517e-05, 8.4256090432e-05, 0.00025555992797, 0.00073236022527, 0.0019828845874, 0.0050723691004, 0.012259280593, 0.027993670512, 0.060394227512, 0.12310387896, 0.23707664247, 0.43136660743, 0.74155779184, 1.2044373297, 1.8482645641, 2.6796914552, 3.6706769962, 4.750597909, 5.8088625606, 6.7108055342, 7.3248533235, 7.5537731316, 7.3598619465, 6.7751064857, 5.892550451, 4.8420717492, 3.7592383136, 2.7574600108, 1.9109939579, 1.2512674022, 0.77407255927, 0.4524326493, 0.24984285096, 0.13035288241, 0.064256204964, 0.02992610701, 0.013168190255, 0.0054744774087, 0.0021503043146, 0.00079799063076, 0.00027979246203, 9.2685897638e-05, 2.9008644671e-05,
			3.4405741146e-06, 1.2283038625e-05, 4.1429364514e-05, 0.00013202250708, 0.00039749125935, 0.0011307009193, 0.0030388453911, 0.0077163192578, 0.01851196398, 0.041960004728, 0.089858524345, 0.18181250821, 0.34755933447, 0.62773288367, 1.0711777109, 1.7269863312, 2.6306132203, 3.7858710852, 5.1477253705, 6.6131084073, 8.0266927617, 9.2046729633, 9.9728850149, 10.208783334, 9.8734262791, 9.0219936144, 7.7889312324, 6.3532208197, 4.8961053972, 3.5649077226, 2.4523731548, 1.5939164027, 0.97878037157, 0.56786576536, 0.31127686722, 0.16120879401, 0.078880804664, 0.036466548017, 0.015927906292, 0.0065729970584, 0.0025627655056, 0.00094404982061, 0.00032856500811, 0.00010804062613, 3.3565161989e-05,
			5.2898731346e-06, 1.8745930169e-05, 6.2762071026e-05, 0.00019852950511, 0.00059332524098, 0.0016753330545, 0.0044694099333, 0.011265226957, 0.02682689602, 0.060358943328, 0.12830794555, 0.25769512045, 0.48898953119, 0.87666496671, 1.484938499, 2.3764244297, 3.5931907685, 5.1330709552, 6.9281133601, 8.8347329753, 10.644189447, 12.116368938, 13.030860875, 13.240806935, 12.711491879, 11.529734902, 9.8805892607, 7.9999467571, 6.119727356, 4.4230085422, 3.0202591486, 1.9485491495, 1.1877341575, 0.68401850745, 0.37218355738, 0.19133183431, 0.092930443187, 0.042645135628, 0.018489352704, 0.0075738137876, 0.0029312187328, 0.0010718214585, 0.00037028576396, 0.00012086231653, 3.7271802381e-05,
			7.8053046903e-06, 2.7456080798e-05, 9.1246594429e-05, 0.00028650523207, 0.00084994041611, 0.0023822371128, 0.0063084431343, 0.015783383949, 0.037309443647, 0.083325541555, 0.17582403248, 0.35052504015, 0.66023809843, 1.1749593431, 1.9755399774, 3.138264416, 4.7101416569, 6.6791182227, 8.9483923553, 11.326914721, 13.54624633, 15.306187609, 16.340141813, 16.481067438, 15.705637798, 14.140557914, 12.028687397, 9.6674216002, 7.340806994, 5.2664465294, 3.5697046003, 2.286059895, 1.3831957832, 0.790715829, 0.42706888727, 0.21792956724, 0.10506912116, 0.047860227735, 0.020597529666, 0.0083752199738, 0.0032174958704, 0.0011678320565, 0.00040048211612, 0.00012975530544, 3.9719372366e-05,
			1.105260734e-05, 3.8592282837e-05, 0.00012731115793, 0.0003967989083, 0.0011684618964, 0.0032508672302, 0.0085452468523, 0.021222215214, 0.049796352981, 0.11039390038, 0.23122422746, 0.45757502901, 0.85552364458, 1.5112713265, 2.5222817324, 3.9772736553, 5.9254055409, 8.3404870249, 11.091887815, 13.93670961, 16.544580468, 18.556325944, 19.663868054, 19.687321625, 18.62280291, 16.643481741, 14.053485407, 11.211523631, 8.4505690109, 6.0179419661, 4.0490278532, 2.5739153479, 1.5458896191, 0.87720970466, 0.47029363259, 0.23821850353, 0.11400466037, 0.051547835664, 0.022021098527, 0.00888808572, 0.0033893637538, 0.0012211492507, 0.00041568049248, 0.00013368716777, 4.0621381714e-05,
			1.5019999123e-05, 5.205863455e-05, 0.00017046949683, 0.00052739838468, 0.0015415976718, 0.0042573945252, 0.011108551974, 0.027384935643, 0.063783260668, 0.14035969852, 0.29182255374, 0.57323935667, 1.0638829985, 1.8654880123, 3.0905216015, 4.8373981236, 7.1537310278, 9.9952603, 13.194603244, 16.456568735, 19.392016219, 21.589737841, 22.709757544, 22.56931365, 21.191657797, 18.799757126, 15.7572444, 12.478116322, 9.3359499534, 6.5994649461, 4.4075745253, 2.7811942878, 1.6580732764, 0.9339353987, 0.49701635271, 0.24989941606, 0.11871361324, 0.053281509756, 0.022594005756, 0.0090521274093, 0.0034264845249, 0.0012254271907, 0.00041406313511, 0.00013218577094, 3.986918284e-05,
			1.9588688845e-05, 6.7393103929e-05, 0.00021905708276, 0.0006727249561, 0.0019519017605, 0.005350803234, 0.01385864301, 0.033912761226, 0.0784054612, 0.17126562018, 0.3534555343, 0.68919179771, 1.2696561978, 2.2099014131, 3.634129421, 5.6463605582, 8.2885307321, 11.495482987, 15.063213078, 18.648707675, 21.813260631, 24.106444549, 25.170188004, 24.830215193, 23.142764348, 20.379367866, 16.955355909, 13.327964835, 9.8983200502, 6.9454417319, 4.6044629083, 2.8840236162, 1.7067085842, 0.95424668451, 0.50408371921, 0.2515853821, 0.1186339128, 0.052853411071, 0.022247330252, 0.0088475595294, 0.0033243732617, 0.0011801485817, 0.00039582561418, 0.00012543250088, 3.7553489894e-05,
			2.451721475e-05, 8.3727578595e-05, 0.00027014586944, 0.00082350587324, 0.0023717848209, 0.006453933459, 0.01659259765, 0.040303707333, 0.092494588952, 0.20055263493, 0.41084795965, 0.79519678696, 1.4541487088, 2.512370895, 4.1010910639, 6.3249311116, 9.2162217059, 12.687929406, 16.503243943, 20.280964753, 23.547707189, 25.831484722, 26.77261771, 26.216398513, 24.25470234, 21.201158564, 17.509105717, 13.661835808, 10.07151686, 7.0148991662, 4.6162434887, 2.8700978981, 1.6859529112, 0.9356962673, 0.49064240174, 0.24307258474, 0.11377519753, 0.050315284471, 0.021022917251, 0.0082990186688, 0.0030952889663, 0.0010907275366, 0.00036313794372, 0.00011422622977, 3.3946389798e-05,
			2.9448773015e-05, 9.982791312e-05, 0.00031971997858, 0.00096744499209, 0.0027658144024, 0.0074706846452, 0.019065073055, 0.045968174478, 0.10471689473, 0.22538082713, 0.45830848589, 0.88052065722, 1.598313337, 2.7411009122, 4.4414916761, 6.7994441116, 9.8346450742, 13.439549152, 17.352075733, 21.166979765, 24.395351524, 26.564154162, 27.329118837, 26.564154162, 24.395351524, 21.166979765, 17.352075733, 13.439549152, 9.8346450742, 6.7994441116, 4.4414916761, 2.7411009122, 1.598313337, 0.88052065722, 0.45830848589, 0.22538082713, 0.10471689473, 0.045968174478, 0.019065073055, 0.0074706846452, 0.0027658144024, 0.00096744499209, 0.00031971997858, 9.9827913118e-05, 2.9448773015e-05,
			3.3946389798e-05, 0.00011422622978, 0.00036313794373, 0.0010907275366, 0.0030952889663, 0.0082990186688, 0.021022917251, 0.050315284471, 0.11377519753, 0.24307258474, 0.49064240174, 0.9356962673, 1.6859529112, 2.8700978981, 4.6162434887, 7.0148991662, 10.07151686, 13.661835808, 17.509105717, 21.201158564, 24.25470234, 26.216398513, 26.77261771, 25.831484722, 23.547707189, 20.280964753, 16.503243943, 12.687929406, 9.2162217059, 6.3249311116, 4.1010910639, 2.512370895, 1.4541487088, 0.79519678696, 0.41084795965, 0.20055263493, 0.092494588952, 0.040303707333, 0.01659259765, 0.006453933459, 0.0023717848209, 0.00082350587323, 0.00027014586944, 8.3727578592e-05, 2.4517214749e-05,
			3.7553489894e-05, 0.00012543250088, 0.00039582561418, 0.0011801485817, 0.0033243732617, 0.0088475595294, 0.022247330252, 0.052853411071, 0.1186339128, 0.2515853821, 0.50408371921, 0.95424668451, 1.7067085842, 2.8840236162, 4.6044629083, 6.9454417319, 9.8983200502, 13.327964835, 16.955355909, 20.379367866, 23.142764348, 24.830215193, 25.170188004, 24.106444549, 21.813260631, 18.648707675, 15.063213078, 11.495482987, 8.2885307321, 5.6463605582, 3.634129421, 2.2099014131, 1.2696561978, 0.68919179771, 0.3534555343, 0.17126562018, 0.0784054612, 0.033912761226, 0.01385864301, 0.005350803234, 0.0019519017605, 0.0006727249561, 0.00021905708276, 6.7393103926e-05, 1.9588688845e-05,
			3.986918284e-05, 0.00013218577094, 0.00041406313511, 0.0012254271907, 0.0034264845249, 0.0090521274093, 0.022594005756, 0.053281509756, 0.11871361324, 0.24989941606, 0.49701635271, 0.9339353987, 1.6580732764, 2.7811942878, 4.4075745253, 6.5994649461, 9.3359499534, 12.478116322, 15.7572444, 18.799757126, 21.191657797, 22.56931365, 22.709757544, 21.589737841, 19.392016219, 16.456568735, 13.194603244, 9.9952603, 7.1537310278, 4.8373981236, 3.0905216015, 1.8654880123, 1.0638829985, 0.57323935667, 0.29182255374, 0.14035969852, 0.063783260668, 0.027384935643, 0.011108551974, 0.0042573945252, 0.0015415976718, 0.00052739838468, 0.00017046949683, 5.2058634548e-05, 1.5019999122e-05,
			4.0621381714e-05, 0.00013368716777, 0.00041568049248, 0.0012211492507, 0.0033893637538, 0.00888808572, 0.022021098527, 0.051547835664, 0.11400466037, 0.23821850353, 0.47029363259, 0.87720970466, 1.5458896191, 2.5739153479, 4.0490278532, 6.0179419661, 8.4505690109, 11.211523631, 14.053485407, 16.643481741, 18.62280291, 19.687321625, 19.663868054, 18.556325944, 16.544580468, 13.93670961, 11.091887815, 8.3404870249, 5.9254055409, 3.9772736553, 2.5222817324, 1.5112713265, 0.85552364458, 0.45757502901, 0.23122422746, 0.11039390038, 0.049796352981, 0.021222215214, 0.0085452468523, 0.0032508672302, 0.0011684618964, 0.0003967989083, 0.00012731115793, 3.8592282835e-05, 1.105260734e-05,
			3.9719372366e-05, 0.00012975530544, 0.00040048211613, 0.0011678320565, 0.0032174958704, 0.0083752199738, 0.020597529666, 0.047860227735, 0.10506912116, 0.21792956724, 0.42706888727, 0.790715829, 1.3831957832, 2.286059895, 3.5697046003, 5.2664465294, 7.340806994, 9.6674216002, 12.028687397, 14.140557914, 15.705637798, 16.481067438, 16.340141813, 15.306187609, 13.54624633, 11.326914721, 8.9483923553, 6.6791182227, 4.7101416569, 3.138264416, 1.9755399774, 1.1749593431, 0.66023809843, 0.35052504015, 0.17582403248, 0.083325541555, 0.037309443647, 0.015783383949, 0.0063084431343, 0.0023822371128, 0.00084994041611, 0.00028650523207, 9.1246594429e-05, 2.7456080796e-05, 7.8053046898e-06,
			3.7271802381e-05, 0.00012086231653, 0.00037028576397, 0.0010718214585, 0.0029312187328, 0.0075738137876, 0.018489352704, 0.042645135628, 0.092930443187, 0.19133183431, 0.37218355738, 0.68401850745, 1.1877341575, 1.9485491495, 3.0202591486, 4.4230085422, 6.119727356, 7.9999467571, 9.8805892607, 11.529734902, 12.711491879, 13.240806935, 13.030860875, 12.116368938, 10.644189447, 8.8347329753, 6.9281133601, 5.1330709552, 3.5931907685, 2.3764244297, 1.484938499, 0.87666496671, 0.48898953119, 0.25769512045, 0.12830794555, 0.060358943328, 0.02682689602, 0.011265226957, 0.0044694099333, 0.0016753330545, 0.00059332524098, 0.00019852950511, 6.2762071026e-05, 1.8745930168e-05, 5.2898731341e-06,
			3.3565161989e-05, 0.00010804062613, 0.00032856500811, 0.00094404982061, 0.0025627655056, 0.0065729970584, 0.015927906292, 0.036466548017, 0.078880804664, 0.16120879401, 0.31127686722, 0.56786576536, 0.97878037157, 1.5939164027, 2.4523731548, 3.5649077226, 4.8961053972, 6.3532208197, 7.7889312324, 9.0219936144, 9.8734262791, 10.208783334, 9.9728850149, 9.2046729633, 8.0266927617, 6.6131084073, 5.1477253705, 3.7858710852, 2.6306132203, 1.7269863312, 1.0711777109, 0.62773288367, 0.34755933447, 0.18181250821, 0.089858524345, 0.041960004728, 0.01851196398, 0.0077163192578, 0.0030388453911, 0.0011307009193, 0.00039749125935, 0.00013202250708, 4.1429364514e-05, 1.2283038624e-05, 3.4405741141e-06,
			2.9008644671e-05, 9.2685897639e-05, 0.00027979246203, 0.00079799063076, 0.0021503043146, 0.0054744774087, 0.013168190255, 0.02992610701, 0.064256204964, 0.13035288241, 0.24984285096, 0.4524326493, 0.77407255927, 1.2512674022, 1.9109939579, 2.7574600108, 3.7592383136, 4.8420717492, 5.892550451, 6.7751064857, 7.3598619465, 7.5537731316, 7.3248533235, 6.7108055342, 5.8088625606, 4.750597909, 3.6706769962, 2.6796914552, 1.8482645641, 1.2044373297, 0.74155779184, 0.43136660743, 0.23707664247, 0.12310387896, 0.060394227512, 0.027993670512, 0.012259280593, 0.0050723691004, 0.0019828845874, 0.00073236022527, 0.00025555992797, 8.4256090432e-05, 2.6245187517e-05, 7.7238709356e-06, 2.1475675436e-06,
			2.4060046889e-05, 7.6308096063e-05, 0.00022865521775, 0.00064733797137, 0.0017314956198, 0.0043757481063, 0.010447777362, 0.023568731621, 0.050233013005, 0.10115397757, 0.19244978176, 0.34593348649, 0.58750086225, 0.94268183125, 1.429099575, 2.0469185842, 2.7699974829, 3.5415950884, 4.278181111, 4.8827012428, 5.2650423011, 5.3639448529, 5.1630635413, 4.6953866572, 4.0343723478, 3.2750755298, 2.5119291518, 1.8202631453, 1.2462400105, 0.80613899333, 0.49267314739, 0.28447793114, 0.15519545371, 0.079992659101, 0.038954891287, 0.017923160046, 0.007791263496, 0.0031999406678, 0.0012417000133, 0.00045523135712, 0.00015768426034, 5.1604199208e-05, 1.5955906763e-05, 4.6611659233e-06, 1.2864502229e-06,
			1.9151193356e-05, 6.029176026e-05, 0.00017933151902, 0.00050395851037, 0.0013380528939, 0.0033565442258, 0.0079552190282, 0.017813637613, 0.037687193705, 0.075331342345, 0.14226508725, 0.25384095067, 0.42792312852, 0.68157014456, 1.0256426724, 1.4582175832, 1.9587964406, 2.4859764405, 2.9808864837, 3.3770274746, 3.6146352283, 3.6554015066, 3.4925804793, 3.1528149688, 2.6890028977, 2.1668297064, 1.649677365, 1.1866263114, 0.80643553465, 0.51780478954, 0.3141255019, 0.18004499519, 0.097498882369, 0.049883733052, 0.02411342939, 0.011012850309, 0.0047520523414, 0.0019373291774, 0.00074621908056, 0.00027156262863, 9.3371502532e-05, 3.0331870562e-05, 9.3094430614e-06, 2.6995071179e-06, 7.3955311083e-07,
			1.4629367583e-05, 4.571678648e-05, 0.0001349778607, 0.00037652073116, 0.0009923287582, 0.0024709436819, 0.0058131400632, 0.012921098265, 0.027134935031, 0.053839232795, 0.10092753373, 0.17875622804, 0.29912549224, 0.47291859931, 0.70641528539, 0.99695259257, 1.3293203483, 1.6746556728, 1.9932516121, 2.2415036479, 2.3815379306, 2.3906515631, 2.2673355007, 2.0316833383, 1.7200337733, 1.3758106085, 1.0397311531, 0.74237644455, 0.50080428272, 0.31919244989, 0.19221085562, 0.10935633337, 0.058782857635, 0.029853700709, 0.014324727802, 0.0064940451628, 0.0027815377193, 0.0011256291392, 0.00043037439772, 0.00015546701245, 5.306042988e-05, 1.7109753653e-05, 5.2126229237e-06, 1.5003920214e-06, 4.0801484294e-07,
			1.0724711048e-05, 3.3267779128e-05, 9.7498706262e-05, 0.00026996869598, 0.00070626597175, 0.0017456763592, 0.0040766163705, 0.0089944923703, 0.018749694037, 0.036927714724, 0.068714976243, 0.12080671964, 0.20066494298, 0.31491449026, 0.46693293502, 0.65411950153, 0.86576577301, 1.0826409611, 1.2791139132, 1.4278241341, 1.5058473223, 1.5004719817, 1.4125881717, 1.2564463975, 1.0558764163, 0.83834530707, 0.62888829092, 0.44572275253, 0.29846734575, 0.18882938073, 0.11287117367, 0.063743695846, 0.034011999635, 0.01714619728, 0.0081666546416, 0.0036750333641, 0.0015624966861, 0.00062765016698, 0.0002382083169, 8.5415545102e-05, 2.8937272564e-05, 9.2622975733e-06, 2.8010400293e-06, 8.0030469082e-07, 2.1602934579e-07,
			7.5452907253e-06, 2.3232839901e-05, 6.7587371813e-05, 0.00018576689629, 0.00048240454562, 0.0011835729221, 0.0027435906208, 0.0060087522208, 0.012433402544, 0.024307282729, 0.044897643953, 0.078352239272, 0.12918735231, 0.20124694957, 0.29619610276, 0.41187942626, 0.54112996552, 0.67169759775, 0.7877469547, 0.87285157116, 0.91376557014, 0.90379494705, 0.84458964649, 0.74569687355, 0.62204186546, 0.49025003282, 0.36505337762, 0.25682413535, 0.17070884476, 0.10720546835, 0.063609001899, 0.035658325987, 0.018886176636, 0.0094507846631, 0.0044681980146, 0.0019958949377, 0.0008423327083, 0.00033586935398, 0.00012653125671, 4.5036640587e-05, 1.5145193628e-05, 4.8119831744e-06, 1.4444838812e-06, 4.096720188e-07, 1.097689967e-07,
			5.0944426274e-06, 1.5570808233e-05, 4.4963762971e-05, 0.00012267431314, 0.00031621677042, 0.00077011700335, 0.001772022281, 0.0038523198515, 0.0079125453174, 0.015355034623, 0.028153092699, 0.048768808203, 0.079817642807, 0.12342307929, 0.18031613155, 0.24889347461, 0.32458852687, 0.39993880551, 0.46558036061, 0.51207843501, 0.53213159856, 0.52244711636, 0.4846255975, 0.42472818989, 0.35168718839, 0.27513303051, 0.20336192261, 0.14201599806, 0.093701302268, 0.058411009236, 0.034402065713, 0.019143223032, 0.010064363706, 0.0049991746581, 0.0023461243083, 0.0010402661093, 0.00043579134738, 0.0001724858533, 6.4501392012e-05, 2.2789007632e-05, 7.6071574872e-06, 2.3991632167e-06, 7.1488531492e-07, 2.0125536173e-07, 5.3527463347e-08,
			3.3010163294e-06, 1.001498633e-05, 2.8707152092e-05, 7.7744437428e-05, 0.0001989247372, 0.00048089337592, 0.0010983719706, 0.0023702315716, 0.0048325107059, 0.0093088404695, 0.01694178126, 0.029131528634, 0.047326915555, 0.072643013417, 0.1053465278, 0.14434020721, 0.18685088002, 0.22853025096, 0.26407845609, 0.28831217011, 0.29739502847, 0.28983121577, 0.2668685139, 0.23216152038, 0.19081998789, 0.14818294127, 0.10872096027, 0.075364890264, 0.049358912993, 0.03054237663, 0.017855860971, 0.0098627832308, 0.0051470561139, 0.0025378096131, 0.0011822243268, 0.00052033311118, 0.00021637334168, 8.5009362931e-05, 3.1555167573e-05, 1.10666183e-05, 3.6669080541e-06, 1.1479565691e-06, 3.3953920946e-07, 9.4882989413e-08, 2.5049732752e-08,
			2.0527163065e-06, 6.1818701868e-06, 1.7589273874e-05, 4.7284126414e-05, 0.00012009448115, 0.00028818491684, 0.00065337133715, 0.0013995537915, 0.0028324341217, 0.0054159014654, 0.0097841343891, 0.016699935143, 0.026930714842, 0.041031906878, 0.059065820566, 0.080332541202, 0.10322561817, 0.12532110153, 0.14374794333, 0.15578290588, 0.15950660998, 0.15430439331, 0.14103230971, 0.12178664464, 0.099362253058, 0.076592088702, 0.055781104826, 0.038382302788, 0.02495259168, 0.015326430165, 0.0088942038345, 0.0048765632302, 0.0025261628908, 0.0012363731025, 0.00057171350086, 0.00024977447074, 0.0001030999237, 4.0207709676e-05, 1.4814978244e-05, 5.1574304127e-06, 1.6963143643e-06, 5.2713223006e-07, 1.5476460273e-07, 4.2929617753e-08, 1.1250108987e-08,
			1.2250121025e-06, 3.6620110162e-06, 1.0342749015e-05, 2.7598895637e-05, 6.9580509897e-05, 0.00016573872883, 0.00037299329273, 0.00079308314034, 0.0015932250002, 0.0030239612165, 0.0054227056991, 0.009187483445, 0.014706787637, 0.022242304933, 0.0317820917, 0.042906775587, 0.054728053018, 0.065953042447, 0.07509316125, 0.080780521987, 0.082101980769, 0.078839039406, 0.07152695224, 0.061311059384, 0.049653357568, 0.03799260899, 0.027465676992, 0.018759540186, 0.012105835228, 0.0073808777549, 0.0042516934589, 0.0023139637316, 0.0011898488928, 0.0005780530864, 0.00026532872982, 0.0001150645281, 4.7145393018e-05, 1.8250621752e-05, 6.6750827849e-06, 2.3066208156e-06, 7.5307151945e-07, 2.3229310701e-07, 6.769785805e-08, 1.8640005905e-08, 4.8487434829e-09,
			7.0158747263e-07, 2.0818501564e-06, 5.8365221781e-06, 1.5459595463e-05, 3.8688531618e-05, 9.147592947e-05, 0.00020434876424, 0.00043129841327, 0.000860051366, 0.0016203603777, 0.0028842940878, 0.004850741887, 0.0077075702749, 0.011570910099, 0.016411876559, 0.021993262511, 0.027845932452, 0.033309994463, 0.037646797572, 0.040199642788, 0.040556177845, 0.038657387952, 0.034813576865, 0.029621389802, 0.023812382431, 0.018085931707, 0.0129783515, 0.0087991105269, 0.0056363583195, 0.0034111355688, 0.0019504728402, 0.0010537106065, 0.0005378278477, 0.00025936160137, 0.00011817034405, 5.0868825751e-05, 2.068879883e-05, 7.9498539217e-06, 2.8861791051e-06, 9.8998268472e-07, 3.208277826e-07, 9.8232666208e-08, 2.8416966885e-08, 7.7665975618e-09, 2.0053633694e-09,
			3.8561390484e-07, 1.1358179185e-06, 3.1608340264e-06, 8.310628808e-06, 2.0644584265e-05, 4.845279178e-05, 0.00010744149031, 0.00022509500531, 0.00044555398723, 0.00083325026498, 0.0014722827963, 0.0024578063506, 0.0038765440924, 0.0057767347501, 0.0081331867975, 0.01081881459, 0.013596878193, 0.0161450472, 0.018112566654, 0.019198231303, 0.019225735632, 0.018190524071, 0.016261025394, 0.013733811596, 0.010959093909, 0.0082622547105, 0.0058852218345, 0.0039606583281, 0.0025183271885, 0.0015128543103, 0.00085866186026, 0.00046045509345, 0.00023328797586, 0.00011167020402, 5.0503567024e-05, 2.1579753678e-05, 8.7118519703e-06, 3.3228745336e-06, 1.197448146e-06, 4.0769806029e-07, 1.3114733947e-07, 3.9858287123e-08, 1.1444954176e-08, 3.1048353422e-09, 7.9573458579e-10,
			2.0339998253e-07, 5.9469615409e-07, 1.6427676055e-06, 4.2874215185e-06, 1.0571975754e-05, 2.4629546403e-05, 5.4212208366e-05, 0.00011274006278, 0.00022151337315, 0.00041120854454, 0.00072121507978, 0.0011951101522, 0.0018710763746, 0.002767677649, 0.0038679413048, 0.0051072201955, 0.00637132247, 0.0075095660001, 0.0083625799933, 0.0087984438376, 0.0087460411453, 0.0082140466076, 0.0072885766648, 0.0061103785729, 0.0048398649227, 0.0036219127892, 0.002560838833, 0.0017106686218, 0.0010796643898, 0.00064379968217, 0.00036270343014, 0.00019305955886, 9.7088882143e-05, 4.6130272771e-05, 2.0708118508e-05, 8.7828022264e-06, 3.5193554413e-06, 1.3323871259e-06, 4.765787465e-07, 1.6105547721e-07, 5.1422412318e-08, 1.5511887363e-08, 4.4208895581e-09, 1.1903631668e-09, 3.0279453771e-10,
			1.0296019769e-07, 2.9881388654e-07, 8.1934841385e-07, 2.1226342257e-06, 5.1954275553e-06, 1.2014546057e-05, 2.6250254403e-05, 5.4187582553e-05, 0.00010568324266, 0.00019473882134, 0.00033903063312, 0.0005576545782, 0.00086662547493, 0.0012724402206, 0.0017651555547, 0.0023134926721, 0.0028647894039, 0.0033516338781, 0.0037047558489, 0.0038690256129, 0.0038175297975, 0.0035587861881, 0.0031344387057, 0.0026082899464, 0.002050642297, 0.0015232165496, 0.0010689830016, 0.00070878913586, 0.00044401748663, 0.00026279645591, 0.00014695181449, 7.7636509936e-05, 3.8751829459e-05, 1.8274819301e-05, 8.1423193205e-06, 3.427494533e-06, 1.3631335849e-06, 5.1219158581e-07, 1.818269103e-07, 6.0983850308e-08, 1.9324204448e-08, 5.7851840157e-09, 1.6362833421e-09, 4.3723652767e-10, 1.1037296811e-10,
			5.0013227583e-08, 1.4407876694e-07, 3.921486348e-07, 1.0084150167e-06, 2.4500030905e-06, 5.6238406247e-06, 1.2196591949e-05, 2.4990966756e-05, 4.8380080691e-05, 8.8488931151e-05, 0.00015291495955, 0.00024966029251, 0.00038511216981, 0.00056125865138, 0.00077281695595, 0.0010053742396, 0.0012357086523, 0.0014349650576, 0.0015743566474, 0.0016319284126, 0.0015982137736, 0.0014787814262, 0.0012927304956, 0.0010676929909, 0.00083314126713, 0.00061422032944, 0.00042782129724, 0.00028153515523, 0.00017503874276, 0.00010281732804, 5.705953493e-05, 2.9917072255e-05, 1.4819652283e-05, 6.9356002724e-06, 3.0665935102e-06, 1.2810126683e-06, 5.0556217397e-07, 1.8850309274e-07, 6.6402419511e-08, 2.2098842129e-08, 6.9482249317e-09, 2.0639297636e-09, 5.792005369e-10, 1.5355542172e-10, 3.8456906847e-11
	};
	Matrix<Double> beamMatrixIn(33, 33);
	Double *p;
	p = beamData;
	for (uInt i=0; i<33; i++) {
		for (uInt j=0; j<33; j++) {
			beamMatrixIn(i,j) = *p++;
		}
	}
	Matrix<Double> kernelMatrix(45, 45);
	Matrix<Double> beamMatrixOut;
	p = kernelData;
	for (uInt i=0; i<45; i++) {
		for (uInt j=0; j<45; j++) {
			kernelMatrix(i,j) = *p++;
		}
	}
	Matrix<Double> expectedMatrix(45, 45);
	p = expectedData;
	for (uInt i=0; i<45; i++) {
		for (uInt j=0; j<45; j++) {
			expectedMatrix(i,j) = *p++;
		}
	}

	Convolver<Double> conv(beamMatrixIn, kernelMatrix.shape());
	conv.linearConv(beamMatrixOut, kernelMatrix);

    cout << "*** max " << max(abs(beamMatrixOut - expectedMatrix)) << endl;
    return max(abs(beamMatrixOut - expectedMatrix)) < 5e-10;
}

int main() {
  Bool anyFailures = False;
  {
    Bool failed = False;
    // Test the double precision constructor
    Array<Double> psf(IPosition(1,4)); 
    psf = 0.;
    psf(IPosition(1,1)) = 0.1;
    psf(IPosition(1,2)) = 1.;
    psf(IPosition(1,3)) = 0.5;
    Convolver<Double> conv(psf);
    // Now test circular Convolution (1 - Dimensional)
    Vector<Double> mod(4);
    mod = 0;
    mod(3) = 1;
    mod(0) = 2;
    Vector<Double> result;
    conv.circularConv(result, mod);
    Array<Double> expectedResult(IPosition(1,4));
    expectedResult(IPosition(1,0)) = 2.5;
    expectedResult(IPosition(1,1)) = 1.0;
    expectedResult(IPosition(1,2)) = 0.1;
    expectedResult(IPosition(1,3)) = 1.2;
    if (!allNearAbs(expectedResult, result, 1.E-10))
      failed = True;

    if (failed) 
      cout << "Failed";
    else
      cout << "Passed";
    cout << " the Circular Convolution in Double Precision Test"
	 << endl;
    mod.resize(IPosition(1,6));
    mod = 0;
    mod(5) = 1;
    mod(0) = 2;
    if (!failed){
      result.resize(IPosition(1,0));
      conv.circularConv(result, mod);
      expectedResult.resize(IPosition(1,6));
      expectedResult = 0.;
      expectedResult(IPosition(1,0)) = 2.5;
      expectedResult(IPosition(1,1)) = 1.0;
      expectedResult(IPosition(1,4)) = 0.1;
      expectedResult(IPosition(1,5)) = 1.2;
      if (!allNearAbs(expectedResult, result, 1.E-10)){
	failed = True;
	cout << "Failed";
      }
      else
	cout << "Passed";
      cout << " the Circular Convolution Resize Test"
	   << endl;
    }
    if (failed) anyFailures = True;
  }
  {
    Bool failed = False;
    // Test the single precision constructor
    Matrix<Float> psf(2,2); 
    psf = 0.;
    psf(1,1) = 1;
    psf(0,1) = .5;
    psf(1,0) = .1;
    //    cout << "Psf:" << psf << endl;
    Convolver<Float> conv(psf);
    // And test single precision circular convolution
    Matrix<Float> mod(6,6);
    mod = 0;
    mod(0,0) = 1;
    mod(5,5) = 2;
    mod(2,0) = 3;
    //    cout << "Model:" << mod << endl;
    Matrix<Float> result;
    conv.circularConv(result, mod);
    //    cout << "Result:" << result << endl;
    Matrix<Float> expectedResult(6,6);
    expectedResult = mod;
    expectedResult(5,0) = 0.5;
    expectedResult(0,5) = 0.1;
    expectedResult(5,4) = 0.2;
    expectedResult(4,5) = 1.0;
    expectedResult(2,5) = 0.3;
    expectedResult(1,0) = 1.5;
    if (!allNearAbs(expectedResult, result, 1.E-5)){
      failed = True;
      cout << "Failed";
    }
    
    else
      cout << "Passed";
    cout << " the Floating Point 2-D Circular Convolution Test"
	 << endl;
    if (failed) anyFailures = True;
  }
  {
    Bool failed = False;
    // Test the double precision constructor with supplied image size
    Array<Double> psf(IPosition(1,2)); 
    psf = 0.;
    psf(IPosition(1,0)) = .5;
    psf(IPosition(1,1)) = 1.;
    Convolver<Double> conv(psf, IPosition(1,4));
    // And test linear convolution
    Array<Double> mod(IPosition(1,4)); 
    mod = 0.;
    mod(IPosition(1,0)) = 1.;
    mod(IPosition(1,3)) = 2.;
    Array<Double> result;
    conv.linearConv(result, mod, False);
    Array<Double> expectedResult(IPosition(1,4));
    expectedResult(IPosition(1,0)) = 1.;
    expectedResult(IPosition(1,1)) = 0.;
    expectedResult(IPosition(1,2)) = 1.;
    expectedResult(IPosition(1,3)) = 2.;
    if (!allNearAbs(expectedResult, result, 1.E-10)){
      failed = True;
      cout << "Failed";
    }
    else
      cout << "Passed";
    cout << " the Linear Convolution in Double Precision Test"
	 << endl;
    if (!failed){
      // see if the convolver can automatically resize if given a bigger image
      Vector<Double> bigMod(8), bigResult; 
      bigMod = 0; bigMod(0) = 1; bigMod(7) = 2;
      conv.linearConv(bigResult, bigMod, True);
      Vector<Double> expectedBigResult(9);
      expectedBigResult = 0;
      expectedBigResult(0) = 0.5;
      expectedBigResult(1) = 1.0;
      expectedBigResult(7) = 1.0;
      expectedBigResult(8) = 2.0; 
      if (!allNearAbs(expectedBigResult, bigResult, 1.E-10)){
	failed = True;
	cout << "Failed";
      }
      else
	cout << "Passed";
      cout << " the   array resize test"
	   << endl;
    }
    if (!failed){
      // Set the psf to something new (different size)
      psf.resize(IPosition(1,4));
      psf(IPosition(1,0)) = .5;
      psf(IPosition(1,1)) = 1.;
      psf(IPosition(1,2)) = .3;
      psf(IPosition(1,3)) = .1;
      conv.setPsf(psf); 
      result.resize(IPosition(1,0));
      conv.linearConv(result, mod);
      expectedResult.resize(IPosition(1,4));
      expectedResult(IPosition(1,0)) = 0.3;
      expectedResult(IPosition(1,1)) = 1.1;
      expectedResult(IPosition(1,2)) = 2.0;
      expectedResult(IPosition(1,3)) = 0.6;
      if (!allNearAbs(expectedResult, result, 1.E-10)){
	failed = True;
	cout << "Failed";
      }
      else
	cout << "Passed";
      cout << " the   new psf test"
	   << endl;
    }
    if (!failed){
      mod.resize(IPosition(1,2));
      mod(IPosition(1,0)) = 0;
      mod(IPosition(1,1)) = 1;
      result.resize(IPosition(1,0));
      conv.linearConv(result, mod);
      expectedResult.resize(IPosition(1,2));
      expectedResult(IPosition(1,0)) = 1;
      expectedResult(IPosition(1,1)) = 0.3;
      if (!allNearAbs(expectedResult, result, 1.E-10)){
	failed = True;
	cout << "Failed";
      }
      else
	cout << "Passed";
      cout << " the   small model test"
	   << endl;
    }
    if (failed) anyFailures = True;
  }
  {
    Bool failed = False;
    //    Test the linear convolution with Single precision 2-D functions
    Matrix<Float> psf(2,4); 
    psf = 0.;
    psf(1,2) = 1.;
    psf(1,3) = .1;
    Cube<Float> mod(2,4,3); 
    Convolver<Float> conv(psf, mod.shape());
    mod = 0.;
    mod(1,2,0) = 1.;
    mod(0,0,1) = 2.;
    mod(1,3,1) = 4.;
    for (uInt i = 0; i < 4; i++)
      for (uInt j = 0; j < 2; j++)
	mod(j,i,2) = 1.;
    Cube<Float> result;
    conv.linearConv(result, mod, False);
    Cube<Float> expectedResult(2,4,3);
    expectedResult = mod;
    expectedResult(1,3,0) = 0.1;
    expectedResult(0,1,1) = 0.2;
    expectedResult(0,0,2) = 1;
    expectedResult(1,0,2) = 1;
    expectedResult(0,1,2) = 1.1;
    expectedResult(1,1,2) = 1.1;
    expectedResult(0,2,2) = 1.1;
    expectedResult(1,2,2) = 1.1;
    expectedResult(0,3,2) = 1.1;
    expectedResult(1,3,2) = 1.1;
    if (!allNearAbs(expectedResult, result, 1.E-5)){
      failed = True;
      cout << "Failed";
    }
    
    else
      cout << "Passed";
    cout << " the Multiple Floating Point 2-D Linear Convolution Test"
	 << endl;
    if (failed) anyFailures = True;
  }
  {
	  Bool failed = False;
	 if (! doLinearConv()) {
		 failed = True;
		 cout << "Failed";
	 }
	 else {
		 cout << "Passed";
	 }
	 cout << " the linear convolution test"  << endl;
	 if (failed) anyFailures = True;


	  /*
	  Matrix<Double> mat1 = doLinearConv();
	  Matrix<Double> mat2 = doLinearConv();
	  Matrix<Double> mat3 = doLinearConv();
	  Matrix<Double> mat4 = doLinearConv();
	  Matrix<Double> mat5 = doLinearConv();

	  cout << "*** all " << allTrue(mat0 == mat1) << endl;
	  cout << "*** all " << allTrue(mat0 == mat2) << endl;
	  cout << "*** all " << allTrue(mat0 == mat3) << endl;
	  cout << "*** all " << allTrue(mat0 == mat4) << endl;
	  cout << "*** all " << allTrue(mat0 == mat5) << endl;
	  */

  }
  if (anyFailures) {
    cout << "FAIL" << endl;
    return 1;
  }
  else {
    cout << "OK" << endl;
    return 0;
  }
}
// Local Variables: 
// compile-command: "gmake OPTLIB=1 tConvolver"
// End:
