{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdColor: TMFColorRGBA;
    { Internal wrapper for property @link(Color). This wrapper API may change, we advise to access simpler @link(Color) instead. }
    public property FdColor: TMFColorRGBA read FFdColor;
    {  }
    procedure SetColor(const Value: array of TCastleColor); overload;
    {  }
    procedure SetColor(const Value: TVector4List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TColorRGBANode ----------------------------------------------- }

procedure TColorRGBANode.SetColor(const Value: array of TCastleColor);
begin
  FdColor.Send(Value);
end;

procedure TColorRGBANode.SetColor(const Value: TVector4List);
begin
  FdColor.Send(Value);
end;

class function TColorRGBANode.ClassX3DType: String;
begin
  Result := 'ColorRGBA';
end;

procedure TColorRGBANode.CreateNode;
begin
  inherited;

  FFdColor := TMFColorRGBA.Create(Self, True, 'color', []);
   FdColor.ChangeAlways := chColorNode;
  AddField(FFdColor);
end;

{$endif read_implementation}
