// This file has been generated by Py++.

#include "boost/python.hpp"
#include "generators/include/python_CEGUI.h"
#include "RenderingWindow.pypp.hpp"

namespace bp = boost::python;

struct RenderingWindow_wrapper : CEGUI::RenderingWindow, bp::wrapper< CEGUI::RenderingWindow > {

    RenderingWindow_wrapper(::CEGUI::TextureTarget & target, ::CEGUI::RenderingSurface & owner )
    : CEGUI::RenderingWindow( boost::ref(target), boost::ref(owner) )
      , bp::wrapper< CEGUI::RenderingWindow >(){
        // constructor
    
    }

    virtual void draw(  ) {
        if( bp::override func_draw = this->get_override( "draw" ) )
            func_draw(  );
        else{
            this->CEGUI::RenderingWindow::draw(  );
        }
    }
    
    void default_draw(  ) {
        CEGUI::RenderingWindow::draw( );
    }

    virtual void invalidate(  ) {
        if( bp::override func_invalidate = this->get_override( "invalidate" ) )
            func_invalidate(  );
        else{
            this->CEGUI::RenderingWindow::invalidate(  );
        }
    }
    
    void default_invalidate(  ) {
        CEGUI::RenderingWindow::invalidate( );
    }

    virtual bool isRenderingWindow(  ) const  {
        if( bp::override func_isRenderingWindow = this->get_override( "isRenderingWindow" ) )
            return func_isRenderingWindow(  );
        else{
            return this->CEGUI::RenderingWindow::isRenderingWindow(  );
        }
    }
    
    bool default_isRenderingWindow(  ) const  {
        return CEGUI::RenderingWindow::isRenderingWindow( );
    }

    virtual void realiseGeometry_impl(  ){
        if( bp::override func_realiseGeometry_impl = this->get_override( "realiseGeometry_impl" ) )
            func_realiseGeometry_impl(  );
        else{
            this->CEGUI::RenderingWindow::realiseGeometry_impl(  );
        }
    }
    
    virtual void default_realiseGeometry_impl(  ){
        CEGUI::RenderingWindow::realiseGeometry_impl( );
    }

    void setOwner( ::CEGUI::RenderingSurface & owner ){
        CEGUI::RenderingWindow::setOwner( boost::ref(owner) );
    }

    void attachWindow( ::CEGUI::RenderingWindow & w ){
        CEGUI::RenderingSurface::attachWindow( boost::ref(w) );
    }

    virtual void destroyRenderingWindow( ::CEGUI::RenderingWindow & window ) {
        if( bp::override func_destroyRenderingWindow = this->get_override( "destroyRenderingWindow" ) )
            func_destroyRenderingWindow( boost::ref(window) );
        else{
            this->CEGUI::RenderingSurface::destroyRenderingWindow( boost::ref(window) );
        }
    }
    
    void default_destroyRenderingWindow( ::CEGUI::RenderingWindow & window ) {
        CEGUI::RenderingSurface::destroyRenderingWindow( boost::ref(window) );
    }

    void detatchWindow( ::CEGUI::RenderingWindow & w ){
        CEGUI::RenderingSurface::detatchWindow( boost::ref(w) );
    }

    void draw( ::CEGUI::RenderQueue const & queue, ::CEGUI::RenderQueueEventArgs & args ){
        CEGUI::RenderingSurface::draw( boost::ref(queue), boost::ref(args) );
    }

    virtual void drawContent(  ){
        if( bp::override func_drawContent = this->get_override( "drawContent" ) )
            func_drawContent(  );
        else{
            this->CEGUI::RenderingSurface::drawContent(  );
        }
    }
    
    virtual void default_drawContent(  ){
        CEGUI::RenderingSurface::drawContent( );
    }

    virtual void fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        if( bp::override func_fireEvent = this->get_override( "fireEvent" ) )
            func_fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        else{
            this->CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        }
    }
    
    void default_fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
    }

    void fireEvent_impl( ::CEGUI::String const & name, ::CEGUI::EventArgs & args ){
        CEGUI::EventSet::fireEvent_impl( boost::ref(name), boost::ref(args) );
    }

    ::CEGUI::ScriptModule * getScriptModule(  ) const {
        return CEGUI::EventSet::getScriptModule(  );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
    }

    virtual void transferRenderingWindow( ::CEGUI::RenderingWindow & window ) {
        if( bp::override func_transferRenderingWindow = this->get_override( "transferRenderingWindow" ) )
            func_transferRenderingWindow( boost::ref(window) );
        else{
            this->CEGUI::RenderingSurface::transferRenderingWindow( boost::ref(window) );
        }
    }
    
    void default_transferRenderingWindow( ::CEGUI::RenderingWindow & window ) {
        CEGUI::RenderingSurface::transferRenderingWindow( boost::ref(window) );
    }

};

void register_RenderingWindow_class(){

    { //::CEGUI::RenderingWindow
        typedef bp::class_< RenderingWindow_wrapper, bp::bases< CEGUI::RenderingSurface >, boost::noncopyable > RenderingWindow_exposer_t;
        RenderingWindow_exposer_t RenderingWindow_exposer = RenderingWindow_exposer_t( "RenderingWindow", "*!\n\
        \n\
            RenderingWindow is a RenderingSurface that can be drawn back onto another\n\
            RenderingSurface and is primarily intended to be used as a kind of cache for\n\
            rendered imagery.\n\
        *\n", bp::init< CEGUI::TextureTarget &, CEGUI::RenderingSurface & >(( bp::arg("target"), bp::arg("owner") ), "*!\n\
            \n\
                Constructor for RenderingWindow objects.\n\
        \n\
            @param target\n\
                The TextureTarget based object that will be used as the target for\n\
                content rendering done by the RenderingWindow.\n\
        \n\
            @param owner\n\
                The RenderingSurface object that will be our initial owner.  This\n\
                RenderingSurface is also the target where our cached imagery will be\n\
                rendered back to.\n\
        \n\
            \note\n\
                The TextureTarget  target remains under it's original ownership, and\n\
                the RenderingSurface  owner actually owns  e this object.\n\
            *\n") );
        bp::scope RenderingWindow_scope( RenderingWindow_exposer );
        { //::CEGUI::RenderingWindow::draw
        
            typedef void ( ::CEGUI::RenderingWindow::*draw_function_type )(  ) ;
            typedef void ( RenderingWindow_wrapper::*default_draw_function_type )(  ) ;
            
            RenderingWindow_exposer.def( 
                "draw"
                , draw_function_type(&::CEGUI::RenderingWindow::draw)
                , default_draw_function_type(&RenderingWindow_wrapper::default_draw) );
        
        }
        { //::CEGUI::RenderingWindow::getOwner
        
            typedef ::CEGUI::RenderingSurface const & ( ::CEGUI::RenderingWindow::*getOwner_function_type )(  ) const;
            
            RenderingWindow_exposer.def( 
                "getOwner"
                , getOwner_function_type( &::CEGUI::RenderingWindow::getOwner )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Return the RenderingSurface that owns the RenderingWindow.  This is\n\
                    also the RenderingSurface that will be used when the RenderingWindow\n\
                    renders back it's cached imagery content.\n\
            \n\
                @return\n\
                    RenderingSurface object that owns, and is targetted by, the\n\
                    RenderingWindow.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::getOwner
        
            typedef ::CEGUI::RenderingSurface & ( ::CEGUI::RenderingWindow::*getOwner_function_type )(  ) ;
            
            RenderingWindow_exposer.def( 
                "getOwner"
                , getOwner_function_type( &::CEGUI::RenderingWindow::getOwner )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Return the RenderingSurface that owns the RenderingWindow.  This is\n\
                    also the RenderingSurface that will be used when the RenderingWindow\n\
                    renders back it's cached imagery content.\n\
            \n\
                @return\n\
                    RenderingSurface object that owns, and is targetted by, the\n\
                    RenderingWindow.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::getPivot
        
            typedef ::CEGUI::Vector3f const & ( ::CEGUI::RenderingWindow::*getPivot_function_type )(  ) const;
            
            RenderingWindow_exposer.def( 
                "getPivot"
                , getPivot_function_type( &::CEGUI::RenderingWindow::getPivot )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Return the rotation pivot point location for the RenderingWindow.\n\
            \n\
                @return\n\
                    Vector3 object describing the current location of the pivot point used\n\
                    when rotating the RenderingWindow.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::getPosition
        
            typedef ::CEGUI::Vector2f const & ( ::CEGUI::RenderingWindow::*getPosition_function_type )(  ) const;
            
            RenderingWindow_exposer.def( 
                "getPosition"
                , getPosition_function_type( &::CEGUI::RenderingWindow::getPosition )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Return the current pixel position of the RenderingWindow.  The origin is\n\
                    at the top-left corner.\n\
            \n\
                @return\n\
                    Vector2 object describing the pixel position of the RenderingWindow.\n\
            \n\
                \note\n\
                    This position is an absolute pixel location relative to the screen or\n\
                    other root surface.  It is  e not relative to the owner of the\n\
                    RenderingWindow.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::getRenderEffect
        
            typedef ::CEGUI::RenderEffect * ( ::CEGUI::RenderingWindow::*getRenderEffect_function_type )(  ) ;
            
            RenderingWindow_exposer.def( 
                "getRenderEffect"
                , getRenderEffect_function_type( &::CEGUI::RenderingWindow::getRenderEffect )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Return a pointer to the RenderEffect currently being used with the\n\
                    RenderingWindow.  A return value of 0 indicates that no RenderEffect\n\
                    is being used.\n\
            \n\
                @return\n\
                    Pointer to the RenderEffect used with this RenderingWindow, or 0 for\n\
                    none.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::getRotation
        
            typedef ::CEGUI::Quaternion const & ( ::CEGUI::RenderingWindow::*getRotation_function_type )(  ) const;
            
            RenderingWindow_exposer.def( 
                "getRotation"
                , getRotation_function_type( &::CEGUI::RenderingWindow::getRotation )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Return the current rotation being applied to the RenderingWindow\n\
            \n\
                @return\n\
                    Quaternion object describing the rotation for the RenderingWindow.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::getSize
        
            typedef ::CEGUI::Sizef const & ( ::CEGUI::RenderingWindow::*getSize_function_type )(  ) const;
            
            RenderingWindow_exposer.def( 
                "getSize"
                , getSize_function_type( &::CEGUI::RenderingWindow::getSize )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Return the current size of the RenderingWindow in pixels.\n\
            \n\
                @return\n\
                    Size object describing the current pixel size of the RenderingWindow.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::getTextureTarget
        
            typedef ::CEGUI::TextureTarget const & ( ::CEGUI::RenderingWindow::*getTextureTarget_function_type )(  ) const;
            
            RenderingWindow_exposer.def( 
                "getTextureTarget"
                , getTextureTarget_function_type( &::CEGUI::RenderingWindow::getTextureTarget )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Return the TextureTarget object that is the target for content rendered\n\
                    to this RenderingWindows.  This is the same object passed into the\n\
                    constructor.\n\
            \n\
                @return\n\
                    The TextureTarget object that receives the rendered output resulting\n\
                    from geometry queued to this RenderingWindow.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::getTextureTarget
        
            typedef ::CEGUI::TextureTarget & ( ::CEGUI::RenderingWindow::*getTextureTarget_function_type )(  ) ;
            
            RenderingWindow_exposer.def( 
                "getTextureTarget"
                , getTextureTarget_function_type( &::CEGUI::RenderingWindow::getTextureTarget )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Return the TextureTarget object that is the target for content rendered\n\
                    to this RenderingWindows.  This is the same object passed into the\n\
                    constructor.\n\
            \n\
                @return\n\
                    The TextureTarget object that receives the rendered output resulting\n\
                    from geometry queued to this RenderingWindow.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::invalidate
        
            typedef void ( ::CEGUI::RenderingWindow::*invalidate_function_type )(  ) ;
            typedef void ( RenderingWindow_wrapper::*default_invalidate_function_type )(  ) ;
            
            RenderingWindow_exposer.def( 
                "invalidate"
                , invalidate_function_type(&::CEGUI::RenderingWindow::invalidate)
                , default_invalidate_function_type(&RenderingWindow_wrapper::default_invalidate) );
        
        }
        { //::CEGUI::RenderingWindow::invalidateGeometry
        
            typedef void ( ::CEGUI::RenderingWindow::*invalidateGeometry_function_type )(  ) ;
            
            RenderingWindow_exposer.def( 
                "invalidateGeometry"
                , invalidateGeometry_function_type( &::CEGUI::RenderingWindow::invalidateGeometry )
                , "*!\n\
                \n\
                    Mark the geometry used when rendering the RenderingWindow back to it's\n\
                    owning RenderingSurface as invalid so that it gets regenerated on the\n\
                    next rendering pass.\n\
            \n\
                    This is separate from the main invalidate() function because in most\n\
                    cases invalidating the cached imagery will not require the potentially\n\
                    expensive regeneration of the geometry for the RenderingWindow itself.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::isRenderingWindow
        
            typedef bool ( ::CEGUI::RenderingWindow::*isRenderingWindow_function_type )(  ) const;
            typedef bool ( RenderingWindow_wrapper::*default_isRenderingWindow_function_type )(  ) const;
            
            RenderingWindow_exposer.def( 
                "isRenderingWindow"
                , isRenderingWindow_function_type(&::CEGUI::RenderingWindow::isRenderingWindow)
                , default_isRenderingWindow_function_type(&RenderingWindow_wrapper::default_isRenderingWindow) );
        
        }
        { //::CEGUI::RenderingWindow::realiseGeometry
        
            typedef void ( ::CEGUI::RenderingWindow::*realiseGeometry_function_type )(  ) ;
            
            RenderingWindow_exposer.def( 
                "realiseGeometry"
                , realiseGeometry_function_type( &::CEGUI::RenderingWindow::realiseGeometry )
                , "*!\n\
                \n\
                    generate geometry to be used when rendering back the RenderingWindow to\n\
                    it's owning RenderingSurface.\n\
            \n\
                \note\n\
                    In normal usage you should never have to call this directly.  There may\n\
                    be certain cases where it might be useful to call this when using the\n\
                    RenderEffect system.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::realiseGeometry_impl
        
            typedef void ( RenderingWindow_wrapper::*realiseGeometry_impl_function_type )(  ) ;
            
            RenderingWindow_exposer.def( 
                "realiseGeometry_impl"
                , realiseGeometry_impl_function_type( &RenderingWindow_wrapper::default_realiseGeometry_impl )
                , "! default generates geometry to draw window as a single quad.\n" );
        
        }
        { //::CEGUI::RenderingWindow::setClippingRegion
        
            typedef void ( ::CEGUI::RenderingWindow::*setClippingRegion_function_type )( ::CEGUI::Rectf const & ) ;
            
            RenderingWindow_exposer.def( 
                "setClippingRegion"
                , setClippingRegion_function_type( &::CEGUI::RenderingWindow::setClippingRegion )
                , ( bp::arg("region") )
                , "*!\n\
                \n\
                    Set the clipping region that will be used when rendering the imagery\n\
                    for this RenderingWindow back onto the RenderingSurface that owns it.\n\
            \n\
                \note\n\
                    This is not the clipping region used when rendering the queued geometry\n\
                     e onto the RenderingWindow, that still uses whatever regions are set\n\
                    on the queued GeometryBuffer objects.\n\
            \n\
                @param region\n\
                    Rect object describing a rectangular clipping region.\n\
            \n\
                \note\n\
                    The region should be described as absolute pixel locations relative to\n\
                    the screen or other root surface.  The region should  e not be described\n\
                    relative to the owner of the RenderingWindow.\n\
            \n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::setOwner
        
            typedef void ( RenderingWindow_wrapper::*setOwner_function_type )( ::CEGUI::RenderingSurface & ) ;
            
            RenderingWindow_exposer.def( 
                "setOwner"
                , setOwner_function_type( &RenderingWindow_wrapper::setOwner )
                , ( bp::arg("owner") )
                , "! set a new owner for this RenderingWindow object\n" );
        
        }
        { //::CEGUI::RenderingWindow::setPivot
        
            typedef void ( ::CEGUI::RenderingWindow::*setPivot_function_type )( ::CEGUI::Vector3f const & ) ;
            
            RenderingWindow_exposer.def( 
                "setPivot"
                , setPivot_function_type( &::CEGUI::RenderingWindow::setPivot )
                , ( bp::arg("pivot") )
                , "*!\n\
                \n\
                    Set the location of the pivot point around which the RenderingWindow\n\
                    will be rotated.\n\
            \n\
                @param pivot\n\
                    Vector3 describing the three dimensional point around which the\n\
                    RenderingWindow will be rotated.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::setPosition
        
            typedef void ( ::CEGUI::RenderingWindow::*setPosition_function_type )( ::CEGUI::Vector2f const & ) ;
            
            RenderingWindow_exposer.def( 
                "setPosition"
                , setPosition_function_type( &::CEGUI::RenderingWindow::setPosition )
                , ( bp::arg("position") )
                , "*!\n\
                \n\
                    Set the two dimensional position of the RenderingWindow in pixels.  The\n\
                    origin is at the top-left corner.\n\
            \n\
                @param position\n\
                    Vector2 object describing the desired location of the RenderingWindow,\n\
                    in pixels.\n\
            \n\
                \note\n\
                    This position is an absolute pixel location relative to the screen or\n\
                    other root surface.  It is  e not relative to the owner of the\n\
                    RenderingWindow.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::setRenderEffect
        
            typedef void ( ::CEGUI::RenderingWindow::*setRenderEffect_function_type )( ::CEGUI::RenderEffect * ) ;
            
            RenderingWindow_exposer.def( 
                "setRenderEffect"
                , setRenderEffect_function_type( &::CEGUI::RenderingWindow::setRenderEffect )
                , ( bp::arg("effect") )
                , "*!\n\
                \n\
                    Set the RenderEffect that should be used with the RenderingWindow.  This\n\
                    may be 0 to remove a previously set RenderEffect.\n\
            \n\
                \note\n\
                    Ownership of the RenderEffect does not change; the RenderingWindow will\n\
                    not delete a RenderEffect assigned to it when the RenderingWindow is\n\
                    destroyed.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::setRotation
        
            typedef void ( ::CEGUI::RenderingWindow::*setRotation_function_type )( ::CEGUI::Quaternion const & ) ;
            
            RenderingWindow_exposer.def( 
                "setRotation"
                , setRotation_function_type( &::CEGUI::RenderingWindow::setRotation )
                , ( bp::arg("rotation") )
                , "*!\n\
                \n\
                    Set the rotation quaternion to be used when rendering the RenderingWindow\n\
                    back onto it's owning RenderingSurface.\n\
            \n\
                @param rotation\n\
                    Quaternion object describing the rotation.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::setSize
        
            typedef void ( ::CEGUI::RenderingWindow::*setSize_function_type )( ::CEGUI::Sizef const & ) ;
            
            RenderingWindow_exposer.def( 
                "setSize"
                , setSize_function_type( &::CEGUI::RenderingWindow::setSize )
                , ( bp::arg("size") )
                , "*!\n\
                \n\
                    Set the size of the RenderingWindow in pixels.\n\
            \n\
                @param size\n\
                    Size object that describes the desired size of the RenderingWindow, in\n\
                    pixels.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingWindow::unprojectPoint
        
            typedef void ( ::CEGUI::RenderingWindow::*unprojectPoint_function_type )( ::CEGUI::Vector2f const &,::CEGUI::Vector2f & ) ;
            
            RenderingWindow_exposer.def( 
                "unprojectPoint"
                , unprojectPoint_function_type( &::CEGUI::RenderingWindow::unprojectPoint )
                , ( bp::arg("p_in"), bp::arg("p_out") )
                , "*!\n\
            \n\
                Fill in Vector2 object  p_out with an unprojected version of the\n\
                point described by Vector2  p_in.\n\
            *\n" );
        
        }
        { //::CEGUI::RenderingWindow::update
        
            typedef void ( ::CEGUI::RenderingWindow::*update_function_type )( float const ) ;
            
            RenderingWindow_exposer.def( 
                "update"
                , update_function_type( &::CEGUI::RenderingWindow::update )
                , ( bp::arg("elapsed") )
                , "*!\n\
                \n\
                    Peform time based updated for the RenderingWindow.\n\
            \n\
                \note\n\
                    Currently this really only has meaning for RenderingWindow objects that\n\
                    have RenderEffect objects set.  Though this may not always be the case.\n\
            \n\
                @param elapsed\n\
                    float value describing the number of seconds that have passed since the\n\
                    previous call to update.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderingSurface::attachWindow
        
            typedef void ( RenderingWindow_wrapper::*attachWindow_function_type )( ::CEGUI::RenderingWindow & ) ;
            
            RenderingWindow_exposer.def( 
                "attachWindow"
                , attachWindow_function_type( &RenderingWindow_wrapper::attachWindow )
                , ( bp::arg("w") )
                , "! attach ReneringWindow from this RenderingSurface\n" );
        
        }
        { //::CEGUI::RenderingSurface::createRenderingWindow
        
            typedef ::CEGUI::RenderingWindow & ( ::CEGUI::RenderingSurface::*createRenderingWindow_function_type )( ::CEGUI::TextureTarget & ) ;
            
            RenderingWindow_exposer.def( 
                "createRenderingWindow"
                , createRenderingWindow_function_type(&::CEGUI::RenderingSurface::createRenderingWindow)
                , ( bp::arg("target") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::RenderingSurface::destroyRenderingWindow
        
            typedef void ( ::CEGUI::RenderingSurface::*destroyRenderingWindow_function_type )( ::CEGUI::RenderingWindow & ) ;
            typedef void ( RenderingWindow_wrapper::*default_destroyRenderingWindow_function_type )( ::CEGUI::RenderingWindow & ) ;
            
            RenderingWindow_exposer.def( 
                "destroyRenderingWindow"
                , destroyRenderingWindow_function_type(&::CEGUI::RenderingSurface::destroyRenderingWindow)
                , default_destroyRenderingWindow_function_type(&RenderingWindow_wrapper::default_destroyRenderingWindow)
                , ( bp::arg("window") ) );
        
        }
        { //::CEGUI::RenderingSurface::detatchWindow
        
            typedef void ( RenderingWindow_wrapper::*detatchWindow_function_type )( ::CEGUI::RenderingWindow & ) ;
            
            RenderingWindow_exposer.def( 
                "detatchWindow"
                , detatchWindow_function_type( &RenderingWindow_wrapper::detatchWindow )
                , ( bp::arg("w") )
                , "! detatch ReneringWindow from this RenderingSurface\n" );
        
        }
        { //::CEGUI::RenderingSurface::draw
        
            typedef void ( RenderingWindow_wrapper::*draw_function_type )( ::CEGUI::RenderQueue const &,::CEGUI::RenderQueueEventArgs & ) ;
            
            RenderingWindow_exposer.def( 
                "draw"
                , draw_function_type( &RenderingWindow_wrapper::draw )
                , ( bp::arg("queue"), bp::arg("args") )
                , "! draw a rendering queue, firing events before and after.\n" );
        
        }
        { //::CEGUI::RenderingSurface::drawContent
        
            typedef void ( RenderingWindow_wrapper::*drawContent_function_type )(  ) ;
            
            RenderingWindow_exposer.def( 
                "drawContent"
                , drawContent_function_type( &RenderingWindow_wrapper::default_drawContent )
                , "** draw the surface content. Default impl draws the render queues.\n\
             * NB: Called between RenderTarget activate and deactivate calls.\n\
             *\n" );
        
        }
        { //::CEGUI::EventSet::fireEvent
        
            typedef void ( ::CEGUI::EventSet::*fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            typedef void ( RenderingWindow_wrapper::*default_fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            
            RenderingWindow_exposer.def( 
                "fireEvent"
                , fireEvent_function_type(&::CEGUI::EventSet::fireEvent)
                , default_fireEvent_function_type(&RenderingWindow_wrapper::default_fireEvent)
                , ( bp::arg("name"), bp::arg("args"), bp::arg("eventNamespace")="" ) );
        
        }
        { //::CEGUI::EventSet::fireEvent_impl
        
            typedef void ( RenderingWindow_wrapper::*fireEvent_impl_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs & ) ;
            
            RenderingWindow_exposer.def( 
                "fireEvent_impl"
                , fireEvent_impl_function_type( &RenderingWindow_wrapper::fireEvent_impl )
                , ( bp::arg("name"), bp::arg("args") )
                , "! Implementation event firing member\n" );
        
        }
        { //::CEGUI::EventSet::getScriptModule
        
            typedef ::CEGUI::ScriptModule * ( RenderingWindow_wrapper::*getScriptModule_function_type )(  ) const;
            
            RenderingWindow_exposer.def( 
                "getScriptModule"
                , getScriptModule_function_type( &RenderingWindow_wrapper::getScriptModule )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! Implementation event firing member\n\
            ! Helper to return the script module pointer or throw.\n" );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( RenderingWindow_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            RenderingWindow_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&RenderingWindow_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("subscriber_name") ) );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( RenderingWindow_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            
            RenderingWindow_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&RenderingWindow_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("group"), bp::arg("subscriber_name") ) );
        
        }
        { //::CEGUI::RenderingSurface::transferRenderingWindow
        
            typedef void ( ::CEGUI::RenderingSurface::*transferRenderingWindow_function_type )( ::CEGUI::RenderingWindow & ) ;
            typedef void ( RenderingWindow_wrapper::*default_transferRenderingWindow_function_type )( ::CEGUI::RenderingWindow & ) ;
            
            RenderingWindow_exposer.def( 
                "transferRenderingWindow"
                , transferRenderingWindow_function_type(&::CEGUI::RenderingSurface::transferRenderingWindow)
                , default_transferRenderingWindow_function_type(&RenderingWindow_wrapper::default_transferRenderingWindow)
                , ( bp::arg("window") ) );
        
        }
    }

}
