// This file has been generated by Py++.

#include "boost/python.hpp"
#include "generators/include/python_CEGUI.h"
#include "System.pypp.hpp"

namespace bp = boost::python;

struct System_wrapper : CEGUI::System, bp::wrapper< CEGUI::System > {

    System_wrapper(::CEGUI::Renderer & renderer, ::CEGUI::ResourceProvider * resourceProvider, ::CEGUI::XMLParser * xmlParser, ::CEGUI::ImageCodec * imageCodec, ::CEGUI::ScriptModule * scriptModule, ::CEGUI::String const & configFile, ::CEGUI::String const & logFile )
    : CEGUI::System( boost::ref(renderer), boost::python::ptr(resourceProvider), boost::python::ptr(xmlParser), boost::python::ptr(imageCodec), boost::python::ptr(scriptModule), boost::ref(configFile), boost::ref(logFile) )
      , bp::wrapper< CEGUI::System >(){
        // constructor
    
    }

    void cleanupImageCodec(  ){
        CEGUI::System::cleanupImageCodec(  );
    }

    void cleanupXMLParser(  ){
        CEGUI::System::cleanupXMLParser(  );
    }

    void createSingletons(  ){
        CEGUI::System::createSingletons(  );
    }

    void destroySingletons(  ){
        CEGUI::System::destroySingletons(  );
    }

    void invalidateAllWindows(  ){
        CEGUI::System::invalidateAllWindows(  );
    }

    void outputLogHeader(  ){
        CEGUI::System::outputLogHeader(  );
    }

    void setupImageCodec( ::CEGUI::String const & codecName ){
        CEGUI::System::setupImageCodec( boost::ref(codecName) );
    }

    void setupXMLParser(  ){
        CEGUI::System::setupXMLParser(  );
    }

    virtual void fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        if( bp::override func_fireEvent = this->get_override( "fireEvent" ) )
            func_fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        else{
            this->CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        }
    }
    
    void default_fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
    }

    void fireEvent_impl( ::CEGUI::String const & name, ::CEGUI::EventArgs & args ){
        CEGUI::EventSet::fireEvent_impl( boost::ref(name), boost::ref(args) );
    }

    ::CEGUI::ScriptModule * getScriptModule(  ) const {
        return CEGUI::EventSet::getScriptModule(  );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
    }

};

void register_System_class(){

    { //::CEGUI::System
        typedef bp::class_< System_wrapper, bp::bases< CEGUI::Singleton< CEGUI::System >, CEGUI::EventSet >, boost::noncopyable > System_exposer_t;
        System_exposer_t System_exposer = System_exposer_t( "System", bp::no_init );
        bp::scope System_scope( System_exposer );
        System_exposer.def( bp::init< CEGUI::Renderer &, CEGUI::ResourceProvider *, CEGUI::XMLParser *, CEGUI::ImageCodec *, CEGUI::ScriptModule *, CEGUI::String const &, CEGUI::String const & >(( bp::arg("renderer"), bp::arg("resourceProvider"), bp::arg("xmlParser"), bp::arg("imageCodec"), bp::arg("scriptModule"), bp::arg("configFile"), bp::arg("logFile") )) );
        { //::CEGUI::System::addStandardWindowFactories
        
            typedef void ( ::CEGUI::System::*addStandardWindowFactories_function_type )(  ) ;
            
            System_exposer.def( 
                "addStandardWindowFactories"
                , addStandardWindowFactories_function_type( &::CEGUI::System::addStandardWindowFactories )
                , "*!\n\
                 adds factories for all the basic window types\n\
            \n\
                You do not need to call this manually! Standard Window factories will be\n\
                added automatically. One occasion when you will need this is if you\n\
                remove all window factories from WindowFactoryManager and want to add the\n\
                standard ones back\n\
                *\n" );
        
        }
        { //::CEGUI::System::cleanupImageCodec
        
            typedef void ( System_wrapper::*cleanupImageCodec_function_type )(  ) ;
            
            System_exposer.def( 
                "cleanupImageCodec"
                , cleanupImageCodec_function_type( &System_wrapper::cleanupImageCodec )
                , "! cleanup image codec \n" );
        
        }
        { //::CEGUI::System::cleanupXMLParser
        
            typedef void ( System_wrapper::*cleanupXMLParser_function_type )(  ) ;
            
            System_exposer.def( 
                "cleanupXMLParser"
                , cleanupXMLParser_function_type( &System_wrapper::cleanupXMLParser )
                , "! handle cleanup of the XML parser\n" );
        
        }
        { //::CEGUI::System::create
        
            typedef ::CEGUI::System & ( *create_function_type )( ::CEGUI::Renderer &,::CEGUI::ResourceProvider *,::CEGUI::XMLParser *,::CEGUI::ImageCodec *,::CEGUI::ScriptModule *,::CEGUI::String const &,::CEGUI::String const &,int const );
            
            System_exposer.def( 
                "create"
                , create_function_type( &::CEGUI::System::create )
                , ( bp::arg("renderer"), bp::arg("resourceProvider")=bp::object(), bp::arg("xmlParser")=bp::object(), bp::arg("imageCodec")=bp::object(), bp::arg("scriptModule")=bp::object(), bp::arg("configFile")="", bp::arg("logFile")="CEGUI.log", bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::System::createGUIContext
        
            typedef ::CEGUI::GUIContext & ( ::CEGUI::System::*createGUIContext_function_type )( ::CEGUI::RenderTarget & ) ;
            
            System_exposer.def( 
                "createGUIContext"
                , createGUIContext_function_type( &::CEGUI::System::createGUIContext )
                , ( bp::arg("rt") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::System::createRegexMatcher
        
            typedef ::CEGUI::RegexMatcher * ( ::CEGUI::System::*createRegexMatcher_function_type )(  ) const;
            
            System_exposer.def( 
                "createRegexMatcher"
                , createRegexMatcher_function_type( &::CEGUI::System::createRegexMatcher )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Create a RegexMatcher instance if support is available.\n\
            \n\
                @return\n\
                    Pointer to an object that implements the RegexMatcher interface, or 0\n\
                    if the system has no built in support for RegexMatcher creation.\n\
            \n\
                \note\n\
                    The created RegexMatcher is not tracked in any way, and it is the\n\
                    resposibility of the caller to destroy the RegexMatcher when it is no\n\
                    longer needed by calling System.destroyRegexMatcher.\n\
                *\n" );
        
        }
        { //::CEGUI::System::createSingletons
        
            typedef void ( System_wrapper::*createSingletons_function_type )(  ) ;
            
            System_exposer.def( 
                "createSingletons"
                , createSingletons_function_type( &System_wrapper::createSingletons )
                , "! create the other core system singleton objects (except the logger)\n" );
        
        }
        { //::CEGUI::System::destroy
        
            typedef void ( *destroy_function_type )(  );
            
            System_exposer.def( 
                "destroy"
                , destroy_function_type( &::CEGUI::System::destroy )
                , "! Destroy the System object.\n" );
        
        }
        { //::CEGUI::System::destroyGUIContext
        
            typedef void ( ::CEGUI::System::*destroyGUIContext_function_type )( ::CEGUI::GUIContext & ) ;
            
            System_exposer.def( 
                "destroyGUIContext"
                , destroyGUIContext_function_type( &::CEGUI::System::destroyGUIContext )
                , ( bp::arg("context") ) );
        
        }
        { //::CEGUI::System::destroyRegexMatcher
        
            typedef void ( ::CEGUI::System::*destroyRegexMatcher_function_type )( ::CEGUI::RegexMatcher * ) const;
            
            System_exposer.def( 
                "destroyRegexMatcher"
                , destroyRegexMatcher_function_type( &::CEGUI::System::destroyRegexMatcher )
                , ( bp::arg("rm") )
                , "! destroy a RegexMatcher instance returned by System.createRegexMatcher.\n" );
        
        }
        { //::CEGUI::System::destroySingletons
        
            typedef void ( System_wrapper::*destroySingletons_function_type )(  ) ;
            
            System_exposer.def( 
                "destroySingletons"
                , destroySingletons_function_type( &System_wrapper::destroySingletons )
                , "! cleanup the core system singleton objects\n" );
        
        }
        { //::CEGUI::System::executeScriptFile
        
            typedef void ( ::CEGUI::System::*executeScriptFile_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) const;
            
            System_exposer.def( 
                "executeScriptFile"
                , executeScriptFile_function_type( &::CEGUI::System::executeScriptFile )
                , ( bp::arg("filename"), bp::arg("resourceGroup")="" )
                , "*!\n\
               \n\
                  Execute a script file if possible.\n\
            \n\
               @param filename\n\
                  String object holding the filename of the script file that is to be executed\n\
            \n\
               @param resourceGroup\n\
                  Resource group identifier to be passed to the ResourceProvider when loading the script file.\n\
               *\n" );
        
        }
        { //::CEGUI::System::executeScriptGlobal
        
            typedef int ( ::CEGUI::System::*executeScriptGlobal_function_type )( ::CEGUI::String const & ) const;
            
            System_exposer.def( 
                "executeScriptGlobal"
                , executeScriptGlobal_function_type( &::CEGUI::System::executeScriptGlobal )
                , ( bp::arg("function_name") )
                , "*!\n\
               \n\
                  Execute a scripted global function if possible.  The function should not take any parameters\
                  and should return an integer.\n\
            \n\
               @param function_name\n\
                  String object holding the name of the function, in the global script environment, that\n\
                  is to be executed.\n\
            \n\
               @return\n\
                  The integer value returned from the script function.\n\
               *\n" );
        
        }
        { //::CEGUI::System::executeScriptString
        
            typedef void ( ::CEGUI::System::*executeScriptString_function_type )( ::CEGUI::String const & ) const;
            
            System_exposer.def( 
                "executeScriptString"
                , executeScriptString_function_type( &::CEGUI::System::executeScriptString )
                , ( bp::arg("str") )
                , "*!\n\
                \n\
                    If possible, execute script code contained in the given CEGUI.String object.\n\
            \n\
                @param str\n\
                    String object holding the valid script code that should be executed.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::System::getClipboard
        
            typedef ::CEGUI::Clipboard * ( ::CEGUI::System::*getClipboard_function_type )(  ) const;
            
            System_exposer.def( 
                "getClipboard"
                , getClipboard_function_type( &::CEGUI::System::getClipboard )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
            \n\
                Retrieves internal CEGUI clipboard, optionally synced with system wide clipboard\n\
            *\n" );
        
        }
        { //::CEGUI::System::getDefaultCustomRenderedStringParser
        
            typedef ::CEGUI::RenderedStringParser * ( ::CEGUI::System::*getDefaultCustomRenderedStringParser_function_type )(  ) const;
            
            System_exposer.def( 
                "getDefaultCustomRenderedStringParser"
                , getDefaultCustomRenderedStringParser_function_type( &::CEGUI::System::getDefaultCustomRenderedStringParser )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Return pointer to the currently set global default custom\n\
                    RenderedStringParser object.\n\
            \n\
                    The returned RenderedStringParser is used for all windows that have\n\
                    parsing enabled and no custom RenderedStringParser set on the window\n\
                    itself.\n\
            \n\
                    If this global custom RenderedStringParser is set to 0, then all windows\n\
                    with parsing enabled and no custom RenderedStringParser set on the\n\
                    window itself will use the systems BasicRenderedStringParser. \n\
                *\n" );
        
        }
        { //::CEGUI::System::getDefaultGUIContext
        
            typedef ::CEGUI::GUIContext & ( ::CEGUI::System::*getDefaultGUIContext_function_type )(  ) const;
            
            System_exposer.def( 
                "getDefaultGUIContext"
                , getDefaultGUIContext_function_type( &::CEGUI::System::getDefaultGUIContext )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::System::getDefaultImageCodecName
        
            typedef ::CEGUI::String const & ( *getDefaultImageCodecName_function_type )(  );
            
            System_exposer.def( 
                "getDefaultImageCodecName"
                , getDefaultImageCodecName_function_type( &::CEGUI::System::getDefaultImageCodecName )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
            \n\
                Get the name of the default image codec.\n\
            *\n" );
        
        }
        { //::CEGUI::System::getDefaultXMLParserName
        
            typedef ::CEGUI::String const ( *getDefaultXMLParserName_function_type )(  );
            
            System_exposer.def( 
                "getDefaultXMLParserName"
                , getDefaultXMLParserName_function_type( &::CEGUI::System::getDefaultXMLParserName )
                , "*!\n\
                \n\
                    Return the name of the currently set default xml parser module.\n\
            \n\
                @return\n\
                    String holding the currently set default xml parser name.  Note that if\n\
                    this name has been changed after instantiating the system, the name\n\
                    returned may not actually correspond to the module in use.\n\
                *\n" );
        
        }
        { //::CEGUI::System::getImageCodec
        
            typedef ::CEGUI::ImageCodec & ( ::CEGUI::System::*getImageCodec_function_type )(  ) const;
            
            System_exposer.def( 
                "getImageCodec"
                , getImageCodec_function_type( &::CEGUI::System::getImageCodec )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
            \n\
                Retrieve the image codec to be used by the system.\n\
            *\n" );
        
        }
        { //::CEGUI::System::getMajorVersion
        
            typedef unsigned int ( *getMajorVersion_function_type )(  );
            
            System_exposer.def( 
                "getMajorVersion"
                , getMajorVersion_function_type( &::CEGUI::System::getMajorVersion )
                , "*!\n\
                \n\
                    Retrieves CEGUI's major version as an integer\n\
            \n\
                \note\n\
                    APIheaders major version is a macro called CEGUI_MAJOR_VERSION,\n\
                    this returns the version your application is linking to\n\
                *\n" );
        
        }
        { //::CEGUI::System::getMinorVersion
        
            typedef unsigned int ( *getMinorVersion_function_type )(  );
            
            System_exposer.def( 
                "getMinorVersion"
                , getMinorVersion_function_type( &::CEGUI::System::getMinorVersion )
                , "*!\n\
                \n\
                    Retrieves CEGUI's minor version as an integer\n\
            \n\
                \note\n\
                    APIheaders minor version is a macro called CEGUI_MINOR_VERSION,\n\
                    this returns the version your application is linking to\n\
                *\n" );
        
        }
        { //::CEGUI::System::getPatchVersion
        
            typedef unsigned int ( *getPatchVersion_function_type )(  );
            
            System_exposer.def( 
                "getPatchVersion"
                , getPatchVersion_function_type( &::CEGUI::System::getPatchVersion )
                , "*!\n\
                \n\
                    Retrieves CEGUI's patch version as an integer\n\
            \n\
                \note\n\
                    APIheaders patch version is a macro called CEGUI_PATCH_VERSION,\n\
                    this returns the version your application is linking to\n\
                *\n" );
        
        }
        { //::CEGUI::System::getRenderer
        
            typedef ::CEGUI::Renderer * ( ::CEGUI::System::*getRenderer_function_type )(  ) const;
            
            System_exposer.def( 
                "getRenderer"
                , getRenderer_function_type( &::CEGUI::System::getRenderer )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return a pointer to the Renderer object being used by the system\n\
            \n\
               @return\n\
                  Pointer to the Renderer object used by the system.\n\
               *\n" );
        
        }
        { //::CEGUI::System::getResourceProvider
        
            typedef ::CEGUI::ResourceProvider * ( ::CEGUI::System::*getResourceProvider_function_type )(  ) const;
            
            System_exposer.def( 
                "getResourceProvider"
                , getResourceProvider_function_type( &::CEGUI::System::getResourceProvider )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return a pointer to the ResourceProvider being used within the GUI system.\n\
            \n\
               @return\n\
                  Pointer to a ResourceProvider based object.\n\
               *\n" );
        
        }
        { //::CEGUI::System::getScriptingModule
        
            typedef ::CEGUI::ScriptModule * ( ::CEGUI::System::*getScriptingModule_function_type )(  ) const;
            
            System_exposer.def( 
                "getScriptingModule"
                , getScriptingModule_function_type( &::CEGUI::System::getScriptingModule )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return a pointer to the ScriptModule being used for scripting within the GUI system.\n\
            \n\
               @return\n\
                  Pointer to a ScriptModule based object.\n\
               *\n" );
        
        }
        { //::CEGUI::System::getSingleton
        
            typedef ::CEGUI::System & ( *getSingleton_function_type )(  );
            
            System_exposer.def( 
                "getSingleton"
                , getSingleton_function_type( &::CEGUI::System::getSingleton )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return singleton System object\n\
            \n\
               @return\n\
                  Singleton System object\n\
               *\n" );
        
        }
        { //::CEGUI::System::getVerboseVersion
        
            typedef ::CEGUI::String const & ( *getVerboseVersion_function_type )(  );
            
            System_exposer.def( 
                "getVerboseVersion"
                , getVerboseVersion_function_type( &::CEGUI::System::getVerboseVersion )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Retrieves CEGUI's verbose version, includes info about compiler, platform, etc...\n\
            \n\
                \note\n\
                    APIheaders verbose version can be constructed using various compiler specific macros,\n\
                    this returns the version your application is linking to\n\
                *\n" );
        
        }
        { //::CEGUI::System::getVersion
        
            typedef ::CEGUI::String const & ( *getVersion_function_type )(  );
            
            System_exposer.def( 
                "getVersion"
                , getVersion_function_type( &::CEGUI::System::getVersion )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Retrieves CEGUI's short version (1.2.3 for example)\n\
            \n\
                \note\n\
                    APIheaders version can be constructed using CEGUI_*_VERSION macros,\n\
                    this returns the version your application is linking to\n\
                *\n" );
        
        }
        { //::CEGUI::System::getXMLParser
        
            typedef ::CEGUI::XMLParser * ( ::CEGUI::System::*getXMLParser_function_type )(  ) const;
            
            System_exposer.def( 
                "getXMLParser"
                , getXMLParser_function_type( &::CEGUI::System::getXMLParser )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
            \n\
                Return the XMLParser object.\n\
             *\n" );
        
        }
        { //::CEGUI::System::injectTimePulse
        
            typedef bool ( ::CEGUI::System::*injectTimePulse_function_type )( float ) ;
            
            System_exposer.def( 
                "injectTimePulse"
                , injectTimePulse_function_type( &::CEGUI::System::injectTimePulse )
                , ( bp::arg("timeElapsed") )
                , "! call this to ensure system-level time based updates occur.\n" );
        
        }
        { //::CEGUI::System::invalidateAllCachedRendering
        
            typedef void ( ::CEGUI::System::*invalidateAllCachedRendering_function_type )(  ) ;
            
            System_exposer.def( 
                "invalidateAllCachedRendering"
                , invalidateAllCachedRendering_function_type( &::CEGUI::System::invalidateAllCachedRendering )
                , "*!\n\
                \n\
                    Invalidate all imagery and geometry caches for CEGUI managed elements.\n\
            \n\
                    This function will invalidate the caches used for both imagery and\n\
                    geometry for all content that is managed by the core CEGUI manager\n\
                    objects, causing a full and total redraw of that content.  This\n\
                    includes Window object's cached geometry, rendering surfaces and\n\
                    rendering windows and the mouse pointer geometry.\n\
                *\n" );
        
        }
        { //::CEGUI::System::invalidateAllWindows
        
            typedef void ( System_wrapper::*invalidateAllWindows_function_type )(  ) ;
            
            System_exposer.def( 
                "invalidateAllWindows"
                , invalidateAllWindows_function_type( &System_wrapper::invalidateAllWindows )
                , "! invalidate all windows and any rendering surfaces they may be using.\n" );
        
        }
        { //::CEGUI::System::notifyDisplaySizeChanged
        
            typedef void ( ::CEGUI::System::*notifyDisplaySizeChanged_function_type )( ::CEGUI::Sizef const & ) ;
            
            System_exposer.def( 
                "notifyDisplaySizeChanged"
                , notifyDisplaySizeChanged_function_type( &::CEGUI::System::notifyDisplaySizeChanged )
                , ( bp::arg("new_size") )
                , "*!\n\
                \n\
                    Notification function to be called when the main display changes size.\n\
                    Client code should call this function when the host window changes size,\n\
                    or if the display resolution is changed in full-screen mode.\n\
            \n\
                    Calling this function ensures that any other parts of the system that\n\
                    need to know about display size changes are notified.  This affects\n\
                    things such as the MouseCursor default constraint area, and also the\n\
                    auto-scale functioning of Imagesets and Fonts.\n\
            \n\
                \note\n\
                    This function will also fire the System.EventDisplaySizeChanged event.\n\
            \n\
                @param new_size\n\
                    Size object describing the new display size in pixels.\n\
                *\n" );
        
        }
        { //::CEGUI::System::outputLogHeader
        
            typedef void ( System_wrapper::*outputLogHeader_function_type )(  ) ;
            
            System_exposer.def( 
                "outputLogHeader"
                , outputLogHeader_function_type( &System_wrapper::outputLogHeader )
                , "! output the standard log header\n" );
        
        }
        { //::CEGUI::System::performVersionTest
        
            typedef void ( *performVersionTest_function_type )( int const,int const,::CEGUI::String const & );
            
            System_exposer.def( 
                "performVersionTest"
                , performVersionTest_function_type( &::CEGUI::System::performVersionTest )
                , ( bp::arg("expected"), bp::arg("received"), bp::arg("func") )
                , "! Internal CEGUI version validation function.\n" );
        
        }
        { //::CEGUI::System::renderAllGUIContexts
        
            typedef void ( ::CEGUI::System::*renderAllGUIContexts_function_type )(  ) ;
            
            System_exposer.def( 
                "renderAllGUIContexts"
                , renderAllGUIContexts_function_type( &::CEGUI::System::renderAllGUIContexts )
                , "*!\n\
            \n\
                Depending upon the internal state, for each GUIContext this may either\n\
                re-use cached rendering from last time or trigger a full re-draw of all\n\
                elements.\n\
            *\n" );
        
        }
        { //::CEGUI::System::setDefaultCustomRenderedStringParser
        
            typedef void ( ::CEGUI::System::*setDefaultCustomRenderedStringParser_function_type )( ::CEGUI::RenderedStringParser * ) ;
            
            System_exposer.def( 
                "setDefaultCustomRenderedStringParser"
                , setDefaultCustomRenderedStringParser_function_type( &::CEGUI::System::setDefaultCustomRenderedStringParser )
                , ( bp::arg("parser") )
                , "*!\n\
                \n\
                    Set the global default custom RenderedStringParser object.  This change\n\
                    is reflected the next time an affected window reparses it's text.  This\n\
                    may be set to 0 for no system wide custom parser (which is the default).\n\
            \n\
                    The set RenderedStringParser is used for all windows that have\n\
                    parsing enabled and no custom RenderedStringParser set on the window\n\
                    itself.\n\
            \n\
                    If this global custom RenderedStringParser is set to 0, then all windows\n\
                    with parsing enabled and no custom RenderedStringParser set on the\n\
                    window itself will use the systems BasicRenderedStringParser. \n\
                *\n" );
        
        }
        { //::CEGUI::System::setDefaultImageCodecName
        
            typedef void ( *setDefaultImageCodecName_function_type )( ::CEGUI::String const & );
            
            System_exposer.def( 
                "setDefaultImageCodecName"
                , setDefaultImageCodecName_function_type( &::CEGUI::System::setDefaultImageCodecName )
                , ( bp::arg("codecName") )
                , "*!\n\
            \n\
                Set the name of the default image codec to be used.\n\
            *\n" );
        
        }
        { //::CEGUI::System::setDefaultXMLParserName
        
            typedef void ( *setDefaultXMLParserName_function_type )( ::CEGUI::String const & );
            
            System_exposer.def( 
                "setDefaultXMLParserName"
                , setDefaultXMLParserName_function_type( &::CEGUI::System::setDefaultXMLParserName )
                , ( bp::arg("parserName") )
                , "*!\n\
                \n\
                    Static member to set the name of the default XML parser module that\n\
                    should be used.\n\
            \n\
                    If you want to modify the default parser from the one compiled in, you\n\
                    need to call this static member prior to instantiating the main\n\
                    CEGUI.System object.\n\
            \n\
                    Note that calling this member to change the name of the default module\n\
                    after CEGUI.System, and therefore the default xml parser, has been\n\
                    created will have no real effect - the default parser name will be\n\
                    updated, though no actual changes to the xml parser module will occur.\n\
            \n\
                    The built-in options for this are:\n\
                     - XercesParser\n\
                     - ExpatParser\n\
                     - LibxmlParser\n\
                     - TinyXMLParser\n\
            \n\
                    Whether these are actually available, depends upon how you built the\n\
                    system.  If you have some custom parser, you can provide the name of\n\
                    that here to have it used as the default, though note that the\n\
                    final filename of the parser module should be of the form:\n\
            \n\
                    [prefix]CEGUI[parserName][suffix]\n\
            \n\
                    where:\n\
                    - [prefix] is some optional prefix; like 'lib' on linux.\n\
                    - CEGUI is a required prefix.\n\
                    - [parserName] is the name of the parser, as supplied to this function.\n\
                    - [suffix] is the filename suffix, like .dll or .so\n\
            \n\
                    Final module filenames are, thus, of the form:\n\
                    - CEGUIXercesParser.dll\n\
                    - libCEGUIXercesParser.so\n\
            \n\
                @param parserName\n"
            "        String describing the name of the xml parser module to be used as the\n\
                    default.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n\
            " );
        
        }
        { //::CEGUI::System::setImageCodec
        
            typedef void ( ::CEGUI::System::*setImageCodec_function_type )( ::CEGUI::String const & ) ;
            
            System_exposer.def( 
                "setImageCodec"
                , setImageCodec_function_type( &::CEGUI::System::setImageCodec )
                , ( bp::arg("codecName") )
                , "*!\n\
            \n\
                Set the image codec to be used by the system.\n\
            *\n" );
        
        }
        { //::CEGUI::System::setImageCodec
        
            typedef void ( ::CEGUI::System::*setImageCodec_function_type )( ::CEGUI::ImageCodec & ) ;
            
            System_exposer.def( 
                "setImageCodec"
                , setImageCodec_function_type( &::CEGUI::System::setImageCodec )
                , ( bp::arg("codec") )
                , "*!\n\
                \n\
                    Set the image codec to use from an existing image codec.\n\
            \n\
                    In this case the renderer does not take the ownership of the image codec\n\
                    object.\n\
            \n\
                @param codec\n\
                    The ImageCodec object to be used.\n\
                *\n" );
        
        }
        { //::CEGUI::System::setScriptingModule
        
            typedef void ( ::CEGUI::System::*setScriptingModule_function_type )( ::CEGUI::ScriptModule * ) ;
            
            System_exposer.def( 
                "setScriptingModule"
                , setScriptingModule_function_type( &::CEGUI::System::setScriptingModule )
                , ( bp::arg("scriptModule") )
                , "*!\n\
                \n\
                    Set the ScriptModule to be used for scripting within the GUI system.\n\
            \n\
                @param scriptModule\n\
                    Pointer to a ScriptModule based object, or 0 for none (be careful!)\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::System::setXMLParser
        
            typedef void ( ::CEGUI::System::*setXMLParser_function_type )( ::CEGUI::String const & ) ;
            
            System_exposer.def( 
                "setXMLParser"
                , setXMLParser_function_type( &::CEGUI::System::setXMLParser )
                , ( bp::arg("parserName") )
                , "*!\n\
                \n\
                    Set a new XML parser module to be used.\n\
            \n\
                    The current XMLParser will be cleaned up and, if owned by the system,\n\
                    also deleted, as will any dynamically loaded module associated with the\n\
                    XMLParser object.  The newly created XMLParser object, and the\n\
                    associated module will be owned by the system.\n\
            \n\
                @param parserName\n\
                    String object describing the name of the XML parser module to be used.\n\
                *\n" );
        
        }
        { //::CEGUI::System::setXMLParser
        
            typedef void ( ::CEGUI::System::*setXMLParser_function_type )( ::CEGUI::XMLParser * ) ;
            
            System_exposer.def( 
                "setXMLParser"
                , setXMLParser_function_type( &::CEGUI::System::setXMLParser )
                , ( bp::arg("parser") )
                , "*!\n\
                \n\
                    Sets the XMLParser object to be used by the system.\n\
            \n\
                    The current XMLParser will be cleaned up and, if owned by the system,\n\
                    also deleted, as will any dynamically loaded module associated with the\n\
                    XMLParser object.\n\
            \n\
                    If the argument passed in the  parser parameter is 0, the system will\n\
                    cleanup any existing parser as described above, and revert to using\n\
                    the parser provided by the default module (see getDefaultXMLParserName\n\
                    and setDefaultXMLParserName).\n\
            \n\
                @param parser\n\
                    Pointer to the XMLParser object to be used by the system, or 0 to cause\n\
                    the system to initialise a default parser.\n\
                *\n" );
        
        }
        { //::CEGUI::System::setupImageCodec
        
            typedef void ( System_wrapper::*setupImageCodec_function_type )( ::CEGUI::String const & ) ;
            
            System_exposer.def( 
                "setupImageCodec"
                , setupImageCodec_function_type( &System_wrapper::setupImageCodec )
                , ( bp::arg("codecName") )
                , "! setup image codec \n" );
        
        }
        { //::CEGUI::System::setupXMLParser
        
            typedef void ( System_wrapper::*setupXMLParser_function_type )(  ) ;
            
            System_exposer.def( 
                "setupXMLParser"
                , setupXMLParser_function_type( &System_wrapper::setupXMLParser )
                , "! handle creation and initialisation of the XML parser.\n" );
        
        }
        System_exposer.add_static_property( "EventDisplaySizeChanged"
                        , bp::make_getter( &CEGUI::System::EventDisplaySizeChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        System_exposer.add_static_property( "EventRenderedStringParserChanged"
                        , bp::make_getter( &CEGUI::System::EventRenderedStringParserChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        { //::CEGUI::EventSet::fireEvent
        
            typedef void ( ::CEGUI::EventSet::*fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            typedef void ( System_wrapper::*default_fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            
            System_exposer.def( 
                "fireEvent"
                , fireEvent_function_type(&::CEGUI::EventSet::fireEvent)
                , default_fireEvent_function_type(&System_wrapper::default_fireEvent)
                , ( bp::arg("name"), bp::arg("args"), bp::arg("eventNamespace")="" ) );
        
        }
        { //::CEGUI::EventSet::fireEvent_impl
        
            typedef void ( System_wrapper::*fireEvent_impl_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs & ) ;
            
            System_exposer.def( 
                "fireEvent_impl"
                , fireEvent_impl_function_type( &System_wrapper::fireEvent_impl )
                , ( bp::arg("name"), bp::arg("args") )
                , "! Implementation event firing member\n" );
        
        }
        { //::CEGUI::EventSet::getScriptModule
        
            typedef ::CEGUI::ScriptModule * ( System_wrapper::*getScriptModule_function_type )(  ) const;
            
            System_exposer.def( 
                "getScriptModule"
                , getScriptModule_function_type( &System_wrapper::getScriptModule )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! Implementation event firing member\n\
            ! Helper to return the script module pointer or throw.\n" );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( System_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            System_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&System_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("subscriber_name") ) );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( System_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            
            System_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&System_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("group"), bp::arg("subscriber_name") ) );
        
        }
        System_exposer.staticmethod( "create" );
        System_exposer.staticmethod( "destroy" );
        System_exposer.staticmethod( "getDefaultImageCodecName" );
        System_exposer.staticmethod( "getDefaultXMLParserName" );
        System_exposer.staticmethod( "getMajorVersion" );
        System_exposer.staticmethod( "getMinorVersion" );
        System_exposer.staticmethod( "getPatchVersion" );
        System_exposer.staticmethod( "getSingleton" );
        System_exposer.staticmethod( "getVerboseVersion" );
        System_exposer.staticmethod( "getVersion" );
        System_exposer.staticmethod( "performVersionTest" );
        System_exposer.staticmethod( "setDefaultImageCodecName" );
        System_exposer.staticmethod( "setDefaultXMLParserName" );
    }

}
