// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// File Description:
//     Helper functionality to allow testing the Android NTP from any device.

var gmailURI =
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAAGX' +
    'RFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS' +
    '54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3' +
    'prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9Ik' +
    'Fkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMC' +
    'AgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5Lz' +
    'AyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG' +
    '1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaH' +
    'R0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy' +
    '5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD' +
    '0iQWRvYmUgUGhvdG9zaG9wIENTNSBNYWNpbnRvc2giIHhtcE1NOkluc3RhbmNlSUQ9InhtcC' +
    '5paWQ6Q0I4ODgwMUFERUU1MTFERjk1QUNDNjkwRjdDRDZDOEEiIHhtcE1NOkRvY3VtZW50SU' +
    'Q9InhtcC5kaWQ6Q0I4ODgwMUJERUU1MTFERjk1QUNDNjkwRjdDRDZDOEEiPiA8eG1wTU06RG' +
    'VyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpDQjg4ODAxOERFRTUxMURGOT' +
    'VBQ0M2OTBGN0NENkM4QSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpDQjg4ODAxOURFRT' +
    'UxMURGOTVBQ0M2OTBGN0NENkM4QSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPi' +
    'A8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PmexxOEAAAzaSURBVHja7Fv7bxxXFf' +
    '7u7DPxM34k8fsRN07bxHHiuDRt0iTtD6lAiCBa9SEQhZ8QPzSlBQSlUIH4AakSqPwBFIRUhK' +
    'BSVVEk+qBBAVraxqFt2saJk9ip42ey6/Xa+5qZe7kzc2fn7uzseu2sjSFd6XpmX7P3fOf7zj' +
    'n33DFhjOFGfii4wR+fAnCjA+C3Twgha/KDC0893MkPj7hefrHyp8//e62MluMesZ+sNgCxHz' +
    'xUqxDyGP+Vpz0nBTwbT6s/bn7mD9G1BGAtJEC48V/0EXK6kPHmh4Dj1aHAxbknH/qamBcRY3' +
    'Unt4oMIFe/90Bn2O97jp8fWpaHKPvbQirzeNPPX3iPP6UWQf53JEAmv3t/bWUgcJxf8umVTp' +
    'BpOlRV/+VoNP6TgedeiThKWecSmHvywWNVwcDQSo2HxHsum0e7qitGpr/5+cdWSxJlY8C17z' +
    '/YFfIpv+Knh8vhIYMBVKPWUTfO9fcWU+oTnb9+5Q3BBLYeJEDGnvhSbd2G0PFiAW7ZE6QcAM' +
    'toDgA1jwYIBhi6qv/mUmzxiTte/Gd0pUCUSwJGdD9WvyF0upzG21I3J8nsydrnpga+2lkRHr' +
    'n8wKHj5ZDFihgQ4XQP+JTnyDKje8nm69Txvq7lSIGp1JaEKYuUqj2+/aW3TiyHDSuWwMR37t' +
    '9UEfQ/xoPTj1azSJEBkGKAAMQ+N16ndrb47YX5xLeO/v1MSbJYiQRI/KmHHzEKldU0XsyOxw' +
    'Ce+o04wKgFiCwHcW4P46kP+ErPxtDI8N39x5dbRC3FAHLt2/f1BwL+Xyg+5RBW+8HnYnu14F' +
    'E6t5lCc89NWex+8+OCsiiVAWTm0WOHfQxDoPSQEZlX3X5qed/8LSo87z4ywRKTKV7sYLtDIK' +
    '+fHtx+TGLD0qtBj1pEIQo5YjKDSXUYKWdN5vpRRYGPDwSs54ZHLWNhG2f9rMEUHg+0ZMoCRg' +
    'BHVQ3p+YTJBs6QvfyTL/OhS+U0KwUAIpBTVFVTElNRjL35MaJj0+t2TS9bFa6twE2HdoMpBp' +
    'I59lEv1xUCwARBU3VS1ViDvvsOYGZ4HJdOnkEqtvhfN5JJM7XP/eEg2vb0oLG1EfOjU5jPaD' +
    'YAsvdZqRIwvuxTNd1H/TzGZjQ09jSjYVszrpweweW3h6GlMmtuJCvwuS3bW9G19yakZ+YQvz' +
    'xjSiJDqWFb0OV5thQDDM/7xOvBtKr5WdBvXkERGm2/rRdbd3bh/GtDmD03vmZGen2massm3H' +
    'K4H0pGRWJ81tI+tWJFWqdGJNnouiRdigFEigEGAxTjosZXqZUzzWjrD/mx89gdiE1EcP7VU4' +
    'hPR1fNSPnIRAD2h4LYcXAXWjgj50auIJPWTMMjnKk1xMomGZ36BAMyIhDqkn3MCwDiAsCvad' +
    'QEIJZWcUUD2itDqAlYUVjnP1K1uQaDXz+KqTOjOPvqELR0pmxGMhdvId7r2NmNWw/2ITlxDV' +
    'Eel4zKMMLnN7qYQigURg3VTCdpjgT8gtWKGLQQAHlZQBcMMIbS2IZEZzeil85iazqGcMAPQq' +
    '3SdHNvGxq4DsfeGcb5kx9ct5F5r/HR2L4F/ffsBc/xiF+YgM5pn+Jp8kI8iYVgGFvvvAsdlZ' +
    'VIvf4XbiI1HGQHQcXl3JIkYGUBDgAVABhlaUdzE7SmrRi7MAI2Ooy2AOUgEGh62owP3ftvQU' +
    'tfN07/6S1c/WR62Uba78mvBTjdB7jh7dvbeYCbRjyWgKpp+IR7fCpDsan3FtzWvxdVoRDUyQ' +
    'kkRSGlWQAEXAxAqXWACQA1LqaL0lO3Cg4/L4y29WxHrLkVF0eGUTN1CfVBn1mIqHEdfs6M/Q' +
    '8dwbXxq3j3z29ikafNpYwsxI4dA73ou3MXtLlFRD4aNecwk0xjdCGJQGsHbt0zgJa6el4LMd' +
    'PrjNmVJGcmpUSifckMyAGBG05sCWRLVIWZs6zewPXW14/plnZcOP8xNs9NopIbb0jCoGctrx' +
    '/u/cYXcO7dYZz5xwdIpzOeRnoZv6VtCw7cezvCoQAWeFpTubdjPNCNxhNIVlSj6+6D6GhrN1' +
    'pm2ahvVot2VWg5ixQzvBQGiAWGxQKrPjdQJua7ZoXMx+a6TagfvB3jk1OY/XAIrSwDv0KR4W' +
    'Wpxr3Vs7sHnbu68D4H4aNTw0WNr6yuwO1HBtDe1YzktRjmePXJFzbc4ylEuSMb+gfRv+NmbA' +
    'wExKrRWRPYawXLeNNhJa0I/Us1JrISoFYcMGZqrA+YgQCxFgeGJ4z4kGo8itGREQQufogmrj' +
    'qq6tASaQSrNmLf3QPo5hH8rTeGMDE+nRcT9u3fhV17e0E44EZqS3PwJvl3JzM6NrR1Yg/XeX' +
    '11teNx2Xh7cSRJwLV4K8gGf4GGrFU8GwwQEoCglqkoszdl0YAY7SuxlA75fOjt7UWM03Pkg/' +
    'fQMPsJqvnnU9G4uUipbqjBZx+4h4M0jpMnTmF+fhHdPa04cHgAlRUbkJiJIjkbQ4RXmZe411' +
    'HXgG0HB9He1Jw1GjmrQMd42CtGYbzZU1jO3qBnr8CIAVkJWEGG6EKrpv1idWb3Eoj1pzocxs' +
    '7Bz+DKbDcuvj+EpoUIQoqGhfEZhGoq0dHdjE5u+OxsFI2Nm5DhQETPjyPOtW7QPR4Io3X/QX' +
    'R2dSPk9xc0nrmWyuYcs1mLXTcAggG2BMQPcqMJc+hvkcpZJxuMsHnUUl+PLXdxj4+NQTv7Pj' +
    'ZnEqBXY0hF5lHR3ICGuhpz4ZKILlhpTaWovWkHBvv3mCCa63zqeJdKhmc9nwUhNwuYbL1eAJ' +
    'hoRTu64nnfMJFYErDAQFYKVkAjOULy8SfbOjqRam7B+Y/OYOOlYTSoKmIXJ00jJrnWxxfTPK' +
    '21o2/fbWZQzTY9qNPsYG7jc0CgDhi2ZBktAwCUOgFQHLMpwDDeBCO3uIHEALkGDvL4cOuu3Y' +
    'ht246L7/wLlZOXMbGQQKqyGp1H7kJne7vVDKFOSpODW06qM59Ty0a7b2gwRAKgPAywu7JUSj' +
    'UE2QZ9VgJwYgDJj6VWn18AUc0rtr4DBzE2fgU1165iH09rls6trJNtjMrNUCoHPFjZyB0L7D' +
    'StO067/hggM8DWlaC/1SkT2UB43YgNrEC/jNmviUN7UxOwtcliO5V6fXC1wKQeYI7ROcHPAY' +
    'LqDiPKEANkBghUTeOZpHUBiCkDtmQjwO7pSU8cIyE3PZGX5izKe2QBiQXlTIMSnUSFZf+YHf' +
    'SE4bAB8aooWD4K2QzlMjrbsnaBwPLyPaTCR4oV2VhVLgbYMUC6eC4DWHaNDxAHAuLdFcnKQw' +
    'Ige7D1jtzWt5cUcjKAO0boZWSAtQ3lc3rwfJjGS7o3DSeyyknRRphTn0g7PLYMwDzoX4QNeR' +
    'IQQdB2VlligC4xQMQAuQgyS+Gc3M9KaAo6WcHZ+WXSc5bLijwZILf8zXqfZY0vXwwwCiFBLY' +
    'hKUIR8QXfiyv3FGZDrcTkgyixAnqH5QRGexZEp2xKNL0kCUIEKn4JIIuEwwPC5oL8T+aWsUM' +
    'TzOZugLhbYMcBLAoUzg8QS6hgf4HNGCTJYkgFKMACVs6D58hgys7MINDRIFaBUELkqwLwk4M' +
    '4GLHejMmucWxLMHR+cLCAXTDTFF1GnTpnXCm4Imkt08OX0dS+GjK0myhcrWiqNq7//HYItra' +
    'IaJs6uskz/ogooFPW9KA1Xvqe5hY+c8/lr6swMaDoNhXu+urkembGZ8sSAJF/H125rRmYhCV' +
    '3VAG1ROD3X8FJvMGGyFDxTn6smoN4BkNndbdHqDDfVgnDjNzbWYO7CpLWxer0AnMuoZ1sjcT' +
    'MLVDTVIVRZledtkhP3lkKBeVeEck1AmStGeAdAr1hjdKAi567w5XYcowQzcvYtdWssZ7Y/TG' +
    'b+Ok+1l3tn1c9hNpqlvrv4YSS/rcg81gF53WHG8s6ZlCaZO/+7QSvwGA3ixLMZnFgJA/Lm+E' +
    'ya/uy+AB1v9eHLnG0Vxba/ltoEyRuF3iNi+2YF94BN6HjptRSeL/WmKX+BkGVvJJrjjypeqt' +
    'PwdrcPN/NaI2zcliOGUmhPEB7MYMX2Dj02Tpbx0PlX9DmKySkd49JeIJVGydvjzAWCcSEtwj' +
    'Af0XBG7Lj6pR2Xgk3VNbxdwJgjr1iQFkdjaGLIQJTMgKzh4mIZcXHbaE06XyujUUSuMgD2yI' +
    'jXlnWLjNvzbuOJ9D1/KTchrQEIzDXXlBg2CFqxu0SKAWB7PyUZa7+3XgCAi602AAk+khILNB' +
    'T4vwO/B6Vk7ysSzanEBp8EwFrrv1AM0FwsSIqjKsWCkuoAKt1NoUrtDU0YH5R2XdeDBNxO0y' +
    'RHpT3iQEl1gC0BuCSRkWLBmv1fzzLigO5ig+rKBCXfJSYbLZ/7JEmQdQaAnPN111jWbXL2B4' +
    'kLXa8bDcg6kYD7TjCvY/FK0GMzUUb2//bx6f8O3+gA/EeAAQA4VO0Ui7BW7wAAAABJRU5Erk' +
    'Jggg==';
var docsURI =
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAAGX' +
    'RFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS' +
    '54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3' +
    'prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9Ik' +
    'Fkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMC' +
    'AgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5Lz' +
    'AyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG' +
    '1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaH' +
    'R0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy' +
    '5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD' +
    '0iQWRvYmUgUGhvdG9zaG9wIENTNSBNYWNpbnRvc2giIHhtcE1NOkluc3RhbmNlSUQ9InhtcC' +
    '5paWQ6ODExMDRCNzNERUU2MTFERjk1QUNDNjkwRjdDRDZDOEEiIHhtcE1NOkRvY3VtZW50SU' +
    'Q9InhtcC5kaWQ6ODExMDRCNzRERUU2MTFERjk1QUNDNjkwRjdDRDZDOEEiPiA8eG1wTU06RG' +
    'VyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpDQjg4ODAxQ0RFRTUxMURGOT' +
    'VBQ0M2OTBGN0NENkM4QSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo4MTEwNEI3MkRFRT' +
    'YxMURGOTVBQ0M2OTBGN0NENkM4QSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPi' +
    'A8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PvnSmacAAAp9SURBVHja7FtdbBxXFf' +
    '7uzOx6/R87tmOTkoCaQBr+StVGKPxUCFEkUBWpSDyA8lLekFCf4CEICSm0D7wAfeapD4gKoY' +
    'qEkqhSKgWJHwUqKLRS6yRN0/zZju3a3tje3Zl7L+f+zdwZO9S72fVGJGNdze7M7Ow93/nOd8' +
    '65s2ZSStzLW4B7fLsPwH0A7vEt+qALGGO59+dmRenyKnt2oY6jaxw9sQAahVG3+9i+rnvHaz' +
    'QEjZCg31UBDo0ABwfpGLAYMXybS5xTskyvMdErsRoz/Tk3C3VuPQFGK+b8cp28SCcfndjoy6' +
    '0IfNQkYOxmnT07V8MPuL23kGZSbmy2Fc+pz96KgavrwN8WgSNTwDcmMVLnOAkRPxlGpXN3Yw' +
    'ioawMy/rsGXe21DSAIz2CO7BoHBPPAqATGAy9eBV5f1ocmWFg6ITn/1tf3FqjXZQACO6JaIi' +
    'NlPLeGc2u8BsEfyA933oHlAFGIqHu8OmdDhGOXCMIXT15sPE20ZncDAMyOkEaZJisS630uzF' +
    '5YwwSyIX2DNwFEeuxQk1hsAMux0QgCATwo/erslcaxx3d3lgnNMKCkWBtzyRQACU00sQwoDu' +
    'HtnaEpSDLPFneNYtQ6N0MxQe3fT0o/PXUp/tETH2ZBtxkQWsGsNGQGgDJSvZZ0lpXNFcIzmM' +
    'MDxQ8DnylOL2QGgA9CDdHxly/Wj321QyBEWwTAMaCsGCADM+FYGUR3WJqdx8L19xD2DaJ/9z' +
    '4ynGlgUiaIQph4DHGDW4Olnzbs7FhYViCAQHjulStSdAOAFITYepFb4y/8/a/494kX0KitUj' +
    '4OMfmJx7DvyNNIWMVohM8EeIZbBjh2cLrpOmf6m5xmwI9+CwKFw3O/v9Q+EJrRABUGoSt21F' +
    'xX5pfwxh9/jTiOURqaQDg0hmtvvobkP39CT9kwZINGYKP3XVZRtF/jVgjFxnCIg/LxP1A4HP' +
    'lo+8KhmRtpFqjqTgsgvVuYuYr6ahVR/w6gbxjoHwUGRrFy5TwGmQEqFUqxEYQkBUDqvTZeGW' +
    '0zwWaakBAIv5uuH/viFGtLjtyqCKZbgzRAs4AmE/YOgqo2SHIIi8pgpTIZFWB0bJziNssUWj' +
    'CxCRAWBEV4QUKxZo2tFfZqrCUZCPRdx89cjo+//NJvy3eaJJumkq79adI1ytu9H9qDqc98Hv' +
    'zWIuKVBawtzGL3yAAOHPoSrq5adXcgeAanIOg6QlFAEAOkpn0KgtgcDNdbLPPo2MEvP/WzV0' +
    '8QCB0WwdzWsOpllJxh99eOonfyI0iuncf4zhEy/gt4ozSJpaq53hmvWBB7IDhAjOIJAsM0Pb' +
    'eVYNhiIUfL6JmHv/IU+/OZUz9UEtIKAOyDOibqBnUBRGOIxujRs42/ICwNpPmdmWxQkqbDW6' +
    'gBqw3jfacXDZsyi51jIk2OFDzR3d+B4RBjlRA9IdN9Qh+FUR/dmw6hV43A7ulYf2T2Ad2iIp' +
    'Nf3rpx4cffPPxQtdPdoPES8/K5ojPFZ9W2vy69ufiPrbdjy4A45331Aa69GdON3pq7hcGVaw' +
    'hFjICOB0xSjLoBuxeIggAjvSXsHx/G5/bvwfhQ5ZmeyX0rdMlPCv1Xh0KAZdWb8OPaGs5FZq' +
    'hfNqc6IJR3zMKA8pJ6zSRHIyjj5sADhEsC6gj1cUFAaJbQXqqKSqpUoOtknJmZx+nzc/j+4w' +
    'cJjKFHbapGMyA0L4LcLm5wkwnq9r2iuXrvU95RPWWBPS9s3PvtowKC0TFyLo0AYRgioJiKaB' +
    '/qfTb0uXIJbGAI7/I+PH/uMm4sK/nUDg2Lmav9ISCyaq6Y2hJkXo4LAqhFUBjjjTczBihOSX' +
    'dcM8MuHbkhbVtlr3XhQ/GAy9UGTk/P6m7VazTF/1ijaU8W8EFICrndvW8ILwMIzwhluAaDWw' +
    'Z4Rlsw0uMwDFFfKG3hlLWTan0txOkLMwqAHlgfbDUMWgJA8gxmfpuWOBVA4Qoh+wlhvGwMFK' +
    'mhkM67yk7P6+6c79SUOdli23qt7hhQtyCwjjBAhYDqBmWhx08K7a9fBaYxr4TMUV571vOybR' +
    'mlZ7y010jraf1ZITKwcmlOzQq2Kd+6trWsAdKjf9rSIssILgScsb7iOw2Qjv5W6bPzMve6OI' +
    'reN/YL17AFm5Xw7QsBT8DTlR5kadAJonAT1OlLZnFt6S+92M+M55kApkBZykN6x2XB+xvWLj' +
    'ucBVhmuCwug8EXKJ55S/qq7zyf6YAPRE4U0/OF48XwltIvmllHCyHJsvU8wwJpV3IyevgTLi' +
    'o7vHSXF0JZ0InsPikzcFvvb18zZAntGS2ziXkez4GgQcrn+FycW01waS/LCh5DHGu2eUkst3' +
    'E1AWbzoGd4KkpO+OADUfB8Lu9n18g0BHgWLj5T2mx8SwDo6otCLPW+3Weq7Me8TL0phQeCU3' +
    '4/ri31s8KoqBFyK2m98wCoJsX0ZTK3hCsLoSBt6epyeD61CS80jNLnjRdp45Oxov3ebw0AV9' +
    'DQH3NaEIQ0Ij1JljTS81kNLzeJd7FR7Z1YiiIwnTG+NQCoVQWzpitbwgilxSsoz78L3jOA2q' +
    '794Cyinp6nISAL3V9O1LycnzPeA6arvw+4HQO0HIQlDL59FiP/fAkBjyk9MvCpA1g9/B3Myz' +
    'KCQuGShkUuLbpix733ad/5H3AFrWiAEiw152h5BjteP0mEIE0YnABohLMX8dmFf2CoEpnFDM' +
    '+bMjVOZOVv6nFuq0Y/5u9CAOAmTgoQLV1HkNSAyiDQOwTWP4JGZRiVlVns7aVuMDFgZcMZ7g' +
    'MhsnNSdDzm75wB5Cm9PMUb4MrwqEdrAiMtAIWEKodHRsc0K1JD08bHjJQRHkP8RZLt3FpIg7' +
    'r1AaPJ14cmUd3zCHa895pZ9CRWPDgxivFPHsL0pRW9gCm9nt7lctfgpCLpZYvt3lrIArYStA' +
    'XO3ENPIBh7APsas5gaG8GOjz+C38yEqK5XEQUs6/HTgsmWwQ4IyG33+h1mAe4tNpmq8MauT6' +
    'EafRpvRQw336mBJ6vaeOkVQFmBVGhy0N2f6rbAAF5YbCI5pBRYrUssq4cjTNLABjWXuUap+4' +
    'a33gvoVOYhYMthJs0DDMNmYR1eKI07ZLj7LaPcDgDUIyv15LfaUE9uWL4VxiZGA531ON12R2' +
    '+EpZVtY4AIHhyK8PZijPU4yc/EN1jmfgzXsW33cB8qpD3vJzLaFgD2BtXp+bXo4cemBinuk7' +
    'Qt7sb/HZRJbNSTon/dWMHHBsXMdIcAyFnGTj3/8/nD3zvOxc49o5Woa+Kl4n65znF9hbLO8s' +
    '03a6/84oWW7rOFx+PKSipsQWUfRmlQ0Y+dNIbt8XKXMFByS703VmmoH9rO05ijsURDPSavS5' +
    '2z2xMC6YMgO1TwxzA/nWNdAkDaOSTecI+P2h4C6WN/++ipZo1HF0FwDFi384k9ELacdpphQO' +
    'J9Ydkandh7dAuA2M5nze5jNPFgtBkGcHvzmo052Pc9XQYgsXNas6NeYEFbQ8B9mTN+zdI/7B' +
    'IA0ot9F5Y+AOgEAD713K8xgi4CIAqi7HSgIxrAvX3iGd6tf7wq/pMKRxO/DGkFAFlAvekHkR' +
    '0EoTjH9hVC/+/b/X+cvA/AfQDu7e2/AgwAYigTJC+FeFkAAAAASUVORK5CYII=';
var calendarURI =
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAAGX' +
    'RFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS' +
    '54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3' +
    'prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9Ik' +
    'Fkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMC' +
    'AgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5Lz' +
    'AyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG' +
    '1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaH' +
    'R0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy' +
    '5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD' +
    '0iQWRvYmUgUGhvdG9zaG9wIENTNSBNYWNpbnRvc2giIHhtcE1NOkluc3RhbmNlSUQ9InhtcC' +
    '5paWQ6Q0I4ODgwMTZERUU1MTFERjk1QUNDNjkwRjdDRDZDOEEiIHhtcE1NOkRvY3VtZW50SU' +
    'Q9InhtcC5kaWQ6Q0I4ODgwMTdERUU1MTFERjk1QUNDNjkwRjdDRDZDOEEiPiA8eG1wTU06RG' +
    'VyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpDQjg4ODAxNERFRTUxMURGOT' +
    'VBQ0M2OTBGN0NENkM4QSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpDQjg4ODAxNURFRT' +
    'UxMURGOTVBQ0M2OTBGN0NENkM4QSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPi' +
    'A8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PpjawNkAAAsNSURBVHja7FtbbBTXGf' +
    '7O7Jq1Db7gC40BLzY22I4JaWhwqoBCKKWQtlGrqClFTdOkah/aplJfKlWqoj4kKpX6VqnKU6' +
    'W0qpS+JA9UJSFtqRMIcRICKRCDL8Q22IBtlvi6N+/O3zO33TOzZy5rW0BENjns7JmZM+f//u' +
    '+/nTlmRIS7+aPgLv98DsDdDkDYOmCMuV4U+T39kn9V23tJ/9/2O3dIub68iyH7OeEa4xTZjs' +
    'nqs11nv0b7TbmxbOeHM4e+8LKX4JbvY7kDFwC48P/lX49KhggAQP5BtxgA/lH/kjnU8KP8wH' +
    'IAvEyARQ6pz8iF/yx82A+1f4RWlA8wb6Ldn3ETDwkAKJ4+wCG8YjRqCvIU9ep7yA4chjo1BK' +
    'V+C8L3HgCrai5k3iJTDpoZgdr/KtTYBSg1HVA2fRusMhrk1ghvaW2KZmPOWbgBENIBIJWBKR' +
    'IG5e1fnTyPhZO/s4GRvtGLyP6XgJLyoCK6/qLEDWR6DnExZo3xxz+EevMCwjtfACut9Rt4hT' +
    'lcRujLepmASJcQv5XZHJTNUZkCj/yn8LGZOLLXPiiMAD6Cy87R2Dt8vIT91EIcNHoiCLIlOW' +
    'UajXmZgF147ZzGAJ950vyE/ER80kNgKh6PoGPZu8tNjVu9BWaguNh/WKcPqYrfJKLtD0nPNG' +
    '7e7i4ceQltZ1hldZ0UmcbmTo9Bcr9Xmn6gxJQp5IwKiocT5CaQZXK15EPr6s7HEW3ZYju755' +
    'vPYrZ0Q0C1erGCUN2yE1seeMTWu2XbLrCadp/bCYLwIcEEmJcTZLYoQP7c7L0B7PrWi9ijDi' +
    'GZnEdpxRqcmanHzCT5CCqnrjO3Gp1Wce/Wn+Dg9se4L5jnMy5Hb3IdRsczQewnLNi/rw+QhU' +
    'HmrzzCWyPadxPqucVNTpIk+yuC/pITvRMqetFgjD9POUdO/k4k7KV9NyeYB4GI0dyENArKHj' +
    'gxT0KPTHiXtNiW3jrP5/sm5x0gkfM657i2CFAUA6xMEOrwMR52eBjKJF1p4KoJ8tAQuZkBuT' +
    'hEKnwmSWqQ0mqxX/FKg90AsOfKTbtB06NoicTQ2XyPXHzf8EXeYECifS8AyAG7UHz943JVjh' +
    'FqMeWwW8nIVtbzLCyOquoQWju2yp5ZnObdtF8UAA5TI+G5mp0QeTluFgQAwwTMsckU2H35kA' +
    'oOU8k4Jq+NYGbqBtL8uL4hirp7oohEyoML7zF+AUDuQcazIgwvLka7Z3KjQ73oOfYaRocvgv' +
    'E6wmi8pNDMkX933L8DO/d9F5HSMtdnzE7H8MHbR3Dxfz3m2gDh/q7d2Pm170h8Dknzk6JXhI' +
    'KBQJ7K7z7yV5x59ygXlf/HQobgWjGlgQDjuP/sexgZOIennnsBKywQzDHSyQROnXgDZ9/v1j' +
    'u1MTRxGSPEJq66L8BIPVMwIJRAzksGsgQPhRctiiasYmk+pDetT1FCuXMLqTRO/vs1G/Vj41' +
    'fxyksv4vyp47rgOoCK+a03pVD75OJTiiCBEiTRkQIhubjroUfytOeCNm/YgEd37kBTdEMOEE' +
    'MwBQPnTukatwZNpxJYSKcN4ZU8cMwCTmrCtNSKKqgPCHa+rrEdXdse1Kn/1IGDUMprkcwQwn' +
    'zu73S/jsNHjpqmYPgkTesN0Y36vdHGdbrw1qga7fUoZBiBDiB5OT9niKTlAMDm/v0dzFwaOP' +
    'D0L/TjoRkVmXg+EkfqN3EB/2VSmZn+QSjxWQQdbZsQjyewd/cOdJ/8EIOXLhkgMDLvc3PMi2' +
    'fCEhlQePnIVGH6odH7VM9x05bzESG6fq2+XmU953tP/xirVjCMzWQRf+u0cb2uT1UAwCs4UV' +
    'HaLyIKkM8ihv1cbHwUw/3ndE2nUylcHvgYczNTtrD45e1fQpqVSsCzlumNSEJM1WsyywkG1/' +
    '5yMYBIgoH34ENc+NPHj+YEVsxm/S4vL8fufV/HtQS5DmfdZ3gBgQFi1idLh6k48oYDc7sIVF' +
    'nOxhWhhXLHHZtaOM1VKCVwje3MjAAg1RrRb/FjUcmQTxgkl0LGDyjkM0AbCEb76Hw/jh1+1e' +
    'PNEnKMUQTggqXHbrXGYhlARV7Af+7fswuPdW3Ws+++gSFcGRvHR+f6crTWvifHRjF04TyaOz' +
    'pdJm/6AE5/xUDUm/qLTIUV+CSU9kFJngqSEDK1hYtUBOnKZqQrmtG87St4/MmD+M2vflbAhO' +
    'G+XqnwlGOQ0PQFKj/qw/becFlMgMRcoEB+9xxhKklmU3Xv/mmoHvd1ttt8wnQsJhU+b0IhW+' +
    'RYTuovohgqdnD7ROdSXLhwqU2rmXTGRmMx08sVUpZPcb7VIo95UXBT8HeCFDwCxMbHcPrEm5' +
    'ibvllgkp9OjmOwf8AUxdBoc3OjVHhDYEUAgcGWNlIA6i9rGKRgqWb3P//OBb2OMyePoWnzFt' +
    'SuWacLoVV/QxfP6xrXCh0wI6xtbN0oFR56+muAQCYbAtn9IhgQDhQGPRcxrUWMm7xmHzPCFv' +
    '99efACRi/128paXXhzaaasrBTRtjbMZOCyUmzUCsx0PTkTIB/hlzMK5DNBR0ksAXjWor3nCp' +
    'zRoQn/7DNPcOFLHOW2hL5MWM0iv7XH5Y4Cvm9v821zayue+MZ+lJeVuftCfrxp43r8/KffR4' +
    'ytLlz/F66vqa6wbX+pWV0ZwNnmwaRliQIEhxMkj1KY0PrgXuz56j5cuzyEi4Of2ByZBkxnZx' +
    'uSoVUY1Upl1fkSxC7Q3r07sPfhDnNxW1udrsXV+WB2T0UwIEA5HNCh8EumEqrewpFGND8Q1U' +
    'vbkMJ0cLJc4L5ZNfdayzZBSZF1Na75i7r8NfPkI3x+KX/58gByrov7Oxnt7IKaT4TkNHVZ4n' +
    'aNPOQKVMHrtuWMAmS6HwpFUFORkQWswImQewQhn7dIwYWvXRkqfE+4FCfYWqOgrpxDULYaVR' +
    'WrsLZS4ZR2eysr2UZjS6ScFkVyrS9S+Koyba5K7tmtdSVLZ8DNuIq2dbxymw/hjet1+GIb4e' +
    'FoGEVHjmIrysD5fb5/YjaLV07P6l0RPsUWDkD/EgDQ1RO7MfF+y32ru65MKfpGheffnA++Wk' +
    'xBzIEEJZPLOdkOUxLWAO3hTxP+0dYyTM5mlsEJnn354rvRX+PJrdWcBSouxVS5BqgYrZIDD3' +
    'J5seG3l8Bxrym8Rv1URkX3hamlA5A98ae3B6saBv+W/EHrtg2VWF+pBBdS9iKDZP0ue2PcNl' +
    'mLb4ck64OnryTx8ch1JM78uSfIZMXN0tb2OG1z4SretCXbCjS0dbG1m//IatpXynUc5JXUIs' +
    'rooGM5gCJtT+H08DD6Tz6PxOwY77quZeq8pXhLmE0lU/Cwb457ra+fMqnfUnbhOYRWNC16v+' +
    'ut+qQT/Rjo+QOSc3MAVHhWMHYGWFtkS0wGRHQGGH8nsEYr4FDb2I5wSTWnXoQ3BXfOH1xkuQ' +
    'A8v07P4uZYn5aZm5rWHMGEgwEpPwYA+c3FWt6qudMFHZzYlU90IIxmmQy7zcJb28a0ljbnar' +
    'WM2a/CYx+djP5Zh/BpU1Br311+Q7XPfvxbBEBGACBlfqcFEFSHOXgCIGp/wRzQ2iIWEq67Uw' +
    'BQHQxImPNNmU1kgerFAHJQasEUUhskLgySMVsIkr23twmAjDDnhDlfCwTRFAqcYdgDUWberA' +
    '00Lwxk0UwRWIDbAAJJGJAx55sQ2OD0BYF9gCiUIthWiRkh2B3AANFkVYeCFoTvrIMBnpkgOZ' +
    'Ai4dq0+R122P/tBICEOWcFjWeEaBDIBzgHdV6cEQQPCwy5E6KA6gAh4zAN1S0Uss//ePou/9' +
    'z1APxfgAEAbKBAmArJGeAAAAAASUVORK5CYII=';
var acid3URI =
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAAGX' +
    'RFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS' +
    '54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3' +
    'prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9Ik' +
    'Fkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMC' +
    'AgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5Lz' +
    'AyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG' +
    '1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaH' +
    'R0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy' +
    '5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD' +
    '0iQWRvYmUgUGhvdG9zaG9wIENTNSBNYWNpbnRvc2giIHhtcE1NOkluc3RhbmNlSUQ9InhtcC' +
    '5paWQ6MjVCMjQ2NENFMTQ0MTFERjk1QUNDNjkwRjdDRDZDOEEiIHhtcE1NOkRvY3VtZW50SU' +
    'Q9InhtcC5kaWQ6MjVCMjQ2NERFMTQ0MTFERjk1QUNDNjkwRjdDRDZDOEEiPiA8eG1wTU06RG' +
    'VyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyNUIyNDY0QUUxNDQxMURGOT' +
    'VBQ0M2OTBGN0NENkM4QSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDoyNUIyNDY0QkUxND' +
    'QxMURGOTVBQ0M2OTBGN0NENkM4QSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPi' +
    'A8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pi7+a/sAAArqSURBVHja7Ft3bJTZEZ' +
    '9drwtuuGBjisAUARYgioAD7FAEKIKjCAKihS64hOYgEInQcVISUSSKAAU4QpUQEvxB6CWIHg' +
    'iHqaYfYEyAA2MMxsYNe3df5je7b/N5vbvGoRiwH/r0ve+9eWV+M2/ezCw2KaWoKhdTNQDVAD' +
    'gAMJlMHgnUF46QyRtjDt68A6C+MtXwBIRXANRXei7cQfAIgPrKjYIRBLBqdusPNX4cOHCAZs' +
    '6cSQ8ePPA5aVZWFk2aNImuXLlSqj0jI4OSk5Pp7t27stjq1atp4sSJtGfPnsrEILTMOdBCV2' +
    '6lQ4cO6FBTp05VvkpmZqYaNGiQOnbsWKn2tLQ0GX/kyBG1YMECZTab1fDhw5Wfn5/avXu3qq' +
    'ziTQNKIXP58mW6fv06tWnThnbt2kVv3ryRdqvVSosWLaKkpCQaNmwY3b9/n2rUqEHR0dEUGR' +
    'kpk86fP5969uxJy5cvJ4vFImO6dOlC+/bto7Vr1wr9zZs3Pw8tMGhAUyNKrNKqRYsWijeqmA' +
    'm1efNmaV+4cKFIctmyZYqZUgMGDFAPHz4USUOqW7ZskfqSJUvUqFGjFB85xYzL2NevX6vatW' +
    'urOnXqqKdPn1amBjTVvBsBaKsJcnNzVc2aNVXbtm3VihUrVFhYmOrcubP0de3aVfXu3VsZaa' +
    'HqYHT//v1q5MiRMg6Fz76AwWfeRX/48GHVsmVLNW3atMoEoK0GwOJJP2D8cnJypL5p0yaqV6' +
    '8epaSkUHp6OtWqVYseP34sfWfOnJGj0rdvX7lF8DBwxJKWfpayvP39/Wnp0qUUGxtLY8eOJQ' +
    'aVDh48+N56/PJJJhXk5JdLFx4bQTVjIj32lQHAZrPR4sWLqVmzZnT+/HkKCAigZ8+eUf369Y' +
    'nVnmbPnk29evWi7t2704ULF+Tdv39/stvtVFRURFOmTKH169cTawm9evXKBQD6x40bR+vWra' +
    'Nz587JXN6LvbzLTJ7zyYfo9j9uUwD5e6UspCL61Q89qcuf+70bADBY06dPpyZNmgjzKHxmid' +
    'Vbrrtu3brRqVOnaO/evTR48GAaP348BQUFCdMJCQnyHD9+nA4dOiS0L168oEaNGgkgCc1a0E' +
    '/nfqI/zp5LA4cM8rihS5ezaf1mG9fMXpmqW7uQfvi+Nlmsfsy6xScAVv5ntpneKRbAwb3yMU' +
    '2vlWz8zy5PQXGhaEUpVbWE0M4defTb76J9y792FtnTgunokF10a9dtCqQAr7QFrANdv+9G3/' +
    'y1r9EZasevq15twEcpb/ko5HYlCknxqvXJ9HfqHzi+3KnqhOhj8P7lgwGQm/uCXmT+jc972f' +
    'NrswVTfNQfiMIyiIK8z3HfXkhmu+mTOgQVAgAGsri4uEw7+wWUl/eMoqP+QuHhHsDhC6XEOo' +
    'XvnWCf89dQ5k/uEVUIgIKfD1HYvwezLhukzBJTEf2ouMNiiuCjaPYwIzuDZLJ+eMnaim1i5P' +
    'x8GMwS7rcX2ysGQN7de2Q58a9Sp8wWV4coPpeo2Frm7JpK7pD9A8SQZl7QWlI+3bN8h/MWmh' +
    'BBsT/HUoDd+y0QZn5LNeLDKgaA5chxCprxO7fWNvT82p8ozM/N/siVHOQ8Cl4Y0+221z4Z+6' +
    'WwhOITrPTdhNflXIPFfIOE0zdLvqWOSxgMUj48BpNPDfEIgMnfE6JsepXd4aMY1xNnt4glYm' +
    'JDCD+i7EjEUZE1idbkb6S7uc9d1x88Rz9Gx8bfkOiY4ERq1j6Ifmwf5MEhMuvF+In6yDagxJ' +
    'Me5pDVwhYugFXAokrZAKtfE4qJaUwFuTcpr6CsNMwWPwoKjaLfh/Rz7N9cyjkoswsAZBa1+R' +
    '9hQUGBtMHpcmyxhDisdtI5Cgy0dt6Mjh0iUvKVGHQPhvKOnlAq6TdKJRqeaXNVvtWqeCNlnq' +
    'KiwnIDkFevslXHjh3Vjh075Js3pmbMmKEaNmyoRowYoTj2kHb2MBW74ap169bq7NmzrvFDhg' +
    'xRR48elfrVq1dVq1atVGpqqivKHDp0qMw1a9YsxbeVtK9Zs0axF6oSExMVh+0egyGPAMgG3R' +
    '77e0Rf7Dqr5s2bi/5ycCVt27dvVywttW3bNok2ET6/fftWotC5c+cqjhtU48aNhRkkXFDPyM' +
    'gQAGNiYmSuixcvylxz5sxRdevWVVu3bpV2RKUcsEl95cqVKikpSfXp06diAHzIMmHCBMkqRU' +
    'dHqw0bNkjbmDFjVPv27aXOMYWE2BwkyaY5+HLVnzx5IgAiOwUwBg4cqCZPnizgaQDatWsna6' +
    'BAc5KTkwUo5DFQNm7cqAIDA1V2dnYZAD6J54Es0KpVq+Rs69gD4XZoqCMxg0wSQmiEzzCMOL' +
    'P63KIdITcDIOd9586dkmc0OmT5+fkUHOxwssLZE8tla4yQHZknuQrDwoi1y5XVIjfT+tELo0' +
    '+FhYVkTDijrcRpbNEH4wZAtEbqmwJGDdEnUnAOp8oiBtFYEG5bndePNoTIS+g2MG80oJ8cAK' +
    '1ucKU1CJDonTt36OHDh5J3YANJfCSk78SJE8QGkCIiIgSUR48euQBwnV3nbYGCEBy5ibS0NL' +
    'px44bMhQfAoh3zsQ2iqKiod7sFPkZB6iwuLs5lBF++fCnnmtVfLPW9e/ekfd68eWIUmXE5uy' +
    'kpKapTp06KmXXNhbPP6q0uXbok39evX1fx8fGKAZObBmuBfvTo0TIX1oBhrDQjiAIDlp6eLp' +
    'vTBVcoGAQYxnLt2jV169YtV8qdNaVUf1FRkeQh8dYlKytL5sKcxgKQHjx44DUn+EkTIp/Rr0' +
    'PeEyI4VzAy2mAYfziBMUG7MZOjDRDaxLVl78zYj7FoAw2ME+wA6GAAYdDwrdvQDyOGOfHGPD' +
    'CWRuOHPsyHMe7HGO0uyfJ87m93L9GjKwxCLISrBUlOMC2RFxsjVlW5UkCDqwZXDtpBhwftoM' +
    'cmUQct6LS7qr9xZYFOAwFmsQbaMVbPBwAAeF5enuQVkWQFXUhIiFyjGnzQgg4gYQ2+72U9zK' +
    'd/CoRBbNq0aSnX2WNOEN8AABOjjg1iECbT9y0mhQS0pMWhMCMtbpZ2LWmtUejHZsE0mMV8Wi' +
    'swH+oaBIzDNx4wBlr0gTGjkLQGGet6PNbH3Hqf6Me1qDXA5xHAAPyoqfP8+IYaYgGgDiRRx6' +
    'awSUweHh7C0sliKQTzIv48xs8VvPj7Bwoj0BQHo/lO7QjluQpECbOz85necbwwBlqCKwuS1+' +
    'sjI41vjGVXWPYBQMEY9gCAISDQYy3Q6mOJN9b2dA2W0QAQg1EtIT0JNqcdC7TBy4KXFhISSM' +
    '8zI5gJE9Wr68j+PPkFtgEq6PgODHDkBKAwhUWOhRkTgkCgKNG8r+jo8v0IzYzZXHH3xTjOpw' +
    'ZAssjlA3UQQPWArGSKGFUUgIN+0EKiOTmhdD/Nn4FgV5Q19T+PHAzDJgEE1AECvnNyiYLYrm' +
    'W9dDD+8hVH95GKvu2nfPpl+iz/P8z7GvdZXINQLIulcq5B8+dwL39K5istFvhcSynsOfau2g' +
    'CcPn26agPQoEGDqg2A0b+uKqXKG8FqAKoBqAagGoBqAKoBqAagGoBqAFB69Oix4mtn2J1HIw' +
    'DId2VUAaFnOHktAwA6UhmhDV+x9MFbqlHQ7hpwHw8T7v8Kmd+v+TNqgPtfjeF/LOCHw18736' +
    'EnT57s8YUzftLJ8FV+/ul8CwDe/m5Qg5BIjj8tiSP3v7T6coq2a5D6WSPzvgDQIMQ5AWjjrH' +
    '+pBi/VCUAp41ceAO5AfOkakOepE7z/V4ABAGZ9rSgseGtNAAAAAElFTkSuQmCC';
var nytimesURI =
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAAGX' +
    'RFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS' +
    '54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3' +
    'prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9Ik' +
    'Fkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMC' +
    'AgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5Lz' +
    'AyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG' +
    '1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaH' +
    'R0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy' +
    '5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD' +
    '0iQWRvYmUgUGhvdG9zaG9wIENTNSBNYWNpbnRvc2giIHhtcE1NOkluc3RhbmNlSUQ9InhtcC' +
    '5paWQ6MjVCMjQ2NDRFMTQ0MTFERjk1QUNDNjkwRjdDRDZDOEEiIHhtcE1NOkRvY3VtZW50SU' +
    'Q9InhtcC5kaWQ6MjVCMjQ2NDVFMTQ0MTFERjk1QUNDNjkwRjdDRDZDOEEiPiA8eG1wTU06RG' +
    'VyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo5QTJCNkM5REUwODExMURGOT' +
    'VBQ0M2OTBGN0NENkM4QSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo5QTJCNkM5RUUwOD' +
    'ExMURGOTVBQ0M2OTBGN0NENkM4QSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPi' +
    'A8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PuCH9BsAAB6NSURBVHja5HtpjCTned' +
    '5TXdVV1fc1Pfe5u7MXd5fLXXNXFKmIkWXSsmkZYBAphmwDNmzkR4JASeAoP2IF+ZMECWA4Bv' +
    'QnkAwHoRJLMRSIkmmS0UFJlBjxEFfSHtp7Z3buo++zqqsrz/t116h3dmZoIf4jqHcL3dNdXf' +
    'W91/M+7/u9rfm+j1/kRwi/4I9feAUYwQtN0/Y8oeF1fTPk4952FS3PQ8QMQ06V0Kk1Hdj8ey' +
    'odw3a9iWsLa0hYYYwlbKxUmmi6LpK2hXbHQ4fnm3oIvATGkzbKbRcb5Sbidhi6rsPhuQiFMB' +
    'KzeVcfy+UGopaJDr8gUery2QrrmM+nkc9mMBi6svbBv2+sF1FvObxcCOdmR7X9hJfvaMEXdy' +
    'vg5W+85bc7LsIhuXgHlabLxXQphM6/u+jyHI9f1XwPMQqWzGUwPTOFaNREhH/XXQ/dbheWYV' +
    'B4nt/11T3saAyZSBhNx8NWtQaD9ze4UJ+HHg4jYoTQ7XRQoEJFYPB7XX4vpIdh6RqvrcHQe4' +
    '5r8NpyTcdxYFnWztprzRY6VHqIa6f9EOI56URM+1srYGrySd/hIjTDgmnZqJYrXIzGk7m4bg' +
    'e6aUOTtbXbCEcTaJRX8eQHP4AX/uI/IZ6IK8FF+3s9bl6/hlK5itHRUUxNT++83241Ua/X+T' +
    '2d97SoyOjAt7qo1+r0FAOWbe+stcM1evSMMBV39+5dbG9vI5PJYH5+fs97a7usLLIbDwfFYX' +
    '+zVMdIPotai5Yvl5FLJLC+uYVkKkUrGXBoepva90IGGtR2vU5rFqp0eQ9xAZZ9hBcv+PJX/h' +
    'pXrlzB4cOH8fjjj+PZZ59FtVrFjRs38JnPfAa/+ZsfxSOnTqPDkMhms0o4CZHPfe5zSuAPf/' +
    'jDOHr0qHrvlVdeQavVwsc+9jG8+eabePHFF3Hq1Ck8//zzGBsfh0gbi8Xg8loSYuVy2U+lUt' +
    'qeGNB/xGcOHaMW4xgayuLWrQUUbm9j+PAsLzis3Co7lMbaygYqtMjM5Biu/OgqPcVGSpTzHo' +
    'CzuLjAYxEnT55U57/wwgu4dOkSbFpVFJHP5/G9772BmzdvKYsG1v34xz+OH/zgBxinUF/60p' +
    'eUQOLyxWIRhUIB0/Qkua5cUzzr5Zdf5tpvoU0PvXjxonoW70qn00pGiZI9s8Dz//CfVbcL21' +
    'hd3cS7716BzwUcOjLDiy1ia6uIxfurePv7P6J7RvhFDQv3ljExOYGwoStLvNdDFihWrFQqal' +
    'Ei4L1799SiNzY2lPvKIsU1xY1XV1eVBY8cOYIzZ86ozxuNBprNJhL0yrm5OeVt4vriEfJQgE' +
    'pMEIHlHgsLC+p6EpZra2uivOp+HhBv0Z0j1Pj05CgFaiu0N4ywErheb2CYYdElQosFUqm4sk' +
    'I6m0SpWNgBxoMeIsCnP/1pcUUl9Pve9z4cOnRIecDW1pYSaGRkRF1fwvUTn/gEksmkOv/+/f' +
    'vK4p/61KcwOzurPEMEFMEEL/7+00/jLs+ZmphQSpBrhLSQAkI5Rwwk6xXgHPSCQRA88pHn/v' +
    'Dm7TuLmD96CJ12RyFznMJrRN5Kpa5u6joUPhlnCNSUJbJE/+vXrmNsbBxf+J9/gnwu/TPlYR' +
    'WftJgsTBYuHiJWlUXL38Fr8QZRyvDwsBJE3gvSnzqX52kii+RZOQSHxCsMYy8wFJS8tRsE4x' +
    'pc3Lj6Bo9r/JOLiuZx4pHjcOgZ0aiN5dUt5RXZdAp379xCq7bF80weJYyOfBR6H2R30+v9OI' +
    'Y8xKoSEiKEuL8oVZSCPphGIhGlCDkkZORZwkAsKq/lfN00keS54UoVGp89ySbMGKHhPPxEfK' +
    '/bxvcEwQ89/QSRNw+LVu+7x46mhZycf+x4X8AunnziFHytByEeU9ixE3MMk6riDCq/7ihD0N' +
    '9TqYxXhKOFEeY5OsmVfCaWk9AIFCexPUhu5BDBRRGBwrQBRYtX+lxjlYcfj/UUR6FFOT69qU' +
    'uQlNM19GTYbYwHFPD7v/88ErEoOt1uXwEYiGtfCTCInr4WWDgEh5hRJF8Qa4rlglSok7QUi2' +
    'VslmqIMdaT3QoaWgxNT1ffN6iIZMzcAb/9HhIaf9uHCpmlJWwwbE6dOweXNxKZhHB5Xnd/BY' +
    'TD1HLIQpDG5enB1OYPPPkYXG6EQkRiiZ24LpVKyk3jibQCUqdBmgsP4+5tlMMncLNlwuYNkp' +
    'koctPDCu3/rh6NagV//Zff4bXTGB0bw1qjg1ajTYJF4HTc/RVgmzoXqz+gSWV3rWd7v29yv6' +
    '8hY4BRySFWD14LqJmMTXG9rtdhTdAieWKKso8qJY9YRHpe3wyH+iHyd1jgmBYevXAB49NTsL' +
    'iGMdLo4ajFcBNq/KAHDGaBs8vrN9/1eRL/w+bCMnFLSd8lAfK6BKMw06B8KCmGQrn8TNxfBA' +
    '3c1NgDdVtMV50OixPDRAvk9MQAodb1NnVBPLFNTdHcfpj2le2re4ufMaBYEnTVBz+NZWYMt8' +
    '0M0qX38P6a/lCwigElJOV1iKHok4lKyiWdfoxvXXqICv9kdQ0lVlHZmKUUkGJhk2C1lqSvRm' +
    'yiarvFowEyD+D2TWzZMVx2OsgQdCw70mNotLJUbgaFPTYxBou3Nwlgf/XFz+POje+jUtewtV' +
    'nCufMX8Nu/exF/+cWv4aWXLyEeY7qlkA3ev0jNiCPms2klhEdl+zzEe0fP/yvikg5t/X/g+J' +
    'EpjNglnDlewN+85eP/XqpjNG1jOmUgmZ/Gb/3BP8H169d30qsA4GD98VAIxGyTyU9T/0Rbdz' +
    'ZqZHkhTKYszI2S6FDLXd1CZHiULhLFOFG3W62jxZVlE1GEacUSqzgBmygVZwm6d3ou9+MfvY' +
    's3vv1VVFs6blzbxPjYOtzmD/F/vvIqXny1AINm6uyBgQlWjg6v3/Z6eHRGfxYuDXH7u5/HyU' +
    'dO47n3t/Da67fw+RfLEDJ6ajYLj+cfP3Mev/dP/wWGyUvarFEEY3qMtbm/ArJ2HinTZSpKIk' +
    'xXmaMSfBUzTEWI4p3FDXzz+hImM0mGA/Nxq4hhWm6twrJWq6j6/eZGCUdHMtgic8xENvAPLp' +
    '5AjHcxwyY2N1uoOhZrgXE880yMdHsJyxsdBbUhKlpC69i0jWeeSsHphHD9dgtvXq4o4emQ9E' +
    'ITE91XMD43gvXLWTQoWMlL4+tvNJTwSXpuh9llkR42Q8XL925XfQzRUG6XXMKl5zAE91XA2n' +
    'YDdbKyyVAKtm+outykm0uJKhcTwaaE+vJuVaJqzEojHbFp+RElsKS8RydzCkjL9RaWilUCYF' +
    'dyHTOMgetLNRyeyeNf/tFpWJEW+DGe+uAYtgsruLvShEmwKpQ0vPztGs6ciOKP/nACIXsGf/' +
    'wnt3H1uoux4Rzv2UWidRcfOp2iRzrYXnRwlEXS2SM5LFH5W4UydN6/S8Amg4Gr29h0iGuORy' +
    'V0lBfsXw3S2pKrK6Uyc/c2Oozv0clJJJIJyqDh+kYRC1sVjKfj+NaNJRxmZSidHtclqJkGio' +
    '0Wnjt7CIfymYfycrPlKmh64iKFSLt46+2yIhqTMyn8x3+fwZtvb+Pa1Qq9gMBV77IU72K75u' +
    'MffWQEiXgI/+G/3MT0RATLFXKG0RCOnGYGMUM9fDh3ktccxzdfewsvffttZhdPgphp1se5IR' +
    'IlAWthyaoxcxAPsGyUmUOFmU1NzKi0JiVwh67m8fV4Nq6sPJ5O0N3DqDTb6lkKDpYLWC83sV' +
    'FqwCIWiKYl5SQjBFR6QLFcxxTL3aeeTOPOnS08fiFGXGgpJri85UK34/izP5vGpXfqjHmN4O' +
    'tjcdnBS6838cEnx/Cf/12EQBnFf/+qiSuXWnjiWAQpI45r9wvY0Fo4NksPbNVJzLsoOF1VBg' +
    'johRh6whYFBMX2AdPchwiFkcsPKwq8wHpc2JNkfJMIn5ydRKHawiaFXNqqosQQkM8jVMBjs8' +
    'O4sVxALm7j1noZV1YLqDZ7n5+ZHsMzj0zBjpB+hzuoNbvIjxi4fa+NPK2THTbw6kstHJmPYr' +
    'Vo4LtvuThxjIUR8cSI6ohGmFVaPsbHc0xhwD/+HR3/1WXGqfuISypl5rrXKWN2IouJVBRpcp' +
    'kNDapcl0wqtYIUW6IMsb5Ul/sqIMG0Z1B1cmLMTBC4DJWLBQPkxAwLoibDwjZjuL9dRT4ZQT' +
    'pOECxUaWkTo/SQiaEkWvQYKYyGYjZTYlfl9OmpQ3ThBGv7ClNgDu/S+h0C1/UrDobyhkre3/' +
    'lmBWfP2njqiQg+/0IRm/SMR6eTMNrEI0tnRVihZxVw+lAU3/zf21jsulhnaLnEnytXriNS30' +
    'ZU75GARqtXk4jHCjcRJcghpfX+CqBGG40qS15HlZ253NBP45jxc3ejjSUKPj+WIVh20C7UEK' +
    'GS7m6UFSESDlHngoRxvW9uDMOpHr116X5jQ2N47lfej6S1xLh18cQTMd6rq2L17u02q0sqYs' +
    'jHR5+L4gv/q0T3r+KDj8eYbWllIrvLe3n1Em7edvGtV9dx5SdbKMfHMTo7D6/wJl7/3vfw9J' +
    'ljqmOF1Wq/mtQUexVFCAESwra73jB2Fxw23T2dzuxqSiquiLlcHCN0c0lJM+lIr+ymtmcem4' +
    'XVpJt13F4bm8wv6tG8ir2RxXkaYpkl2Ln7pNEJ1VSp1Vj3a9K08HHytIX5EyYsWrS82MTq7Q' +
    'aeOB3BB34pylRHbFkr0qQbePuHwBe+zBBcaWG1XEIkn0AttIGTzA56p4nLd5fgeNihkyKsWL' +
    '3bNegFXVVVHgiCcrIQBmk4yGsBwaDdrKoAWk53GuhQKMkK0vJuUlidz37IozDEBIaCF+qSUP' +
    'FgfR6XXiER8sIF5vijRVJS1gehsLpit0vlaATZugOTYFsreShsevjVDyeRy9Dt6b4/uebgnX' +
    'caXGgCL323jaaWxNy5LM5lRjB/dJ7GiuPCdBxdp4k//4v/Rg9ZIM2GUr7EfSzas7xkgZZqvB' +
    'yQBuULtVpN8WdRwNTU1AP9dp1VXUsxO1qZ6Npu9VpSGtNNudsrkkQp3VBMFVDhvraldjIsA5' +
    'E4iQiV06GlNXHNkOCDB5spjwU9Xieh+SHDIZs2MDEVRoZp7itfrNHiHhxmljFS7lOnT8GkAh' +
    '85/ShOn3uMIJpHmN62LZss6degmw7SCWvHeLEU6xfpG1BwQ0piPbS/AuRL4vqqgKAE0qjc3N' +
    'zEzMyM4tPSgxMqGbSvxKXkvKAHkKa15XXgMQ7PS6fS6rVHxbEeUjW2KMEXmkKA1BskKBS+Um' +
    'NRlKBXRXwUKi4cxvqr399GaZEcNB6HZ8UxMzJEkE3jfo0Mb6uB8aaGnJnBG69/DVv3XsLZQ1' +
    's4np/BO1eJ9JmcygLrJGSblaai2sIHErZ5cBqUuBGXEQFFgwIeQcdVHvKZvBeUv0FTUhQhYC' +
    'ev5T3xoF4RIq3tUK874zBcWAn2Cjoqj/TSIdnZps5WSq5C7iPT9Die851vlXHjehNnxmMwcl' +
    'nkRmaQolD1juCPjbGRdcSjl7G6+A6GrK/j/AfWkOVlt5cKDIsSNv1ptb4wLd4hA8ySsjfIYK' +
    '/er+yvAHF/1QOgcNLMkD68bE4EbSQVS3wtnqAapOTucsj7IrhscIh3iOJ8v9c9lg5MmHWDT+' +
    'v7TdYWRs/yaHqo8++Nisf872GL8V+jN4T9NholFlWNMZi5MDzTU27TuH8fyy2eW6jjQxcN/P' +
    'ovr8Ifu0evakKbJl5VLTRW26gxvCbG24hbmgJkiyl8jMTNpDKSpO3JeHz/3eGg+SgCSQ9Omo' +
    '+ywSBhEGQJeS+kWkueElIxLH5HhA9QVzUq9d5ewfr6eq+jInyAFtekpqXw2xT8znoHCzzWCX' +
    'zb2x6KW3VECKRTE7+E0bFH0A4x1LjC2XwM8aE8MjTG8Xkbv/5rVEqGlWibUFt20F5voVVyVN' +
    '/RI+CWWMc0u/pO+m4zZZeZokWV4YMwQKwXNEHlddCmCp7FskKTxfpB0zLotYtS5FkUErwvtN' +
    'PXDKWIULdXZjNbYosEp1ajxcnmOo6vii5L6yARa2AoMwMt8wgiK+sshKLYoGIfY1QUeU69sI' +
    'HpkzXEyCprLILavK4pqZb1A5MQnLpsgfmqPpFtOAEB8V2Xr8OqeaPRcP7BaVDcWx5CGXO53E' +
    '5zM3Bp8QDBALWh2T9X/g52a0SBQRgphdDyHfKDNlPedoEM0XcRIwR2DB9NZg9bp8Ij9D6Li6' +
    'ZzbFdDuHH7Bm7d3CRznEFzhSmQyjk6OoISU+zcfBUFVpVFYobGawyRKEljtUFllhlSTa9Hg6' +
    'UxpTrD4uSiCKbtItfe6RygALG0uH/AAQZ3eQMGJZaVCw/iQvC5fDY0NLR3l1ZyPRcXNTXmY7' +
    '7X6fEkg/Cs0UINIn9XjxEL6rh++TLuLFbICn8FFaa19dIKzuSbOPQoqSwrzoU1DbMjtqo1eh' +
    '6n0cVd0AHgch3DSR3psZ6RhKipparWXndn72JPBYh1g12aYNtp8GGaYdiWqWiv2uun5R2nt8' +
    'dnhuUza+9tacgMgIemW0erbaPR7qJKQLNNprxqB1XGb8IO0XoaxjJiQoKrVKGyS5TIY/HWPY' +
    'wdWUGl6NIbSI3tLkjVIP3LaNhHlFK0ee79gqtK6HC3ATPhKqM06X01ajxNQiQdr2jY2F8BIk' +
    'iA6kF3d/BRrdZRLhUxlE0zfpuMRQJls8ECgyV0MoVkau9tMSmI2hS61mCt4LmqkSmDEetccK' +
    '3i4OS0iRskO4/MhqkcEiynN4Vy7fIVlfYKdwsYPxZnSMSIP734/tG9Jta36akSHmMRhkMI9z' +
    'ddLKw4KBarKHcaOO+HWKv0UnqSxhlNRx/aun8oBIL0tnvsRF4VuZibRO/7TlXFlVd0WBFGcb' +
    'cRwpDuY3lhAzfI2+OMVWFfh0fS2Ky2cWosjZkTv4Wh8Qv0AgMy+OG2fZRYD+RSzDoMgyMkQ5' +
    'MjYcZ2CP9mHmougQACh8I6dN35KZMKZpokysvkyAYxIMujSz6RiEpn2kBu3sexuuwkOZibnl' +
    'T5X9YpYztSoFUYJs6uDRZj90albCtL7hcQFGX81I2JoASUNlNMhOlpq9rESrmOSaJ4nKjcIM' +
    'pHaYW54RQiXIwoTFiXyffiEYsWOkU6fAqk+HRDCshaadTs0eRSE5icYnbk2iJ0ovcfJbD2Q5' +
    'V6AmFD7VAViRPC5duikFkD83zXCvf3KLTetYIQl/vLkEXH6wlcEe7S6VHwfRWgXIWCyzZVPB' +
    '7fE8wqzRaODCdUXm8wD8uNDebuersDN2LgyaOTe37vJ6tbRGFHAVe54fbyM9OX5OU6rzPFSn' +
    'O5WN/J3XFiTYsekKbyTFo9TivW3Y4arOqlM09hgEj61LEJzGQTu3AHqjco+w1NkiVRYC5m8z' +
    '6Jg2sBubiAz0NzPrxinSSm0GhjgbW5r5qO5P9099PTw2o/QN9vNIaLHbGJzNKaohDtsEdFpx' +
    'RTi8Z7CzL5/UenvAcYmixaWuxasFmKXjhI+83zg+0PeuAufj84AzTKajEXjyiPkAr2wGIo+J' +
    'KEgTDBwUpQYmk2E4d1fFSFg1DL6bSJBM+T3V5paQvh8Dvhh3oJcnPZX5DNEiMaQblSJjEhB6' +
    'BVI2FNtd4dp8XQCKsmp9QUht6bANND6DPOnnKi/SJMRu6MfoHWZuy0+x4s58raxXhSrcpust' +
    '7fslNzBIZxcAgM8oGHRlwoaJT1uwjkOzJFxoIpbsIVzuD1t672mAVQLiudYZIlWZhsdMgh96' +
    'iy/gh6dqI48b5gFyfwSnUeGWFQ4qrpjz7zDGh3ME8kD5k+UQqgcmT4qtufK7Asm8qx91dAwO' +
    'LkCAqenUpQ6LHM+tESOhfq81ljiuFJahghyBhyY1mgXCMom4P5ApkraDR6SkgxZSoqa1vK6o' +
    'H3xXhtKcpUOKqudGdHOcE15ZDhKJk5khGbfR9hG6lDBF96X4zr3KqRTI1n3rsWkBCQul7mdX' +
    'YUwMVtUYAtLjYtVJaalCEqs1Akn3eU28q54n7BkJJQaZn8UlMdHQ3LTOoTmTQiYjHqy4hElR' +
    'vHDUvFtaROYarRRJIKMBQKSGNWHyi+tD6nF4UELr/fBIo0ZwydFSLTdt3rDXZWmwdgQBAncj' +
    'Nxo0EMkJskGRpdx1HKEI12+oApg40ywBj0AWRxogjxIvEG8SSHoLnBVYRtD9l4j2i5TKEdr1' +
    'elSQqVdLdSa5O1STntKtRO73LZn+URtQwcHk1jpUqDuA01w6CHsb8CxGpBTO31kKquxnMkRY' +
    'qgQp2DCnAwhHrNVfuBeYG54bQ69gLdrqraNJXHR7NQo60h7aeNWq0/2uL7GPCCB2eR1CjOAH' +
    'tVAEo5YkYck3EdhVZFpZWcnd5fAQI2QdyKcKIQsZ4qa1WPXVevhScIKAUlryxSrC1WD0bSxA' +
    'skRgPFlMtV1ZSUnC7NcIl7ydEhI9wTWPYjhKhIs0xVkI6a840I3mi9fB8UMq6a/4VKaars3S' +
    'l6NHUtv6+AABRb9LIQ2aMp80lG+OCW2OCwYTCJJdYUxQSjLyJ8AG4y3ycCSp9Asoe8Jx4y6E' +
    'Xy3jde/Rt87bVvI0LwE6E319dUqpuaGFPPTfIDjfVwPj+KzY0NrK0u85ppfPKT/xxlPYrl7U' +
    'qvHU8vqpNQrZZZlpNxyvR6q+0iE7NwYjwLbVdxJ8ORYgxReM0jtnmFg7vCgcXEfUUgCQnxBL' +
    'FmnNYWq3uqu6rvDCSqeOuD0j6D6VihQG9dehdNWmxmeg73F+6q6W+9c4hKLeDqrWUFmtnhCS' +
    'wtLapBzemxcSWEaXaR09oqE7nlImL01CGdNLfdJC23aVlWgGSVy0vLKjTEALLeoLgTl/A9X2' +
    '32HrgxEiBsoAhx66BJokCr3VJjqeL2LOp4QVf5nmSAXp7uxWmSn8cGqLSEyHq1hLJbJRLLqO' +
    'w6rIiHCEGq6TsqNUbzNlyDoVLfQlNrkCGy1EaT57uYTA0hn7DhyahOn+gM828ZvTGYiiUL+X' +
    '2MEHYZZAwxiBim7fTCM0xvOXBjJPgwUIDEetAIlYfs+a9sl5HqSBT3crQugw2y6RiLqjzj9e' +
    'f6HLq02a+9FWkR7wj5yOdG1XydyYXFiPIbhQq9YwWHTp9EteEpS+VyI2gJwFoye8AagKEolg' +
    'ywpc3yW5RmWVLquortSfiK5YP0HWBA0KDZb4L9oZaYuHxQD8hN5WJBu7zUCeE7Gy6OqEJGuj' +
    'MOzs8NY63eRGW7N+0p2+GF2yUVJs+cmcM0iw/Kjb+Xn4A+dpxIHVJK8vl9i6VrsbCJox0TR+' +
    'qmGpqq061FkY0qS2VeK6YRKKlIlwpR4dfpqNH3eDym9i9lXfIcCCmvg1Ac3Nl6z5/MDLa1xI' +
    'KiaakMB0mGRZfNR20FNMcIOPKzFJ/xl2FBlI2a2Kg0kbLDODs7jBzPk5/T9GMAh9cqMG/XYK' +
    'RiCCcZHmYCtbvLcH/cEEeH/uOrJC6W6iFKjd9GGYlNxjPjthW21C9NIuonNKTjMuhihvfEnN' +
    '3vHTSmuy8VFgUENYHe3y6HSl1dFj+9Zkeh2mBd7qNWqKtCR1LTMONW5nZkQMJRbfBebJrSES' +
    'KodeTnLskYPKK3G+rClf1DtCTLU2BfNSx7e0byboPCu+qnN6/d3MR4zEAqpqmBjI1yHeMpA2' +
    'GLfCNsHDiILQAedLtUmjyoI3T48OE/Jep+0u7/LOWB3VQtmCQzaHlPlcXqHCojR+vLs7wnC/' +
    'z65buqbI1JJ4YLPDuRxcjFcwhFZZcno/K9jKt450rofqRO5cmsoLVDivyuhw4VZuezSOYz+L' +
    'VcFiTeau5A9vjGqETJ95Zx8I/eRHj5PcLgNt758+f/dD8FyPz82vJyLx3trghFEWOkktZQTI' +
    '2bSp9PfjYjTQubGBGzdfX7IqcjqScGK9wriwUuZaH2bzyLJI//n0f8IZf3950VDtJdsHEzgA' +
    'Vrg78YGVSAfPDD+fn5zy4sLPyBgKEg6KASpKGQMsm+TFv1tBNE87BL1Hfb6LZ19YsyCNPKZR' +
    '5a1MJWGaVmbwiz4XbUBoXk80K90QNg9Yu0kPIgmUbVQ7pKadI1EhITUcL7ivyosXktpJQvTZ' +
    'IqsUhCQZonMqw1m00qlhjsXAUtflr/syJjX9Y9PeCWHDMzM1+l6zwnSggUoDIDb1wl4odo+Q' +
    'xTZFgYvMwHmCQYdPkvf/bPUWJK8iemoCViap7g0ZPHMDQ1h7YZxXqJfNyLoEHmVm22VKu63H' +
    'RVr1/1eyj0YTI9j+lW2t/SGqvwNShUg5WjeN0IQVSEkUlWR7XlXNWpKjVcvqcjxcyB/rR6UM' +
    '7fvHlTfn3y1UC+QQ/Y/bM5YS9neTzbf45T208HGpT5GiFCkh2kzB1EWGlsfPzCRSzcvoNnf/' +
    'UpzE4P4xs/uIqia+Bf//G/xUd+4znUa9Xed3gtt09YBG+EaBkUXto/Fg+zWu91N9W2lyfMqn' +
    'dA+5lCRsgZ1/paX+BLPF7pP9cO+t1goIQneRyRBsvgLyx+zh61vruL1b87KPx7/XI03hdcFP' +
    'Bo//XP42OtH/O3doPfe/50dpcift49oLZf1/j/CTAAiUoqMXPzWK8AAAAASUVORK5CYII=';
var picasaURI =
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAAGX' +
    'RFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS' +
    '54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3' +
    'prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9Ik' +
    'Fkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMC' +
    'AgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5Lz' +
    'AyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG' +
    '1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaH' +
    'R0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy' +
    '5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD' +
    '0iQWRvYmUgUGhvdG9zaG9wIENTNSBNYWNpbnRvc2giIHhtcE1NOkluc3RhbmNlSUQ9InhtcC' +
    '5paWQ6RDE1MkQ1NTRFMTQ1MTFERjk1QUNDNjkwRjdDRDZDOEEiIHhtcE1NOkRvY3VtZW50SU' +
    'Q9InhtcC5kaWQ6RDE1MkQ1NTVFMTQ1MTFERjk1QUNDNjkwRjdDRDZDOEEiPiA8eG1wTU06RG' +
    'VyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpEMTUyRDU1MkUxNDUxMURGOT' +
    'VBQ0M2OTBGN0NENkM4QSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpEMTUyRDU1M0UxND' +
    'UxMURGOTVBQ0M2OTBGN0NENkM4QSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPi' +
    'A8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pn4gIuUAAA/sSURBVHja7FsLdBPXmb' +
    '53ZqTRw7KFX9jYBuxgaLJAy4ZHoEAKzaNJS9pCIAGa7qYn3WabNptuziZNTx7NY5tNmmxT0m' +
    'eyCcmyLGmSkjZPSFICmADlZQw2hhAexkY2si1ZsqyZ0cydu/fKd8xlkGVJNsme08w594x0Jc' +
    '3c/7v/4/v/fwQxxuBv+YCfAfAZAJ8B8BkAf/MAQAgvyLVtr6Ftjj8wN/i5ET/sGz5sAF5Y+T' +
    '6IiwYoaBsNVm6aZl1IoNdeJ8ujLoawfBQAtR5BmCACMF4CwE/u56afmwCoBsYhcm5RAPgoZJ' +
    'rHmjEOLNe0MAPApBfrm+rHPbf6gbsnDgwgAUTuIgjkFiYEo+9pHRYA0kghy4SnQzzidk8tEY' +
    'QbHRhPdwIwmQhcPLie9GNWQMZoQei+CMKDQUnaEYNw8+2quu1Nw0h4D/SY4Ps9OPSzUvz/yQ' +
    'TOUfFq38Xiid5mOidth2DGpS73y1AQSnNdGNn6iAbhljcU/QffQtoZMoXodPBnY/BIaoAwDP' +
    'tO7vac6is9q25Yv/Leq5/a+uh1Ly8jc545GBx/UlFujmLz4OBmn/4gCytwY3ydiEEleSvfea' +
    '3fS6dLfxKA5fcE4Oi72+CnoQHWF0W60z+++smJ1aMm3euUHEtNiCm8sbZw608feOufNpLP86' +
    '+BYMIqt/vOcVCcmotPQxgoPzf0RfcnEk17HqhYMEYwLmvuxI99+VfBIO8jsnGYw9EAa9ep33' +
    'A+/LXVSyYUTXrNQYTHSSQh+VDIq/SPfeSua564hZr1Oxjoi+PKunqkN+aiCfSSwYRJ3UO+Yq' +
    'JiUXbc/rkxzvV1d5bOJHMOthHpoksmmpax8AK7qeuJb669o7yg/FlBcNSc79Oga0LpJT94aO' +
    '5v/oECRWxAu0ZHb29SY01ZA0AuFwaYAlAQjpoy3XFJALMuKnK+/OGdZYuoaQwXBCEL4enOy7' +
    '9Yuu7Hhd7ifxf6Q1nKQ0KiWDm+5oZ7r376Wx6nTwghQ1mE4KaX1L6DJoRZ2UIcgDxy8vcopt' +
    'eaEwVQUVMsPbPtR2WL6YawteUEgpCF8K6ff/3FO/LlwnsyVZqaktor7rrysaVFvjKsA9z7bQ' +
    'TqnlFi+w0IzUw1QAWACu7rVbCXuquBhUPgryl2rNpwW8lXmCbkBIKQoc3LD331t9cXeUt/Ar' +
    'O6AQRj/TWz/uWKhxdX+ybRMBa+HYHtjyt9u4hgRkaOkJgROXnjCdNj/0wUsX9yheMX//OdUd' +
    'NB//fEkdYAekHnd+fcPaWsYOyDJPjK2ccZCCryqqb+67wHln++cg5dZOinCO++X+n7sBfjxN' +
    'B8ANM1yKqOXak+dwhCxewq7yO3zPaVcyDA4QIALeHLfRW+KWNm3C8JUkXusRYCT1HhhGV/f/' +
    'OXHaJMaW7XUyaovyOR2NyFsZKBGYomHpy15rnBnO/N897G/IHDouK5AnCO3f/znH9bnufKv2' +
    'q4hKM33nP8/cN/Wq8jrYu8pXE8uMYwDnxX0947BUA0nR+g60FmevUu90vfWX2jb4bNHwx5SG' +
    'lUX15Qe23l6MKa24abmHVE2o6u3vmfvz3a2dRC3lK17yOD7nziLYRQt6JozzqdCyeJYtHghC' +
    '29QA4B+OZM9P2IQH0z6PcvKEWGOaQGnLP7C2oXLSMqW51T2snGsc7mo099cO9LRPhuJnSEaU' +
    'A7GafpeadpfnxjIrFhH8YdwwHa5xbnP39T6cJstEAYzPFNHTOzdFRe6XXDINmgqW3X0ae3PP' +
    'hOMNYeYsLHGAAUjDMMhAA9N5nmyRtVdeN2hFoAR81hBrs4sHCIXdMq4Q0uB/Rm6guEQXbf/a' +
    'XaRfPdDs/EXGRHogkam7Yf+nXdI+9F1XCQCU1HlJ17OBACTBMCJ02zZZmmvfmBTqhzv87DbA' +
    'sjRV5p1l1X5k+2EaSMfYDAQomrrKB8rgAFZw6qjzcdeaPhpfrf1WFsBpmQ9BxiAMSYH6D30q' +
    '00l51RkESFb2ra+ldkOXqFwzHbB5LMkRDIzICQJVgyc5w8l7wkLByozB8MqkVSqtD3harZ5V' +
    '7Z//ms8ncBA2ToaGPTq7vXN7y4iwndwcYZDgCFCQvY4kwus6NDIfTXs1jT1q2GMICYEJkCkI' +
    'wI+cL0PBl6YxqOM7BRJhowkOlVlU4Y63V4xmeetRHh4wnttcY1OzccfmUfmerkhA8yde+1PD' +
    '+XxvKe2tICKrBHI+tYoaqvstjnJNTXzNgZeuDExdM84/57Z1+EI0Y4nQ84J+Ep91XVCoLozv' +
    'SGYSMU/8PO328hwu9lQp9mg77uYjs/sBtrV/zJ2nXE5uLMN3TZtQb1/1YVUOYA5DnEMmIGlz' +
    'BzltI5Q8kGBvWccrGzqDoze4egV+mK/e+epzfva9txmC3aEoBqQZgJb9kievGmd7BTwwALXq' +
    'y7MXD2xS0QLE3QGU+goYxugieZAOLB1fi8aCAAuarAUcuuYUUDNBQAomUCstNblsmNQrFAz+' +
    'q//nLTofb6ozabt4SPMbVP2vqqm97G+YYbHClvBHumusH0/VHygQdLII44+qCzRdPd09icmw' +
    'iFsvFJeS4whuMDwlA+gDcBp0OUCoYiOYHQseBzO5/cdDJ07EQK4XuY8NbOm0uWbMQNvTJoG9' +
    '8A6uasAetnjAWPv94B5qsaiLg8uODlLsT5Ap0NwIBIQAGa2QDgdsJCzgQG9QN2H5DUAgFIab' +
    'O+Y8HGtlVbH9pAhD9O1d7h8Fikxgp3vbzwK6/fiN1kn1Vy+92lTeROMYAlB7h7RRV4/6ujgD' +
    'hbBh3/UWkXXmODmoeRjRPsJ0VJ03EM5QPsACRBwCSopajPJeE7FNhzYtWWB9/tjHW0CYKj6/' +
    'K5D82cNvWWCubAepj9akwIc8XSDVhIeIBSdhi0LL0L6GMbgKj5gItkNzCOwf2+QrAduoDPNE' +
    'E7AYEDAnGc3gRZHiYe0HAxEwD496JhJvRUmfmeU1uP/GrrI+/HtCjZdW/PFV967KqK8pnLXa' +
    '5CnbP3hEU+li/bgGHCC2KVB0HHvOdIZm/094OYLkqE7Qnk1QOlReBDjxvkExDoPAMhFf4ZHw' +
    'kjWWsQh6LDQooKEFB1JcZ/SRdMvHffXw78vu7RD1RD6XK5ivsu/+JTXysuuvgrGOMEhKLGEY' +
    '4koVm+dCMW1DwQrzgAgvP+K5kbQPP8jJZ49+SP7is5C8JIHBHNjGVSIkvpHSNKuPusKiFzc/' +
    'Oru3/T9ESdic2QN69MWzj/4W+UllTNZ34FcyxyAG2q9nGy88G5zyd3HSLH4PSVXIJuMdWEHQ' +
    'QE3wiA0N6DurMtiAwwsjPRQBtld5qpam8cWLtp3e7ndtCwVuCvMRbOe3SZv6B6On8RA6lOez' +
    'kqXtFIdv7Z/i1ICo/TRhUnTjZWwH0EhO0e17CE1xHWP+40ApnUAyTbOqg26sHe0wG1r6/9va' +
    'N/3vbng2spwTEKi+bmLfjirUtkubjGbp7I0GRbzIVE+P4b48x7LyJbwH2ltJd6PFVlKKMjFM' +
    'fhbce0U5xJ4qEAsDwvdV5aY8fe40os9stdHXWUoorjx11VOeXvvrfCJXvLU10JoYR8XkFyCL' +
    'UfFASiBVqKVh2JzbRMkBEIgQhq39ea6LJFETwUAIiFrnh3LNhJBv2Rd+Kk66d84ZIV/+hwuo' +
    'uwmbLXBk1TPy/e5iK8dbj6+3eYN01MvLpmYJW8E/onknky5AsnFDcyzH2nEofJd+NcREKZAp' +
    'BgoayXeHbHzBk/vGx85cJbRdFZgM10pWskgdw7zSl9wsClGTlas19paA3qz0d0PErVCaM2gY' +
    'urFGNCfHSnCOOyA/RsPp6ot/ORTOoBJgeAUxAkV3nJ3Gup8ENWv5LyD5Cp5Hnbyt14OE1L7l' +
    'pJ06w/qZ0hgwpWQltlLEmSuLVrjIF2M1Zq8RI9HZGyA2AwEDSENLUjeGLrRdWTp2AMh+peJA' +
    'lU4fR8/7glY6dJeSLl7hibOGcAiMoLSDMlPaq7jYiRF48afiWO/FhFPlM3PeSeDmIHImu+IL' +
    'ICsmmCEN7aeQzFDb74khEAPP20Bm4+8uvNY0Y//nWXO78y7WJxkuFIRZd5J3sr3WvBSB4V7o' +
    'ztJtan/DX0lzNv2fKRtCYgnLeXZweORE8qJ069uzFZlU9772TuICM12cL+5J+7I+5Qikt9rd' +
    'tPv0C0I8yEjzOzQOnWlJII8aOh8cX93aGPmtOJxTTAbfShPPApHAISQGus443uNeEmpvYKE9' +
    '4YKpESUjhgPhNLkBCn1Dc8u0lLdPYM8iQNNXZqSl6kmJ8KAFqndrjtmcDbtnSaL7jiTAEA3E' +
    'UUFkqiwc7Gln0Nr2xWFdNI9XwD0wDZ1LD3kxbeiKPIiT+2/VH7SOtlQutcuR1l2xqzA9DLSl' +
    'uhEy2v7z90+PXtxOHiFAAk+wkYYfkTNf041FpfPf1mcEd3G6e1WdUQpEFMQGceNMo6LDTmup' +
    'qP/m6bN8+UJ9V+YyaNPVx4TJbUCVmSkpVSeMF9HkCGqX+05fgHXe+FDzN7V9iaE1wzJGsA7K' +
    'Qozqo8VrLj3FP/zBZNS2iTaq+/zOkUnefUE6y4fKHVPobUk6+11RHh97H1WdXnPs7zm5mAIA' +
    '3CRC1SpLAEx8HV18SDh17YFu2NBGddumyBKPmLoCAM6WxGiiMrQS10cl3rh917w4dYDdJqvV' +
    'lVaG0kNIBPjqyWNl/wSLS0vhbRjVMnpk7+9uV6QuhXO3jhAMCmibv3RD5ueaVtl9KhtoKz3e' +
    'UORnwiNuY3LAAA17rSwPmPu9M5b6B9b2cw2HhEEJLO3xAI/SUUGIzEfxDoYzW0KEMcK1ba1V' +
    'Db24H9wbrQEcb1O7nuURcnfNo+YLYAYBsI/HwSAGoWBtIkgDQKjFNt1ztjHbFTnhJPJQEi5+' +
    'xQQCS1M5ERb1NC3bvCxwPvnmk2E2YP2+lONoKc8DHO9kE2ppjJs8Ln9A2Z4F7WtrI6OA42V+' +
    'QsdlSXzCq+NL82b5K7Ui5zF7kKoDQIGLZ80dBMXetQo6HOcGe0vi8Q2dF7ilDbXubgwkxga1' +
    'gJT9xm9+lpe45/mOAbJ1b1xxLcihCUBdJaFm2rjaavXaXyaDIKvVWeQne57HP6nW7JLchQos' +
    '+6E7PWMdlmlNC6tb54QInG29SwGlQjibAeY4L1gbMPVITYCHOdJ8UW9obc+eH8YwRy1V+JOz' +
    'sYV6AaQNtRpSxnpw88FTAOYZXL7HV6nnrrVioOzj5OE2Wjhw1L3fu4rlFWEWg4/xixfmlxbN' +
    '40dJv98RzCC852aaUUACCOwqpM+DgTtJcbMS7RSXBUFwwn/Ob6jxFoK+ZKbJc9zBSsYfkKy2' +
    'zsjUps2/0EJ2ScG6qN5SGQI+8Y8T9NcWYhcj7BxQ2nTfhUGoBA6qaoddZTcPycdv1CAGD3D5' +
    'ZGSJzaS5z6Cym4hskJqHNJDS+0OVx1v5AA8GZxTnGU23UBnN+oxCkqUcj2fthCf1IApAPE3q' +
    'S0P6zwqf1x8v8EGAA33M3uCuOMmQAAAABJRU5ErkJggg==';
var ipadURI =
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAAGX' +
    'RFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS' +
    '54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3' +
    'prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9Ik' +
    'Fkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMC' +
    'AgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5Lz' +
    'AyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG' +
    '1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaH' +
    'R0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy' +
    '5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD' +
    '0iQWRvYmUgUGhvdG9zaG9wIENTNSBNYWNpbnRvc2giIHhtcE1NOkluc3RhbmNlSUQ9InhtcC' +
    '5paWQ6NDNENTU5MDBERjBFMTFERjk1QUNDNjkwRjdDRDZDOEEiIHhtcE1NOkRvY3VtZW50SU' +
    'Q9InhtcC5kaWQ6OUEyQjZDOTRFMDgxMTFERjk1QUNDNjkwRjdDRDZDOEEiPiA8eG1wTU06RG' +
    'VyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo0M0Q1NThGRURGMEUxMURGOT' +
    'VBQ0M2OTBGN0NENkM4QSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo0M0Q1NThGRkRGME' +
    'UxMURGOTVBQ0M2OTBGN0NENkM4QSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPi' +
    'A8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PnDOrc0AABa6SURBVHja7FvZj2TXXf' +
    '7uvtStvbqq1+merWc8nsx4V+IEcJxIUWIIIBDiIRAWgZQHP/CEwFL4B1DIQxDiASEiKwLJQk' +
    'YhSmTiOLYTrzNjjz2LZ8azdXd1dde+V926G9+57Z6MEyPclstCOCVdVVfVvfec8zu/37ece1' +
    'qKoggf55eMj/nrlwH4ZQA+5i91LydLkoRDhw7ljh07dtL3fVl83j328hLAG4Yh3g8Av1+QFn' +
    '1gn9xnnnnmp57nRVMJwBe+8IXE17/+9acqlcq9vV4v/o6NYTQaicbfs+M/HxxVVZFIJJBKpW' +
    'AYBmRZfte5u+ff/v7z37/XOeIexWIRTz311Lf41aPve1L3SIOfeeyxx57/9re/Hc+gGLgIgP' +
    'j7/U29aBHxoMXgRRBmZ2eRz+dhWRYURYkHIgYkztkdrPhblvhZlt71W1zDsnwrCCK4jz76aG' +
    '91dTU1lQwYDAbGuXPn0G63YZnssOiYrrNx0SExNuk9Ulikuuiogt1kEHEIgwCtZis+doKRxP' +
    'LyMuZm56DzniGv+9nssx359nfpnTalWwFTVCXOQtd1/alhwHA4jAJ2XMyGxyvDdAL5dAYB+h' +
    'iOIow90XbIzkcIpIidC5AwknASJlxvgH5vhAn7FwUhHCsBUzcx7xgQCbTVc/HcpTNIbjo4dv' +
    'ROzBVLccDCMIiRWn5n0EyTnUCwHZWDTiRsGLoCrz2KI7uX+t9zAOr1ehxl0ZmAfXHmkliYK2' +
    'Hi5XCzug05HLNDFnRTj1PdDzwYqonxZIJ2g7Mjc6QKj9BDaiaLmfwMZhiAPAOUH8l46c3X0O' +
    'i08PybL2Npdh4HVg6imJuBK/CFgVfYW5PnmpYOTZFg2RoyyRx8BrXRHLDJKC7LqQVgfX0d4/' +
    'FYTDKMvI7x8hCXo0sorWSw/74cNDvJWVdQ3Wqhuc3ZDjSEkgeLKZ47sJ9/S8wUF8NWD2vNJt' +
    'Y6dZRkC6sc0NmRj8GqwVZKnMYJ1kd1rLd7OFm8EycPryKbcZDL20jYKtN8jKFLDBqHqLssRy' +
    'uCbsjMrhC74Dy1DBCgF4USnIyExV/JIpfMMu4O3ADsUIBmfYxQs5GctTAMXPisZVlXYdsmbE' +
    'OPgWzil9BtsyRaHUSjHroct1MwY6wYRDsMYpkmFhdzyC2F0ItdZkoGg34P5foEYxfQmE0J9t' +
    '6wVAzHCoIwijOAZTq9APT7/RjxYzCLNEjhDLarMraqTciqDJvpnMmloM+a7KACJQapGKJF6T' +
    'L9ieC81iR4mqKWGZyMtgyZ2LA+Xkej20Q/6iOdT7CUGEivy6xbw2svX4EaOcyEk1jMp5CQQn' +
    'iugoFroQclxhCTDck8Jiy3qQVAiUchxsOGQhnl5hCTMTOCo/L42RtyJnxOD3yMCY2qJnHWNS' +
    'QIUprKPJE1GAyCpPhQElmYWhIeNvlbF/l5B8lF4odURr1ZgdczUb6ZwpsXXESOxvQfoFF/Bb' +
    'PBvWjJeeKJSrZQYiCMJh50YoT0DiNMLQCCswVFxYwwGKG2ViEwUcgoQlAo+Md7voR7SwTFUM' +
    'HX/v27eFluwdKE2IkwI6n455UvIW+l0Oi18dft54CDCaxkx1D9Po7LRXxl3wmcOv05XO2ewb' +
    'fKP0GB+uDkwSZCNcD99Xk4DRWaRbA7PIsGAViUCacFo2jI9ney03Gc6QXgrrvuihsQNEcUAq' +
    '6POWMKDKa7Y9iYu1vC6adfwF3HD8DeaAOTAUZpip4Ea7w4h/Rnvogf/ejHePizv4mVl56HPr' +
    'ON7StbuLZpIrtcQpEAl5j7BIGxg8aL34HaWkN+7GOYXcHv/8Gv45P7D0NWdDzx/Bm8QUo4uL' +
    'AfObuI9cYa1t/uYdAdx5piagGYm5uLGxAixdA0FJiapk++Z+RlgtCosYkDGVJWZwMRy2T26B' +
    'L2z3H08ggFnm87CXR6A9Kah0nfw5VTwOnTNiKWzb3ZNK62SzhxNMILzQSyGgXRSgGbvNbiLR' +
    '2bJZRgqukWGq02nn57Dd5xhYxwCZI/QTga3sKpqQVgV3YKIWMXyACfvxMRWSHwR0w/H08MKt' +
    'hHJO6WW/COZXDH4TRGnQ5g19FJrOOv/uMvUat5+OHjp+FnDdKcD/VQihgAfO/SK7j02jkEw+' +
    '+gTa3QnCtgtGWw5JhBSQXffPoMUj94nbiiozYZIZGLcIMZspwuklWIOGz/fUvyDxqA2wPRaX' +
    'Sx+fIlqLoGWdAbdfhbEx8GA7AwJ0HL1AiMm5A46xhbkLoJXBuuQZ+XsW8+QzA0UOjpSA14v4' +
    'aLiZNGK2ki5Zg4MFvAJxdmkExasdQWYKposZ6OKXKOIDtPkA39EEt2HjY/Xbh0lrTqYq9LfB' +
    '8oAEx6UplG8OJAVdZcIFQZsyDTQzZLmtTGGE0oT/smpIkMt0Nk5rtFLl9eLuLICuu23sT9cy' +
    'nkMhnWteBxXie0hC+jPwrgUf11iCGB2yfve3DHfarJBpXomJQrIUEvMh518f2mhOPFe5AZuD' +
    'HFfiQZELAE0iWqv9/6BEypQam7jma3gXpPQrPvIGOUkFHTWCmkkc4moQtkZvkm6fhyloPrNE' +
    'BqOo0NdvrNjSuQPBeLaQs2Ka3d7aHaoFJsj+GSTdIUUI5OIBz0Y6oNfRHQkL9VkSuRCg2y0f' +
    'g88vIi/DD6aDKACUlzU0Wt9RwGlLatNpUeZpBLULnNmFAtEwoHGhGpazRIo1oNaZZJgiXy/e' +
    'fP4a31CoLBIFaFps0yoMy1gxyyi0UcWlrAcnGE6HwZV8ptuGhCY2bkC3NMegvdRhPjqMGO++' +
    'g3ZOgZFSqDMZ4UoXyAFe49BUCoLAE0ItU8pn17UKAcTeP4UgoqqfCLzq/iaPEI/cIEf/vTf8' +
    'HrtStQWiFWD8ygdGQOzzxxGpfOXmc2EEwpkMDBhw5VHY1MJ571Hg4uJdkQnSUd5oP3s+b9DK' +
    '5fsXHxChVeIqTuoO/P2MJpYdDx0LpKI6Q2UeytY3966RcWZj7UAJTL5R2pSYqTZRuzmX2wCU' +
    'wturGhO0R1s4n05jrr10PzhQ36gAbuPrkPh1ZSOH/6Jm6U65g5WkIin4aTS0ImrRmWhA49g0' +
    'dkb1e28eLaBg6vLqE4P2AcHHbwJKJMncrvMo7MF1hySTS2NTRutmB2PWRsB4miha1rW5g3it' +
    'N3g67rMnVlutqQwmNA1+ZjQoROcNY79Rp+cnYNNr3+HJXa4fvvIMilUGbNDko29uUPQyONJZ' +
    'IJeNEEN2tVyH36/eEIw2qP2eRidomSenwDrz6ros/MyKz+FMePFNheAjla/Rliz2yB8vfYLB' +
    'IO/YapwSUQvvTU09je3p5uAMTg4xIgCvQDppqSQKiPMLq8hsVKD41CEkNdQj6VQWneQpAzcO' +
    'b6EGvlLsYEMTfyeIkORzMxFoKoS7VIAyTrEY7eRyNFZXvpVQWNsgWFXj+/ZGB+IQOVdLhIMB' +
    'WZN8AQMgMxZvpfPtvDuN2HTHktulPeLE/XDN2+COmzE2vnr5DDh1igDMaJA6jkh0gxpbeoys' +
    'Y1H1e/18VGz9tpxSINUKwEa12qwb7gOxgBNcMJA6ufdtCrW6hcc1A85OCOz84zkMwOkocUkh' +
    'LdCXTigkHwGWx1sHGhivZIQbVL0GvTB4TXkZ6Y6A+DnfWKaSvBgGibJf8fLpYQLjEti6Q6Bq' +
    'W2UceVMy2WwhBDUpKriWhRnbW7PCKKJgNZJ4nS4aPI5nzMLvpILB9FZ2DCS46wtEr9QFk88i' +
    'sQlsuSdLo8E/4giGffSGZR3HcYk+45jNaqvAexKM0ocdLDzTE8wTjTLIHd1Vih/S2m8sLRGV' +
    'TKTbx9pgxlQiFDYeRR8GikNSQNavgI+4n22bnjmN+3gFwhj6W5IsqtF7B+/XXUwlVcut5mOR' +
    'HwQlIfSyRF5Zez0rTQDgtNowdIo5dox+uAA9EHPcDSA6uYuXuFWOFTio/oKwa4ePEcabEXl+' +
    'nU1wNk0li3M8CLz1xmbfswIxmphIZUkUC3uETSlpCisMmk8pxJCy5npe83qA5fwI9eWMNWeY' +
    'KtXh5hcQOBxQ4zxeWxDEdKYcDS8npVRKMKMYLs0BsyuARaJoFKnTCTNak1KJoop6m/MUPJPK' +
    'HQkqWLsUadagBuZUCc2RGW55NYPLSMPEsgZRY4ky2UkpwZ0lrBKaHZqeD0+dMYNK/CSbcwcR' +
    'MY9JJoWh10tXXorg67loPbtqniVLTEKFku2sY21OGE7cix7JIJrEoxwRKgD7hzDvPzC6yPCP' +
    '2eizdOXcLVN65BJRYo9CNiyW5qARAPHkQAhAlJlVI48KkjlLEK+kz/4aRCLR/ATqwg4ucfv/' +
    'qfNDAe7HQb2/4QN/oGM6GFJcNDguDgeQvQKJsl4qFmBPQP1DYMgEtscdUc2/DofGmYZlPILj' +
    'twlnK002LFKIMqrXTn2jauXryOTrMH2zaoPj34PXfPjvADBUAAUhSwoz0LzWYV9e0aBu0BGU' +
    'DDWenvURtNoBjbyBZC1ActBKxViZphMsrgAsWK59IkifplxsjUuaGnspaleA1BS6pYOL6Ipa' +
    'IDS5XpNFWEqo0hwf3a1SZq21eRcsdIkQaHVJLzdxRiNmnLA3jv8SjuQ8eA+KmMkMXeGK2RWC' +
    'V2oasWJgUDG9U6jEkZvhPRLUjY2BT4kEbY1eB3Ijo+eoiAbk7iEfEMGpvUfBdGSsJwewZzJd' +
    'Lgkgmd6T+sVtGbybIlB53NITavbcJmJs2THnKGhRYFUYZl2KQi1DXaYNKl6NkuU00lAHr8GG' +
    'ynkTFn/NIPTsEg4ptLJYzaLfijJroUInqPBiWdwny+ADEtXXNIeTyA0uwwa0K6Z86qzB+o28' +
    'eVJA4dziK5X0HIgfcv9NGfy0Bamke33ENAIzVkW7YyQM5kwALa5aqLMSfDTtnQmfLbdd7bJc' +
    '1KmG4AbmUA33uNGno1mZ5mEd6Lp2EzlX3WohQR9Sc6ZbIHwx7BdMQSd5ruMQ1pNo9Zyt4xfx' +
    's2RijOyjh6Vw7Naz6u1+swj9MdfuoQ3PoIzR9cYIaQBgmw8rCKWUJifqzS9clotGiAlBEzYU' +
    'y/QAXp0ASZVdrkwfQzIH6czairSQ4oa2BS7zAyGsayiXDMg/5dmUkgRSlrSQHRfBSvHCsyEd' +
    'qxISeTsBci3JUnLtBB3rzWo47pwnmgyOkz0T17g/e8ycxJsIwmGLx+E3nO+hIzambWRIPyup' +
    '8jGwUeVGZAmlghk4qrwgpHP6PqqQQgk8nEQBgvOkQBx91kQQYEOdKYkKV+DdKI6c2jMZPG0O' +
    'TsRGSNHtPbk2FpY9Z4Akl6+GCgojJmSRQpifU82m2N10ZwfGIAhZO0yhJ5623YE5VaX0e7mO' +
    'bgqRPY4xa1QSVIoEDtEA2aqA5lqCHiJ0PiMfvUAiCWxOMIi/FT4iqZJCksCb8/xvzBY5jQvW' +
    '1sXqRLy8KmgRmGHga6WPCQMWEmpM0AGuv00ilS12E6QvqGqCOjc7WFXNJEIlfCW90qjVCSgU' +
    'hBWVZQtz103VBYIKAZwon66A014kHETGlgU+AJwTDLjBAEoGna9M1QvCooGZD9IjKJRTTUKp' +
    'xEFu1AgRrMwTdk0hZRmajkdZnGjky/YMKyQ9IdS+GgiU0qNqsZYSVIY0zssFs0UOtE+hYDsN' +
    'WMF0u6joquePqjW6BuxHC4xR4rmDN06oQO6m6T7yqSVKaqYsCPpOmWwLuCwUZ13aUOeIGMYO' +
    'KNyiUglaPwzSHoUZP7VHRygCQ9+z7W6bAW4rJD0yNMUtNFKqnBoDu86lZ5L43XjJDcqCBDDB' +
    'lnbAxyAk9YQpxRZTKC22/EdJkYSNBn5tES2FIeIs9zvXQawTliUTSZLgjeWnAUGxdId91eBx' +
    'pNi+GQ58diCwszQxU6yYbiBTQ/Lub2a+i5BsqWjFGZAuZiDUVdpg8gl1PRRfuznLUIvUKAIQ' +
    'EywTILxMKARtxgWnujGuT2CDIxJEGlXBVA12UwaJyWD5bgKzZuNgOkvZ2Hth9JBogwGMyAHF' +
    'F6uNVmbSpQHIO4SIVX4EwStGbmmOqUuFfqHDixIbzSwLxpQSZzDDnbowubUHQNKiMWzDlIzt' +
    'Jac/LGHHScQfU+HNmCydm3qA9C3r9jk10sFQ4RrzsErrd4LrUHxmLTRRg7xo+mBJjGYsDKvg' +
    'OwOMuTSZ8qj1qcftx2fGQKE2y7PlrbBKjtAYxymy6OZcCscCs1+MwA6UAexmwBAV3jSBBInz' +
    '6+2YXeJnb0fOxjeZUWisQMGTcJeD2Wj0U80L0BKm934wewqjtEkm36oUD+xM5eoWkGYHdvn5' +
    'CcE9avG7ZZ37NojyT0u13I9gQjqYUrm5yRwGYWy8jkaXhoYho0KpMhZ4s0iCLTPplBNOQMbr' +
    'dIZT6Czgg6Y6DYNnJp4BPUDtX6FuqzVHtpB/a4yw6oqHb7oDmGZtJ+8zDazMIKLxwbZCR9ug' +
    'EQ20/EJimxLi6P6dY2Ruj4ZTSqWxQ/Kj7zwJdQ0A4JW4eXr30fndpGXBatJGerNINHHvpjqs' +
    'IM+q0a/uvp70Cs3WSys/DoGg/esYqv3PurpDEZ62eexZOvPIfBwVlYKaq/4QAPHf1dHCsWMK' +
    'KKfO7mazi7dYrYwlIQ7E8r6fQIkEZip3/TCkClUokXHcWCiNcdo3uhgzbrbmZRRW0i4Wjxz/' +
    'HQobsRrV/FuctvUd6eA/IzBDQLSl/Dn534Go7MlXB+YwvPvvI8bUIfQ1EOFDZfpgt87J7DDK' +
    '6B81oX/9Z4DZkZDRppD2oef/TA5/GQehMjOcfv57H1agUFnWoxCNEj/bWr67BCc7p7hG7cuB' +
    'EvOsZrApSxcq4AK6cj8GwcpN6/WO6gYN7Atp5CaC3g0JH7WKc0RiNa3zCHijvAIb2PJlP48M' +
    'oJ6HKb/B0xpZcxq19lA98lle6HVH8G9x36DBnGiBnHpb6ojao49co3YVr74C78IQ6kj6NHZR' +
    'kpISyXIJlosR013sM4tQA0Go2dTVLsVUGREFjU4CMTf3Lit7HszOBl6vSXhMXVJvjy8n1Y8F' +
    'bZQS3eP6RqZAUO/B8u1NAdDPGny5/mebJYX2MATMz5T6Pm0QC5pE1a4Ac9BiCSY8oR2BP2V9' +
    'G+928gTSKk1ix80b8Pp4KrOINrpGSP7GASS7zpLooOBoNbNearBKHECn7v5G/gRPEgVViAXw' +
    'Md2bAFGjXkCwQvxcHOjiop3kAZbL+Fe8RGCrJBOmHET5nFSu7E6+AGg1Vdo7Hhd4PoCNLZFK' +
    '8Kb9HuZOM6KhRFQvaaQY90msTnpHuwXzmIJy8/iUBsEJ32Jqndzc0Sy3JI8ZE9P8G58rM4E/' +
    'zwFzY1C7aIsOPQxHbZcGe72M67+I3fIbqlsXcebfPGMccwmNHuxuJbD2R3Q4H4nN2Nxxr7kx' +
    'zSVPVZZrftIZ66GxQ7cSpXr2M9vILb+vY/PU5+12DetdMg2v157w/3RT9s0mY2nWGZiT0GwX' +
    'T3CInNzGJNYGd2xTKASs/+wbSUuIdpmvFOcYEtu+C6l+tFX8TW+3AHKGKsEAHZ00r3Xk6uVq' +
    'txhD+M/zTbHYAIgLCwe72nCNZuX3b/AUMcU82Ab3zjG1KpVIofPuxVcb3Xq9lsoksFude1fP' +
    'ES2SOuE/sBdrHnnQDIUwvAtWvXyo888siAmZDYbfjDyIS93kdkzO4S/e3AWygUxB6G+p4yaS' +
    '+px4b0EydO/MXdd9/9O4y++r9A39RetwfstifWYizek08++XdUg/86lQw4fvy49+CDD/7T44' +
    '8//oQsyxL+D71E+pOl/K9+9avbUysBppjM1O+xsc5eFx8/ipcQamSq6WHAww8/HJ45c8YT9b' +
    'fXpaePqjSY/sHUMOD/4+uX/zr7cQ/AfwswAOt56bdhiZTkAAAAAElFTkSuQmCC';
var computerURI =
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAAGX' +
    'RFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS' +
    '54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3' +
    'prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9Ik' +
    'Fkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMC' +
    'AgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5Lz' +
    'AyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG' +
    '1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaH' +
    'R0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy' +
    '5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD' +
    '0iQWRvYmUgUGhvdG9zaG9wIENTNSBNYWNpbnRvc2giIHhtcE1NOkluc3RhbmNlSUQ9InhtcC' +
    '5paWQ6OUEyQjZDOUJFMDgxMTFERjk1QUNDNjkwRjdDRDZDOEEiIHhtcE1NOkRvY3VtZW50SU' +
    'Q9InhtcC5kaWQ6OUEyQjZDOUNFMDgxMTFERjk1QUNDNjkwRjdDRDZDOEEiPiA8eG1wTU06RG' +
    'VyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo5QTJCNkM5OUUwODExMURGOT' +
    'VBQ0M2OTBGN0NENkM4QSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo5QTJCNkM5QUUwOD' +
    'ExMURGOTVBQ0M2OTBGN0NENkM4QSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPi' +
    'A8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PnnpZXkAABTzSURBVHja7FtbjCXVdV' +
    '31rvvs2+/uecDAzJBhACEDEhAslMRRFMdGDpHlfFjyBwIJ/iLk8GEp+XB+/OPPJCQSH8Ry4C' +
    'NKpEREjhQwzlgMmId5TnDDDMyLfsxMv+6z3ln73Kr2mfLtnu7xTyS4rTN1q+6pU2evvffa65' +
    'x7x8iyDJ/nl4nP+esLAL4A4AsAvgDgCwA+zy+7fKHX6/1GJ8dxcPLkyW+eOHHiUeqG8TRNIU' +
    '00BP/kHzNJElf6GoYhLdP1hbxnf5NHQz4vriVpAkO9HzqD19zilqKPfs5nOHJNjWEMr8o8ij' +
    'H5snhuzM7Ovv7YY489NTMzc2aUzjFNze/KCK2tra1d1QQQGv+dWq2W5RP5f9cE8OJI49T7Rx' +
    '555N3BYFAt2yNNt/c3ImB1dfWq82q1io8//vgPu90uZufmcf/vfpng8y8zlBOMdPjeshwYtq' +
    'WOKafguj5s0+a5DZdH3/dUvtnqMwue5yNLUvTDiIOYoB95H0NJ5s+WFUexMc5gGQ7dzT68J4' +
    'oDJPxLs5R9PBjOgP1TeL6LxaVFPPvMMzh37tytBGCe7XQ5Clqt1vYpICGlv+TmMAxVaPb7fa' +
    'yutWHTSCQMxVQmZsLl5FyOZDgmwriHM6cvMHIiNKtNGltVnx8+uB833DgLI4ngpDaqdhUJDY' +
    'sGPQRRShuZJjTKMPh8i+/tdAgCDbYyixPhecT+BCxMIyRGzP6cG9psIR548F4cPnIz/vYfnl' +
    'bzjqIoY3Pz9Ns9B1iWdXUH2xYAPAWGeJsGmyY9IW42ZNKctkFvsHmccKVew7FbDuGN1z5AO2' +
    'pjrGHDcywsnVvEgfkJNOsuHOagzXCwPRtxKsiFJJFUeXuY33xnGYSDIWo7qNieAiLmn6EMyq' +
    'CwYT+D87XgYHl5ReZJgIfepudtGu7KeFfl/LUAGPUqADA4UBILEDEJKRVWYhQkiCyTYRnxuh' +
    'BjimrFx+FD8ziz8BngDeC4YkCA9ZXLaNXmkam+DkzlWAZzHA49zGYKABL6NEQ+8zymjjw05P' +
    'NiHhOCJc/PEhUFEgcpgTj90WmSQIbeZlelJr1vBEHgjIrqHQEYxZoFALbpsPFtFqtcTGPJWz' +
    'YjUjlId26F8aHD80iDEN2NkB6P4Ts2AVhGdmACjs9x7IQAMBIY7o6ZDmmexlvkCxkl5hjCFT' +
    '6jzYjkUwMxjbeyiFwSc56JepYAFUYR7r73bhy99Sie/9FzaiyJBkaBLxGwJwDKneW84ADbcu' +
    'HbtaHXkwE9QMNlupnJCREUtigNEAYmqq6Lm27ah7MfXoBHT/u2wRweEJB1jI/PgZENyTaP1x' +
    'OSZyahyrCXkGf2QmCwySkOw91zfPTbbRpO/qCXxeuGlRI4C7aUXQKfEOzNzTY/NxVJh+QKls' +
    '2KpPCedED5Bp0DHNtnPhIAhqpvVJGaEaMgFv5GmA0IQMDoNVSKhL0+Ws0xTE7UkQ4SVMkDUg' +
    'baLEMWo6NKbWExohIrhskUkVyWKmIQkDiVowBukFdIrH3mtskxKi7BEaawOVQmPMxIjBkpMc' +
    '688x4+Ztu8dEnxWBSFzJi4IhpmTwCMejGXFDP6ThVVq0UjmYc0xmAIm/RQyhxOyMwBuoRioK' +
    'ZnpfQEWb5Vr2Czs0FDLFUO0WHZG6SotaoE0kLiRPAFGcdVAEl5Mxg9rm8TfJoZ80pvQPKsMs' +
    'oMROQHUjv6QYDeoE9qCAk4AWKjkmLFgSJpSQEC4AkB7rTpY++okvLzAgDbkghocOIxDUwUYX' +
    'mGy1BlGMd9eqeJIO0wnOkV3udT2Hk+vZH14SUWGm4FLrnDHYDjVJQETGl4zFSyXEcqOz3twP' +
    'Fc1SQF+u0OapWKqj4hSdch6AlLZyqNqSJplySRqiAOAa6z7JrGkJSZAr7Mf08cMCIFTJLJEA' +
    'BO1mRIORnFDfPeoDE2S+OYU0e9Nic0hSDuopNsEASSn+S1z2aHaBg+WtUaWjSwyYxqOQ2mgI' +
    'EK5xYyXC3mvsHxbQqmjJ53CUBE0kuYSn6jRa1AXmDqDdJhyonh/ajP84A8QbDNCiZqUwSU3M' +
    'JoyyOgIunwW1UBnpuMABUWrleBU/PJ9gy5yIBLlSelaUAPt5wa5iuzvGZgM1jH5f4SvZYo9Z' +
    'eZXYyhisnmBCo0umXX0bLqqgr4DYvsHikPuwQoI/MnojEYVWtrXdQrNQS9QJU/S3SCKoUJum' +
    'EPjqSHOQUn6WGqPo05ltiU1cUyhAMixV17FkJyY+l8KwIafgvjjSl6hrWW/SyWJysiYXEim+' +
    'kmGpmPQ/489tUnsd5rYbm7rMI0jMgBqYsJexKtiRrqVYZqpapIsMK0SkhwNsE0PVaAQazqer' +
    'vXRo0pEw0CKtAOc9tCl8Bf2VjFcvuKqvdcXiGcTHFwncabc5i1p8lDJGLGyIBAcR1TEfUq0X' +
    'DdKcAcsoIwUBfrPv2Y1hneDCuf+ecT7YSljON7DMM+iWilc4menMFN9YOYdcfx2fpF9MIrMA' +
    'LmaLeG6X0HyAssYT7XCpLrrCypFAgaL0JI6nxA0vMNj8Tp4AqjYMxuUVV2cGX5HDbWLmOw3o' +
    'XTT9CzPBxqN3C8ejPqdhODMMC5zgUFYMwyyBTwJQX2pATLEUD0zGAwBGCe6m7fDfPorKySnZ' +
    'mfrAaZkw3rNUWRH1OihBmW1y/D8GJMe00c9g4iyLgKi9YRXOjAmOfCaKYiAgAGZbEpRwlRx1' +
    'QKLlV1ncLJrKH92Sqma/vR6XbwyZlP0L3EyCOB2omNmjmBu2hsyzwIh+Xxs81lrLh9tkgJDB' +
    'FqWxJ+L1VA7ywqiky6lQIbrOcBVVxtdgx2l95iOZO8TJkCkscJa3IUJUq2XmhfxpVsGdPM9Q' +
    'PePPN/Gv2kg97KJupfasFukf1ropAsJaHtqktSpRJsU/3ZLoIrfYzddACX31nG6bdPI2T5bC' +
    'ZNTMUtDGypQhbWJpkWfQOdCxfxWdbBuhdhw2pzHllRvp09b4johFEAQCQVAKfeXUB/9WW0GL' +
    '776mMYp3HjRgVN1u26V1eRkFDzh2TnQJa6TIkLlz5GcPYKbrn5COYO7YcMn5FTM6aaQYkoeZ' +
    'xkUv6g0slmvbdalMgsZ2deWsDCq+8jYZUQDmgyKqqOh1WS7mJvHa92FpCea2G108Wav4lBkw' +
    'xAAKIo2NIvEv7ahsnedEB+o1nogPX2ChZOv0ONz9yPWAr5V2MbIwhTDPcbxmdxcGoGE806fI' +
    'KSmVWsXNjE6cEaFpZfx43NNeyfmEV4oYojszdzYBY0jyVtg+JnIoYzVWU4+9h47RLe/q9f4M' +
    'z5BcpokbuxAqHTH2B9o4d3189iYf08zmdvY73P3KdEJtqo9j34ohmGKwtJAVs4rbzC3ZMSlK' +
    '0syko1wiBcZqhzHUBCiwcUGKHahyHrUvlxKP+ihwYhmfCbmGu1MD3ZQLBC/U8NUK97eIP3/4' +
    'qa/tOlNQRvGbh57iCaN5IMO1RwjRrTI8EHr7yB1392AquDZQqjAfrrbaxvXsFlCqKL62tYia' +
    '5g02JlMEM89JUH8Ny/n1D7Qg4FmWFYw23O3OOsAHZeDncPAEP+qggQAOI4sYYbc5vEmjzAlV' +
    'rI0I1lBSiSN6OI4VAdrstXCcU5EhWWEtSXycDUAgG77bs0Q2j2kdyaOHv2Mn65sICv3/4V3B' +
    'vdjm7QwcL//AIvn/op3l96kyWszfjtqvLXo+KTkhYZDnpSIciCtu9ifnoe1thhPvfnsiXJyK' +
    'WSNKD2EIqQJ3c5Yo9u056FkGwqsKl+hiPanQ+RHRsuYmBHamcoSyToZGksmxu2GtYmSXVNR8' +
    'GWUr191P2EhGjjUGsalZlJLF1awT+/8yre+vQ8Xnnzv/HhxptoYwmy1pO1hMPmDVcVInLVOs' +
    'ClfJatAVl2Hzt6K758/3348T/9mCnCMOdCCrK/YAifGFvL+D1zgJ4vcjNrqUMA1EVD7fvJlB' +
    'K1k5sYsvLL1OQkCmzTZx+u7HIDHJm8bJzEttrcEKIbdFIsXlzG2HgNlxbP441T/4Hu4IJiQC' +
    '/zGDE+lZyh1GDCGxKV0ZnS967NHCemlVoNny6cwC9fPslJ+Vw3mEpK23SQbVuqb06CdrGDfV' +
    '3b4gIAc8hjCNmyxjYpS0E5zJBAvl2Xb2nTA1wb2Aw1WxYmrAIZF0eyb6B2fGSfjzd0oxV8sv' +
    'i+UoASFS7JLTBl2exRXUqqxGo8GdKnnpdtErXzNtwrYRnt0ThLrfZunLsd7XVOx/8VJfpw89' +
    'W2ZLOVqdIfOlGc57NilbXNrjlA0kEBEMeWhJXtNriwqag1uNR82QRhnNFYghYPqAcG6pqh9n' +
    'jVHpoKTVOtCIZhKNHp8p++rNc5vkOvhmKqoRJH9VPPkvSTDVk+x1A7RRbG6i32NMkLA8zMHM' +
    'DtN96AF14/y4xIlENk8E4/VOmYp4AjTtyTEtQ75+nAFWyqLmb9NcbwGjJZikYMLdZb2RGKaY' +
    'zBRZDrerAcO48K2cJOhl+AcNHj0UOyOoQIJrOnlsnqS5RE0YhyMVW3iqqIIMoliaaxiXEVwo' +
    'uLK/j+X/8V7jl2FH/x/R8gqjfxfqeHW44cxuNf/xNcWV3FP/7kP3H00BxeffWXW2WQUSCRcP' +
    '1CSDYVJCoEmK/8/h9xBUdQag3cuLkIVA20Dz+A4Mzr6FKjH/2d43jztdfoYaq0KEanvYn907' +
    'P4zoF5/H3vKFpcmPzZu/+GT/7UR/VIhgfdDCs/j/DuUh0nZr6JYweA44dmkD79v/jX+ysY0J' +
    'injrawcnkd3/3uU5iamcKh22/D7bcdU16emZ1l7e/gkQfvxbmziziz8hF+8L0/xoN/fh5r66' +
    'uqCkgJ3FMKjIgABYDrcuVG5VZv1NGrNtDYV1P57brsv38G5uw4vZei0WxQ5juYHhtDhWLIcC' +
    'oIWPvnKItDVo23pxuMpDHE54EVKrr3+xlWuUyervZhUkaH/QrC2wzcNGZiEKzhvfcuoh9E+N' +
    'a3vonFlWX85KWXMDc7rdKDIQh/bgp/88prXBvYFFVN/N2zP0OVDso5wJMtsZ32BXdcDeYqqh' +
    'arpWUfzzz9Q8VQatGyzYCWbQ9Lac5mssLLTEPt4cl9iewh/LQotfl3fIasKX6kbkmzXMuk2p' +
    'eCeTRe+/dMhv5VotzjC6nLknjXADBsrkoBglD99re/jRdffHGrnpaPJem847VfG2Fo5l39+a' +
    'hxRmzUXNUv/1J2K40nJyfxta99ze10OnvjgBHLY//hhx/GN77xja1JFN+2FCKjOC/eb2f0KC' +
    '/qn416lb9lLlqZs/TnZuo7RrUZ6ljDV/LbbIl5EhX6A4ovG8oGF0Ds5qd3ZcN1j466vwyeDo' +
    'T+mT4Go9e1RRmJQt4tAHq45Ib6uwnLYhJl3b1T7oqW8GtjlLcRF1YD9dXbyMzeZowy+CMiyS' +
    '1WstcVAblBXvlBo863C+Xi+tWfZ6re+41pCktWiUEfcRgokSTdylGxE9dsx0f5NctVZWoPAJ' +
    'RrJiPCHUU6xXkRiuVJb+exgqTldwSN8UkqQVsJpgA5/SPbFsydvF0GKj+vSArztLtrAOQHEf' +
    'og3W63KqBst6raieDK/X4NlKwgI6rnHuxqjVrepxS+mjsKLtnGsJFgjCBhn/a4eTXbHQD6w1' +
    'wRMobxrgBQ5Pao8lOwcZnEdmR9grBx+SLa8h25aH3j1/3LRo0ysLheCLfCQUUFkPe1Wu1io9' +
    'FYlbmtrKyMjsryxXvuuWfrh1HHjx8XELw777zzXw4cOPB78iWJXu5wtVaRB5vFr6BKYSwn4g' +
    'lL9+ooYzUQB/l1Iz9mutGF4eUyXHxOh7VfeOGFv3z55ZefFWJfWFjYKpn6z4B+A4BRYU4wzK' +
    'mpqYNaxBh5wqpjbhiXCZZrmmoXRJhXftFlqZ8VcEJ33HHHDwnm8cJDIrPLk5drllrSenjrrb' +
    'e+t7S09Eb+zNiQr5kgm3+qpEmpSvJraX6t+LFUKkcKoPUVcfsIxaXbfC0hZOTEmC4uLp4tXb' +
    'fyZufNyZubNy8/yrXq+Ph4M99lHplCAoJEnRwrrAznz5+v8JnrOdBh3gLtfZS3uAAkByMr/Q' +
    '4y21Z2XgMAo+RtvZUNL4z1tVbJjy7zcPauu+4aLwSUXhr10C9CW4iY9fs2AvBBodDz1tPeD0' +
    'aAkWhApNqSZVsQ7F0Yb2xjvKN5upIfa3mTUtLIj57v+0cmJiaqxYZLAUCRx/q5pADJC+x/hJ' +
    'cO5d7t5aWsrb13chBMLR1Hbf/uCMJuUqDcRgHg58bWc8OlNfNzd3Z29sjFixeNDz/8EEVFGa' +
    'UXpFRJo/HS5nhpn+xu5wZ7BbdoDoIW9mWPZ9qcsZcUMHaIAquU+3oEFF4fy42XXyPWpqenp5' +
    '544okvvffee5ibm1MACCsXukAnQOEAafV6HV/96lcnCcbdzz///KkcYEebQ6oZqRNhol0zSk' +
    'AZo6JgVz+R2QEMsxQNekRUmnw999xzf8ByOsMIgGxQFltURUkSw8XrYriwv/TZv38/7rvvPu' +
    'uhhx564OzZs72TJ0+ezkEe5EToaqRra04xS9GKnQhwLwBcC5hRKZM8/vjj97H87f/0009x7N' +
    'ixLZktxutcUBCggCAAsGKABKjq9ZNPPvngo48+urSxsdEekY67ndf2HUfogO0IsMz8fin363' +
    'n4b6XA/Pz8IeqHOXq4RsMqNFJ+sVHoA6t4Rv7T8pSHRBoBCnkM2D8kaO1Tp059FIbhFfl6km' +
    '0zPwognfzYz1uwQ0XItF+hZ3sBoBzyjlb69PyvaeTXyDmgooFT9ClKpq2BUJBYUdKKktfTDJ' +
    'TjRm50cezmra9phAKAtKQNttq1hNCocpFpDJtooJQJpiCgoj7X8sn1NG3garlrlgCI88kHOQ' +
    'h9zUi9DLZLmqCsBdJRhu+FA7IRrJkWuV3qt7Vyzj/TDejkRlc0ctS9XwagkLmB1npaiPdKgi' +
    'jYZdhn25XC3ZBgqklKlAbVJ114fZB7y9fUoadVClvzvll6TqKBGGpgBhqoYcnoSAN/OxUIXI' +
    'cUzjQ2LbyfloxPtYlH2uT0tYFernTPWyW21mt6XAI21saPS/q/vA7Yled3GwHb7WGnI0LX1C' +
    'ZqleqzNaJWmyPGTktjJiUj49JnaSncy0pwR+P3ogOyEZFRjg6jpMvLCyhjF0KlnF6Zpu5S7X' +
    '22A8ntyvDrFULZDkRplMC4Vttp/N38Zylsw/B7+u/w16sEsx34Yrv1xKjjtUDANTx73YYXr/' +
    '8TYADca8cY9ZLO9gAAAABJRU5ErkJggg==';
var laptopURI =
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAAGX' +
    'RFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS' +
    '54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3' +
    'prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9Ik' +
    'Fkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMC' +
    'AgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5Lz' +
    'AyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG' +
    '1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaH' +
    'R0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy' +
    '5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD' +
    '0iQWRvYmUgUGhvdG9zaG9wIENTNSBNYWNpbnRvc2giIHhtcE1NOkluc3RhbmNlSUQ9InhtcC' +
    '5paWQ6OUEyQjZDOTdFMDgxMTFERjk1QUNDNjkwRjdDRDZDOEEiIHhtcE1NOkRvY3VtZW50SU' +
    'Q9InhtcC5kaWQ6OUEyQjZDOThFMDgxMTFERjk1QUNDNjkwRjdDRDZDOEEiPiA8eG1wTU06RG' +
    'VyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo5QTJCNkM5NUUwODExMURGOT' +
    'VBQ0M2OTBGN0NENkM4QSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo5QTJCNkM5NkUwOD' +
    'ExMURGOTVBQ0M2OTBGN0NENkM4QSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPi' +
    'A8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pi/s9H0AABMnSURBVHja7FtJrCXnVT' +
    '5/1a2qO7x5ard7cnfaommQbRSHIGcBSiwhIcVRjJDYI7FgESlIIWIVNiwQiAVihVixJasQ1I' +
    'ohRhhkxU5ER8HBSXpwu4f3+s33vTvVrTHfd/6/6t33+vWAt36vdX2HqvrrDN855zvnL5uyLO' +
    'XT/OfJp/zvxAAnBjgxwIkBTgxwYoATA5wY4MQAJwY4McCn869RfXjzq1897rifJOlfJmn6e3' +
    'mRR57xjUhpqj8c1xc/GuMJ39hclmVh3PWmKNhtlnqm7/kyHo9Nnuf6U8l/2o0a8TyuYSQIAv' +
    '2Nq3PNyW7V/m7qr1ynKIrqmJ7oeV7pZBvhv/8YhuHfHKfYtWvXDhsgz4tjTit/czAcfHN3t6' +
    'sCBUEo5YHW7sb2ew5B0iSRqBnVglJ5GEOF5HcIJ3fv3cd5Y3c/u1q701bjUKEzZ57X82kQgQ' +
    'H0BjgPV8P0Isl4LM1mUy8t3LHSWp1CiYdXmmX6W6vV/KvlpcVvw5B3nooA3380GjzfP01h4n' +
    'gkOZSzHtP7VC5R0fi9hLJACRRxXsOPlfeqawyVjRpShj4E9SSHcQyPefbcBq7d2dpQg5a1x+' +
    '3aBsdoQBp62PfUcFaOWpjDioWRtNstqOAv48SnG+BAK5n4yeSU3gsi+fwf/onMLy4JQmIChm' +
    'V9eyI9zXLn8VINEQS+wtiHgr5nBfYsttUYVDDLS1WqxCsDKsZpqtfzWr5n8KbvN6SB6BuMYp' +
    'lqtxUhMdEWBuptDbPSGgway/baPbn59rf1Xjg3K58lB5gnJEmvEcjV33lDTp97QQKPoUBFrN' +
    'LQVwhmfqenCe0kzVXhBoQJGkaP4aO+HwowwhgX43RJ8Z+xGlfUEPE4kSYU5Huj4dfI4md7j1' +
    'SVThE2NJLnjhcw+L0PfyI///d/VkfReHTK0xFw3F9ZGpu8PJkOPSnSWHYHIwmDBjzR1BtQkN' +
    'JZ37h4pEdjCBVAWApMuHMh632HAgdxKpFkqSrBv2GcKBp8XLexsSuz0x3Z7/Z0nQj3HQFlXJ' +
    '/G6Q9HMoKBqGDmEmsLCMkhJ6CvL6aFx7p30gDFMVZSmMLNiYPb8lxTRohhegX2xm8NeC2B96' +
    'hsQz3HPFAqdOnFFMbyFQk0oq9xbNQgnot79ZpLkv1hrMiJoWQMNDQjq2QD+cnH8f3BQHIcSx' +
    'gWWIshcXZlSbaQpPm7JlYTwykIi7xOpOZofjgeAccMR6GI54oVFM3wKiSAMu2Zdp2oFvGZgq' +
    'dQuEWBR3mdG4iONKUioQsHGIJL+iwbtvTRc1RuQKhD0VE8Vg8zrkejVNHR8HxN0nv9gZxZWZ' +
    'Tb99YU8kMY4BcwEI1/9tSirG/t1nCvkGhLYvkJQ8BWAomipnp6OKJl6W1P2s0QxvDg6Vzhye' +
    '9EDDM5ExNjEx+lBwFpCCMW+kwqpWdDgTHP3/pQhIbgdyY3Ks9r6MnluRl5uL2rsuzDAFSSoX' +
    'Dh9IrcxvcQ997d24ccqazMz2JtII4J17PoLYoDrvCJDCAVRJVk2KTHbN9DLui0mmplfqaHZ6' +
    'eamsT4mTEawjNUkFAt1KuAKeseQJI7xPXdsRj1nevQc6wEmcvuN++tKj+4dOaUPNzc1nXvP9' +
    'zUz1c/cw6ISRRZNB7RQ07RgjOqEsy1lXh9Iirs6iwXoyeHo7EKZlzE8OY81lHyU2goEBVUhu' +
    'WSyawN+EfM3LiOuYS/F3muQvXgQYZID7G9u99Tr+/1+rK501WFhrjnFNbe7u7J99/7sbSgPM' +
    'Pk3KkFvd8v7jyAwUuZn24DFb5+pvf9iZIO+UyVayZfz4oAjZ8cnuj2BhIBaiTDTH70LrNsmn' +
    'kao4HnaSJjIqLQREZAsgNWPAuvDGILc6J/OBrpZ4rJJMcXr+vCIIzrM8uI8/sP1SDDcSwznR' +
    'ZyzZT8/KO7srIwJxeeX5GluWn1+ADXzk61ZaYdafgVE962iZ1ZwJNnYIKP2gLsy1R8e2evJ3' +
    '5rDwTcljeWQiY3vmgMxiIT09jTKNdMz980Y5Pjw3P0duwyuFehKo7d+vsa80TM9Z/d1Bhn6B' +
    'ANTLwLs1Ny9fI5ufNgU+6vb8nppTlLriwntnzE5BpmvrF9RdWXPBMP8LzjmKCloYQME42EbV' +
    'mGINPtlnqwC6MQTOqh2WlFSpVxqVQLytgS6dtQQZXwEJ8jhEIPYUKjED1dwJ+3Z5hsD4dyER' +
    '7+6a27mtnPP7cEpddRAod6zvNLs0iGQ1SI2DJN/GOloKysRG30Cfxu2aZyGGPMM/AAczwVNl' +
    'VTs7W7B+x35LNXLqpnaYAZkKF7SEh319ZhKHwH1LUpyiwTJBwjoKN0PQKrw9hl+RbCaBDn8P' +
    'JQldDs7zy1gbr+60hwd9Y2NOueXVnQ+8dQmhWHVYjICTLLMVBBJWkkanBWik3KWvUsT1T/Cc' +
    '2QsVRXzUhys9ntSuJH8tObd+Slyy9o2WHcLs/PwAgbso8c8dzSvJZDkpAI3o5AoROyQaxNRC' +
    'iVxWdWhmGcIn5j7Z9ZWr3SlqwFJDRWBibG57D2Zndf+TINugcURODhXMt36zDiyDNJ1DKE2L' +
    '4Z4dqh6xTZg/jmmeYBtORRA6BR0X6+FUUyB4g/RDb+t/evyxpK0JUXziC5tRSaa1s7qvQmPN' +
    'dGApx1ITGNd8+1qCQrvpIyT2OdccmvVIC278Bw7WagIdNCfiHpiQlrfN9Oey6XeLKLKkHFiE' +
    'LGf8ZQg/LkBgxj3w8QUv26vQ/DgEHwWCo0gYBHDcDWQhMapPziqy/Jd977X/kY3v6P6z+Rdz' +
    '/4EIlpWrl4okIHsgjePt2KtGLQm4xxet336aFQszSTKr1HtzBEiAAaLUtJnjLpp6mW156yy1' +
    'yGyRi8INOKwMTLxNlkN0amqX0/jId7Bpb3w9ABeof9ev5g2EebZ0CA94gBsECReVWnbS1eyP' +
    '7eLs71ZJ8eX1u1lkLv3YBwy/OX5AzCgEKSvTGpaZXAMdJkCknhy8LTNXNXEWgUKk/D7SHBEV' +
    'VDGJavFKGWghMIub6nsJQYx3M3NCmBij5KJf2dMDQgS4zmacZNmHCOb/uO/2c7bOpBluHsSb' +
    '779jvyfx89AH+Nba2FYDMzM7KysgIvpRoGtz++L2dBR5mMSGQeIFRmUDGm4KEkCtXTngu3qn' +
    'vM81L6SGiE7S5efdT2LhihzgXSRPJKedJmZP0c1cNeiz7CTVpS56SU84UILBIyWvnLOpE/Dg' +
    'UHIdBoPIIAHyyGi4wQjx/+9w9Q72Y5k9JXCIV++7XPS6fTUfiurm/IjxAWb//wx7IwP6fCLU' +
    '11lAUy87cdPW0yVifa5gEVhue7iO0dvLM80uMZvF/gRVwmIE7MH+MkVtSECKcxqkeOskc5CH' +
    'UiwGfWJukBmqqJEkLH2Pa7fLIBBoDV0VYYZck1U1gegsleVxEASMA7ofTADQxiLgcalhcXZB' +
    '4Kb6AEsS2eAnPr4xqdypSFlkDmB633HGLgxfxBuPPFmKf3R/Qwva9GGOsUJWeda1iWV3LqBI' +
    'VpIOUozKBElJsqacgmdljC4+M49o4bmR3DA44JgaLU4EEUyfPnTkvQmZLBzo7srq5Jhhh/97' +
    'v/Kud+7apMzc9LH97b2dySRtTSrowVoIdytg3v2y6wVLpMD1J5JjD2DixZpL9DKDug8plVMs' +
    'FvPtE3wPVQLBklyjgzJNfxyJZP/uMcwLDrc0MRg5AqcM/cdYGdTtuwAj3uWajaAPNoOw91SY' +
    'ASeLaWwaDVltd+93UxYdM2Kw/X5Wfv/kC6SIK3fvgjkWZbEyHcDgPY0Veu3BQdIBS17Lxlhx' +
    '1QUkdebK8R+wwPxrsOUljWAF9xfJ73LrSttq0tp846Z8B1DFn+nucsj1CQw5gEjZqPVVhmee' +
    '+SnWBBQv90Axw9Xmr0S91JDUFRM5AXMq0QueD8q5+V7rVNUY0bocyeWpHp5WVNRHs4d0wlCm' +
    'eEwnZpOj6DoixvhL9Ok4gIneCgbFIhw+SGbI5cwYQXoMZzIk1lU6CAJdWis9DIJALKqHQjdJ' +
    'It24sY1w/YHOg9PQSOqwPGEWReyqSWMKYAsXTUl62P7ojSBHaCiP0Lv3IZXvGUgGzt9fUq1n' +
    't6yM4COF4fSx74aoBU54C55QJmYkJq7LJUhjMDU+0r1G2s3SsoUlaFwDJW8gHmLM4VeV5mEe' +
    'TbDtUoC30aD9hDQ3I0ByBLex47OtDS97/3ffGitozxeQDGN0apkqip3ge1kS2Qj8i1wSVj3r' +
    'czgIyZWWNQZMTkRnpV2BZbB6ScFcJQ5ApMYSlH6sjyWYkkBwV5PY3MzG6Q8TNVHOgYsL0GIk' +
    'LCH+f4dvTMiVBWuIn1RD/zVCLEYcXhGBC7N6WWTWX9gw9sbNJLzRaEaQt3ykzoo1wN5eHt29' +
    'JEMxQh0zeoMKGM60pIE0Dwvp9LIx3WLI55gPGe6Vg7t+NthIIwTDgNYlgwmzOeOQJPUs0BAe' +
    '5PjqHGQzUqYzuWY7wbGE6NMNivd6SAGq9wGzpP7gWO8gDRsZXhBCgIPDk3vaPK2/q6Z0+KUd' +
    'tRqSiwliDHufnSvQK3ZcXP24jhHReXdgvLUyHr3SO3tnF7b0FZusnTwTsZKO/VIu0lc3WQ9y' +
    'C77hwlfjXNFfZADEcmy9DtNz7RAK1W6xEihJ675BBjrOyrcOMkUZ6v0C0ShXleTChyzPvRDc' +
    '4mQucKyifvSQPT+NevX0eOiOs9g8mmxBz9ntpdJl8bLOQUEiTtGL16Cu45trm9vV3mbs/hiQ' +
    'b4z3feOeR9xunlFy8Hc3Nzuti5s+e0F6/O2N/fl62tLSU1NtFNKn6wh8iJcvU7jUYladxef6' +
    'gzxmojdWn5lIWxmJqU1HTWfSvFbYKKqZsdGm8Z1Wd5eameX9JZd+/dk067Izdu3Ji+devW0w' +
    '1w48bNowiIvvT663/04otXlHrOzs26LWt7EyqyByaoUHaCla6rrJTiO6+tmxH2Mqn1RhSFdm' +
    'TFDK+GGUvVedqO0W5p0bi8R7UTTIW1quT2Oh7nbnELXEXnl7ohAg6DZD0Chb548YVvrK8//E' +
    '6/P+gflwxrA5w6depgmIgbvPzyy3985uz5V86fP6+CMxTauAnWwXsLDGtKpjrTaph+v1/nEC' +
    'akNhqgMbk8J0G+PhOghqj28JTA4B68hh4fg16zjS1cqPAZAZ5LQ/CcXEul0XV4jIo1o0i3z6' +
    'BYvS/IifPU1JRylmk0arN49Xr7r7z22he+8dZbb33ruDxQG2AFMKqgOjc/d+rVVz/3zXk0NQ' +
    'k6Mt6UtsNi+pne4nkse91uV5VMyNfdvh8NUglPYSsj2IQaHOzcZJYDUC5WBG1xDTc/R3aaw1' +
    'KK39PU7vcb3ZiwDtpE+C0tLmpYUh4qTFTSURGMQxnaCIF2e0qu/OrVr62trf5Tr9e7dRQFtQ' +
    'G+8saXD+qf8f9udm7hzGcuXYJ1/XpzgQtTISYadmyM2aWlJduNsafn0ALncOxVVkvZuVydAw' +
    'hnCsc16PUY3g+DUNcfJ/bhh8ztISgV8xracYag2imcwWMd9BkfAeJcl3HOcOHUSpCvKN8Uzq' +
    'eilOfChfOQP5t7883f/4cobHzpKOGrDUDBnWe+4PnhH1BZWpmxxoX6uCEFYS1mnLVaTfQKQ7' +
    'zvKLyJAN6cBqFyk9tRldWrd0KeQhPG2zvbSjeIDBqGMwbyhxG82QLfSJQGe1o5hqOBooX0mN' +
    '5eX1+3T4uQyAGJDCHGPtex22LoSqc7CItp2d3Z+SLC88tAzL8c3w2yxcxSZJLG30dhaBjDq+' +
    'j6qrLHBfs6j7Pn7iMciA7u3tC7i2iHV1aW1ZCe557gqLZWJuDAXN7hQw72ISFct6Qxu7m1qd' +
    'x+fX3DjWHQoiO+tSKVlj1WW1JFYZ8c4XW7u7v1IzJVhLNCNVyJVDnds0fjJP7bvMj+C8e6jx' +
    'hgfW3VXLx0+U9fevk3XqH3GVupy9jVw0u68+P2CSsplYtDIJKNtnt6o/a2ywmpI0oNxn95+D' +
    'Ebep8IUyY68bRL6QxUldTStb/VkyCPbnUdnHcw1Cwn1uHMo395bfXBX6ytPfh61R3VBlhbe4' +
    'gOLHxjG/2+XePgya3qVQmse/xuK6ysnxWylfpAC6OdG5HDJqkRejrB4doESJFbK/CcIrfP/1' +
    'QkZrKM2l0dc4hQERGle6ager7AEjWpG69DBnKNUZIwEadvrj64/2dk/4cMcO17b5UXL178GN' +
    'D/XMPt+00qb2FNeltoqzsaxmoIxj/j0O4L5rKxsVHfmLO/5ZUVl/nLg0faxE6FjDMyQ8mW37' +
    'wOF+OIz+RjdOUR71eurc55FBkVEOy9gQAi+/0HD1brxsdUVnUwf2VhYeGvgyD8LXRoXh279o' +
    'ks+2iTmeyy9JkgPqKXwUANa4TMVDGqCvq+nQj5nmkg8alBvYNH7KSs54OlHWJU+FcseBWcq4' +
    'erHE8pJ6k1L9UdrDyfaHtK17rwmPYdJcLsf1C2/xwh9171XGFtAEcm2BCcxecr+BJJvZ+gZj' +
    'SlqVPbxACBcqsA3pPaTvOYJ9FkIoQq07rv5eE+tpzwmfWMMfK4Lq90OaGcqEQZrruNj/fwuV' +
    'c4OJqT/2/w5GHpEwOcGODEACcGODHAp/bvlwIMACEaE9sQeOO+AAAAAElFTkSuQmCC';
var twitterURI =
    'data:image/vnd.microsoft.icon;base64,AAABAAEAEBAAAAEAIABoBAAAFgAAACgAAAA' +
    'QAAAAIAAAAAEAIAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAD///8A////AP///wD///8A///' +
    '/AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD' +
    '///8A/v7+D/7+/j/+/v5g/v7+YP7+/mD+/v5I/v7+KP///wD///8A////AP///wD///8A///' +
    '/AP///wD+/v4H/v7+UPbv4pHgx47B1K9Y3tWwWN7Ur1je3sKCx+rbuKj+/v5n/v7+GP///wD' +
    '///8A////AP///wD+/v4Y+fbweM2ycMe2iB7/vI0f/8STIf/KlyL/zJki/8yZIv/LmCL/0ah' +
    'K5/Hp1JH+/v4Y////AP///wD///8A7OTTaquHN+CujkXPs5ZTv6N6G/+2iB7/xpUh/8yZIv/' +
    'MmSL/zJki/8yZIv/Kmy738OjUi////wD///8A////AMKtfY7w6+Ef////AP///wD///8A3sq' +
    'bp8iWIf/MmSL/zJki/8yZIv/MmSL/y5gi/8mePO7+/v4w////AP///wD///8A////AP///wD' +
    '+/v4H/v7+V9CtWN3KmCL/zJki/8yZIv/MmSL/zJki/8yZIv/JlyH/5tSqp/7+/mD+/v4////' +
    '/AP///wD///8A+PXvJtGyZdXNnS/3y5gi/8qYIv/LmCL/zJki/8yZIv/MmSL/y5gi/82iPO7' +
    'LqVfe0byMmf///wD///8A/v7+D/Do1JHKmy73ypci/8KSIP+/jyD/xpQh/8uYIv/MmSL/zJk' +
    'i/8qYIv+/jyD/rIEd/9nKqH7///8A////APPu4TzAlSz3wZEg/7mLH/+sgR3/uZdGz7mLH//' +
    'JlyH/zJki/8yZIv/GlSH/to0r9eXbxD/Vx6dg////AP7+/h/p38WhtIsq9al/HP+kfyjuyba' +
    'Kgf///wCzjzjlwJAg/8qYIv/JlyH/u4wf/8CkYrn///8A////AP///wDj2sRMnHUa/7meYa7' +
    'Vx6dg////AP///wD///8A2MmnYK6DHf++jiD/vo4g/62CHf/k2sQ/////AP///wD///8A8Ov' +
    'hH/f07w////8A////AP///wD///8A////AP///wC/p3Cfpnwc/66GKvPg1LZ8////AP///wD' +
    '///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////ANXHp2DJtoqByLW' +
    'Kgf///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD' +
    '///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A///' +
    '/AP///wD///8A////AP///wD///8A////AP///wD///8A//8AAP//AADgPwAAwA8AAIAHAAB' +
    '4BwAA+AMAAPAAAADgAQAA4AMAAMEDAADPhwAA/48AAP/nAAD//wAA//8AAA==';
var thumbnailURI =
    'data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAA0JCgsKCA0LCgsOD' +
    'g0PEyAVExISEyccHhcgLikxMC4pLSwzOko+MzZGNywtQFdBRkxOUlNSMj5aYVpQYEpRUk//2' +
    'wBDAQ4ODhMREyYVFSZPNS01T09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT' +
    '09PT09PT09PT09PT0//wAARCAEsASwDASIAAhEBAxEB/8QAHAAAAQUBAQEAAAAAAAAAAAAAA' +
    'AIDBAUGAQcI/8QAUBAAAQMCBAMEBAsEBgcHBQAAAQIDEQAEBRIhMRNBUQYiYXEUgZGhBxUjM' +
    'kJSkrHB0eEzctLwF1NVYoKTFiQ1VKLC8SVDRGNzdLImNEXT4v/EABkBAQEBAQEBAAAAAAAAA' +
    'AAAAAABAgMEBf/EACkRAAICAQMEAgICAwEAAAAAAAABAhEDEiExBBNBUSJSFGEFMhVCsYH/2' +
    'gAMAwEAAhEDEQA/APTqKQp5pC0oW4hKlfNSVQT5UlNywqcj7aoBOixsN/voB2imRdW6smV9o' +
    '5/mwsd7y60C6tyEkPtQowDnGpoB6im1XDKM+d1tOSM8qHdnaelHpDObLxm80gRmEydqAcooo' +
    'oAooooAooooAooooAooooAooooAooooDiqhXNTVVCuaAoMQ51k8VM5q1mIc6yeKfSoDK3vzq' +
    'qXPnVbXu5qpc+dQHE1YM2R9CTdvOhtpbhbRpJUQATA6CR7agtoUucomBNWLNyv0FNm+1xG21' +
    'lxEGFIJAB9RyjTw5VGztjT8EsYK+XbVltSVOXCSoSYTE6GfERHmKS5h67dZC1JIDYdzDYgxH' +
    'rkx5g065i90tlKOE2hSQEhQTMIBkAT00130FJxLFlXtuhtTaUqzla48dY8pKj/i8KweuDceR' +
    'yzw9V61xBdWzSc+SHFkHaZ2p34jeBXN3afJ/OGc/iI5H+SKq2GFOGQNBzJirOxKLZSi9bIfB' +
    'TABcAjX11m15OtTluizawh5sBtD9sToSAsnTTw5TtVvititLAaF2wlLSQQCTqOtU9nf2aXEq' +
    'XhVulSQJVxRBI5x4/lUe/uBcvKcTkSCdgsaUcom4Y5u7JV1bu2CkIddbWVpzDISdPZVp2Gvb' +
    'VnHrhT90y2FW4SnOsCTm21rL8Qn56iogQNZ0qRj9rbpXaKZaCQtlCjE6mBrVXs45bcdD8no9' +
    'xcMKuE5Xmz8sNlDxrQpyqAIUD5GvHMGw63vHOE9nKOgUatn8GZt3OGy4+lI5Bw1rWcJ9HodN' +
    'msx3s/c4njFvfNPspQwEEJLfelKiTr0IPPaPGqRvski2bAavLNl4N5CVsxPyHDMg7gqk1dNY' +
    'xijzSXk+ioSsBQBbUYB21zeNdGJ4orQLsyfBlR/5qzLLFOtSPNGEmr0lUx2XfWu2QLy2W226' +
    '6sZWCcpXOoVI1SJjx1ilDsO8poBy4tc6UkJSls5UnK0kKHQ/JknxNWpxLFhPetBG/yKv4q58' +
    'a4pOjln/lK/iqLNDzIrxz8RFKwW6U8Hj6GpSHlPDMknPmJlKj0E6b7Dam2Oy/Atmmw60pxtC' +
    'k8QogklTZB9QQR66V8aYp/WWf8AlK/io+NMV/rLL/KV/FV72P7E7eT6mjqHcN2rj5Dj+VyNU' +
    'hcHbpVHdY1itvbrdBs1ZBMcNQn/AIqon+094+OK9YWixonMUK5TAnN4mu+LGs6uO6OOXL2XU' +
    'tmbRxu14LbIu0ATnTmUDoNNNfGkhhsIKfTUGTmknz8fGsSntE+cgTh1keGkhMIVoN/rVNsrm' +
    '/urXjM4fhoaUdAtRExpsVeIru8EoI4rqFN7GucYtsqgbkoCl5zCwPZ03oVasJbCuM7kCfoqi' +
    'dSZ8d6zJ+NnAUGww1YQYgrJy7D63gBUkXnaANhgWmHZAkJy5zoOX0q4yxuvi9zqsntFwhFot' +
    'JHpLonSSvrP613gWOVSfS9ACD8oNt9aoeLjhTk9Bw0hQAylZMx/ipAt8ZDiFjCsPCkqCkkKV' +
    'oR/iqY8ctPzav8AQlk3+KNIW7QuqHpRCl97KHB15evShFtaOBXDfUqBBKXJIrPFvGzlnC8P7' +
    'o01VpqT9bqT7aGF45ZqPBw7Dmisa946if3vGt9teydx+i9fZsUuBDt2UKJyhJcGp6a0rJZMn' +
    'Oq8KeEAslTogDWCfDes6y5jOIvvOpwzD1uMuFtaiSO8P8VPm1x4zOFYcQUpSQSdQkggfO8BT' +
    'tpeSd1+i5LdgsqUm8IzFSjleAjr91OOtWjjmVd0QTPc4g69PXVA3Y443GTCcNSAnLoo7fapR' +
    'tceKys4Xh5UdyVGTrP1utO2vZe4/ReuWls2mXH3EDaS5Hj+FRbi1tbpCVMXbKUEEgggzrvv1' +
    'qDcJ7SXLeR/DsPWmZgqO/2qaNv2gLPCOGYfw4jKFEAiZ+t1J9tFBLyHN+h5zAvSCUNX7KlDv' +
    'aanWPHyqBcdirh1JAvWteqTUthntDbu8RnDMPQuIkKPP/F4VJ9I7Vf7lY/aP8VHFvyRTS8GW' +
    'uPg2vXdRiFuP8BqEr4Kb9RkYpbfYVW29I7VR/8AZWP2j/FQLjtV/uVj9o/xVnR+0a7n6Zikf' +
    'BTiCTIxS2+wql/0W4jzxZg/4FVsfSO1X+5WP2j/ABUekdqv9ysftH+Knb/aNLM1wmY8/BhiC' +
    'QSrFrcAc8qqE/BrcplRxa1POYNaa5xXtE1cC1es7LMtBUR3iMu2pzVAdx7EWb4sv2lmhxQJk' +
    'hUEH/FRYk3V7lfVSirK1PwfvoSIxa016g1KZ7G3jLBZGIYeoZgslSTIPLn4VLcxW+Digu3tC' +
    'Y17izy3+d76DjN2FJzMWUwMvya9vtVfxL3Oi/k8iVJjLXY7ERnKL6wUVKmQ2rTbQQdNhTNx2' +
    'IvbkgrxKxTkmcqCNSanI7RXzc5E2QzGT3Fb/aplXaG+cuA2beyUSMwORfXpm6mp+H+h/lMi4' +
    'ZBHwf3IJHxpa6GNjUy67EP3LVqycQt+I0gI2PeipC8ZxBKiVW1okqlR+SWJ3k/O8TSW8cvW1' +
    'BaGbNKuR4a+f+KtLpmuDm+ucpanyKwzsi7h7yVrvmCImIIq1cwJx9WdFy3B8JquRiWK3oLqL' +
    'K0eyCCoMqMRy+dUZntjcWySyq0YOUwCkkD3zRdM3wXJ/Iyk7kxyybxI2DJYZcLam0wcvgKfL' +
    'eLlSVejrlMwco51ItsLbu8MtlKvLtkrYSIadCR81IP/AMR76kDBEhTahiWJnKMo/wBYHX8a8' +
    'M+hg5N2zvDq56Vsiu4WLhalcByVEToOVKy4xCYYWIA+iOVWAwUdwIxDEUlIykpeAKu8VSepk' +
    'mhnB0Nugqv8QdCRHDcelMZSnb1+2s/gY/bL+ZP0ivyYzBPAXJ/uimnbXFXiOIw4cogaAVaJw' +
    'PK4FjEMSB1mHgJJGp25kT51YWVuq1aLZduH5VmzPKzEeE9Kj/j8bVNsq62a8IydxhuJLtnEC' +
    '2dlSYHnUJrCMfYaLbdosJJJIISdxHWt9B4hXC9YETpvUuvZ0qXSxcYb37PJ1N9TJSk+Dzw2X' +
    'aTi8T0VQVoNEp8fzNP2FpjFpaC3VggdAJIUpYkT663lFeiXUOSppHGPTqLtNmKcRi7qipeAA' +
    'qmZLp6z160BvFRMdn066aun862tFc+4vqdND+xi0IxZC0FPZ9AKIKSHNo251KF92h0/7FH2/' +
    'wBa1VFO4vqND+xlDfdof7FH2/1pp97HH05X8BQ4mIyrUCDqDsT4CtAl9cuNIUS6t1QTP0RG9' +
    'LU6i2dyHiKISkbzMkj21xXVQ50m+zP7GbsH+0FkbkpwcL47xdMqGhI238KmfGvaM/8A4RP2/' +
    'wBauje5CpLjSkrEZRIOaTFRrl9w3IBCmyAmROh74pPq4Lev+iPTz41f8K4Yr2jj/Yift/rR8' +
    'a9o4/2In7f61di7nKrhq4SlZQuR/MVJrcc0JcIy8U1zIzfxr2j/ALET9v8AWj417R/2In7f6' +
    '1pIoit9yPomiX2M38bdo/7ET9v9aPjbtH/Yift/rWkoprj9Rol9jN/GvaP+xE/b/Wj417R/2' +
    'In7f61pIoimuP1GiX2M38bdo/7ET9v9aPjbtH/YqPt/rWkjU1H9KATK0RG8ctvzprj9Qsc3/' +
    'sZK9V2iur1Fz8WcMpRkKQoEETPM1VX+D4/evF5dkvMRAAI0Htr0M3KQvKUmf5/KlB3Me6nbe' +
    'TEax+BpGcYz1qO5ZYpuOhvY89OHdoTZ8D4tXm4XDLnEExPn0gU03h/alofJ2i06gz3Z0EV6I' +
    'LtBEhKvd4/lXRdtkEgEgc9K6/ky9HP8U8w/0d7QH/wTv20/nTjOAdoGnEuos3AtJBT3knnPX' +
    'wr1IEKAI2OtUr3arBGXVNqvApSTByIUoT5gVpdTN+DD6eC5ZkvRe1smbdR565OkU2zh3algH' +
    'hWihICTqk6DbnWxHavAz/4yPNpf5V1fafBC0uMRZBg/OlP3ip35r/UdmL8mVwu37TYYw401h' +
    'iHAtWaXCCQYjSFVCR2cxvLKrJc/vD86tMPxXHnMcuGXLVCmwrupUqEgeBjbxihNzdoursFam' +
    'lF9RKELJAMDyqxzSttI7x6JZFV8Fph+DWbzdlfOMOOO+jpMhenzAIj1CpKMKt0hMM3QCHUvJ' +
    '74+cB02A1OlR7NWJJsrf0b0As+jtZQ6TmBjWY6/hUji4vwweHhgUdYKjBEiIPrrjLkkeEcdw' +
    'm1zE8G9EJyy2uNI2036da45gliW0gW91IEhYXChJVIn1n3U46cVS8ospsFNknKHDBiTtHhl9' +
    '9JjGSBl9AzlO2pE97bn9X31mjQ5Y2DOHrDjTd26vJBK15t46nfT76npfWSJt3RJA5fnTNim9' +
    'Ic+MGrVOoycGTpzmalZEfVT7KEAhXEnMMmkCOc1JqJ3eLkDcRBzRpvUuss0gopi+kWbygpSS' +
    'lBUCkwZAqIu5et3XEJIWkOBCQrUiQjnOu5qFLKioyFPvJZWCEiDniNelMlbhs7TvFSlkBRzZ' +
    'Z7pO422oCfRVUzfXBQAEJVEJlUSTp467+vTrQL99AW4otrQCDASR9FOm87npQCm7YL9IdRAe' +
    'S6SlR6jl5UhxzjPocAInhyOhzGRSXry4CxmhMJWSBGvcJGxMe2nF4g8lJMNCGeNJBiNe7vvp' +
    'vXnfTrwzr3H5O3vdvULg5UBKleU/rSLtxD1yC2QpMI7wMg98U9eLdQ86pqfkmkr1V3d1TI5z' +
    'FC7p5Lgb+Tkr4fzTodNd9tfuqS6e735CyVWwywloMNMqLi3QoAt5zpB38udW1VbV+7wW5yFa' +
    'lhGY+ITr/xU8i4dyPrUpteVxKElI0EhOvlJmumLFoRmctTJ1FQbe6dceyqyZQ6powDJIBM7+' +
    'G1NIvHfSClJPyyvkytJgATt1EBJ9ddDBZ0VWJv3oRPDkqTIg6BWXx5Zv0ocv322luENqCUhQ' +
    'hJBUDmg76bTQFnRTTC1rLiV5SULyyBE6A/jTtAc61ABbSU8RGYlIOkwAY391T9iaQG2wIDYg' +
    'axFUsZUReIlxeUtxmA16GSKdPAbCUKMx1nzp0NtiIbSI20pRSk7pB9VBKV8EebVIOo1338R+' +
    'dDvAbZzBMhURBNPZBySn1ppDzJebKCMvQjlQRk73GmLrPmCU91Jyp8orzEW7SbdB4aCSpZJI' +
    'H1jXpdnZu26IW9xCD9WBWJX2ZxqCg2wUErXlUlxMEFRI3PjXq6aUYzts8vWRco1FFViAs8Nt' +
    'LebRp64eTxFBUAJEkAe6qxd8m8sX20MhgtjVA1BHhOvvrSXnZPGL5ppLluErZSUJUVpIKddD' +
    'r4moh7E420y4hq2QpTmhVxEgAe2kpXkuxCKWNKj0CzT/qTB/wDLT91ZZwLGI3+mnpCo9grXN' +
    'MPNWrbYSFKQkDeJ0qp+Irpy4uXTw0hx0qSCeVcYNJnvwSS5GrLF7C3sra3uZCktNgkslQPcC' +
    'uW8A+qp+G4jZYkpxFoASgQQpoiQDUKzxu1srC1Yf4qSm3bOYNykymYB8NJ8xUtvHrVx4NpFx' +
    'KiAklkwSSR6tudWXJ5I8In+jNhMcNqByyequpt0JcDiUNhQ2IT+tQkYywtxpAS+OLlyEtaGT' +
    'Hq9dMq7RWqUkqRcg5ikDg7wYnfbY+RqGi37/wBZP2f1rsL+sn7P61X2mLM3d36Mzxs4BJKmi' +
    'kaedWEK+t7qgEZzxQgqTmEGMvKal1F1zxmEggkR41KrLNICARBEg0lSEqBCkgg7gjelUVCnA' +
    'AkAAQAIAFcLaFIyqQkp6EaUqigEFlozLaNRB7o1HSjgtAghtEjY5RpS6KAQGmwkAISAOQFIe' +
    'tWn0hLie6OQMfzvT1B0EmgOFIMyBroaSpptRUVNoJVoSU7io7+JWVv+1uWgegVJ9gqA52ls8' +
    '2W2beuFf+WjT8/dQFtwWjMto1EHujau8JABAQmCIIjcdKo1dpg2flsPfQnqf+lPNdp8Mc+ct' +
    'xs/3kflNAW4QlIhKQANoFGROndGm2m1RmsTsXh8ndsmeRWAfZUoEESDIoBKmml/PbQqOqQa4' +
    'GGRENIEdEinKKAAAJgb0UUUB57247bYr2fx0WNi3aqaLKXJdQomST0I6VSW/wAI3ai5SVM2m' +
    'HqA/wDLUP8AnqN8K4ntcn/2yPvVWRYLqTDbi0xroSKFSs3Z+EDtWEFXoVgQOQbUT7M/8weho' +
    '/pA7WZkp9CsMyhIHDVMdfn1kGHkkr9NcuFoUAISqZ1561LN7YBEoVf8TQQXdCOes1S6Wab/A' +
    'E87WxPoeH7lPzDvtHz6jP8AwmdpLd0tu21glY1jhq/irJv3L7jy1JeeKCsqAKzUe8ccffLry' +
    'ipahqTzjSgcTX/0pdoP6jD/APKV/FSk/Ch2hWoIRbWClKMABpZJP2qw1SsNu1YdidrehsLNu' +
    '6l0IVoFQZioZN6jt12tXdJt/RMNDhWEEZScijyVCzl9dR0fCN2pcYNwiysi0Ao5uCqIBAP0u' +
    'WZPtrOYZiNjhmJruGlXDqHFJELQAUpzhRJ11Pd/GpOHYxZoUizLbgt0lKUFahlIPdXI+iFJU' +
    'snfXL0oC1X8J/aJCUKVbWACxKfklaiYn53UGk/0pdoP6jD/APKV/FWPvnkv3SlNAhpMJaB3C' +
    'BoJ8evjNR6A9/wsFeGWYDpEMIlPdP0fGpveSnvPKgmQSU1TWuEWV/htsXeKHSyhSuG4ARKQN' +
    'uhy+7SpLGDYZlIYDhCkBAyvTAEba+WtdZcnKPCLENvZgS64QDqITrSVBxKYNwtJTqSQn31Ab' +
    'wTDEhLiQ6oLUClXHnMd+utOfFFiULOV3IWksqPF5IMjnoQRvy1rJomlLpUAHlyAJEJ11n9Kc' +
    'b4iUQvMs9dBVZ/o/h05gy8CVZioOmTpzM6in7LC7axc4rCHs0EEqcmZjx8KAmkDOF8M5jAnT' +
    'aalVEy/K58qpMDcRvUuss0goqHf4kzYhIcClKUJCUiqO57UrSYat0p8VGfyqFNRSVuIbTmcU' +
    'lI6kxWGf7QYg8AeMUJP1YHvH51BVeLc7zxKiROYq3/nzoDcP43hzAOa4Cv3BPv2qC52k4g/1' +
    'Oydd6KOg/L31mba+TbKSsNtk8itE+/9asUYywsgusKHihU/fQE1eIYzcfNLFunoNT+NRXLZ5' +
    '8TeXz7uuwOUezWloxCzcUAl7LroFppwd9IUgpWNRIM0Ay3Z2rRlNuhSuWeVffUsXJQnKlKQB' +
    'pA0qKpRBggieulNqXOh/wClASzcDWFLHmZn21HcSy+AVpYV5opqQrSSSNIApt1xLRlxxtPmf' +
    'woDrmH2xHcbWn/016e+m02bzQzWt682fZ91RXMTt2gcmdZ6/NFV9z2gciG1BH7ok+00BfDEM' +
    'etEz6Uh1I+uQfefzpxvtjdNHLcWzC/3FR+dYh/FHHVaqKj4maLe2vb1YCEL15nSgPTML7WWO' +
    'IXaLQpU08vRIJBBPnV/WO7KYCixcTcrtybgCAtZ2noK2AmNaA8d+FNM9rE/+2R96qzeGWNxe' +
    'v8ABtGFuuH6Kf50rX/CXY3Fx2m4rTZU2m3QFEctVVX4NiisFSOC02vMjUKG/iaqR0i6JNn2F' +
    'uHGw5f3bbGk5GxnUPXt99RcQwLDLRRQ268sjmVD8qL3tSuFJazyYkZtutUN1jD9wpRISkEzC' +
    'RFaoNscftmUGGlnfnUXEbV+3WgOtKT3QdRV12OwW7x7FkKU0tVq0czi9kzyBP4D3b1ZXxfu8' +
    'Qv3r1GdFu8prKEaBKdAfZUaKnaowxBFO+lLgAhJgACrVeFO3L6lWKOIgd4+FWVxiYQ9mRgYQ' +
    'yVgkBuT88kwTzKO705xtWaI048GX9JVM5U7ztXF3C1iCAPIVpjjaHGVtrwdx1Cj3lkarIKIB' +
    'gR9FQ2nve0axotPOZsNeCFOOryJHzVKyiNI2KV9PnVKRnUzKUVbY1cm8FuUWbrKWGglRUmJP' +
    'X7vOZjWqmqQ9ws7Czu7G3cfw591wsNhRS6kSABGmcfdT9tg9hbOIdYwi5SttUpPGSYP26Th+' +
    'G2NzZWy3C4XlsoJCHY+gBMT0j+TVhYYZa2Dql2yHpUCDmczbmTuetdZcnGPCK8YFhoIPxPc9' +
    '0gj5Yf/ALKUMFw8JyjB7mDv8sP46um30OJKmyFJHNKgR160KeSkkK0ITmIKgNOu9QtP2QbJl' +
    'uwQtNphlw2lZBIzoOwgbr6CpPpD3+43H2m/4qfCyQClJIOxBH513Mr6h9ooK/ZGS64Xwo2Vw' +
    'kqypJKkQBPgqrGokHi58q5MDcRv+tS6wzaKvGsOaxG2yOthS0GUKmCk+BrDXuF49h5JaSt9q' +
    'fBZ9+vsr02KQUJO4qFPIk4ypDhRd2pQob5ZSfYaeZxKxfTmQ9kn64yn2ivTbrDLS6QUvsNuA' +
    '/WSDWcxDsLhtwFcJK2J5IOnsNAZzLmGZBC0xuhQP5U2ZQCSANNpg/hT112HxG1lVjcpWBsDK' +
    'D7arXGu0GHlQurZ1SBsSnOPaNaAmF1SUz3ojkJoTcKbGZSuGeUmDVWcbSBlctyhX91RTTCsY' +
    'RmlDIzbSdTQGlbxS5EZXVKSdswkGurxgIT3kNZvrbe6sx6ZeXOiEKPkKkW2CYleEfJkTz3oC' +
    'dc48tQKQ4fJOgqsXiLzphsEnwE1orDsM+shVwfbWnw3snZ2wBUgKI8KA89t8NxK+UMrShPM1' +
    'eWPYi5dhVyogeyvRWLNhhMNtpSB0FPgRtQGVsOx1lbwVpzGtBbYdbW6QG2kiPCpdFAcCQNq7' +
    'RRQGF7VPWyO1VuhdutxwtpJhWihJ0I9tP452RtcVZRdYfcC0CkjQNBQPvFVnbO6RadsWHnPm' +
    'pZTOk6EqBqS52icwCxFutAvUrMtkKynJyMwZqp0dtDklRhcX7LnDWLl64xBJ4Md0NmVE6CNa' +
    'pcLVF+0kWrVypaghLbkxJPgR+VaDH8eGKXEm3yIM5kFU5unKomFYbmKX7dq7VcoWFNqTCUog' +
    'zMmZquRI4MknSR6nheNYXhWGOekPsW6GTlyJASZ6BI51lMqb+zxrELdx1pL6XHMhIkgkmD0q' +
    'iu8LdS6Xb25DlyozkBzH1nlUy3vhbYa5ZpMKuRw/IHc+yuerfY90Oj0xcpMYsL1Nthhat1Q+' +
    'BvFKQbh9guqv0NPKOXvZRpO81U4a/bt8Rp9tS1qIgjlG9Wty5ZKaWBbKBOoBUdOgro0eSTTZ' +
    'UK9IaYWy3fs8JkAZRl70qggTv18qdIUh1xpOKDKhZVMJ11KuvMjbyplx7DFBIXZrzp0UUqgH' +
    'SOvrqMh7DkgcSyUdTPfOm8DfyrJwlyJxG/uLlxba3gpoKhISIBA2qDU64ubEpItLPIYiVqKv' +
    'XEx1qDQh7lYYXhN1bWzr7QXclhAUOLBjKnlP7vuqba4Vhds6l+1bKVoWSFh6ddZB186i2Nlh' +
    'NxYWqrptlbvCSVZnY1yJ5T0y1JXhmDONlTjLKkJMlReOhJ6zzNdZcnKPCGBgGBNNlYYyICZK' +
    'uOQAPPNUv4uw7iDKg5mmuDAe2STMET11k02MPwZDfC4bIStJay8Y6jQlO/hNdfs8IdjjpaWE' +
    'I4vefOiRAzb+Ak+FZNDSsCwbOVqYOZRiVPmT/xVZ2jTNszwbZBCEkmM0xJJPPrNVnxRgaTlU' +
    'yzK1GAXyJJnTfz99WFpYW1kpSra2DZUIMKOokn7yaAfj5XiZVSYTuI3qXUTL8tny94wDrymp' +
    'dZZpBRRTT7pbiANiTJ6fjUKO0VDGIIOvCcgpzcvKluXiG1qQpCyR0jw/MUBIKQdxSFMoWIUk' +
    'Gktvh9tRbBEaCajOvPICsywkhII0G+vP1VznkUOTUY2N3OBYddTxrZtU88oqF/ohhAMptkip' +
    'q719q3fdjiFuNI/vEHbwppvErpy2UrgjidwCE6AlRSZ16gxW4PXHUjMvi6Y4xgGHsfMYTU9u' +
    '3abACUAR4Ui1dW7bhbiQFBSknSNlEdT0pD7jzecg93MI03FSctKtlirJQAG1dquZuX1PISVZ' +
    'gTyjXr/ACKZTitw2hJdtgrNqIOXQzHM9D05aVMU+4rQmtHJb0VVKxVw2bdwhlKSpeXhkyVaj' +
    'Yjnr7qFYk6mxW8lKXFpO6U906gdfH3V10sxqRa0VTtYldOWanAwOJnSkQnQSoA8x1qytXFOs' +
    'haxCpUCIjYkfhUaaKmmPUUUVCnlfwnHh42l0HZhP3ms1bY36Rh6LS814JhtzoOhq++FJ3/6i' +
    'SzGnASSfWaxeHXibO4cS6gLYdSULSROnI+o1XuqPTDI8VSRbsFtm7DrTzQ6KUnMBVqcUtuH8' +
    'verWkfRaTl95ism4JJCEoUATC0mAaWxaBSgp0kgfRSd6xpPZDqpP+sS3excvL9Hwy3IWvTu6' +
    'qPr/wClW1rhacKsXLrFFD0hxBBB1yJ6DxNUzd3a4eM7KktL6J1V+lVl7ir10uCpZRmBVnUVF' +
    'XmTy8KR5OXUTk185f8Agq3R31OmrZlg3VolwXjKSpWUoWqCNd/xpizYQ6P2iUpIkKOxrr+HN' +
    'NJkv28SBo5410yJt7HPHOKXAkYQ1x1srumUKTliVQDOv3ffSX8Ht0cP/W7dfEcyQlclPKT0G' +
    'ldVYNqSF+k2+on9rUVdklRVF9bpKdTKoBHh+VcdD9mpZYLwV902ht3K3tFMVKubYtIDhuWHZ' +
    'VlhC5Pn5VGra2R45tOTaPdbC3wp3D7VV03bcUMoKitcH5o/AD3VJRaYM2240gWiUOCFoD+it' +
    'dCfIio9kML9AtReptQ4bduS8YkEab7/ADfcKeeTgYS2p1NnleHcUF6KCSDuOQIHsrtLk4R4Q' +
    'GywQEsqatQW1FZSp3YnQnX933UMIwVaEqt/RVJA9HGVydFk931kmu5MFui2rh2bpdVwkmcxU' +
    'dVRtvuabaX2eU0lKPQEpcIWAVBMkSAdR4msmhZt8DdWp0ptMyVySXIIVP8A091WbF21cT6O6' +
    'y7lJByOAxFRThWHunOqxt15u9O88+lPWtixZqWq1t2misAKyneJj7z7aAej5bNlTn0B11ial' +
    '1EgcbNCc+gPe1AmpdZZpAZ5GklMxOUx1FKO1VCC83agx8oEgpMTplMVxyZNHg6RjqLPhiZhH' +
    '2aUUTvlMf3arnVu5ltrcVAUMug72x6UqwW8S2hRhIQO6d9h4fjWF1C1aaL23V2TwkjbKPVXY' +
    'PUeyu0V3OYkpzAhWUg8iKb9Ga/q2vsCkXWIWVkUi9vLe3K5yh10JmOk0W2IWV2optLy3fUBM' +
    'NuhRj1VQPJRlTlSEgDkE0qFdR7K6TG9Jzp+sn20B2D1Hspo27ZJJbaJP9ynQpJ2IPka7QDPo' +
    'zX9U19gUejN/wBU19gVCur95q4W2jgQk/SUZqMrE70RHovtNbUWzNotvR2ubTX2BTiU5RAgD' +
    'oBWFuu2mJMXjlum2t1lCymQFbDnvVnd9o7xjBF4ghprMkJORxJTMkeO2tccmRQrV5NRV8Gp1' +
    '50Vj+y/a28xnFjZXNvboSGyvM0qdvXWwrZWqPIPhObW72uCG05lejIgTvqaxgw67WVZW5Ime' +
    '8NK9T7adj8XxvHzfYeq0DRt0tEPLIMgk8gapP6Pe0epKMHJ6mT/AMtA3aow4w68Mw0dN+8K6' +
    'cNvRu1/xD862x+DvtGQdMJ1MyCQdwfq+FKPwfdo5kN4KPIf/wA0IYZOHXajAZMkZtSNqUMLv' +
    'T/3BGsaqH51tf6O+0XDyEYR83LOs+fzd6D8HnaNSwsjCJHnz/w0BnbW4xFpscK1Z4ZSNMojz' +
    '38aLh+9dahdjbANrH0RvMRv41oj8HfaM7DCBpGkj/lpK/g67SLCgVYWAoQYUR/y0NajOBzEE' +
    'uoKrJiAMmWAARznXwrnGvIKhh1pABnuDl6/CtOPg87RhOXJg5B8D/DXB8HnaMEkJwfXz6fu0' +
    'JqZlkDEUMpaNiwpKRpnSDOkdarLnOLhYcbQ2rmlI0FbwfB72kGxwobjQkTrP1aYd+DLtC86p' +
    'xTmHAnklxQH/wAaEN3bu4WrCbVOIItyQyhJU4k/VmJjoZjxp4XmALSUH0HKCVZVpAgk66Ecy' +
    'PdTNld4Y3YWrd4WA6lhs/KNydtNef504u5wJ5l5ShaKQhJUuGdwkAmNNdxt1rrLlnKPCHVvY' +
    'Jb3Pozjdk060oLyqQBlUAII03iKaWOz6mlEs4epEpbJQkH5xgDQczTj95gzWr3o2iRBLMyIE' +
    'AddFJ9tcRfYI8MiV2is6suUs/OMkDSOs+2smiY7itlbvLZeuWG3EEBSVOQRMRy8RQxi1ncO8' +
    'Ji5YWuYAC9z4aa11piyu2g+2zbOIc72bhDveNOJsmEOJcSwwlSTIKWwIMET7CR6zQDmnFnKj' +
    'PpOusTUuomnF3Rn0nTWJqXWWaQla0oTKp9QmucVr+sR7aHWw6jIomDUB1DNu+htfGUtQzBSQ' +
    'D83YedQoscbPJukaTsfA76VJ9KYz5M4CokgiIquZuLRQLhS+Ertw8cw5HkOp1qVbtNXls3cg' +
    'uDjISrvROuvlQEtLiFzkUlUdDNM3V3bWNtx7x9DLQgFazAmltW6GjKCqIiKj4k6pm1S6lh1/' +
    'KoShpGZXMbeugKh29bucfYumLdT9qphTKbgBKkFRKVCNZ5RtT1w247ibHBfNqWmVmWm0nNJS' +
    'NQQaabYxO7V3Lc2rTrnEDy1JztjeCggidOtVGJIcF85bWOKLXjfEyJCnIBRlCj8n82I8PGgN' +
    'Eba8cGVWK3RH/oN/wANOWLrj1qhTiwVGQTlAmDFZJq17eSc1zlj+6gz7q1eE2t41hjLdxkS6' +
    'lMKmdT10NATLaQ+4Drtr6hUnnTTTbiVd8pI8J/GnedAZ7FGnVXb62G+I4mCEzE6VEZvLS5zp' +
    'CkNuI+cgq12HPbcxUzFMq7x5tQkHQifAUwsM5UpDaTlSEzESBtXoV7HK1wzLXDRN9ePZCUBz' +
    'JmjRPPWpWIPcXsq/wAC6W6sNtAJCYKTmG3nSrrFGraxvErZUYeUO5uoQOR865dKuP8ARta0t' +
    'HIptBSQtJ+kmK+V1F6lfs7xIPwdgo7TLCpzcFUzvuK9UrzLsMpTna1a1ABRZUVeelem17FwJ' +
    'chRSTAkkgRWZXjl0idyQYOZMD1HnUlJR5EYuRqKKw7Pay7eByWxVCspy8j7RV7gOJ3GIOupu' +
    'G0oCQCI3rKyJuiuDSsu6KaL7SSoFUZfnaHTSaPSGfrazERr7K3qXszTHaKbDzZVlG/kaUCk7' +
    'RRNPgj2FUUlKkq2INcC2zqFJPrqixdFJBSdiKQ4BmoDN2mI4Zb2Vs3dlrjN27R1ZzHvCAP56' +
    '1IONYKEqPHZ0TrDCtR7Ks2LAsMNsoWgobSEpzNyYHUzTnozmvfa/wAr9a6Nps5xTSKj42wdT' +
    'Liw4yrgozKTwTIAMRr57eNddxbB7dwpW6wFJUnZkneCCCP3gatvRnPrtdP2X60eir+s1/lfr' +
    'UtGqZVt4/hQBQ3dICUJB7rSgAJj+fOrG1uE3dsi4YWFNuCUnKdR7aX6Kv6zP+V+tKDDw0DrY' +
    'Hg3+tLQpiNOLEpz6E93Uial1HDDuYEuIOomG4J99SKyyoKac4GdJcKM+qUkxI6xTtMu2jDxl' +
    'xsEzO58vwqFIQw+0SllDj0htlLSe/lJykEGQZ3ipVihpi1btmnM4ZTkmZOlc+L7UpylqRr9I' +
    '84/IU4zasMKKmkZSREyaAepBWlCQVqCQdNTFLptxhp2OIkGKA7xWxutPtpsi2D3EIaDu2fTN' +
    'z5+o0gYdaDZke011FhbIBCWtCZOp8fzNAPcVsEAuIlW3e3oDrZJAWmR40x8X2mUJ4QyjYSdK' +
    'E4fapIIa1GxzHrPWgJAcQfpp9td+lUcWFqFZuFr5mpFAV9zhqXLhT/HyZtwpIPLxqKcNJBUi' +
    '+YjXXhDT31crQlYhQmNvCo/xfaAyGhPma1qZNKM0/2UbcCs2JtHirKjLQInw1qS9gK3sN9BV' +
    'ibaWUgJORuFCDO8+FXhw60O7XvNCsPtVklTU5tT3jr765zhGbuSKnXBS4F2UZwnETepu3HlF' +
    'BRCgIrSUltCW0BCRAFKrRW7K3GzFiY+uKx12627clhxCoCM5WCfwrd3lqi7Z4ThUBMyk1WK7' +
    'Ps5szbqgrqpAJ/CuOSDk7R0hJJUzMsLtAgoZ4ClQT3UpJ9tP4G42vGGA3BObvEcvA1bu4DcE' +
    'FKHWyDzIIqRh+AItLlFy4+tbiTICUgCsxxys05qia604UXhBVrMJAEHuDwmkOocTdJK1OGFA' +
    '50pmBlVpt1++rD1UeqtvGmctZEZJFwslbsKIgFGh0Gp0ogF4HgK1OpNS58KJ8K6RWkzLch7K' +
    'C+CuU8v59VcLaVgwysGD91TFd5JGokRIpotLKp4qwOlVyfoiihkDKrNwVggyY51JUdjG4pHC' +
    'XmJ4qxrMUtYJMgUuxVDVxeNsOpbWlZKhIgfz/JoRfMLcbbSVZl7DKdN/wAqfUhKtwDHUUw47' +
    'aMuQ48y2uPpFINYeq+Te3oQMQZKgClYnnExpPLwpab1lbZW1mWNNhEyY50kXNhyubf7aa76R' +
    'Y5SnjsZTuMyYqLV7Lt6Bd/boEkmYJgAnafyNdN/bAxnO8fNNcDlkpWjrBJ6FNPBpA2SnrsKv' +
    'yHxG271hxSUoUSVbSkjlNJRiFusJIURmISBHMzG3lT4aQIhIEbaDSjhomco9gp8iXEbVdsoA' +
    'KyUzPKdt6R8YW8nvK037p/nnT3Bb17iddToPXXeEj6o6bClSFxGVXrCRMk9/JtGvrpPxg0FI' +
    'BSsBSQqY0E0+hhtsEISBmJJ03JrvCQRGUQPAUqfsXEZRfMrcCE5yVEgd08qSjEbdScylFPmN' +
    'tJ1p5DDTaAlCAAnbTalFpB3SPYKVP2W4gy8h9oONmUnYxS64EwIGg8KIPU1tGDtFcg/WNEH6' +
    'xoDtFcg/WNEH6xoDtFcg/WNEH6xoDtFcg/WNEH6xoDtFcg/WNEH6xoDilBJ1UBJgTzNGYTGY' +
    'TTVxbh9ISVqRBmUnWmfixnJlk7k7DmAPwFUhLJggEiTsK7rVc/bWbLaE3F0G0oGmdYHOTv6v' +
    'ZUMv4TxSU3wXJGiBmA9YG1KJZe61xSghOZSgkDckxUNVmy2hCVPQAdM0anTr5e89a6mwZQhS' +
    'M6/lCJMwdNalou5M161yY+kKrvQLZSgBcKJIOmYa9dP52pxmyYS4l1DuaTpqDJpcfYp+iakg' +
    'zCgY0MUJIVOVQMGDHKoXxa0ghXGWAnXUilu2CHVSpxcAkgCOZmrsNyWNdiKSVxtBqGbBla0j' +
    'imUpUIEDefz+6nm2UsNpaSZAncdTNRUCTXlrud+7dddUVLWskk16lyrzRRdaZuXGW0uKbBWQ' +
    'RuBqRPKRMHrFccvg74nVs62zNS22AYmqVXarBrd1sZnXkFOZRQjVPQaxr15DxqwZ7T4KcPF4' +
    'q5KRqOCU/KT+6D75iuOiR17kSyTbCK1OFvpXbIZLgU62nvDcgcp9lZ60YvL5tLrpFpbqAUlt' +
    'pUuKB6r2HknX+9Wlw63atbNDbTaUJ1MJG56nqa3i2ZyyO0SqKKK9BxM52iW85idpaIuXWULQ' +
    'pRLaoM6/lVcqwcJyHE73zDtSu0ToHaC1CT3ksqnw3qP6Qv6xqgMIFxZdqmLT065faeYUpSXV' +
    'yJG33VsqxOGuFfbOyKpn0Zf41tqAKKKKAre0L7lvgtw6ysoWAACDBEms76E7w0rOJXveG3Fq' +
    '77WLSjAHwd1FIHtFUqLhYQADpAoCBi1vc2GHLvWMUvStBTALpjUivQGiVNpJ3KQa8+7QvKVg' +
    'twFHTu//IV6Az+xR+6PuoBdFFFAFFFZy77U2tpi1xaPPoQlmP8Au1E7c4pZVFy4NHRWQuO2l' +
    'q3bZ27houTqlTSwK1bDoeYbdSZStIUCPEUssouPKHKKKKGSm7V3VzZYC9c2ri0KbWjMURmyl' +
    'QBiRA3rz53G3nSnjemPE6kOXKimPIGK9Jx+39KwG/YiSthUecSK8tsmU+jyWSAnWVSQfyrtj' +
    'Vo5ZHQ4HUOJCQyhuTuBJ9tOv3K2m5UtZCdpMxXCosrK1hpKgO6lABM1LssNOJ2Wd9q9UrORk' +
    'CVhBEg7JQfv5V22RySbN+HHLu0ZuWU5w8wCNuYB58q6hl7jIWtJMLk6/va7+IpvCbZ5rB7Vg' +
    '5mS0koCSdcoMJ90VN4LmYninXl0r5k8fzbPdGXxI9xbLKcjSSdD3iRGoP5++h1l5xKlJSQVO' +
    'ZokAgZY++nSw4kftyABSgy7P7Y7RzrHbvwXV+yI7bvkLSlKiCFAd7Tn4+VKSy+p5MoWGyTmG' +
    'bzjn5VJDDmYEumAdta4m2UHM5cnXQVOzvwXWQ+E+18plIX4ncnL+tT8uVKU7wAJOtIFu5Ih2' +
    'AOQpxQiB0FdMWPS2ZnLUjryXFNKDSwhZ2UU5gPVXl7uP4efkXLoAIJA+RQrKfDOFV6pXzde2' +
    'dyziF0w4ysONLUFpymU6x+NdZRszGVGlatuzThLuI3S3n1KJUW2w0gjXZKRpyq+sMW7J2Vup' +
    'hlDQacMqSprNO2hJEnUTrNYaxwG7ulIK8rSFayTJA8q0DOAYJhVsLvFnVuiDCSYCyNYAGp5c' +
    '65yrizaT5o2tv2wwNSsqH1qMbJbJ0rT4XesYhh7V3aqzMuA5TETBI/CvC8Y7ROXbRssOYTY4' +
    'ftwmgElwdVEb+X317B2EYdtuxmGtPIKF8MqgiDClEj3EVqENO5iUrL+uKUEJKlGABJrtQ8W/' +
    'wBmPnoma2zKMVjN00nEF4g8tYCXOFG/0f191RjjmHA6qd9SRRf2DmMKbw+1yJeedLmZZIAga' +
    'zHgKR/R9jBH7eyn99X8NZxu0bmqZK7O3rF72ztVW5WUpt1pOYef516HWJ7K9kL/AAjGRfXb9' +
    'uUpQpIS2SSSfMCttWzAUUUUBl+1i0XJbtFKITBUY6gH9KzbeOWAaTmU5tyTVnjDqW7y4UoE8' +
    'NTgAnqaqLfsDi62EKD1mEqSCAVqkT17tYg7bNyVJEfGMXsrnDXWWFOFaoiU6aEGvVWf2KP3R' +
    '91eaD4PcWUpIXcWaUzqQpRgeWWvTUpypCegiuhg7RRRUAV5t2s7MYu5jNzf4fbi5afIJCFgK' +
    'TA6H8K9JoqNWdMeSWN3E8ftuyvaG8WEOYfwEEiVvLSAB6ta9btG+DaMtTORCUz5CKdookkXJ' +
    'mlk/sFFFFU5CSAQQRINVjGAYQx8yyQf3pV99WtFVNojVjDVvbs6MsNt/uIAp6fA+yu1xRISS' +
    'BJ5DrUKEjx9lEjx9lJLitfkzzozrk/Jn276fyKA482282UOJlPlUROF2iXA4ErzzMnrM/fUt' +
    'TigDDajE7c66FqKgOGd4mfCaqbRKRDawqzZcSttsgoMjwqdPgfZQDIBIg9K7Ru+Qkkcnz9lI' +
    'UnMZH3U5RUKIccQ0kKcUEiYk1Fet8NecLr9vbOKUkStbYVInSTHWnb1CltJCUNL7wkObVFi7' +
    'K8rlvZ5RlAM8tP10psNxSLfCJ7jFlp0QmlLwvC7kJW7h9o6IlJWwk7+YpptZUUrKbEtGM5Sq' +
    'YEaaxrrp/OjiVX6mgWRaxEAAkgbdPXpSl4G/kE4JhCFhaMLsUqGoIt0Aj3VPqPam6Klm6S0k' +
    'QMoQSdef4VIoAqHdOW9zaONekITnRM7mOsVMqAlEs6NW5WcuojKRzq0nyLa4IGG4Za2V6b43' +
    'geCkltACIync6yddKuFXLKcmZwDOMyZ0kfyRUcNucNCUMMRqSkgdfDqKUlt8AAsNFGgiNhOv' +
    '4UUUuCNt8j/AKSzlKg6kpESQZidq6H2ykKCxBBI5HTfSuJZaAIDKACdoGsbUpLTaYyoSIkCB' +
    'tNNgCHm3CQhYUR0pKrhlCilbiUkGDJilIabR8xCU+QimFJCrhYWGoABEgSdCNff7KbDcp7nB' +
    'bfEbpSxfJyqdKlICPnAGSN/fV4bphKZ4iYAqIhDqCki3YBnUiBHvp63bczHjW7SQDoUxv191' +
    'NKXA1Nj6n2k5MywM/zT1pPpdvP7Zv7QpQZa7pLaZTqmR83ypKbW3QCEMNgHokU2G4tp5p5Mt' +
    'LSseBmurcS2AVmAdKS2y23+zQlPkIpN0lSkJyIQs5hovpQB6UxkKuKkhIkwdvVR6Vb/ANe3v' +
    'HzhvUQIfRm4VswkETMCCd538vZ66SAA5C2rXMJnUd0xOuu+36c7SFsm+l239e19oVw3duMsu' +
    'p70xrvBg/fUVWZKilDNsowIBIB9fvp9ln5IJet2pB0CQIAqUhuPIfaWYQ6hR8FA05TaGWkRk' +
    'bQmNBCQKcqAKKKKFCiiigCiiigCiiigCiiigCiiigG3mW30hLqZAUFDzFITZ26SlQbEpiDT9' +
    'FQEZNjboa4aUHLERmP5+Ap5ptDScqBA85pdFC2woooqkOK2MVTptBwG1fF7YUUgmARBBmPaA' +
    'auaKFTK23Z9HcbLVolBUEhZ1MCBOv8AO3jVlRRQMKKKKECq923D185xLVC0wkhZBHXn4e6fG' +
    'rCigKn0RIb0sBIUIBUTvqefWrNoqU2CsQfKKXRUKwoooqkCmn2EPpSleYBJkZTB2j8adooCN' +
    '6CwUxCo3+eaPQms6lAqBUoKMHmBAPuqTRQqbQx6I0VpWQSURlB5RT9FFCWFFFFAFFFFAFFFF' +
    'AFFFFAFFFFAFFFFAFFFFARn7YOrz51pVECDHX86aXYBbeUurmZzTrsPxAPqqdUTFXXWsNuDb' +
    'oUt4oIbCY+cRpvWHCLNKTXBEJs2rktqxBAcKtGy6kEDpE7VJXYJUGhxFDhTB56x+VeVt4PiL' +
    'twlsW8rUsJOVaVlMndQBJAr1TBUOt4PaNP/ALVpoNr1mSnuk+6p24+i65HfQjKvl3tZjvbV1' +
    'u0LaXE8RakuJgg8tOVS6KuiJNbIZs1EQHVp0iEaDfpQbEFeYLUkhASCNxE+PjUyimiI1sh+h' +
    'qBJD7uq51VsOYpHoK0kFNw70Ou+up84qfTdw6hlhbrhASlJJJp24jWyIWLcqLiXcpUqVKC9/' +
    'DfxpSbNXdIuHTBB30MeuserGrRK+Gb1Oqsui5TPTib8q2tg6h+yZcbUFJKBqDI9vOmiI1sfn' +
    'wNdnwNFFbMnJPQ0SehrtFAck9DRJ6Gu02+8i3YcecICG0lSieQAk0A5Pga5J6GvCMUxO7xS9' +
    'eu3rt8JdWVpb4khAJMAa8hHKtR8F1298d3dot9a2yxmCSokAhQ/M1aJZ6fJ6GiT0NdoqFOSe' +
    'hok9DXaKA5PgaJ8DXaKAKKKKAKKKKAKKKKAKKKKAKKKKAKKKKAKxXb/ABJ9rg2TKlIQpJW5l' +
    'UATrAHiOora1lu3GFt3dmi4LiWlNyniK2AI1np50B59m4C0Oi6CAmS2W1wrefUeWtendlcSd' +
    'xHD875l0ABRmRP3V5vZ4U16S0FYhZt51BIUh0LIJOkJGu2mteo4DhrOG2IQyQoKgyB0oCzoo' +
    'ooAooooArC/CViTzNszYslaUujMsp89PuNbqsj2/wADdxKyRdWyAt1gQU66id/GNdPGgPMks' +
    'kw8XG8uilLJ2gajrM9K1XYrH3bC9at31vKtbhzhHOdErVqkgcp1nzms/wAIttpbcKgEoLJaj' +
    'ulRB13jcg1sexPZt5T7WJ4i0kJRKmwomVr2CiPDXfr4VCs9AFFFFUgUUUUAV518JWNvFDuEs' +
    'whpGVTys3eXIJAjpp7Yr0Wsj297ON4nhjl9bNpF7bpzk/1iADI8+ns51VyDD4TgNoWUi7uHw' +
    'XmypUI0bM7AkGdNZHSmbHP2a7WNJsipwIWmOIcpWlWhSdP5gGmsPxfF3rYNtJW+lCcqYZzwk' +
    'awTHKpHZO1PaLtaj4wyuQeM7CYBCfogdJj1VTPk9pooorJoKKKKAKKKKAKKKKAKKKKAKKKKA' +
    'KKKKAKKKKAKKKKAKYv7cXdhcWygIdbUjXxEVU47idzh7yywUwm2LgSpMiQoD8ah4djt7duBD' +
    'nDA+SMpT1eCD7jQGAV2exkH/Zt1I6NmvW8FZXbYLYsOghbdu2lQPIhIms61j+IKwRN4VoLqX' +
    'i2e5ooZRv7Z0qRi2L3zF7dNsuhCWm21JASDqogHfz91Aaeiqfs1iVxiVk85dZCtp3hgpESMq' +
    'TJ8dTVxQBRRRQBSHUhbSkq1CgRVfi969ZqSWSmOEtUESCQtsD3KNUB7TYgFqHyMAkDudFEdf' +
    'CgHThb5VxiyMw+kUd+PPb/h/OtRbIDdu2gJywkCKzNxjl8l+xCFoSm4t0uLSE6A94mPsgUwj' +
    'tDiJs7Z8uIKlqbKhkEEKzyPLuigNlRVT2dxB/ErRx24yZklIGUQNUJP3k1bUAUUUUAVxaQtJ' +
    'SoSCIINVuO3j1lbMOW6gCp9KFSJBBBqga7SYi9cBklpIC0CUo1IKkg7+ZoDD4t2T7QYfitwi' +
    'xs7pduXFFpbEkFJ222Maa1oPgzwPE7LFbm6xC1ft0JZ4aOKkpzEqB0nwT760F3jd83cWCUOJ' +
    'Cbi2Q4sZR84hRMfZAqN/pDiIsba44iCpamyoZBBCs8jy7oq2SjZ0VVdn8QfxG0W7cZMySkDK' +
    'IGqEn7yatahQooooAooooAooooAooooAooooAooooAooooAooooD//Z';
var faviconURI =
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACdU' +
    'lEQVQ4jY2Ta2iNARjHf+97ttNh5rC5xFyzXMsXtSQSUT5QPoxcUjS3j0T2ASVJTdkH5bJcas' +
    'IkpLZl5CxsEofNzpiwyWm2s43mPXZs5/K+798H5lbGr54vz9P/99RTjyEpDPj5Bz1xm5fvP5' +
    'OXm/VrO5oGZAMZ/xJ0RROU3HlLS0eMVfPGk2YaAGkmYA8UfBn+QNGlWkYPTWfb0incCLZR+b' +
    'S9f2ybA4UdV8T6UpTeamDfmQB5U4axfM5YKuoiRD7FAfiroKb+DfPWH2LkUC/nCldSFWzh6t' +
    '0m1i2YSKYvnernnT8FSdum9EYN2/aeZueh89TUvWbS2BF09/SyYf855s7MIX/hLM7fDuExxN' +
    'yp2TSEo6QcF1zJ2nP0sshaJjIWi8GL5Jucr8p79XoQahGzC/Tg2RsFX7VrzpYShSPdevbO0t' +
    'aSJ+qw+iyzN56k9Pp9kPv9njbxzo8Un61gdu44fBk+gk1hJozy4/EYtH7oIWuIF49p0JtwMD' +
    '2mSZY/A1I2YHwr22XMqOGkbIeU4zBkkJek7eAC3nQPtiMkYRhg+rxpHN61hnHTJ0NmJvj9zF' +
    '+xgKLda7l48xGu47IkbwYNLR0gyM0ZTsSKAwb+wekgyZKkyMeoyqvrFHj4QomUrWvVdWLaBh' +
    'UeuyZJWn3girYXl0uSjlc16+DVF3JdWT8Ef1JZG9KOojJ96UvoSFmtZm08robmiNq6+1RwMq' +
    'g7oU5JAwj6KSl/ogmri3U50ChJ2lvWqMILIfUm7f8TNL3rUtXjZsWTjk4H3mrTicdqDP+IWE' +
    'iKDSToJ9DYqc2ngnre+tu+mKH/fOcvCRsrZpOT7fu1Hf0K5C7pVCUOwRoAAAAASUVORK5CYI' +
    'I=';

var mockMostVisitedPages = [
  {
    title: 'Mail',
    url: 'http://mail.google.com',
    thumbnailUrl: thumbnailURI
  },
  {
    title: 'Docs',
    url: 'http://docs.google.com',
    thumbnailUrl: thumbnailURI
  },
  {
    title: 'Calendar',
    url: 'http://www.google.com/calendar',
    thumbnailUrl: thumbnailURI
  },
  {
    title: '',
    url: 'http://www.nytimes.com',
    thumbnailUrl: thumbnailURI
  },
  {
    title: 'Acid3 Test',
    url: 'http://acid3.acidtests.org/',
    thumbnailUrl: thumbnailURI
  },
  {
    title: 'CNN',
    url: 'http://www.cnn.com',
    thumbnailUrl: thumbnailURI
  },
  {
    title: 'Tech Crunch',
    url: 'http://techcrunch.com',
    thumbnailUrl: thumbnailURI
  },
];

var mockBookmarks = [
  {
    title: 'Bookmarks Bar',
    id: '1',
    root: true,
    bookmarks:
      [
        {
          title: 'Docs',
          url: 'http://docs.google.com',
          icon: docsURI,
          editable: true
        },
        {
          title: 'Calendar',
          url: 'http://www.google.com/calendar',
          icon: calendarURI,
          editable: true
        },
        {
          title: 'Recipes',
          folder: true,
          id: '2',
          editable: false
        },
        {
          title: 'Acid3 Test',
          url: 'http://acid3.acidtests.org/',
          icon: acid3URI,
          editable: true
        }
      ]
  },
  {
    title: 'Recipes',
    id: '2',
    root: false,
    bookmarks:
      [
        {
          title: 'Chicken Noodle Soup that happens to have a really long ' +
                 'name, it\'s so long it gets ellipsized',
          url: 'http://docs.google.com',
          icon: nytimesURI,
          editable: true
        },
        {
          title: 'Pizza',
          url: 'http://www.google.com/buzz',
          icon: ipadURI,
          editable: true
        },
        {
          title: 'Desserts Really Really Really Really Long Title',
          id: '3',
          folder: true,
          editable: true
        },
        {
          title: 'Empty',
          id: '4',
          folder: true,
          editable: true
        }
      ],
    hierarchy:
      [
        {
          root: true
        }
      ]
  },
  {
    title: 'Desserts Really Really Really Really Long Title',
    id: '3',
    root: false,
    bookmarks:
      [
        {
          title: '<b>Cake</b>',
          url: 'http://www.google.com',
          icon: gmailURI,
          editable: true
        },
        {
          title: 'Cupcake',
          url: 'http://www.google.com',
          icon: faviconURI,
          editable: true
        }
      ],
    hierarchy:
      [
        {
          title: 'Recipes',
          id: '2'
        },
        {
          root: true
        }
      ]
  },
  {
    title: 'Empty',
    id: '4',
    root: false,
    bookmarks: [],
    hierarchy:
      [
        {
          title: 'Recipes',
          id: '2'
        },
        {
          root: true
        }
      ]
  }
];


var mockRecents = [
  {
    title: 'Picasaweb has a really long title when i don\'t think it should',
    url: 'http://picasaweb.google.com/m/viewer',
    icon: picasaURI
  },
  {
    title: 'Acid3 Test',
    url: 'http://acid3.acidtests.org/',
    icon: twitterURI
  },
];

var mockSyncedDevices = [
  {title: 'iPad', icon: ipadURI},
  {title: 'Laptop', icon: laptopURI},
  {title: 'Desktop', icon: computerURI}
];

var mockForeignSessions = [
  { // Client 1
    name: 'Test Clientzor 1',
    tag: 'session_syncXch...',
    windows: [
      { // Window 1
        deviceType: 'tablet',
        sessionId: 1,
        tabs: [
          {
            title: 'chrome://setings/personal',
            url: 'chrome://settings/personal',
            icon: docsURI,
            sessionId: 2
          },
          {
            title: 'Amazon.com: The Hunger Games',
            url: 'http://www.amazon.com/Hunger-Games-Suzanne-Collins/dp/' +
                 '0439023483',
            icon: docsURI,
            sessionId: 3
          },
        ],
        timestamp: 10
      },
      { // Window 2
        deviceType: 'tablet',
        sessionId: 3,
        tabs: [
          {
            title: 'Electronics store at Amazon.com',
            url: 'http://www.amazon.com/electronics-store/' +
                 'b?ie=UTF8&node=172282',
            icon: docsURI,
            sessionId: 4
          }
        ],
        timestamp: 50
      }
    ]
  },
  { // Client 2
    name: 'Moooo!',
    tag: 'session_syncXch...',
    windows: [
      { // Window 1
        deviceType: 'macosx',
        sessionId: 5,
        tabs: [
          {
            title: 'Amazon.com: Containment eBook',
            url: 'http://www.amazon.com/Containment-ebook/dp/B0039PT4BO',
            icon: gmailURI,
            sessionId: 6
          },
        ]
      }
    ],
  }
];

/////////////////////////////////////////////////////////////////////////////
// Mocks section:
//     Definitions that allow the NTP to be tested from a desktop browser.
/////////////////////////////////////////////////////////////////////////////
PRESS_START_EVT = 'mousedown';
PRESS_STOP_EVT = 'mouseup';
PRESS_MOVE_EVT = 'mousemove';

function getMockBookmarkData(folder_id) {
  if (folder_id != null) {
    for (var i = 0; i < mockBookmarks.length; ++i) {
      if (mockBookmarks[i].id == folder_id) {
        return mockBookmarks[i];
      }
    }
  }

  for (var i = 0; i < mockBookmarks.length; ++i) {
    if (mockBookmarks[i].root === true) {
      return mockBookmarks[i];
    }
  }

  // Shouldn't get here
  return null;
}

/**
 * Override the send function and return the appropriate mock data.
 * @param {string} funcName The name of the function being called.
 * @param {Array} opt_args Optional arguments to pass to the function.
 */
window.chrome.send = function(funcName, opt_args) {
  if (funcName == 'getMostVisited') {
    ntp.setMostVisitedPages(mockMostVisitedPages, false, false);
  } else if (funcName == 'getRecentlyClosedTabs') {
    ntp.setRecentlyClosedTabs(mockRecents);
  } else if (funcName == 'getBookmarks') {
    if (opt_args && opt_args.length == 1) {
      ntp.bookmarks(getMockBookmarkData(opt_args[0]));
    } else {
      ntp.bookmarks(getMockBookmarkData(null));
    }
  } else if (funcName == 'getForeignSessions') {
    ntp.setForeignSessions(mockForeignSessions, true);
    ntp.snapshots([]);
    ntp.setSyncEnabled(true);
  } else if (funcName == 'openForeignSession') {
    // Try to find the requested session in mock data
    for (var i = 0; i < mockForeignSessions.length; i++) {
      var windows = mockForeignSessions[i].windows;
      for (var j = 0; j < windows.length; j++) {
        var tabs = windows[j].tabs;
        for (var k = 0; k < tabs.length; k++) {
          if (windows[j].sessionTag == opt_args[0] &&
              j == opt_args[1] &&
              tabs[k].sessionId == opt_args[2]) {
            window.location = tabs[k].url;
          }
        }
      }
    }
  } else if (funcName == 'getFaviconDominantColor') {
    // use setTimeout to post to end of event queue, so the item can be
    // inserted into doc.
    setTimeout(
        'ntp.setFaviconDominantColor(' + opt_args[1] + ', "#FF0000");', 0);
  }
};

/**
 * Overrides getTouchEventX in ntp_android.js.
 * @param {BrowserEvent} evt The touch event triggered by the browser.
 * @return {number} The page Y coordinate of the "touch" event (we are dealing
 *     with click events instead of touch events when mocking).
 */
window.getTouchEventX = function(evt) {
  return evt.pageX;
};

/**
 * Overrides getTouchEventY in ntp_android.js.
 * @param {BrowserEvent} evt The touch event triggered by the browser.
 * @return {number} The page X coordinate of the "touch" event (we are dealing
 *     with click events instead of touch events when mocking).
 */
window.getTouchEventY = function(evt) {
  return evt.pageY;
};

/** Mock data, normally generated by native C++ code. */
window.templateData = {
  device: 'tablet',
  title: 'New Tab',
  mostvisited: 'Most Visited',
  remotetabs: 'Open Tabs'
};
