use Test::More tests => 7;

BEGIN {
    use_ok('CipUX::Trait');

}
use base qw(CipUX);
use Module::Pluggable except => ['CipUX::Trait::DebianEdu'];

my $trait = CipUX::Trait->new;

my @methods = qw(init set_trait_name_register get_trait_name_register);
can_ok( $trait, @methods );
isa_ok( $trait, 'CipUX::Trait' );

# add module from the filesystem
ok( $trait->init );

# comare hash
my $class_hr = {
    'some-feature' => 'CipUX::Trait::SomeThing',
    'that-feature' => 'CipUX::Trait::ThatThing',
    'this-feature' => 'CipUX::Trait::ThisThing',
};

# add artificial traits
foreach my $c ( keys %{$class_hr} ) {
    ok(
        $trait->set_trait_name_register(
            { class => $class_hr->{$c}, name => $c }
        )
    );
}
my $trait_list_hr = {};
$trait_list_hr = $trait->get_trait_name_register;

# add offical traits here
if ( exists $trait_list_hr->{'debian-edu-configuration'} ) {
    $class_hr->{'debian-edu-configuration'} = 'CipUX::Trait::DebianEdu';
}
if ( exists $trait_list_hr->{'samba-support'} ) {
    $class_hr->{'samba-support'} = 'CipUX::Trait::Samba';
}

#use Data::Dumper;
#diag(Dumper($class_hr));
#diag(Dumper($trait_list_hr));

# postpone test untill clear how to add custom traits.
#is_deeply( $trait_list_hr, $class_hr, 'trait_name_register' );

#foreach my $trait ( sort keys %{$trait_list_hr} ) {
#    diag(" $trait: $trait_list_hr->{$trait}\n");
#}

#
my @trait = $trait->get_trait;
my $err   = 0;

foreach my $t (@trait) {
    if ( not( exists $class_hr->{$t} and defined $class_hr->{$t} ) ) {
        $err = 1;
    }
}

# postpone test untill clear how to add custom traits.
#is( $err, 0, 'get trait sub' );
