/*
 * This file is part of the Code::Blocks IDE and licensed under the GNU Lesser General Public License, version 3
 * http://www.gnu.org/licenses/lgpl-3.0.html
 */

#ifndef VIRTUALBUILDTARGETSDLG_H
#define VIRTUALBUILDTARGETSDLG_H

#include <wx/wxprec.h>

//(*Headers(VirtualBuildTargetsDlg)
#include <wx/checklst.h>
#include <wx/button.h>
#include "scrollingdialog.h"
#include <wx/listbox.h>
//*)

class cbProject;

class VirtualBuildTargetsDlg: public wxScrollingDialog
{
    public:

        VirtualBuildTargetsDlg(wxWindow* parent,wxWindowID id, cbProject* project);
        virtual ~VirtualBuildTargetsDlg();

        //(*Identifiers(VirtualBuildTargetsDlg)
        //*)

    protected:

        //(*Handlers(VirtualBuildTargetsDlg)
        void OnAddClick(wxCommandEvent& event);
        void OnEditClick(wxCommandEvent& event);
        void OnRemoveClick(wxCommandEvent& event);
        void OnAliasesSelect(wxCommandEvent& event);
        void OnTargetsToggled(wxCommandEvent& event);
        //*)

        void OnUpdateUI(wxUpdateUIEvent& event);

        //(*Declarations(VirtualBuildTargetsDlg)
        wxCheckListBox* lstTargets;
        wxButton* btnEdit;
        wxButton* btnRemove;
        wxButton* btnAdd;
        wxListBox* lstAliases;
        //*)

        void SetVirtualTarget(const wxString& targetName);
        void CheckTargets();
        cbProject* m_pProject;

    private:

        DECLARE_EVENT_TABLE()
};

#endif
