---
layout: api
page_title: HTTP API
sidebar_current: api-introduction
description: |-
  Consul exposes a RESTful HTTP API to control almost every aspect of the
  Consul agent.
---

# HTTP API Structure

The main interface to Consul is a RESTful HTTP API. The API can perform basic
CRUD operations on nodes, services, checks, configuration, and more.

## Authentication

When authentication is enabled, a Consul token should be provided to API
requests using the `X-Consul-Token` header or with the
 Bearer scheme in the authorization header. 
This reduces the probability of the
token accidentally getting logged or exposed. When using authentication,
clients should communicate via TLS. If you don’t provide a token in the request, then the agent default token will be used.


Below is an example using `curl` with `X-Consul-Token`.

```sh
$ curl \
    --header "X-Consul-Token: <consul token>" \
    http://127.0.0.1:8500/v1/agent/members
```

Below is an example using `curl` with Bearer scheme.

```sh
$ curl \
    --header "Authorization: Bearer <consul token>" \
    http://127.0.0.1:8500/v1/agent/members
```

Previously this was provided via a `?token=` query parameter. This functionality
exists on many endpoints for backwards compatibility, but its use is **highly
discouraged**, since it can show up in access logs as part of the URL.

To learn more about the ACL system read the [documentation](/docs/acl/acl-system.html).

## Version Prefix

All API routes are prefixed with `/v1/`. This documentation is only for the v1 API.

## Formatted JSON Output

By default, the output of all HTTP API requests is minimized JSON. If the client
passes `pretty` on the query string, formatted JSON will be returned.

## HTTP Methods

Consul's API aims to be RESTful, although there are some exceptions. The API
responds to the standard HTTP verbs GET, PUT, and DELETE. Each API method will
clearly document the verb(s) it responds to and the generated response. The same
path with different verbs may trigger different behavior. For example:

```text
PUT /v1/kv/foo
GET /v1/kv/foo
```

Even though these share a path, the `PUT` operation creates a new key whereas
the `GET` operation reads an existing key.

Here is the same example using `curl`:

```shell
$ curl \
    --request PUT \
    --data 'hello consul' \
    http://127.0.0.1:8500/v1/kv/foo
```

## Translated Addresses

Consul 0.7 added the ability to translate addresses in HTTP response based on
the configuration setting for
[`translate_wan_addrs`](/docs/agent/options.html#translate_wan_addrs). In order
to allow clients to know if address translation is in effect, the
`X-Consul-Translate-Addresses` header will be added if translation is enabled,
and will have a value of `true`. If translation is not enabled then this header
will not be present.

## UUID Format

UUID-format identifiers generated by the Consul API use the
[hashicorp/go-uuid](https://github.com/hashicorp/go-uuid) library.

These UUID-format strings are generated using high quality, purely random bytes.
It is not intended to be RFC compliant, merely to use a well-understood string
representation of a 128-bit value.



