// Bug: free uninitialized pointer
// Fix: https://code.wireshark.org/review/gitweb?p=wireshark.git;a=commit;h=28960d79cca262ac6b974f339697b299a1e28fef

void *malloc(unsigned long);
void free(void *);

struct comment {
  int *data;
};

struct table {
  struct comment *com;
};

void destroy_table(struct table *comment_table)
{
    free(comment_table->com->data);
    free(comment_table->com);
    free(comment_table);
}

void f()
{
    struct table *comment_table = (struct table *)malloc(sizeof(struct table));
    struct comment *comment_rec = (struct comment *)malloc(sizeof(struct comment));
    comment_table->com = comment_rec;
    destroy_table(comment_table);
}


