<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>

<xsl:template match="/">
  <html>
    <head>
      <title>Crossroads Status Overview</title>
      <style type="text/css">
	h1 {
	  font-family: Verdana,Helvetica;
	  font-size: 12pt;
	  color: blue;
	}
	body {
	  font-family: Verdana,Helvetica;
	  font-size: 10pt;
	}
	td {
	  font-family: Verdana,Helvetica;
	  font-size: 10pt;
	}
	.backend { background-color: #f3f099; }
	.info   { font-size: 8pt; background-color: #ffff99; }
	.footer { color: gray; }
      </style>
    </head>
    <body>
      <h1>XR Status Overview</h1>
      <hr/>
      <xsl:apply-templates/>
    </body>
  </html>
</xsl:template>

<xsl:template match="/status">
  <table>
    <xsl:apply-templates/>
  </table>
</xsl:template>

<xsl:template match="/status/backend">
  <tr> <td colspan="2"></td></tr>
  <tr>
    <td class="backend" colspan="2">
      <b> Back end <xsl:value-of select="address"/> </b>
    </td>
  </tr>
  <tr>
    <td class="info">Weight</td>
    <td class="info"><xsl:value-of select="weight"/></td>
  </tr>
  <tr>
    <td class="info">Max. connections</td>
    <td class="info"><xsl:value-of select="maxconnections"/></td>
  </tr>
  <tr>
    <td class="info">Host match</td>
    <td class="info"><xsl:value-of select="hostmatch"/></td>
  </tr>
  <tr>
    <td class="info">Health state</td>
    <td class="info"><xsl:value-of select="live"/></td>
  </tr>
  <tr>
    <td class="info">Availability</td>
    <td class="info"><xsl:value-of select="available"/></td>
  </tr>
  <tr>
    <td class="info">Connections</td>
    <td class="info"><xsl:value-of select="connections"/></td>
  </tr>
  <tr>
    <td class="info">Bytes served</td>
    <td class="info"><xsl:value-of select="bytesserved"/></td>
  </tr>
  <tr>
    <td class="info">Clients served</td>
    <td class="info"><xsl:value-of select="clientsserved"/></td>
  </tr>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>

