#include "backend"

bool Backend::connect() {
    PROFILE("Backend::connect");
    
    // Assume the backend is dead
    islive = false;

    debugmsg ("About to connect to back end " + description() + "\n");
    
    // Create client socket
    if ( (clsocket = socket (PF_INET, SOCK_STREAM, 0)) < 0 )
	throw Error(string("Failed to create client socket: ") +
		    strerror(errno));

    // Resolve hostname, prepare binding
    struct sockaddr_in backendaddr;
    
    backendaddr.sin_family = AF_INET;
    backendaddr.sin_port = htons(bdef.port());
    backendaddr.sin_addr.s_addr = dnsentry.resolve(bdef.server());

    // Client socket goes into nonblocking mode, so we can connect
    // and enforce a timeout later.
    int flags;
    if ( (flags = fcntl (clsocket, F_GETFL, 0)) == -1 ) {
	socketclose (clsocket);
	throw Error(string("Failed to get fd flags: ") + strerror(errno));
    }    
    if (fcntl (clsocket, F_SETFL, flags | O_NONBLOCK) == -1) {
	socketclose (clsocket);
	throw Error(string("Failed to fd in nonblocking mode: ") +
		    strerror(errno));
    }

    // Do the connect
    int conres = ::connect (clsocket, (struct sockaddr *)&backendaddr,
			 sizeof(backendaddr));
    int conerrno = errno;
    debugmsg((Mstr("Connect result: ") + conres) +
	     (Mstr(", errno: ") + conerrno) + "\n");

    // Put socket again in blocking mode.
    if (fcntl (clsocket, F_SETFL, flags) == -1) {
	socketclose (clsocket);
	throw Error(string("Failed to put fd in blocking mode: ") +
		    strerror(errno));
    }
    
    // Check on the outcome of the connect
    if (!conres || conerrno == EINPROGRESS) {
	// Wait for socket to go writable.
	Fdset fdset (config.backend_write_timeout());
	fdset.add (clsocket);
	fdset.wait_rw();

	debugmsg(Mstr("Connecting to ") + description() + "\n");
	
#	ifdef CONNECTCHECK_ONLY_WRITABLE
	if (fdset.writeable(clsocket))
	    islive = true;
	else {
	    markconnecterror();
	    socketclose(clsocket);
	}
#	else	
	if (fdset.writeable(clsocket) && !fdset.readable(clsocket))
	    islive = true;
	else {
	    socketclose(clsocket);
	    markconnecterror();
	}
#	endif	
    }

    debugmsg ((Mstr("Back end ") + description()) +
	      (Mstr(" is ") + livestr()) +
	      (Mstr(" (socket ") + clsocket) + ")\n");
    
    return (islive);
}
