#include "balancer"

void Balancer::init() {
    // Set the listening socket.
    if (config.stype() != Servertype::t_udp) {
	if (config.sport())
	    server_fd = serversocket(config.sipaddr(), config.sport(),
				     "balancer", Servertype::t_tcp);
	else
	    server_fd = 0;
    } else {
	server_fd = serversocket(config.sipaddr(), config.sport(),
				 "balancer", Servertype::t_udp);
    }
    
    // Start the web interface if requested.
    if (config.usewebinterface() && !config.foregroundmode()) {
	webinterface = new Webinterface();
	if (! webinterface)
	    throw Error("Memory fault in Balancer::init");
	webinterface->start();
    }

    // Add workable back ends, display initial states.
    for (int i = 0; i < config.backends(); i++)
	addbackend (config.backend(i));

    if (config.verbose()) {
	for (unsigned i = 0; i < nbackends(); i++)
	    _msg ("Initial backend state: " + backend(i).description() +
		  " is " + backend(i).availablestr() + "\n");
    }
}
