//
// C++ Implementation: datainputstream
//
// Description:
//
//
// Author: Rikard Bjorklind <olof@linux.nu>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "datainputstream.h"
#include <netinet/in.h>

#include "rpcexception.h"

#include <boost/scoped_array.hpp>

using std::string;

namespace rpc
{

DataInputStream::DataInputStream( CmdInputBufferPtr buf ) : data( buf )
{
}

int DataInputStream::readInt()
{
	checkRead( 4 );
	int i = *(reinterpret_cast<int*>(data->curPtr()));
	i = ntohl(i);
	data->advance( 4 );
	return i;
}

char DataInputStream::readByte()
{
	checkRead( 1 );
	char ch = *(data->curPtr());
	data->advance( 1 );
	return ch;
}

short DataInputStream::readShort()
{
	checkRead( 2 );
	short s = *(reinterpret_cast<short*>(data->curPtr()));
	s = ntohs(s);
	data->advance( 2 );
	return s;
}

bool DataInputStream::readBool()
{
	checkRead( 1 );
	char ch = *(data->curPtr());
	data->advance( 1 );
	return ch!=0;
}

int64 DataInputStream::readLong()
{
	checkRead( 8 );
	uint32_t l1 = *(reinterpret_cast<uint32_t*>(data->curPtr()));
	data->advance( 4 );
	uint32_t l2 = *(reinterpret_cast<uint32_t*>(data->curPtr()));
	data->advance( 4 );

	l1 = ntohl(l1);
	l2 = ntohl(l2);

	int64 l = ((int64)l1<<32)+l2;
	
	return l;
}

string DataInputStream::readUTF()
{
	// one int for length, rest is the string
	int length = readInt();
	checkRead( length );
	// Allocate space for string
	boost::scoped_array<char> str( new char[length+1] );
	// Copy date from buffer
	memcpy( str.get(), data->curPtr(), length );
	// Null-terminate
	str.get()[length] = '\0';
	// Create string to return
	string ret = str.get();
	// Advance the buffer past the string
	data->advance( length );
	
	return ret;
}

DataInputStream::~DataInputStream()
{}

void DataInputStream::checkRead( int i )
{
	if(data->remaining() < i) throw RpcException( "EndOfStream" );
} 

}

