//
// C++ Implementation: filelog
//
// Description: 
//
//
// Author: Arsenij Vodjanov <arsenij@gmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "filelog.h"
#include <QDateTime>
#include <QFile>
#include <QTextStream>

#define FLOG_ENABLE

// This should be retrieved from gui settings
#define FLOG_FILE_NAME "/tmp/qtclient.log"


FileLog::FileLog() { 
    time.start();
    QString msg("--- New log started on %1");
    printMessage(msg.arg(QDateTime::currentDateTime().toString("ddd MMMM d yyyy")));
}

void FileLog::info(const char* format, ...)
{
#ifdef FLOG_ENABLE
    va_list va;
    va_start(va,format);
    printMessage(format,va);
	va_end(va);
#endif
}

void FileLog::info(const QString& msg) {
#ifdef FLOG_ENABLE
    printMessage(msg);
#endif
}

void FileLog::error(const char* format, ...)
{
#ifdef FLOG_ENABLE
    va_list va;
    va_start(va,format);
    printMessage(format,va);
	va_end(va);
#endif
}

void FileLog::error(const QString& msg)
{
#ifdef FLOG_ENABLE
    printMessage(msg);
#endif
}

void FileLog::warn(const char* format, ...)
{
#ifdef FLOG_ENABLE
    va_list va;
    va_start(va,format);
    printMessage(format,va);
    va_end(va);
#endif
}

void FileLog::warn(const QString& msg)
{
#ifdef FLOG_ENABLE
    printMessage(msg);
#endif
}

void FileLog::debug(const char* format, ...)
{
#ifdef FLOG_ENABLE
    va_list va;
    va_start(va,format);
    printMessage(format,va);
    va_end(va);
#endif
}

void FileLog::debug(const QString& msg)
{
#ifdef FLOG_ENABLE
    printMessage(msg);
#endif
}

void FileLog::msg(const QString& msg,const QColor&)
{
#ifdef FLOG_ENABLE
    printMessage(msg);
#endif
}

FileLog::~FileLog()
{
#ifdef FLOG_ENABLE
    printMessage("--- End of log");
#endif
}

void FileLog::printMessage(const QString msg)
{
#ifdef FLOG_ENABLE
    time.restart();

    QFile file(FLOG_FILE_NAME);
    if (!file.open(QIODevice::Append | QIODevice::Text))
        return;

    QTextStream out(&file);
    out << time.toString("hh:mm:ss.zzz") << ": " << msg;
	if (!msg.endsWith("\n"))
		out << endl;

    file.close();
#endif
}

void FileLog::printMessage(const char* format, va_list va)
{
#ifdef FLOG_ENABLE
    QString msg;
    msg.vsprintf(format,va);
    printMessage(msg);
#endif
}
