/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.Pattern;
import com.stevesoft.pat.PatternSub;
import com.stevesoft.pat.Pthings;
import com.stevesoft.pat.RegSyntax;
import com.stevesoft.pat.RegSyntaxError;
import com.stevesoft.pat.patInt;
import java.util.Hashtable;

class FastMulti
extends PatternSub {
    patInt fewestMatches;
    patInt mostMatches;
    public boolean matchFewest = false;
    int step = -1;

    public patInt minChars() {
        return this.sub.countMinChars().mul(this.fewestMatches);
    }

    public patInt maxChars() {
        return this.sub.countMaxChars().mul(this.mostMatches);
    }

    FastMulti(patInt a, patInt b, Pattern p) throws RegSyntax {
        if (p == null) {
            RegSyntaxError.endItAll("Null length pattern followed by *, +, or other Multi.");
        }
        this.fewestMatches = a;
        this.mostMatches = b;
        this.sub = p;
        this.step = p.countMinChars().intValue();
        this.sub.setParent(null);
    }

    public String toString() {
        return this.sub.toString() + "{" + this.fewestMatches + "," + this.mostMatches + "}" + (this.matchFewest ? "?" : "") + "(?# <= fast multi)" + this.nextString();
    }

    public int matchInternal(int pos, Pthings pt) {
        int nMatches;
        int m = -1;
        int i = pos;
        int endstr = pt.src.length() - this.step;
        patInt matches = new patInt(0);
        if (this.matchFewest) {
            int ii;
            if (this.fewestMatches.lessEq(matches) && (ii = this.nextMatch(i, pt)) >= 0) {
                return ii;
            }
            while (i >= 0 && i <= endstr) {
                if ((i = this.sub.matchInternal(i, pt)) < 0) continue;
                matches.inc();
                if (this.fewestMatches.lessEq(matches) && (ii = this.nextMatch(i, pt)) >= 0) {
                    return ii;
                }
                if (!matches.equals(this.mostMatches)) continue;
                return -1;
            }
            return -1;
        }
        for (nMatches = 0; this.fewestMatches.intValue() > nMatches; ++nMatches) {
            if ((i = this.sub.matchInternal(i, pt)) >= 0) {
                continue;
            }
            return -1;
        }
        m = i;
        if (this.mostMatches.finite()) {
            while (nMatches < this.mostMatches.intValue() && (i = this.sub.matchInternal(i, pt)) >= 0) {
                m = i;
                ++nMatches;
            }
        } else {
            while ((i = this.sub.matchInternal(i, pt)) >= 0) {
                m = i;
                ++nMatches;
            }
        }
        while (m >= pos) {
            int r = this.nextMatch(m, pt);
            if (r >= 0) {
                return r;
            }
            m -= this.step;
            if (--nMatches >= this.fewestMatches.intValue()) continue;
            return -1;
        }
        return -1;
    }

    public Pattern clone1(Hashtable h) {
        try {
            FastMulti fm = new FastMulti(this.fewestMatches, this.mostMatches, this.sub.clone(h));
            fm.matchFewest = this.matchFewest;
            return fm;
        }
        catch (RegSyntax rs) {
            return null;
        }
    }
}

