/* $Id: ConstantDeclaration.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CONSTANT_DECLARATION_HPP_INCLUDED
#define __CONSTANT_DECLARATION_HPP_INCLUDED

#include "frontend/ast/ValDeclaration.hpp"
#include "frontend/visitor/Visitor.hpp"
#include "frontend/ast/Expression.hpp"

namespace ast {

//! A VHDL constant declaration.
/** This class represents a declaration of a VHDL constant.
 *  A constant must never be target of an assignment statement.
 *  (it can change though, e.g. the loop parameter of an iteration scheme).
 */
class ConstantDeclaration : public ValDeclaration {
public:
	/** c'tor
	 *  @param declName the declared name 
	 *  @param varInit initializer Expression for the constant.
	 *  @param subtype subtype indication of the constant.
	 *  @param fValue has the constant a fixed value?
	 *  @param loc location of the ConstantDeclaration.
	 */
	ConstantDeclaration(
		std::string* declName,
		Expression* varInit,
		SubtypeIndication* subtype,
		bool fValue,
		Location loc
		) :	ValDeclaration(ValDeclaration::MODE_IN, 
					declName, 
					varInit,
					subtype,
					ValDeclaration::OBJ_CLASS_CONSTANT,
					loc),
			fixedValue(fValue) {}
	
	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name != NULL);
		stream << "CONSTANT " << *this->name << " : "
			<< this->subtypeIndic;

		if (this->init != NULL) {
			stream << " := " << *this->init;
		}
		stream << ';';
	}

	/** true, if the constant will always evaluate to the same value. */
	bool fixedValue;

};
	
}; /* namespace ast */

#endif /* __CONSTANT_DECLARATION_HPP_INCLUDED */
