/* $Id: SigAssignStat.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_ASSIGN_STAT_HPP_INLCUDED
#define __SIG_ASSIGN_STAT_HPP_INLCUDED

#include "frontend/ast/SeqStat.hpp"
#include "frontend/ast/Name.hpp"
#include "frontend/ast/WaveFormElem.hpp"

namespace ast {

/** Signal assign statement */
class SigAssignStat : public SeqStat {
public:
	//! c'tor
	/** @param trg target of the SigAssignStat.
          * @param waveFrm WaveForm that should get assigned.
	  * @param loc location of the SigAssignStat.
          */
	SigAssignStat(
		Name *trg, 
		std::list<WaveFormElem*> *waveFrm,
		Location loc
		) : 	SeqStat(loc),
			target(trg), 
			waveForm(waveFrm) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
        *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << this->target << " <= ";
		util::MiscUtil::listPut(this->waveForm, stream, ", ");
		stream << ';';
	}


	/** target */	
	Expression *target;

	/** WaveForm that should get assigned to target */
	std::list<WaveFormElem*> *waveForm;

protected:
	/** Destructor */
	virtual ~SigAssignStat() {
		util::MiscUtil::terminate(target);
		util::MiscUtil::lterminate(waveForm);
	}
};

};

#endif /* __SIG_ASSIGN_STAT_HPP_INLCUDED */
