-- $Id: proc_formal2.vhdl 4327 2009-01-27 14:41:18Z potyra $ 

-- generating implicit formals for procedure parameters.

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


package t is 
	type byte is array(integer range 0 to 7) of bit;
	function foo(constant a : in byte) return bit;
end package t;

package body t is
	function foo(constant a : in byte) return bit is
		variable ret : bit;
	begin
		ret := '0';
		for i in a'range loop
			if a(i) = '1' then 
				ret := '1';
			end if;
		end loop;
		return ret;
	end;
end t;

entity test_bench is
end entity test_bench;

use t.all;
architecture test_bench_impl of test_bench is
begin
	p : process
		variable x : bit;
	begin
		x := foo("00001000");
		assert(x = '1') 
			report "foo() should return '1'."
			severity failure;

		x := foo("00000000");
		assert(x = '0')
			report "foo() should return '0'."
			severity failure;

		assert false report "simulation finished" severity note;
		wait;
	end process;
end test_bench_impl;
