/*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE.  
*
*/



/* ferret.c
 *
 * Jonathan Callahan (after Oct 96)
 *
 * I believe this file was originally generated by the UIM/X
 * software.  I am making modifications so that no X calls
 * are made if the GUI is not being used.
 *
 * I will also fold in the three files named FerretMain_mycode_#.c
 ** Linux Port     - 5/97 - *kob* Using NAG f90 for linux, we first have to 
 *                         call f90_io_init() to set up lun's etc, and then
 *                         call f90_io_finish() after we are done to flush 
 *                         buffers,etc
 */

/* *acm   9/06 v600 - add stdlib.h wherever there is stdio.h for altix build*/ 

/*-----------------------------------------------------------
 * This is the project main program file for Xt generated 
 * code. You may add application dependent source code 
 * at the appropriate places. 
 * 			     
 * Do not modify the statements preceded by the dollar
 * sign ($), these statements will be replaced with
 * the appropriate source code when the main program is  
 * generated.  
 *
 * $Date: 2006/09/13 20:34:13 $  		$Revision: 1.4 $ 
 *-----------------------------------------------------------*/ 

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xlib.h>
#include <stdlib.h>
#include <stdio.h>

/*---------------------------------------------------- 
 * UxXt.h needs to be included only when compiling a 
 * stand-alone application. 
 *---------------------------------------------------*/
#ifndef DESIGN_TIME
#include "UxXt.h"
#endif /* DESIGN_TIME */

XtAppContext	UxAppContext;
Widget		UxTopLevel;
Display		*UxDisplay;
int		UxScreen;
char init_command[128];
extern void SetInitialState(void);

/*----------------------------------------------
 * Insert application global declarations here
 *---------------------------------------------*/
/*
 * BEGIN of "FerretMain_mycode_1.c"
 *
 * Here are the contents of the file "FerretMain_mycode_1.c"
 * which was previously included as a separate file.
 */

#define __globalDefs

#include "ferret_shared_buffer.h"
#include "ferret.h"
#include "ferret_structures.h"

#include "JC_Utility.h" /* for windows[] and window_count in the SGI_POPUPS section */

#undef __globalDefs

/* .................... Function Definitions .................... */

void help_text(void);
static void TimeOutCB(XtPointer cd, XtIntervalId *id);

/* .................... Function Declarations .................... */

void help_text()
{
  printf(
	" Usage:  ferret [-memsize Mwords] [-unmapped] [-help]\n\
       -memsize:  specify the memory cache size in megawords (default 3.2)\n\
      -unmapped:  use invisible output windows (for animations and GIF files)\n\
           -gui:  to start Ferret in point and click mode\n\
          -help:  obtain this listing\n");
  exit(0);
}

static void TimeOutCB(XtPointer cd, XtIntervalId *id)
{
  XtAppAddTimeOut((XtAppContext)cd, (unsigned long)2000, TimeOutCB, cd);
  
#ifdef NO_ENTRY_NAME_UNDERSCORES
  xgks_x_events();
#else
  xgks_x_events_();
#endif

}

/*
 * END of "FerretMain_mycode_1.c"
 */


/*
 * Here is the beginning of the "main" program.
 */
#ifdef _NO_PROTO
main(argc,argv)
  int     argc;
char    *argv[];
#else
main( int argc, char *argv[])
#endif /* _NO_PROTO */
{
  char *home;
  FILE *fp;
  int i=1,
    max_mem_blks=PMAX_MEM_BLKS,
    mem_blk_size,
    old_mem_blk_size,
    mem_size =  PMEM_BLK_SIZE * PMAX_MEM_BLKS, status, ttout_lun=TTOUT_LUN;
  int using_gui=0;
  float rmem_size;
  char tText[128], quote='"';
  extern void SetInitialState(void);

  /*-----------------------------------------------------------
   * Declarations.
   * The default identifier - mainIface will only be declared 
   * if the interface function is global and of type swidget.
   * To change the identifier to a different name, modify the
   * string mainIface in the file "xtmain.dat". If "mainIface"
   * is declared, it will be used below where the return value
   * of  PJ_INTERFACE_FUNCTION_CALL will be assigned to it.
   *----------------------------------------------------------*/ 

  Widget mainIface;

  /*---------------------------------
   * Interface function declaration
   *--------------------------------*/	

  Widget  create_FerretMainWd(swidget UxParent);
  swidget UxParent = NULL;


  /*------------------------------------------------------
   * Declare the fallback resources (added by JC 9.13.96)
   *-----------------------------------------------------*/

#include "fallback_resources.c"


  /*---------------------
   * Initialize program
   *--------------------*/

/*
 * BEGIN of "FerretMain_mycode_3.c"
 *
 * Here are the contents of the file "FerretMain_mycode_3.c"
 * which was previously included as a separate file.
 */

  /* kob - 5/97 */
#ifdef MIXING_NAG_F90_AND_C
  f90_io_init();
#endif

  /*
   * Make sure the FERRET environment is set up and ready by looking for $FER_DIR.
   */
  if (getenv("FER_DIR") == NULL){
    printf("\n  The FERRET environment has not been properly set up.\n");
    printf("  (The environment variable FER_DIR is not defined)\n");
    printf("\n  Have you executed \"source your_system_path/ferret_paths\" ?\n");
    exit(1);
  }


  /*
   * Decode the command line options.
   */
  while (i < argc) {

    if (strcmp(argv[i],"-memsize")==0) {
      if (++i == argc)
	help_text();
      if (sscanf(argv[i++],"%f",&rmem_size) != 1)
	help_text();
      if ( rmem_size <= 0.0 )
	help_text();

      mem_size = rmem_size * 1.E6;

    } else if (strcmp(argv[i],"-unmapped")==0) {
      WindowMapping(0);  /* new routine added to xopws.c */
      i++;

    } else if (strcmp(argv[i],"-gui")==0) {
      using_gui = 1;  /* new routine added to xopws.c */
      i++;

    } else
      help_text();

  }


  /*
   * Allocate memory.
   */
  mem_blk_size =  mem_size / max_mem_blks;
  memory = (float *) malloc(mem_size*sizeof(float));
  if (memory == NULL) {
    printf("Unable to allocate the requested %f Mwords of memory.\n",mem_size/1.E6);
    exit(0);
  }


  /*
   * Initialize stuff: keyboard, todays date, grids, GFDL terms, PPL brain.
   */
#ifdef NO_ENTRY_NAME_UNDERSCORES
  initialize();
#else
  initialize_();
#endif

	
  /*
   * Turn on ^C interrupts.
   */
  if (!using_gui) {
#ifdef NO_ENTRY_NAME_UNDERSCORES
    set_ctrl_c(ctrlc_ast);
#else
    set_ctrl_c_(ctrlc_ast_);
#endif
  }


  /*  
   * Prepare appropriate console input state and open the output journal file.
   */
#ifdef NO_ENTRY_NAME_UNDERSCORES
  init_journal(&status);
#else
  init_journal_(&status);
#endif


  /*
   * Program name and revision number.
   */
  if (!using_gui ) {
#ifdef NO_ENTRY_NAME_UNDERSCORES
    proclaim_c( &ttout_lun, "\t" );
#else
    proclaim_c_( &ttout_lun, "\t" );
#endif
  }


  /*
   * Initialize size and shape of memory and linked lists.
   */
#ifdef NO_ENTRY_NAME_UNDERSCORES
  init_memory(&mem_blk_size, &max_mem_blks);
#else
  init_memory_(&mem_blk_size, &max_mem_blks);
#endif


  /*
   * ==>> place FERRET under GUI control here  <<== 
   */
  if ( using_gui ) {
#ifdef NO_ENTRY_NAME_UNDERSCORES
    mode_gui_on();
#else
    mode_gui_on_();
#endif
  }


  /*
   * Set up to execute $HOME/.ferret if it exists: '\GO "$HOME/.ferret"'
   * --> need to see if it exists!!!
   */
  home = (char *)getenv("HOME");
  if (home != 0) {
    strcpy(init_command, home);
    strcat(init_command, "/.ferret");
    fp = fopen( init_command, "r");
    if (fp != NULL) {
      sprintf(init_command, "GO %c%s/.ferret%c", quote, home, quote);
      fclose(fp);
    }
    else 
      strcpy(init_command, "");
  }


  /* GUI OFF -- Only using the command line interface. */

  if ( !using_gui ) {

    /*
     * Allocate memory for the shared buffer.
     */
    sBuffer = (sharedMem *)malloc(sizeof(sharedMem));

    while ( 1 ) {
      ferret_dispatch_c( memory, init_command, sBuffer );

      /*
       * At this point we need to do one of the following:
       *
       *    1) Reallocate Memory.
       */
      if (sBuffer->flags[FRTN_ACTION] == FACTN_MEM_RECONFIGURE) {
	old_mem_blk_size = mem_blk_size;
	mem_size = sBuffer->flags[FRTN_IDATA1];
	mem_blk_size = mem_size / max_mem_blks;
	free ( (void *) memory );
	memory = (float *) malloc(mem_size*sizeof(float));
	if ( memory == 0 ) {
	  printf("Unable to allocate %d Mwords of memory.\n",mem_size/1.E6 );
	  mem_blk_size = old_mem_blk_size;
	  mem_size = mem_blk_size * max_mem_blks;
	  memory = (float *) malloc(mem_size*sizeof(float));
	  if ( memory == 0 ) {
	    printf("Unable to reallocate previous memory of %d Mwords.\n",mem_size/1.E6 );
	    exit(0);
	  } else {
	    printf("Restoring previous memory of %f Mwords.\n",mem_size/1.E6 );
	  }
	}
#ifdef NO_ENTRY_NAME_UNDERSCORES
	init_memory( &mem_blk_size, &max_mem_blks );
#else
	init_memory_( &mem_blk_size, &max_mem_blks );
#endif
      }

      /*
       *    2) Exit.
       */
      else if  (sBuffer->flags[FRTN_ACTION] == FACTN_EXIT ) {
	exit(0);
      }

      /*
       *    3) Print an error message.
       */
      else {

	/*
	 * Check the sBuffer->flags[FRTN_STATUS] to see if you need
	 * to display any messages from FERRET to the user
	 */
	if (sBuffer->flags[FRTN_STATUS] != 3 ) {
	  printf("error buffer from FERRET: %d\n", sBuffer->numStrings);
	  printf("error lines:\n%s\n",sBuffer->text);
	}
	else
	  printf("no action\n");

      }

    } /* while () */


    /* GUI ON -- Using the full GUI interface. */

  } else {



  /*    #include "FerretMain_mycode_3.c"*/
/*
 * END of "FerretMain_mycode_3.c"
 */


#ifdef XOPEN_CATALOG
    if (XSupportsLocale()) {
      XtSetLanguageProc(NULL,(XtLanguageProc)NULL,NULL);
    }
#endif


    /*UxTopLevel = XtAppInitialize(&UxAppContext, "Ferret",
 				     NULL, 0, &argc, argv, NULL, NULL, 0);*/

    UxTopLevel = XtVaAppInitialize(&UxAppContext, "Ferret",
				   NULL, 0, &argc, argv, fallbacks, NULL);

    UxDisplay = XtDisplay(UxTopLevel);
    UxScreen = XDefaultScreen(UxDisplay);

    /*
     * We set the geometry of UxTopLevel so that dialogShells
     * that are parented on it will get centered on the screen
     * (if defaultPosition is true).
     */

    XtVaSetValues(UxTopLevel,
		  XtNx, 0,
		  XtNy, 0,
		  XtNwidth, DisplayWidth(UxDisplay, UxScreen),
		  XtNheight, DisplayHeight(UxDisplay, UxScreen),
		  NULL);

    /*-------------------------------------------------------
     * Insert initialization code for your application here 
     *------------------------------------------------------*/
	
    /*----------------------------------------------------------------
     * Create and popup the first window of the interface.  The 	 
     * return value can be used in the popdown or destroy functions.
     * The Widget return value of  PJ_INTERFACE_FUNCTION_CALL will 
     * be assigned to "mainIface" from  PJ_INTERFACE_RETVAL_TYPE. 
     *---------------------------------------------------------------*/

    mainIface = create_FerretMainWd(UxParent);

    SetInitialState();
    UxPopupInterface(mainIface, no_grab);

#ifdef X_REFRESH
    XtAppAddTimeOut(UxAppContext, 2000, TimeOutCB, UxAppContext);
#endif

#ifdef SGI_POPUPS
    /* NB__ UxTopLevel is declared external in UxXt.h */
    windows[window_count++] = XtWindow(UxTopLevel);
    XSetWMColormapWindows(XtDisplay(UxTopLevel), XtWindow(UxTopLevel),
			  windows, window_count);
#endif /* SGI_POPUPS */

    /*-----------------------
     * Enter the event loop 
     *----------------------*/
    {

      XEvent event;

      for (;;)
	{
	  XtAppNextEvent(UxAppContext, &event);

	  if (event.type == ClientMessage) {
	    ;
	  }
	  switch (event.type)
	    {

	      /*---------------------------------------------------
	       * Insert code here to handle any events that you do
	       * not wish to be handled by the interface.
	       *---------------------------------------------------*/
	    default:
	      XtDispatchEvent(&event);
	      break;
	    }
	}

    } /* event loop block */

  } /* END of GUI ON section. */

/* 
 *kob* 5/97 - need to close f90 files and flush buffers.....
 */
#ifdef MIXING_NAG_F90_AND_C
  f90_io_finish();
#endif


}
