/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.Data;
import visad.ErrorEstimate;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.SingletonSet;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealTuple;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinarySingletonSet
implements BinaryObject {
    public static final int computeBytes(RealTupleType sampleType, Real[] sampleReals, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors) {
        boolean trivialTuple = BinaryRealTuple.isTrivialTuple(sampleType, sampleReals);
        int unitsLen = BinaryUnit.computeBytes(units);
        int errorsLen = BinaryErrorEstimate.computeBytes(errors);
        return 7 + BinaryRealTuple.computeBytes(sampleReals, cs, trivialTuple) + (cs == null ? 0 : 5) + (unitsLen == 0 ? 0 : unitsLen + 1) + (errorsLen == 0 ? 0 : errorsLen + 1) + 1;
    }

    public static final Real[] getSampleReals(RealTuple sample) {
        Data[] comps = sample.getComponents();
        if (comps == null) {
            return null;
        }
        Real[] sampleReals = new Real[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            sampleReals[i] = (Real)comps[i];
        }
        return sampleReals;
    }

    public static SingletonSet read(BinaryReader reader) throws IOException, VisADException {
        BinaryObjectCache cache = reader.getCoordinateSystemCache();
        DataInput file = reader.getInput();
        RealTuple sample = null;
        CoordinateSystem cs = null;
        Unit[] units = null;
        ErrorEstimate[] errs = null;
        boolean reading = true;
        block9: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 5: {
                    sample = (RealTuple)BinaryGeneric.read(reader);
                    continue block9;
                }
                case 32: {
                    int index = file.readInt();
                    cs = (CoordinateSystem)cache.get(index);
                    continue block9;
                }
                case 40: {
                    units = BinaryUnit.readList(reader);
                    continue block9;
                }
                case 41: {
                    errs = BinaryErrorEstimate.readList(reader);
                    continue block9;
                }
                case 80: {
                    reading = false;
                    continue block9;
                }
            }
            throw new IOException("Unknown SingletonSet directive " + directive);
        }
        if (sample == null) {
            throw new IOException("No sample found for SingletonSet");
        }
        return new SingletonSet(sample, cs, units, errs);
    }

    public static final void writeDependentData(BinaryWriter writer, RealTuple sample, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, SingletonSet set, Object token) throws IOException {
        if (!(set.getClass().equals(SingletonSet.class) || set instanceof SingletonSet && set instanceof Saveable)) {
            return;
        }
        Object dependToken = token == SAVE_DEPEND_BIG ? token : SAVE_DEPEND;
        if (cs != null) {
            BinaryCoordinateSystem.write(writer, cs, SAVE_DATA);
        }
        if (units != null) {
            BinaryUnit.writeList(writer, units, SAVE_DATA);
        }
        if (errors != null) {
            BinaryErrorEstimate.writeList(writer, errors, SAVE_DATA);
        }
        BinaryGeneric.write(writer, sample, dependToken);
    }

    public static final void write(BinaryWriter writer, RealTuple sample, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, SingletonSet set, Object token) throws IOException {
        BinarySingletonSet.writeDependentData(writer, sample, cs, units, errors, set, token);
        if (token == SAVE_DEPEND || token == SAVE_DEPEND_BIG) {
            return;
        }
        if (!(set.getClass().equals(SingletonSet.class) || set instanceof SingletonSet && set instanceof Saveable)) {
            BinaryUnknown.write(writer, set, token);
            return;
        }
        if (sample == null) {
            throw new IOException("Null SingletonSet sample");
        }
        int csIndex = -1;
        if (cs != null && (csIndex = writer.getCoordinateSystemCache().getIndex(cs)) < 0) {
            throw new IOException("CoordinateSystem " + cs + " not cached");
        }
        int[] unitsIndex = null;
        if (units != null) {
            unitsIndex = BinaryUnit.lookupList(writer.getUnitCache(), units);
        }
        int[] errorsIndex = null;
        if (errors != null) {
            errorsIndex = BinaryErrorEstimate.lookupList(writer.getErrorEstimateCache(), errors);
        }
        RealTupleType sampleType = (RealTupleType)sample.getType();
        Real[] sampleReals = BinarySingletonSet.getSampleReals(sample);
        int objLen = BinarySingletonSet.computeBytes(sampleType, sampleReals, cs, units, errors);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(36);
        file.writeByte(5);
        BinaryRealTuple.write(writer, sampleType, sampleReals, sample.getCoordinateSystem(), sample, token);
        if (csIndex >= 0) {
            file.writeByte(32);
            file.writeInt(csIndex);
        }
        if (unitsIndex != null) {
            file.writeByte(40);
            BinaryIntegerArray.write(writer, unitsIndex, token);
        }
        if (errorsIndex != null) {
            file.writeByte(41);
            BinaryIntegerArray.write(writer, errorsIndex, token);
        }
        file.writeByte(80);
    }
}

