//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: PDESolver.hpp,v 1.3 2005/09/25 14:27:13 delpinux Exp $

#ifndef PDESOLVER_HPP
#define PDESOLVER_HPP

#include <Solver.hpp>
#include <PDESystem.hpp>
#include <PDESolution.hpp>

/*!
  \class PDESolver

  This defines a general solver for PDE problems.

  \author Stphane Del Pino
*/

class PDESolver
  : public Solver
{
public:
  const Solution& Solve ();

  PDESolver(ConstReferenceCounting<Problem> P,
	    ReferenceCounting<Method> M,
	    PDESolution& U)
    : Solver(P,M,U)
  {
    ;
  }

  ~PDESolver()
  {
    ;
  }
};

#endif // PDESOLVER_HPP

