// Code generated by protoc-gen-go. DO NOT EDIT.
// source: commit.proto

package gitaly

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type TreeEntryResponse_ObjectType int32

const (
	TreeEntryResponse_COMMIT TreeEntryResponse_ObjectType = 0
	TreeEntryResponse_BLOB   TreeEntryResponse_ObjectType = 1
	TreeEntryResponse_TREE   TreeEntryResponse_ObjectType = 2
	TreeEntryResponse_TAG    TreeEntryResponse_ObjectType = 3
)

var TreeEntryResponse_ObjectType_name = map[int32]string{
	0: "COMMIT",
	1: "BLOB",
	2: "TREE",
	3: "TAG",
}
var TreeEntryResponse_ObjectType_value = map[string]int32{
	"COMMIT": 0,
	"BLOB":   1,
	"TREE":   2,
	"TAG":    3,
}

func (x TreeEntryResponse_ObjectType) String() string {
	return proto.EnumName(TreeEntryResponse_ObjectType_name, int32(x))
}
func (TreeEntryResponse_ObjectType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{5, 0}
}

type TreeEntry_EntryType int32

const (
	TreeEntry_BLOB   TreeEntry_EntryType = 0
	TreeEntry_TREE   TreeEntry_EntryType = 1
	TreeEntry_COMMIT TreeEntry_EntryType = 3
)

var TreeEntry_EntryType_name = map[int32]string{
	0: "BLOB",
	1: "TREE",
	3: "COMMIT",
}
var TreeEntry_EntryType_value = map[string]int32{
	"BLOB":   0,
	"TREE":   1,
	"COMMIT": 3,
}

func (x TreeEntry_EntryType) String() string {
	return proto.EnumName(TreeEntry_EntryType_name, int32(x))
}
func (TreeEntry_EntryType) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{10, 0} }

type FindAllCommitsRequest_Order int32

const (
	FindAllCommitsRequest_NONE FindAllCommitsRequest_Order = 0
	FindAllCommitsRequest_TOPO FindAllCommitsRequest_Order = 1
	FindAllCommitsRequest_DATE FindAllCommitsRequest_Order = 2
)

var FindAllCommitsRequest_Order_name = map[int32]string{
	0: "NONE",
	1: "TOPO",
	2: "DATE",
}
var FindAllCommitsRequest_Order_value = map[string]int32{
	"NONE": 0,
	"TOPO": 1,
	"DATE": 2,
}

func (x FindAllCommitsRequest_Order) String() string {
	return proto.EnumName(FindAllCommitsRequest_Order_name, int32(x))
}
func (FindAllCommitsRequest_Order) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{19, 0}
}

type CommitStatsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *CommitStatsRequest) Reset()                    { *m = CommitStatsRequest{} }
func (m *CommitStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitStatsRequest) ProtoMessage()               {}
func (*CommitStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *CommitStatsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitStatsRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

type CommitStatsResponse struct {
	// OID is the commit. Empty means not found
	Oid       string `protobuf:"bytes,1,opt,name=oid" json:"oid,omitempty"`
	Additions int32  `protobuf:"varint,2,opt,name=additions" json:"additions,omitempty"`
	Deletions int32  `protobuf:"varint,3,opt,name=deletions" json:"deletions,omitempty"`
}

func (m *CommitStatsResponse) Reset()                    { *m = CommitStatsResponse{} }
func (m *CommitStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitStatsResponse) ProtoMessage()               {}
func (*CommitStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *CommitStatsResponse) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

func (m *CommitStatsResponse) GetAdditions() int32 {
	if m != nil {
		return m.Additions
	}
	return 0
}

func (m *CommitStatsResponse) GetDeletions() int32 {
	if m != nil {
		return m.Deletions
	}
	return 0
}

type CommitIsAncestorRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	AncestorId string      `protobuf:"bytes,2,opt,name=ancestor_id,json=ancestorId" json:"ancestor_id,omitempty"`
	ChildId    string      `protobuf:"bytes,3,opt,name=child_id,json=childId" json:"child_id,omitempty"`
}

func (m *CommitIsAncestorRequest) Reset()                    { *m = CommitIsAncestorRequest{} }
func (m *CommitIsAncestorRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitIsAncestorRequest) ProtoMessage()               {}
func (*CommitIsAncestorRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *CommitIsAncestorRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitIsAncestorRequest) GetAncestorId() string {
	if m != nil {
		return m.AncestorId
	}
	return ""
}

func (m *CommitIsAncestorRequest) GetChildId() string {
	if m != nil {
		return m.ChildId
	}
	return ""
}

type CommitIsAncestorResponse struct {
	Value bool `protobuf:"varint,1,opt,name=value" json:"value,omitempty"`
}

func (m *CommitIsAncestorResponse) Reset()                    { *m = CommitIsAncestorResponse{} }
func (m *CommitIsAncestorResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitIsAncestorResponse) ProtoMessage()               {}
func (*CommitIsAncestorResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *CommitIsAncestorResponse) GetValue() bool {
	if m != nil {
		return m.Value
	}
	return false
}

type TreeEntryRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// commit ID or refname
	Revision []byte `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	// entry path relative to repository root
	Path  []byte `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	Limit int64  `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
}

func (m *TreeEntryRequest) Reset()                    { *m = TreeEntryRequest{} }
func (m *TreeEntryRequest) String() string            { return proto.CompactTextString(m) }
func (*TreeEntryRequest) ProtoMessage()               {}
func (*TreeEntryRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *TreeEntryRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *TreeEntryRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *TreeEntryRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *TreeEntryRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type TreeEntryResponse struct {
	Type TreeEntryResponse_ObjectType `protobuf:"varint,1,opt,name=type,enum=gitaly.TreeEntryResponse_ObjectType" json:"type,omitempty"`
	// SHA1 object ID
	Oid  string `protobuf:"bytes,2,opt,name=oid" json:"oid,omitempty"`
	Size int64  `protobuf:"varint,3,opt,name=size" json:"size,omitempty"`
	// file mode
	Mode int32 `protobuf:"varint,4,opt,name=mode" json:"mode,omitempty"`
	// raw object contents
	Data []byte `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *TreeEntryResponse) Reset()                    { *m = TreeEntryResponse{} }
func (m *TreeEntryResponse) String() string            { return proto.CompactTextString(m) }
func (*TreeEntryResponse) ProtoMessage()               {}
func (*TreeEntryResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *TreeEntryResponse) GetType() TreeEntryResponse_ObjectType {
	if m != nil {
		return m.Type
	}
	return TreeEntryResponse_COMMIT
}

func (m *TreeEntryResponse) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

func (m *TreeEntryResponse) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *TreeEntryResponse) GetMode() int32 {
	if m != nil {
		return m.Mode
	}
	return 0
}

func (m *TreeEntryResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type CommitsBetweenRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	From       []byte      `protobuf:"bytes,2,opt,name=from,proto3" json:"from,omitempty"`
	To         []byte      `protobuf:"bytes,3,opt,name=to,proto3" json:"to,omitempty"`
}

func (m *CommitsBetweenRequest) Reset()                    { *m = CommitsBetweenRequest{} }
func (m *CommitsBetweenRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitsBetweenRequest) ProtoMessage()               {}
func (*CommitsBetweenRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *CommitsBetweenRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitsBetweenRequest) GetFrom() []byte {
	if m != nil {
		return m.From
	}
	return nil
}

func (m *CommitsBetweenRequest) GetTo() []byte {
	if m != nil {
		return m.To
	}
	return nil
}

type CommitsBetweenResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *CommitsBetweenResponse) Reset()                    { *m = CommitsBetweenResponse{} }
func (m *CommitsBetweenResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitsBetweenResponse) ProtoMessage()               {}
func (*CommitsBetweenResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *CommitsBetweenResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type CountCommitsRequest struct {
	Repository *Repository                `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte                     `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	After      *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=after" json:"after,omitempty"`
	Before     *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=before" json:"before,omitempty"`
	Path       []byte                     `protobuf:"bytes,5,opt,name=path,proto3" json:"path,omitempty"`
	MaxCount   int32                      `protobuf:"varint,6,opt,name=max_count,json=maxCount" json:"max_count,omitempty"`
}

func (m *CountCommitsRequest) Reset()                    { *m = CountCommitsRequest{} }
func (m *CountCommitsRequest) String() string            { return proto.CompactTextString(m) }
func (*CountCommitsRequest) ProtoMessage()               {}
func (*CountCommitsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *CountCommitsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CountCommitsRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *CountCommitsRequest) GetAfter() *google_protobuf.Timestamp {
	if m != nil {
		return m.After
	}
	return nil
}

func (m *CountCommitsRequest) GetBefore() *google_protobuf.Timestamp {
	if m != nil {
		return m.Before
	}
	return nil
}

func (m *CountCommitsRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *CountCommitsRequest) GetMaxCount() int32 {
	if m != nil {
		return m.MaxCount
	}
	return 0
}

type CountCommitsResponse struct {
	Count int32 `protobuf:"varint,1,opt,name=count" json:"count,omitempty"`
}

func (m *CountCommitsResponse) Reset()                    { *m = CountCommitsResponse{} }
func (m *CountCommitsResponse) String() string            { return proto.CompactTextString(m) }
func (*CountCommitsResponse) ProtoMessage()               {}
func (*CountCommitsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *CountCommitsResponse) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

type TreeEntry struct {
	// OID of the object this tree entry points to
	Oid string `protobuf:"bytes,1,opt,name=oid" json:"oid,omitempty"`
	// OID of the tree attached to commit_oid
	RootOid string `protobuf:"bytes,2,opt,name=root_oid,json=rootOid" json:"root_oid,omitempty"`
	// Path relative to repository root
	Path []byte              `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	Type TreeEntry_EntryType `protobuf:"varint,4,opt,name=type,enum=gitaly.TreeEntry_EntryType" json:"type,omitempty"`
	// File mode e.g. 0644
	Mode int32 `protobuf:"varint,5,opt,name=mode" json:"mode,omitempty"`
	// The commit object via which this entry was retrieved
	CommitOid string `protobuf:"bytes,6,opt,name=commit_oid,json=commitOid" json:"commit_oid,omitempty"`
	// Relative path of the first subdir that doesn't have only one directory descendant
	FlatPath []byte `protobuf:"bytes,7,opt,name=flat_path,json=flatPath,proto3" json:"flat_path,omitempty"`
}

func (m *TreeEntry) Reset()                    { *m = TreeEntry{} }
func (m *TreeEntry) String() string            { return proto.CompactTextString(m) }
func (*TreeEntry) ProtoMessage()               {}
func (*TreeEntry) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *TreeEntry) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

func (m *TreeEntry) GetRootOid() string {
	if m != nil {
		return m.RootOid
	}
	return ""
}

func (m *TreeEntry) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *TreeEntry) GetType() TreeEntry_EntryType {
	if m != nil {
		return m.Type
	}
	return TreeEntry_BLOB
}

func (m *TreeEntry) GetMode() int32 {
	if m != nil {
		return m.Mode
	}
	return 0
}

func (m *TreeEntry) GetCommitOid() string {
	if m != nil {
		return m.CommitOid
	}
	return ""
}

func (m *TreeEntry) GetFlatPath() []byte {
	if m != nil {
		return m.FlatPath
	}
	return nil
}

type GetTreeEntriesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Path       []byte      `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *GetTreeEntriesRequest) Reset()                    { *m = GetTreeEntriesRequest{} }
func (m *GetTreeEntriesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTreeEntriesRequest) ProtoMessage()               {}
func (*GetTreeEntriesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *GetTreeEntriesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *GetTreeEntriesRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *GetTreeEntriesRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

type GetTreeEntriesResponse struct {
	Entries []*TreeEntry `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
}

func (m *GetTreeEntriesResponse) Reset()                    { *m = GetTreeEntriesResponse{} }
func (m *GetTreeEntriesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetTreeEntriesResponse) ProtoMessage()               {}
func (*GetTreeEntriesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *GetTreeEntriesResponse) GetEntries() []*TreeEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type ListFilesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *ListFilesRequest) Reset()                    { *m = ListFilesRequest{} }
func (m *ListFilesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListFilesRequest) ProtoMessage()               {}
func (*ListFilesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *ListFilesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListFilesRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

// A single 'page' of the paginated response
type ListFilesResponse struct {
	// Remember to force encoding utf-8 on the client side
	Paths [][]byte `protobuf:"bytes,1,rep,name=paths,proto3" json:"paths,omitempty"`
}

func (m *ListFilesResponse) Reset()                    { *m = ListFilesResponse{} }
func (m *ListFilesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListFilesResponse) ProtoMessage()               {}
func (*ListFilesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *ListFilesResponse) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

type FindCommitRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *FindCommitRequest) Reset()                    { *m = FindCommitRequest{} }
func (m *FindCommitRequest) String() string            { return proto.CompactTextString(m) }
func (*FindCommitRequest) ProtoMessage()               {}
func (*FindCommitRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *FindCommitRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindCommitRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

type FindCommitResponse struct {
	// commit is nil when the commit was not found
	Commit *GitCommit `protobuf:"bytes,1,opt,name=commit" json:"commit,omitempty"`
}

func (m *FindCommitResponse) Reset()                    { *m = FindCommitResponse{} }
func (m *FindCommitResponse) String() string            { return proto.CompactTextString(m) }
func (*FindCommitResponse) ProtoMessage()               {}
func (*FindCommitResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

func (m *FindCommitResponse) GetCommit() *GitCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

type ListCommitsByOidRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Oid        []string    `protobuf:"bytes,2,rep,name=oid" json:"oid,omitempty"`
}

func (m *ListCommitsByOidRequest) Reset()                    { *m = ListCommitsByOidRequest{} }
func (m *ListCommitsByOidRequest) String() string            { return proto.CompactTextString(m) }
func (*ListCommitsByOidRequest) ProtoMessage()               {}
func (*ListCommitsByOidRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{17} }

func (m *ListCommitsByOidRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListCommitsByOidRequest) GetOid() []string {
	if m != nil {
		return m.Oid
	}
	return nil
}

type ListCommitsByOidResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *ListCommitsByOidResponse) Reset()                    { *m = ListCommitsByOidResponse{} }
func (m *ListCommitsByOidResponse) String() string            { return proto.CompactTextString(m) }
func (*ListCommitsByOidResponse) ProtoMessage()               {}
func (*ListCommitsByOidResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{18} }

func (m *ListCommitsByOidResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type FindAllCommitsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// When nil, return all commits reachable by any branch in the repo
	Revision []byte                      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	MaxCount int32                       `protobuf:"varint,3,opt,name=max_count,json=maxCount" json:"max_count,omitempty"`
	Skip     int32                       `protobuf:"varint,4,opt,name=skip" json:"skip,omitempty"`
	Order    FindAllCommitsRequest_Order `protobuf:"varint,5,opt,name=order,enum=gitaly.FindAllCommitsRequest_Order" json:"order,omitempty"`
}

func (m *FindAllCommitsRequest) Reset()                    { *m = FindAllCommitsRequest{} }
func (m *FindAllCommitsRequest) String() string            { return proto.CompactTextString(m) }
func (*FindAllCommitsRequest) ProtoMessage()               {}
func (*FindAllCommitsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{19} }

func (m *FindAllCommitsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindAllCommitsRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *FindAllCommitsRequest) GetMaxCount() int32 {
	if m != nil {
		return m.MaxCount
	}
	return 0
}

func (m *FindAllCommitsRequest) GetSkip() int32 {
	if m != nil {
		return m.Skip
	}
	return 0
}

func (m *FindAllCommitsRequest) GetOrder() FindAllCommitsRequest_Order {
	if m != nil {
		return m.Order
	}
	return FindAllCommitsRequest_NONE
}

// A single 'page' of the result set
type FindAllCommitsResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *FindAllCommitsResponse) Reset()                    { *m = FindAllCommitsResponse{} }
func (m *FindAllCommitsResponse) String() string            { return proto.CompactTextString(m) }
func (*FindAllCommitsResponse) ProtoMessage()               {}
func (*FindAllCommitsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{20} }

func (m *FindAllCommitsResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type FindCommitsRequest struct {
	Repository  *Repository                `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision    []byte                     `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Limit       int32                      `protobuf:"varint,3,opt,name=limit" json:"limit,omitempty"`
	Offset      int32                      `protobuf:"varint,4,opt,name=offset" json:"offset,omitempty"`
	Paths       [][]byte                   `protobuf:"bytes,5,rep,name=paths,proto3" json:"paths,omitempty"`
	Follow      bool                       `protobuf:"varint,6,opt,name=follow" json:"follow,omitempty"`
	SkipMerges  bool                       `protobuf:"varint,7,opt,name=skip_merges,json=skipMerges" json:"skip_merges,omitempty"`
	DisableWalk bool                       `protobuf:"varint,8,opt,name=disable_walk,json=disableWalk" json:"disable_walk,omitempty"`
	After       *google_protobuf.Timestamp `protobuf:"bytes,9,opt,name=after" json:"after,omitempty"`
	Before      *google_protobuf.Timestamp `protobuf:"bytes,10,opt,name=before" json:"before,omitempty"`
}

func (m *FindCommitsRequest) Reset()                    { *m = FindCommitsRequest{} }
func (m *FindCommitsRequest) String() string            { return proto.CompactTextString(m) }
func (*FindCommitsRequest) ProtoMessage()               {}
func (*FindCommitsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{21} }

func (m *FindCommitsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindCommitsRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *FindCommitsRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *FindCommitsRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *FindCommitsRequest) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

func (m *FindCommitsRequest) GetFollow() bool {
	if m != nil {
		return m.Follow
	}
	return false
}

func (m *FindCommitsRequest) GetSkipMerges() bool {
	if m != nil {
		return m.SkipMerges
	}
	return false
}

func (m *FindCommitsRequest) GetDisableWalk() bool {
	if m != nil {
		return m.DisableWalk
	}
	return false
}

func (m *FindCommitsRequest) GetAfter() *google_protobuf.Timestamp {
	if m != nil {
		return m.After
	}
	return nil
}

func (m *FindCommitsRequest) GetBefore() *google_protobuf.Timestamp {
	if m != nil {
		return m.Before
	}
	return nil
}

// A single 'page' of the result set
type FindCommitsResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *FindCommitsResponse) Reset()                    { *m = FindCommitsResponse{} }
func (m *FindCommitsResponse) String() string            { return proto.CompactTextString(m) }
func (*FindCommitsResponse) ProtoMessage()               {}
func (*FindCommitsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{22} }

func (m *FindCommitsResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type CommitLanguagesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *CommitLanguagesRequest) Reset()                    { *m = CommitLanguagesRequest{} }
func (m *CommitLanguagesRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitLanguagesRequest) ProtoMessage()               {}
func (*CommitLanguagesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{23} }

func (m *CommitLanguagesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitLanguagesRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

type CommitLanguagesResponse struct {
	Languages []*CommitLanguagesResponse_Language `protobuf:"bytes,1,rep,name=languages" json:"languages,omitempty"`
}

func (m *CommitLanguagesResponse) Reset()                    { *m = CommitLanguagesResponse{} }
func (m *CommitLanguagesResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitLanguagesResponse) ProtoMessage()               {}
func (*CommitLanguagesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{24} }

func (m *CommitLanguagesResponse) GetLanguages() []*CommitLanguagesResponse_Language {
	if m != nil {
		return m.Languages
	}
	return nil
}

type CommitLanguagesResponse_Language struct {
	Name  string  `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Share float32 `protobuf:"fixed32,2,opt,name=share" json:"share,omitempty"`
	Color string  `protobuf:"bytes,3,opt,name=color" json:"color,omitempty"`
}

func (m *CommitLanguagesResponse_Language) Reset()         { *m = CommitLanguagesResponse_Language{} }
func (m *CommitLanguagesResponse_Language) String() string { return proto.CompactTextString(m) }
func (*CommitLanguagesResponse_Language) ProtoMessage()    {}
func (*CommitLanguagesResponse_Language) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{24, 0}
}

func (m *CommitLanguagesResponse_Language) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CommitLanguagesResponse_Language) GetShare() float32 {
	if m != nil {
		return m.Share
	}
	return 0
}

func (m *CommitLanguagesResponse_Language) GetColor() string {
	if m != nil {
		return m.Color
	}
	return ""
}

type RawBlameRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Path       []byte      `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *RawBlameRequest) Reset()                    { *m = RawBlameRequest{} }
func (m *RawBlameRequest) String() string            { return proto.CompactTextString(m) }
func (*RawBlameRequest) ProtoMessage()               {}
func (*RawBlameRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{25} }

func (m *RawBlameRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *RawBlameRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *RawBlameRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

type RawBlameResponse struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *RawBlameResponse) Reset()                    { *m = RawBlameResponse{} }
func (m *RawBlameResponse) String() string            { return proto.CompactTextString(m) }
func (*RawBlameResponse) ProtoMessage()               {}
func (*RawBlameResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{26} }

func (m *RawBlameResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type LastCommitForPathRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Path       []byte      `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *LastCommitForPathRequest) Reset()                    { *m = LastCommitForPathRequest{} }
func (m *LastCommitForPathRequest) String() string            { return proto.CompactTextString(m) }
func (*LastCommitForPathRequest) ProtoMessage()               {}
func (*LastCommitForPathRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{27} }

func (m *LastCommitForPathRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *LastCommitForPathRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *LastCommitForPathRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

type LastCommitForPathResponse struct {
	// commit is nil when the commit was not found
	Commit *GitCommit `protobuf:"bytes,1,opt,name=commit" json:"commit,omitempty"`
}

func (m *LastCommitForPathResponse) Reset()                    { *m = LastCommitForPathResponse{} }
func (m *LastCommitForPathResponse) String() string            { return proto.CompactTextString(m) }
func (*LastCommitForPathResponse) ProtoMessage()               {}
func (*LastCommitForPathResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{28} }

func (m *LastCommitForPathResponse) GetCommit() *GitCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

type CommitsByMessageRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Offset     int32       `protobuf:"varint,3,opt,name=offset" json:"offset,omitempty"`
	Limit      int32       `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
	Path       []byte      `protobuf:"bytes,5,opt,name=path,proto3" json:"path,omitempty"`
	Query      string      `protobuf:"bytes,6,opt,name=query" json:"query,omitempty"`
}

func (m *CommitsByMessageRequest) Reset()                    { *m = CommitsByMessageRequest{} }
func (m *CommitsByMessageRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitsByMessageRequest) ProtoMessage()               {}
func (*CommitsByMessageRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{29} }

func (m *CommitsByMessageRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitsByMessageRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *CommitsByMessageRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *CommitsByMessageRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *CommitsByMessageRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *CommitsByMessageRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

// One 'page' of the paginated response of CommitsByMessage
type CommitsByMessageResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *CommitsByMessageResponse) Reset()                    { *m = CommitsByMessageResponse{} }
func (m *CommitsByMessageResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitsByMessageResponse) ProtoMessage()               {}
func (*CommitsByMessageResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{30} }

func (m *CommitsByMessageResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type FilterShasWithSignaturesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Shas       [][]byte    `protobuf:"bytes,2,rep,name=shas,proto3" json:"shas,omitempty"`
}

func (m *FilterShasWithSignaturesRequest) Reset()         { *m = FilterShasWithSignaturesRequest{} }
func (m *FilterShasWithSignaturesRequest) String() string { return proto.CompactTextString(m) }
func (*FilterShasWithSignaturesRequest) ProtoMessage()    {}
func (*FilterShasWithSignaturesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{31}
}

func (m *FilterShasWithSignaturesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FilterShasWithSignaturesRequest) GetShas() [][]byte {
	if m != nil {
		return m.Shas
	}
	return nil
}

type FilterShasWithSignaturesResponse struct {
	Shas [][]byte `protobuf:"bytes,1,rep,name=shas,proto3" json:"shas,omitempty"`
}

func (m *FilterShasWithSignaturesResponse) Reset()         { *m = FilterShasWithSignaturesResponse{} }
func (m *FilterShasWithSignaturesResponse) String() string { return proto.CompactTextString(m) }
func (*FilterShasWithSignaturesResponse) ProtoMessage()    {}
func (*FilterShasWithSignaturesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{32}
}

func (m *FilterShasWithSignaturesResponse) GetShas() [][]byte {
	if m != nil {
		return m.Shas
	}
	return nil
}

type ExtractCommitSignatureRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	CommitId   string      `protobuf:"bytes,2,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
}

func (m *ExtractCommitSignatureRequest) Reset()                    { *m = ExtractCommitSignatureRequest{} }
func (m *ExtractCommitSignatureRequest) String() string            { return proto.CompactTextString(m) }
func (*ExtractCommitSignatureRequest) ProtoMessage()               {}
func (*ExtractCommitSignatureRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{33} }

func (m *ExtractCommitSignatureRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ExtractCommitSignatureRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

// Either of the 'signature' and 'signed_text' fields may be present. It
// is up to the caller to stitch them together.
type ExtractCommitSignatureResponse struct {
	Signature  []byte `protobuf:"bytes,1,opt,name=signature,proto3" json:"signature,omitempty"`
	SignedText []byte `protobuf:"bytes,2,opt,name=signed_text,json=signedText,proto3" json:"signed_text,omitempty"`
}

func (m *ExtractCommitSignatureResponse) Reset()                    { *m = ExtractCommitSignatureResponse{} }
func (m *ExtractCommitSignatureResponse) String() string            { return proto.CompactTextString(m) }
func (*ExtractCommitSignatureResponse) ProtoMessage()               {}
func (*ExtractCommitSignatureResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{34} }

func (m *ExtractCommitSignatureResponse) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *ExtractCommitSignatureResponse) GetSignedText() []byte {
	if m != nil {
		return m.SignedText
	}
	return nil
}

func init() {
	proto.RegisterType((*CommitStatsRequest)(nil), "gitaly.CommitStatsRequest")
	proto.RegisterType((*CommitStatsResponse)(nil), "gitaly.CommitStatsResponse")
	proto.RegisterType((*CommitIsAncestorRequest)(nil), "gitaly.CommitIsAncestorRequest")
	proto.RegisterType((*CommitIsAncestorResponse)(nil), "gitaly.CommitIsAncestorResponse")
	proto.RegisterType((*TreeEntryRequest)(nil), "gitaly.TreeEntryRequest")
	proto.RegisterType((*TreeEntryResponse)(nil), "gitaly.TreeEntryResponse")
	proto.RegisterType((*CommitsBetweenRequest)(nil), "gitaly.CommitsBetweenRequest")
	proto.RegisterType((*CommitsBetweenResponse)(nil), "gitaly.CommitsBetweenResponse")
	proto.RegisterType((*CountCommitsRequest)(nil), "gitaly.CountCommitsRequest")
	proto.RegisterType((*CountCommitsResponse)(nil), "gitaly.CountCommitsResponse")
	proto.RegisterType((*TreeEntry)(nil), "gitaly.TreeEntry")
	proto.RegisterType((*GetTreeEntriesRequest)(nil), "gitaly.GetTreeEntriesRequest")
	proto.RegisterType((*GetTreeEntriesResponse)(nil), "gitaly.GetTreeEntriesResponse")
	proto.RegisterType((*ListFilesRequest)(nil), "gitaly.ListFilesRequest")
	proto.RegisterType((*ListFilesResponse)(nil), "gitaly.ListFilesResponse")
	proto.RegisterType((*FindCommitRequest)(nil), "gitaly.FindCommitRequest")
	proto.RegisterType((*FindCommitResponse)(nil), "gitaly.FindCommitResponse")
	proto.RegisterType((*ListCommitsByOidRequest)(nil), "gitaly.ListCommitsByOidRequest")
	proto.RegisterType((*ListCommitsByOidResponse)(nil), "gitaly.ListCommitsByOidResponse")
	proto.RegisterType((*FindAllCommitsRequest)(nil), "gitaly.FindAllCommitsRequest")
	proto.RegisterType((*FindAllCommitsResponse)(nil), "gitaly.FindAllCommitsResponse")
	proto.RegisterType((*FindCommitsRequest)(nil), "gitaly.FindCommitsRequest")
	proto.RegisterType((*FindCommitsResponse)(nil), "gitaly.FindCommitsResponse")
	proto.RegisterType((*CommitLanguagesRequest)(nil), "gitaly.CommitLanguagesRequest")
	proto.RegisterType((*CommitLanguagesResponse)(nil), "gitaly.CommitLanguagesResponse")
	proto.RegisterType((*CommitLanguagesResponse_Language)(nil), "gitaly.CommitLanguagesResponse.Language")
	proto.RegisterType((*RawBlameRequest)(nil), "gitaly.RawBlameRequest")
	proto.RegisterType((*RawBlameResponse)(nil), "gitaly.RawBlameResponse")
	proto.RegisterType((*LastCommitForPathRequest)(nil), "gitaly.LastCommitForPathRequest")
	proto.RegisterType((*LastCommitForPathResponse)(nil), "gitaly.LastCommitForPathResponse")
	proto.RegisterType((*CommitsByMessageRequest)(nil), "gitaly.CommitsByMessageRequest")
	proto.RegisterType((*CommitsByMessageResponse)(nil), "gitaly.CommitsByMessageResponse")
	proto.RegisterType((*FilterShasWithSignaturesRequest)(nil), "gitaly.FilterShasWithSignaturesRequest")
	proto.RegisterType((*FilterShasWithSignaturesResponse)(nil), "gitaly.FilterShasWithSignaturesResponse")
	proto.RegisterType((*ExtractCommitSignatureRequest)(nil), "gitaly.ExtractCommitSignatureRequest")
	proto.RegisterType((*ExtractCommitSignatureResponse)(nil), "gitaly.ExtractCommitSignatureResponse")
	proto.RegisterEnum("gitaly.TreeEntryResponse_ObjectType", TreeEntryResponse_ObjectType_name, TreeEntryResponse_ObjectType_value)
	proto.RegisterEnum("gitaly.TreeEntry_EntryType", TreeEntry_EntryType_name, TreeEntry_EntryType_value)
	proto.RegisterEnum("gitaly.FindAllCommitsRequest_Order", FindAllCommitsRequest_Order_name, FindAllCommitsRequest_Order_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for CommitService service

type CommitServiceClient interface {
	CommitIsAncestor(ctx context.Context, in *CommitIsAncestorRequest, opts ...grpc.CallOption) (*CommitIsAncestorResponse, error)
	TreeEntry(ctx context.Context, in *TreeEntryRequest, opts ...grpc.CallOption) (CommitService_TreeEntryClient, error)
	CommitsBetween(ctx context.Context, in *CommitsBetweenRequest, opts ...grpc.CallOption) (CommitService_CommitsBetweenClient, error)
	CountCommits(ctx context.Context, in *CountCommitsRequest, opts ...grpc.CallOption) (*CountCommitsResponse, error)
	GetTreeEntries(ctx context.Context, in *GetTreeEntriesRequest, opts ...grpc.CallOption) (CommitService_GetTreeEntriesClient, error)
	ListFiles(ctx context.Context, in *ListFilesRequest, opts ...grpc.CallOption) (CommitService_ListFilesClient, error)
	FindCommit(ctx context.Context, in *FindCommitRequest, opts ...grpc.CallOption) (*FindCommitResponse, error)
	CommitStats(ctx context.Context, in *CommitStatsRequest, opts ...grpc.CallOption) (*CommitStatsResponse, error)
	// Use a stream to paginate the result set
	FindAllCommits(ctx context.Context, in *FindAllCommitsRequest, opts ...grpc.CallOption) (CommitService_FindAllCommitsClient, error)
	FindCommits(ctx context.Context, in *FindCommitsRequest, opts ...grpc.CallOption) (CommitService_FindCommitsClient, error)
	CommitLanguages(ctx context.Context, in *CommitLanguagesRequest, opts ...grpc.CallOption) (*CommitLanguagesResponse, error)
	RawBlame(ctx context.Context, in *RawBlameRequest, opts ...grpc.CallOption) (CommitService_RawBlameClient, error)
	LastCommitForPath(ctx context.Context, in *LastCommitForPathRequest, opts ...grpc.CallOption) (*LastCommitForPathResponse, error)
	CommitsByMessage(ctx context.Context, in *CommitsByMessageRequest, opts ...grpc.CallOption) (CommitService_CommitsByMessageClient, error)
	ListCommitsByOid(ctx context.Context, in *ListCommitsByOidRequest, opts ...grpc.CallOption) (CommitService_ListCommitsByOidClient, error)
	FilterShasWithSignatures(ctx context.Context, opts ...grpc.CallOption) (CommitService_FilterShasWithSignaturesClient, error)
	// ExtractCommitSignature returns a stream because the signed text may be
	// arbitrarily large and signature verification is impossible without the
	// full text.
	ExtractCommitSignature(ctx context.Context, in *ExtractCommitSignatureRequest, opts ...grpc.CallOption) (CommitService_ExtractCommitSignatureClient, error)
}

type commitServiceClient struct {
	cc *grpc.ClientConn
}

func NewCommitServiceClient(cc *grpc.ClientConn) CommitServiceClient {
	return &commitServiceClient{cc}
}

func (c *commitServiceClient) CommitIsAncestor(ctx context.Context, in *CommitIsAncestorRequest, opts ...grpc.CallOption) (*CommitIsAncestorResponse, error) {
	out := new(CommitIsAncestorResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/CommitIsAncestor", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) TreeEntry(ctx context.Context, in *TreeEntryRequest, opts ...grpc.CallOption) (CommitService_TreeEntryClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[0], c.cc, "/gitaly.CommitService/TreeEntry", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceTreeEntryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_TreeEntryClient interface {
	Recv() (*TreeEntryResponse, error)
	grpc.ClientStream
}

type commitServiceTreeEntryClient struct {
	grpc.ClientStream
}

func (x *commitServiceTreeEntryClient) Recv() (*TreeEntryResponse, error) {
	m := new(TreeEntryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) CommitsBetween(ctx context.Context, in *CommitsBetweenRequest, opts ...grpc.CallOption) (CommitService_CommitsBetweenClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[1], c.cc, "/gitaly.CommitService/CommitsBetween", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceCommitsBetweenClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_CommitsBetweenClient interface {
	Recv() (*CommitsBetweenResponse, error)
	grpc.ClientStream
}

type commitServiceCommitsBetweenClient struct {
	grpc.ClientStream
}

func (x *commitServiceCommitsBetweenClient) Recv() (*CommitsBetweenResponse, error) {
	m := new(CommitsBetweenResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) CountCommits(ctx context.Context, in *CountCommitsRequest, opts ...grpc.CallOption) (*CountCommitsResponse, error) {
	out := new(CountCommitsResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/CountCommits", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) GetTreeEntries(ctx context.Context, in *GetTreeEntriesRequest, opts ...grpc.CallOption) (CommitService_GetTreeEntriesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[2], c.cc, "/gitaly.CommitService/GetTreeEntries", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceGetTreeEntriesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_GetTreeEntriesClient interface {
	Recv() (*GetTreeEntriesResponse, error)
	grpc.ClientStream
}

type commitServiceGetTreeEntriesClient struct {
	grpc.ClientStream
}

func (x *commitServiceGetTreeEntriesClient) Recv() (*GetTreeEntriesResponse, error) {
	m := new(GetTreeEntriesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) ListFiles(ctx context.Context, in *ListFilesRequest, opts ...grpc.CallOption) (CommitService_ListFilesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[3], c.cc, "/gitaly.CommitService/ListFiles", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceListFilesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_ListFilesClient interface {
	Recv() (*ListFilesResponse, error)
	grpc.ClientStream
}

type commitServiceListFilesClient struct {
	grpc.ClientStream
}

func (x *commitServiceListFilesClient) Recv() (*ListFilesResponse, error) {
	m := new(ListFilesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) FindCommit(ctx context.Context, in *FindCommitRequest, opts ...grpc.CallOption) (*FindCommitResponse, error) {
	out := new(FindCommitResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/FindCommit", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) CommitStats(ctx context.Context, in *CommitStatsRequest, opts ...grpc.CallOption) (*CommitStatsResponse, error) {
	out := new(CommitStatsResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/CommitStats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) FindAllCommits(ctx context.Context, in *FindAllCommitsRequest, opts ...grpc.CallOption) (CommitService_FindAllCommitsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[4], c.cc, "/gitaly.CommitService/FindAllCommits", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceFindAllCommitsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_FindAllCommitsClient interface {
	Recv() (*FindAllCommitsResponse, error)
	grpc.ClientStream
}

type commitServiceFindAllCommitsClient struct {
	grpc.ClientStream
}

func (x *commitServiceFindAllCommitsClient) Recv() (*FindAllCommitsResponse, error) {
	m := new(FindAllCommitsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) FindCommits(ctx context.Context, in *FindCommitsRequest, opts ...grpc.CallOption) (CommitService_FindCommitsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[5], c.cc, "/gitaly.CommitService/FindCommits", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceFindCommitsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_FindCommitsClient interface {
	Recv() (*FindCommitsResponse, error)
	grpc.ClientStream
}

type commitServiceFindCommitsClient struct {
	grpc.ClientStream
}

func (x *commitServiceFindCommitsClient) Recv() (*FindCommitsResponse, error) {
	m := new(FindCommitsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) CommitLanguages(ctx context.Context, in *CommitLanguagesRequest, opts ...grpc.CallOption) (*CommitLanguagesResponse, error) {
	out := new(CommitLanguagesResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/CommitLanguages", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) RawBlame(ctx context.Context, in *RawBlameRequest, opts ...grpc.CallOption) (CommitService_RawBlameClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[6], c.cc, "/gitaly.CommitService/RawBlame", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceRawBlameClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_RawBlameClient interface {
	Recv() (*RawBlameResponse, error)
	grpc.ClientStream
}

type commitServiceRawBlameClient struct {
	grpc.ClientStream
}

func (x *commitServiceRawBlameClient) Recv() (*RawBlameResponse, error) {
	m := new(RawBlameResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) LastCommitForPath(ctx context.Context, in *LastCommitForPathRequest, opts ...grpc.CallOption) (*LastCommitForPathResponse, error) {
	out := new(LastCommitForPathResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/LastCommitForPath", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) CommitsByMessage(ctx context.Context, in *CommitsByMessageRequest, opts ...grpc.CallOption) (CommitService_CommitsByMessageClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[7], c.cc, "/gitaly.CommitService/CommitsByMessage", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceCommitsByMessageClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_CommitsByMessageClient interface {
	Recv() (*CommitsByMessageResponse, error)
	grpc.ClientStream
}

type commitServiceCommitsByMessageClient struct {
	grpc.ClientStream
}

func (x *commitServiceCommitsByMessageClient) Recv() (*CommitsByMessageResponse, error) {
	m := new(CommitsByMessageResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) ListCommitsByOid(ctx context.Context, in *ListCommitsByOidRequest, opts ...grpc.CallOption) (CommitService_ListCommitsByOidClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[8], c.cc, "/gitaly.CommitService/ListCommitsByOid", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceListCommitsByOidClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_ListCommitsByOidClient interface {
	Recv() (*ListCommitsByOidResponse, error)
	grpc.ClientStream
}

type commitServiceListCommitsByOidClient struct {
	grpc.ClientStream
}

func (x *commitServiceListCommitsByOidClient) Recv() (*ListCommitsByOidResponse, error) {
	m := new(ListCommitsByOidResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) FilterShasWithSignatures(ctx context.Context, opts ...grpc.CallOption) (CommitService_FilterShasWithSignaturesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[9], c.cc, "/gitaly.CommitService/FilterShasWithSignatures", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceFilterShasWithSignaturesClient{stream}
	return x, nil
}

type CommitService_FilterShasWithSignaturesClient interface {
	Send(*FilterShasWithSignaturesRequest) error
	Recv() (*FilterShasWithSignaturesResponse, error)
	grpc.ClientStream
}

type commitServiceFilterShasWithSignaturesClient struct {
	grpc.ClientStream
}

func (x *commitServiceFilterShasWithSignaturesClient) Send(m *FilterShasWithSignaturesRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *commitServiceFilterShasWithSignaturesClient) Recv() (*FilterShasWithSignaturesResponse, error) {
	m := new(FilterShasWithSignaturesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) ExtractCommitSignature(ctx context.Context, in *ExtractCommitSignatureRequest, opts ...grpc.CallOption) (CommitService_ExtractCommitSignatureClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[10], c.cc, "/gitaly.CommitService/ExtractCommitSignature", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceExtractCommitSignatureClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_ExtractCommitSignatureClient interface {
	Recv() (*ExtractCommitSignatureResponse, error)
	grpc.ClientStream
}

type commitServiceExtractCommitSignatureClient struct {
	grpc.ClientStream
}

func (x *commitServiceExtractCommitSignatureClient) Recv() (*ExtractCommitSignatureResponse, error) {
	m := new(ExtractCommitSignatureResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for CommitService service

type CommitServiceServer interface {
	CommitIsAncestor(context.Context, *CommitIsAncestorRequest) (*CommitIsAncestorResponse, error)
	TreeEntry(*TreeEntryRequest, CommitService_TreeEntryServer) error
	CommitsBetween(*CommitsBetweenRequest, CommitService_CommitsBetweenServer) error
	CountCommits(context.Context, *CountCommitsRequest) (*CountCommitsResponse, error)
	GetTreeEntries(*GetTreeEntriesRequest, CommitService_GetTreeEntriesServer) error
	ListFiles(*ListFilesRequest, CommitService_ListFilesServer) error
	FindCommit(context.Context, *FindCommitRequest) (*FindCommitResponse, error)
	CommitStats(context.Context, *CommitStatsRequest) (*CommitStatsResponse, error)
	// Use a stream to paginate the result set
	FindAllCommits(*FindAllCommitsRequest, CommitService_FindAllCommitsServer) error
	FindCommits(*FindCommitsRequest, CommitService_FindCommitsServer) error
	CommitLanguages(context.Context, *CommitLanguagesRequest) (*CommitLanguagesResponse, error)
	RawBlame(*RawBlameRequest, CommitService_RawBlameServer) error
	LastCommitForPath(context.Context, *LastCommitForPathRequest) (*LastCommitForPathResponse, error)
	CommitsByMessage(*CommitsByMessageRequest, CommitService_CommitsByMessageServer) error
	ListCommitsByOid(*ListCommitsByOidRequest, CommitService_ListCommitsByOidServer) error
	FilterShasWithSignatures(CommitService_FilterShasWithSignaturesServer) error
	// ExtractCommitSignature returns a stream because the signed text may be
	// arbitrarily large and signature verification is impossible without the
	// full text.
	ExtractCommitSignature(*ExtractCommitSignatureRequest, CommitService_ExtractCommitSignatureServer) error
}

func RegisterCommitServiceServer(s *grpc.Server, srv CommitServiceServer) {
	s.RegisterService(&_CommitService_serviceDesc, srv)
}

func _CommitService_CommitIsAncestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitIsAncestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).CommitIsAncestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/CommitIsAncestor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).CommitIsAncestor(ctx, req.(*CommitIsAncestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_TreeEntry_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TreeEntryRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).TreeEntry(m, &commitServiceTreeEntryServer{stream})
}

type CommitService_TreeEntryServer interface {
	Send(*TreeEntryResponse) error
	grpc.ServerStream
}

type commitServiceTreeEntryServer struct {
	grpc.ServerStream
}

func (x *commitServiceTreeEntryServer) Send(m *TreeEntryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_CommitsBetween_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitsBetweenRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).CommitsBetween(m, &commitServiceCommitsBetweenServer{stream})
}

type CommitService_CommitsBetweenServer interface {
	Send(*CommitsBetweenResponse) error
	grpc.ServerStream
}

type commitServiceCommitsBetweenServer struct {
	grpc.ServerStream
}

func (x *commitServiceCommitsBetweenServer) Send(m *CommitsBetweenResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_CountCommits_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountCommitsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).CountCommits(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/CountCommits",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).CountCommits(ctx, req.(*CountCommitsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_GetTreeEntries_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetTreeEntriesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).GetTreeEntries(m, &commitServiceGetTreeEntriesServer{stream})
}

type CommitService_GetTreeEntriesServer interface {
	Send(*GetTreeEntriesResponse) error
	grpc.ServerStream
}

type commitServiceGetTreeEntriesServer struct {
	grpc.ServerStream
}

func (x *commitServiceGetTreeEntriesServer) Send(m *GetTreeEntriesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_ListFiles_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListFilesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).ListFiles(m, &commitServiceListFilesServer{stream})
}

type CommitService_ListFilesServer interface {
	Send(*ListFilesResponse) error
	grpc.ServerStream
}

type commitServiceListFilesServer struct {
	grpc.ServerStream
}

func (x *commitServiceListFilesServer) Send(m *ListFilesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_FindCommit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindCommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).FindCommit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/FindCommit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).FindCommit(ctx, req.(*FindCommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_CommitStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).CommitStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/CommitStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).CommitStats(ctx, req.(*CommitStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_FindAllCommits_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllCommitsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).FindAllCommits(m, &commitServiceFindAllCommitsServer{stream})
}

type CommitService_FindAllCommitsServer interface {
	Send(*FindAllCommitsResponse) error
	grpc.ServerStream
}

type commitServiceFindAllCommitsServer struct {
	grpc.ServerStream
}

func (x *commitServiceFindAllCommitsServer) Send(m *FindAllCommitsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_FindCommits_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindCommitsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).FindCommits(m, &commitServiceFindCommitsServer{stream})
}

type CommitService_FindCommitsServer interface {
	Send(*FindCommitsResponse) error
	grpc.ServerStream
}

type commitServiceFindCommitsServer struct {
	grpc.ServerStream
}

func (x *commitServiceFindCommitsServer) Send(m *FindCommitsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_CommitLanguages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitLanguagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).CommitLanguages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/CommitLanguages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).CommitLanguages(ctx, req.(*CommitLanguagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_RawBlame_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RawBlameRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).RawBlame(m, &commitServiceRawBlameServer{stream})
}

type CommitService_RawBlameServer interface {
	Send(*RawBlameResponse) error
	grpc.ServerStream
}

type commitServiceRawBlameServer struct {
	grpc.ServerStream
}

func (x *commitServiceRawBlameServer) Send(m *RawBlameResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_LastCommitForPath_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LastCommitForPathRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).LastCommitForPath(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/LastCommitForPath",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).LastCommitForPath(ctx, req.(*LastCommitForPathRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_CommitsByMessage_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitsByMessageRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).CommitsByMessage(m, &commitServiceCommitsByMessageServer{stream})
}

type CommitService_CommitsByMessageServer interface {
	Send(*CommitsByMessageResponse) error
	grpc.ServerStream
}

type commitServiceCommitsByMessageServer struct {
	grpc.ServerStream
}

func (x *commitServiceCommitsByMessageServer) Send(m *CommitsByMessageResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_ListCommitsByOid_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListCommitsByOidRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).ListCommitsByOid(m, &commitServiceListCommitsByOidServer{stream})
}

type CommitService_ListCommitsByOidServer interface {
	Send(*ListCommitsByOidResponse) error
	grpc.ServerStream
}

type commitServiceListCommitsByOidServer struct {
	grpc.ServerStream
}

func (x *commitServiceListCommitsByOidServer) Send(m *ListCommitsByOidResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_FilterShasWithSignatures_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(CommitServiceServer).FilterShasWithSignatures(&commitServiceFilterShasWithSignaturesServer{stream})
}

type CommitService_FilterShasWithSignaturesServer interface {
	Send(*FilterShasWithSignaturesResponse) error
	Recv() (*FilterShasWithSignaturesRequest, error)
	grpc.ServerStream
}

type commitServiceFilterShasWithSignaturesServer struct {
	grpc.ServerStream
}

func (x *commitServiceFilterShasWithSignaturesServer) Send(m *FilterShasWithSignaturesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *commitServiceFilterShasWithSignaturesServer) Recv() (*FilterShasWithSignaturesRequest, error) {
	m := new(FilterShasWithSignaturesRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _CommitService_ExtractCommitSignature_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ExtractCommitSignatureRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).ExtractCommitSignature(m, &commitServiceExtractCommitSignatureServer{stream})
}

type CommitService_ExtractCommitSignatureServer interface {
	Send(*ExtractCommitSignatureResponse) error
	grpc.ServerStream
}

type commitServiceExtractCommitSignatureServer struct {
	grpc.ServerStream
}

func (x *commitServiceExtractCommitSignatureServer) Send(m *ExtractCommitSignatureResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _CommitService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.CommitService",
	HandlerType: (*CommitServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CommitIsAncestor",
			Handler:    _CommitService_CommitIsAncestor_Handler,
		},
		{
			MethodName: "CountCommits",
			Handler:    _CommitService_CountCommits_Handler,
		},
		{
			MethodName: "FindCommit",
			Handler:    _CommitService_FindCommit_Handler,
		},
		{
			MethodName: "CommitStats",
			Handler:    _CommitService_CommitStats_Handler,
		},
		{
			MethodName: "CommitLanguages",
			Handler:    _CommitService_CommitLanguages_Handler,
		},
		{
			MethodName: "LastCommitForPath",
			Handler:    _CommitService_LastCommitForPath_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "TreeEntry",
			Handler:       _CommitService_TreeEntry_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CommitsBetween",
			Handler:       _CommitService_CommitsBetween_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetTreeEntries",
			Handler:       _CommitService_GetTreeEntries_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListFiles",
			Handler:       _CommitService_ListFiles_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllCommits",
			Handler:       _CommitService_FindAllCommits_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindCommits",
			Handler:       _CommitService_FindCommits_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RawBlame",
			Handler:       _CommitService_RawBlame_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CommitsByMessage",
			Handler:       _CommitService_CommitsByMessage_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListCommitsByOid",
			Handler:       _CommitService_ListCommitsByOid_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FilterShasWithSignatures",
			Handler:       _CommitService_FilterShasWithSignatures_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "ExtractCommitSignature",
			Handler:       _CommitService_ExtractCommitSignature_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "commit.proto",
}

func init() { proto.RegisterFile("commit.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 1559 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xdd, 0x6e, 0x1a, 0x47,
	0x14, 0xf6, 0x82, 0xc1, 0x70, 0xa0, 0x0e, 0x9e, 0xfc, 0xe1, 0x75, 0x12, 0x3b, 0xdb, 0x26, 0x25,
	0x4a, 0x45, 0x2c, 0xaa, 0x56, 0xed, 0x55, 0x65, 0x27, 0xd8, 0x75, 0x6a, 0x87, 0x68, 0x8d, 0x14,
	0xa5, 0x37, 0x68, 0xcc, 0x0e, 0x30, 0xf5, 0xc2, 0x92, 0xdd, 0x21, 0x36, 0xad, 0xd4, 0xfb, 0x4a,
	0x7d, 0x92, 0x4a, 0x7d, 0x88, 0xbe, 0x42, 0x1f, 0xa3, 0x8f, 0x10, 0xf5, 0xa2, 0x9a, 0x9f, 0xdd,
	0x59, 0x60, 0x71, 0x1a, 0x5b, 0xe4, 0x06, 0xed, 0x9c, 0x99, 0x39, 0xe7, 0x3b, 0x67, 0xce, 0x2f,
	0x50, 0x6c, 0x7b, 0xfd, 0x3e, 0x65, 0xd5, 0xa1, 0xef, 0x31, 0x0f, 0x65, 0xbb, 0x94, 0x61, 0x77,
	0x6c, 0x16, 0x83, 0x1e, 0xf6, 0x89, 0x23, 0xa9, 0xe6, 0x66, 0xd7, 0xf3, 0xba, 0x2e, 0x79, 0x22,
	0x56, 0x27, 0xa3, 0xce, 0x13, 0x46, 0xfb, 0x24, 0x60, 0xb8, 0x3f, 0x94, 0x07, 0x2c, 0x07, 0xd0,
	0x53, 0xc1, 0xe6, 0x98, 0x61, 0x16, 0xd8, 0xe4, 0xcd, 0x88, 0x04, 0x0c, 0xd5, 0x00, 0x7c, 0x32,
	0xf4, 0x02, 0xca, 0x3c, 0x7f, 0x5c, 0x36, 0xb6, 0x8c, 0x4a, 0xa1, 0x86, 0xaa, 0x52, 0x42, 0xd5,
	0x8e, 0x76, 0xec, 0xd8, 0x29, 0x64, 0x42, 0xce, 0x27, 0x6f, 0x69, 0x40, 0xbd, 0x41, 0x39, 0xb5,
	0x65, 0x54, 0x8a, 0x76, 0xb4, 0xb6, 0xda, 0x70, 0x7d, 0x42, 0x4a, 0x30, 0xf4, 0x06, 0x01, 0x41,
	0x25, 0x48, 0x7b, 0xd4, 0x11, 0xfc, 0xf3, 0x36, 0xff, 0x44, 0x77, 0x20, 0x8f, 0x1d, 0x87, 0x32,
	0xea, 0x0d, 0x02, 0xc1, 0x25, 0x63, 0x6b, 0x02, 0xdf, 0x75, 0x88, 0x4b, 0xe4, 0x6e, 0x5a, 0xee,
	0x46, 0x04, 0xeb, 0x37, 0x03, 0x6e, 0x4b, 0x29, 0x07, 0xc1, 0xce, 0xa0, 0x4d, 0x02, 0xe6, 0xf9,
	0x57, 0x51, 0x68, 0x13, 0x0a, 0x58, 0xb1, 0x69, 0x51, 0x47, 0xa0, 0xc9, 0xdb, 0x10, 0x92, 0x0e,
	0x1c, 0xb4, 0x0e, 0xb9, 0x76, 0x8f, 0xba, 0x0e, 0xdf, 0x4d, 0x8b, 0xdd, 0x15, 0xb1, 0x3e, 0x70,
	0xac, 0x6d, 0x28, 0xcf, 0x42, 0x51, 0x5a, 0xdf, 0x80, 0xcc, 0x5b, 0xec, 0x8e, 0x88, 0x80, 0x91,
	0xb3, 0xe5, 0xc2, 0xfa, 0xdd, 0x80, 0x52, 0xd3, 0x27, 0xa4, 0x3e, 0x60, 0xfe, 0x78, 0x41, 0xef,
	0x80, 0x10, 0x2c, 0x0f, 0x31, 0xeb, 0x09, 0xb4, 0x45, 0x5b, 0x7c, 0x73, 0x38, 0x2e, 0xed, 0x53,
	0x56, 0x5e, 0xde, 0x32, 0x2a, 0x69, 0x5b, 0x2e, 0xac, 0xbf, 0x0d, 0x58, 0x8b, 0xc1, 0x51, 0xd0,
	0xbf, 0x81, 0x65, 0x36, 0x1e, 0x4a, 0xe4, 0xab, 0xb5, 0xcf, 0x42, 0x24, 0x33, 0x07, 0xab, 0x8d,
	0x93, 0x9f, 0x48, 0x9b, 0x35, 0xc7, 0x43, 0x62, 0x8b, 0x1b, 0xe1, 0x53, 0xa7, 0xf4, 0x53, 0x23,
	0x58, 0x0e, 0xe8, 0xcf, 0x44, 0x60, 0x49, 0xdb, 0xe2, 0x9b, 0xd3, 0xfa, 0x9e, 0x43, 0x04, 0x94,
	0x8c, 0x2d, 0xbe, 0x39, 0xcd, 0xc1, 0x0c, 0x97, 0x33, 0x12, 0x33, 0xff, 0xb6, 0xbe, 0x02, 0xd0,
	0x12, 0x10, 0x40, 0xf6, 0x69, 0xe3, 0xe8, 0xe8, 0xa0, 0x59, 0x5a, 0x42, 0x39, 0x58, 0xde, 0x3d,
	0x6c, 0xec, 0x96, 0x0c, 0xfe, 0xd5, 0xb4, 0xeb, 0xf5, 0x52, 0x0a, 0xad, 0x40, 0xba, 0xb9, 0xb3,
	0x5f, 0x4a, 0x5b, 0x1e, 0xdc, 0x94, 0xaf, 0x12, 0xec, 0x12, 0x76, 0x46, 0xc8, 0xe0, 0x2a, 0x76,
	0x46, 0xb0, 0xdc, 0xf1, 0xbd, 0xbe, 0xb2, 0xb1, 0xf8, 0x46, 0xab, 0x90, 0x62, 0x9e, 0xb2, 0x6e,
	0x8a, 0x79, 0x56, 0x1d, 0x6e, 0x4d, 0x0b, 0x54, 0x96, 0x7c, 0x0c, 0x2b, 0x32, 0x7c, 0x83, 0xb2,
	0xb1, 0x95, 0xae, 0x14, 0x6a, 0x6b, 0xa1, 0xb8, 0x7d, 0xca, 0xe4, 0x1d, 0x3b, 0x3c, 0x61, 0xfd,
	0x6b, 0xf0, 0xf8, 0x19, 0x0d, 0xd4, 0xc6, 0xa2, 0xc2, 0x14, 0x6d, 0x43, 0x06, 0x77, 0x18, 0xf1,
	0x85, 0x06, 0x85, 0x9a, 0x59, 0x95, 0xd9, 0xa3, 0x1a, 0x66, 0x8f, 0x6a, 0x33, 0xcc, 0x1e, 0xb6,
	0x3c, 0x88, 0x6a, 0x90, 0x3d, 0x21, 0x1d, 0xcf, 0x97, 0x4f, 0x76, 0xf1, 0x15, 0x75, 0x32, 0x72,
	0xc2, 0x4c, 0xcc, 0x09, 0x37, 0x20, 0xdf, 0xc7, 0xe7, 0xad, 0x36, 0x57, 0xb2, 0x9c, 0x15, 0xaf,
	0x9f, 0xeb, 0xe3, 0x73, 0xa1, 0xb4, 0xf5, 0x05, 0xdc, 0x98, 0xd4, 0x5e, 0x07, 0x92, 0xbc, 0x60,
	0x88, 0x0b, 0x72, 0x61, 0xbd, 0x33, 0x20, 0x1f, 0x39, 0x64, 0x42, 0x8a, 0x59, 0x87, 0x9c, 0xef,
	0x79, 0xac, 0xa5, 0xdd, 0x71, 0x85, 0xaf, 0x1b, 0xd2, 0x25, 0x67, 0xc2, 0xe3, 0x89, 0x72, 0xf9,
	0x65, 0xe1, 0xf2, 0x1b, 0x33, 0x2e, 0x5f, 0x15, 0xbf, 0x31, 0x4f, 0x0f, 0x7d, 0x38, 0x13, 0xf3,
	0xe1, 0xbb, 0x00, 0xf2, 0x2d, 0x85, 0xd4, 0xac, 0x90, 0x9a, 0x97, 0x14, 0x2e, 0x77, 0x03, 0xf2,
	0x1d, 0x17, 0xb3, 0x96, 0x10, 0xbe, 0x22, 0x1f, 0x85, 0x13, 0x5e, 0x62, 0xd6, 0xb3, 0x1e, 0x43,
	0x3e, 0x12, 0x11, 0xb9, 0xf7, 0x52, 0xe4, 0xde, 0x46, 0xcc, 0xfd, 0xd3, 0xd6, 0x2f, 0x70, 0x73,
	0x9f, 0xb0, 0x10, 0x1c, 0x25, 0xc1, 0x47, 0xcc, 0x24, 0xdc, 0xdb, 0xa7, 0x85, 0x6b, 0x6f, 0x27,
	0x92, 0x34, 0xed, 0xed, 0x3a, 0x75, 0x84, 0x27, 0xac, 0x13, 0x28, 0x1d, 0xd2, 0x80, 0xed, 0x51,
	0x77, 0x61, 0xf0, 0xad, 0x47, 0xb0, 0x16, 0x93, 0xa1, 0xfd, 0x89, 0xeb, 0x21, 0x31, 0x16, 0x6d,
	0xb9, 0xb0, 0xda, 0xb0, 0xb6, 0x47, 0x07, 0x8e, 0x8a, 0xc9, 0x05, 0xe1, 0xf9, 0x0e, 0x50, 0x5c,
	0x88, 0x02, 0xf4, 0x08, 0xb2, 0xd2, 0x49, 0x94, 0x84, 0x84, 0x1c, 0xa1, 0x0e, 0x58, 0x2d, 0xb8,
	0xcd, 0x15, 0x0a, 0xb3, 0xcd, 0xb8, 0x41, 0x9d, 0xab, 0x60, 0x8d, 0xd2, 0x75, 0x5a, 0x85, 0x8d,
	0xb5, 0x0f, 0xe5, 0x59, 0x01, 0x97, 0x49, 0x66, 0xef, 0x0c, 0xb8, 0xc9, 0x75, 0xdd, 0x71, 0xdd,
	0x05, 0xa7, 0xb3, 0x89, 0xa4, 0x92, 0x9e, 0x4c, 0x2a, 0xa2, 0xfc, 0x9c, 0xd2, 0x61, 0x58, 0x6a,
	0xf8, 0x37, 0xfa, 0x16, 0x32, 0x9e, 0xef, 0x10, 0x5f, 0xc4, 0xee, 0x6a, 0xed, 0xd3, 0x50, 0x76,
	0x22, 0xdc, 0x6a, 0x83, 0x1f, 0xb5, 0xe5, 0x0d, 0xeb, 0x01, 0x64, 0xc4, 0x9a, 0xc7, 0xe5, 0x8b,
	0xc6, 0x8b, 0xba, 0x8a, 0xd0, 0xc6, 0xcb, 0x86, 0x2c, 0x45, 0xcf, 0x76, 0x9a, 0xf5, 0x52, 0x8a,
	0x87, 0xc8, 0x34, 0xb3, 0xcb, 0xd8, 0xf0, 0x9f, 0x54, 0xdc, 0x5f, 0x16, 0x66, 0xc0, 0xa8, 0x35,
	0x90, 0xc6, 0x93, 0x0b, 0x74, 0x0b, 0xb2, 0x5e, 0xa7, 0x13, 0x10, 0xa6, 0x6c, 0xa7, 0x56, 0x3a,
	0x7c, 0x32, 0xb1, 0xf0, 0xe1, 0xa7, 0x3b, 0x9e, 0xeb, 0x7a, 0x67, 0x22, 0xed, 0xe5, 0x6c, 0xb5,
	0xe2, 0xdd, 0x15, 0xb7, 0x79, 0xab, 0x4f, 0xfc, 0x2e, 0x09, 0x44, 0xd6, 0xcb, 0xd9, 0xc0, 0x49,
	0x47, 0x82, 0x82, 0xee, 0x43, 0xd1, 0xa1, 0x01, 0x3e, 0x71, 0x49, 0xeb, 0x0c, 0xbb, 0xa7, 0xe5,
	0x9c, 0x38, 0x51, 0x50, 0xb4, 0x57, 0xd8, 0x3d, 0xd5, 0xf5, 0x2a, 0xff, 0xe1, 0xf5, 0x0a, 0xfe,
	0x6f, 0xbd, 0xb2, 0x76, 0xe1, 0xfa, 0x84, 0xad, 0x2f, 0xf3, 0x60, 0xbd, 0xb0, 0x11, 0x38, 0xc4,
	0x83, 0xee, 0x08, 0x77, 0x17, 0x97, 0xd9, 0xfe, 0x8c, 0xba, 0xe0, 0x98, 0x28, 0x05, 0x79, 0x0f,
	0xf2, 0x6e, 0x48, 0x54, 0xa0, 0x2b, 0xa1, 0xa8, 0x39, 0x77, 0xaa, 0x21, 0xc5, 0xd6, 0x57, 0xcd,
	0xe7, 0x90, 0x0b, 0xc9, 0x3c, 0x8e, 0x06, 0xb8, 0x4f, 0x54, 0x85, 0x15, 0xdf, 0xdc, 0x13, 0xc4,
	0x14, 0x22, 0xc0, 0xa5, 0x6c, 0xb9, 0x90, 0xe5, 0xda, 0xf5, 0x7c, 0xd5, 0x2b, 0xcb, 0x85, 0x35,
	0x82, 0x6b, 0x36, 0x3e, 0xdb, 0x75, 0x71, 0x9f, 0x7c, 0xcc, 0x5a, 0xf5, 0x10, 0x4a, 0x5a, 0xac,
	0x32, 0x4f, 0xd8, 0x69, 0x1a, 0xb1, 0x4e, 0xf3, 0x57, 0x28, 0x1f, 0xe2, 0x30, 0xed, 0xed, 0x79,
	0x3e, 0x2f, 0xc9, 0x1f, 0x13, 0xe7, 0x1e, 0xac, 0x27, 0xc8, 0xff, 0xf0, 0xfa, 0xf0, 0x57, 0xe4,
	0x16, 0xc1, 0xee, 0xf8, 0x88, 0x04, 0x01, 0x7f, 0xd2, 0x05, 0xe9, 0xa1, 0x13, 0x44, 0x7a, 0x3a,
	0x41, 0xe8, 0x49, 0x23, 0x4a, 0x27, 0x49, 0xed, 0xe0, 0x0d, 0xc8, 0xbc, 0x19, 0x11, 0x7f, 0xac,
	0x5a, 0x25, 0xb9, 0xe0, 0x25, 0x68, 0x56, 0x85, 0xcb, 0x44, 0x23, 0x85, 0xcd, 0x3d, 0xea, 0x32,
	0xe2, 0x1f, 0xf7, 0x70, 0xf0, 0x8a, 0xb2, 0xde, 0x31, 0xed, 0x0e, 0x30, 0x1b, 0xf9, 0x57, 0x0b,
	0x4b, 0x5e, 0x52, 0x7a, 0x38, 0x10, 0x55, 0xb3, 0x68, 0x8b, 0x6f, 0xeb, 0x6b, 0xd8, 0x9a, 0x2f,
	0x4a, 0xfb, 0x9d, 0xb8, 0x67, 0xc4, 0xee, 0x0d, 0xe1, 0x6e, 0xfd, 0x9c, 0xf9, 0xb8, 0xad, 0xc0,
	0x47, 0xd7, 0xae, 0x02, 0x70, 0x03, 0x54, 0xd3, 0xa9, 0xe7, 0xd9, 0x9c, 0x24, 0x1c, 0x38, 0x56,
	0x0b, 0xee, 0xcd, 0x93, 0xa8, 0x70, 0xde, 0x81, 0x7c, 0x10, 0x12, 0x55, 0x90, 0x68, 0x82, 0x48,
	0xe8, 0xb4, 0x3b, 0x20, 0x4e, 0x8b, 0x91, 0x73, 0xa6, 0x9c, 0x02, 0x24, 0xa9, 0x49, 0xce, 0x59,
	0xed, 0x8f, 0x02, 0x7c, 0xa2, 0x58, 0x13, 0xff, 0x2d, 0x6d, 0x13, 0xf4, 0x0a, 0x4a, 0xd3, 0x53,
	0x32, 0xda, 0x9c, 0x4c, 0x48, 0x33, 0xa3, 0xbc, 0xb9, 0x35, 0xff, 0x80, 0xc4, 0x69, 0x2d, 0xa1,
	0x67, 0xf1, 0x11, 0xa0, 0x9c, 0x30, 0xa6, 0x4a, 0x56, 0xeb, 0x73, 0x07, 0x58, 0x6b, 0x69, 0xdb,
	0x40, 0xc7, 0xb0, 0x3a, 0x39, 0xbd, 0xa1, 0xbb, 0x93, 0xb2, 0xa7, 0xc6, 0x48, 0xf3, 0xde, 0xbc,
	0xed, 0x18, 0xd3, 0x1f, 0xa0, 0x18, 0x1f, 0x66, 0xd0, 0x86, 0xbe, 0x33, 0x33, 0xe0, 0x99, 0x77,
	0x92, 0x37, 0x23, 0x3d, 0x8f, 0x61, 0x75, 0xb2, 0xe3, 0xd6, 0x08, 0x13, 0xc7, 0x00, 0x8d, 0x30,
	0xb9, 0x51, 0x17, 0x08, 0x9f, 0x41, 0x3e, 0xea, 0x8d, 0xb5, 0xf1, 0xa6, 0x5b, 0x72, 0x6d, 0xbc,
	0x99, 0x46, 0x5a, 0x70, 0xa9, 0x03, 0xe8, 0xaa, 0x89, 0xd6, 0xe3, 0xad, 0xd4, 0x44, 0x2b, 0x6d,
	0x9a, 0x49, 0x5b, 0x91, 0x86, 0xdf, 0x43, 0x21, 0xf6, 0xcf, 0x11, 0x32, 0x27, 0x2d, 0x1c, 0xff,
	0xd3, 0xca, 0xdc, 0x48, 0xdc, 0x8b, 0xdb, 0x6a, 0xb2, 0xf5, 0xd2, 0xb6, 0x4a, 0xec, 0xef, 0xb4,
	0xad, 0x92, 0x3b, 0x36, 0xa1, 0xe5, 0x73, 0x28, 0xc4, 0x7a, 0x03, 0x94, 0xa0, 0xcb, 0x2c, 0xbc,
	0x84, 0x66, 0x42, 0xf0, 0x6a, 0xc2, 0xb5, 0xa9, 0x22, 0x8c, 0xee, 0xcd, 0xad, 0xce, 0x92, 0xe7,
	0xe6, 0x7b, 0xaa, 0xb7, 0xb5, 0x84, 0x76, 0x20, 0x17, 0x16, 0x3a, 0x74, 0x3b, 0xca, 0x0f, 0x93,
	0x15, 0xd7, 0x2c, 0xcf, 0x6e, 0xc4, 0x80, 0xfd, 0x08, 0x6b, 0x33, 0x35, 0x08, 0x45, 0x61, 0x38,
	0xaf, 0x3c, 0x9a, 0xf7, 0x2f, 0x38, 0x11, 0xc1, 0x7b, 0x1d, 0xa6, 0x00, 0x9d, 0xd3, 0xa7, 0x53,
	0xc0, 0x4c, 0xc1, 0x9a, 0x4e, 0x01, 0xb3, 0xe5, 0x40, 0xc0, 0x7e, 0x2d, 0xe7, 0xc8, 0xf8, 0xc4,
	0xa2, 0x59, 0xcf, 0x19, 0x96, 0x34, 0xeb, 0x79, 0xc3, 0x8e, 0x60, 0x1d, 0x40, 0x79, 0x5e, 0x56,
	0x47, 0x9f, 0xeb, 0x77, 0xbe, 0xb0, 0xc4, 0x98, 0x95, 0xf7, 0x1f, 0x0c, 0x45, 0x56, 0x8c, 0x6d,
	0x03, 0x9d, 0xc2, 0xad, 0xe4, 0x04, 0x8d, 0x1e, 0x84, 0x9c, 0x2e, 0x2c, 0x19, 0xe6, 0xc3, 0xf7,
	0x1d, 0xd3, 0x1a, 0x9e, 0x64, 0x45, 0x43, 0xfc, 0xe5, 0x7f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xc0,
	0x6e, 0x68, 0x46, 0x65, 0x16, 0x00, 0x00,
}
