/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _rpc_h_
#define _rpc_h_

#include <globus_io.h>

#define RPCBSIZ	8192
typedef struct {
  globus_byte_t	buf[RPCBSIZ];
  int		idx;
  globus_size_t	len;
} BUFFER;

#define NEXTC(h,b,rcp,errmsg)	((b)->idx < (b)->len ? (b)->buf[(b)->idx++] : \
				  rrpc_fillbuf((h), (b), (rcp), (errmsg)))

extern int	rrpc_connect(char *host, unsigned short port,
			     globus_io_attr_t *attr, globus_io_handle_t *h,
			     char *errmsg, int errmsglen);
extern void	rrpc_initbuf(BUFFER *b);
extern int	rrpc_fillbuf(globus_io_handle_t *h, BUFFER *b, int *rcp,
			     char *errmsg);
extern int	rrpc_getresult(globus_rls_handle_t *h, BUFFER *b,char *errmsg);
extern int	rrpc_get_timeout();
extern int	rrpc_globuserr(char *errmsg,int len,globus_result_t r);
extern int	rrpc_read(globus_io_handle_t *h, globus_byte_t *buf,
			  globus_size_t max_nb, globus_size_t wait_nb,
			  globus_size_t *nbr, char *errmsg);
void		rrpc_set_timeout(int timeout);
extern int	rrpc_write(globus_io_handle_t *h, globus_byte_t *buf,
			   globus_size_t nb, globus_size_t *nbw, char *errmsg);
extern int	rrpc_writev(globus_io_handle_t *h, struct iovec *iov,
			    globus_size_t iovcnt, globus_size_t *nbw,
			    char *errmsg);
extern int	rrpc_bufwrite(globus_io_handle_t *h, BUFFER *b, char *buf,
			      int nb, int flush, char *errmsg);
extern int	rrpc_bufprintf(globus_io_handle_t *h, BUFFER *b, int flush,
			       char *errmsg, char *fmt, ...);

#endif
