-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_license.adb,v $
--  Description     : Display the license information on in a small browser  --
--  Author          : Michael Erdmann                                        --
--  Created         : 23.9.2001                                              --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/05/30 07:19:16 $
--  Status          : $State: Exp $
--                                                                           --
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;              use Ada.Text_IO;

with Glib;                     use Glib;
with Gdk.Color;                use Gdk.Color;
with Gdk.Font;                 use Gdk.Font;
with Gtk.Box;                  use Gtk.Box;
with Gtk.Check_Button;         use Gtk.Check_Button;
with Gtk.Enums;                use Gtk.Enums;
with Gtk.Hbutton_Box;          use Gtk.Hbutton_Box;
with Gtk.Handlers;             use Gtk.Handlers;
with Gtk.Main;                 use Gtk.Main;
with Gtk.Scrolled_Window;      use Gtk.Scrolled_Window;
with Gtk.Text;                 use Gtk.Text;
with Gtk;                      use Gtk;

with GUI_Dialog;               use GUI_Dialog;
with GUI_Logging;              use GUI_Logging;
with GUI_Menu;                 use GUI_Menu;

package body GUI_License is

   Version      : constant String :=
      "$Id: gui_license.adb,v 1.4 2002/05/30 07:19:16 merdmann Exp $";

   Cmd_Disagree : constant Natural := 100;

   ---------------------
   -- Dialog_Contents --
   ---------------------
   procedure Dialog_Contents(
      This     : in out Object;
      Vbox     : in Gtk_Box ) is
      Scrolled : Gtk_Scrolled_Window;
      Text     : Gtk_Text;
   begin
      Gtk_New (Scrolled);
      Pack_Start (Vbox, Scrolled, True, True, 0 );
      Set_Policy (Scrolled, Policy_Never, Policy_Always);
      Show (Scrolled);

      Gtk_New (Text);
      Set_Editable (Text, False);
      Add( Scrolled, Text );
      Show_All (Text);

      declare
         Buffer : String (1 .. 1024);
         Last   : Natural;
         Infile       : File_Type;
      begin

         Open (Infile, In_File, "COPYING");
         while not End_Of_File (Infile) loop
            Get_Line (Infile, Buffer, Last);

            Insert (Text, Null_Font, Null_Color,
                    Null_Color,
                    Buffer (1 .. Last) & Ascii.LF, Gint (Last) + 1);
         end loop;
         Close (Infile);

      exception
         when Name_Error =>
            Error ("License file not found");
      end;

      Add_Command( This, "I disagree", Cmd_Disagree );

   end Dialog_Contents;

   -------------
   -- Command --
   -------------
   procedure Command(
      This : in out Object;
      Cmd  : in Natural ) is
   begin
      Put_Line("Calling command");
      case Cmd is
         when Dlg_Cmd_Dismiss =>
            GUI_Dialog.Command( GUI_Dialog.Object(This), Cmd );

         when Cmd_Disagree =>
            GUI_Menu.Dont_Save := True;
            Gtk.Main.Main_Quit;

         when others =>
            GUI_Logging.Error("Unknown internal command in gui_addrow.adb");
      end case;
   end Command;

end GUI_License;
