/* 
 * Copyright (C) 2004, 2005 Jean-Yves Lefort <jylefort@brutele.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GT_UTIL_H
#define _GT_UTIL_H

#include <stdarg.h>
#include <gtk/gtk.h>
#include <libgnomevfs/gnome-vfs.h>

#define GT_LIST_FOREACH(var, head)		\
for ((var) = (head);				\
     (var);					\
     (var) = (var)->next)

#define GT_UI_FILE(filename) UIDIR G_DIR_SEPARATOR_S filename

GtkWidget *gt_error_dialog (GtkWindow *parent,
			    const char *primary,
			    const char *format,
			    ...) G_GNUC_PRINTF(3, 4);
void gt_fatal_error_dialog (GtkWindow *parent,
			    const char *format,
			    ...) G_GNUC_PRINTF(2, 3);

void gt_create_interface (const char *name, ...);

#define GT_TEXT_BUFFER(view) gtk_text_view_get_buffer(GTK_TEXT_VIEW((view)))

void gt_text_buffer_clear (GtkTextBuffer *buffer);
char *gt_text_buffer_get_all_text (GtkTextBuffer *buffer);

GnomeVFSResult gt_vfs_write_file (const char *uri, const char *contents);
gboolean gt_vfs_uri_exists (const char *text_uri);

GSList *gt_g_utf8_slist_find (GSList *list, const char *str);

char *gt_vfs_read_entire_file (const char *uri, GError **err);

typedef gpointer (*GTCopyFunc) (gconstpointer data, gpointer user_data);
GSList *gt_g_slist_copy_deep (const GSList *list,
			      GTCopyFunc copy_func,
			      gpointer user_data);

void gt_g_object_slist_free (GSList *list);

void gt_thread_create (GtkWindow *parent, GThreadFunc func, gpointer data);

gpointer gt_g_object_connect (gpointer object,
			      gpointer instance,
			      const char *signal_spec,
			      ...);

double gt_get_current_time (void);
const char *gt_dot_dir (void);

GList *gt_window_icon_list_new (const char *icon_name);

typedef enum
{
  GT_TOOLBAR_STYLE_DESKTOP_DEFAULT,
  GT_TOOLBAR_STYLE_ICONS,
  GT_TOOLBAR_STYLE_TEXT,
  GT_TOOLBAR_STYLE_BOTH,
  GT_TOOLBAR_STYLE_BOTH_HORIZ
} GTToolbarStyle;

GType gt_toolbar_style_get_type (void);
#define GT_TYPE_TOOLBAR_STYLE (gt_toolbar_style_get_type())

void gt_source_remove (unsigned int *tag);

void gt_display_help (GtkWindow *parent, const char *link_id);

#endif /* _GT_UTIL_H */
