// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1/model.proto

package automl

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Deployment state of the model.
type Model_DeploymentState int32

const (
	// Should not be used, an un-set enum has this value by default.
	Model_DEPLOYMENT_STATE_UNSPECIFIED Model_DeploymentState = 0
	// Model is deployed.
	Model_DEPLOYED Model_DeploymentState = 1
	// Model is not deployed.
	Model_UNDEPLOYED Model_DeploymentState = 2
)

var Model_DeploymentState_name = map[int32]string{
	0: "DEPLOYMENT_STATE_UNSPECIFIED",
	1: "DEPLOYED",
	2: "UNDEPLOYED",
}

var Model_DeploymentState_value = map[string]int32{
	"DEPLOYMENT_STATE_UNSPECIFIED": 0,
	"DEPLOYED":                     1,
	"UNDEPLOYED":                   2,
}

func (x Model_DeploymentState) String() string {
	return proto.EnumName(Model_DeploymentState_name, int32(x))
}

func (Model_DeploymentState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_452845e4ed6fce9d, []int{0, 0}
}

// API proto representing a trained machine learning model.
type Model struct {
	// Required.
	// The model metadata that is specific to the problem type.
	// Must match the metadata type of the dataset used to train the model.
	//
	// Types that are valid to be assigned to ModelMetadata:
	//	*Model_TranslationModelMetadata
	//	*Model_ImageClassificationModelMetadata
	//	*Model_TextClassificationModelMetadata
	//	*Model_ImageObjectDetectionModelMetadata
	//	*Model_TextExtractionModelMetadata
	//	*Model_TextSentimentModelMetadata
	ModelMetadata isModel_ModelMetadata `protobuf_oneof:"model_metadata"`
	// Output only. Resource name of the model.
	// Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the model to show in the interface. The name can be
	// up to 32 characters long and can consist only of ASCII Latin letters A-Z
	// and a-z, underscores
	// (_), and ASCII digits 0-9. It must start with a letter.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The resource ID of the dataset used to create the model. The dataset must
	// come from the same ancestor project and location.
	DatasetId string `protobuf:"bytes,3,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Output only. Timestamp when the model training finished  and can be used for prediction.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this model was last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Deployment state of the model. A model can only serve
	// prediction requests after it gets deployed.
	DeploymentState Model_DeploymentState `protobuf:"varint,8,opt,name=deployment_state,json=deploymentState,proto3,enum=google.cloud.automl.v1.Model_DeploymentState" json:"deployment_state,omitempty"`
	// Used to perform a consistent read-modify-write updates. If not set, a blind
	// "overwrite" update happens.
	Etag string `protobuf:"bytes,10,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. The labels with user-defined metadata to organize your model.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	Labels               map[string]string `protobuf:"bytes,34,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Model) Reset()         { *m = Model{} }
func (m *Model) String() string { return proto.CompactTextString(m) }
func (*Model) ProtoMessage()    {}
func (*Model) Descriptor() ([]byte, []int) {
	return fileDescriptor_452845e4ed6fce9d, []int{0}
}

func (m *Model) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model.Unmarshal(m, b)
}
func (m *Model) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model.Marshal(b, m, deterministic)
}
func (m *Model) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model.Merge(m, src)
}
func (m *Model) XXX_Size() int {
	return xxx_messageInfo_Model.Size(m)
}
func (m *Model) XXX_DiscardUnknown() {
	xxx_messageInfo_Model.DiscardUnknown(m)
}

var xxx_messageInfo_Model proto.InternalMessageInfo

type isModel_ModelMetadata interface {
	isModel_ModelMetadata()
}

type Model_TranslationModelMetadata struct {
	TranslationModelMetadata *TranslationModelMetadata `protobuf:"bytes,15,opt,name=translation_model_metadata,json=translationModelMetadata,proto3,oneof"`
}

type Model_ImageClassificationModelMetadata struct {
	ImageClassificationModelMetadata *ImageClassificationModelMetadata `protobuf:"bytes,13,opt,name=image_classification_model_metadata,json=imageClassificationModelMetadata,proto3,oneof"`
}

type Model_TextClassificationModelMetadata struct {
	TextClassificationModelMetadata *TextClassificationModelMetadata `protobuf:"bytes,14,opt,name=text_classification_model_metadata,json=textClassificationModelMetadata,proto3,oneof"`
}

type Model_ImageObjectDetectionModelMetadata struct {
	ImageObjectDetectionModelMetadata *ImageObjectDetectionModelMetadata `protobuf:"bytes,20,opt,name=image_object_detection_model_metadata,json=imageObjectDetectionModelMetadata,proto3,oneof"`
}

type Model_TextExtractionModelMetadata struct {
	TextExtractionModelMetadata *TextExtractionModelMetadata `protobuf:"bytes,19,opt,name=text_extraction_model_metadata,json=textExtractionModelMetadata,proto3,oneof"`
}

type Model_TextSentimentModelMetadata struct {
	TextSentimentModelMetadata *TextSentimentModelMetadata `protobuf:"bytes,22,opt,name=text_sentiment_model_metadata,json=textSentimentModelMetadata,proto3,oneof"`
}

func (*Model_TranslationModelMetadata) isModel_ModelMetadata() {}

func (*Model_ImageClassificationModelMetadata) isModel_ModelMetadata() {}

func (*Model_TextClassificationModelMetadata) isModel_ModelMetadata() {}

func (*Model_ImageObjectDetectionModelMetadata) isModel_ModelMetadata() {}

func (*Model_TextExtractionModelMetadata) isModel_ModelMetadata() {}

func (*Model_TextSentimentModelMetadata) isModel_ModelMetadata() {}

func (m *Model) GetModelMetadata() isModel_ModelMetadata {
	if m != nil {
		return m.ModelMetadata
	}
	return nil
}

func (m *Model) GetTranslationModelMetadata() *TranslationModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_TranslationModelMetadata); ok {
		return x.TranslationModelMetadata
	}
	return nil
}

func (m *Model) GetImageClassificationModelMetadata() *ImageClassificationModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_ImageClassificationModelMetadata); ok {
		return x.ImageClassificationModelMetadata
	}
	return nil
}

func (m *Model) GetTextClassificationModelMetadata() *TextClassificationModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_TextClassificationModelMetadata); ok {
		return x.TextClassificationModelMetadata
	}
	return nil
}

func (m *Model) GetImageObjectDetectionModelMetadata() *ImageObjectDetectionModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_ImageObjectDetectionModelMetadata); ok {
		return x.ImageObjectDetectionModelMetadata
	}
	return nil
}

func (m *Model) GetTextExtractionModelMetadata() *TextExtractionModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_TextExtractionModelMetadata); ok {
		return x.TextExtractionModelMetadata
	}
	return nil
}

func (m *Model) GetTextSentimentModelMetadata() *TextSentimentModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_TextSentimentModelMetadata); ok {
		return x.TextSentimentModelMetadata
	}
	return nil
}

func (m *Model) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Model) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Model) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *Model) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Model) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Model) GetDeploymentState() Model_DeploymentState {
	if m != nil {
		return m.DeploymentState
	}
	return Model_DEPLOYMENT_STATE_UNSPECIFIED
}

func (m *Model) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Model) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Model) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Model_TranslationModelMetadata)(nil),
		(*Model_ImageClassificationModelMetadata)(nil),
		(*Model_TextClassificationModelMetadata)(nil),
		(*Model_ImageObjectDetectionModelMetadata)(nil),
		(*Model_TextExtractionModelMetadata)(nil),
		(*Model_TextSentimentModelMetadata)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.cloud.automl.v1.Model_DeploymentState", Model_DeploymentState_name, Model_DeploymentState_value)
	proto.RegisterType((*Model)(nil), "google.cloud.automl.v1.Model")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.automl.v1.Model.LabelsEntry")
}

func init() {
	proto.RegisterFile("google/cloud/automl/v1/model.proto", fileDescriptor_452845e4ed6fce9d)
}

var fileDescriptor_452845e4ed6fce9d = []byte{
	// 759 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x55, 0x51, 0x4f, 0xdb, 0x3a,
	0x18, 0x25, 0xe5, 0xc2, 0x05, 0x97, 0x5b, 0x2a, 0x5f, 0x84, 0x42, 0x81, 0x4b, 0xe9, 0xd5, 0xa4,
	0xee, 0x61, 0xc9, 0x5a, 0xa4, 0x0d, 0xc2, 0x5e, 0x0a, 0xcd, 0xb6, 0x4a, 0xb4, 0xb0, 0xb6, 0x20,
	0x36, 0x21, 0x45, 0x6e, 0x62, 0xa2, 0x6c, 0x49, 0x1c, 0xc5, 0x2e, 0xa3, 0x43, 0xbc, 0x4e, 0xda,
	0xc3, 0xf6, 0x43, 0xf8, 0x29, 0xfb, 0x29, 0xfc, 0x8a, 0x29, 0x76, 0x52, 0xa0, 0x6a, 0xda, 0xa7,
	0x7e, 0xf6, 0x39, 0xe7, 0xfb, 0x4e, 0x4e, 0xec, 0x06, 0x94, 0x6c, 0x42, 0x6c, 0x17, 0xab, 0xa6,
	0x4b, 0xfa, 0x96, 0x8a, 0xfa, 0x8c, 0x78, 0xae, 0x7a, 0x55, 0x51, 0x3d, 0x62, 0x61, 0x57, 0x09,
	0x42, 0xc2, 0x08, 0x5c, 0x15, 0x1c, 0x85, 0x73, 0x14, 0xc1, 0x51, 0xae, 0x2a, 0x85, 0xb5, 0x58,
	0x8b, 0x02, 0x47, 0x0d, 0x31, 0x25, 0xfd, 0xd0, 0xc4, 0x42, 0x52, 0x48, 0x6b, 0xeb, 0x78, 0xc8,
	0x4e, 0x38, 0xdb, 0x29, 0x1c, 0x86, 0xaf, 0x59, 0x4c, 0x29, 0xa7, 0x51, 0x42, 0xe4, 0x53, 0x17,
	0x31, 0x87, 0xf8, 0x31, 0x73, 0x2b, 0x66, 0xf2, 0x55, 0xaf, 0x7f, 0xa9, 0x32, 0xc7, 0xc3, 0x94,
	0x21, 0x2f, 0x88, 0x09, 0x1b, 0x8f, 0xcc, 0x22, 0xdf, 0x27, 0x8c, 0xab, 0xa9, 0x40, 0x4b, 0xbf,
	0xb2, 0x60, 0xae, 0x19, 0x3d, 0x32, 0x0c, 0x40, 0xe1, 0x51, 0x77, 0x83, 0xe7, 0x60, 0x78, 0x98,
	0x21, 0x0b, 0x31, 0x24, 0x2f, 0x17, 0xa5, 0x72, 0xb6, 0xfa, 0x52, 0x19, 0x9f, 0x88, 0xd2, 0x7d,
	0x50, 0xf2, 0x6e, 0xcd, 0x58, 0xf7, 0x7e, 0xa6, 0x2d, 0xb3, 0x14, 0x0c, 0xfe, 0x90, 0xc0, 0xff,
	0x3c, 0x17, 0xc3, 0x74, 0x11, 0xa5, 0xce, 0xa5, 0x63, 0x8e, 0x9d, 0xfd, 0x0f, 0x9f, 0xbd, 0x9b,
	0x36, 0xbb, 0x11, 0xb5, 0x38, 0x7c, 0xd2, 0x61, 0xd4, 0x43, 0xd1, 0x99, 0xc2, 0x81, 0xdf, 0x25,
	0x50, 0x8a, 0xf2, 0x9f, 0x62, 0x25, 0xc7, 0xad, 0xbc, 0x4e, 0x8d, 0x01, 0x5f, 0xb3, 0xc9, 0x4e,
	0xb6, 0xd8, 0x64, 0x0a, 0xfc, 0x29, 0x81, 0x67, 0x22, 0x14, 0xd2, 0xfb, 0x8c, 0x4d, 0x66, 0x58,
	0x98, 0x61, 0x73, 0x9c, 0x97, 0x15, 0xee, 0x65, 0x6f, 0x62, 0x2c, 0xc7, 0xbc, 0x47, 0x3d, 0x69,
	0x31, 0xea, 0x66, 0xdb, 0x99, 0x46, 0x82, 0xdf, 0xc0, 0x7f, 0x3c, 0x17, 0x7c, 0xcd, 0x42, 0x34,
	0xd6, 0xc7, 0xbf, 0xdc, 0xc7, 0xce, 0xa4, 0x4c, 0xf4, 0xa1, 0x78, 0xd4, 0xc1, 0x3a, 0x4b, 0x87,
	0xe1, 0x57, 0xb0, 0xc9, 0x67, 0x53, 0xec, 0x47, 0xa7, 0xda, 0x67, 0xa3, 0xa3, 0x57, 0xf9, 0xe8,
	0xea, 0xa4, 0xd1, 0x9d, 0x44, 0x3b, 0x3a, 0xb9, 0xc0, 0x52, 0x51, 0x08, 0xc1, 0x5f, 0x3e, 0xf2,
	0xb0, 0x2c, 0x15, 0xa5, 0xf2, 0x62, 0x9b, 0xd7, 0x70, 0x1b, 0x2c, 0x59, 0x0e, 0x0d, 0x5c, 0x34,
	0x30, 0x38, 0x96, 0xe1, 0x58, 0x36, 0xde, 0x6b, 0x45, 0x94, 0x4d, 0x00, 0x22, 0x39, 0xc5, 0xcc,
	0x70, 0x2c, 0x79, 0x96, 0x13, 0x16, 0xe3, 0x9d, 0x86, 0x05, 0xf7, 0x41, 0xd6, 0x0c, 0x31, 0x62,
	0xd8, 0x88, 0x66, 0xca, 0x7f, 0x73, 0xf3, 0x85, 0xc4, 0x7c, 0x72, 0x81, 0x95, 0x6e, 0x72, 0x81,
	0xdb, 0x40, 0xd0, 0xa3, 0x8d, 0x48, 0xdc, 0x0f, 0xac, 0xa1, 0x38, 0x3b, 0x5d, 0x2c, 0xe8, 0x5c,
	0x7c, 0x0e, 0xf2, 0x16, 0x0e, 0x5c, 0x32, 0xe0, 0x21, 0x52, 0x86, 0x18, 0x96, 0x17, 0x8a, 0x52,
	0x39, 0x57, 0x7d, 0x91, 0x96, 0x1d, 0x0f, 0x44, 0xa9, 0x0f, 0x55, 0x9d, 0x48, 0xd4, 0x5e, 0xb6,
	0x9e, 0x6e, 0x44, 0x49, 0x61, 0x86, 0x6c, 0x19, 0x88, 0xa4, 0xa2, 0x1a, 0xd6, 0xc0, 0xbc, 0x8b,
	0x7a, 0xd8, 0xa5, 0x72, 0xa9, 0x38, 0x5b, 0xce, 0x56, 0x9f, 0x4f, 0x9e, 0x71, 0xc4, 0xb9, 0xba,
	0xcf, 0xc2, 0x41, 0x3b, 0x16, 0x16, 0xf6, 0x40, 0xf6, 0xd1, 0x36, 0xcc, 0x83, 0xd9, 0x2f, 0x78,
	0x10, 0xbf, 0x8e, 0xa8, 0x84, 0x2b, 0x60, 0xee, 0x0a, 0xb9, 0xfd, 0xe4, 0x35, 0x88, 0x85, 0x96,
	0xd9, 0x95, 0x4a, 0x1f, 0xc0, 0xf2, 0x88, 0x6b, 0x58, 0x04, 0x1b, 0x75, 0xfd, 0xe4, 0xe8, 0xf8,
	0x63, 0x53, 0x6f, 0x75, 0x8d, 0x4e, 0xb7, 0xd6, 0xd5, 0x8d, 0xd3, 0x56, 0xe7, 0x44, 0x3f, 0x6c,
	0xbc, 0x6d, 0xe8, 0xf5, 0xfc, 0x0c, 0x5c, 0x02, 0x0b, 0x82, 0xa1, 0xd7, 0xf3, 0x12, 0xcc, 0x01,
	0x70, 0xda, 0x1a, 0xae, 0x33, 0xda, 0xf9, 0x7d, 0xed, 0x14, 0xac, 0xc7, 0xbe, 0xc5, 0xb3, 0xa0,
	0xc0, 0xa1, 0x8a, 0x49, 0x3c, 0x55, 0xfc, 0x79, 0xbe, 0x0a, 0x42, 0x12, 0x5d, 0x22, 0xaa, 0xde,
	0xc4, 0xd5, 0xad, 0xea, 0x12, 0x71, 0xbf, 0xa9, 0x7a, 0x93, 0x94, 0xb7, 0xe2, 0xf3, 0x42, 0xd5,
	0x1b, 0xfe, 0x7b, 0x7b, 0x90, 0x07, 0xb9, 0xa7, 0x47, 0xfa, 0xe0, 0x4e, 0x02, 0x05, 0x93, 0x78,
	0x29, 0x91, 0x9d, 0x48, 0x9f, 0xde, 0xc4, 0x88, 0x4d, 0x5c, 0xe4, 0xdb, 0x0a, 0x09, 0x6d, 0xd5,
	0xc6, 0x3e, 0x3f, 0x00, 0xea, 0x83, 0xb7, 0xd1, 0x2f, 0xc7, 0xbe, 0xa8, 0xee, 0x32, 0xab, 0xef,
	0x84, 0xfc, 0x90, 0x37, 0xae, 0xf5, 0x19, 0x69, 0x1e, 0x29, 0x67, 0x95, 0xdf, 0x09, 0x70, 0xc1,
	0x81, 0x0b, 0x0e, 0xb8, 0x17, 0x67, 0x95, 0xfb, 0xcc, 0x9a, 0x00, 0x34, 0x8d, 0x23, 0x9a, 0x26,
	0x34, 0x9a, 0x76, 0x56, 0xe9, 0xcd, 0xf3, 0xb1, 0x3b, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x7a,
	0xe5, 0x86, 0xae, 0x4d, 0x07, 0x00, 0x00,
}
