/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Event;
import com.garmin.fit.EventType;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.LengthType;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgWithEvent;
import com.garmin.fit.SwimStroke;

public class LengthMesg
extends Mesg
implements MesgWithEvent {
    protected static final Mesg lengthMesg = new Mesg("length", 101);

    public LengthMesg() {
        super(Factory.createMesg(101));
    }

    public LengthMesg(Mesg mesg) {
        super(mesg);
    }

    public Integer getMessageIndex() {
        return this.getFieldIntegerValue(254, 0, 65535);
    }

    public void setMessageIndex(Integer n) {
        this.setFieldValue(254, 0, (Object)n, 65535);
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    @Override
    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    @Override
    public Event getEvent() {
        Short s = this.getFieldShortValue(0, 0, 65535);
        if (s == null) {
            return null;
        }
        return Event.getByValue(s);
    }

    @Override
    public void setEvent(Event event) {
        this.setFieldValue(0, 0, (Object)event.value, 65535);
    }

    @Override
    public EventType getEventType() {
        Short s = this.getFieldShortValue(1, 0, 65535);
        if (s == null) {
            return null;
        }
        return EventType.getByValue(s);
    }

    @Override
    public void setEventType(EventType eventType) {
        this.setFieldValue(1, 0, (Object)eventType.value, 65535);
    }

    public DateTime getStartTime() {
        return this.timestampToDateTime(this.getFieldLongValue(2, 0, 65535));
    }

    public void setStartTime(DateTime dateTime) {
        this.setFieldValue(2, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public Float getTotalElapsedTime() {
        return this.getFieldFloatValue(3, 0, 65535);
    }

    public void setTotalElapsedTime(Float f) {
        this.setFieldValue(3, 0, (Object)f, 65535);
    }

    public Float getTotalTimerTime() {
        return this.getFieldFloatValue(4, 0, 65535);
    }

    public void setTotalTimerTime(Float f) {
        this.setFieldValue(4, 0, (Object)f, 65535);
    }

    public Integer getTotalStrokes() {
        return this.getFieldIntegerValue(5, 0, 65535);
    }

    public void setTotalStrokes(Integer n) {
        this.setFieldValue(5, 0, (Object)n, 65535);
    }

    public Float getAvgSpeed() {
        return this.getFieldFloatValue(6, 0, 65535);
    }

    public void setAvgSpeed(Float f) {
        this.setFieldValue(6, 0, (Object)f, 65535);
    }

    public SwimStroke getSwimStroke() {
        Short s = this.getFieldShortValue(7, 0, 65535);
        if (s == null) {
            return null;
        }
        return SwimStroke.getByValue(s);
    }

    public void setSwimStroke(SwimStroke swimStroke) {
        this.setFieldValue(7, 0, (Object)swimStroke.value, 65535);
    }

    public Short getAvgSwimmingCadence() {
        return this.getFieldShortValue(9, 0, 65535);
    }

    public void setAvgSwimmingCadence(Short s) {
        this.setFieldValue(9, 0, (Object)s, 65535);
    }

    @Override
    public Short getEventGroup() {
        return this.getFieldShortValue(10, 0, 65535);
    }

    @Override
    public void setEventGroup(Short s) {
        this.setFieldValue(10, 0, (Object)s, 65535);
    }

    public Integer getTotalCalories() {
        return this.getFieldIntegerValue(11, 0, 65535);
    }

    public void setTotalCalories(Integer n) {
        this.setFieldValue(11, 0, (Object)n, 65535);
    }

    public LengthType getLengthType() {
        Short s = this.getFieldShortValue(12, 0, 65535);
        if (s == null) {
            return null;
        }
        return LengthType.getByValue(s);
    }

    public void setLengthType(LengthType lengthType) {
        this.setFieldValue(12, 0, (Object)lengthType.value, 65535);
    }

    public Integer getPlayerScore() {
        return this.getFieldIntegerValue(18, 0, 65535);
    }

    public void setPlayerScore(Integer n) {
        this.setFieldValue(18, 0, (Object)n, 65535);
    }

    public Integer getOpponentScore() {
        return this.getFieldIntegerValue(19, 0, 65535);
    }

    public void setOpponentScore(Integer n) {
        this.setFieldValue(19, 0, (Object)n, 65535);
    }

    public int getNumStrokeCount() {
        return this.getNumFieldValues(20, 65535);
    }

    public Integer getStrokeCount(int n) {
        return this.getFieldIntegerValue(20, n, 65535);
    }

    public void setStrokeCount(int n, Integer n2) {
        this.setFieldValue(20, n, (Object)n2, 65535);
    }

    public int getNumZoneCount() {
        return this.getNumFieldValues(21, 65535);
    }

    public Integer getZoneCount(int n) {
        return this.getFieldIntegerValue(21, n, 65535);
    }

    public void setZoneCount(int n, Integer n2) {
        this.setFieldValue(21, n, (Object)n2, 65535);
    }

    static {
        lengthMesg.addField(new Field("message_index", 254, 132, 1.0, 0.0, "", false));
        lengthMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "", false));
        lengthMesg.addField(new Field("event", 0, 0, 1.0, 0.0, "", false));
        lengthMesg.addField(new Field("event_type", 1, 0, 1.0, 0.0, "", false));
        lengthMesg.addField(new Field("start_time", 2, 134, 1.0, 0.0, "", false));
        lengthMesg.addField(new Field("total_elapsed_time", 3, 134, 1000.0, 0.0, "s", false));
        lengthMesg.addField(new Field("total_timer_time", 4, 134, 1000.0, 0.0, "s", false));
        lengthMesg.addField(new Field("total_strokes", 5, 132, 1.0, 0.0, "strokes", false));
        lengthMesg.addField(new Field("avg_speed", 6, 132, 1000.0, 0.0, "m/s", false));
        lengthMesg.addField(new Field("swim_stroke", 7, 0, 1.0, 0.0, "swim_stroke", false));
        lengthMesg.addField(new Field("avg_swimming_cadence", 9, 2, 1.0, 0.0, "strokes/min", false));
        lengthMesg.addField(new Field("event_group", 10, 2, 1.0, 0.0, "", false));
        lengthMesg.addField(new Field("total_calories", 11, 132, 1.0, 0.0, "kcal", false));
        lengthMesg.addField(new Field("length_type", 12, 0, 1.0, 0.0, "", false));
        lengthMesg.addField(new Field("player_score", 18, 132, 1.0, 0.0, "", false));
        lengthMesg.addField(new Field("opponent_score", 19, 132, 1.0, 0.0, "", false));
        lengthMesg.addField(new Field("stroke_count", 20, 132, 1.0, 0.0, "counts", false));
        lengthMesg.addField(new Field("zone_count", 21, 132, 1.0, 0.0, "counts", false));
    }
}

