use warnings;
use strict;
use Test::More tests => 3;

BEGIN {
    use_ok('Gscan2pdf::Frontend::Image_Sane');
    use Gtk3;
}

#########################

Glib::set_application_name('gscan2pdf');
use Log::Log4perl qw(:easy);
Log::Log4perl->easy_init($WARN);
my $logger = Log::Log4perl::get_logger;
Gscan2pdf::Frontend::Image_Sane->setup($logger);

my $path;
Gscan2pdf::Frontend::Image_Sane->open_device(
    device_name       => 'test',
    finished_callback => sub {
        Gscan2pdf::Frontend::Image_Sane->scan_pages(
            dir               => '.',
            npages            => 1,
            new_page_callback => sub {
                ( my $status, $path ) = @_;
                is( $status,  5,     'SANE_STATUS_GOOD' );
                is( -s $path, 30807, 'PNM created with expected size' );
            },
            finished_callback => sub {
                Gtk3->main_quit;
            },
        );
    }
);
Gtk3->main;

#########################

unlink $path;

Gscan2pdf::Frontend::Image_Sane->quit();
