//*****************************************************************************
//                              PnlGnuCapOP.hpp                               *
//                             -----------------                              *
// Description : This class derives from the Analysis Panel base class and    *
//               provides a GUI for a user to configure a Operating Point     *
//               Analysis for GNU-Cap electronic circuit simulator.           *
// Started     : 06/11/2003                                                   *
// Last Update : 30/06/2009                                                   *
// Copyright   : (C) 2003 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLGNUCAPOP_HPP
#define PNLGNUCAPOP_HPP

// System Includes


// wxWidgets Library Includes


// Application Includes

#include "base/PnlAnaBase.hpp"
#include "netlist/SimnGnuCap.hpp"

// Local Constant Declarations

//*****************************************************************************

class PnlGnuCapOP : public PnlAnaBase
{
  private :

    void  Create( void );

    void  DoLayout( void );

    virtual  void  InitScale( void );

  public :

    PnlGnuCapOP( wxWindow * poWin );
   ~PnlGnuCapOP( );

    bool  bClear( void );

    bool  bLoad( SimnGnuCap & roSimn );
    bool  bSave( SimnGnuCap & roSimn );

    // Event handlers
    void  OnScale  ( wxCommandEvent & roEvtCmd );
    void  OnSrcName( wxCommandEvent & roEvtCmd );

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // PNLGNUCAPOP_HPP
