#    Copyright (C) 2013 Ahmet Öztürk (aoz_2@yahoo.com)
#
#    This file is part of Lifeograph.
#
#    Lifeograph is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    Lifeograph is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.


include( ${CMAKE_SOURCE_DIR}/cmake/definitions.cmake )

execute_process( COMMAND stat -c %Y "${BIN_DIR}/${PACKAGE_NAME}" OUTPUT_VARIABLE MODIFIED_SRC )

set( CP_REQUIRED YES )
file( GLOB bin_files ${BIN_DIR}/lifeograph.* )
foreach( bin_file ${bin_files} )
    execute_process( COMMAND stat -c %Y ${bin_file} OUTPUT_VARIABLE MODIFIED_TGT )
    if( MODIFIED_TGT EQUAL MODIFIED_SRC )
        set( CP_REQUIRED NO )
        break()
    endif()
endforeach()

if( CP_REQUIRED )
    execute_process( COMMAND date +%Y-%m-%d__%H-%M-%S OUTPUT_VARIABLE DATE_SUFFIX )
    string( REGEX REPLACE \n "" DATE_SUFFIX "${DATE_SUFFIX}" )
    execute_process( COMMAND cp -p "${BIN_DIR}/${PACKAGE_NAME}"
                     "${BIN_DIR}/${PACKAGE_NAME}.${DATE_SUFFIX}" )
endif()
