/***********************************************************************************

    Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_APP_WINDOW_HEADER
#define LIFEOGRAPH_APP_WINDOW_HEADER

#define LIFEOGRAPH_DEVELOPMENT_VERSION


#include <gtkmm.h>

#include "helpers.hpp"
#include "settings.hpp"
#include "panel_main.hpp"
#include "panel_diary.hpp"
#include "widget_textview.hpp"
#include "dialog_export.hpp"
#include "view_entry.hpp"
#include "view_login.hpp"
#include "undo.hpp"


namespace LIFEO
{

class AppWindow : public Gtk::ApplicationWindow
{
    public:
                                    AppWindow( BaseObjectType*,
                                               const Glib::RefPtr<Gtk::Builder>& );
                                    ~AppWindow();
        static AppWindow*           p;

        void                        update_title();

        bool                        confirm_dismiss_element( const DiaryElement*,
                                                             Gtk::Widget* = NULL );
        Gtk::TreeRow                get_element_row( const DiaryElement* );

        void                        login();
        bool                        finish_editing( bool = true );
        void                        logout( bool );

        void                        show_about();

        bool                        write_backup();

        void                        handle_undo();
        void                        handle_redo();

        // AUTO LOGOUT FUNCTIONALITY
        bool                        handle_idle();
        void                        freeze_auto_logout();
        void                        unfreeze_auto_logout();
        void                        update_auto_logout_count_down();
        void                        disable_auto_logout_for_the_session();
        void                        reenable_auto_logout_for_the_session();
        bool                        is_auto_logout_in_use()
        { return( m_auto_logout_status == 0 ); }

        bool                        on_event( GdkEvent* );

        // PANELS AND VIEWS
        PanelMain*                  panel_main{ nullptr };
        PanelDiary*                 panel_diary{ nullptr };
        PanelExtra*                 panel_extra{ nullptr };

        ViewLogin*                  m_view_login{ nullptr };
        DiaryView*                  m_diary_view{ nullptr };
        EntryView*                  m_entry_view{ nullptr };
        TagView*                    m_tag_view{ nullptr };
        CategoryTagsView*           m_ctg_tags_view{ nullptr };
        ChapterView*                m_chapter_view{ nullptr };
        FilterView*                 m_filter_view{ nullptr };

        Gtk::HeaderBar*             m_Hb_main;

    protected:
        bool                        on_delete_event( GdkEventAny* );

        // WIDGETS
        Gtk::Stack*                 m_St_main{ nullptr };
        Gtk::AboutDialog*           m_about_dialog{ nullptr };

        Gtk::Paned*                 m_paned_entry{ nullptr };
        Gtk::Paned*                 m_paned_main{ nullptr };

        sigc::connection            m_connection_backup;

        int                         m_seconds_remaining{ LOGOUT_COUNTDOWN + 1 };
        sigc::connection            m_connection_timeout;
        int                         m_auto_logout_status{ 1 }; // reflects the result of all factors

        // ACTIONS
        Glib::RefPtr< Gtk::Action > m_action_undo;
        Glib::RefPtr< Gtk::Action > m_action_redo;
};

} // end of namespace LIFEO

#endif
