/* ratedMoveVector.t.cc
 */
#include "osl/rating/ratedMoveVector.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class RatedMoveVectorTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(RatedMoveVectorTest);
  CPPUNIT_TEST(testSort);
  CPPUNIT_TEST_SUITE_END();
public:
  void testSort();
};

CPPUNIT_TEST_SUITE_REGISTRATION(RatedMoveVectorTest);

using namespace osl;
using namespace osl::rating;

void RatedMoveVectorTest::testSort()
{
  RatedMove a(Move(Square(5,5),GOLD,BLACK), 200, 200);
  RatedMove b(Move(Square(5,5),SILVER,BLACK), 100, 100);
  {
    RatedMoveVector v;
    v.push_back(a);
    v.push_back(b);
    v.sort();
    CPPUNIT_ASSERT_EQUAL(v[0], a);
  }
  {
    RatedMoveVector v;
    v.push_back(b);
    v.push_back(a);
    v.sort();
    CPPUNIT_ASSERT_EQUAL(v[0], a);
  }
  b.setRating(300);
  {
    RatedMoveVector v;
    v.push_back(b);
    v.push_back(a);
    v.sort();
    CPPUNIT_ASSERT_EQUAL(v[0], b);
  }
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
