/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.web.jsf.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JRadioButton;
import org.openide.util.HelpCtx;

/**
 *
 * @author  Petr Pisl
 */
public class TemplatePanelVisual extends javax.swing.JPanel implements HelpCtx.Provider{

    private static final long serialVersionUID = 1L;
    private static final String RESOURCES_FOLDER="org/netbeans/modules/web/jsf/facelets/resources/templates/";  //NOI18N

    private final Map<Integer, JRadioButton> templateButtonMapping = new HashMap();

    /** Creates new form TemplatePanelVisual */
    public TemplatePanelVisual() {
        initComponents();
        initTemplateButtonMapping();
        initListeners();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        bgTemplates = new javax.swing.ButtonGroup();
        bgLayout = new javax.swing.ButtonGroup();
        jpTemplateChooser = new javax.swing.JPanel();
        jRadioButton2 = new javax.swing.JRadioButton();
        jRadioButton3 = new javax.swing.JRadioButton();
        jRadioButton4 = new javax.swing.JRadioButton();
        jRadioButton5 = new javax.swing.JRadioButton();
        jRadioButton6 = new javax.swing.JRadioButton();
        jRadioButton7 = new javax.swing.JRadioButton();
        jRadioButton8 = new javax.swing.JRadioButton();
        jRadioButton9 = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton10 = new javax.swing.JRadioButton();

        jpTemplateChooser.setLayout(new java.awt.GridLayout(2, 0, 10, 10));

        bgTemplates.add(jRadioButton2);
        jRadioButton2.setSelected(true);
        jRadioButton2.setText(getTemplatePreviewText(1, true));
        jRadioButton2.setActionCommand("1");
        jRadioButton2.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jRadioButton2.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jRadioButton2.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        jpTemplateChooser.add(jRadioButton2);

        bgTemplates.add(jRadioButton3);
        jRadioButton3.setText(getTemplatePreviewText(2, false));
        jRadioButton3.setActionCommand("2");
        jRadioButton3.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jRadioButton3.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jRadioButton3.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        jpTemplateChooser.add(jRadioButton3);

        bgTemplates.add(jRadioButton4);
        jRadioButton4.setText(getTemplatePreviewText(8, false));
        jRadioButton4.setActionCommand("3");
        jRadioButton4.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jRadioButton4.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jRadioButton4.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        jpTemplateChooser.add(jRadioButton4);

        bgTemplates.add(jRadioButton5);
        jRadioButton5.setText(getTemplatePreviewText(7, false));
        jRadioButton5.setActionCommand("4");
        jRadioButton5.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton5.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jRadioButton5.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jRadioButton5.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        jpTemplateChooser.add(jRadioButton5);

        bgTemplates.add(jRadioButton6);
        jRadioButton6.setText(getTemplatePreviewText(3, false));
        jRadioButton6.setActionCommand("5");
        jRadioButton6.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton6.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jRadioButton6.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jRadioButton6.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        jpTemplateChooser.add(jRadioButton6);

        bgTemplates.add(jRadioButton7);
        jRadioButton7.setText(getTemplatePreviewText(6, false));
        jRadioButton7.setToolTipText("");
        jRadioButton7.setActionCommand("6");
        jRadioButton7.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton7.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jRadioButton7.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jRadioButton7.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        jpTemplateChooser.add(jRadioButton7);

        bgTemplates.add(jRadioButton8);
        jRadioButton8.setText(getTemplatePreviewText(4, false));
        jRadioButton8.setActionCommand("7");
        jRadioButton8.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton8.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jRadioButton8.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jRadioButton8.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        jpTemplateChooser.add(jRadioButton8);

        bgTemplates.add(jRadioButton9);
        jRadioButton9.setText(getTemplatePreviewText(5, false));
        jRadioButton9.setActionCommand("8");
        jRadioButton9.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton9.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jRadioButton9.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jRadioButton9.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        jpTemplateChooser.add(jRadioButton9);

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle"); // NOI18N
        jLabel1.setText(bundle.getString("LBL_Layout")); // NOI18N

        bgLayout.add(jRadioButton1);
        jRadioButton1.setSelected(true);
        jRadioButton1.setText(bundle.getString("LBL_CSS_Layout")); // NOI18N
        jRadioButton1.setActionCommand("css");
        jRadioButton1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

        bgLayout.add(jRadioButton10);
        jRadioButton10.setText(bundle.getString("LBL_Table_Layout")); // NOI18N
        jRadioButton10.setActionCommand("table");
        jRadioButton10.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioButton1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioButton10)
                .addGap(201, 201, 201))
            .addComponent(jpTemplateChooser, javax.swing.GroupLayout.DEFAULT_SIZE, 690, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jRadioButton1)
                    .addComponent(jRadioButton10))
                .addGap(18, 18, 18)
                .addComponent(jpTemplateChooser, javax.swing.GroupLayout.DEFAULT_SIZE, 167, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup bgLayout;
    private javax.swing.ButtonGroup bgTemplates;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton10;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JRadioButton jRadioButton3;
    private javax.swing.JRadioButton jRadioButton4;
    private javax.swing.JRadioButton jRadioButton5;
    private javax.swing.JRadioButton jRadioButton6;
    private javax.swing.JRadioButton jRadioButton7;
    private javax.swing.JRadioButton jRadioButton8;
    private javax.swing.JRadioButton jRadioButton9;
    private javax.swing.JPanel jpTemplateChooser;
    // End of variables declaration//GEN-END:variables

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.web.jsf.wizards.TemplatePanelVisual");
    }
    
    InputStream getTemplate(){
        String path = RESOURCES_FOLDER+"template-";  //NOI18N
        path = path + bgLayout.getSelection().getActionCommand() + "-"; //NOI18N
        path = path + bgTemplates.getSelection().getActionCommand() + ".template";          //NOI18N
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        return is;
    }
    
    InputStream getDefaultCSS(){
        String path = RESOURCES_FOLDER+ "default.css";  //NOI18N
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }
    
    InputStream getLayoutCSS(){
        String path = RESOURCES_FOLDER;
        path = path + bgLayout.getSelection().getActionCommand() + "Layout.css";    //NOI18N
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }
    
    String getLayoutFileName(){
        String name = bgLayout.getSelection().getActionCommand() + "Layout";    //NOI18N
        return name;
    }

    private void initTemplateButtonMapping() {
        templateButtonMapping.put(1, jRadioButton2);
        templateButtonMapping.put(2, jRadioButton3);
        templateButtonMapping.put(3, jRadioButton6);
        templateButtonMapping.put(4, jRadioButton8);
        templateButtonMapping.put(5, jRadioButton9);
        templateButtonMapping.put(6, jRadioButton7);
        templateButtonMapping.put(7, jRadioButton5);
        templateButtonMapping.put(8, jRadioButton4);
    }

    private void initListeners() {
        ActionListener clickListener = new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JRadioButton) {
                    JRadioButton rbutton = (JRadioButton) e.getSource();
                    int IdIndex = rbutton.getText().indexOf("template") + 8; //NOI18N
                    int templateId = Integer.parseInt(rbutton.getText().substring(IdIndex, IdIndex + 1));
                    resetAllPreviews();
                    templateButtonMapping.get(templateId).setText(getTemplatePreviewText(templateId, true));
                }
            }
        };
        for (JRadioButton jRadioButton : templateButtonMapping.values()) {
            jRadioButton.addActionListener(clickListener);
        }
    }

    private void resetAllPreviews() {
        for (Map.Entry<Integer, JRadioButton> entry : templateButtonMapping.entrySet()) {
            entry.getValue().setText(getTemplatePreviewText(entry.getKey(), false));
        }
    }

    private static String getTemplatePreviewText(int templateId, boolean selected) {
        if (selected) {
            return "<html><body><img src='" + getSelectedTemplatePreview(templateId) + "' width='68' height='68'>"; //NOI18N
        } else {
            return "<html><body><img src='" + getUnselectedTemplatePreview(templateId) + "' width='68' height='68'>"; //NOI18N
        }
    }

    private static URL getUnselectedTemplatePreview(int templateId) {
        return TemplatePanelVisual.class.getResource(
                "/org/netbeans/modules/web/jsf/facelets/resources/template" + templateId + "-unselected.png"); //NOI18N
    }

    private static URL getSelectedTemplatePreview(int templateId) {
        return TemplatePanelVisual.class.getResource(
                "/org/netbeans/modules/web/jsf/facelets/resources/template" + templateId + "-selected.png"); //NOI18N
    }

}
