# has-own-deep [![NPM version](https://img.shields.io/npm/v/has-own-deep.svg?style=flat)](https://www.npmjs.com/package/has-own-deep) [![NPM monthly downloads](https://img.shields.io/npm/dm/has-own-deep.svg?style=flat)](https://npmjs.org/package/has-own-deep) [![NPM total downloads](https://img.shields.io/npm/dt/has-own-deep.svg?style=flat)](https://npmjs.org/package/has-own-deep) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/has-own-deep.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/has-own-deep)

> Returns true if an object has an own, nested property using dot notation paths ('a.b.c').

Please consider following this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), and consider starring the project to show your :heart: and support.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save has-own-deep
```

## Usage

```js
const hasOwnDeep = require('has-own-deep');
const obj = { a: { b: { c: 'd' } } };

console.log(hasOwnDeep(obj, 'a'));     //=> true
console.log(hasOwnDeep(obj, 'a.b'));   //=> true
console.log(hasOwnDeep(obj, 'a.b.c')); //=> true

console.log(hasOwnDeep(obj, 'c'));     //=> false
console.log(hasOwnDeep(obj, 'a.c'));   //=> false
console.log(hasOwnDeep(obj, 'a.b.d')); //=> false
```

## Keys with dots

Should correctly detect deeply nested keys that have dots in them.

```js
console.log(hasOwnDeep({ 'a.b.c': 'd' }, 'a.b.c'));      //=> true
console.log(hasOwnDeep({ 'a.b': { c: 'd' } }, 'a.b.c')); //=> true
console.log(hasOwnDeep({ a: { 'b.c': 'd' } }, 'a.b.c')); //=> true
```

## About

<details>
<summary><strong>Contributing</strong></summary>

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

</details>

<details>
<summary><strong>Running Tests</strong></summary>

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

</details>

<details>
<summary><strong>Building docs</strong></summary>

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

</details>

### Author

**Jon Schlinkert**

* [linkedin/in/jonschlinkert](https://linkedin.com/in/jonschlinkert)
* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2018, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on January 26, 2018._