var assert = require('assert')
var FS = require('fs')
var YAML = require('js-yaml')
var jju = require('../')

function addTest(name, fn) {
  if (typeof(describe) === 'function') {
    it(name, fn)
  } else {
    fn()
  }
}

FS.readdirSync(__dirname + '/update').filter(function(file) {
  return file.match(/^[^\.].*\.yaml$/)
}).forEach(function(file) {
  addTest('update: ' + file, function() {
    var test = YAML.load(FS.readFileSync(__dirname + '/update/' + file, 'utf8'))
    assert.strictEqual(test.test(jju, test.input), test.output)
  })
})

