**webpack users**

If you use webpack and are experiencing issues, try using [unlazy-loader](https://github.com/doowb/unlazy-loader), a webpack loader that _fixes the webpack bug_ that prevents webpack from working with native javascript getters.

## Usage

```js
var utils = require('{%= name %}')(require);
```

**Use as a property on `lazy`**

The module is also added as a property to the `lazy` function
so it can be called without having to call a function first.

```js
var utils = require('{%= name %}')(require);

// `npm install glob`
utils('glob');

// glob sync
console.log(utils.glob.sync('*.js'));

// glob async
utils.glob('*.js', function (err, files) {
  console.log(files);
});
```

**Use as a function**

```js
var utils = require('{%= name %}')(require);
var glob = utils('glob');

// `glob` is a now a function that may be called when needed
glob().sync('foo/*.js');
```

## Aliases

An alias may be passed as the second argument if you don't want to use the automatically camel-cased variable name.

**Example**

```js
var utils = require('{%= name %}')(require);

// alias `ansi-yellow` as `yellow`
utils('ansi-yellow', 'yellow');
console.log(utils.yellow('foo'));
```

Dot notation may also be used in the alias to create an object hierarchy.

**Example**

```js
var utils = require('{%= name %}')(require);
utils('ansi-cyan', 'color.cyan');
utils('ansi-yellow', 'color.yellow');
utils('ansi-magenta', 'color.magenta');
console.log(utils.color.cyan('foo'));
console.log(utils.color.yellow('bar'));
console.log(utils.color.magenta('baz'));
```

## Browserify usage

**Example**

```js
var utils = require('{%= name %}')(require);
// temporarily re-assign `require` to trick browserify
var fn = require;
require = utils;
// list module dependencies (here, `require` is actually `lazy-cache`)
require('glob');
require = fn; // restore the native `require` function

/**
 * Now you can use glob with the `utils.glob` variable
 */

// sync
console.log(utils.glob.sync('*.js'));

// async
utils.glob('*.js', function (err, files) {
  console.log(files.join('\n'));
});
```

## Kill switch

In certain rare edge cases it may be necessary to unlazy all lazy-cached dependencies (5 reported cases after ~30 million downloads).

To force lazy-cache to immediately invoke all dependencies, do:

```js
process.env.UNLAZY = true;
```
