/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Base 2 logarithm of Euler's number.
*
* @module @stdlib/constants/float64/log2-e
* @type {number}
*
* @example
* var LOG2E = require( '@stdlib/constants/float64/log2-e' );
* // returns 1.4426950408889634
*/


// MAIN //

/**
* Base 2 logarithm of Euler's number.
*
* @constant
* @type {number}
* @default 1.4426950408889634
* @see [OEIS]{@link https://oeis.org/A001113}
* @see [Wikipedia]{@link https://en.wikipedia.org/wiki/E_%27mathematical_constant%28}
*/
var LOG2E = 1.442695040888963407359924681001892137426645954152985934135;


// EXPORTS //

module.exports = LOG2E;
