class QAST::Op is QAST::Node does QAST::Children {
    has str $!name;
    has str $!op;
    has str $!childorder;
    has int $!arity;

    method new(str :$name, str :$op, *@children, *%options) {
        my $node := nqp::create(self);
        nqp::bindattr($node, QAST::Op, '@!children', @children);
        nqp::bindattr_s($node, QAST::Op, '$!name', $name);
        nqp::bindattr_s($node, QAST::Op, '$!op', $op);
        $node.set(%options) if nqp::isconcrete(%options) && nqp::elems(%options);
        $node
    }

    method name($value = NO_VALUE) {
        $!name := $value unless $value =:= NO_VALUE;
        nqp::isnull_s($!name) ?? "" !! $!name
    }
    method op($value = NO_VALUE) {
        $!op := $value unless $value =:= NO_VALUE;
        nqp::isnull_s($!op) ?? "" !! $!op
    }
    method childorder($value = NO_VALUE) {
        $!childorder := $value unless $value =:= NO_VALUE;
        nqp::isnull_s($!childorder) ?? "" !! $!childorder
    }
    method arity($value = NO_VALUE) {
        $value =:= NO_VALUE
          ?? $!arity
          !! ($!arity := $value)
    }

    method count_inline_placeholder_usages(@usages) {
        my int $elems := nqp::elems(@(self));
        my int $i;
        while $i < $elems {
            self[$i].count_inline_placeholder_usages(@usages);
            ++$i;
        }
    }

    method substitute_inline_placeholders(@fillers) {
        my $result := self.shallow_clone();
        my int $elems := nqp::elems(@(self));
        my int $i;
        while $i < $elems {
            $result[$i] := self[$i].substitute_inline_placeholders(@fillers)
                unless nqp::isstr(self[$i]);
            ++$i;
        }
        $result
    }

    method evaluate_unquotes(@unquotes) {
        my $result := self.shallow_clone();
        my $elems := nqp::elems(@(self));
        my int $i;
        while $i < $elems {
            $result[$i] := self[$i].evaluate_unquotes(@unquotes)
                unless nqp::isstr(self[$i]);
            ++$i;
        }
        $result
    }

    method dump_extra_node_info() {
        !nqp::isnull_s($!name) && nqp::chars($!name)
          ?? "$!op $!name"
          !! $!op;
    }
}
