C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_vwn3.F 
C> The nwxcm_c_vwn3 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_vwn3 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{\sqrt{{\it t_2}}}}\\\\ 
C>   {\it t_4} &=& 1.575246635799487\,{\it t_3}\\\\ 
C>   {\it t_5} &=& \arctan \left({{6.15199081975908}\over{{\it t_4}
C>    +3.72744}}\right)\\\\ 
C>   {\it t_6} &=& 0.7876233178997433\,{\it t_3}\\\\ 
C>   {\it t_7} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_8} &=& 0.6203504908994001\,{\it t_7}\\\\ 
C>   {\it t_9} &=& {{1}\over{\left| 2.935818660072219\,{\it t_3}+{
C>    \it t_8}+12.9352\right| }}\\\\ 
C>   {\it t_{10}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.10498\right)^2\,{\it t_9}\right)\\\\ 
C>   {\it t_{11}} &=& \left| {\it t_7}\right| \\\\ 
C>   {\it t_{12}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_9}\right)\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_3}
C>    +{\it t_8}+18.0578\right| }}\\\\ 
C>   {\it t_{16}} &=& \arctan \left({{6.692072046645942}\over{{
C>    \it t_4}+1.06835}}\right)\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\left| 0.8414573716781907\,{\it t_3}
C>    +{\it t_8}+11.4813\right| }}\\\\ 
C>   {\it t_{18}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.228344\right)^2\,{\it t_{17}}\right)\\\\ 
C>   {\it t_{19}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{17}}\right)\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\left| 10.29581201158544\,{\it t_3}
C>    +{\it t_8}+42.7198\right| }}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{\left| 15.84942278842832\,{\it t_3}
C>    +{\it t_8}+101.578\right| }}\\\\ 
C>   {\it t_{22}} &=& 0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{11}}\,{\it t_{21}}\right)+0.002667310007273315
C>    \,\log \left(1.0\,\left({\it t_6}+0.743294\right)^2\,{
C>    \it t_{21}}\right)-0.0310907\,\log \left(0.6203504908994001
C>    \,{\it t_{11}}\,{\it t_{20}}\right)-0.004431373767749538
C>    \,\log \left(1.0\,\left({\it t_6}+0.409286\right)^2\,{
C>    \it t_{20}}\right)+0.6188180297906176\,\arctan 
C>    \left({{1.171685277708971}\over{{\it t_4}+20.1231}}\right)
C>    -20.52197293770518\,\arctan \left({{0.0448998886415768}
C>    \over{{\it t_4}+13.072}}\right)\\\\ 
C>   {\it t_{23}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\sqrt{{\it t_{23}}}}}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{{\it t_{23}}}}\\\\ 
C>   {\it t_{26}} &=& 0.6203504908994001\,{\it t_{25}}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\left| {\it t_{26}}
C>    +2.935818660072219\,{\it t_{24}}+12.9352\right| }}\\\\ 
C>   {\it t_{28}} &=& \left| {\it t_{25}}\right| \\\\ 
C>   {\it t_{29}} &=& \log \left(0.6203504908994001\,{\it t_{27}}
C>    \,{\it t_{28}}\right)\\\\ 
C>   {\it t_{30}} &=& 0.7876233178997433\,{\it t_{24}}\\\\ 
C>   {\it t_{31}} &=& \log \left(1.0\,{\it t_{27}}\,\left({\it t_{30}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{32}} &=& 1.575246635799487\,{\it t_{24}}\\\\ 
C>   {\it t_{33}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{32}}+3.72744}}\right)\\\\ 
C>   {\it t_{34}} &=& {{1}\over{\left| {\it t_{26}}
C>    +5.560951426165705\,{\it t_{24}}+18.0578\right| }}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\left| {\it t_{26}}
C>    +0.8414573716781907\,{\it t_{24}}+11.4813\right| }}\\\\ 
C>   {\it t_{36}} &=& \log \left(0.6203504908994001\,{\it t_{35}}
C>    \,{\it t_{28}}\right)\\\\ 
C>   {\it t_{37}} &=& \log \left(1.0\,{\it t_{35}}\,\left({\it t_{30}}
C>    +0.228344\right)^2\right)\\\\ 
C>   {\it t_{38}} &=& \arctan \left({{6.692072046645942}\over{{
C>    \it t_{32}}+1.06835}}\right)\\\\ 
C>   {\it t_{39}} &=& {{1}\over{\left| {\it t_{26}}
C>    +10.29581201158544\,{\it t_{24}}+42.7198\right| }}\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\left| {\it t_{26}}
C>    +15.84942278842832\,{\it t_{24}}+101.578\right| }}\\\\ 
C>   {\it t_{41}} &=& 0.6188180297906176\,\arctan 
C>    \left({{1.171685277708971}\over{{\it t_{32}}+20.1231}}\right)
C>    -20.52197293770518\,\arctan \left({{0.0448998886415768}
C>    \over{{\it t_{32}}+13.072}}\right)+0.002667310007273315
C>    \,\log \left(1.0\,{\it t_{40}}\,\left({\it t_{30}}
C>    +0.743294\right)^2\right)-0.004431373767749538\,\log \left(1.0
C>    \,{\it t_{39}}\,\left({\it t_{30}}+0.409286\right)^2\right)
C>    +0.01554535\,\log \left(0.6203504908994001\,{\it t_{40}}\,{
C>    \it t_{28}}\right)-0.0310907\,\log \left(0.6203504908994001
C>    \,{\it t_{39}}\,{\it t_{28}}\right)\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left({{1.125\,\left(\left({\it t_{13}}
C>    \,{\it t_{14}}+1.0\right)^{{{4}\over{3}}}+\left(1.0-{
C>    \it t_{13}}\,{\it t_{14}}\right)^{{{4}\over{3}}}-2.0\right)
C>    \,\left(0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{11}}\,{\it t_{15}}\right)+0.002247867095542611
C>    \,\log \left(1.0\,\left({\it t_6}+0.325\right)^2\,{
C>    \it t_{15}}\right)-0.0310907\,{\it t_{12}}
C>    -9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    +0.05249139316978092\,\arctan \left({{4.730926909560114}
C>    \over{{\it t_4}+7.06042}}\right)-0.03878329487811301\,{
C>    \it t_5}\right)\,\left({{{\it t_{13}}^4\,
C>    \left(1.709920934161365\,{\it t_{22}}+0.01688686394038963\,{
C>    \it t_{19}}+3.649033517917767 \times 10^{-4}\,{\it t_{18}}
C>    +0.005458482358638966\,{\it t_{16}}\right)}\over{{\it t_1}^4}}
C>    -0.01688686394038963\,{\it t_{19}}-3.649033517917767 \times 10^{
C>    -4}\,{\it t_{18}}-0.005458482358638966\,{
C>    \it t_{16}}\right)}\over{{\it t_{22}}}}+0.0310907\,{\it t_{12}}
C>    +9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    +0.03878329487811301\,{\it t_5}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left({{0.5848223622634643\,
C>    \left(0.05249139316978092\,\arctan 
C>    \left({{4.730926909560114}\over{{\it t_{32}}+7.06042}}\right)
C>    -0.03878329487811301\,{\it t_{33}}+0.002247867095542611
C>    \,\log \left(1.0\,{\it t_{34}}\,\left({\it t_{30}}
C>    +0.325\right)^2\right)-9.690227711544375 \times 10^{-4}\,{
C>    \it t_{31}}+0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{34}}\,{\it t_{28}}\right)-0.0310907\,{
C>    \it t_{29}}\right)\,\left(1.0\,\left(1.709920934161365\,{
C>    \it t_{41}}+0.005458482358638966\,{\it t_{38}}
C>    +3.649033517917767 \times 10^{-4}\,{\it t_{37}}
C>    +0.01688686394038963\,{\it t_{36}}\right)-0.005458482358638966
C>    \,{\it t_{38}}-3.649033517917767 \times 10^{-4}\,{\it t_{37}}
C>    -0.01688686394038963\,{\it t_{36}}\right)}\over{{\it t_{41}}}}
C>    +0.03878329487811301\,{\it t_{33}}+9.690227711544375 \times 10^{
C>    -4}\,{\it t_{31}}+0.0310907\,{\it t_{29}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] SH Vosko, L Wilk, M Nusair, Can.J.Phys. 58, 1200 (1980)  , DOI: 
C> <a href="http://dx.doi.org/10.1139/p80-159 "> 
C> 10.1139/p80-159 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_vwn3(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 4.9237251092134837d-1*t4
            t6 = 1/abs(t5+2.615517080950829d+0*t3+1.29352d+1)
            t7 = abs(t4)
            t8 = t5+2.615517080950828d+0*t3+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = 7.016926042943222d-1*t3+1.0498d-1
            t12 = t11**2
            t13 = 1.4033852085886445d+0*t3+3.72744d+0
            t14 = 1/t7
            t15 = 1/t2**3
            t16 = 1/rhoa**6.666666666666667d-1
            t17 = -2.1795975674590234d-1*t15*t16-8.206208515355806d-2/rh
     1         oa**1.3333333333333333d+0
            t18 = 1/t8
            t19 = 1/t13**2
            fnc(iq) = 2.0d+0*rhoa*(3.10907d-2*log(4.9237251092134837d-1*
     1         t6*t7)+9.690227711544375d-4*log(1.0d+0*(7.016926042943223
     2         d-1*t3+1.0498d-1)**2*t6)+3.8783294878113006d-2*atan(6.151
     3         99081975908d+0/(1.4033852085886447d+0*t3+3.72744d+0)))*wg
     4         ht+fnc(iq)
            Amat(iq,D1_RA) = 2.0d+0*rhoa*(6.314467057030004d-2*t14*(-4.9
     1         237251092134837d-1*t10*t17*t18*t7-8.206208515355806d-2*t1
     2         0*t14/rhoa**1.6666666666666666d+0)*t9+9.690227711544375d-
     3         4*(-1.0d+0*t10*t12*t17*t18-1.1694876738238703d-1*t10*t11*
     4         t15*t16)*t9/t12+2.790332964441521d-2*t15*t16*t19/(3.78469
     5         9104639999d+1*t19+1))*wght+1.0d+0*(3.10907d-2*log(4.92372
     6         51092134837d-1*t10*t7)+3.8783294878113006d-2*atan(6.15199
     7         081975908d+0/t13)+9.690227711544375d-4*log(1.0d+0*t10*t12
     8         ))*wght+Amat(iq,D1_RA)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = t2**5.0d-1
            t4 = 1/t3
            t5 = 1.5752466357994865d+0*t4
            t6 = t5+3.72744d+0
            t7 = atan(6.15199081975908d+0/t6)
            t8 = 7.876233178997433d-1*t4
            t9 = t8+1.0498d-1
            t10 = t9**2
            t11 = 1/t2
            t12 = 6.203504908994001d-1*t11
            t13 = 2.935818660072219d+0*t4+t12+1.29352d+1
            t14 = abs(t13)
            t15 = 1/t14
            t16 = log(1.0d+0*t10*t15)
            t17 = abs(t11)
            t18 = log(6.203504908994001d-1*t15*t17)
            t19 = rhoa-rhob
            t20 = 1/t1
            t21 = 1.0d+0-t19*t20
            t22 = t19*t20+1.0d+0
            t23 = t22**1.3333333333333333d+0+t21**1.3333333333333333d+0-
     1         2.0d+0
            t24 = t5+7.06042d+0
            t25 = t8+3.25d-1
            t26 = t25**2
            t27 = 5.560951426165704d+0*t4+t12+1.8057800000000002d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = -3.8783294878113006d-2*t7+2.2478670955426108d-3*log(1.
     1         0d+0*t26*t29)+1.554535d-2*log(6.203504908994001d-1*t17*t2
     2         9)+5.249139316978092d-2*atan(4.7309269095601136d+0/t24)-3
     3         .10907d-2*t18-9.690227711544375d-4*t16
            t31 = t5+1.0683499999999999d+0
            t32 = atan(6.692072046645942d+0/t31)
            t33 = t8+2.28344d-1
            t34 = t33**2
            t35 = 8.414573716781907d-1*t4+t12+1.14813d+1
            t36 = abs(t35)
            t37 = 1/t36
            t38 = log(1.0d+0*t34*t37)
            t39 = log(6.203504908994001d-1*t17*t37)
            t40 = t19**4
            t41 = 1/t1**4
            t42 = t5+1.3072d+1
            t43 = t5+2.0123100000000002d+1
            t44 = t8+4.09286d-1
            t45 = t44**2
            t46 = 1.0295812011585444d+1*t4+t12+4.2719799999999997d+1
            t47 = abs(t46)
            t48 = 1/t47
            t49 = t8+7.43294d-1
            t50 = t49**2
            t51 = 1.5849422788428325d+1*t4+t12+1.01578d+2
            t52 = abs(t51)
            t53 = 1/t52
            t54 = 2.667310007273315d-3*log(1.0d+0*t50*t53)+1.554535d-2*l
     1         og(6.203504908994001d-1*t17*t53)-4.431373767749538d-3*log
     2         (1.0d+0*t45*t48)-3.10907d-2*log(6.203504908994001d-1*t17*
     3         t48)+6.188180297906176d-1*atan(1.171685277708971d+0/t43)-
     4         2.052197293770518d+1*atan(4.4899888641576796d-2/t42)
            t55 = 1.709920934161365d+0*t54+1.688686394038963d-2*t39+3.64
     1         90335179177674d-4*t38+5.458482358638966d-3*t32
            t56 = t40*t41*t55-1.688686394038963d-2*t39-3.649033517917767
     1         4d-4*t38-5.458482358638966d-3*t32
            t57 = 1/t54
            t58 = 3.8783294878113006d-2*t7+1.1250000000000002d+0*t23*t30
     1         *t56*t57+3.10907d-2*t18+9.690227711544375d-4*t16
            t59 = 1/t1**6.666666666666667d-1
            t60 = 1/t3**3
            t61 = 1/t6**2
            t62 = 1/(3.784699104639999d+1*t61+1)
            t63 = 6.264085709464389d-2*t59*t60*t61*t62
            t64 = 1/t10
            t65 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t66 = t65-4.8930311001203647d-1*t59*t60
            t67 = 1/t13
            t68 = -2.625411059665811d-1*t15*t59*t60*t9-1.0d+0*t10*t15*t6
     1         6*t67
            t69 = 9.690227711544375d-4*t14*t64*t68
            t70 = 1/t17
            t71 = 1/t1**1.6666666666666666d+0
            t72 = -2.067834969664667d-1*t15*t70*t71-6.203504908994001d-1
     1         *t15*t17*t66*t67
            t73 = 5.011795824473985d-2*t14*t70*t72
            t74 = 1/t42**2
            t75 = 1/t43**2
            t76 = t65-1.715968668597574d+0*t59*t60
            t77 = 1/t46
            t78 = t65-2.641570464738054d+0*t59*t60
            t79 = 1/t51
            t80 = 2.667310007273315d-3*t52*(-1.0d+0*t50*t53*t78*t79-2.62
     1         5411059665811d-1*t49*t53*t59*t60)/t50+2.5058979122369923d
     2         -2*t52*t70*(-6.203504908994001d-1*t17*t53*t78*t79-2.06783
     3         4969664667d-1*t53*t70*t71)-4.431373767749538d-3*t47*(-1.0
     4         d+0*t45*t48*t76*t77-2.625411059665811d-1*t44*t48*t59*t60)
     5         /t45-5.011795824473985d-2*t47*t70*(-6.203504908994001d-1*
     6         t17*t48*t76*t77-2.067834969664667d-1*t48*t70*t71)+1.90358
     7         04775132142d-1*t59*t60*t75/(1.3728463899999485d+0*t75+1)-
     8         2.4191438009473537d-1*t59*t60*t74/(2.016000000025997d-3*t
     9         74+1)
            t81 = -1.1250000000000002d+0*t23*t30*t56*t80/t54**2
            t82 = 1/t31**2
            t83 = 1/(4.4783828277500004d+1*t82+1)
            t84 = -9.590247809108334d-3*t59*t60*t82*t83
            t85 = 1/t34
            t86 = t65-1.4024289527969844d-1*t59*t60
            t87 = 1/t35
            t88 = -1.0d+0*t34*t37*t86*t87-2.625411059665811d-1*t33*t37*t
     1         59*t60
            t89 = -3.6490335179177674d-4*t36*t85*t88
            t90 = -6.203504908994001d-1*t17*t37*t86*t87-2.06783496966466
     1         7d-1*t37*t70*t71
            t91 = -2.722148880047894d-2*t36*t70*t90
            t92 = t40*t41*(2.722148880047894d-2*t36*t70*t90+3.6490335179
     1         177674d-4*t36*t85*t88+9.590247809108334d-3*t59*t60*t82*t8
     2         3+1.709920934161365d+0*t80)
            t93 = -4*t40*t55/t1**5
            t94 = t19**3
            t95 = 1/t24**2
            t96 = t65-9.26825237694284d-1*t59*t60
            t97 = 1/t27
            t98 = 1.1250000000000002d+0*t23*t56*t57*(2.2478670955426108d
     1         -3*t28*(-1.0d+0*t26*t29*t96*t97-2.625411059665811d-1*t25*
     2         t29*t59*t60)/t26+2.5058979122369923d-2*t28*t70*(-6.203504
     3         908994001d-1*t17*t29*t96*t97-2.067834969664667d-1*t29*t70
     4         *t71)+6.519760588836059d-2*t59*t60*t95/(2.238166942360001
     5         d+1*t95+1)-5.011795824473985d-2*t14*t70*t72-9.69022771154
     6         4375d-4*t14*t64*t68-6.264085709464389d-2*t59*t60*t61*t62)
            t99 = 1/t1**2
            t100 = t19*t99
            t101 = -t20
            t102 = t21**3.333333333333333d-1
            t103 = -t19*t99
            t104 = t22**3.333333333333333d-1
            t105 = 1.0d+0*t58*wght
            fnc(iq) = 1.0d+0*t1*t58*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*(t98+1.1250000000000002d+0*t23*t3
     1         0*t57*(4*t41*t55*t94+t93+t92+t91+t89+t84)+t81+t73+t69+t63
     2         +1.1250000000000002d+0*(1.3333333333333333d+0*t104*(t20+t
     3         103)+1.3333333333333333d+0*(t101+t100)*t102)*t30*t56*t57)
     4         *wght+t105+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*(t98+1.1250000000000002d+0*t23*t3
     1         0*t57*(-4*t41*t55*t94+t93+t92+t91+t89+t84)+t81+t73+t69+t6
     2         3+1.1250000000000002d+0*(1.3333333333333333d+0*t102*(t20+
     3         t100)+1.3333333333333333d+0*(t103+t101)*t104)*t30*t56*t57
     4         )*wght+t105+Amat(iq,D1_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = t11+3.25d-1
            t22 = t21**2
            t23 = t15+7.06042d+0
            t24 = 1.554535d-2*log(6.203504908994001d-1*t20*t9)+5.2491393
     1         16978092d-2*atan(4.7309269095601136d+0/t23)+2.24786709554
     2         26108d-3*log(1.0d+0*t20*t22)-3.8783294878113006d-2*t17-9.
     3         690227711544375d-4*t14-3.10907d-2*t10
            t25 = t5+8.414573716781907d-1*t3+1.14813d+1
            t26 = abs(t25)
            t27 = 1/t26
            t28 = log(6.203504908994001d-1*t27*t9)
            t29 = t11+2.28344d-1
            t30 = t29**2
            t31 = log(1.0d+0*t27*t30)
            t32 = t15+1.0683499999999999d+0
            t33 = atan(6.692072046645942d+0/t32)
            t34 = t5+1.0295812011585444d+1*t3+4.2719799999999997d+1
            t35 = abs(t34)
            t36 = 1/t35
            t37 = t5+1.5849422788428325d+1*t3+1.01578d+2
            t38 = abs(t37)
            t39 = 1/t38
            t40 = t11+4.09286d-1
            t41 = t40**2
            t42 = t11+7.43294d-1
            t43 = t42**2
            t44 = t15+1.3072d+1
            t45 = t15+2.0123100000000002d+1
            t46 = 1.554535d-2*log(6.203504908994001d-1*t39*t9)-3.10907d-
     1         2*log(6.203504908994001d-1*t36*t9)+6.188180297906176d-1*a
     2         tan(1.171685277708971d+0/t45)-2.052197293770518d+1*atan(4
     3         .4899888641576796d-2/t44)+2.667310007273315d-3*log(1.0d+0
     4         *t39*t43)-4.431373767749538d-3*log(1.0d+0*t36*t41)
            t47 = 1.0d+0*(1.709920934161365d+0*t46+5.458482358638966d-3*
     1         t33+3.6490335179177674d-4*t31+1.688686394038963d-2*t28)-5
     2         .458482358638966d-3*t33-3.6490335179177674d-4*t31-1.68868
     3         6394038963d-2*t28
            t48 = 1/t46
            t49 = 5.848223622634643d-1*t24*t47*t48+3.8783294878113006d-2
     1         *t17+9.690227711544375d-4*t14+3.10907d-2*t10
            t50 = 1/t9
            t51 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t52 = 1/t2**3
            t53 = 1/rhoa**6.666666666666667d-1
            t54 = t51-4.8930311001203647d-1*t52*t53
            t55 = 1/t6
            t56 = 1/rhoa**1.6666666666666666d+0
            t57 = -6.203504908994001d-1*t54*t55*t8*t9-2.067834969664667d
     1         -1*t50*t56*t8
            t58 = 1/t16**2
            t59 = 1/(3.784699104639999d+1*t58+1)
            t60 = 1/t13
            t61 = -1.0d+0*t13*t54*t55*t8-2.625411059665811d-1*t12*t52*t5
     1         3*t8
            t62 = t51-9.26825237694284d-1*t52*t53
            t63 = 1/t18
            t64 = 1/t23**2
            t65 = t51-1.715968668597574d+0*t52*t53
            t66 = 1/t34
            t67 = t51-2.641570464738054d+0*t52*t53
            t68 = 1/t37
            t69 = 1/t44**2
            t70 = 1/t45**2
            t71 = 2.5058979122369923d-2*t38*t50*(-6.203504908994001d-1*t
     1         39*t67*t68*t9-2.067834969664667d-1*t39*t50*t56)-5.0117958
     2         24473985d-2*t35*t50*(-6.203504908994001d-1*t36*t65*t66*t9
     3         -2.067834969664667d-1*t36*t50*t56)+1.9035804775132142d-1*
     4         t52*t53*t70/(1.3728463899999485d+0*t70+1)-2.4191438009473
     5         537d-1*t52*t53*t69/(2.016000000025997d-3*t69+1)+2.6673100
     6         07273315d-3*t38*(-1.0d+0*t39*t43*t67*t68-2.62541105966581
     7         1d-1*t39*t42*t52*t53)/t43-4.431373767749538d-3*t35*(-1.0d
     8         +0*t36*t41*t65*t66-2.625411059665811d-1*t36*t40*t52*t53)/
     9         t41
            t72 = t51-1.4024289527969844d-1*t52*t53
            t73 = 1/t25
            t74 = -6.203504908994001d-1*t27*t72*t73*t9-2.067834969664667
     1         d-1*t27*t50*t56
            t75 = 1/t32**2
            t76 = 1/(4.4783828277500004d+1*t75+1)
            t77 = 1/t30
            t78 = -1.0d+0*t27*t30*t72*t73-2.625411059665811d-1*t27*t29*t
     1         52*t53
            fnc(iq) = 1.0d+0*rhoa*t49*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*(5.848223622634643d-1*t47*t48*(
     1         2.5058979122369923d-2*t19*t50*(-6.203504908994001d-1*t20*
     2         t62*t63*t9-2.067834969664667d-1*t20*t50*t56)-9.6902277115
     3         44375d-4*t60*t61*t7-5.011795824473985d-2*t50*t57*t7+6.519
     4         760588836059d-2*t52*t53*t64/(2.238166942360001d+1*t64+1)+
     5         2.2478670955426108d-3*t19*(-1.0d+0*t20*t22*t62*t63-2.6254
     6         11059665811d-1*t20*t21*t52*t53)/t22-6.264085709464389d-2*
     7         t52*t53*t58*t59)+5.848223622634643d-1*t24*t48*(1.0d+0*(3.
     8         6490335179177674d-4*t26*t77*t78+9.590247809108334d-3*t52*
     9         t53*t75*t76+2.722148880047894d-2*t26*t50*t74+1.7099209341
     :         61365d+0*t71)-3.6490335179177674d-4*t26*t77*t78-9.5902478
     ;         09108334d-3*t52*t53*t75*t76-2.722148880047894d-2*t26*t50*
     <         t74)-5.848223622634643d-1*t24*t47*t71/t46**2+9.6902277115
     =         44375d-4*t60*t61*t7+5.011795824473985d-2*t50*t57*t7+6.264
     >         085709464389d-2*t52*t53*t58*t59)*wght+1.0d+0*t49*wght+Ama
     ?         t(iq,D1_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = t11+3.25d-1
            t22 = t21**2
            t23 = t15+7.06042d+0
            t24 = 1.554535d-2*log(6.203504908994001d-1*t20*t9)+5.2491393
     1         16978092d-2*atan(4.7309269095601136d+0/t23)+2.24786709554
     2         26108d-3*log(1.0d+0*t20*t22)-3.8783294878113006d-2*t17-9.
     3         690227711544375d-4*t14-3.10907d-2*t10
            t25 = t5+8.414573716781907d-1*t3+1.14813d+1
            t26 = abs(t25)
            t27 = 1/t26
            t28 = log(6.203504908994001d-1*t27*t9)
            t29 = t11+2.28344d-1
            t30 = t29**2
            t31 = log(1.0d+0*t27*t30)
            t32 = t15+1.0683499999999999d+0
            t33 = atan(6.692072046645942d+0/t32)
            t34 = t5+1.0295812011585444d+1*t3+4.2719799999999997d+1
            t35 = abs(t34)
            t36 = 1/t35
            t37 = t5+1.5849422788428325d+1*t3+1.01578d+2
            t38 = abs(t37)
            t39 = 1/t38
            t40 = t11+4.09286d-1
            t41 = t40**2
            t42 = t11+7.43294d-1
            t43 = t42**2
            t44 = t15+1.3072d+1
            t45 = t15+2.0123100000000002d+1
            t46 = 1.554535d-2*log(6.203504908994001d-1*t39*t9)-3.10907d-
     1         2*log(6.203504908994001d-1*t36*t9)+6.188180297906176d-1*a
     2         tan(1.171685277708971d+0/t45)-2.052197293770518d+1*atan(4
     3         .4899888641576796d-2/t44)+2.667310007273315d-3*log(1.0d+0
     4         *t39*t43)-4.431373767749538d-3*log(1.0d+0*t36*t41)
            t47 = 1.0d+0*(1.709920934161365d+0*t46+5.458482358638966d-3*
     1         t33+3.6490335179177674d-4*t31+1.688686394038963d-2*t28)-5
     2         .458482358638966d-3*t33-3.6490335179177674d-4*t31-1.68868
     3         6394038963d-2*t28
            t48 = 1/t46
            t49 = 5.848223622634643d-1*t24*t47*t48+3.8783294878113006d-2
     1         *t17+9.690227711544375d-4*t14+3.10907d-2*t10
            t50 = 1/t9
            t51 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t52 = 1/t2**3
            t53 = 1/rhob**6.666666666666667d-1
            t54 = t51-4.8930311001203647d-1*t52*t53
            t55 = 1/t6
            t56 = 1/rhob**1.6666666666666666d+0
            t57 = -6.203504908994001d-1*t54*t55*t8*t9-2.067834969664667d
     1         -1*t50*t56*t8
            t58 = 1/t16**2
            t59 = 1/(3.784699104639999d+1*t58+1)
            t60 = 1/t13
            t61 = -1.0d+0*t13*t54*t55*t8-2.625411059665811d-1*t12*t52*t5
     1         3*t8
            t62 = t51-9.26825237694284d-1*t52*t53
            t63 = 1/t18
            t64 = 1/t23**2
            t65 = t51-1.715968668597574d+0*t52*t53
            t66 = 1/t34
            t67 = t51-2.641570464738054d+0*t52*t53
            t68 = 1/t37
            t69 = 1/t44**2
            t70 = 1/t45**2
            t71 = 2.5058979122369923d-2*t38*t50*(-6.203504908994001d-1*t
     1         39*t67*t68*t9-2.067834969664667d-1*t39*t50*t56)-5.0117958
     2         24473985d-2*t35*t50*(-6.203504908994001d-1*t36*t65*t66*t9
     3         -2.067834969664667d-1*t36*t50*t56)+1.9035804775132142d-1*
     4         t52*t53*t70/(1.3728463899999485d+0*t70+1)-2.4191438009473
     5         537d-1*t52*t53*t69/(2.016000000025997d-3*t69+1)+2.6673100
     6         07273315d-3*t38*(-1.0d+0*t39*t43*t67*t68-2.62541105966581
     7         1d-1*t39*t42*t52*t53)/t43-4.431373767749538d-3*t35*(-1.0d
     8         +0*t36*t41*t65*t66-2.625411059665811d-1*t36*t40*t52*t53)/
     9         t41
            t72 = t51-1.4024289527969844d-1*t52*t53
            t73 = 1/t25
            t74 = -6.203504908994001d-1*t27*t72*t73*t9-2.067834969664667
     1         d-1*t27*t50*t56
            t75 = 1/t32**2
            t76 = 1/(4.4783828277500004d+1*t75+1)
            t77 = 1/t30
            t78 = -1.0d+0*t27*t30*t72*t73-2.625411059665811d-1*t27*t29*t
     1         52*t53
            fnc(iq) = 1.0d+0*rhob*t49*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*(5.848223622634643d-1*t47*t48*(
     1         2.5058979122369923d-2*t19*t50*(-6.203504908994001d-1*t20*
     2         t62*t63*t9-2.067834969664667d-1*t20*t50*t56)-9.6902277115
     3         44375d-4*t60*t61*t7-5.011795824473985d-2*t50*t57*t7+6.519
     4         760588836059d-2*t52*t53*t64/(2.238166942360001d+1*t64+1)+
     5         2.2478670955426108d-3*t19*(-1.0d+0*t20*t22*t62*t63-2.6254
     6         11059665811d-1*t20*t21*t52*t53)/t22-6.264085709464389d-2*
     7         t52*t53*t58*t59)+5.848223622634643d-1*t24*t48*(1.0d+0*(3.
     8         6490335179177674d-4*t26*t77*t78+9.590247809108334d-3*t52*
     9         t53*t75*t76+2.722148880047894d-2*t26*t50*t74+1.7099209341
     :         61365d+0*t71)-3.6490335179177674d-4*t26*t77*t78-9.5902478
     ;         09108334d-3*t52*t53*t75*t76-2.722148880047894d-2*t26*t50*
     <         t74)-5.848223622634643d-1*t24*t47*t71/t46**2+9.6902277115
     =         44375d-4*t60*t61*t7+5.011795824473985d-2*t50*t57*t7+6.264
     >         085709464389d-2*t52*t53*t58*t59)*wght+1.0d+0*t49*wght+Ama
     ?         t(iq,D1_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_vwn3 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{\sqrt{{\it t_2}}}}\\\\ 
C>   {\it t_4} &=& 1.575246635799487\,{\it t_3}\\\\ 
C>   {\it t_5} &=& \arctan \left({{6.15199081975908}\over{{\it t_4}
C>    +3.72744}}\right)\\\\ 
C>   {\it t_6} &=& 0.7876233178997433\,{\it t_3}\\\\ 
C>   {\it t_7} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_8} &=& 0.6203504908994001\,{\it t_7}\\\\ 
C>   {\it t_9} &=& {{1}\over{\left| 2.935818660072219\,{\it t_3}+{
C>    \it t_8}+12.9352\right| }}\\\\ 
C>   {\it t_{10}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.10498\right)^2\,{\it t_9}\right)\\\\ 
C>   {\it t_{11}} &=& \left| {\it t_7}\right| \\\\ 
C>   {\it t_{12}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_9}\right)\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_3}
C>    +{\it t_8}+18.0578\right| }}\\\\ 
C>   {\it t_{16}} &=& \arctan \left({{6.692072046645942}\over{{
C>    \it t_4}+1.06835}}\right)\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\left| 0.8414573716781907\,{\it t_3}
C>    +{\it t_8}+11.4813\right| }}\\\\ 
C>   {\it t_{18}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.228344\right)^2\,{\it t_{17}}\right)\\\\ 
C>   {\it t_{19}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{17}}\right)\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\left| 10.29581201158544\,{\it t_3}
C>    +{\it t_8}+42.7198\right| }}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{\left| 15.84942278842832\,{\it t_3}
C>    +{\it t_8}+101.578\right| }}\\\\ 
C>   {\it t_{22}} &=& 0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{11}}\,{\it t_{21}}\right)+0.002667310007273315
C>    \,\log \left(1.0\,\left({\it t_6}+0.743294\right)^2\,{
C>    \it t_{21}}\right)-0.0310907\,\log \left(0.6203504908994001
C>    \,{\it t_{11}}\,{\it t_{20}}\right)-0.004431373767749538
C>    \,\log \left(1.0\,\left({\it t_6}+0.409286\right)^2\,{
C>    \it t_{20}}\right)+0.6188180297906176\,\arctan 
C>    \left({{1.171685277708971}\over{{\it t_4}+20.1231}}\right)
C>    -20.52197293770518\,\arctan \left({{0.0448998886415768}
C>    \over{{\it t_4}+13.072}}\right)\\\\ 
C>   {\it t_{23}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\sqrt{{\it t_{23}}}}}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{{\it t_{23}}}}\\\\ 
C>   {\it t_{26}} &=& 0.6203504908994001\,{\it t_{25}}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\left| {\it t_{26}}
C>    +2.935818660072219\,{\it t_{24}}+12.9352\right| }}\\\\ 
C>   {\it t_{28}} &=& \left| {\it t_{25}}\right| \\\\ 
C>   {\it t_{29}} &=& \log \left(0.6203504908994001\,{\it t_{27}}
C>    \,{\it t_{28}}\right)\\\\ 
C>   {\it t_{30}} &=& 0.7876233178997433\,{\it t_{24}}\\\\ 
C>   {\it t_{31}} &=& \log \left(1.0\,{\it t_{27}}\,\left({\it t_{30}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{32}} &=& 1.575246635799487\,{\it t_{24}}\\\\ 
C>   {\it t_{33}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{32}}+3.72744}}\right)\\\\ 
C>   {\it t_{34}} &=& {{1}\over{\left| {\it t_{26}}
C>    +5.560951426165705\,{\it t_{24}}+18.0578\right| }}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\left| {\it t_{26}}
C>    +0.8414573716781907\,{\it t_{24}}+11.4813\right| }}\\\\ 
C>   {\it t_{36}} &=& \log \left(0.6203504908994001\,{\it t_{35}}
C>    \,{\it t_{28}}\right)\\\\ 
C>   {\it t_{37}} &=& \log \left(1.0\,{\it t_{35}}\,\left({\it t_{30}}
C>    +0.228344\right)^2\right)\\\\ 
C>   {\it t_{38}} &=& \arctan \left({{6.692072046645942}\over{{
C>    \it t_{32}}+1.06835}}\right)\\\\ 
C>   {\it t_{39}} &=& {{1}\over{\left| {\it t_{26}}
C>    +10.29581201158544\,{\it t_{24}}+42.7198\right| }}\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\left| {\it t_{26}}
C>    +15.84942278842832\,{\it t_{24}}+101.578\right| }}\\\\ 
C>   {\it t_{41}} &=& 0.6188180297906176\,\arctan 
C>    \left({{1.171685277708971}\over{{\it t_{32}}+20.1231}}\right)
C>    -20.52197293770518\,\arctan \left({{0.0448998886415768}
C>    \over{{\it t_{32}}+13.072}}\right)+0.002667310007273315
C>    \,\log \left(1.0\,{\it t_{40}}\,\left({\it t_{30}}
C>    +0.743294\right)^2\right)-0.004431373767749538\,\log \left(1.0
C>    \,{\it t_{39}}\,\left({\it t_{30}}+0.409286\right)^2\right)
C>    +0.01554535\,\log \left(0.6203504908994001\,{\it t_{40}}\,{
C>    \it t_{28}}\right)-0.0310907\,\log \left(0.6203504908994001
C>    \,{\it t_{39}}\,{\it t_{28}}\right)\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left({{1.125\,\left(\left({\it t_{13}}
C>    \,{\it t_{14}}+1.0\right)^{{{4}\over{3}}}+\left(1.0-{
C>    \it t_{13}}\,{\it t_{14}}\right)^{{{4}\over{3}}}-2.0\right)
C>    \,\left(0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{11}}\,{\it t_{15}}\right)+0.002247867095542611
C>    \,\log \left(1.0\,\left({\it t_6}+0.325\right)^2\,{
C>    \it t_{15}}\right)-0.0310907\,{\it t_{12}}
C>    -9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    +0.05249139316978092\,\arctan \left({{4.730926909560114}
C>    \over{{\it t_4}+7.06042}}\right)-0.03878329487811301\,{
C>    \it t_5}\right)\,\left({{{\it t_{13}}^4\,
C>    \left(1.709920934161365\,{\it t_{22}}+0.01688686394038963\,{
C>    \it t_{19}}+3.649033517917767 \times 10^{-4}\,{\it t_{18}}
C>    +0.005458482358638966\,{\it t_{16}}\right)}\over{{\it t_1}^4}}
C>    -0.01688686394038963\,{\it t_{19}}-3.649033517917767 \times 10^{
C>    -4}\,{\it t_{18}}-0.005458482358638966\,{
C>    \it t_{16}}\right)}\over{{\it t_{22}}}}+0.0310907\,{\it t_{12}}
C>    +9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    +0.03878329487811301\,{\it t_5}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left({{0.5848223622634643\,
C>    \left(0.05249139316978092\,\arctan 
C>    \left({{4.730926909560114}\over{{\it t_{32}}+7.06042}}\right)
C>    -0.03878329487811301\,{\it t_{33}}+0.002247867095542611
C>    \,\log \left(1.0\,{\it t_{34}}\,\left({\it t_{30}}
C>    +0.325\right)^2\right)-9.690227711544375 \times 10^{-4}\,{
C>    \it t_{31}}+0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{34}}\,{\it t_{28}}\right)-0.0310907\,{
C>    \it t_{29}}\right)\,\left(1.0\,\left(1.709920934161365\,{
C>    \it t_{41}}+0.005458482358638966\,{\it t_{38}}
C>    +3.649033517917767 \times 10^{-4}\,{\it t_{37}}
C>    +0.01688686394038963\,{\it t_{36}}\right)-0.005458482358638966
C>    \,{\it t_{38}}-3.649033517917767 \times 10^{-4}\,{\it t_{37}}
C>    -0.01688686394038963\,{\it t_{36}}\right)}\over{{\it t_{41}}}}
C>    +0.03878329487811301\,{\it t_{33}}+9.690227711544375 \times 10^{
C>    -4}\,{\it t_{31}}+0.0310907\,{\it t_{29}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] SH Vosko, L Wilk, M Nusair, Can.J.Phys. 58, 1200 (1980)  , DOI: 
C> <a href="http://dx.doi.org/10.1139/p80-159 "> 
C> 10.1139/p80-159 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_vwn3_d2(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat,Amat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
c 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 4.9237251092134837d-1*t4
            t6 = 1/abs(t5+2.615517080950829d+0*t3+1.29352d+1)
            t7 = abs(t4)
            t8 = t5+2.615517080950828d+0*t3+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = log(4.9237251092134837d-1*t10*t7)
            t12 = 7.016926042943222d-1*t3
            t13 = t12+1.0498d-1
            t14 = t13**2
            t15 = log(1.0d+0*t10*t14)
            t16 = 1.4033852085886445d+0*t3
            t17 = t16+3.72744d+0
            t18 = atan(6.15199081975908d+0/t17)
            t19 = 1/t7
            t20 = 1/t2**3
            t21 = 1/rhoa**6.666666666666667d-1
            t22 = -2.1795975674590234d-1*t20*t21-8.206208515355806d-2/rh
     1         oa**1.3333333333333333d+0
            t23 = 1/t8
            t24 = 1/rhoa**1.6666666666666666d+0
            t25 = -4.9237251092134837d-1*t10*t22*t23*t7-8.20620851535580
     1         6d-2*t10*t19*t24
            t26 = 1/t17**2
            t27 = 3.784699104639999d+1*t26+1
            t28 = 1/t27
            t29 = 1/t14
            t30 = -1.0d+0*t10*t14*t22*t23-1.1694876738238703d-1*t10*t13*
     1         t20*t21
            t31 = 9.690227711544375d-4*t29*t30*t9+6.314467057030004d-2*t
     1         19*t25*t9+2.790332964441521d-2*t20*t21*t26*t28
            t32 = 2.0d+0*t31*wght
            t33 = 1/rhoa**2.3333333333333334d+0
            t34 = -2.470091445929572d-1*t33/(t17**5*t27**2)
            t35 = 6.526520015557556d-3*t28*t33/t17**3
            t36 = 1/abs(t5+7.496532937978391d-1*t3+1.14813d+1)
            t37 = -1.688686394038963d-2*log(4.9237251092134837d-1*t36*t7
     1         )-3.6490335179177674d-4*log(1.0d+0*(t12+2.28344d-1)**2*t3
     2         6)-5.458482358638966d-3*atan(6.692072046645942d+0/(t16+1.
     3         0683499999999999d+0))
            t38 = 1/abs(t5+4.9542444972117183d+0*t3+1.8057800000000002d+
     1         1)
            t39 = 1.554535d-2*log(4.9237251092134837d-1*t38*t7)+2.247867
     1         0955426108d-3*log(1.0d+0*(t12+3.25d-1)**2*t38)-3.87832948
     2         78113006d-2*t18+5.249139316978092d-2*atan(4.7309269095601
     3         136d+0/(t16+7.06042d+0))-9.690227711544375d-4*t15-3.10907
     4         d-2*t11
            t40 = 1/abs(t5+9.17252572333538d+0*t3+4.2719799999999997d+1)
            t41 = 1/abs(t5+1.4120230445475074d+1*t3+1.01578d+2)
            t42 = 1/(1.554535d-2*log(4.9237251092134837d-1*t41*t7)-3.109
     1         07d-2*log(4.9237251092134837d-1*t40*t7)+2.667310007273315
     2         d-3*log(1.0d+0*(t12+7.43294d-1)**2*t41)-4.431373767749538
     3         d-3*log(1.0d+0*(t12+4.09286d-1)**2*t40)+6.188180297906176
     4         d-1*atan(1.171685277708971d+0/(t16+2.0123100000000002d+1)
     5         )-2.052197293770518d+1*atan(4.4899888641576796d-2/(t16+1.
     6         3072d+1)))
            t43 = 1/rhoa**2
            t44 = 1/rhoa**1.6666666666666669d+0
            t45 = -9.301109881471736d-3*t20*t26*t28*t44
            t46 = t22**2
            t47 = 1/t8**2
            t48 = 1/t2**5
            t49 = 1/rhoa**1.3333333333333336d+0
            t50 = 5.448993918647558d-2*t48*t49+7.265325224863413d-2*t20*
     1         t44+5.470805676903872d-2/rhoa**2.333333333333333d+0
            t51 = 6.314467057030004d-2*t19*(-4.9237251092134837d-1*t10*t
     1         23*t50*t7+9.847450218426967d-1*t10*t46*t47*t7+1.641241703
     2         0711612d-1*t10*t19*t22*t23*t24+5.470805676903869d-2*t10*t
     3         19/rhoa**2.6666666666666666d+0)*t9
            t52 = -6.975832411103801d-3*t26*t28*t48*t49
            t53 = 1.0524111761716676d-2*t19*t25*t9/rhoa**9.9999999999999
     1         99d-1
            t54 = 1.1332601865197636d-4*t20*t21*t30*t9/t13**3
            t55 = 9.690227711544375d-4*t29*(-1.0d+0*t10*t14*t23*t50+2.92
     1         3719184559675d-2*t10*t13*t48*t49+2.0d+0*t10*t14*t46*t47+3
     2         .898292246079568d-2*t10*t13*t20*t44+6.838507096129838d-3*
     3         t10*t33+2.3389753476477407d-1*t10*t13*t20*t21*t22*t23)*t9
            t56 = 6.314467057030004d-2*t10*t19*t22*t25*t8
            t57 = 9.690227711544375d-4*t10*t22*t29*t30*t8
            fnc(iq) = 2.0d+0*rhoa*(3.10907d-2*log(4.9237251092134837d-1*
     1         t6*t7)+9.690227711544375d-4*log(1.0d+0*(7.016926042943223
     2         d-1*t3+1.0498d-1)**2*t6)+3.8783294878113006d-2*atan(6.151
     3         99081975908d+0/(1.4033852085886447d+0*t3+3.72744d+0)))*wg
     4         ht+fnc(iq)
            Amat(iq,D1_RA) = 2.0d+0*rhoa*t31*wght+1.0d+0*(3.878329487811
     1         3006d-2*t18+9.690227711544375d-4*t15+3.10907d-2*t11)*wght
     2         +Amat(iq,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*(t57+t56+t55+t54+t53+t52+t5
     1         1+t45+2.5000000000000006d-1*t37*t39*t42*t43+t35+t34)*wght
     2         +t32+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*(t57+t56+t55+t54+t53+t52+t5
     1         1+t45-2.5000000000000006d-1*t37*t39*t42*t43+t35+t34)*wght
     2         +t32+Amat2(iq,D2_RA_RB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = t2**5.0d-1
            t4 = 1/t3
            t5 = 1.5752466357994865d+0*t4
            t6 = t5+3.72744d+0
            t7 = atan(6.15199081975908d+0/t6)
            t8 = 7.876233178997433d-1*t4
            t9 = t8+1.0498d-1
            t10 = t9**2
            t11 = 1/t2
            t12 = 6.203504908994001d-1*t11
            t13 = 2.935818660072219d+0*t4+t12+1.29352d+1
            t14 = abs(t13)
            t15 = 1/t14
            t16 = log(1.0d+0*t10*t15)
            t17 = abs(t11)
            t18 = log(6.203504908994001d-1*t15*t17)
            t19 = rhoa-rhob
            t20 = 1/t1
            t21 = 1.0d+0-t19*t20
            t22 = t19*t20+1.0d+0
            t23 = t22**1.3333333333333333d+0+t21**1.3333333333333333d+0-
     1         2.0d+0
            t24 = t5+7.06042d+0
            t25 = t8+3.25d-1
            t26 = t25**2
            t27 = 5.560951426165704d+0*t4+t12+1.8057800000000002d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = -3.8783294878113006d-2*t7+2.2478670955426108d-3*log(1.
     1         0d+0*t26*t29)+1.554535d-2*log(6.203504908994001d-1*t17*t2
     2         9)+5.249139316978092d-2*atan(4.7309269095601136d+0/t24)-3
     3         .10907d-2*t18-9.690227711544375d-4*t16
            t31 = t5+1.0683499999999999d+0
            t32 = atan(6.692072046645942d+0/t31)
            t33 = t8+2.28344d-1
            t34 = t33**2
            t35 = 8.414573716781907d-1*t4+t12+1.14813d+1
            t36 = abs(t35)
            t37 = 1/t36
            t38 = log(1.0d+0*t34*t37)
            t39 = log(6.203504908994001d-1*t17*t37)
            t40 = t19**4
            t41 = 1/t1**4
            t42 = t5+1.3072d+1
            t43 = t5+2.0123100000000002d+1
            t44 = t8+4.09286d-1
            t45 = t44**2
            t46 = 1.0295812011585444d+1*t4+t12+4.2719799999999997d+1
            t47 = abs(t46)
            t48 = 1/t47
            t49 = t8+7.43294d-1
            t50 = t49**2
            t51 = 1.5849422788428325d+1*t4+t12+1.01578d+2
            t52 = abs(t51)
            t53 = 1/t52
            t54 = 2.667310007273315d-3*log(1.0d+0*t50*t53)+1.554535d-2*l
     1         og(6.203504908994001d-1*t17*t53)-4.431373767749538d-3*log
     2         (1.0d+0*t45*t48)-3.10907d-2*log(6.203504908994001d-1*t17*
     3         t48)+6.188180297906176d-1*atan(1.171685277708971d+0/t43)-
     4         2.052197293770518d+1*atan(4.4899888641576796d-2/t42)
            t55 = 1.709920934161365d+0*t54+1.688686394038963d-2*t39+3.64
     1         90335179177674d-4*t38+5.458482358638966d-3*t32
            t56 = t40*t41*t55-1.688686394038963d-2*t39-3.649033517917767
     1         4d-4*t38-5.458482358638966d-3*t32
            t57 = 1/t54
            t58 = 3.8783294878113006d-2*t7+1.1250000000000002d+0*t23*t30
     1         *t56*t57+3.10907d-2*t18+9.690227711544375d-4*t16
            t59 = 1/t1**6.666666666666667d-1
            t60 = 1/t3**3
            t61 = 1/t6**2
            t62 = 3.784699104639999d+1*t61+1
            t63 = 1/t62
            t64 = 6.264085709464389d-2*t59*t60*t61*t63
            t65 = 1/t10
            t66 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t67 = t66-4.8930311001203647d-1*t59*t60
            t68 = 1/t13
            t69 = -2.625411059665811d-1*t15*t59*t60*t9-1.0d+0*t10*t15*t6
     1         7*t68
            t70 = 9.690227711544375d-4*t14*t65*t69
            t71 = 1/t17
            t72 = 1/t1**1.6666666666666666d+0
            t73 = -2.067834969664667d-1*t15*t71*t72-6.203504908994001d-1
     1         *t15*t17*t67*t68
            t74 = 5.011795824473985d-2*t14*t71*t73
            t75 = 1/t42**2
            t76 = 2.016000000025997d-3*t75+1
            t77 = 1/t76
            t78 = 1/t43**2
            t79 = 1.3728463899999485d+0*t78+1
            t80 = 1/t79
            t81 = 1/t45
            t82 = t66-1.715968668597574d+0*t59*t60
            t83 = 1/t46
            t84 = -1.0d+0*t45*t48*t82*t83-2.625411059665811d-1*t44*t48*t
     1         59*t60
            t85 = -6.203504908994001d-1*t17*t48*t82*t83-2.06783496966466
     1         7d-1*t48*t71*t72
            t86 = 1/t50
            t87 = t66-2.641570464738054d+0*t59*t60
            t88 = 1/t51
            t89 = -1.0d+0*t50*t53*t87*t88-2.625411059665811d-1*t49*t53*t
     1         59*t60
            t90 = -6.203504908994001d-1*t17*t53*t87*t88-2.06783496966466
     1         7d-1*t53*t71*t72
            t91 = 2.5058979122369923d-2*t52*t71*t90+2.667310007273315d-3
     1         *t52*t86*t89-5.011795824473985d-2*t47*t71*t85-4.431373767
     2         749538d-3*t47*t81*t84+1.9035804775132142d-1*t59*t60*t78*t
     3         80-2.4191438009473537d-1*t59*t60*t75*t77
            t92 = 1/t54**2
            t93 = -1.1250000000000002d+0*t23*t30*t56*t91*t92
            t94 = 1/t31**2
            t95 = 4.4783828277500004d+1*t94+1
            t96 = 1/t95
            t97 = -9.590247809108334d-3*t59*t60*t94*t96
            t98 = 1/t34
            t99 = t66-1.4024289527969844d-1*t59*t60
            t100 = 1/t35
            t101 = -1.0d+0*t100*t34*t37*t99-2.625411059665811d-1*t33*t37
     1         *t59*t60
            t102 = -3.6490335179177674d-4*t101*t36*t98
            t103 = -6.203504908994001d-1*t100*t17*t37*t99-2.067834969664
     1         667d-1*t37*t71*t72
            t104 = -2.722148880047894d-2*t103*t36*t71
            t105 = 3.6490335179177674d-4*t101*t36*t98+9.590247809108334d
     1         -3*t59*t60*t94*t96+1.709920934161365d+0*t91+2.72214888004
     2         7894d-2*t103*t36*t71
            t106 = t105*t40*t41
            t107 = 1/t1**5
            t108 = -4*t107*t40*t55
            t109 = t19**3
            t110 = t97+4*t109*t41*t55+t108+t106+t104+t102
            t111 = 1/t24**2
            t112 = 2.238166942360001d+1*t111+1
            t113 = 1/t112
            t114 = 1/t26
            t115 = t66-9.26825237694284d-1*t59*t60
            t116 = 1/t27
            t117 = -2.625411059665811d-1*t25*t29*t59*t60-1.0d+0*t115*t11
     1         6*t26*t29
            t118 = -2.067834969664667d-1*t29*t71*t72-6.203504908994001d-
     1         1*t115*t116*t17*t29
            t119 = -5.011795824473985d-2*t14*t71*t73+2.5058979122369923d
     1         -2*t118*t28*t71-9.690227711544375d-4*t14*t65*t69-6.264085
     2         709464389d-2*t59*t60*t61*t63+6.519760588836059d-2*t111*t1
     3         13*t59*t60+2.2478670955426108d-3*t114*t117*t28
            t120 = 1.1250000000000002d+0*t119*t23*t56*t57
            t121 = 1/t1**2
            t122 = t121*t19
            t123 = -t20
            t124 = t123+t122
            t125 = t21**3.333333333333333d-1
            t126 = -t121*t19
            t127 = t20+t126
            t128 = t22**3.333333333333333d-1
            t129 = 1.3333333333333333d+0*t127*t128+1.3333333333333333d+0
     1         *t124*t125
            t130 = t93+t74+t70+t64+1.1250000000000002d+0*t129*t30*t56*t5
     1         7+1.1250000000000002d+0*t110*t23*t30*t57+t120
            t131 = 1.0d+0*t58*wght
            t132 = t97-4*t109*t41*t55+t108+t106+t104+t102
            t133 = t20+t122
            t134 = t126+t123
            t135 = 1.3333333333333333d+0*t128*t134+1.3333333333333333d+0
     1         *t125*t133
            t136 = t93+t74+t70+t64+1.1250000000000002d+0*t135*t30*t56*t5
     1         7+1.1250000000000002d+0*t132*t23*t30*t57+t120
            t137 = 1/t1**2.3333333333333334d+0
            t138 = 1/t6**5
            t139 = 1/t62**2
            t140 = -1.2448480831567728d+0*t137*t138*t139
            t141 = 1/t6**3
            t142 = 3.289159980064472d-2*t137*t141*t63
            t143 = 1/t1**1.3333333333333336d+0
            t144 = 1/t3**5
            t145 = -3.1320428547321943d-2*t143*t144*t61*t63
            t146 = 1/t1**1.6666666666666669d+0
            t147 = -4.176057139642926d-2*t146*t60*t61*t63
            t148 = 9.690227711544375d-4*t13*t15*t65*t67*t69
            t149 = 5.011795824473985d-2*t13*t15*t67*t71*t73
            t150 = t67**2
            t151 = 1/t13**2
            t152 = 2.7571132928862224d-1/t1**2.333333333333333d+0
            t153 = 3.262020733413577d-1*t146*t60+t152+2.4465155500601823
     1         d-1*t143*t144
            t154 = 5.250822119331622d-1*t15*t59*t60*t67*t68*t9+1.7502740
     1         397772074d-1*t146*t15*t60*t9+1.3127055298329054d-1*t143*t
     2         144*t15*t9-1.0d+0*t10*t15*t153*t68+2.0d+0*t10*t15*t150*t1
     3         51+3.446391616107778d-2*t137*t15
            t155 = 9.690227711544375d-4*t14*t154*t65
            t156 = 1/t9**3
            t157 = 2.544083100456872d-4*t14*t156*t59*t60*t69
            t158 = 1/t1**2.6666666666666666d+0
            t159 = 4.135669939329334d-1*t15*t67*t68*t71*t72+2.7571132928
     1         862224d-1*t15*t158*t71-6.203504908994001d-1*t15*t153*t17*
     2         t68+1.2407009817988002d+0*t15*t150*t151*t17
            t160 = 5.011795824473985d-2*t14*t159*t71
            t161 = 1/t1**9.999999999999999d-1
            t162 = 1.670598608157995d-2*t14*t161*t71*t73
            t163 = 2.2500000000000003d+0*t23*t30*t56*t91**2/t54**3
            t164 = -2.2500000000000003d+0*t119*t23*t56*t91*t92
            t165 = t82**2
            t166 = 1/t46**2
            t167 = 1.1439791123983827d+0*t146*t60+t152+8.57984334298787d
     1         -1*t143*t144
            t168 = t87**2
            t169 = 1/t51**2
            t170 = 1.761046976492036d+0*t146*t60+t152+1.320785232369027d
     1         +0*t143*t144
            t171 = 2.5058979122369923d-2*t51*t53*t71*t87*t90+8.352993040
     1         789976d-3*t161*t52*t71*t90+2.667310007273315d-3*t51*t53*t
     2         86*t87*t89+7.002785192652656d-4*t52*t59*t60*t89/t49**3+2.
     3         5058979122369923d-2*t52*t71*(4.135669939329334d-1*t53*t71
     4         *t72*t87*t88-6.203504908994001d-1*t17*t170*t53*t88+2.7571
     5         132928862224d-1*t158*t53*t71+1.2407009817988002d+0*t168*t
     6         169*t17*t53)+2.667310007273315d-3*t52*t86*(5.250822119331
     7         622d-1*t49*t53*t59*t60*t87*t88-1.0d+0*t170*t50*t53*t88+1.
     8         7502740397772074d-1*t146*t49*t53*t60+2.0d+0*t168*t169*t50
     9         *t53+1.3127055298329054d-1*t143*t144*t49*t53+3.4463916161
     :         07778d-2*t137*t53)-5.011795824473985d-2*t46*t48*t71*t82*t
     ;         85-1.670598608157995d-2*t161*t47*t71*t85-4.43137376774953
     <         8d-3*t46*t48*t81*t82*t84-1.1634177699362593d-3*t47*t59*t6
     =         0*t84/t44**3-5.011795824473985d-2*t47*t71*(4.135669939329
     >         334d-1*t48*t71*t72*t82*t83-6.203504908994001d-1*t167*t17*
     ?         t48*t83+2.7571132928862224d-1*t158*t48*t71+1.240700981798
     @         8002d+0*t165*t166*t17*t48)-4.431373767749538d-3*t47*t81*(
     1         5.250822119331622d-1*t44*t48*t59*t60*t82*t83-1.0d+0*t167*
     2         t45*t48*t83+1.7502740397772074d-1*t146*t44*t48*t60+2.0d+0
     3         *t165*t166*t45*t48+1.3127055298329054d-1*t143*t144*t44*t4
     4         8+3.446391616107778d-2*t137*t48)-1.2690536516754763d-1*t1
     5         46*t60*t78*t80-9.517902387566071d-2*t143*t144*t78*t80+9.9
     6         95362477254237d-2*t137*t80/t43**3-1.372209729363942d-1*t1
     7         37/(t43**5*t79**2)+1.6127625339649027d-1*t146*t60*t75*t77
     8         +1.2095719004736769d-1*t143*t144*t75*t77-1.27024937798583
     9         4d-1*t137*t77/t42**3+2.560822746052464d-4*t137/(t42**5*t7
     :         6**2)
            t172 = -1.1250000000000002d+0*t171*t23*t30*t56*t92
            t173 = 1/t31**5
            t174 = 1/t95**2
            t175 = 2.255165148260897d-1*t137*t173*t174
            t176 = 1/t31**3
            t177 = -5.035668532593766d-3*t137*t176*t96
            t178 = 4.795123904554167d-3*t143*t144*t94*t96
            t179 = 6.393498539405557d-3*t146*t60*t94*t96
            t180 = -3.6490335179177674d-4*t101*t35*t37*t98*t99
            t181 = -2.722148880047894d-2*t103*t35*t37*t71*t99
            t182 = t99**2
            t183 = 1/t35**2
            t184 = 9.349526351979897d-2*t146*t60+t152+7.012144763984922d
     1         -2*t143*t144
            t185 = 5.250822119331622d-1*t100*t33*t37*t59*t60*t99+1.75027
     1         40397772074d-1*t146*t33*t37*t60-1.0d+0*t100*t184*t34*t37+
     2         2.0d+0*t182*t183*t34*t37+1.3127055298329054d-1*t143*t144*
     3         t33*t37+3.446391616107778d-2*t137*t37
            t186 = -3.6490335179177674d-4*t185*t36*t98
            t187 = 1/t33**3
            t188 = -9.580212955032547d-5*t101*t187*t36*t59*t60
            t189 = 4.135669939329334d-1*t100*t37*t71*t72*t99+2.757113292
     1         8862224d-1*t158*t37*t71-6.203504908994001d-1*t100*t17*t18
     2         4*t37+1.2407009817988002d+0*t17*t182*t183*t37
            t190 = -2.722148880047894d-2*t189*t36*t71
            t191 = -9.073829600159646d-3*t103*t161*t36*t71
            t192 = -8*t105*t107*t40
            t193 = t40*t41*(3.6490335179177674d-4*t101*t35*t37*t98*t99+2
     1         .722148880047894d-2*t103*t35*t37*t71*t99+3.64903351791776
     2         74d-4*t185*t36*t98-6.393498539405557d-3*t146*t60*t94*t96-
     3         4.795123904554167d-3*t143*t144*t94*t96+5.035668532593766d
     4         -3*t137*t176*t96+2.722148880047894d-2*t189*t36*t71+9.0738
     5         29600159646d-3*t103*t161*t36*t71+9.580212955032547d-5*t10
     6         1*t187*t36*t59*t60-2.255165148260897d-1*t137*t173*t174+1.
     7         709920934161365d+0*t171)
            t194 = 20*t40*t55/t1**6
            t195 = t19**2
            t196 = 12*t195*t41*t55
            t197 = t115**2
            t198 = 1/t27**2
            t199 = 6.178834917961894d-1*t146*t60+t152+4.63412618847142d-
     1         1*t143*t144
            t200 = 1.1250000000000002d+0*t23*t56*t57*(-5.011795824473985
     1         d-2*t13*t15*t67*t71*t73-1.670598608157995d-2*t14*t161*t71
     2         *t73+2.5058979122369923d-2*t28*t71*(4.135669939329334d-1*
     3         t115*t116*t29*t71*t72+2.7571132928862224d-1*t158*t29*t71-
     4         6.203504908994001d-1*t116*t17*t199*t29+1.2407009817988002
     5         d+0*t17*t197*t198*t29)+2.5058979122369923d-2*t115*t118*t2
     6         7*t29*t71+8.352993040789976d-3*t118*t161*t28*t71-5.011795
     7         824473985d-2*t14*t159*t71-9.690227711544375d-4*t13*t15*t6
     8         5*t67*t69-2.544083100456872d-4*t14*t156*t59*t60*t69-9.690
     9         227711544375d-4*t14*t154*t65+4.176057139642926d-2*t146*t6
     :         0*t61*t63+3.1320428547321943d-2*t143*t144*t61*t63-3.28915
     ;         9980064472d-2*t137*t141*t63+2.2478670955426108d-3*t114*t2
     <         8*(5.250822119331622d-1*t115*t116*t25*t29*t59*t60+1.75027
     =         40397772074d-1*t146*t25*t29*t60-1.0d+0*t116*t199*t26*t29+
     >         2.0d+0*t197*t198*t26*t29+1.3127055298329054d-1*t143*t144*
     ?         t25*t29+3.446391616107778d-2*t137*t29)+5.901575133296435d
     @         -4*t117*t28*t59*t60/t25**3-4.3465070592240396d-2*t111*t11
     1         3*t146*t60+2.2478670955426108d-3*t114*t115*t117*t27*t29+3
     2         .4234103112606934d-2*t113*t137/t24**3-7.662163788798045d-
     3         1*t137/(t112**2*t24**5)-3.2598802944180294d-2*t111*t113*t
     4         143*t144+1.2448480831567728d+0*t137*t138*t139)
            t201 = 1/t21**6.666666666666666d-1
            t202 = 1/t1**3
            t203 = -2*t19*t202
            t204 = 2*t121
            t205 = 1/t22**6.666666666666666d-1
            t206 = 2*t19*t202
            t207 = -2*t121
            fnc(iq) = 1.0d+0*t1*t58*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t130*wght+t131+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t136*wght+t131+Amat(iq,D1_RB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*t1*(-2.2500000000000003d+0*t129*
     1         t30*t56*t91*t92-2.2500000000000003d+0*t110*t23*t30*t91*t9
     2         2+1.1250000000000002d+0*(1.3333333333333333d+0*t128*(t207
     3         +t206)+4.444444444444444d-1*t127**2*t205+1.33333333333333
     4         33d+0*t125*(t204+t203)+4.444444444444444d-1*t124**2*t201)
     5         *t30*t56*t57+2.2500000000000003d+0*t119*t129*t56*t57+1.12
     6         50000000000002d+0*t23*t30*(-32*t107*t109*t55+8*t105*t109*
     7         t41+t196+t194+t193+t192+t191+t190+t188+t186+t181+t180+t17
     8         9+t178+t177+t175)*t57+2.2500000000000003d+0*t110*t129*t30
     9         *t57+2.2500000000000003d+0*t110*t119*t23*t57+t200+t172+t1
     :         64+t163+t162+t160+t157+t155+t149+t148+t147+t145+t142+t140
     ;         )*wght+2.0d+0*t130*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*t1*(-1.1250000000000002d+0*t135*
     1         t30*t56*t91*t92-1.1250000000000002d+0*t129*t30*t56*t91*t9
     2         2-1.1250000000000002d+0*t132*t23*t30*t91*t92-1.1250000000
     3         000002d+0*t110*t23*t30*t91*t92+1.1250000000000002d+0*(4.4
     4         44444444444444d-1*t127*t134*t205+2.6666666666666666d+0*t1
     5         28*t19*t202-2.6666666666666666d+0*t125*t19*t202+4.4444444
     6         44444444d-1*t124*t133*t201)*t30*t56*t57+1.125000000000000
     7         2d+0*t119*t135*t56*t57+1.1250000000000002d+0*t119*t129*t5
     8         6*t57+1.1250000000000002d+0*t23*t30*(-12*t195*t41*t55+t19
     9         4+t193+t192+t191+t190+t188+t186+t181+t180+t179+t178+t177+
     :         t175)*t57+1.1250000000000002d+0*t110*t135*t30*t57+1.12500
     ;         00000000002d+0*t129*t132*t30*t57+1.1250000000000002d+0*t1
     <         19*t132*t23*t57+1.1250000000000002d+0*t110*t119*t23*t57+t
     =         200+t172+t164+t163+t162+t160+t157+t155+t149+t148+t147+t14
     >         5+t142+t140)*wght+1.0d+0*t136*wght+1.0d+0*t130*wght+Amat2
     ?         (iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*t1*(-2.2500000000000003d+0*t135*
     1         t30*t56*t91*t92-2.2500000000000003d+0*t132*t23*t30*t91*t9
     2         2+1.1250000000000002d+0*(1.3333333333333333d+0*t125*(t207
     3         +t203)+1.3333333333333333d+0*t128*(t206+t204)+4.444444444
     4         444444d-1*t134**2*t205+4.444444444444444d-1*t133**2*t201)
     5         *t30*t56*t57+2.2500000000000003d+0*t119*t135*t56*t57+1.12
     6         50000000000002d+0*t23*t30*(32*t107*t109*t55-8*t105*t109*t
     7         41+t196+t194+t193+t192+t191+t190+t188+t186+t181+t180+t179
     8         +t178+t177+t175)*t57+2.2500000000000003d+0*t132*t135*t30*
     9         t57+2.2500000000000003d+0*t119*t132*t23*t57+t200+t172+t16
     :         4+t163+t162+t160+t157+t155+t149+t148+t147+t145+t142+t140)
     ;         *wght+2.0d+0*t136*wght+Amat2(iq,D2_RB_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = t11+3.25d-1
            t22 = t21**2
            t23 = t15+7.06042d+0
            t24 = 1.554535d-2*log(6.203504908994001d-1*t20*t9)+5.2491393
     1         16978092d-2*atan(4.7309269095601136d+0/t23)+2.24786709554
     2         26108d-3*log(1.0d+0*t20*t22)-3.8783294878113006d-2*t17-9.
     3         690227711544375d-4*t14-3.10907d-2*t10
            t25 = t5+8.414573716781907d-1*t3+1.14813d+1
            t26 = abs(t25)
            t27 = 1/t26
            t28 = log(6.203504908994001d-1*t27*t9)
            t29 = t11+2.28344d-1
            t30 = t29**2
            t31 = log(1.0d+0*t27*t30)
            t32 = t15+1.0683499999999999d+0
            t33 = atan(6.692072046645942d+0/t32)
            t34 = t5+1.0295812011585444d+1*t3+4.2719799999999997d+1
            t35 = abs(t34)
            t36 = 1/t35
            t37 = t5+1.5849422788428325d+1*t3+1.01578d+2
            t38 = abs(t37)
            t39 = 1/t38
            t40 = t11+4.09286d-1
            t41 = t40**2
            t42 = t11+7.43294d-1
            t43 = t42**2
            t44 = t15+1.3072d+1
            t45 = t15+2.0123100000000002d+1
            t46 = 1.554535d-2*log(6.203504908994001d-1*t39*t9)-3.10907d-
     1         2*log(6.203504908994001d-1*t36*t9)+6.188180297906176d-1*a
     2         tan(1.171685277708971d+0/t45)-2.052197293770518d+1*atan(4
     3         .4899888641576796d-2/t44)+2.667310007273315d-3*log(1.0d+0
     4         *t39*t43)-4.431373767749538d-3*log(1.0d+0*t36*t41)
            t47 = 1.0d+0*(1.709920934161365d+0*t46+5.458482358638966d-3*
     1         t33+3.6490335179177674d-4*t31+1.688686394038963d-2*t28)-5
     2         .458482358638966d-3*t33-3.6490335179177674d-4*t31-1.68868
     3         6394038963d-2*t28
            t48 = 1/t46
            t49 = 5.848223622634643d-1*t24*t47*t48+3.8783294878113006d-2
     1         *t17+9.690227711544375d-4*t14+3.10907d-2*t10
            t50 = 1/t9
            t51 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t52 = 1/t2**3
            t53 = 1/rhoa**6.666666666666667d-1
            t54 = t51-4.8930311001203647d-1*t52*t53
            t55 = 1/t6
            t56 = 1/rhoa**1.6666666666666666d+0
            t57 = -6.203504908994001d-1*t54*t55*t8*t9-2.067834969664667d
     1         -1*t50*t56*t8
            t58 = 1/t16**2
            t59 = 3.784699104639999d+1*t58+1
            t60 = 1/t59
            t61 = 1/t13
            t62 = -1.0d+0*t13*t54*t55*t8-2.625411059665811d-1*t12*t52*t5
     1         3*t8
            t63 = t51-9.26825237694284d-1*t52*t53
            t64 = 1/t18
            t65 = -6.203504908994001d-1*t20*t63*t64*t9-2.067834969664667
     1         d-1*t20*t50*t56
            t66 = 1/t23**2
            t67 = 2.238166942360001d+1*t66+1
            t68 = 1/t67
            t69 = 1/t22
            t70 = -1.0d+0*t20*t22*t63*t64-2.625411059665811d-1*t20*t21*t
     1         52*t53
            t71 = 2.2478670955426108d-3*t19*t69*t70-9.690227711544375d-4
     1         *t61*t62*t7-5.011795824473985d-2*t50*t57*t7+6.51976058883
     2         6059d-2*t52*t53*t66*t68+2.5058979122369923d-2*t19*t50*t65
     3         -6.264085709464389d-2*t52*t53*t58*t60
            t72 = 1/t46**2
            t73 = t51-1.715968668597574d+0*t52*t53
            t74 = 1/t34
            t75 = -6.203504908994001d-1*t36*t73*t74*t9-2.067834969664667
     1         d-1*t36*t50*t56
            t76 = t51-2.641570464738054d+0*t52*t53
            t77 = 1/t37
            t78 = -6.203504908994001d-1*t39*t76*t77*t9-2.067834969664667
     1         d-1*t39*t50*t56
            t79 = 1/t44**2
            t80 = 2.016000000025997d-3*t79+1
            t81 = 1/t80
            t82 = 1/t45**2
            t83 = 1.3728463899999485d+0*t82+1
            t84 = 1/t83
            t85 = 1/t41
            t86 = -1.0d+0*t36*t41*t73*t74-2.625411059665811d-1*t36*t40*t
     1         52*t53
            t87 = 1/t43
            t88 = -1.0d+0*t39*t43*t76*t77-2.625411059665811d-1*t39*t42*t
     1         52*t53
            t89 = 2.667310007273315d-3*t38*t87*t88-4.431373767749538d-3*
     1         t35*t85*t86+1.9035804775132142d-1*t52*t53*t82*t84-2.41914
     2         38009473537d-1*t52*t53*t79*t81+2.5058979122369923d-2*t38*
     3         t50*t78-5.011795824473985d-2*t35*t50*t75
            t90 = t51-1.4024289527969844d-1*t52*t53
            t91 = 1/t25
            t92 = -6.203504908994001d-1*t27*t9*t90*t91-2.067834969664667
     1         d-1*t27*t50*t56
            t93 = 1/t32**2
            t94 = 4.4783828277500004d+1*t93+1
            t95 = 1/t94
            t96 = 1/t30
            t97 = -1.0d+0*t27*t30*t90*t91-2.625411059665811d-1*t27*t29*t
     1         52*t53
            t98 = 1.0d+0*(3.6490335179177674d-4*t26*t96*t97+9.5902478091
     1         08334d-3*t52*t53*t93*t95+2.722148880047894d-2*t26*t50*t92
     2         +1.709920934161365d+0*t89)-3.6490335179177674d-4*t26*t96*
     3         t97-9.590247809108334d-3*t52*t53*t93*t95-2.72214888004789
     4         4d-2*t26*t50*t92
            t99 = 5.848223622634643d-1*t24*t48*t98-5.848223622634643d-1*
     1         t24*t47*t72*t89+5.848223622634643d-1*t47*t48*t71+9.690227
     2         711544375d-4*t61*t62*t7+5.011795824473985d-2*t50*t57*t7+6
     3         .264085709464389d-2*t52*t53*t58*t60
            t100 = 1/t59**2
            t101 = 1/t16**5
            t102 = 1/rhoa**2.3333333333333334d+0
            t103 = 1/t16**3
            t104 = 1/rhoa**1.6666666666666669d+0
            t105 = t54**2
            t106 = 1/t6**2
            t107 = 2.7571132928862224d-1/rhoa**2.333333333333333d+0
            t108 = 1/t2**5
            t109 = 1/rhoa**1.3333333333333336d+0
            t110 = 3.262020733413577d-1*t104*t52+2.4465155500601823d-1*t
     1         108*t109+t107
            t111 = 1/rhoa**2.6666666666666666d+0
            t112 = -6.203504908994001d-1*t110*t55*t8*t9+1.24070098179880
     1         02d+0*t105*t106*t8*t9+4.135669939329334d-1*t50*t54*t55*t5
     2         6*t8+2.7571132928862224d-1*t111*t50*t8
            t113 = 1/rhoa**9.999999999999999d-1
            t114 = 1/t12**3
            t115 = 5.250822119331622d-1*t12*t52*t53*t54*t55*t8-1.0d+0*t1
     1         10*t13*t55*t8+1.7502740397772074d-1*t104*t12*t52*t8+2.0d+
     2         0*t105*t106*t13*t8+1.3127055298329054d-1*t108*t109*t12*t8
     3         +3.446391616107778d-2*t102*t8
            t116 = 1/t94**2
            t117 = 1/t32**5
            t118 = 1/t32**3
            t119 = t90**2
            t120 = 1/t25**2
            t121 = 9.349526351979897d-2*t104*t52+7.012144763984922d-2*t1
     1         08*t109+t107
            t122 = 4.135669939329334d-1*t27*t50*t56*t90*t91-6.2035049089
     1         94001d-1*t121*t27*t9*t91+1.2407009817988002d+0*t119*t120*
     2         t27*t9+2.7571132928862224d-1*t111*t27*t50
            t123 = 1/t29**3
            t124 = 5.250822119331622d-1*t27*t29*t52*t53*t90*t91-1.0d+0*t
     1         121*t27*t30*t91+1.7502740397772074d-1*t104*t27*t29*t52+2.
     2         0d+0*t119*t120*t27*t30+1.3127055298329054d-1*t108*t109*t2
     3         7*t29+3.446391616107778d-2*t102*t27
            t125 = t73**2
            t126 = 1/t34**2
            t127 = 1.1439791123983827d+0*t104*t52+8.57984334298787d-1*t1
     1         08*t109+t107
            t128 = t76**2
            t129 = 1/t37**2
            t130 = 1.761046976492036d+0*t104*t52+1.320785232369027d+0*t1
     1         08*t109+t107
            t131 = 2.5058979122369923d-2*t38*t50*(-6.203504908994001d-1*
     1         t130*t39*t77*t9+1.2407009817988002d+0*t128*t129*t39*t9+4.
     2         135669939329334d-1*t39*t50*t56*t76*t77+2.7571132928862224
     3         d-1*t111*t39*t50)-5.011795824473985d-2*t35*t50*(-6.203504
     4         908994001d-1*t127*t36*t74*t9+1.2407009817988002d+0*t125*t
     5         126*t36*t9+4.135669939329334d-1*t36*t50*t56*t73*t74+2.757
     6         1132928862224d-1*t111*t36*t50)+2.667310007273315d-3*t37*t
     7         39*t76*t87*t88+7.002785192652656d-4*t38*t52*t53*t88/t42**
     8         3+2.667310007273315d-3*t38*(5.250822119331622d-1*t39*t42*
     9         t52*t53*t76*t77-1.0d+0*t130*t39*t43*t77+1.750274039777207
     :         4d-1*t104*t39*t42*t52+2.0d+0*t128*t129*t39*t43+1.31270552
     ;         98329054d-1*t108*t109*t39*t42+3.446391616107778d-2*t102*t
     <         39)*t87-4.431373767749538d-3*t34*t36*t73*t85*t86-1.163417
     =         7699362593d-3*t35*t52*t53*t86/t40**3-4.431373767749538d-3
     >         *t35*(5.250822119331622d-1*t36*t40*t52*t53*t73*t74-1.0d+0
     ?         *t127*t36*t41*t74+1.7502740397772074d-1*t104*t36*t40*t52+
     @         2.0d+0*t125*t126*t36*t41+1.3127055298329054d-1*t108*t109*
     1         t36*t40+3.446391616107778d-2*t102*t36)*t85-1.269053651675
     2         4763d-1*t104*t52*t82*t84-9.517902387566071d-2*t108*t109*t
     3         82*t84+9.995362477254237d-2*t102*t84/t45**3-1.37220972936
     4         3942d-1*t102/(t45**5*t83**2)+1.6127625339649027d-1*t104*t
     5         52*t79*t81+1.2095719004736769d-1*t108*t109*t79*t81-1.2702
     6         49377985834d-1*t102*t81/t44**3+2.560822746052464d-4*t102/
     7         (t44**5*t80**2)+2.5058979122369923d-2*t37*t39*t50*t76*t78
     8         +8.352993040789976d-3*t113*t38*t50*t78-5.011795824473985d
     9         -2*t34*t36*t50*t73*t75-1.670598608157995d-2*t113*t35*t50*
     :         t75
            t132 = t63**2
            t133 = 1/t18**2
            t134 = 6.178834917961894d-1*t104*t52+4.63412618847142d-1*t10
     1         8*t109+t107
            fnc(iq) = 1.0d+0*rhoa*t49*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t99*wght+1.0d+0*t49*wght+Amat(i
     1         q,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*t99*wght+1.0d+0*rhoa*(-1.1696447
     1         245269286d+0*t24*t72*t89*t98+1.1696447245269286d+0*t48*t7
     2         1*t98+5.848223622634643d-1*t24*t48*(1.0d+0*(3.64903351791
     3         77674d-4*t25*t27*t90*t96*t97+9.580212955032547d-5*t123*t2
     4         6*t52*t53*t97+3.6490335179177674d-4*t124*t26*t96-6.393498
     5         539405557d-3*t104*t52*t93*t95-4.795123904554167d-3*t108*t
     6         109*t93*t95+5.035668532593766d-3*t102*t118*t95+2.72214888
     7         0047894d-2*t25*t27*t50*t90*t92+9.073829600159646d-3*t113*
     8         t26*t50*t92+2.722148880047894d-2*t122*t26*t50+1.709920934
     9         161365d+0*t131-2.255165148260897d-1*t102*t116*t117)-3.649
     :         0335179177674d-4*t25*t27*t90*t96*t97-9.580212955032547d-5
     ;         *t123*t26*t52*t53*t97-3.6490335179177674d-4*t124*t26*t96+
     <         6.393498539405557d-3*t104*t52*t93*t95+4.795123904554167d-
     =         3*t108*t109*t93*t95-5.035668532593766d-3*t102*t118*t95-2.
     >         722148880047894d-2*t25*t27*t50*t90*t92-9.073829600159646d
     ?         -3*t113*t26*t50*t92-2.722148880047894d-2*t122*t26*t50+2.2
     @         55165148260897d-1*t102*t116*t117)+5.848223622634643d-1*t4
     1         7*t48*(2.5058979122369923d-2*t19*t50*(-6.203504908994001d
     2         -1*t134*t20*t64*t9+1.2407009817988002d+0*t132*t133*t20*t9
     3         +4.135669939329334d-1*t20*t50*t56*t63*t64+2.7571132928862
     4         224d-1*t111*t20*t50)-9.690227711544375d-4*t54*t6*t61*t62*
     5         t8-5.011795824473985d-2*t50*t54*t57*t6*t8+2.2478670955426
     6         108d-3*t18*t20*t63*t69*t70+5.901575133296435d-4*t19*t52*t
     7         53*t70/t21**3-2.544083100456872d-4*t114*t52*t53*t62*t7-9.
     8         690227711544375d-4*t115*t61*t7-1.670598608157995d-2*t113*
     9         t50*t57*t7-5.011795824473985d-2*t112*t50*t7+2.24786709554
     :         26108d-3*t19*(5.250822119331622d-1*t20*t21*t52*t53*t63*t6
     ;         4-1.0d+0*t134*t20*t22*t64+1.7502740397772074d-1*t104*t20*
     <         t21*t52+2.0d+0*t132*t133*t20*t22+1.3127055298329054d-1*t1
     =         08*t109*t20*t21+3.446391616107778d-2*t102*t20)*t69-4.3465
     >         070592240396d-2*t104*t52*t66*t68-3.2598802944180294d-2*t1
     ?         08*t109*t66*t68+3.4234103112606934d-2*t102*t68/t23**3-7.6
     @         62163788798045d-1*t102/(t23**5*t67**2)+2.5058979122369923
     1         d-2*t18*t20*t50*t63*t65+8.352993040789976d-3*t113*t19*t50
     2         *t65+4.176057139642926d-2*t104*t52*t58*t60+3.132042854732
     3         1943d-2*t108*t109*t58*t60-3.289159980064472d-2*t102*t103*
     4         t60+1.2448480831567728d+0*t100*t101*t102)+1.1696447245269
     5         286d+0*t24*t47*t89**2/t46**3-1.1696447245269286d+0*t47*t7
     6         1*t72*t89+9.690227711544375d-4*t54*t6*t61*t62*t8+5.011795
     7         824473985d-2*t50*t54*t57*t6*t8-5.848223622634643d-1*t131*
     8         t24*t47*t72+2.544083100456872d-4*t114*t52*t53*t62*t7+9.69
     9         0227711544375d-4*t115*t61*t7+1.670598608157995d-2*t113*t5
     :         0*t57*t7+5.011795824473985d-2*t112*t50*t7-4.1760571396429
     ;         26d-2*t104*t52*t58*t60-3.1320428547321943d-2*t108*t109*t5
     <         8*t60+3.289159980064472d-2*t102*t103*t60-1.24484808315677
     =         28d+0*t100*t101*t102)*wght+Amat2(iq,D2_RA_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = t11+3.25d-1
            t22 = t21**2
            t23 = t15+7.06042d+0
            t24 = 1.554535d-2*log(6.203504908994001d-1*t20*t9)+5.2491393
     1         16978092d-2*atan(4.7309269095601136d+0/t23)+2.24786709554
     2         26108d-3*log(1.0d+0*t20*t22)-3.8783294878113006d-2*t17-9.
     3         690227711544375d-4*t14-3.10907d-2*t10
            t25 = t5+8.414573716781907d-1*t3+1.14813d+1
            t26 = abs(t25)
            t27 = 1/t26
            t28 = log(6.203504908994001d-1*t27*t9)
            t29 = t11+2.28344d-1
            t30 = t29**2
            t31 = log(1.0d+0*t27*t30)
            t32 = t15+1.0683499999999999d+0
            t33 = atan(6.692072046645942d+0/t32)
            t34 = t5+1.0295812011585444d+1*t3+4.2719799999999997d+1
            t35 = abs(t34)
            t36 = 1/t35
            t37 = t5+1.5849422788428325d+1*t3+1.01578d+2
            t38 = abs(t37)
            t39 = 1/t38
            t40 = t11+4.09286d-1
            t41 = t40**2
            t42 = t11+7.43294d-1
            t43 = t42**2
            t44 = t15+1.3072d+1
            t45 = t15+2.0123100000000002d+1
            t46 = 1.554535d-2*log(6.203504908994001d-1*t39*t9)-3.10907d-
     1         2*log(6.203504908994001d-1*t36*t9)+6.188180297906176d-1*a
     2         tan(1.171685277708971d+0/t45)-2.052197293770518d+1*atan(4
     3         .4899888641576796d-2/t44)+2.667310007273315d-3*log(1.0d+0
     4         *t39*t43)-4.431373767749538d-3*log(1.0d+0*t36*t41)
            t47 = 1.0d+0*(1.709920934161365d+0*t46+5.458482358638966d-3*
     1         t33+3.6490335179177674d-4*t31+1.688686394038963d-2*t28)-5
     2         .458482358638966d-3*t33-3.6490335179177674d-4*t31-1.68868
     3         6394038963d-2*t28
            t48 = 1/t46
            t49 = 5.848223622634643d-1*t24*t47*t48+3.8783294878113006d-2
     1         *t17+9.690227711544375d-4*t14+3.10907d-2*t10
            t50 = 1/t9
            t51 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t52 = 1/t2**3
            t53 = 1/rhob**6.666666666666667d-1
            t54 = t51-4.8930311001203647d-1*t52*t53
            t55 = 1/t6
            t56 = 1/rhob**1.6666666666666666d+0
            t57 = -6.203504908994001d-1*t54*t55*t8*t9-2.067834969664667d
     1         -1*t50*t56*t8
            t58 = 1/t16**2
            t59 = 3.784699104639999d+1*t58+1
            t60 = 1/t59
            t61 = 1/t13
            t62 = -1.0d+0*t13*t54*t55*t8-2.625411059665811d-1*t12*t52*t5
     1         3*t8
            t63 = t51-9.26825237694284d-1*t52*t53
            t64 = 1/t18
            t65 = -6.203504908994001d-1*t20*t63*t64*t9-2.067834969664667
     1         d-1*t20*t50*t56
            t66 = 1/t23**2
            t67 = 2.238166942360001d+1*t66+1
            t68 = 1/t67
            t69 = 1/t22
            t70 = -1.0d+0*t20*t22*t63*t64-2.625411059665811d-1*t20*t21*t
     1         52*t53
            t71 = 2.2478670955426108d-3*t19*t69*t70-9.690227711544375d-4
     1         *t61*t62*t7-5.011795824473985d-2*t50*t57*t7+6.51976058883
     2         6059d-2*t52*t53*t66*t68+2.5058979122369923d-2*t19*t50*t65
     3         -6.264085709464389d-2*t52*t53*t58*t60
            t72 = 1/t46**2
            t73 = t51-1.715968668597574d+0*t52*t53
            t74 = 1/t34
            t75 = -6.203504908994001d-1*t36*t73*t74*t9-2.067834969664667
     1         d-1*t36*t50*t56
            t76 = t51-2.641570464738054d+0*t52*t53
            t77 = 1/t37
            t78 = -6.203504908994001d-1*t39*t76*t77*t9-2.067834969664667
     1         d-1*t39*t50*t56
            t79 = 1/t44**2
            t80 = 2.016000000025997d-3*t79+1
            t81 = 1/t80
            t82 = 1/t45**2
            t83 = 1.3728463899999485d+0*t82+1
            t84 = 1/t83
            t85 = 1/t41
            t86 = -1.0d+0*t36*t41*t73*t74-2.625411059665811d-1*t36*t40*t
     1         52*t53
            t87 = 1/t43
            t88 = -1.0d+0*t39*t43*t76*t77-2.625411059665811d-1*t39*t42*t
     1         52*t53
            t89 = 2.667310007273315d-3*t38*t87*t88-4.431373767749538d-3*
     1         t35*t85*t86+1.9035804775132142d-1*t52*t53*t82*t84-2.41914
     2         38009473537d-1*t52*t53*t79*t81+2.5058979122369923d-2*t38*
     3         t50*t78-5.011795824473985d-2*t35*t50*t75
            t90 = t51-1.4024289527969844d-1*t52*t53
            t91 = 1/t25
            t92 = -6.203504908994001d-1*t27*t9*t90*t91-2.067834969664667
     1         d-1*t27*t50*t56
            t93 = 1/t32**2
            t94 = 4.4783828277500004d+1*t93+1
            t95 = 1/t94
            t96 = 1/t30
            t97 = -1.0d+0*t27*t30*t90*t91-2.625411059665811d-1*t27*t29*t
     1         52*t53
            t98 = 1.0d+0*(3.6490335179177674d-4*t26*t96*t97+9.5902478091
     1         08334d-3*t52*t53*t93*t95+2.722148880047894d-2*t26*t50*t92
     2         +1.709920934161365d+0*t89)-3.6490335179177674d-4*t26*t96*
     3         t97-9.590247809108334d-3*t52*t53*t93*t95-2.72214888004789
     4         4d-2*t26*t50*t92
            t99 = 5.848223622634643d-1*t24*t48*t98-5.848223622634643d-1*
     1         t24*t47*t72*t89+5.848223622634643d-1*t47*t48*t71+9.690227
     2         711544375d-4*t61*t62*t7+5.011795824473985d-2*t50*t57*t7+6
     3         .264085709464389d-2*t52*t53*t58*t60
            t100 = 1/t59**2
            t101 = 1/t16**5
            t102 = 1/rhob**2.3333333333333334d+0
            t103 = 1/t16**3
            t104 = 1/rhob**1.6666666666666669d+0
            t105 = t54**2
            t106 = 1/t6**2
            t107 = 2.7571132928862224d-1/rhob**2.333333333333333d+0
            t108 = 1/t2**5
            t109 = 1/rhob**1.3333333333333336d+0
            t110 = 3.262020733413577d-1*t104*t52+2.4465155500601823d-1*t
     1         108*t109+t107
            t111 = 1/rhob**2.6666666666666666d+0
            t112 = -6.203504908994001d-1*t110*t55*t8*t9+1.24070098179880
     1         02d+0*t105*t106*t8*t9+4.135669939329334d-1*t50*t54*t55*t5
     2         6*t8+2.7571132928862224d-1*t111*t50*t8
            t113 = 1/rhob**9.999999999999999d-1
            t114 = 1/t12**3
            t115 = 5.250822119331622d-1*t12*t52*t53*t54*t55*t8-1.0d+0*t1
     1         10*t13*t55*t8+1.7502740397772074d-1*t104*t12*t52*t8+2.0d+
     2         0*t105*t106*t13*t8+1.3127055298329054d-1*t108*t109*t12*t8
     3         +3.446391616107778d-2*t102*t8
            t116 = 1/t94**2
            t117 = 1/t32**5
            t118 = 1/t32**3
            t119 = t90**2
            t120 = 1/t25**2
            t121 = 9.349526351979897d-2*t104*t52+7.012144763984922d-2*t1
     1         08*t109+t107
            t122 = 4.135669939329334d-1*t27*t50*t56*t90*t91-6.2035049089
     1         94001d-1*t121*t27*t9*t91+1.2407009817988002d+0*t119*t120*
     2         t27*t9+2.7571132928862224d-1*t111*t27*t50
            t123 = 1/t29**3
            t124 = 5.250822119331622d-1*t27*t29*t52*t53*t90*t91-1.0d+0*t
     1         121*t27*t30*t91+1.7502740397772074d-1*t104*t27*t29*t52+2.
     2         0d+0*t119*t120*t27*t30+1.3127055298329054d-1*t108*t109*t2
     3         7*t29+3.446391616107778d-2*t102*t27
            t125 = t73**2
            t126 = 1/t34**2
            t127 = 1.1439791123983827d+0*t104*t52+8.57984334298787d-1*t1
     1         08*t109+t107
            t128 = t76**2
            t129 = 1/t37**2
            t130 = 1.761046976492036d+0*t104*t52+1.320785232369027d+0*t1
     1         08*t109+t107
            t131 = 2.5058979122369923d-2*t38*t50*(-6.203504908994001d-1*
     1         t130*t39*t77*t9+1.2407009817988002d+0*t128*t129*t39*t9+4.
     2         135669939329334d-1*t39*t50*t56*t76*t77+2.7571132928862224
     3         d-1*t111*t39*t50)-5.011795824473985d-2*t35*t50*(-6.203504
     4         908994001d-1*t127*t36*t74*t9+1.2407009817988002d+0*t125*t
     5         126*t36*t9+4.135669939329334d-1*t36*t50*t56*t73*t74+2.757
     6         1132928862224d-1*t111*t36*t50)+2.667310007273315d-3*t37*t
     7         39*t76*t87*t88+7.002785192652656d-4*t38*t52*t53*t88/t42**
     8         3+2.667310007273315d-3*t38*(5.250822119331622d-1*t39*t42*
     9         t52*t53*t76*t77-1.0d+0*t130*t39*t43*t77+1.750274039777207
     :         4d-1*t104*t39*t42*t52+2.0d+0*t128*t129*t39*t43+1.31270552
     ;         98329054d-1*t108*t109*t39*t42+3.446391616107778d-2*t102*t
     <         39)*t87-4.431373767749538d-3*t34*t36*t73*t85*t86-1.163417
     =         7699362593d-3*t35*t52*t53*t86/t40**3-4.431373767749538d-3
     >         *t35*(5.250822119331622d-1*t36*t40*t52*t53*t73*t74-1.0d+0
     ?         *t127*t36*t41*t74+1.7502740397772074d-1*t104*t36*t40*t52+
     @         2.0d+0*t125*t126*t36*t41+1.3127055298329054d-1*t108*t109*
     1         t36*t40+3.446391616107778d-2*t102*t36)*t85-1.269053651675
     2         4763d-1*t104*t52*t82*t84-9.517902387566071d-2*t108*t109*t
     3         82*t84+9.995362477254237d-2*t102*t84/t45**3-1.37220972936
     4         3942d-1*t102/(t45**5*t83**2)+1.6127625339649027d-1*t104*t
     5         52*t79*t81+1.2095719004736769d-1*t108*t109*t79*t81-1.2702
     6         49377985834d-1*t102*t81/t44**3+2.560822746052464d-4*t102/
     7         (t44**5*t80**2)+2.5058979122369923d-2*t37*t39*t50*t76*t78
     8         +8.352993040789976d-3*t113*t38*t50*t78-5.011795824473985d
     9         -2*t34*t36*t50*t73*t75-1.670598608157995d-2*t113*t35*t50*
     :         t75
            t132 = t63**2
            t133 = 1/t18**2
            t134 = 6.178834917961894d-1*t104*t52+4.63412618847142d-1*t10
     1         8*t109+t107
            fnc(iq) = 1.0d+0*rhob*t49*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t99*wght+1.0d+0*t49*wght+Amat(i
     1         q,D1_RB)
            Amat2(iq,D2_RB_RB) = 2.0d+0*t99*wght+1.0d+0*rhob*(-1.1696447
     1         245269286d+0*t24*t72*t89*t98+1.1696447245269286d+0*t48*t7
     2         1*t98+5.848223622634643d-1*t24*t48*(1.0d+0*(3.64903351791
     3         77674d-4*t25*t27*t90*t96*t97+9.580212955032547d-5*t123*t2
     4         6*t52*t53*t97+3.6490335179177674d-4*t124*t26*t96-6.393498
     5         539405557d-3*t104*t52*t93*t95-4.795123904554167d-3*t108*t
     6         109*t93*t95+5.035668532593766d-3*t102*t118*t95+2.72214888
     7         0047894d-2*t25*t27*t50*t90*t92+9.073829600159646d-3*t113*
     8         t26*t50*t92+2.722148880047894d-2*t122*t26*t50+1.709920934
     9         161365d+0*t131-2.255165148260897d-1*t102*t116*t117)-3.649
     :         0335179177674d-4*t25*t27*t90*t96*t97-9.580212955032547d-5
     ;         *t123*t26*t52*t53*t97-3.6490335179177674d-4*t124*t26*t96+
     <         6.393498539405557d-3*t104*t52*t93*t95+4.795123904554167d-
     =         3*t108*t109*t93*t95-5.035668532593766d-3*t102*t118*t95-2.
     >         722148880047894d-2*t25*t27*t50*t90*t92-9.073829600159646d
     ?         -3*t113*t26*t50*t92-2.722148880047894d-2*t122*t26*t50+2.2
     @         55165148260897d-1*t102*t116*t117)+5.848223622634643d-1*t4
     1         7*t48*(2.5058979122369923d-2*t19*t50*(-6.203504908994001d
     2         -1*t134*t20*t64*t9+1.2407009817988002d+0*t132*t133*t20*t9
     3         +4.135669939329334d-1*t20*t50*t56*t63*t64+2.7571132928862
     4         224d-1*t111*t20*t50)-9.690227711544375d-4*t54*t6*t61*t62*
     5         t8-5.011795824473985d-2*t50*t54*t57*t6*t8+2.2478670955426
     6         108d-3*t18*t20*t63*t69*t70+5.901575133296435d-4*t19*t52*t
     7         53*t70/t21**3-2.544083100456872d-4*t114*t52*t53*t62*t7-9.
     8         690227711544375d-4*t115*t61*t7-1.670598608157995d-2*t113*
     9         t50*t57*t7-5.011795824473985d-2*t112*t50*t7+2.24786709554
     :         26108d-3*t19*(5.250822119331622d-1*t20*t21*t52*t53*t63*t6
     ;         4-1.0d+0*t134*t20*t22*t64+1.7502740397772074d-1*t104*t20*
     <         t21*t52+2.0d+0*t132*t133*t20*t22+1.3127055298329054d-1*t1
     =         08*t109*t20*t21+3.446391616107778d-2*t102*t20)*t69-4.3465
     >         070592240396d-2*t104*t52*t66*t68-3.2598802944180294d-2*t1
     ?         08*t109*t66*t68+3.4234103112606934d-2*t102*t68/t23**3-7.6
     @         62163788798045d-1*t102/(t23**5*t67**2)+2.5058979122369923
     1         d-2*t18*t20*t50*t63*t65+8.352993040789976d-3*t113*t19*t50
     2         *t65+4.176057139642926d-2*t104*t52*t58*t60+3.132042854732
     3         1943d-2*t108*t109*t58*t60-3.289159980064472d-2*t102*t103*
     4         t60+1.2448480831567728d+0*t100*t101*t102)+1.1696447245269
     5         286d+0*t24*t47*t89**2/t46**3-1.1696447245269286d+0*t47*t7
     6         1*t72*t89+9.690227711544375d-4*t54*t6*t61*t62*t8+5.011795
     7         824473985d-2*t50*t54*t57*t6*t8-5.848223622634643d-1*t131*
     8         t24*t47*t72+2.544083100456872d-4*t114*t52*t53*t62*t7+9.69
     9         0227711544375d-4*t115*t61*t7+1.670598608157995d-2*t113*t5
     :         0*t57*t7+5.011795824473985d-2*t112*t50*t7-4.1760571396429
     ;         26d-2*t104*t52*t58*t60-3.1320428547321943d-2*t108*t109*t5
     <         8*t60+3.289159980064472d-2*t102*t103*t60-1.24484808315677
     =         28d+0*t100*t101*t102)*wght+Amat2(iq,D2_RB_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_vwn3 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{\sqrt{{\it t_2}}}}\\\\ 
C>   {\it t_4} &=& 1.575246635799487\,{\it t_3}\\\\ 
C>   {\it t_5} &=& \arctan \left({{6.15199081975908}\over{{\it t_4}
C>    +3.72744}}\right)\\\\ 
C>   {\it t_6} &=& 0.7876233178997433\,{\it t_3}\\\\ 
C>   {\it t_7} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_8} &=& 0.6203504908994001\,{\it t_7}\\\\ 
C>   {\it t_9} &=& {{1}\over{\left| 2.935818660072219\,{\it t_3}+{
C>    \it t_8}+12.9352\right| }}\\\\ 
C>   {\it t_{10}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.10498\right)^2\,{\it t_9}\right)\\\\ 
C>   {\it t_{11}} &=& \left| {\it t_7}\right| \\\\ 
C>   {\it t_{12}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_9}\right)\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_3}
C>    +{\it t_8}+18.0578\right| }}\\\\ 
C>   {\it t_{16}} &=& \arctan \left({{6.692072046645942}\over{{
C>    \it t_4}+1.06835}}\right)\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\left| 0.8414573716781907\,{\it t_3}
C>    +{\it t_8}+11.4813\right| }}\\\\ 
C>   {\it t_{18}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.228344\right)^2\,{\it t_{17}}\right)\\\\ 
C>   {\it t_{19}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{17}}\right)\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\left| 10.29581201158544\,{\it t_3}
C>    +{\it t_8}+42.7198\right| }}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{\left| 15.84942278842832\,{\it t_3}
C>    +{\it t_8}+101.578\right| }}\\\\ 
C>   {\it t_{22}} &=& 0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{11}}\,{\it t_{21}}\right)+0.002667310007273315
C>    \,\log \left(1.0\,\left({\it t_6}+0.743294\right)^2\,{
C>    \it t_{21}}\right)-0.0310907\,\log \left(0.6203504908994001
C>    \,{\it t_{11}}\,{\it t_{20}}\right)-0.004431373767749538
C>    \,\log \left(1.0\,\left({\it t_6}+0.409286\right)^2\,{
C>    \it t_{20}}\right)+0.6188180297906176\,\arctan 
C>    \left({{1.171685277708971}\over{{\it t_4}+20.1231}}\right)
C>    -20.52197293770518\,\arctan \left({{0.0448998886415768}
C>    \over{{\it t_4}+13.072}}\right)\\\\ 
C>   {\it t_{23}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\sqrt{{\it t_{23}}}}}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{{\it t_{23}}}}\\\\ 
C>   {\it t_{26}} &=& 0.6203504908994001\,{\it t_{25}}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\left| {\it t_{26}}
C>    +2.935818660072219\,{\it t_{24}}+12.9352\right| }}\\\\ 
C>   {\it t_{28}} &=& \left| {\it t_{25}}\right| \\\\ 
C>   {\it t_{29}} &=& \log \left(0.6203504908994001\,{\it t_{27}}
C>    \,{\it t_{28}}\right)\\\\ 
C>   {\it t_{30}} &=& 0.7876233178997433\,{\it t_{24}}\\\\ 
C>   {\it t_{31}} &=& \log \left(1.0\,{\it t_{27}}\,\left({\it t_{30}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{32}} &=& 1.575246635799487\,{\it t_{24}}\\\\ 
C>   {\it t_{33}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{32}}+3.72744}}\right)\\\\ 
C>   {\it t_{34}} &=& {{1}\over{\left| {\it t_{26}}
C>    +5.560951426165705\,{\it t_{24}}+18.0578\right| }}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\left| {\it t_{26}}
C>    +0.8414573716781907\,{\it t_{24}}+11.4813\right| }}\\\\ 
C>   {\it t_{36}} &=& \log \left(0.6203504908994001\,{\it t_{35}}
C>    \,{\it t_{28}}\right)\\\\ 
C>   {\it t_{37}} &=& \log \left(1.0\,{\it t_{35}}\,\left({\it t_{30}}
C>    +0.228344\right)^2\right)\\\\ 
C>   {\it t_{38}} &=& \arctan \left({{6.692072046645942}\over{{
C>    \it t_{32}}+1.06835}}\right)\\\\ 
C>   {\it t_{39}} &=& {{1}\over{\left| {\it t_{26}}
C>    +10.29581201158544\,{\it t_{24}}+42.7198\right| }}\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\left| {\it t_{26}}
C>    +15.84942278842832\,{\it t_{24}}+101.578\right| }}\\\\ 
C>   {\it t_{41}} &=& 0.6188180297906176\,\arctan 
C>    \left({{1.171685277708971}\over{{\it t_{32}}+20.1231}}\right)
C>    -20.52197293770518\,\arctan \left({{0.0448998886415768}
C>    \over{{\it t_{32}}+13.072}}\right)+0.002667310007273315
C>    \,\log \left(1.0\,{\it t_{40}}\,\left({\it t_{30}}
C>    +0.743294\right)^2\right)-0.004431373767749538\,\log \left(1.0
C>    \,{\it t_{39}}\,\left({\it t_{30}}+0.409286\right)^2\right)
C>    +0.01554535\,\log \left(0.6203504908994001\,{\it t_{40}}\,{
C>    \it t_{28}}\right)-0.0310907\,\log \left(0.6203504908994001
C>    \,{\it t_{39}}\,{\it t_{28}}\right)\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left({{1.125\,\left(\left({\it t_{13}}
C>    \,{\it t_{14}}+1.0\right)^{{{4}\over{3}}}+\left(1.0-{
C>    \it t_{13}}\,{\it t_{14}}\right)^{{{4}\over{3}}}-2.0\right)
C>    \,\left(0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{11}}\,{\it t_{15}}\right)+0.002247867095542611
C>    \,\log \left(1.0\,\left({\it t_6}+0.325\right)^2\,{
C>    \it t_{15}}\right)-0.0310907\,{\it t_{12}}
C>    -9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    +0.05249139316978092\,\arctan \left({{4.730926909560114}
C>    \over{{\it t_4}+7.06042}}\right)-0.03878329487811301\,{
C>    \it t_5}\right)\,\left({{{\it t_{13}}^4\,
C>    \left(1.709920934161365\,{\it t_{22}}+0.01688686394038963\,{
C>    \it t_{19}}+3.649033517917767 \times 10^{-4}\,{\it t_{18}}
C>    +0.005458482358638966\,{\it t_{16}}\right)}\over{{\it t_1}^4}}
C>    -0.01688686394038963\,{\it t_{19}}-3.649033517917767 \times 10^{
C>    -4}\,{\it t_{18}}-0.005458482358638966\,{
C>    \it t_{16}}\right)}\over{{\it t_{22}}}}+0.0310907\,{\it t_{12}}
C>    +9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    +0.03878329487811301\,{\it t_5}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left({{0.5848223622634643\,
C>    \left(0.05249139316978092\,\arctan 
C>    \left({{4.730926909560114}\over{{\it t_{32}}+7.06042}}\right)
C>    -0.03878329487811301\,{\it t_{33}}+0.002247867095542611
C>    \,\log \left(1.0\,{\it t_{34}}\,\left({\it t_{30}}
C>    +0.325\right)^2\right)-9.690227711544375 \times 10^{-4}\,{
C>    \it t_{31}}+0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{34}}\,{\it t_{28}}\right)-0.0310907\,{
C>    \it t_{29}}\right)\,\left(1.0\,\left(1.709920934161365\,{
C>    \it t_{41}}+0.005458482358638966\,{\it t_{38}}
C>    +3.649033517917767 \times 10^{-4}\,{\it t_{37}}
C>    +0.01688686394038963\,{\it t_{36}}\right)-0.005458482358638966
C>    \,{\it t_{38}}-3.649033517917767 \times 10^{-4}\,{\it t_{37}}
C>    -0.01688686394038963\,{\it t_{36}}\right)}\over{{\it t_{41}}}}
C>    +0.03878329487811301\,{\it t_{33}}+9.690227711544375 \times 10^{
C>    -4}\,{\it t_{31}}+0.0310907\,{\it t_{29}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] SH Vosko, L Wilk, M Nusair, Can.J.Phys. 58, 1200 (1980)  , DOI: 
C> <a href="http://dx.doi.org/10.1139/p80-159 "> 
C> 10.1139/p80-159 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_vwn3_d3(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat,Amat2,Amat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
c 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 4.9237251092134837d-1*t4
            t6 = 1/abs(t5+2.615517080950829d+0*t3+1.29352d+1)
            t7 = abs(t4)
            t8 = t5+2.615517080950828d+0*t3+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = log(4.9237251092134837d-1*t10*t7)
            t12 = 7.016926042943222d-1*t3
            t13 = t12+1.0498d-1
            t14 = t13**2
            t15 = log(1.0d+0*t10*t14)
            t16 = 1.4033852085886445d+0*t3
            t17 = t16+3.72744d+0
            t18 = atan(6.15199081975908d+0/t17)
            t19 = 1/t7
            t20 = -8.206208515355806d-2/rhoa**1.3333333333333333d+0
            t21 = 1/t2**3
            t22 = 1/rhoa**6.666666666666667d-1
            t23 = t20-2.1795975674590234d-1*t21*t22
            t24 = 1/t8
            t25 = 1/rhoa**1.6666666666666666d+0
            t26 = -4.9237251092134837d-1*t10*t23*t24*t7-8.20620851535580
     1         6d-2*t10*t19*t25
            t27 = 1/t17**2
            t28 = 3.784699104639999d+1*t27+1
            t29 = 1/t28
            t30 = 1/t14
            t31 = -1.0d+0*t10*t14*t23*t24-1.1694876738238703d-1*t10*t13*
     1         t21*t22
            t32 = 9.690227711544375d-4*t30*t31*t9+6.314467057030004d-2*t
     1         19*t26*t9+2.790332964441521d-2*t21*t22*t27*t29
            t33 = 2.0d+0*t32*wght
            t34 = 1/t28**2
            t35 = 1/t17**5
            t36 = 1/rhoa**2.3333333333333334d+0
            t37 = -2.470091445929572d-1*t34*t35*t36
            t38 = 1/t17**3
            t39 = 6.526520015557556d-3*t29*t36*t38
            t40 = t5+7.496532937978391d-1*t3+1.14813d+1
            t41 = abs(t40)
            t42 = 1/t41
            t43 = t12+2.28344d-1
            t44 = t43**2
            t45 = t16+1.0683499999999999d+0
            t46 = -1.688686394038963d-2*log(4.9237251092134837d-1*t42*t7
     1         )-5.458482358638966d-3*atan(6.692072046645942d+0/t45)-3.6
     2         490335179177674d-4*log(1.0d+0*t42*t44)
            t47 = t5+4.9542444972117183d+0*t3+1.8057800000000002d+1
            t48 = abs(t47)
            t49 = 1/t48
            t50 = t12+3.25d-1
            t51 = t50**2
            t52 = t16+7.06042d+0
            t53 = 1.554535d-2*log(4.9237251092134837d-1*t49*t7)+5.249139
     1         316978092d-2*atan(4.7309269095601136d+0/t52)+2.2478670955
     2         426108d-3*log(1.0d+0*t49*t51)-3.8783294878113006d-2*t18-9
     3         .690227711544375d-4*t15-3.10907d-2*t11
            t54 = t5+9.17252572333538d+0*t3+4.2719799999999997d+1
            t55 = abs(t54)
            t56 = 1/t55
            t57 = t5+1.4120230445475074d+1*t3+1.01578d+2
            t58 = abs(t57)
            t59 = 1/t58
            t60 = t12+4.09286d-1
            t61 = t60**2
            t62 = t12+7.43294d-1
            t63 = t62**2
            t64 = t16+1.3072d+1
            t65 = t16+2.0123100000000002d+1
            t66 = 1.554535d-2*log(4.9237251092134837d-1*t59*t7)-3.10907d
     1         -2*log(4.9237251092134837d-1*t56*t7)+6.188180297906176d-1
     2         *atan(1.171685277708971d+0/t65)-2.052197293770518d+1*atan
     3         (4.4899888641576796d-2/t64)+2.667310007273315d-3*log(1.0d
     4         +0*t59*t63)-4.431373767749538d-3*log(1.0d+0*t56*t61)
            t67 = 1/t66
            t68 = 1/rhoa**2
            t69 = 1/rhoa**1.6666666666666669d+0
            t70 = -9.301109881471736d-3*t21*t27*t29*t69
            t71 = t23**2
            t72 = 1/t8**2
            t73 = 1/t2**5
            t74 = 1/rhoa**1.3333333333333336d+0
            t75 = 5.448993918647558d-2*t73*t74+7.265325224863413d-2*t21*
     1         t69+5.470805676903872d-2/rhoa**2.333333333333333d+0
            t76 = 1/rhoa**2.6666666666666666d+0
            t77 = 5.470805676903869d-2*t10*t19*t76-4.9237251092134837d-1
     1         *t10*t24*t7*t75+9.847450218426967d-1*t10*t7*t71*t72+1.641
     2         2417030711612d-1*t10*t19*t23*t24*t25
            t78 = 6.314467057030004d-2*t19*t77*t9
            t79 = -6.975832411103801d-3*t27*t29*t73*t74
            t80 = 1/rhoa**9.999999999999999d-1
            t81 = 1.0524111761716676d-2*t19*t26*t80*t9
            t82 = 1/t13**3
            t83 = 1.1332601865197636d-4*t21*t22*t31*t82*t9
            t84 = -1.0d+0*t10*t14*t24*t75+2.923719184559675d-2*t10*t13*t
     1         73*t74+2.0d+0*t10*t14*t71*t72+3.898292246079568d-2*t10*t1
     2         3*t21*t69+6.838507096129838d-3*t10*t36+2.3389753476477407
     3         d-1*t10*t13*t21*t22*t23*t24
            t85 = 9.690227711544375d-4*t30*t84*t9
            t86 = 6.314467057030004d-2*t10*t19*t23*t26*t8
            t87 = 9.690227711544375d-4*t10*t23*t30*t31*t8
            t88 = t87+t86+t85+t83+t81+t79+t78+t70+2.5000000000000006d-1*
     1         t46*t53*t67*t68+t39+t37
            t89 = t87+t86+t85+t83+t81+t79+t78+t70-2.5000000000000006d-1*
     1         t46*t53*t67*t68+t39+t37
            t90 = 1/rhoa**3.3333333333333337d+0
            t91 = 4.3226600303767515d-1*t34*t35*t90
            t92 = -1.1421410027225727d-2*t29*t38*t90
            t93 = 1/rhoa**3
            t94 = 1/rhoa**3.0d+0
            t95 = 4.3732069462725337d+0*t21*t94/(t17**8*t28**3)
            t96 = -2.022119049462691d-1*t21*t34*t94/t17**6
            t97 = 2.289805413347801d-3*t21*t29*t94/t17**4
            t98 = 1/rhoa**2.666666666666667d+0
            t99 = 7.750924901226445d-3*t21*t27*t29*t98
            t100 = 6.975832411103802d-3*t27*t29*t36*t73
            t101 = 1.988000729055306d-5*t31*t36*t9/t13**4
            t102 = t20-6.247110781648659d-2*t21*t22
            t103 = 1/t40
            t104 = 1/t45**2
            t105 = -3.429692674920095d-2*t19*t41*(-4.9237251092134837d-1
     1         *t102*t103*t42*t7-8.206208515355806d-2*t19*t25*t42)-3.649
     2         0335179177674d-4*t41*(-1.0d+0*t102*t103*t42*t44-1.1694876
     3         738238703d-1*t21*t22*t42*t43)/t44-4.2719697398914064d-3*t
     4         104*t21*t22/(4.4783828277500004d+1*t104+1)
            t106 = t20-4.128537081009765d-1*t21*t22
            t107 = 1/t47
            t108 = 1/t52**2
            t109 = -9.690227711544375d-4*t30*t31*t9-6.314467057030004d-2
     1         *t19*t26*t9+3.157233528515002d-2*t19*t48*(-4.923725109213
     2         4837d-1*t106*t107*t49*t7-8.206208515355806d-2*t19*t25*t49
     3         )+2.2478670955426108d-3*t48*(-1.0d+0*t106*t107*t49*t51-1.
     4         1694876738238703d-1*t21*t22*t49*t50)/t51-2.79033296444152
     5         1d-2*t21*t22*t27*t29+2.904223175587974d-2*t108*t21*t22/(2
     6         .238166942360001d+1*t108+1)
            t110 = 1/t66**2
            t111 = t20-7.643771436112816d-1*t21*t22
            t112 = 1/t54
            t113 = t20-1.1766858704562562d+0*t21*t22
            t114 = 1/t57
            t115 = 1/t64**2
            t116 = 1/t65**2
            t117 = 3.157233528515002d-2*t19*t58*(-4.9237251092134837d-1*
     1         t113*t114*t59*t7-8.206208515355806d-2*t19*t25*t59)-6.3144
     2         67057030004d-2*t19*t55*(-4.9237251092134837d-1*t111*t112*
     3         t56*t7-8.206208515355806d-2*t19*t25*t56)+2.66731000727331
     4         5d-3*t58*(-1.0d+0*t113*t114*t59*t63-1.1694876738238703d-1
     5         *t21*t22*t59*t62)/t63-4.431373767749538d-3*t55*(-1.0d+0*t
     6         111*t112*t56*t61-1.1694876738238703d-1*t21*t22*t56*t60)/t
     7         61+8.479487036467487d-2*t116*t21*t22/(1.3728463899999485d
     8         +0*t116+1)-1.0776060556305726d-1*t115*t21*t22/(2.01600000
     9         0025997d-3*t115+1)
            t118 = 1/t2**7
            t119 = 1/rhoa**2.0d+0
            t120 = 2.906596837959916d-3*t118*t119*t27*t29
            t121 = -5.262055880858336d-3*t119*t19*t26*t9
            t122 = 1.7540186269527788d-3*t19*t26*t9/rhoa**1.999999999999
     1         9998d+0
            t123 = -3.7775339550658793d-5*t21*t31*t69*t82*t9
            t124 = t23**3
            t125 = 1/t8**3
            t126 = -6.054437687386176d-2*t21*t98-5.448993918647558d-2*t3
     1         6*t73-2.2704141327698155d-2*t118*t119-6.382606623054516d-
     2         2/rhoa**3.333333333333333d+0
            t127 = 6.314467057030004d-2*t19*(-1.6412417030711612d-1*t10*
     1         t19*t23*t24*t76+2.95423506552809d+0*t10*t23*t7*t72*t75+2.
     2         4618625546067416d-1*t10*t19*t24*t25*t75-4.923725109213483
     3         d-1*t10*t19*t25*t71*t72-4.9237251092134837d-1*t10*t126*t2
     4         4*t7-2.95423506552809d+0*t10*t124*t125*t7-6.3826066230545
     5         15d-2*t10*t19/rhoa**3.6666666666666664d+0)*t9
            t128 = -2.833150466299409d-5*t31*t73*t74*t82*t9
            t129 = 2.1048223523433351d-2*t19*t77*t80*t9
            t130 = 2.1048223523433351d-2*t10*t19*t23*t26*t8*t80
            t131 = 2.2665203730395272d-4*t21*t22*t82*t84*t9
            t132 = 2.2665203730395272d-4*t10*t21*t22*t23*t31*t8*t82
            t133 = 9.690227711544375d-4*t30*t9*(-3.2485768717329727d-2*t
     1         10*t13*t21*t98-1.1967387418227218d-2*t10*t90+6.0d+0*t10*t
     2         14*t23*t72*t75+3.508463021471611d-1*t10*t13*t21*t22*t24*t
     3         75-8.771157553679026d-2*t10*t13*t23*t24*t73*t74-2.9237191
     4         84559675d-2*t10*t13*t36*t73-7.016926042943222d-1*t10*t13*
     5         t21*t22*t71*t72-1.1694876738238703d-1*t10*t13*t21*t23*t24
     6         *t69-2.0515521288389513d-2*t10*t23*t24*t36-1.0d+0*t10*t12
     7         6*t14*t24-6.0d+0*t10*t124*t125*t14-1.2182163268998646d-2*
     8         t10*t118*t119*t13)
            t134 = 6.314467057030004d-2*t10*t19*t26*t75*t8
            t135 = 1.262893411406001d-1*t10*t19*t23*t77*t8
            t136 = 1.938045542308875d-3*t10*t23*t30*t8*t84
            t137 = 9.690227711544375d-4*t10*t30*t31*t75*t8
            fnc(iq) = 2.0d+0*rhoa*(3.10907d-2*log(4.9237251092134837d-1*
     1         t6*t7)+9.690227711544375d-4*log(1.0d+0*(7.016926042943223
     2         d-1*t3+1.0498d-1)**2*t6)+3.8783294878113006d-2*atan(6.151
     3         99081975908d+0/(1.4033852085886447d+0*t3+3.72744d+0)))*wg
     4         ht+fnc(iq)
            Amat(iq,D1_RA) = 2.0d+0*rhoa*t32*wght+1.0d+0*(3.878329487811
     1         3006d-2*t18+9.690227711544375d-4*t15+3.10907d-2*t11)*wght
     2         +Amat(iq,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*t88*wght+t33+Amat2(iq,D2_RA
     1         _RA)
            Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*t89*wght+t33+Amat2(iq,D2_RA
     1         _RB)
            Amat3(iq,D3_RA_RA_RA) = 2.0d+0*rhoa*(t99+t97+t96+t95-7.5d-1*
     1         t46*t53*t67*t93+t92+t91+7.500000000000001d-1*t105*t53*t67
     2         *t68+7.500000000000001d-1*t109*t46*t67*t68-7.500000000000
     3         001d-1*t110*t117*t46*t53*t68+t137+t136+t135+t134+t133+t13
     4         2+t131+t130+t129+t128+t127+t123+t122+t121+t120+t101+t100)
     5         *wght+3.0d+0*t88*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 2.0d+0*rhoa*(t99+t97+t96+t95+2.50000
     1         00000000006d-1*t46*t53*t67*t93+t92+t91-2.5000000000000006
     2         d-1*t105*t53*t67*t68-2.5000000000000006d-1*t109*t46*t67*t
     3         68+2.5000000000000006d-1*t110*t117*t46*t53*t68+t137+t136+
     4         t135+t134+t133+t132+t131+t130+t129+t128+t127+t123+t122+t1
     5         21+t120+t101+t100)*wght+2.0d+0*t89*wght+1.0d+0*t88*wght+A
     6         mat3(iq,D3_RA_RA_RB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = t2**5.0d-1
            t4 = 1/t3
            t5 = 1.5752466357994865d+0*t4
            t6 = t5+3.72744d+0
            t7 = atan(6.15199081975908d+0/t6)
            t8 = 7.876233178997433d-1*t4
            t9 = t8+1.0498d-1
            t10 = t9**2
            t11 = 1/t2
            t12 = 6.203504908994001d-1*t11
            t13 = 2.935818660072219d+0*t4+t12+1.29352d+1
            t14 = abs(t13)
            t15 = 1/t14
            t16 = log(1.0d+0*t10*t15)
            t17 = abs(t11)
            t18 = log(6.203504908994001d-1*t15*t17)
            t19 = rhoa-rhob
            t20 = 1/t1
            t21 = 1.0d+0-t19*t20
            t22 = t19*t20+1.0d+0
            t23 = t22**1.3333333333333333d+0+t21**1.3333333333333333d+0-
     1         2.0d+0
            t24 = t5+7.06042d+0
            t25 = t8+3.25d-1
            t26 = t25**2
            t27 = 5.560951426165704d+0*t4+t12+1.8057800000000002d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = -3.8783294878113006d-2*t7+2.2478670955426108d-3*log(1.
     1         0d+0*t26*t29)+1.554535d-2*log(6.203504908994001d-1*t17*t2
     2         9)+5.249139316978092d-2*atan(4.7309269095601136d+0/t24)-3
     3         .10907d-2*t18-9.690227711544375d-4*t16
            t31 = t5+1.0683499999999999d+0
            t32 = atan(6.692072046645942d+0/t31)
            t33 = t8+2.28344d-1
            t34 = t33**2
            t35 = 8.414573716781907d-1*t4+t12+1.14813d+1
            t36 = abs(t35)
            t37 = 1/t36
            t38 = log(1.0d+0*t34*t37)
            t39 = log(6.203504908994001d-1*t17*t37)
            t40 = t19**4
            t41 = 1/t1**4
            t42 = t5+1.3072d+1
            t43 = t5+2.0123100000000002d+1
            t44 = t8+4.09286d-1
            t45 = t44**2
            t46 = 1.0295812011585444d+1*t4+t12+4.2719799999999997d+1
            t47 = abs(t46)
            t48 = 1/t47
            t49 = t8+7.43294d-1
            t50 = t49**2
            t51 = 1.5849422788428325d+1*t4+t12+1.01578d+2
            t52 = abs(t51)
            t53 = 1/t52
            t54 = 2.667310007273315d-3*log(1.0d+0*t50*t53)+1.554535d-2*l
     1         og(6.203504908994001d-1*t17*t53)-4.431373767749538d-3*log
     2         (1.0d+0*t45*t48)-3.10907d-2*log(6.203504908994001d-1*t17*
     3         t48)+6.188180297906176d-1*atan(1.171685277708971d+0/t43)-
     4         2.052197293770518d+1*atan(4.4899888641576796d-2/t42)
            t55 = 1.709920934161365d+0*t54+1.688686394038963d-2*t39+3.64
     1         90335179177674d-4*t38+5.458482358638966d-3*t32
            t56 = t40*t41*t55-1.688686394038963d-2*t39-3.649033517917767
     1         4d-4*t38-5.458482358638966d-3*t32
            t57 = 1/t54
            t58 = 3.8783294878113006d-2*t7+1.1250000000000002d+0*t23*t30
     1         *t56*t57+3.10907d-2*t18+9.690227711544375d-4*t16
            t59 = 1/t1**6.666666666666667d-1
            t60 = 1/t3**3
            t61 = 1/t6**2
            t62 = 3.784699104639999d+1*t61+1
            t63 = 1/t62
            t64 = 6.264085709464389d-2*t59*t60*t61*t63
            t65 = 1/t10
            t66 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t67 = t66-4.8930311001203647d-1*t59*t60
            t68 = 1/t13
            t69 = -2.625411059665811d-1*t15*t59*t60*t9-1.0d+0*t10*t15*t6
     1         7*t68
            t70 = 9.690227711544375d-4*t14*t65*t69
            t71 = 1/t17
            t72 = 1/t1**1.6666666666666666d+0
            t73 = -2.067834969664667d-1*t15*t71*t72-6.203504908994001d-1
     1         *t15*t17*t67*t68
            t74 = 5.011795824473985d-2*t14*t71*t73
            t75 = 1/t42**2
            t76 = 2.016000000025997d-3*t75+1
            t77 = 1/t76
            t78 = 1/t43**2
            t79 = 1.3728463899999485d+0*t78+1
            t80 = 1/t79
            t81 = 1/t45
            t82 = t66-1.715968668597574d+0*t59*t60
            t83 = 1/t46
            t84 = -1.0d+0*t45*t48*t82*t83-2.625411059665811d-1*t44*t48*t
     1         59*t60
            t85 = -6.203504908994001d-1*t17*t48*t82*t83-2.06783496966466
     1         7d-1*t48*t71*t72
            t86 = 1/t50
            t87 = t66-2.641570464738054d+0*t59*t60
            t88 = 1/t51
            t89 = -1.0d+0*t50*t53*t87*t88-2.625411059665811d-1*t49*t53*t
     1         59*t60
            t90 = -6.203504908994001d-1*t17*t53*t87*t88-2.06783496966466
     1         7d-1*t53*t71*t72
            t91 = 2.5058979122369923d-2*t52*t71*t90+2.667310007273315d-3
     1         *t52*t86*t89-5.011795824473985d-2*t47*t71*t85-4.431373767
     2         749538d-3*t47*t81*t84+1.9035804775132142d-1*t59*t60*t78*t
     3         80-2.4191438009473537d-1*t59*t60*t75*t77
            t92 = 1/t54**2
            t93 = -1.1250000000000002d+0*t23*t30*t56*t91*t92
            t94 = 1/t31**2
            t95 = 4.4783828277500004d+1*t94+1
            t96 = 1/t95
            t97 = -9.590247809108334d-3*t59*t60*t94*t96
            t98 = 1/t34
            t99 = t66-1.4024289527969844d-1*t59*t60
            t100 = 1/t35
            t101 = -1.0d+0*t100*t34*t37*t99-2.625411059665811d-1*t33*t37
     1         *t59*t60
            t102 = -3.6490335179177674d-4*t101*t36*t98
            t103 = -6.203504908994001d-1*t100*t17*t37*t99-2.067834969664
     1         667d-1*t37*t71*t72
            t104 = -2.722148880047894d-2*t103*t36*t71
            t105 = 3.6490335179177674d-4*t101*t36*t98+9.590247809108334d
     1         -3*t59*t60*t94*t96+1.709920934161365d+0*t91+2.72214888004
     2         7894d-2*t103*t36*t71
            t106 = t105*t40*t41
            t107 = 1/t1**5
            t108 = -4*t107*t40*t55
            t109 = t19**3
            t110 = t97+4*t109*t41*t55+t108+t106+t104+t102
            t111 = 1/t24**2
            t112 = 2.238166942360001d+1*t111+1
            t113 = 1/t112
            t114 = 1/t26
            t115 = t66-9.26825237694284d-1*t59*t60
            t116 = 1/t27
            t117 = -2.625411059665811d-1*t25*t29*t59*t60-1.0d+0*t115*t11
     1         6*t26*t29
            t118 = -2.067834969664667d-1*t29*t71*t72-6.203504908994001d-
     1         1*t115*t116*t17*t29
            t119 = -5.011795824473985d-2*t14*t71*t73+2.5058979122369923d
     1         -2*t118*t28*t71-9.690227711544375d-4*t14*t65*t69-6.264085
     2         709464389d-2*t59*t60*t61*t63+6.519760588836059d-2*t111*t1
     3         13*t59*t60+2.2478670955426108d-3*t114*t117*t28
            t120 = 1.1250000000000002d+0*t119*t23*t56*t57
            t121 = 1/t1**2
            t122 = t121*t19
            t123 = -t20
            t124 = t123+t122
            t125 = t21**3.333333333333333d-1
            t126 = -t121*t19
            t127 = t20+t126
            t128 = t22**3.333333333333333d-1
            t129 = 1.3333333333333333d+0*t127*t128+1.3333333333333333d+0
     1         *t124*t125
            t130 = t93+t74+t70+t64+1.1250000000000002d+0*t129*t30*t56*t5
     1         7+1.1250000000000002d+0*t110*t23*t30*t57+t120
            t131 = 1.0d+0*t58*wght
            t132 = t97-4*t109*t41*t55+t108+t106+t104+t102
            t133 = t20+t122
            t134 = t126+t123
            t135 = 1.3333333333333333d+0*t128*t134+1.3333333333333333d+0
     1         *t125*t133
            t136 = t93+t74+t70+t64+1.1250000000000002d+0*t135*t30*t56*t5
     1         7+1.1250000000000002d+0*t132*t23*t30*t57+t120
            t137 = 1/t1**2.3333333333333334d+0
            t138 = 1/t6**5
            t139 = 1/t62**2
            t140 = -1.2448480831567728d+0*t137*t138*t139
            t141 = 1/t6**3
            t142 = 3.289159980064472d-2*t137*t141*t63
            t143 = 1/t1**1.3333333333333336d+0
            t144 = 1/t3**5
            t145 = -3.1320428547321943d-2*t143*t144*t61*t63
            t146 = 1/t1**1.6666666666666669d+0
            t147 = -4.176057139642926d-2*t146*t60*t61*t63
            t148 = 9.690227711544375d-4*t13*t15*t65*t67*t69
            t149 = 5.011795824473985d-2*t13*t15*t67*t71*t73
            t150 = t67**2
            t151 = 1/t13**2
            t152 = 2.7571132928862224d-1/t1**2.333333333333333d+0
            t153 = 3.262020733413577d-1*t146*t60+t152+2.4465155500601823
     1         d-1*t143*t144
            t154 = 5.250822119331622d-1*t15*t59*t60*t67*t68*t9+1.7502740
     1         397772074d-1*t146*t15*t60*t9+1.3127055298329054d-1*t143*t
     2         144*t15*t9-1.0d+0*t10*t15*t153*t68+2.0d+0*t10*t15*t150*t1
     3         51+3.446391616107778d-2*t137*t15
            t155 = 9.690227711544375d-4*t14*t154*t65
            t156 = 1/t9**3
            t157 = 2.544083100456872d-4*t14*t156*t59*t60*t69
            t158 = 1/t1**2.6666666666666666d+0
            t159 = 4.135669939329334d-1*t15*t67*t68*t71*t72+2.7571132928
     1         862224d-1*t15*t158*t71-6.203504908994001d-1*t15*t153*t17*
     2         t68+1.2407009817988002d+0*t15*t150*t151*t17
            t160 = 5.011795824473985d-2*t14*t159*t71
            t161 = 1/t1**9.999999999999999d-1
            t162 = 1.670598608157995d-2*t14*t161*t71*t73
            t163 = t91**2
            t164 = 1/t54**3
            t165 = 2.2500000000000003d+0*t163*t164*t23*t30*t56
            t166 = -2.2500000000000003d+0*t119*t23*t56*t91*t92
            t167 = 1/t42**5
            t168 = 1/t76**2
            t169 = 1/t42**3
            t170 = 1/t43**5
            t171 = 1/t79**2
            t172 = 1/t43**3
            t173 = t82**2
            t174 = 1/t46**2
            t175 = 1.1439791123983827d+0*t146*t60+t152+8.57984334298787d
     1         -1*t143*t144
            t176 = 5.250822119331622d-1*t44*t48*t59*t60*t82*t83-1.0d+0*t
     1         175*t45*t48*t83+1.7502740397772074d-1*t146*t44*t48*t60+2.
     2         0d+0*t173*t174*t45*t48+1.3127055298329054d-1*t143*t144*t4
     3         4*t48+3.446391616107778d-2*t137*t48
            t177 = 1/t44**3
            t178 = 4.135669939329334d-1*t48*t71*t72*t82*t83-6.2035049089
     1         94001d-1*t17*t175*t48*t83+2.7571132928862224d-1*t158*t48*
     2         t71+1.2407009817988002d+0*t17*t173*t174*t48
            t179 = t87**2
            t180 = 1/t51**2
            t181 = 1.761046976492036d+0*t146*t60+t152+1.320785232369027d
     1         +0*t143*t144
            t182 = 5.250822119331622d-1*t49*t53*t59*t60*t87*t88-1.0d+0*t
     1         181*t50*t53*t88+1.7502740397772074d-1*t146*t49*t53*t60+2.
     2         0d+0*t179*t180*t50*t53+1.3127055298329054d-1*t143*t144*t4
     3         9*t53+3.446391616107778d-2*t137*t53
            t183 = 1/t49**3
            t184 = 4.135669939329334d-1*t53*t71*t72*t87*t88-6.2035049089
     1         94001d-1*t17*t181*t53*t88+2.7571132928862224d-1*t158*t53*
     2         t71+1.2407009817988002d+0*t17*t179*t180*t53
            t185 = 2.5058979122369923d-2*t51*t53*t71*t87*t90+8.352993040
     1         789976d-3*t161*t52*t71*t90+2.667310007273315d-3*t51*t53*t
     2         86*t87*t89+7.002785192652656d-4*t183*t52*t59*t60*t89+2.66
     3         7310007273315d-3*t182*t52*t86-5.011795824473985d-2*t46*t4
     4         8*t71*t82*t85-1.670598608157995d-2*t161*t47*t71*t85-4.431
     5         373767749538d-3*t46*t48*t81*t82*t84-1.1634177699362593d-3
     6         *t177*t47*t59*t60*t84-4.431373767749538d-3*t176*t47*t81-1
     7         .2690536516754763d-1*t146*t60*t78*t80-9.517902387566071d-
     8         2*t143*t144*t78*t80+9.995362477254237d-2*t137*t172*t80+1.
     9         6127625339649027d-1*t146*t60*t75*t77+1.2095719004736769d-
     :         1*t143*t144*t75*t77-1.270249377985834d-1*t137*t169*t77+2.
     ;         5058979122369923d-2*t184*t52*t71-5.011795824473985d-2*t17
     <         8*t47*t71-1.372209729363942d-1*t137*t170*t171+2.560822746
     =         052464d-4*t137*t167*t168
            t186 = -1.1250000000000002d+0*t185*t23*t30*t56*t92
            t187 = 1/t31**5
            t188 = 1/t95**2
            t189 = 2.255165148260897d-1*t137*t187*t188
            t190 = 1/t31**3
            t191 = -5.035668532593766d-3*t137*t190*t96
            t192 = 4.795123904554167d-3*t143*t144*t94*t96
            t193 = 6.393498539405557d-3*t146*t60*t94*t96
            t194 = -3.6490335179177674d-4*t101*t35*t37*t98*t99
            t195 = -2.722148880047894d-2*t103*t35*t37*t71*t99
            t196 = t99**2
            t197 = 1/t35**2
            t198 = 9.349526351979897d-2*t146*t60+t152+7.012144763984922d
     1         -2*t143*t144
            t199 = 5.250822119331622d-1*t100*t33*t37*t59*t60*t99+1.75027
     1         40397772074d-1*t146*t33*t37*t60-1.0d+0*t100*t198*t34*t37+
     2         2.0d+0*t196*t197*t34*t37+1.3127055298329054d-1*t143*t144*
     3         t33*t37+3.446391616107778d-2*t137*t37
            t200 = -3.6490335179177674d-4*t199*t36*t98
            t201 = 1/t33**3
            t202 = -9.580212955032547d-5*t101*t201*t36*t59*t60
            t203 = 4.135669939329334d-1*t100*t37*t71*t72*t99+2.757113292
     1         8862224d-1*t158*t37*t71-6.203504908994001d-1*t100*t17*t19
     2         8*t37+1.2407009817988002d+0*t17*t196*t197*t37
            t204 = -2.722148880047894d-2*t203*t36*t71
            t205 = -9.073829600159646d-3*t103*t161*t36*t71
            t206 = -8*t105*t107*t40
            t207 = 3.6490335179177674d-4*t101*t35*t37*t98*t99+2.72214888
     1         0047894d-2*t103*t35*t37*t71*t99+3.6490335179177674d-4*t19
     2         9*t36*t98-6.393498539405557d-3*t146*t60*t94*t96-4.7951239
     3         04554167d-3*t143*t144*t94*t96+5.035668532593766d-3*t137*t
     4         190*t96+2.722148880047894d-2*t203*t36*t71+9.0738296001596
     5         46d-3*t103*t161*t36*t71+9.580212955032547d-5*t101*t201*t3
     6         6*t59*t60-2.255165148260897d-1*t137*t187*t188+1.709920934
     7         161365d+0*t185
            t208 = t207*t40*t41
            t209 = 1/t1**6
            t210 = 20*t209*t40*t55
            t211 = t19**2
            t212 = 12*t211*t41*t55
            t213 = -32*t107*t109*t55+8*t105*t109*t41+t212+t210+t208+t206
     1         +t205+t204+t202+t200+t195+t194+t193+t192+t191+t189
            t214 = 1/t24**5
            t215 = 1/t112**2
            t216 = 1/t24**3
            t217 = t115**2
            t218 = 1/t27**2
            t219 = 6.178834917961894d-1*t146*t60+t152+4.63412618847142d-
     1         1*t143*t144
            t220 = 5.250822119331622d-1*t115*t116*t25*t29*t59*t60+1.7502
     1         740397772074d-1*t146*t25*t29*t60-1.0d+0*t116*t219*t26*t29
     2         +2.0d+0*t217*t218*t26*t29+1.3127055298329054d-1*t143*t144
     3         *t25*t29+3.446391616107778d-2*t137*t29
            t221 = 1/t25**3
            t222 = 4.135669939329334d-1*t115*t116*t29*t71*t72+2.75711329
     1         28862224d-1*t158*t29*t71-6.203504908994001d-1*t116*t17*t2
     2         19*t29+1.2407009817988002d+0*t17*t217*t218*t29
            t223 = -5.011795824473985d-2*t13*t15*t67*t71*t73-1.670598608
     1         157995d-2*t14*t161*t71*t73+2.5058979122369923d-2*t115*t11
     2         8*t27*t29*t71+2.5058979122369923d-2*t222*t28*t71+8.352993
     3         040789976d-3*t118*t161*t28*t71-5.011795824473985d-2*t14*t
     4         159*t71-9.690227711544375d-4*t13*t15*t65*t67*t69-2.544083
     5         100456872d-4*t14*t156*t59*t60*t69-9.690227711544375d-4*t1
     6         4*t154*t65+4.176057139642926d-2*t146*t60*t61*t63+3.132042
     7         8547321943d-2*t143*t144*t61*t63-3.289159980064472d-2*t137
     8         *t141*t63+5.901575133296435d-4*t117*t221*t28*t59*t60-4.34
     9         65070592240396d-2*t111*t113*t146*t60+2.2478670955426108d-
     :         3*t114*t115*t117*t27*t29+2.2478670955426108d-3*t114*t220*
     ;         t28+3.4234103112606934d-2*t113*t137*t216-7.66216378879804
     <         5d-1*t137*t214*t215-3.2598802944180294d-2*t111*t113*t143*
     =         t144+1.2448480831567728d+0*t137*t138*t139
            t224 = 1.1250000000000002d+0*t223*t23*t56*t57
            t225 = t124**2
            t226 = 1/t21**6.666666666666666d-1
            t227 = 1/t1**3
            t228 = -2*t19*t227
            t229 = 2*t121
            t230 = t229+t228
            t231 = t127**2
            t232 = 1/t22**6.666666666666666d-1
            t233 = 2*t19*t227
            t234 = -2*t121
            t235 = t234+t233
            t236 = 1.3333333333333333d+0*t128*t235+4.444444444444444d-1*
     1         t231*t232+1.3333333333333333d+0*t125*t230+4.4444444444444
     2         44d-1*t225*t226
            t237 = -2.2500000000000003d+0*t129*t30*t56*t91*t92-2.2500000
     1         000000003d+0*t110*t23*t30*t91*t92+1.1250000000000002d+0*t
     2         236*t30*t56*t57+2.2500000000000003d+0*t119*t129*t56*t57+1
     3         .1250000000000002d+0*t213*t23*t30*t57+2.2500000000000003d
     4         +0*t110*t129*t30*t57+2.2500000000000003d+0*t110*t119*t23*
     5         t57+t224+t186+t166+t165+t162+t160+t157+t155+t149+t148+t14
     6         7+t145+t142+t140
            t238 = -12*t211*t41*t55+t210+t208+t206+t205+t204+t202+t200+t
     1         195+t194+t193+t192+t191+t189
            t239 = 4.444444444444444d-1*t127*t134*t232+2.666666666666666
     1         6d+0*t128*t19*t227-2.6666666666666666d+0*t125*t19*t227+4.
     2         444444444444444d-1*t124*t133*t226
            t240 = -1.1250000000000002d+0*t135*t30*t56*t91*t92-1.1250000
     1         000000002d+0*t129*t30*t56*t91*t92-1.1250000000000002d+0*t
     2         132*t23*t30*t91*t92-1.1250000000000002d+0*t110*t23*t30*t9
     3         1*t92+1.1250000000000002d+0*t239*t30*t56*t57+1.1250000000
     4         000002d+0*t119*t135*t56*t57+1.1250000000000002d+0*t119*t1
     5         29*t56*t57+1.1250000000000002d+0*t23*t238*t30*t57+1.12500
     6         00000000002d+0*t110*t135*t30*t57+1.1250000000000002d+0*t1
     7         29*t132*t30*t57+1.1250000000000002d+0*t119*t132*t23*t57+1
     8         .1250000000000002d+0*t110*t119*t23*t57+t224+t186+t166+t16
     9         5+t162+t160+t157+t155+t149+t148+t147+t145+t142+t140
            t241 = 32*t107*t109*t55-8*t105*t109*t41+t212+t210+t208+t206+
     1         t205+t204+t202+t200+t195+t194+t193+t192+t191+t189
            t242 = t133**2
            t243 = t234+t228
            t244 = t134**2
            t245 = t233+t229
            t246 = 1.3333333333333333d+0*t128*t245+4.444444444444444d-1*
     1         t232*t244+1.3333333333333333d+0*t125*t243+4.4444444444444
     2         44d-1*t226*t242
            t247 = -2.2500000000000003d+0*t135*t30*t56*t91*t92-2.2500000
     1         000000003d+0*t132*t23*t30*t91*t92+1.1250000000000002d+0*t
     2         246*t30*t56*t57+2.2500000000000003d+0*t119*t135*t56*t57+1
     3         .1250000000000002d+0*t23*t241*t30*t57+2.2500000000000003d
     4         +0*t132*t135*t30*t57+2.2500000000000003d+0*t119*t132*t23*
     5         t57+t224+t186+t166+t165+t162+t160+t157+t155+t149+t148+t14
     6         7+t145+t142+t140
            t248 = 1/t1**3.0d+0
            t249 = 1/t6**8
            t250 = 1/t62**3
            t251 = 4.947718859586276d+1*t248*t249*t250*t60
            t252 = 1/t6**6
            t253 = -2.2877665475865033d+0*t139*t248*t252*t60
            t254 = 1/t1**3.3333333333333337d+0
            t255 = 4.3569682910487045d+0*t138*t139*t254
            t256 = 1/t6**4
            t257 = 2.590619096601433d-2*t248*t256*t60*t63
            t258 = -1.1512059930225654d-1*t141*t254*t63
            t259 = 1/t1**2.0d+0
            t260 = 1/t3**7
            t261 = 2.610035712276828d-2*t259*t260*t61*t63
            t262 = 6.26408570946439d-2*t137*t144*t61*t63
            t263 = 1/t1**2.666666666666667d+0
            t264 = 6.96009523273821d-2*t263*t60*t61*t63
            t265 = 1.938045542308875d-3*t13*t15*t154*t65*t67
            t266 = 5.088166200913744d-4*t13*t15*t156*t59*t60*t67*t69
            t267 = 9.690227711544375d-4*t13*t15*t153*t65*t69
            t268 = 1.002359164894797d-1*t13*t15*t159*t67*t71
            t269 = 5.011795824473985d-2*t13*t15*t153*t71*t73
            t270 = 3.34119721631599d-2*t13*t15*t161*t67*t71*t73
            t271 = t67**3
            t272 = 1/t13**3
            t273 = -6.433264350067851d-1/t1**3.333333333333333d+0
            t274 = -5.436701222355962d-1*t263*t60+t273-2.038762958383485
     1         1d-1*t259*t260-4.893031100120365d-1*t137*t144
            t275 = -5.250822119331622d-1*t146*t15*t60*t67*t68*t9-3.93811
     1         65894987163d-1*t143*t144*t15*t67*t68*t9+7.876233178997433
     2         d-1*t15*t153*t59*t60*t68*t9-1.5752466357994865d+0*t15*t15
     3         0*t151*t59*t60*t9-2.917123399628679d-1*t15*t263*t60*t9-1.
     4         0939212748607545d-1*t15*t259*t260*t9-2.625411059665811d-1
     5         *t137*t144*t15*t9-1.0339174848323335d-1*t137*t15*t67*t68-
     6         1.0d+0*t10*t15*t274*t68+6.0d+0*t10*t15*t151*t153*t67-6.0d
     7         +0*t10*t15*t271*t272-1.2062370656377225d-1*t15*t254
            t276 = 9.690227711544375d-4*t14*t275*t65
            t277 = 5.088166200913744d-4*t14*t154*t156*t59*t60
            t278 = 1/t9**4
            t279 = 1.0018895862972538d-4*t137*t14*t278*t69
            t280 = -1.272041550228436d-4*t14*t143*t144*t156*t69
            t281 = -1.696055400304582d-4*t14*t146*t156*t60*t69
            t282 = 1/t1**3.6666666666666664d+0
            t283 = 6.203504908994001d-1*t15*t153*t68*t71*t72-1.240700981
     1         7988002d+0*t15*t150*t151*t71*t72-8.271339878658668d-1*t15
     2         *t158*t67*t68*t71-6.433264350067852d-1*t15*t282*t71-6.203
     3         504908994001d-1*t15*t17*t274*t68+3.7221029453964005d+0*t1
     4         5*t151*t153*t17*t67-3.7221029453964005d+0*t15*t17*t271*t2
     5         72
            t284 = 5.011795824473985d-2*t14*t283*t71
            t285 = 3.34119721631599d-2*t14*t159*t161*t71
            t286 = -1.6705986081579946d-2*t14*t259*t71*t73
            t287 = 1/t1**1.9999999999999998d+0
            t288 = 5.568662027193316d-3*t14*t287*t71*t73
            t289 = -6.750000000000002d+0*t23*t30*t56*t91**3/t54**4
            t290 = 6.750000000000002d+0*t119*t163*t164*t23*t56
            t291 = 6.750000000000002d+0*t164*t185*t23*t30*t56*t91
            t292 = -3.375000000000001d+0*t223*t23*t56*t91*t92
            t293 = -3.375000000000001d+0*t119*t185*t23*t56*t92
            t294 = t82**3
            t295 = 1/t46**3
            t296 = -1.9066318539973046d+0*t263*t60+t273-7.14986945248989
     1         1d-1*t259*t260-1.715968668597574d+0*t137*t144
            t297 = t87**3
            t298 = 1/t51**3
            t299 = -2.9350782941533937d+0*t263*t60+t273-1.10065436030752
     1         25d+0*t259*t260-2.6415704647380545d+0*t137*t144
            t300 = 1.670598608157995d-2*t161*t51*t53*t71*t87*t90+2.50589
     1         79122369923d-2*t181*t51*t53*t71*t90+2.784331013596658d-3*
     2         t287*t52*t71*t90-8.352993040789973d-3*t259*t52*t71*t90+1.
     3         400557038530531d-3*t183*t51*t53*t59*t60*t87*t89+2.6673100
     4         07273315d-3*t181*t51*t53*t86*t89-4.668523461768438d-4*t14
     5         6*t183*t52*t60*t89+2.757778453988139d-4*t137*t52*t89/t49*
     6         *4-3.501392596326328d-4*t143*t144*t183*t52*t89+2.50589791
     7         22369923d-2*t52*t71*(-8.271339878658668d-1*t158*t53*t71*t
     8         87*t88+6.203504908994001d-1*t181*t53*t71*t72*t88-6.203504
     9         908994001d-1*t17*t299*t53*t88+3.7221029453964005d+0*t17*t
     :         180*t181*t53*t87-1.2407009817988002d+0*t179*t180*t53*t71*
     ;         t72-6.433264350067852d-1*t282*t53*t71-3.7221029453964005d
     <         +0*t17*t297*t298*t53)+2.667310007273315d-3*t52*t86*(-5.25
     =         0822119331622d-1*t146*t49*t53*t60*t87*t88-3.9381165894987
     >         163d-1*t143*t144*t49*t53*t87*t88-1.0339174848323335d-1*t1
     ?         37*t53*t87*t88+7.876233178997433d-1*t181*t49*t53*t59*t60*
     @         t88-1.0d+0*t299*t50*t53*t88+6.0d+0*t180*t181*t50*t53*t87-
     1         1.5752466357994865d+0*t179*t180*t49*t53*t59*t60-2.9171233
     2         99628679d-1*t263*t49*t53*t60-6.0d+0*t297*t298*t50*t53-1.0
     3         939212748607545d-1*t259*t260*t49*t53-2.625411059665811d-1
     4         *t137*t144*t49*t53-1.2062370656377225d-1*t254*t53)+5.3346
     5         2001454663d-3*t182*t51*t53*t86*t87+5.011795824473985d-2*t
     6         184*t51*t53*t71*t87-3.34119721631599d-2*t161*t46*t48*t71*
     7         t82*t85-5.011795824473985d-2*t175*t46*t48*t71*t85-5.56866
     8         2027193316d-3*t287*t47*t71*t85+1.6705986081579946d-2*t259
     9         *t47*t71*t85-2.3268355398725185d-3*t177*t46*t48*t59*t60*t
     :         82*t84-4.431373767749538d-3*t175*t46*t48*t81*t84+7.756118
     ;         466241728d-4*t146*t177*t47*t60*t84-4.5816748203035834d-4*
     <         t137*t47*t84/t44**4+5.817088849681296d-4*t143*t144*t177*t
     =         47*t84-5.011795824473985d-2*t47*t71*(-8.271339878658668d-
     >         1*t158*t48*t71*t82*t83+6.203504908994001d-1*t175*t48*t71*
     ?         t72*t83-6.203504908994001d-1*t17*t296*t48*t83+3.722102945
     @         3964005d+0*t17*t174*t175*t48*t82-1.2407009817988002d+0*t1
     1         73*t174*t48*t71*t72-6.433264350067852d-1*t282*t48*t71-3.7
     2         221029453964005d+0*t17*t294*t295*t48)-4.431373767749538d-
     3         3*t47*t81*(-5.250822119331622d-1*t146*t44*t48*t60*t82*t83
     4         -3.9381165894987163d-1*t143*t144*t44*t48*t82*t83-1.033917
     5         4848323335d-1*t137*t48*t82*t83+7.876233178997433d-1*t175*
     6         t44*t48*t59*t60*t83-1.0d+0*t296*t45*t48*t83+6.0d+0*t174*t
     7         175*t45*t48*t82-1.5752466357994865d+0*t173*t174*t44*t48*t
     8         59*t60-2.917123399628679d-1*t263*t44*t48*t60-6.0d+0*t294*
     9         t295*t45*t48-1.0939212748607545d-1*t259*t260*t44*t48-2.62
     :         5411059665811d-1*t137*t144*t44*t48-1.2062370656377225d-1*
     ;         t254*t48)-8.862747535499076d-3*t176*t46*t48*t81*t82-1.002
     <         359164894797d-1*t178*t46*t48*t71*t82+2.1150894194591274d-
     =         1*t263*t60*t78*t80+7.931585322971725d-2*t259*t260*t78*t80
     >         +1.9035804775132145d-1*t137*t144*t78*t80+7.87258055794557
     ?         9d-2*t248*t60*t80/t43**4-3.498376867038983d-1*t172*t254*t
     @         80+1.97833457907796d-1*t248*t60/(t43**8*t79**3)-2.6879375
     1         566081715d-1*t263*t60*t75*t77-1.007976583728064d-1*t259*t
     2         260*t75*t77-2.419143800947354d-1*t137*t144*t75*t77-1.0004
     3         780296492877d-1*t248*t60*t77/t42**4+4.445872822950419d-1*
     4         t169*t254*t77-5.421598446633554d-7*t248*t60/(t42**8*t76**
     5         3)+1.670598608157995d-2*t161*t184*t52*t71-3.3411972163159
     6         9d-2*t161*t178*t47*t71+1.400557038530531d-3*t182*t183*t52
     7         *t59*t60-2.3268355398725185d-3*t176*t177*t47*t59*t60-2.52
     8         18302197571857d-1*t171*t248*t60/t43**6+4.7062486515309376
     9         d-4*t168*t248*t60/t42**6+4.802734052773798d-1*t170*t171*t
     :         254-8.962879611183625d-4*t167*t168*t254
            t301 = -1.1250000000000002d+0*t23*t30*t300*t56*t92
            t302 = t115**3
            t303 = 1/t27**3
            t304 = -1.0298058196603158d+0*t263*t60+t273-3.86177182372618
     1         33d-1*t259*t260-9.26825237694284d-1*t137*t144
            t305 = 1.1250000000000002d+0*t23*t56*t57*(-3.34119721631599d
     1         -2*t13*t15*t161*t67*t71*t73-5.568662027193316d-3*t14*t287
     2         *t71*t73+1.6705986081579946d-2*t14*t259*t71*t73-5.0117958
     3         24473985d-2*t13*t15*t153*t71*t73+2.5058979122369923d-2*t2
     4         8*t71*(6.203504908994001d-1*t116*t219*t29*t71*t72-1.24070
     5         09817988002d+0*t217*t218*t29*t71*t72-6.433264350067852d-1
     6         *t282*t29*t71-8.271339878658668d-1*t115*t116*t158*t29*t71
     7         -6.203504908994001d-1*t116*t17*t29*t304-3.722102945396400
     8         5d+0*t17*t29*t302*t303+3.7221029453964005d+0*t115*t17*t21
     9         8*t219*t29)-1.002359164894797d-1*t13*t15*t159*t67*t71+5.0
     :         11795824473985d-2*t115*t222*t27*t29*t71+2.505897912236992
     ;         3d-2*t118*t219*t27*t29*t71+1.670598608157995d-2*t115*t118
     <         *t161*t27*t29*t71+2.784331013596658d-3*t118*t28*t287*t71-
     =         5.011795824473985d-2*t14*t283*t71-8.352993040789973d-3*t1
     >         18*t259*t28*t71+1.670598608157995d-2*t161*t222*t28*t71-3.
     ?         34119721631599d-2*t14*t159*t161*t71-5.088166200913744d-4*
     @         t13*t15*t156*t59*t60*t67*t69-9.690227711544375d-4*t13*t15
     1         *t153*t65*t69+1.696055400304582d-4*t14*t146*t156*t60*t69-
     2         1.0018895862972538d-4*t137*t14*t278*t69+1.272041550228436
     3         d-4*t14*t143*t144*t156*t69-1.938045542308875d-3*t13*t15*t
     4         154*t65*t67-9.690227711544375d-4*t14*t275*t65-6.960095232
     5         73821d-2*t263*t60*t61*t63-2.610035712276828d-2*t259*t260*
     6         t61*t63-6.26408570946439d-2*t137*t144*t61*t63-2.590619096
     7         601433d-2*t248*t256*t60*t63+1.1512059930225654d-1*t141*t2
     8         54*t63+2.2478670955426108d-3*t114*t28*(7.876233178997433d
     9         -1*t116*t219*t25*t29*t59*t60-1.5752466357994865d+0*t217*t
     :         218*t25*t29*t59*t60-2.917123399628679d-1*t25*t263*t29*t60
     ;         -5.250822119331622d-1*t115*t116*t146*t25*t29*t60-1.0d+0*t
     <         116*t26*t29*t304-6.0d+0*t26*t29*t302*t303-1.0939212748607
     =         545d-1*t25*t259*t260*t29+6.0d+0*t115*t218*t219*t26*t29-1.
     >         2062370656377225d-1*t254*t29-3.9381165894987163d-1*t115*t
     ?         116*t143*t144*t25*t29-2.625411059665811d-1*t137*t144*t25*
     @         t29-1.0339174848323335d-1*t115*t116*t137*t29)+1.180315026
     1         6592868d-3*t115*t117*t221*t27*t29*t59*t60+1.1803150266592
     2         868d-3*t220*t221*t28*t59*t60-5.088166200913744d-4*t14*t15
     3         4*t156*t59*t60-3.934383422197623d-4*t117*t146*t221*t28*t6
     4         0+7.244178432040066d-2*t111*t113*t263*t60+2.2877665475865
     5         033d+0*t139*t248*t252*t60-4.947718859586276d+1*t248*t249*
     6         t250*t60+2.69635778788734d-2*t113*t248*t60/t24**4-1.40814
     7         30686456894d+0*t215*t248*t60/t24**6+1.8009481522035156d+1
     8         *t248*t60/(t112**3*t24**8)+4.4957341910852217d-3*t114*t11
     9         5*t220*t27*t29+2.2478670955426108d-3*t114*t117*t219*t27*t
     :         29+2.3241090936607786d-4*t117*t137*t28/t25**4-2.950787566
     ;         6482175d-4*t117*t143*t144*t221*t28+2.716566912015024d-2*t
     <         111*t113*t259*t260-1.1981936089412427d-1*t113*t216*t254+2
     =         .681757326079316d+0*t214*t215*t254-4.3569682910487045d+0*
     >         t138*t139*t254+6.51976058883606d-2*t111*t113*t137*t144)
            t306 = 1/t21**1.6666666666666669d+0
            t307 = 6*t19*t41
            t308 = -6*t227
            t309 = 1/t22**1.6666666666666669d+0
            t310 = -6*t19*t41
            t311 = 6*t227
            t312 = 1/t31**8
            t313 = 1/t95**3
            t314 = -1.0606128115063691d+1*t248*t312*t313*t60
            t315 = 1/t31**6
            t316 = 4.1445148651319325d-1*t188*t248*t315*t60
            t317 = -7.89307801891314d-1*t187*t188*t254
            t318 = 1/t31**4
            t319 = -3.9662099574848336d-3*t248*t318*t60*t96
            t320 = 1.762483986407818d-2*t190*t254*t96
            t321 = -3.995936587128472d-3*t259*t260*t94*t96
            t322 = -9.590247809108335d-3*t137*t144*t94*t96
            t323 = -1.0655830899009261d-2*t263*t60*t94*t96
            t324 = -7.298067035835535d-4*t199*t35*t37*t98*t99
            t325 = -1.9160425910065093d-4*t101*t201*t35*t37*t59*t60*t99
            t326 = -3.6490335179177674d-4*t101*t198*t35*t37*t98
            t327 = -5.444297760095788d-2*t203*t35*t37*t71*t99
            t328 = -2.722148880047894d-2*t103*t198*t35*t37*t71
            t329 = -1.8147659200319294d-2*t103*t161*t35*t37*t71*t99
            t330 = t99**3
            t331 = 1/t35**3
            t332 = -1.5582543919966493d-1*t263*t60+t273-5.84345396998743
     1         4d-2*t259*t260-1.4024289527969844d-1*t137*t144
            t333 = -5.250822119331622d-1*t100*t146*t33*t37*t60*t99+6.0d+
     1         0*t197*t198*t34*t37*t99-3.9381165894987163d-1*t100*t143*t
     2         144*t33*t37*t99-1.0339174848323335d-1*t100*t137*t37*t99+7
     3         .876233178997433d-1*t100*t198*t33*t37*t59*t60-1.575246635
     4         7994865d+0*t196*t197*t33*t37*t59*t60-2.917123399628679d-1
     5         *t263*t33*t37*t60-1.0d+0*t100*t332*t34*t37-6.0d+0*t330*t3
     6         31*t34*t37-1.0939212748607545d-1*t259*t260*t33*t37-2.6254
     7         11059665811d-1*t137*t144*t33*t37-1.2062370656377225d-1*t2
     8         54*t37
            t334 = -3.6490335179177674d-4*t333*t36*t98
            t335 = -1.9160425910065093d-4*t199*t201*t36*t59*t60
            t336 = 1/t33**4
            t337 = -3.7727995569144196d-5*t101*t137*t336*t36
            t338 = 4.790106477516273d-5*t101*t143*t144*t201*t36
            t339 = 6.386808636688365d-5*t101*t146*t201*t36*t60
            t340 = -8.271339878658668d-1*t100*t158*t37*t71*t99+3.7221029
     1         453964005d+0*t17*t197*t198*t37*t99+6.203504908994001d-1*t
     2         100*t198*t37*t71*t72-1.2407009817988002d+0*t196*t197*t37*
     3         t71*t72-6.433264350067852d-1*t282*t37*t71-6.2035049089940
     4         01d-1*t100*t17*t332*t37-3.7221029453964005d+0*t17*t330*t3
     5         31*t37
            t341 = -2.722148880047894d-2*t340*t36*t71
            t342 = -1.8147659200319294d-2*t161*t203*t36*t71
            t343 = 9.073829600159644d-3*t103*t259*t36*t71
            t344 = -3.024609866719882d-3*t103*t287*t36*t71
            t345 = 60*t105*t209*t40
            t346 = 36*t105*t211*t41
            t347 = t40*t41*(7.298067035835535d-4*t199*t35*t37*t98*t99+5.
     1         444297760095788d-2*t203*t35*t37*t71*t99+1.814765920031929
     2         4d-2*t103*t161*t35*t37*t71*t99+1.9160425910065093d-4*t101
     3         *t201*t35*t37*t59*t60*t99+3.6490335179177674d-4*t101*t198
     4         *t35*t37*t98+3.6490335179177674d-4*t333*t36*t98+1.0655830
     5         899009261d-2*t263*t60*t94*t96+3.995936587128472d-3*t259*t
     6         260*t94*t96+9.590247809108335d-3*t137*t144*t94*t96+3.9662
     7         099574848336d-3*t248*t318*t60*t96-1.762483986407818d-2*t1
     8         90*t254*t96+2.722148880047894d-2*t103*t198*t35*t37*t71+2.
     9         722148880047894d-2*t340*t36*t71+3.024609866719882d-3*t103
     :         *t287*t36*t71-9.073829600159644d-3*t103*t259*t36*t71+1.81
     ;         47659200319294d-2*t161*t203*t36*t71+1.9160425910065093d-4
     <         *t199*t201*t36*t59*t60-6.386808636688365d-5*t101*t146*t20
     =         1*t36*t60-4.1445148651319325d-1*t188*t248*t315*t60+1.0606
     >         128115063691d+1*t248*t312*t313*t60+3.7727995569144196d-5*
     ?         t101*t137*t336*t36-4.790106477516273d-5*t101*t143*t144*t2
     @         01*t36+1.709920934161365d+0*t300+7.89307801891314d-1*t187
     1         *t188*t254)
            t348 = -12*t107*t207*t40
            t349 = -120*t40*t55/t1**7
            t350 = -144*t107*t211*t55
            t351 = 24*t19*t41*t55
            t352 = 2.0d+0*t240*wght
            t353 = -2.2500000000000003d+0*t23*t238*t30*t91*t92
            t354 = -2.2500000000000003d+0*t129*t132*t30*t91*t92
            t355 = -2.2500000000000003d+0*t110*t135*t30*t91*t92
            t356 = -2.2500000000000003d+0*t239*t30*t56*t91*t92
            t357 = 2.2500000000000003d+0*t119*t23*t238*t57
            t358 = 2.2500000000000003d+0*t119*t129*t132*t57
            t359 = 2.2500000000000003d+0*t110*t119*t135*t57
            t360 = 2.2500000000000003d+0*t119*t239*t56*t57
            t361 = -12*t105*t211*t41
            t362 = 48*t107*t211*t55
            t363 = -24*t19*t41*t55
            fnc(iq) = 1.0d+0*t1*t58*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t130*wght+t131+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t136*wght+t131+Amat(iq,D1_RB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*t1*t237*wght+2.0d+0*t130*wght+Am
     1         at2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*t1*t240*wght+1.0d+0*t136*wght+1.
     1         0d+0*t130*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*t1*t247*wght+2.0d+0*t136*wght+Am
     1         at2(iq,D2_RB_RB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*t1*(-3.375000000000001d+0*t23
     1         6*t30*t56*t91*t92-6.750000000000002d+0*t119*t129*t56*t91*
     2         t92-3.375000000000001d+0*t213*t23*t30*t91*t92-6.750000000
     3         000002d+0*t110*t129*t30*t91*t92-6.750000000000002d+0*t110
     4         *t119*t23*t91*t92-3.375000000000001d+0*t129*t185*t30*t56*
     5         t92-3.375000000000001d+0*t110*t185*t23*t30*t92+1.12500000
     6         00000002d+0*t30*(1.3333333333333333d+0*t128*(t311+t310)-2
     7         .962962962962963d-1*t127**3*t309+1.3333333333333333d+0*t1
     8         25*(t308+t307)-2.962962962962963d-1*t124**3*t306+1.333333
     9         3333333333d+0*t127*t232*t235+1.3333333333333333d+0*t124*t
     :         226*t230)*t56*t57+3.375000000000001d+0*t119*t236*t56*t57+
     ;         3.375000000000001d+0*t129*t223*t56*t57+1.1250000000000002
     <         d+0*t23*t30*(240*t109*t209*t55+12*t109*t207*t41+t351+t350
     =         +t349+t348+t347+t346+t345+t344+t343+t342+t341+t339+t338+t
     >         337+t335+t334+t329+t328+t327+t326+t325+t324+t323+t322+t32
     ?         1+t320+t319+t317+t316+t314-96*t105*t107*t109)*t57+3.37500
     @         0000000001d+0*t110*t236*t30*t57+3.375000000000001d+0*t129
     1         *t213*t30*t57+3.375000000000001d+0*t110*t223*t23*t57+3.37
     2         5000000000001d+0*t119*t213*t23*t57+6.750000000000002d+0*t
     3         110*t119*t129*t57+6.750000000000002d+0*t129*t163*t164*t30
     4         *t56+t305+t301+6.750000000000002d+0*t110*t163*t164*t23*t3
     5         0+t293+t292+t291+t290+t289+t288+t286+t285+t284+t281+t280+
     6         t279+t277+t276+t270+t269+t268+t267+t266+t265+t264+t262+t2
     7         61+t258+t257+t255+t253+t251)*wght+3.0d+0*t237*wght+Amat3(
     8         iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 1.0d+0*t1*(-1.1250000000000002d+0*t2
     1         36*t30*t56*t91*t92-2.2500000000000003d+0*t119*t135*t56*t9
     2         1*t92-4.5000000000000007d+0*t119*t129*t56*t91*t92-1.12500
     3         00000000002d+0*t213*t23*t30*t91*t92-2.2500000000000003d+0
     4         *t110*t129*t30*t91*t92-2.2500000000000003d+0*t119*t132*t2
     5         3*t91*t92-4.5000000000000007d+0*t110*t119*t23*t91*t92-1.1
     6         250000000000002d+0*t135*t185*t30*t56*t92-2.25000000000000
     7         03d+0*t129*t185*t30*t56*t92-1.1250000000000002d+0*t132*t1
     8         85*t23*t30*t92-2.2500000000000003d+0*t110*t185*t23*t30*t9
     9         2+1.1250000000000002d+0*t30*(1.3333333333333333d+0*t128*(
     :         t310+2*t227)-2.962962962962963d-1*t134*t231*t309+1.333333
     ;         3333333333d+0*t125*(t307-2*t227)-2.962962962962963d-1*t13
     <         3*t225*t306+4.444444444444444d-1*t134*t232*t235+1.7777777
     =         777777776d+0*t127*t19*t227*t232+4.444444444444444d-1*t133
     >         *t226*t230-1.7777777777777776d+0*t124*t19*t226*t227)*t56*
     ?         t57+1.1250000000000002d+0*t119*t236*t56*t57+1.12500000000
     @         00002d+0*t135*t223*t56*t57+2.2500000000000003d+0*t129*t22
     1         3*t56*t57+1.1250000000000002d+0*t23*t30*(80*t109*t209*t55
     2         +4*t109*t207*t41+t363+t362+t361+t349+t348+t347+t345+t344+
     3         t343+t342+t341+t339+t338+t337+t335+t334+t329+t328+t327+t3
     4         26+t325+t324+t323+t322+t321+t320+t319+t317+t316+t314-32*t
     5         105*t107*t109)*t57+2.2500000000000003d+0*t110*t239*t30*t5
     6         7+2.2500000000000003d+0*t129*t238*t30*t57+1.1250000000000
     7         002d+0*t132*t236*t30*t57+1.1250000000000002d+0*t135*t213*
     8         t30*t57+1.1250000000000002d+0*t132*t223*t23*t57+2.2500000
     9         000000003d+0*t110*t223*t23*t57+1.1250000000000002d+0*t119
     :         *t213*t23*t57+2.2500000000000003d+0*t110*t119*t129*t57+2.
     ;         2500000000000003d+0*t135*t163*t164*t30*t56+4.500000000000
     <         0007d+0*t129*t163*t164*t30*t56+t360+t359+t358+t357+t356+t
     =         355+t354+t353+t305+t301+2.2500000000000003d+0*t132*t163*t
     >         164*t23*t30+4.5000000000000007d+0*t110*t163*t164*t23*t30+
     ?         t293+t292+t291+t290+t289+t288+t286+t285+t284+t281+t280+t2
     @         79+t277+t276+t270+t269+t268+t267+t266+t265+t264+t262+t261
     1         +t258+t257+t255+t253+t251)*wght+1.0d+0*t237*wght+t352+Ama
     2         t3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = 1.0d+0*t1*(-1.1250000000000002d+0*t2
     1         46*t30*t56*t91*t92-4.5000000000000007d+0*t119*t135*t56*t9
     2         1*t92-2.2500000000000003d+0*t119*t129*t56*t91*t92-1.12500
     3         00000000002d+0*t23*t241*t30*t91*t92-2.2500000000000003d+0
     4         *t132*t135*t30*t91*t92-4.5000000000000007d+0*t119*t132*t2
     5         3*t91*t92-2.2500000000000003d+0*t110*t119*t23*t91*t92-2.2
     6         500000000000003d+0*t135*t185*t30*t56*t92-1.12500000000000
     7         02d+0*t129*t185*t30*t56*t92-2.2500000000000003d+0*t132*t1
     8         85*t23*t30*t92-1.1250000000000002d+0*t110*t185*t23*t30*t9
     9         2+1.1250000000000002d+0*t30*(-8*t128*t19*t41+8*t125*t19*t
     :         41-2.962962962962963d-1*t127*t244*t309-2.962962962962963d
     ;         -1*t124*t242*t306+4.444444444444444d-1*t127*t232*t245+4.4
     <         44444444444444d-1*t124*t226*t243+1.7777777777777776d+0*t1
     =         34*t19*t227*t232-1.7777777777777776d+0*t133*t19*t226*t227
     >         -2.6666666666666666d+0*t128*t227+2.6666666666666666d+0*t1
     ?         25*t227)*t56*t57+1.1250000000000002d+0*t119*t246*t56*t57+
     @         2.2500000000000003d+0*t135*t223*t56*t57+1.125000000000000
     1         2d+0*t129*t223*t56*t57+1.1250000000000002d+0*t23*t30*(-80
     2         *t109*t209*t55-4*t109*t207*t41+t362+t361+t351+t349+t348+t
     3         347+t345+t344+t343+t342+t341+t339+t338+t337+t335+t334+t32
     4         9+t328+t327+t326+t325+t324+t323+t322+t321+t320+t319+t317+
     5         t316+t314+32*t105*t107*t109)*t57+1.1250000000000002d+0*t1
     6         10*t246*t30*t57+1.1250000000000002d+0*t129*t241*t30*t57+2
     7         .2500000000000003d+0*t132*t239*t30*t57+2.2500000000000003
     8         d+0*t135*t238*t30*t57+1.1250000000000002d+0*t119*t23*t241
     9         *t57+2.2500000000000003d+0*t132*t223*t23*t57+1.1250000000
     :         000002d+0*t110*t223*t23*t57+2.2500000000000003d+0*t119*t1
     ;         32*t135*t57+4.5000000000000007d+0*t135*t163*t164*t30*t56+
     <         2.2500000000000003d+0*t129*t163*t164*t30*t56+t360+t359+t3
     =         58+t357+t356+t355+t354+t353+t305+t301+4.5000000000000007d
     >         +0*t132*t163*t164*t23*t30+2.2500000000000003d+0*t110*t163
     ?         *t164*t23*t30+t293+t292+t291+t290+t289+t288+t286+t285+t28
     @         4+t281+t280+t279+t277+t276+t270+t269+t268+t267+t266+t265+
     1         t264+t262+t261+t258+t257+t255+t253+t251)*wght+1.0d+0*t247
     2         *wght+t352+Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*t1*(-3.375000000000001d+0*t24
     1         6*t30*t56*t91*t92-6.750000000000002d+0*t119*t135*t56*t91*
     2         t92-3.375000000000001d+0*t23*t241*t30*t91*t92-6.750000000
     3         000002d+0*t132*t135*t30*t91*t92-6.750000000000002d+0*t119
     4         *t132*t23*t91*t92-3.375000000000001d+0*t135*t185*t30*t56*
     5         t92-3.375000000000001d+0*t132*t185*t23*t30*t92+1.12500000
     6         00000002d+0*t30*(1.3333333333333333d+0*t125*(t311+t307)+1
     7         .3333333333333333d+0*t128*(t310+t308)-2.962962962962963d-
     8         1*t134**3*t309-2.962962962962963d-1*t133**3*t306+1.333333
     9         3333333333d+0*t134*t232*t245+1.3333333333333333d+0*t133*t
     :         226*t243)*t56*t57+3.375000000000001d+0*t119*t246*t56*t57+
     ;         3.375000000000001d+0*t135*t223*t56*t57+1.1250000000000002
     <         d+0*t23*t30*(-240*t109*t209*t55-12*t109*t207*t41+t363+t35
     =         0+t349+t348+t347+t346+t345+t344+t343+t342+t341+t339+t338+
     >         t337+t335+t334+t329+t328+t327+t326+t325+t324+t323+t322+t3
     ?         21+t320+t319+t317+t316+t314+96*t105*t107*t109)*t57+3.3750
     @         00000000001d+0*t132*t246*t30*t57+3.375000000000001d+0*t13
     1         5*t241*t30*t57+3.375000000000001d+0*t119*t23*t241*t57+3.3
     2         75000000000001d+0*t132*t223*t23*t57+6.750000000000002d+0*
     3         t119*t132*t135*t57+6.750000000000002d+0*t135*t163*t164*t3
     4         0*t56+t305+t301+6.750000000000002d+0*t132*t163*t164*t23*t
     5         30+t293+t292+t291+t290+t289+t288+t286+t285+t284+t281+t280
     6         +t279+t277+t276+t270+t269+t268+t267+t266+t265+t264+t262+t
     7         261+t258+t257+t255+t253+t251)*wght+3.0d+0*t247*wght+Amat3
     8         (iq,D3_RB_RB_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = t11+3.25d-1
            t22 = t21**2
            t23 = t15+7.06042d+0
            t24 = 1.554535d-2*log(6.203504908994001d-1*t20*t9)+5.2491393
     1         16978092d-2*atan(4.7309269095601136d+0/t23)+2.24786709554
     2         26108d-3*log(1.0d+0*t20*t22)-3.8783294878113006d-2*t17-9.
     3         690227711544375d-4*t14-3.10907d-2*t10
            t25 = t5+8.414573716781907d-1*t3+1.14813d+1
            t26 = abs(t25)
            t27 = 1/t26
            t28 = log(6.203504908994001d-1*t27*t9)
            t29 = t11+2.28344d-1
            t30 = t29**2
            t31 = log(1.0d+0*t27*t30)
            t32 = t15+1.0683499999999999d+0
            t33 = atan(6.692072046645942d+0/t32)
            t34 = t5+1.0295812011585444d+1*t3+4.2719799999999997d+1
            t35 = abs(t34)
            t36 = 1/t35
            t37 = t5+1.5849422788428325d+1*t3+1.01578d+2
            t38 = abs(t37)
            t39 = 1/t38
            t40 = t11+4.09286d-1
            t41 = t40**2
            t42 = t11+7.43294d-1
            t43 = t42**2
            t44 = t15+1.3072d+1
            t45 = t15+2.0123100000000002d+1
            t46 = 1.554535d-2*log(6.203504908994001d-1*t39*t9)-3.10907d-
     1         2*log(6.203504908994001d-1*t36*t9)+6.188180297906176d-1*a
     2         tan(1.171685277708971d+0/t45)-2.052197293770518d+1*atan(4
     3         .4899888641576796d-2/t44)+2.667310007273315d-3*log(1.0d+0
     4         *t39*t43)-4.431373767749538d-3*log(1.0d+0*t36*t41)
            t47 = 1.0d+0*(1.709920934161365d+0*t46+5.458482358638966d-3*
     1         t33+3.6490335179177674d-4*t31+1.688686394038963d-2*t28)-5
     2         .458482358638966d-3*t33-3.6490335179177674d-4*t31-1.68868
     3         6394038963d-2*t28
            t48 = 1/t46
            t49 = 5.848223622634643d-1*t24*t47*t48+3.8783294878113006d-2
     1         *t17+9.690227711544375d-4*t14+3.10907d-2*t10
            t50 = 1/t9
            t51 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t52 = 1/t2**3
            t53 = 1/rhoa**6.666666666666667d-1
            t54 = t51-4.8930311001203647d-1*t52*t53
            t55 = 1/t6
            t56 = 1/rhoa**1.6666666666666666d+0
            t57 = -6.203504908994001d-1*t54*t55*t8*t9-2.067834969664667d
     1         -1*t50*t56*t8
            t58 = 1/t16**2
            t59 = 3.784699104639999d+1*t58+1
            t60 = 1/t59
            t61 = 1/t13
            t62 = -1.0d+0*t13*t54*t55*t8-2.625411059665811d-1*t12*t52*t5
     1         3*t8
            t63 = t51-9.26825237694284d-1*t52*t53
            t64 = 1/t18
            t65 = -6.203504908994001d-1*t20*t63*t64*t9-2.067834969664667
     1         d-1*t20*t50*t56
            t66 = 1/t23**2
            t67 = 2.238166942360001d+1*t66+1
            t68 = 1/t67
            t69 = 1/t22
            t70 = -1.0d+0*t20*t22*t63*t64-2.625411059665811d-1*t20*t21*t
     1         52*t53
            t71 = 2.2478670955426108d-3*t19*t69*t70-9.690227711544375d-4
     1         *t61*t62*t7-5.011795824473985d-2*t50*t57*t7+6.51976058883
     2         6059d-2*t52*t53*t66*t68+2.5058979122369923d-2*t19*t50*t65
     3         -6.264085709464389d-2*t52*t53*t58*t60
            t72 = 1/t46**2
            t73 = t51-1.715968668597574d+0*t52*t53
            t74 = 1/t34
            t75 = -6.203504908994001d-1*t36*t73*t74*t9-2.067834969664667
     1         d-1*t36*t50*t56
            t76 = t51-2.641570464738054d+0*t52*t53
            t77 = 1/t37
            t78 = -6.203504908994001d-1*t39*t76*t77*t9-2.067834969664667
     1         d-1*t39*t50*t56
            t79 = 1/t44**2
            t80 = 2.016000000025997d-3*t79+1
            t81 = 1/t80
            t82 = 1/t45**2
            t83 = 1.3728463899999485d+0*t82+1
            t84 = 1/t83
            t85 = 1/t41
            t86 = -1.0d+0*t36*t41*t73*t74-2.625411059665811d-1*t36*t40*t
     1         52*t53
            t87 = 1/t43
            t88 = -1.0d+0*t39*t43*t76*t77-2.625411059665811d-1*t39*t42*t
     1         52*t53
            t89 = 2.667310007273315d-3*t38*t87*t88-4.431373767749538d-3*
     1         t35*t85*t86+1.9035804775132142d-1*t52*t53*t82*t84-2.41914
     2         38009473537d-1*t52*t53*t79*t81+2.5058979122369923d-2*t38*
     3         t50*t78-5.011795824473985d-2*t35*t50*t75
            t90 = t51-1.4024289527969844d-1*t52*t53
            t91 = 1/t25
            t92 = -6.203504908994001d-1*t27*t9*t90*t91-2.067834969664667
     1         d-1*t27*t50*t56
            t93 = 1/t32**2
            t94 = 4.4783828277500004d+1*t93+1
            t95 = 1/t94
            t96 = 1/t30
            t97 = -1.0d+0*t27*t30*t90*t91-2.625411059665811d-1*t27*t29*t
     1         52*t53
            t98 = 1.0d+0*(3.6490335179177674d-4*t26*t96*t97+9.5902478091
     1         08334d-3*t52*t53*t93*t95+2.722148880047894d-2*t26*t50*t92
     2         +1.709920934161365d+0*t89)-3.6490335179177674d-4*t26*t96*
     3         t97-9.590247809108334d-3*t52*t53*t93*t95-2.72214888004789
     4         4d-2*t26*t50*t92
            t99 = 5.848223622634643d-1*t24*t48*t98-5.848223622634643d-1*
     1         t24*t47*t72*t89+5.848223622634643d-1*t47*t48*t71+9.690227
     2         711544375d-4*t61*t62*t7+5.011795824473985d-2*t50*t57*t7+6
     3         .264085709464389d-2*t52*t53*t58*t60
            t100 = 1/t46**3
            t101 = t89**2
            t102 = 1/t59**2
            t103 = 1/t16**5
            t104 = 1/rhoa**2.3333333333333334d+0
            t105 = 1/t16**3
            t106 = 1/rhoa**1.6666666666666669d+0
            t107 = t54**2
            t108 = 1/t6**2
            t109 = 2.7571132928862224d-1/rhoa**2.333333333333333d+0
            t110 = 1/t2**5
            t111 = 1/rhoa**1.3333333333333336d+0
            t112 = 3.262020733413577d-1*t106*t52+2.4465155500601823d-1*t
     1         110*t111+t109
            t113 = 1/rhoa**2.6666666666666666d+0
            t114 = -6.203504908994001d-1*t112*t55*t8*t9+1.24070098179880
     1         02d+0*t107*t108*t8*t9+4.135669939329334d-1*t50*t54*t55*t5
     2         6*t8+2.7571132928862224d-1*t113*t50*t8
            t115 = 1/rhoa**9.999999999999999d-1
            t116 = 1/t12**3
            t117 = 5.250822119331622d-1*t12*t52*t53*t54*t55*t8-1.0d+0*t1
     1         12*t13*t55*t8+1.7502740397772074d-1*t106*t12*t52*t8+2.0d+
     2         0*t107*t108*t13*t8+1.3127055298329054d-1*t110*t111*t12*t8
     3         +3.446391616107778d-2*t104*t8
            t118 = 1/t94**2
            t119 = 1/t32**5
            t120 = 1/t32**3
            t121 = t90**2
            t122 = 1/t25**2
            t123 = 9.349526351979897d-2*t106*t52+7.012144763984922d-2*t1
     1         10*t111+t109
            t124 = 4.135669939329334d-1*t27*t50*t56*t90*t91-6.2035049089
     1         94001d-1*t123*t27*t9*t91+1.2407009817988002d+0*t121*t122*
     2         t27*t9+2.7571132928862224d-1*t113*t27*t50
            t125 = 1/t29**3
            t126 = 5.250822119331622d-1*t27*t29*t52*t53*t90*t91-1.0d+0*t
     1         123*t27*t30*t91+1.7502740397772074d-1*t106*t27*t29*t52+2.
     2         0d+0*t121*t122*t27*t30+1.3127055298329054d-1*t110*t111*t2
     3         7*t29+3.446391616107778d-2*t104*t27
            t127 = 1/t80**2
            t128 = 1/t44**5
            t129 = 1/t44**3
            t130 = 1/t83**2
            t131 = 1/t45**5
            t132 = 1/t45**3
            t133 = t73**2
            t134 = 1/t34**2
            t135 = 1.1439791123983827d+0*t106*t52+8.57984334298787d-1*t1
     1         10*t111+t109
            t136 = -6.203504908994001d-1*t135*t36*t74*t9+1.2407009817988
     1         002d+0*t133*t134*t36*t9+4.135669939329334d-1*t36*t50*t56*
     2         t73*t74+2.7571132928862224d-1*t113*t36*t50
            t137 = t76**2
            t138 = 1/t37**2
            t139 = 1.761046976492036d+0*t106*t52+1.320785232369027d+0*t1
     1         10*t111+t109
            t140 = -6.203504908994001d-1*t139*t39*t77*t9+1.2407009817988
     1         002d+0*t137*t138*t39*t9+4.135669939329334d-1*t39*t50*t56*
     2         t76*t77+2.7571132928862224d-1*t113*t39*t50
            t141 = 1/t40**3
            t142 = 1/t42**3
            t143 = 5.250822119331622d-1*t36*t40*t52*t53*t73*t74-1.0d+0*t
     1         135*t36*t41*t74+1.7502740397772074d-1*t106*t36*t40*t52+2.
     2         0d+0*t133*t134*t36*t41+1.3127055298329054d-1*t110*t111*t3
     3         6*t40+3.446391616107778d-2*t104*t36
            t144 = 5.250822119331622d-1*t39*t42*t52*t53*t76*t77-1.0d+0*t
     1         139*t39*t43*t77+1.7502740397772074d-1*t106*t39*t42*t52+2.
     2         0d+0*t137*t138*t39*t43+1.3127055298329054d-1*t110*t111*t3
     3         9*t42+3.446391616107778d-2*t104*t39
            t145 = 2.667310007273315d-3*t37*t39*t76*t87*t88+7.0027851926
     1         52656d-4*t142*t38*t52*t53*t88+2.667310007273315d-3*t144*t
     2         38*t87-4.431373767749538d-3*t34*t36*t73*t85*t86-1.1634177
     3         699362593d-3*t141*t35*t52*t53*t86-4.431373767749538d-3*t1
     4         43*t35*t85-1.2690536516754763d-1*t106*t52*t82*t84-9.51790
     5         2387566071d-2*t110*t111*t82*t84+9.995362477254237d-2*t104
     6         *t132*t84+1.6127625339649027d-1*t106*t52*t79*t81+1.209571
     7         9004736769d-1*t110*t111*t79*t81-1.270249377985834d-1*t104
     8         *t129*t81+2.5058979122369923d-2*t37*t39*t50*t76*t78+8.352
     9         993040789976d-3*t115*t38*t50*t78-5.011795824473985d-2*t34
     :         *t36*t50*t73*t75-1.670598608157995d-2*t115*t35*t50*t75+2.
     ;         5058979122369923d-2*t140*t38*t50-5.011795824473985d-2*t13
     <         6*t35*t50-1.372209729363942d-1*t104*t130*t131+2.560822746
     =         052464d-4*t104*t127*t128
            t146 = 1.0d+0*(3.6490335179177674d-4*t25*t27*t90*t96*t97+9.5
     1         80212955032547d-5*t125*t26*t52*t53*t97+3.6490335179177674
     2         d-4*t126*t26*t96-6.393498539405557d-3*t106*t52*t93*t95-4.
     3         795123904554167d-3*t110*t111*t93*t95+5.035668532593766d-3
     4         *t104*t120*t95+2.722148880047894d-2*t25*t27*t50*t90*t92+9
     5         .073829600159646d-3*t115*t26*t50*t92+2.722148880047894d-2
     6         *t124*t26*t50+1.709920934161365d+0*t145-2.255165148260897
     7         d-1*t104*t118*t119)-3.6490335179177674d-4*t25*t27*t90*t96
     8         *t97-9.580212955032547d-5*t125*t26*t52*t53*t97-3.64903351
     9         79177674d-4*t126*t26*t96+6.393498539405557d-3*t106*t52*t9
     :         3*t95+4.795123904554167d-3*t110*t111*t93*t95-5.0356685325
     ;         93766d-3*t104*t120*t95-2.722148880047894d-2*t25*t27*t50*t
     <         90*t92-9.073829600159646d-3*t115*t26*t50*t92-2.7221488800
     =         47894d-2*t124*t26*t50+2.255165148260897d-1*t104*t118*t119
            t147 = 1/t67**2
            t148 = 1/t23**5
            t149 = 1/t23**3
            t150 = t63**2
            t151 = 1/t18**2
            t152 = 6.178834917961894d-1*t106*t52+4.63412618847142d-1*t11
     1         0*t111+t109
            t153 = -6.203504908994001d-1*t152*t20*t64*t9+1.2407009817988
     1         002d+0*t150*t151*t20*t9+4.135669939329334d-1*t20*t50*t56*
     2         t63*t64+2.7571132928862224d-1*t113*t20*t50
            t154 = 1/t21**3
            t155 = 5.250822119331622d-1*t20*t21*t52*t53*t63*t64-1.0d+0*t
     1         152*t20*t22*t64+1.7502740397772074d-1*t106*t20*t21*t52+2.
     2         0d+0*t150*t151*t20*t22+1.3127055298329054d-1*t110*t111*t2
     3         0*t21+3.446391616107778d-2*t104*t20
            t156 = -9.690227711544375d-4*t54*t6*t61*t62*t8-5.01179582447
     1         3985d-2*t50*t54*t57*t6*t8+2.2478670955426108d-3*t18*t20*t
     2         63*t69*t70+5.901575133296435d-4*t154*t19*t52*t53*t70-2.54
     3         4083100456872d-4*t116*t52*t53*t62*t7-9.690227711544375d-4
     4         *t117*t61*t7-1.670598608157995d-2*t115*t50*t57*t7-5.01179
     5         5824473985d-2*t114*t50*t7+2.2478670955426108d-3*t155*t19*
     6         t69-4.3465070592240396d-2*t106*t52*t66*t68-3.259880294418
     7         0294d-2*t110*t111*t66*t68+3.4234103112606934d-2*t104*t149
     8         *t68+2.5058979122369923d-2*t18*t20*t50*t63*t65+8.35299304
     9         0789976d-3*t115*t19*t50*t65+4.176057139642926d-2*t106*t52
     :         *t58*t60+3.1320428547321943d-2*t110*t111*t58*t60-3.289159
     ;         980064472d-2*t104*t105*t60+2.5058979122369923d-2*t153*t19
     <         *t50-7.662163788798045d-1*t104*t147*t148+1.24484808315677
     =         28d+0*t102*t103*t104
            t157 = -1.1696447245269286d+0*t24*t72*t89*t98+1.169644724526
     1         9286d+0*t48*t71*t98-1.1696447245269286d+0*t47*t71*t72*t89
     2         +9.690227711544375d-4*t54*t6*t61*t62*t8+5.011795824473985
     3         d-2*t50*t54*t57*t6*t8-5.848223622634643d-1*t145*t24*t47*t
     4         72+2.544083100456872d-4*t116*t52*t53*t62*t7+9.69022771154
     5         4375d-4*t117*t61*t7+1.670598608157995d-2*t115*t50*t57*t7+
     6         5.011795824473985d-2*t114*t50*t7-4.176057139642926d-2*t10
     7         6*t52*t58*t60-3.1320428547321943d-2*t110*t111*t58*t60+3.2
     8         89159980064472d-2*t104*t105*t60+5.848223622634643d-1*t156
     9         *t47*t48+5.848223622634643d-1*t146*t24*t48+1.169644724526
     :         9286d+0*t100*t101*t24*t47-1.2448480831567728d+0*t102*t103
     ;         *t104
            t158 = 1/rhoa**3.3333333333333337d+0
            t159 = 1/t59**3
            t160 = 1/t16**8
            t161 = 1/rhoa**3.0d+0
            t162 = 1/t16**6
            t163 = 1/t16**4
            t164 = 1/rhoa**2.666666666666667d+0
            t165 = 1/t12**4
            t166 = 1/t2**7
            t167 = 1/rhoa**2.0d+0
            t168 = 1/rhoa**1.9999999999999998d+0
            t169 = t54**3
            t170 = 1/t6**3
            t171 = -6.433264350067851d-1/rhoa**3.333333333333333d+0
            t172 = -5.436701222355962d-1*t164*t52+t171-2.038762958383485
     1         1d-1*t166*t167-4.893031100120365d-1*t104*t110
            t173 = 1/rhoa**3.6666666666666664d+0
            t174 = -6.203504908994001d-1*t172*t55*t8*t9+3.72210294539640
     1         05d+0*t108*t112*t54*t8*t9-3.7221029453964005d+0*t169*t170
     2         *t8*t9+6.203504908994001d-1*t112*t50*t55*t56*t8-1.2407009
     3         817988002d+0*t107*t108*t50*t56*t8-8.271339878658668d-1*t1
     4         13*t50*t54*t55*t8-6.433264350067852d-1*t173*t50*t8
            t175 = -5.250822119331622d-1*t106*t12*t52*t54*t55*t8-3.93811
     1         65894987163d-1*t110*t111*t12*t54*t55*t8-1.033917484832333
     2         5d-1*t104*t54*t55*t8+7.876233178997433d-1*t112*t12*t52*t5
     3         3*t55*t8-1.0d+0*t13*t172*t55*t8+6.0d+0*t108*t112*t13*t54*
     4         t8-1.5752466357994865d+0*t107*t108*t12*t52*t53*t8-2.91712
     5         3399628679d-1*t12*t164*t52*t8-6.0d+0*t13*t169*t170*t8-1.0
     6         939212748607545d-1*t12*t166*t167*t8-1.2062370656377223d-1
     7         *t158*t8-2.625411059665811d-1*t104*t110*t12*t8
            t176 = 1/t94**3
            t177 = 1/t32**8
            t178 = 1/t32**6
            t179 = 1/t32**4
            t180 = 1/t29**4
            t181 = t90**3
            t182 = 1/t25**3
            t183 = -1.5582543919966493d-1*t164*t52+t171-5.84345396998743
     1         4d-2*t166*t167-1.4024289527969844d-1*t104*t110
            t184 = -8.271339878658668d-1*t113*t27*t50*t90*t91-6.20350490
     1         8994001d-1*t183*t27*t9*t91+6.203504908994001d-1*t123*t27*
     2         t50*t56*t91+3.7221029453964005d+0*t122*t123*t27*t9*t90-3.
     3         7221029453964005d+0*t181*t182*t27*t9-1.2407009817988002d+
     4         0*t121*t122*t27*t50*t56-6.433264350067852d-1*t173*t27*t50
            t185 = -5.250822119331622d-1*t106*t27*t29*t52*t90*t91-3.9381
     1         165894987163d-1*t110*t111*t27*t29*t90*t91-1.0339174848323
     2         335d-1*t104*t27*t90*t91+7.876233178997433d-1*t123*t27*t29
     3         *t52*t53*t91-1.0d+0*t183*t27*t30*t91+6.0d+0*t122*t123*t27
     4         *t30*t90-1.5752466357994865d+0*t121*t122*t27*t29*t52*t53-
     5         2.917123399628679d-1*t164*t27*t29*t52-6.0d+0*t181*t182*t2
     6         7*t30-1.0939212748607545d-1*t166*t167*t27*t29-2.625411059
     7         665811d-1*t104*t110*t27*t29-1.2062370656377223d-1*t158*t2
     8         7
            t186 = t73**3
            t187 = 1/t34**3
            t188 = -1.9066318539973046d+0*t164*t52+t171-7.14986945248989
     1         1d-1*t166*t167-1.715968668597574d+0*t104*t110
            t189 = t76**3
            t190 = 1/t37**3
            t191 = -2.9350782941533937d+0*t164*t52+t171-1.10065436030752
     1         25d+0*t166*t167-2.6415704647380545d+0*t104*t110
            t192 = 2.5058979122369923d-2*t38*t50*(-6.203504908994001d-1*
     1         t191*t39*t77*t9+3.7221029453964005d+0*t138*t139*t39*t76*t
     2         9-3.7221029453964005d+0*t189*t190*t39*t9-8.27133987865866
     3         8d-1*t113*t39*t50*t76*t77+6.203504908994001d-1*t139*t39*t
     4         50*t56*t77-1.2407009817988002d+0*t137*t138*t39*t50*t56-6.
     5         433264350067852d-1*t173*t39*t50)-5.011795824473985d-2*t35
     6         *t50*(-6.203504908994001d-1*t188*t36*t74*t9+3.72210294539
     7         64005d+0*t134*t135*t36*t73*t9-3.7221029453964005d+0*t186*
     8         t187*t36*t9-8.271339878658668d-1*t113*t36*t50*t73*t74+6.2
     9         03504908994001d-1*t135*t36*t50*t56*t74-1.2407009817988002
     :         d+0*t133*t134*t36*t50*t56-6.433264350067852d-1*t173*t36*t
     ;         50)+2.667310007273315d-3*t139*t37*t39*t87*t88+1.400557038
     <         530531d-3*t142*t37*t39*t52*t53*t76*t88-4.668523461768438d
     =         -4*t106*t142*t38*t52*t88+2.757778453988139d-4*t104*t38*t8
     >         8/t42**4-3.501392596326328d-4*t110*t111*t142*t38*t88+2.66
     ?         7310007273315d-3*t38*(-5.250822119331622d-1*t106*t39*t42*
     @         t52*t76*t77-3.9381165894987163d-1*t110*t111*t39*t42*t76*t
     1         77-1.0339174848323335d-1*t104*t39*t76*t77+7.8762331789974
     2         33d-1*t139*t39*t42*t52*t53*t77-1.0d+0*t191*t39*t43*t77+6.
     3         0d+0*t138*t139*t39*t43*t76-1.5752466357994865d+0*t137*t13
     4         8*t39*t42*t52*t53-2.917123399628679d-1*t164*t39*t42*t52-6
     5         .0d+0*t189*t190*t39*t43-1.0939212748607545d-1*t166*t167*t
     6         39*t42-2.625411059665811d-1*t104*t110*t39*t42-1.206237065
     7         6377223d-1*t158*t39)*t87+5.33462001454663d-3*t144*t37*t39
     8         *t76*t87-4.431373767749538d-3*t135*t34*t36*t85*t86-2.3268
     9         355398725185d-3*t141*t34*t36*t52*t53*t73*t86+7.7561184662
     :         41728d-4*t106*t141*t35*t52*t86-4.5816748203035834d-4*t104
     ;         *t35*t86/t40**4+5.817088849681296d-4*t110*t111*t141*t35*t
     <         86-4.431373767749538d-3*t35*(-5.250822119331622d-1*t106*t
     =         36*t40*t52*t73*t74-3.9381165894987163d-1*t110*t111*t36*t4
     >         0*t73*t74-1.0339174848323335d-1*t104*t36*t73*t74+7.876233
     ?         178997433d-1*t135*t36*t40*t52*t53*t74-1.0d+0*t188*t36*t41
     @         *t74+6.0d+0*t134*t135*t36*t41*t73-1.5752466357994865d+0*t
     1         133*t134*t36*t40*t52*t53-2.917123399628679d-1*t164*t36*t4
     2         0*t52-6.0d+0*t186*t187*t36*t41-1.0939212748607545d-1*t166
     3         *t167*t36*t40-2.625411059665811d-1*t104*t110*t36*t40-1.20
     4         62370656377223d-1*t158*t36)*t85-8.862747535499076d-3*t143
     5         *t34*t36*t73*t85+2.1150894194591274d-1*t164*t52*t82*t84+7
     6         .931585322971725d-2*t166*t167*t82*t84+1.9035804775132145d
     7         -1*t104*t110*t82*t84+7.872580557945579d-2*t161*t52*t84/t4
     8         5**4-3.498376867038983d-1*t132*t158*t84+1.97833457907796d
     9         -1*t161*t52/(t45**8*t83**3)-2.6879375566081715d-1*t164*t5
     :         2*t79*t81-1.007976583728064d-1*t166*t167*t79*t81-2.419143
     ;         800947354d-1*t104*t110*t79*t81-1.0004780296492877d-1*t161
     <         *t52*t81/t44**4+4.445872822950419d-1*t129*t158*t81-5.4215
     =         98446633554d-7*t161*t52/(t44**8*t80**3)+1.670598608157995
     >         d-2*t115*t37*t39*t50*t76*t78+2.5058979122369923d-2*t139*t
     ?         37*t39*t50*t78+2.784331013596658d-3*t168*t38*t50*t78-8.35
     @         2993040789973d-3*t167*t38*t50*t78+5.011795824473985d-2*t1
     1         40*t37*t39*t50*t76-3.34119721631599d-2*t115*t34*t36*t50*t
     2         73*t75-5.011795824473985d-2*t135*t34*t36*t50*t75-5.568662
     3         027193316d-3*t168*t35*t50*t75+1.6705986081579946d-2*t167*
     4         t35*t50*t75-1.002359164894797d-1*t136*t34*t36*t50*t73+1.4
     5         00557038530531d-3*t142*t144*t38*t52*t53-2.326835539872518
     6         5d-3*t141*t143*t35*t52*t53-2.5218302197571857d-1*t130*t16
     7         1*t52/t45**6+4.7062486515309376d-4*t127*t161*t52/t44**6+1
     8         .670598608157995d-2*t115*t140*t38*t50-3.34119721631599d-2
     9         *t115*t136*t35*t50+4.802734052773798d-1*t130*t131*t158-8.
     :         962879611183625d-4*t127*t128*t158
            t193 = t63**3
            t194 = 1/t18**3
            t195 = -1.0298058196603158d+0*t164*t52+t171-3.86177182372618
     1         33d-1*t166*t167-9.26825237694284d-1*t104*t110
            fnc(iq) = 1.0d+0*rhoa*t49*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t99*wght+1.0d+0*t49*wght+Amat(i
     1         q,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*t99*wght+1.0d+0*rhoa*t157*wght+A
     1         mat2(iq,D2_RA_RA)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*rhoa*(-3.5089341735807855d+0*
     1         t71*t72*t89*t98-1.7544670867903928d+0*t145*t24*t72*t98+1.
     2         7544670867903928d+0*t156*t48*t98+3.5089341735807855d+0*t1
     3         00*t101*t24*t98+5.848223622634643d-1*t24*t48*(1.0d+0*(3.6
     4         490335179177674d-4*t123*t25*t27*t96*t97+1.916042591006509
     5         3d-4*t125*t25*t27*t52*t53*t90*t97-6.386808636688365d-5*t1
     6         06*t125*t26*t52*t97+3.7727995569144196d-5*t104*t180*t26*t
     7         97-4.790106477516273d-5*t110*t111*t125*t26*t97+7.29806703
     8         5835535d-4*t126*t25*t27*t90*t96+3.6490335179177674d-4*t18
     9         5*t26*t96+1.0655830899009261d-2*t164*t52*t93*t95+3.995936
     :         587128472d-3*t166*t167*t93*t95+9.590247809108335d-3*t104*
     ;         t110*t93*t95+3.9662099574848336d-3*t161*t179*t52*t95-1.76
     <         24839864078184d-2*t120*t158*t95+1.8147659200319294d-2*t11
     =         5*t25*t27*t50*t90*t92+2.722148880047894d-2*t123*t25*t27*t
     >         50*t92+3.024609866719882d-3*t168*t26*t50*t92-9.0738296001
     ?         59644d-3*t167*t26*t50*t92+5.444297760095788d-2*t124*t25*t
     @         27*t50*t90+1.9160425910065093d-4*t125*t126*t26*t52*t53-4.
     1         1445148651319325d-1*t118*t161*t178*t52+1.0606128115063691
     2         d+1*t161*t176*t177*t52+2.722148880047894d-2*t184*t26*t50+
     3         1.8147659200319294d-2*t115*t124*t26*t50+1.709920934161365
     4         d+0*t192+7.89307801891314d-1*t118*t119*t158)-3.6490335179
     5         177674d-4*t123*t25*t27*t96*t97-1.9160425910065093d-4*t125
     6         *t25*t27*t52*t53*t90*t97+6.386808636688365d-5*t106*t125*t
     7         26*t52*t97-3.7727995569144196d-5*t104*t180*t26*t97+4.7901
     8         06477516273d-5*t110*t111*t125*t26*t97-7.298067035835535d-
     9         4*t126*t25*t27*t90*t96-3.6490335179177674d-4*t185*t26*t96
     :         -1.0655830899009261d-2*t164*t52*t93*t95-3.995936587128472
     ;         d-3*t166*t167*t93*t95-9.590247809108335d-3*t104*t110*t93*
     <         t95-3.9662099574848336d-3*t161*t179*t52*t95+1.76248398640
     =         78184d-2*t120*t158*t95-1.8147659200319294d-2*t115*t25*t27
     >         *t50*t90*t92-2.722148880047894d-2*t123*t25*t27*t50*t92-3.
     ?         024609866719882d-3*t168*t26*t50*t92+9.073829600159644d-3*
     @         t167*t26*t50*t92-5.444297760095788d-2*t124*t25*t27*t50*t9
     1         0-1.9160425910065093d-4*t125*t126*t26*t52*t53+4.144514865
     2         1319325d-1*t118*t161*t178*t52-1.0606128115063691d+1*t161*
     3         t176*t177*t52-2.722148880047894d-2*t184*t26*t50-1.8147659
     4         200319294d-2*t115*t124*t26*t50-7.89307801891314d-1*t118*t
     5         119*t158)+5.848223622634643d-1*t47*t48*(2.505897912236992
     6         3d-2*t19*t50*(-6.203504908994001d-1*t195*t20*t64*t9+3.722
     7         1029453964005d+0*t151*t152*t20*t63*t9-3.7221029453964005d
     8         +0*t193*t194*t20*t9-8.271339878658668d-1*t113*t20*t50*t63
     9         *t64+6.203504908994001d-1*t152*t20*t50*t56*t64-1.24070098
     :         17988002d+0*t150*t151*t20*t50*t56-6.433264350067852d-1*t1
     ;         73*t20*t50)-9.690227711544375d-4*t112*t6*t61*t62*t8-5.088
     <         166200913744d-4*t116*t52*t53*t54*t6*t62*t8-1.938045542308
     =         875d-3*t117*t54*t6*t61*t8-3.34119721631599d-2*t115*t50*t5
     >         4*t57*t6*t8-5.011795824473985d-2*t112*t50*t57*t6*t8-1.002
     ?         359164894797d-1*t114*t50*t54*t6*t8+2.2478670955426108d-3*
     @         t152*t18*t20*t69*t70+1.1803150266592868d-3*t154*t18*t20*t
     1         52*t53*t63*t70-3.934383422197623d-4*t106*t154*t19*t52*t70
     2         +2.3241090936607786d-4*t104*t19*t70/t21**4-2.950787566648
     3         2175d-4*t110*t111*t154*t19*t70+1.696055400304582d-4*t106*
     4         t116*t52*t62*t7-1.0018895862972538d-4*t104*t165*t62*t7+1.
     5         272041550228436d-4*t110*t111*t116*t62*t7-9.69022771154437
     6         5d-4*t175*t61*t7-5.568662027193316d-3*t168*t50*t57*t7+1.6
     7         705986081579946d-2*t167*t50*t57*t7-5.088166200913744d-4*t
     8         116*t117*t52*t53*t7-5.011795824473985d-2*t174*t50*t7-3.34
     9         119721631599d-2*t114*t115*t50*t7+2.2478670955426108d-3*t1
     :         9*(-5.250822119331622d-1*t106*t20*t21*t52*t63*t64-3.93811
     ;         65894987163d-1*t110*t111*t20*t21*t63*t64-1.03391748483233
     <         35d-1*t104*t20*t63*t64+7.876233178997433d-1*t152*t20*t21*
     =         t52*t53*t64-1.0d+0*t195*t20*t22*t64+6.0d+0*t151*t152*t20*
     >         t22*t63-1.5752466357994865d+0*t150*t151*t20*t21*t52*t53-2
     ?         .917123399628679d-1*t164*t20*t21*t52-6.0d+0*t193*t194*t20
     @         *t22-1.0939212748607545d-1*t166*t167*t20*t21-2.6254110596
     1         65811d-1*t104*t110*t20*t21-1.2062370656377223d-1*t158*t20
     2         )*t69+4.4957341910852217d-3*t155*t18*t20*t63*t69+7.244178
     3         432040066d-2*t164*t52*t66*t68+2.716566912015024d-2*t166*t
     4         167*t66*t68+6.51976058883606d-2*t104*t110*t66*t68+2.69635
     5         778788734d-2*t161*t52*t68/t23**4-1.1981936089412427d-1*t1
     6         49*t158*t68+1.8009481522035156d+1*t161*t52/(t23**8*t67**3
     7         )+1.670598608157995d-2*t115*t18*t20*t50*t63*t65+2.5058979
     8         122369923d-2*t152*t18*t20*t50*t65+2.784331013596658d-3*t1
     9         68*t19*t50*t65-8.352993040789973d-3*t167*t19*t50*t65+5.01
     :         1795824473985d-2*t153*t18*t20*t50*t63-6.96009523273821d-2
     ;         *t164*t52*t58*t60-2.610035712276828d-2*t166*t167*t58*t60-
     <         6.26408570946439d-2*t104*t110*t58*t60-2.590619096601433d-
     =         2*t161*t163*t52*t60+1.1512059930225654d-1*t105*t158*t60+1
     >         .1803150266592868d-3*t154*t155*t19*t52*t53-1.408143068645
     ?         6894d+0*t147*t161*t52/t23**6+2.2877665475865033d+0*t102*t
     @         161*t162*t52-4.947718859586276d+1*t159*t160*t161*t52+1.67
     1         0598608157995d-2*t115*t153*t19*t50+2.681757326079316d+0*t
     2         147*t148*t158-4.356968291048705d+0*t102*t103*t158)-3.5089
     3         341735807855d+0*t24*t47*t89**3/t46**4-1.7544670867903928d
     4         +0*t156*t47*t72*t89-1.7544670867903928d+0*t146*t24*t72*t8
     5         9+3.5089341735807855d+0*t100*t145*t24*t47*t89+9.690227711
     6         544375d-4*t112*t6*t61*t62*t8+5.088166200913744d-4*t116*t5
     7         2*t53*t54*t6*t62*t8+1.938045542308875d-3*t117*t54*t6*t61*
     8         t8+3.34119721631599d-2*t115*t50*t54*t57*t6*t8+5.011795824
     9         473985d-2*t112*t50*t57*t6*t8+1.002359164894797d-1*t114*t5
     :         0*t54*t6*t8-1.7544670867903928d+0*t145*t47*t71*t72-5.8482
     ;         23622634643d-1*t192*t24*t47*t72+1.7544670867903928d+0*t14
     <         6*t48*t71+3.5089341735807855d+0*t100*t101*t47*t71-1.69605
     =         5400304582d-4*t106*t116*t52*t62*t7+1.0018895862972538d-4*
     >         t104*t165*t62*t7-1.272041550228436d-4*t110*t111*t116*t62*
     ?         t7+9.690227711544375d-4*t175*t61*t7+5.568662027193316d-3*
     @         t168*t50*t57*t7-1.6705986081579946d-2*t167*t50*t57*t7+5.0
     1         88166200913744d-4*t116*t117*t52*t53*t7+5.011795824473985d
     2         -2*t174*t50*t7+3.34119721631599d-2*t114*t115*t50*t7+6.960
     3         09523273821d-2*t164*t52*t58*t60+2.610035712276828d-2*t166
     4         *t167*t58*t60+6.26408570946439d-2*t104*t110*t58*t60+2.590
     5         619096601433d-2*t161*t163*t52*t60-1.1512059930225654d-1*t
     6         105*t158*t60-2.2877665475865033d+0*t102*t161*t162*t52+4.9
     7         47718859586276d+1*t159*t160*t161*t52+4.356968291048705d+0
     8         *t102*t103*t158)*wght+3.0d+0*t157*wght+Amat3(iq,D3_RA_RA_
     9         RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = t11+3.25d-1
            t22 = t21**2
            t23 = t15+7.06042d+0
            t24 = 1.554535d-2*log(6.203504908994001d-1*t20*t9)+5.2491393
     1         16978092d-2*atan(4.7309269095601136d+0/t23)+2.24786709554
     2         26108d-3*log(1.0d+0*t20*t22)-3.8783294878113006d-2*t17-9.
     3         690227711544375d-4*t14-3.10907d-2*t10
            t25 = t5+8.414573716781907d-1*t3+1.14813d+1
            t26 = abs(t25)
            t27 = 1/t26
            t28 = log(6.203504908994001d-1*t27*t9)
            t29 = t11+2.28344d-1
            t30 = t29**2
            t31 = log(1.0d+0*t27*t30)
            t32 = t15+1.0683499999999999d+0
            t33 = atan(6.692072046645942d+0/t32)
            t34 = t5+1.0295812011585444d+1*t3+4.2719799999999997d+1
            t35 = abs(t34)
            t36 = 1/t35
            t37 = t5+1.5849422788428325d+1*t3+1.01578d+2
            t38 = abs(t37)
            t39 = 1/t38
            t40 = t11+4.09286d-1
            t41 = t40**2
            t42 = t11+7.43294d-1
            t43 = t42**2
            t44 = t15+1.3072d+1
            t45 = t15+2.0123100000000002d+1
            t46 = 1.554535d-2*log(6.203504908994001d-1*t39*t9)-3.10907d-
     1         2*log(6.203504908994001d-1*t36*t9)+6.188180297906176d-1*a
     2         tan(1.171685277708971d+0/t45)-2.052197293770518d+1*atan(4
     3         .4899888641576796d-2/t44)+2.667310007273315d-3*log(1.0d+0
     4         *t39*t43)-4.431373767749538d-3*log(1.0d+0*t36*t41)
            t47 = 1.0d+0*(1.709920934161365d+0*t46+5.458482358638966d-3*
     1         t33+3.6490335179177674d-4*t31+1.688686394038963d-2*t28)-5
     2         .458482358638966d-3*t33-3.6490335179177674d-4*t31-1.68868
     3         6394038963d-2*t28
            t48 = 1/t46
            t49 = 5.848223622634643d-1*t24*t47*t48+3.8783294878113006d-2
     1         *t17+9.690227711544375d-4*t14+3.10907d-2*t10
            t50 = 1/t9
            t51 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t52 = 1/t2**3
            t53 = 1/rhob**6.666666666666667d-1
            t54 = t51-4.8930311001203647d-1*t52*t53
            t55 = 1/t6
            t56 = 1/rhob**1.6666666666666666d+0
            t57 = -6.203504908994001d-1*t54*t55*t8*t9-2.067834969664667d
     1         -1*t50*t56*t8
            t58 = 1/t16**2
            t59 = 3.784699104639999d+1*t58+1
            t60 = 1/t59
            t61 = 1/t13
            t62 = -1.0d+0*t13*t54*t55*t8-2.625411059665811d-1*t12*t52*t5
     1         3*t8
            t63 = t51-9.26825237694284d-1*t52*t53
            t64 = 1/t18
            t65 = -6.203504908994001d-1*t20*t63*t64*t9-2.067834969664667
     1         d-1*t20*t50*t56
            t66 = 1/t23**2
            t67 = 2.238166942360001d+1*t66+1
            t68 = 1/t67
            t69 = 1/t22
            t70 = -1.0d+0*t20*t22*t63*t64-2.625411059665811d-1*t20*t21*t
     1         52*t53
            t71 = 2.2478670955426108d-3*t19*t69*t70-9.690227711544375d-4
     1         *t61*t62*t7-5.011795824473985d-2*t50*t57*t7+6.51976058883
     2         6059d-2*t52*t53*t66*t68+2.5058979122369923d-2*t19*t50*t65
     3         -6.264085709464389d-2*t52*t53*t58*t60
            t72 = 1/t46**2
            t73 = t51-1.715968668597574d+0*t52*t53
            t74 = 1/t34
            t75 = -6.203504908994001d-1*t36*t73*t74*t9-2.067834969664667
     1         d-1*t36*t50*t56
            t76 = t51-2.641570464738054d+0*t52*t53
            t77 = 1/t37
            t78 = -6.203504908994001d-1*t39*t76*t77*t9-2.067834969664667
     1         d-1*t39*t50*t56
            t79 = 1/t44**2
            t80 = 2.016000000025997d-3*t79+1
            t81 = 1/t80
            t82 = 1/t45**2
            t83 = 1.3728463899999485d+0*t82+1
            t84 = 1/t83
            t85 = 1/t41
            t86 = -1.0d+0*t36*t41*t73*t74-2.625411059665811d-1*t36*t40*t
     1         52*t53
            t87 = 1/t43
            t88 = -1.0d+0*t39*t43*t76*t77-2.625411059665811d-1*t39*t42*t
     1         52*t53
            t89 = 2.667310007273315d-3*t38*t87*t88-4.431373767749538d-3*
     1         t35*t85*t86+1.9035804775132142d-1*t52*t53*t82*t84-2.41914
     2         38009473537d-1*t52*t53*t79*t81+2.5058979122369923d-2*t38*
     3         t50*t78-5.011795824473985d-2*t35*t50*t75
            t90 = t51-1.4024289527969844d-1*t52*t53
            t91 = 1/t25
            t92 = -6.203504908994001d-1*t27*t9*t90*t91-2.067834969664667
     1         d-1*t27*t50*t56
            t93 = 1/t32**2
            t94 = 4.4783828277500004d+1*t93+1
            t95 = 1/t94
            t96 = 1/t30
            t97 = -1.0d+0*t27*t30*t90*t91-2.625411059665811d-1*t27*t29*t
     1         52*t53
            t98 = 1.0d+0*(3.6490335179177674d-4*t26*t96*t97+9.5902478091
     1         08334d-3*t52*t53*t93*t95+2.722148880047894d-2*t26*t50*t92
     2         +1.709920934161365d+0*t89)-3.6490335179177674d-4*t26*t96*
     3         t97-9.590247809108334d-3*t52*t53*t93*t95-2.72214888004789
     4         4d-2*t26*t50*t92
            t99 = 5.848223622634643d-1*t24*t48*t98-5.848223622634643d-1*
     1         t24*t47*t72*t89+5.848223622634643d-1*t47*t48*t71+9.690227
     2         711544375d-4*t61*t62*t7+5.011795824473985d-2*t50*t57*t7+6
     3         .264085709464389d-2*t52*t53*t58*t60
            t100 = 1/t46**3
            t101 = t89**2
            t102 = 1/t59**2
            t103 = 1/t16**5
            t104 = 1/rhob**2.3333333333333334d+0
            t105 = 1/t16**3
            t106 = 1/rhob**1.6666666666666669d+0
            t107 = t54**2
            t108 = 1/t6**2
            t109 = 2.7571132928862224d-1/rhob**2.333333333333333d+0
            t110 = 1/t2**5
            t111 = 1/rhob**1.3333333333333336d+0
            t112 = 3.262020733413577d-1*t106*t52+2.4465155500601823d-1*t
     1         110*t111+t109
            t113 = 1/rhob**2.6666666666666666d+0
            t114 = -6.203504908994001d-1*t112*t55*t8*t9+1.24070098179880
     1         02d+0*t107*t108*t8*t9+4.135669939329334d-1*t50*t54*t55*t5
     2         6*t8+2.7571132928862224d-1*t113*t50*t8
            t115 = 1/rhob**9.999999999999999d-1
            t116 = 1/t12**3
            t117 = 5.250822119331622d-1*t12*t52*t53*t54*t55*t8-1.0d+0*t1
     1         12*t13*t55*t8+1.7502740397772074d-1*t106*t12*t52*t8+2.0d+
     2         0*t107*t108*t13*t8+1.3127055298329054d-1*t110*t111*t12*t8
     3         +3.446391616107778d-2*t104*t8
            t118 = 1/t94**2
            t119 = 1/t32**5
            t120 = 1/t32**3
            t121 = t90**2
            t122 = 1/t25**2
            t123 = 9.349526351979897d-2*t106*t52+7.012144763984922d-2*t1
     1         10*t111+t109
            t124 = 4.135669939329334d-1*t27*t50*t56*t90*t91-6.2035049089
     1         94001d-1*t123*t27*t9*t91+1.2407009817988002d+0*t121*t122*
     2         t27*t9+2.7571132928862224d-1*t113*t27*t50
            t125 = 1/t29**3
            t126 = 5.250822119331622d-1*t27*t29*t52*t53*t90*t91-1.0d+0*t
     1         123*t27*t30*t91+1.7502740397772074d-1*t106*t27*t29*t52+2.
     2         0d+0*t121*t122*t27*t30+1.3127055298329054d-1*t110*t111*t2
     3         7*t29+3.446391616107778d-2*t104*t27
            t127 = 1/t80**2
            t128 = 1/t44**5
            t129 = 1/t44**3
            t130 = 1/t83**2
            t131 = 1/t45**5
            t132 = 1/t45**3
            t133 = t73**2
            t134 = 1/t34**2
            t135 = 1.1439791123983827d+0*t106*t52+8.57984334298787d-1*t1
     1         10*t111+t109
            t136 = -6.203504908994001d-1*t135*t36*t74*t9+1.2407009817988
     1         002d+0*t133*t134*t36*t9+4.135669939329334d-1*t36*t50*t56*
     2         t73*t74+2.7571132928862224d-1*t113*t36*t50
            t137 = t76**2
            t138 = 1/t37**2
            t139 = 1.761046976492036d+0*t106*t52+1.320785232369027d+0*t1
     1         10*t111+t109
            t140 = -6.203504908994001d-1*t139*t39*t77*t9+1.2407009817988
     1         002d+0*t137*t138*t39*t9+4.135669939329334d-1*t39*t50*t56*
     2         t76*t77+2.7571132928862224d-1*t113*t39*t50
            t141 = 1/t40**3
            t142 = 1/t42**3
            t143 = 5.250822119331622d-1*t36*t40*t52*t53*t73*t74-1.0d+0*t
     1         135*t36*t41*t74+1.7502740397772074d-1*t106*t36*t40*t52+2.
     2         0d+0*t133*t134*t36*t41+1.3127055298329054d-1*t110*t111*t3
     3         6*t40+3.446391616107778d-2*t104*t36
            t144 = 5.250822119331622d-1*t39*t42*t52*t53*t76*t77-1.0d+0*t
     1         139*t39*t43*t77+1.7502740397772074d-1*t106*t39*t42*t52+2.
     2         0d+0*t137*t138*t39*t43+1.3127055298329054d-1*t110*t111*t3
     3         9*t42+3.446391616107778d-2*t104*t39
            t145 = 2.667310007273315d-3*t37*t39*t76*t87*t88+7.0027851926
     1         52656d-4*t142*t38*t52*t53*t88+2.667310007273315d-3*t144*t
     2         38*t87-4.431373767749538d-3*t34*t36*t73*t85*t86-1.1634177
     3         699362593d-3*t141*t35*t52*t53*t86-4.431373767749538d-3*t1
     4         43*t35*t85-1.2690536516754763d-1*t106*t52*t82*t84-9.51790
     5         2387566071d-2*t110*t111*t82*t84+9.995362477254237d-2*t104
     6         *t132*t84+1.6127625339649027d-1*t106*t52*t79*t81+1.209571
     7         9004736769d-1*t110*t111*t79*t81-1.270249377985834d-1*t104
     8         *t129*t81+2.5058979122369923d-2*t37*t39*t50*t76*t78+8.352
     9         993040789976d-3*t115*t38*t50*t78-5.011795824473985d-2*t34
     :         *t36*t50*t73*t75-1.670598608157995d-2*t115*t35*t50*t75+2.
     ;         5058979122369923d-2*t140*t38*t50-5.011795824473985d-2*t13
     <         6*t35*t50-1.372209729363942d-1*t104*t130*t131+2.560822746
     =         052464d-4*t104*t127*t128
            t146 = 1.0d+0*(3.6490335179177674d-4*t25*t27*t90*t96*t97+9.5
     1         80212955032547d-5*t125*t26*t52*t53*t97+3.6490335179177674
     2         d-4*t126*t26*t96-6.393498539405557d-3*t106*t52*t93*t95-4.
     3         795123904554167d-3*t110*t111*t93*t95+5.035668532593766d-3
     4         *t104*t120*t95+2.722148880047894d-2*t25*t27*t50*t90*t92+9
     5         .073829600159646d-3*t115*t26*t50*t92+2.722148880047894d-2
     6         *t124*t26*t50+1.709920934161365d+0*t145-2.255165148260897
     7         d-1*t104*t118*t119)-3.6490335179177674d-4*t25*t27*t90*t96
     8         *t97-9.580212955032547d-5*t125*t26*t52*t53*t97-3.64903351
     9         79177674d-4*t126*t26*t96+6.393498539405557d-3*t106*t52*t9
     :         3*t95+4.795123904554167d-3*t110*t111*t93*t95-5.0356685325
     ;         93766d-3*t104*t120*t95-2.722148880047894d-2*t25*t27*t50*t
     <         90*t92-9.073829600159646d-3*t115*t26*t50*t92-2.7221488800
     =         47894d-2*t124*t26*t50+2.255165148260897d-1*t104*t118*t119
            t147 = 1/t67**2
            t148 = 1/t23**5
            t149 = 1/t23**3
            t150 = t63**2
            t151 = 1/t18**2
            t152 = 6.178834917961894d-1*t106*t52+4.63412618847142d-1*t11
     1         0*t111+t109
            t153 = -6.203504908994001d-1*t152*t20*t64*t9+1.2407009817988
     1         002d+0*t150*t151*t20*t9+4.135669939329334d-1*t20*t50*t56*
     2         t63*t64+2.7571132928862224d-1*t113*t20*t50
            t154 = 1/t21**3
            t155 = 5.250822119331622d-1*t20*t21*t52*t53*t63*t64-1.0d+0*t
     1         152*t20*t22*t64+1.7502740397772074d-1*t106*t20*t21*t52+2.
     2         0d+0*t150*t151*t20*t22+1.3127055298329054d-1*t110*t111*t2
     3         0*t21+3.446391616107778d-2*t104*t20
            t156 = -9.690227711544375d-4*t54*t6*t61*t62*t8-5.01179582447
     1         3985d-2*t50*t54*t57*t6*t8+2.2478670955426108d-3*t18*t20*t
     2         63*t69*t70+5.901575133296435d-4*t154*t19*t52*t53*t70-2.54
     3         4083100456872d-4*t116*t52*t53*t62*t7-9.690227711544375d-4
     4         *t117*t61*t7-1.670598608157995d-2*t115*t50*t57*t7-5.01179
     5         5824473985d-2*t114*t50*t7+2.2478670955426108d-3*t155*t19*
     6         t69-4.3465070592240396d-2*t106*t52*t66*t68-3.259880294418
     7         0294d-2*t110*t111*t66*t68+3.4234103112606934d-2*t104*t149
     8         *t68+2.5058979122369923d-2*t18*t20*t50*t63*t65+8.35299304
     9         0789976d-3*t115*t19*t50*t65+4.176057139642926d-2*t106*t52
     :         *t58*t60+3.1320428547321943d-2*t110*t111*t58*t60-3.289159
     ;         980064472d-2*t104*t105*t60+2.5058979122369923d-2*t153*t19
     <         *t50-7.662163788798045d-1*t104*t147*t148+1.24484808315677
     =         28d+0*t102*t103*t104
            t157 = -1.1696447245269286d+0*t24*t72*t89*t98+1.169644724526
     1         9286d+0*t48*t71*t98-1.1696447245269286d+0*t47*t71*t72*t89
     2         +9.690227711544375d-4*t54*t6*t61*t62*t8+5.011795824473985
     3         d-2*t50*t54*t57*t6*t8-5.848223622634643d-1*t145*t24*t47*t
     4         72+2.544083100456872d-4*t116*t52*t53*t62*t7+9.69022771154
     5         4375d-4*t117*t61*t7+1.670598608157995d-2*t115*t50*t57*t7+
     6         5.011795824473985d-2*t114*t50*t7-4.176057139642926d-2*t10
     7         6*t52*t58*t60-3.1320428547321943d-2*t110*t111*t58*t60+3.2
     8         89159980064472d-2*t104*t105*t60+5.848223622634643d-1*t156
     9         *t47*t48+5.848223622634643d-1*t146*t24*t48+1.169644724526
     :         9286d+0*t100*t101*t24*t47-1.2448480831567728d+0*t102*t103
     ;         *t104
            t158 = 1/rhob**3.3333333333333337d+0
            t159 = 1/t59**3
            t160 = 1/t16**8
            t161 = 1/rhob**3.0d+0
            t162 = 1/t16**6
            t163 = 1/t16**4
            t164 = 1/rhob**2.666666666666667d+0
            t165 = 1/t12**4
            t166 = 1/t2**7
            t167 = 1/rhob**2.0d+0
            t168 = 1/rhob**1.9999999999999998d+0
            t169 = t54**3
            t170 = 1/t6**3
            t171 = -6.433264350067851d-1/rhob**3.333333333333333d+0
            t172 = -5.436701222355962d-1*t164*t52+t171-2.038762958383485
     1         1d-1*t166*t167-4.893031100120365d-1*t104*t110
            t173 = 1/rhob**3.6666666666666664d+0
            t174 = -6.203504908994001d-1*t172*t55*t8*t9+3.72210294539640
     1         05d+0*t108*t112*t54*t8*t9-3.7221029453964005d+0*t169*t170
     2         *t8*t9+6.203504908994001d-1*t112*t50*t55*t56*t8-1.2407009
     3         817988002d+0*t107*t108*t50*t56*t8-8.271339878658668d-1*t1
     4         13*t50*t54*t55*t8-6.433264350067852d-1*t173*t50*t8
            t175 = -5.250822119331622d-1*t106*t12*t52*t54*t55*t8-3.93811
     1         65894987163d-1*t110*t111*t12*t54*t55*t8-1.033917484832333
     2         5d-1*t104*t54*t55*t8+7.876233178997433d-1*t112*t12*t52*t5
     3         3*t55*t8-1.0d+0*t13*t172*t55*t8+6.0d+0*t108*t112*t13*t54*
     4         t8-1.5752466357994865d+0*t107*t108*t12*t52*t53*t8-2.91712
     5         3399628679d-1*t12*t164*t52*t8-6.0d+0*t13*t169*t170*t8-1.0
     6         939212748607545d-1*t12*t166*t167*t8-1.2062370656377223d-1
     7         *t158*t8-2.625411059665811d-1*t104*t110*t12*t8
            t176 = 1/t94**3
            t177 = 1/t32**8
            t178 = 1/t32**6
            t179 = 1/t32**4
            t180 = 1/t29**4
            t181 = t90**3
            t182 = 1/t25**3
            t183 = -1.5582543919966493d-1*t164*t52+t171-5.84345396998743
     1         4d-2*t166*t167-1.4024289527969844d-1*t104*t110
            t184 = -8.271339878658668d-1*t113*t27*t50*t90*t91-6.20350490
     1         8994001d-1*t183*t27*t9*t91+6.203504908994001d-1*t123*t27*
     2         t50*t56*t91+3.7221029453964005d+0*t122*t123*t27*t9*t90-3.
     3         7221029453964005d+0*t181*t182*t27*t9-1.2407009817988002d+
     4         0*t121*t122*t27*t50*t56-6.433264350067852d-1*t173*t27*t50
            t185 = -5.250822119331622d-1*t106*t27*t29*t52*t90*t91-3.9381
     1         165894987163d-1*t110*t111*t27*t29*t90*t91-1.0339174848323
     2         335d-1*t104*t27*t90*t91+7.876233178997433d-1*t123*t27*t29
     3         *t52*t53*t91-1.0d+0*t183*t27*t30*t91+6.0d+0*t122*t123*t27
     4         *t30*t90-1.5752466357994865d+0*t121*t122*t27*t29*t52*t53-
     5         2.917123399628679d-1*t164*t27*t29*t52-6.0d+0*t181*t182*t2
     6         7*t30-1.0939212748607545d-1*t166*t167*t27*t29-2.625411059
     7         665811d-1*t104*t110*t27*t29-1.2062370656377223d-1*t158*t2
     8         7
            t186 = t73**3
            t187 = 1/t34**3
            t188 = -1.9066318539973046d+0*t164*t52+t171-7.14986945248989
     1         1d-1*t166*t167-1.715968668597574d+0*t104*t110
            t189 = t76**3
            t190 = 1/t37**3
            t191 = -2.9350782941533937d+0*t164*t52+t171-1.10065436030752
     1         25d+0*t166*t167-2.6415704647380545d+0*t104*t110
            t192 = 2.5058979122369923d-2*t38*t50*(-6.203504908994001d-1*
     1         t191*t39*t77*t9+3.7221029453964005d+0*t138*t139*t39*t76*t
     2         9-3.7221029453964005d+0*t189*t190*t39*t9-8.27133987865866
     3         8d-1*t113*t39*t50*t76*t77+6.203504908994001d-1*t139*t39*t
     4         50*t56*t77-1.2407009817988002d+0*t137*t138*t39*t50*t56-6.
     5         433264350067852d-1*t173*t39*t50)-5.011795824473985d-2*t35
     6         *t50*(-6.203504908994001d-1*t188*t36*t74*t9+3.72210294539
     7         64005d+0*t134*t135*t36*t73*t9-3.7221029453964005d+0*t186*
     8         t187*t36*t9-8.271339878658668d-1*t113*t36*t50*t73*t74+6.2
     9         03504908994001d-1*t135*t36*t50*t56*t74-1.2407009817988002
     :         d+0*t133*t134*t36*t50*t56-6.433264350067852d-1*t173*t36*t
     ;         50)+2.667310007273315d-3*t139*t37*t39*t87*t88+1.400557038
     <         530531d-3*t142*t37*t39*t52*t53*t76*t88-4.668523461768438d
     =         -4*t106*t142*t38*t52*t88+2.757778453988139d-4*t104*t38*t8
     >         8/t42**4-3.501392596326328d-4*t110*t111*t142*t38*t88+2.66
     ?         7310007273315d-3*t38*(-5.250822119331622d-1*t106*t39*t42*
     @         t52*t76*t77-3.9381165894987163d-1*t110*t111*t39*t42*t76*t
     1         77-1.0339174848323335d-1*t104*t39*t76*t77+7.8762331789974
     2         33d-1*t139*t39*t42*t52*t53*t77-1.0d+0*t191*t39*t43*t77+6.
     3         0d+0*t138*t139*t39*t43*t76-1.5752466357994865d+0*t137*t13
     4         8*t39*t42*t52*t53-2.917123399628679d-1*t164*t39*t42*t52-6
     5         .0d+0*t189*t190*t39*t43-1.0939212748607545d-1*t166*t167*t
     6         39*t42-2.625411059665811d-1*t104*t110*t39*t42-1.206237065
     7         6377223d-1*t158*t39)*t87+5.33462001454663d-3*t144*t37*t39
     8         *t76*t87-4.431373767749538d-3*t135*t34*t36*t85*t86-2.3268
     9         355398725185d-3*t141*t34*t36*t52*t53*t73*t86+7.7561184662
     :         41728d-4*t106*t141*t35*t52*t86-4.5816748203035834d-4*t104
     ;         *t35*t86/t40**4+5.817088849681296d-4*t110*t111*t141*t35*t
     <         86-4.431373767749538d-3*t35*(-5.250822119331622d-1*t106*t
     =         36*t40*t52*t73*t74-3.9381165894987163d-1*t110*t111*t36*t4
     >         0*t73*t74-1.0339174848323335d-1*t104*t36*t73*t74+7.876233
     ?         178997433d-1*t135*t36*t40*t52*t53*t74-1.0d+0*t188*t36*t41
     @         *t74+6.0d+0*t134*t135*t36*t41*t73-1.5752466357994865d+0*t
     1         133*t134*t36*t40*t52*t53-2.917123399628679d-1*t164*t36*t4
     2         0*t52-6.0d+0*t186*t187*t36*t41-1.0939212748607545d-1*t166
     3         *t167*t36*t40-2.625411059665811d-1*t104*t110*t36*t40-1.20
     4         62370656377223d-1*t158*t36)*t85-8.862747535499076d-3*t143
     5         *t34*t36*t73*t85+2.1150894194591274d-1*t164*t52*t82*t84+7
     6         .931585322971725d-2*t166*t167*t82*t84+1.9035804775132145d
     7         -1*t104*t110*t82*t84+7.872580557945579d-2*t161*t52*t84/t4
     8         5**4-3.498376867038983d-1*t132*t158*t84+1.97833457907796d
     9         -1*t161*t52/(t45**8*t83**3)-2.6879375566081715d-1*t164*t5
     :         2*t79*t81-1.007976583728064d-1*t166*t167*t79*t81-2.419143
     ;         800947354d-1*t104*t110*t79*t81-1.0004780296492877d-1*t161
     <         *t52*t81/t44**4+4.445872822950419d-1*t129*t158*t81-5.4215
     =         98446633554d-7*t161*t52/(t44**8*t80**3)+1.670598608157995
     >         d-2*t115*t37*t39*t50*t76*t78+2.5058979122369923d-2*t139*t
     ?         37*t39*t50*t78+2.784331013596658d-3*t168*t38*t50*t78-8.35
     @         2993040789973d-3*t167*t38*t50*t78+5.011795824473985d-2*t1
     1         40*t37*t39*t50*t76-3.34119721631599d-2*t115*t34*t36*t50*t
     2         73*t75-5.011795824473985d-2*t135*t34*t36*t50*t75-5.568662
     3         027193316d-3*t168*t35*t50*t75+1.6705986081579946d-2*t167*
     4         t35*t50*t75-1.002359164894797d-1*t136*t34*t36*t50*t73+1.4
     5         00557038530531d-3*t142*t144*t38*t52*t53-2.326835539872518
     6         5d-3*t141*t143*t35*t52*t53-2.5218302197571857d-1*t130*t16
     7         1*t52/t45**6+4.7062486515309376d-4*t127*t161*t52/t44**6+1
     8         .670598608157995d-2*t115*t140*t38*t50-3.34119721631599d-2
     9         *t115*t136*t35*t50+4.802734052773798d-1*t130*t131*t158-8.
     :         962879611183625d-4*t127*t128*t158
            t193 = t63**3
            t194 = 1/t18**3
            t195 = -1.0298058196603158d+0*t164*t52+t171-3.86177182372618
     1         33d-1*t166*t167-9.26825237694284d-1*t104*t110
            fnc(iq) = 1.0d+0*rhob*t49*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t99*wght+1.0d+0*t49*wght+Amat(i
     1         q,D1_RB)
            Amat2(iq,D2_RB_RB) = 2.0d+0*t99*wght+1.0d+0*rhob*t157*wght+A
     1         mat2(iq,D2_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*rhob*(-3.5089341735807855d+0*
     1         t71*t72*t89*t98-1.7544670867903928d+0*t145*t24*t72*t98+1.
     2         7544670867903928d+0*t156*t48*t98+3.5089341735807855d+0*t1
     3         00*t101*t24*t98+5.848223622634643d-1*t24*t48*(1.0d+0*(3.6
     4         490335179177674d-4*t123*t25*t27*t96*t97+1.916042591006509
     5         3d-4*t125*t25*t27*t52*t53*t90*t97-6.386808636688365d-5*t1
     6         06*t125*t26*t52*t97+3.7727995569144196d-5*t104*t180*t26*t
     7         97-4.790106477516273d-5*t110*t111*t125*t26*t97+7.29806703
     8         5835535d-4*t126*t25*t27*t90*t96+3.6490335179177674d-4*t18
     9         5*t26*t96+1.0655830899009261d-2*t164*t52*t93*t95+3.995936
     :         587128472d-3*t166*t167*t93*t95+9.590247809108335d-3*t104*
     ;         t110*t93*t95+3.9662099574848336d-3*t161*t179*t52*t95-1.76
     <         24839864078184d-2*t120*t158*t95+1.8147659200319294d-2*t11
     =         5*t25*t27*t50*t90*t92+2.722148880047894d-2*t123*t25*t27*t
     >         50*t92+3.024609866719882d-3*t168*t26*t50*t92-9.0738296001
     ?         59644d-3*t167*t26*t50*t92+5.444297760095788d-2*t124*t25*t
     @         27*t50*t90+1.9160425910065093d-4*t125*t126*t26*t52*t53-4.
     1         1445148651319325d-1*t118*t161*t178*t52+1.0606128115063691
     2         d+1*t161*t176*t177*t52+2.722148880047894d-2*t184*t26*t50+
     3         1.8147659200319294d-2*t115*t124*t26*t50+1.709920934161365
     4         d+0*t192+7.89307801891314d-1*t118*t119*t158)-3.6490335179
     5         177674d-4*t123*t25*t27*t96*t97-1.9160425910065093d-4*t125
     6         *t25*t27*t52*t53*t90*t97+6.386808636688365d-5*t106*t125*t
     7         26*t52*t97-3.7727995569144196d-5*t104*t180*t26*t97+4.7901
     8         06477516273d-5*t110*t111*t125*t26*t97-7.298067035835535d-
     9         4*t126*t25*t27*t90*t96-3.6490335179177674d-4*t185*t26*t96
     :         -1.0655830899009261d-2*t164*t52*t93*t95-3.995936587128472
     ;         d-3*t166*t167*t93*t95-9.590247809108335d-3*t104*t110*t93*
     <         t95-3.9662099574848336d-3*t161*t179*t52*t95+1.76248398640
     =         78184d-2*t120*t158*t95-1.8147659200319294d-2*t115*t25*t27
     >         *t50*t90*t92-2.722148880047894d-2*t123*t25*t27*t50*t92-3.
     ?         024609866719882d-3*t168*t26*t50*t92+9.073829600159644d-3*
     @         t167*t26*t50*t92-5.444297760095788d-2*t124*t25*t27*t50*t9
     1         0-1.9160425910065093d-4*t125*t126*t26*t52*t53+4.144514865
     2         1319325d-1*t118*t161*t178*t52-1.0606128115063691d+1*t161*
     3         t176*t177*t52-2.722148880047894d-2*t184*t26*t50-1.8147659
     4         200319294d-2*t115*t124*t26*t50-7.89307801891314d-1*t118*t
     5         119*t158)+5.848223622634643d-1*t47*t48*(2.505897912236992
     6         3d-2*t19*t50*(-6.203504908994001d-1*t195*t20*t64*t9+3.722
     7         1029453964005d+0*t151*t152*t20*t63*t9-3.7221029453964005d
     8         +0*t193*t194*t20*t9-8.271339878658668d-1*t113*t20*t50*t63
     9         *t64+6.203504908994001d-1*t152*t20*t50*t56*t64-1.24070098
     :         17988002d+0*t150*t151*t20*t50*t56-6.433264350067852d-1*t1
     ;         73*t20*t50)-9.690227711544375d-4*t112*t6*t61*t62*t8-5.088
     <         166200913744d-4*t116*t52*t53*t54*t6*t62*t8-1.938045542308
     =         875d-3*t117*t54*t6*t61*t8-3.34119721631599d-2*t115*t50*t5
     >         4*t57*t6*t8-5.011795824473985d-2*t112*t50*t57*t6*t8-1.002
     ?         359164894797d-1*t114*t50*t54*t6*t8+2.2478670955426108d-3*
     @         t152*t18*t20*t69*t70+1.1803150266592868d-3*t154*t18*t20*t
     1         52*t53*t63*t70-3.934383422197623d-4*t106*t154*t19*t52*t70
     2         +2.3241090936607786d-4*t104*t19*t70/t21**4-2.950787566648
     3         2175d-4*t110*t111*t154*t19*t70+1.696055400304582d-4*t106*
     4         t116*t52*t62*t7-1.0018895862972538d-4*t104*t165*t62*t7+1.
     5         272041550228436d-4*t110*t111*t116*t62*t7-9.69022771154437
     6         5d-4*t175*t61*t7-5.568662027193316d-3*t168*t50*t57*t7+1.6
     7         705986081579946d-2*t167*t50*t57*t7-5.088166200913744d-4*t
     8         116*t117*t52*t53*t7-5.011795824473985d-2*t174*t50*t7-3.34
     9         119721631599d-2*t114*t115*t50*t7+2.2478670955426108d-3*t1
     :         9*(-5.250822119331622d-1*t106*t20*t21*t52*t63*t64-3.93811
     ;         65894987163d-1*t110*t111*t20*t21*t63*t64-1.03391748483233
     <         35d-1*t104*t20*t63*t64+7.876233178997433d-1*t152*t20*t21*
     =         t52*t53*t64-1.0d+0*t195*t20*t22*t64+6.0d+0*t151*t152*t20*
     >         t22*t63-1.5752466357994865d+0*t150*t151*t20*t21*t52*t53-2
     ?         .917123399628679d-1*t164*t20*t21*t52-6.0d+0*t193*t194*t20
     @         *t22-1.0939212748607545d-1*t166*t167*t20*t21-2.6254110596
     1         65811d-1*t104*t110*t20*t21-1.2062370656377223d-1*t158*t20
     2         )*t69+4.4957341910852217d-3*t155*t18*t20*t63*t69+7.244178
     3         432040066d-2*t164*t52*t66*t68+2.716566912015024d-2*t166*t
     4         167*t66*t68+6.51976058883606d-2*t104*t110*t66*t68+2.69635
     5         778788734d-2*t161*t52*t68/t23**4-1.1981936089412427d-1*t1
     6         49*t158*t68+1.8009481522035156d+1*t161*t52/(t23**8*t67**3
     7         )+1.670598608157995d-2*t115*t18*t20*t50*t63*t65+2.5058979
     8         122369923d-2*t152*t18*t20*t50*t65+2.784331013596658d-3*t1
     9         68*t19*t50*t65-8.352993040789973d-3*t167*t19*t50*t65+5.01
     :         1795824473985d-2*t153*t18*t20*t50*t63-6.96009523273821d-2
     ;         *t164*t52*t58*t60-2.610035712276828d-2*t166*t167*t58*t60-
     <         6.26408570946439d-2*t104*t110*t58*t60-2.590619096601433d-
     =         2*t161*t163*t52*t60+1.1512059930225654d-1*t105*t158*t60+1
     >         .1803150266592868d-3*t154*t155*t19*t52*t53-1.408143068645
     ?         6894d+0*t147*t161*t52/t23**6+2.2877665475865033d+0*t102*t
     @         161*t162*t52-4.947718859586276d+1*t159*t160*t161*t52+1.67
     1         0598608157995d-2*t115*t153*t19*t50+2.681757326079316d+0*t
     2         147*t148*t158-4.356968291048705d+0*t102*t103*t158)-3.5089
     3         341735807855d+0*t24*t47*t89**3/t46**4-1.7544670867903928d
     4         +0*t156*t47*t72*t89-1.7544670867903928d+0*t146*t24*t72*t8
     5         9+3.5089341735807855d+0*t100*t145*t24*t47*t89+9.690227711
     6         544375d-4*t112*t6*t61*t62*t8+5.088166200913744d-4*t116*t5
     7         2*t53*t54*t6*t62*t8+1.938045542308875d-3*t117*t54*t6*t61*
     8         t8+3.34119721631599d-2*t115*t50*t54*t57*t6*t8+5.011795824
     9         473985d-2*t112*t50*t57*t6*t8+1.002359164894797d-1*t114*t5
     :         0*t54*t6*t8-1.7544670867903928d+0*t145*t47*t71*t72-5.8482
     ;         23622634643d-1*t192*t24*t47*t72+1.7544670867903928d+0*t14
     <         6*t48*t71+3.5089341735807855d+0*t100*t101*t47*t71-1.69605
     =         5400304582d-4*t106*t116*t52*t62*t7+1.0018895862972538d-4*
     >         t104*t165*t62*t7-1.272041550228436d-4*t110*t111*t116*t62*
     ?         t7+9.690227711544375d-4*t175*t61*t7+5.568662027193316d-3*
     @         t168*t50*t57*t7-1.6705986081579946d-2*t167*t50*t57*t7+5.0
     1         88166200913744d-4*t116*t117*t52*t53*t7+5.011795824473985d
     2         -2*t174*t50*t7+3.34119721631599d-2*t114*t115*t50*t7+6.960
     3         09523273821d-2*t164*t52*t58*t60+2.610035712276828d-2*t166
     4         *t167*t58*t60+6.26408570946439d-2*t104*t110*t58*t60+2.590
     5         619096601433d-2*t161*t163*t52*t60-1.1512059930225654d-1*t
     6         105*t158*t60-2.2877665475865033d+0*t102*t161*t162*t52+4.9
     7         47718859586276d+1*t159*t160*t161*t52+4.356968291048705d+0
     8         *t102*t103*t158)*wght+3.0d+0*t157*wght+Amat3(iq,D3_RB_RB_
     9         RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
