/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.tools.publicdataviewer;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.tools.publicdataviewer.PublicDataProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DataOntology {
    protected static DataOntology p_singleton = null;
    protected static Document p_doc;

    protected DataOntology() {
        PublicDataProperties props = PublicDataProperties.getPublicDataProperties();
        String config_file = props.getProperty("OntologyFile");
        DataOntology.loadConfig(config_file);
    }

    protected DataOntology(String config_file) {
        if (config_file == "") {
            PublicDataProperties props = PublicDataProperties.getPublicDataProperties();
            config_file = props.getProperty("OntologyFile");
        }
        DataOntology.loadConfig(config_file);
    }

    protected static void loadConfig(String config_file) {
        try {
            DSI dsi = new DSI(config_file);
            String configString = dsi.getDataSetAsString();
            SAXBuilder builder = new SAXBuilder();
            p_doc = builder.build(new ByteArrayInputStream(configString.getBytes()));
        }
        catch (StatusException ex) {
            System.out.println("StatusException in DataOntology");
        }
        catch (JDOMException ex) {
            System.out.println("JDOMException in DataOntology");
        }
        catch (IOException ex) {
            System.out.println("IOException in DataOntology");
        }
    }

    public static Document getDocument() {
        if (p_singleton == null) {
            DataOntology.getDataOntology();
        }
        return p_doc;
    }

    public static Element getRoot() {
        return DataOntology.getDocument().getRootElement();
    }

    public static Element getEntry(String entry) {
        return DataOntology.getEntry(DataOntology.getRoot(), entry);
    }

    public static DataOntology getDataOntology() {
        PublicDataProperties props = PublicDataProperties.getPublicDataProperties();
        return DataOntology.getDataOntology(props.getProperty("OntologyFile"));
    }

    public static DataOntology getDataOntology(String config_file) {
        p_singleton = new DataOntology(config_file);
        return p_singleton;
    }

    protected static Element getEntry(Element parent, String entry) {
        for (Element node : parent.getChildren()) {
            Element ret;
            if (node.getName().equals("Entry")) {
                if (!node.getAttributeValue("name").equals(entry)) continue;
                return node;
            }
            if (!node.getName().equals("Category") || (ret = DataOntology.getEntry(node, entry)) == null) continue;
            return ret;
        }
        return null;
    }
}

