Minutes from 76th OpenVDB TSC meeting, Jan 19th, 2021, (EDT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B.

Additional Attendees: Johannes Meng (Intel), JT Nelson (Blender),
Andre Pradhana (DW), Richard Jones (DNeg), Bruce Chernaik (Intel),
Laura Lediaev

Regrets: *Peter* C.

Agenda:

1) Confirm Quorum
2) Secretary
3) AX
4) Andre joining TSC
5) Images
6) TAC Survey
7) VDB Activate SOP
8) CSG Intersection Bug
9) Inline Half
10) Next Meeting


1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Dan Bailey.

3) AX

Nick looking to get PR931 merged as soon as possible. This is the last piece
that requires maintaining a separate DNeg repo which is time-consuming.

Attributes to create needs fixing so that it includes pattern matching. Jeff
suggests looking into using UT_String::multimatch() for this.

Active tiles should be densified by default, as constant tiles should be
primarily considered a space-saving optimization and not affect which data gets
evaluated. Easiest solution is to globally densify and constify. Better approach
would be to stream - densify and constify each tile in turn as it's processed -
this is more challenging to implement but would likely reduce memory footprint.
Easiest solution is likely most appropriate here as additional optimization can
be performed later without changing behaviour.

Currently, a missing attribute errors on read. This is different to how VEX
works, which errors on write but not read.

There should not be a mode for running over inactive voxels. For now, acceptable
to include a compile guard to disable this option.

4) Andre joining TSC

Ken has reached out to Peter Cucka and Peter agrees to allowing Andre to replace
him on the TSC. Motion to make Peter an Emeritus TSC member, update the website,
remove him from GitHub OpenVDB group membership and as an OpenVDB code owner. 4
of 5 TSC members approve. Peter not present, but approved offline.

Andre Pradhana accepts the invitation to become a TSC member. Will follow up
with DWA leadership.

5) Images

ASWF has obtained a few more OpenVDB images from studios, still need more. Andre
believes DWA may be able to contribute some new images.

6) TAC Survey

Ken has requested an OpenVDB-specific survey to the TAC, as the most useful
questions appear late in the ASWF distributed survey.

7) VDB Activate SOP

Deactivation is a slow, single-threaded method. Jeff believes it may have
existed prior to tools::deactivate() but is in favour of switching it out.

8) CSG Intersection Bug

Jeff has reported a bug in the new CSG Intersection method and had to roll back
Houdini 18.5 to 7.1 as a result. Dan to investigate and look to release 7.2.2 /
8.0.1 with the bug addressed.

9) Inline Half

No objections regarding licensing from TAC.

Lots of questions regarding the correct level of integration of Half. It would
be preferrable to be able to swap out an embedded OpenVDB Half implementation
with the third-party library to easily test and adopt improvements, however this
is not trivial to achieve. Jeff's PR embeds Half in openvdb/math and uses an
openvdb::math namespace. This means we are essentially forking the
implementation for OpenVDB. Is this a problem? Not much has changed in Half in a
long time, though there are ongoing plans to update it. Not simply a matter of
changing the namespaces as we also wish to bake the auto-generated lookup table.
Half support is coming in C++23, but it will take a long time before we can
adopt that. Also, there is potential to switch to using Imath as a math library
in the future. Would this affect the decision here? Conversation ongoing on the
PR about the right approach to take here.

10) Next Meeting

Next meeting is Jan 26th, 2021. 12pm-1pm EST (GMT-5).
