"""Base

Revision ID: ade87195b0a0
Revises:
Create Date: 2020-08-15 20:12:26.768419

"""

import sqlalchemy as sa
from alembic import op

# pylint: skip-file

# revision identifiers, used by Alembic.
revision = "ade87195b0a0"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "pyfunceble_file",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=True),
        sa.Column("path", sa.Text(), nullable=False),
        sa.Column("test_completed", sa.Boolean(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("path"),
    )
    op.create_table(
        "pyfunceble_whois_record",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=True),
        sa.Column("subject", sa.Text(), nullable=False),
        sa.Column("expiration_date", sa.Text(), nullable=False),
        sa.Column("epoch", sa.Integer(), nullable=False),
        sa.Column("state", sa.String(length=80), nullable=False),
        sa.Column("record", sa.Text(), nullable=False),
        sa.Column("server", sa.Text(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("subject"),
    )
    op.create_table(
        "pyfunceble_status",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=True),
        sa.Column("file_id", sa.Integer(), nullable=False),
        sa.Column("tested", sa.Text(), nullable=False),
        sa.Column("_status", sa.Text(), nullable=True),
        sa.Column("status", sa.Text(), nullable=True),
        sa.Column("_status_source", sa.Text(), nullable=True),
        sa.Column("status_source", sa.Text(), nullable=True),
        sa.Column("domain_syntax_validation", sa.Boolean(), nullable=True),
        sa.Column("expiration_date", sa.Text(), nullable=True),
        sa.Column("http_status_code", sa.Integer(), nullable=True),
        sa.Column("ipv4_range_syntax_validation", sa.Boolean(), nullable=True),
        sa.Column("ipv4_syntax_validation", sa.Boolean(), nullable=True),
        sa.Column("ipv6_range_syntax_validation", sa.Boolean(), nullable=True),
        sa.Column("ipv6_syntax_validation", sa.Boolean(), nullable=True),
        sa.Column("subdomain_syntax_validation", sa.Boolean(), nullable=True),
        sa.Column("url_syntax_validation", sa.Boolean(), nullable=True),
        sa.Column("is_complement", sa.Boolean(), nullable=True),
        sa.Column("test_completed", sa.Boolean(), nullable=False),
        sa.Column("tested_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["file_id"], ["pyfunceble_file.id"], onupdate="CASCADE", ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("tested"),
    )
    op.create_table(
        "pyfunceble_mined",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=True),
        sa.Column("subject_id", sa.Integer(), nullable=False),
        sa.Column("file_id", sa.Integer(), nullable=False),
        sa.Column("mined", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["file_id"], ["pyfunceble_file.id"], onupdate="CASCADE", ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(
            ["subject_id"],
            ["pyfunceble_status.id"],
            onupdate="CASCADE",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("mined"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("pyfunceble_mined")
    op.drop_table("pyfunceble_status")
    op.drop_table("pyfunceble_whois_record")
    op.drop_table("pyfunceble_file")
    # ### end Alembic commands ###
